% Chad Myers
% EE 571
% File: runrbfem.m
% ---------------------------------
% The runrbfem funtion runs the pure RBF EM algorithm (contained in the em function)
% for three randomly generated clusters of points.  The three clusters are at the
% vertices of a triangle whose base is half the height.  The lower clusters
% have radii half that of the upper cluster.  The function takes as input
% the number of classes to assume when running the algorithm.

function runrbfem(j)

N=200;
x1=randn(N,1);
x2=randn(N,1)+1;
X1 = [x1 x2];
X2 = [(x1*0.5-2) (x2*0.5-8)];
X3 = [(x1*0.5+2) (x2*0.5-8)];
X = [X1;X2;X3];

[h, mu, sigmas, P] = em(j,X);


