
# delimit ;
clear;
cap log close;
*************************************************************;
* Replication program for Chapter 10 in SW3U;
*************************************************************;
log using ch10.log,replace;
set more 1;
***********************************;
* Read In Data; 
* (Note: Change path name so that it is appropriate for your computer);
use /Users/mwatson/Dropbox/TB/Supplements_3U/Web/Students/ReplicationFiles/Data/fatality.dta;
desc;
************************************************************;
* summary statistics;
summ year;
summ state;
************************************************************;
* Data transformations, create dummy variables, etc.
* year dummies;
gen y82=(year==1982);
gen y83=(year==1983);
gen y84=(year==1984);
gen y85=(year==1985);
gen y86=(year==1986);
gen y87=(year==1987);
gen y88=(year==1988);
gen da18=(mlda<19);                * minimum legal drinking age;
gen da19=(mlda>=19)*(mlda<20);
gen da20=(mlda>=20)*(mlda<21);
gen da21=(mlda>=21);
gen vfrall=10000*mrall;  *fatality rate per 10,000 in the population;
gen incperc=perinc/1000;
gen lincperc = ln(incperc);
gen vmilespd = vmiles/1000;
gen frmall = mrall/(vmiles/100000);
gen jailcom = ((jaild+comserd)>0);
gen mjailcom = (jaild==.)*(comserd==.);
mvdecode mjailcom,mv(1);
replace jailcom = jailcom + mjailcom;
**********************************************;
**** Equation 10.2 ;
**********************************************;
reg vfrall beertax if (year==1982), r;
 dis "Adjusted Rsquared = " _result(8);
**********************************************;
**** Equation 10.3 ;
**********************************************;
reg vfrall beertax if (year==1988), r;
 dis "Adjusted Rsquared = " _result(8);
**********************************************;
**** Equation 10.8 ;
**********************************************;
preserve;
gen dvfrall = vfrall-vfrall[_n-6];
gen dbtax = beertax-beertax[_n-6];
gen dbda18 = da18-da18[_n-6];
gen dbda19 = da19-da19[_n-6];
gen dbda20 = da20-da20[_n-6];
gen dbjailcom = jailcom-jailcom[_n-6];
gen dbvmilespd = vmilespd-vmilespd[_n-6];
gen dbunrate = unrate-unrate[_n-6];
gen dblincperc = lincperc-lincperc[_n-6];
keep if year==1988;
**** Equation 10.8 ;
reg dvfrall dbtax, r;
 dis "Adjusted Rsquared = " _result(8);
restore;
**********************************************;
**** Equation 10.15 ;
**********************************************;
xtset state year;
xtreg vfrall beertax, fe vce(cluster state);
**********************************************;
**** Equation 10.21 ;
**********************************************;
xtreg vfrall beertax y82 y83 y84 y85 y86 y87, fe vce(cluster state);
**********************************************;
**** Equation Table 10.1 ;
**********************************************;
**** col(1);
reg vfrall beertax, r;
 dis "Adjusted Rsquared = " _result(8);
**** col(2); 
xtreg vfrall beertax, fe vce(cluster state);
**** Col(3);
xtreg vfrall beertax y82 y83 y84 y85 y86 y87, fe vce(cluster state);
test y82 y83 y84 y85 y86 y87; 
**** Col(4);
xtreg vfrall beertax da18 da19 da20 jailcom vmilespd unrate lincperc y82 y83 y84 y85 y86 y87, fe vce(cluster state);
test y82 y83 y84 y85 y86 y87;
test da18 da19 da20;
test unrate lincperc;
**** Col(5);
xtreg vfrall beertax da18 da19 da20 jailcom vmilespd y82 y83 y84 y85 y86 y87, fe vce(cluster state);
test y82 y83 y84 y85 y86 y87;
test da18 da19 da20;
**** Col(6);
xtreg vfrall beertax mlda jailcom vmilespd unrate lincperc y82 y83 y84 y85 y86 y87, fe vce(cluster state);
test y82 y83 y84 y85 y86 y87;
test unrate lincperc;

keep if (year==1988) | (year==1982);
**** Col(7);
xtreg vfrall beertax da18 da19 da20 jailcom vmilespd unrate lincperc y82, fe vce(cluster state);
test y82;
test da18 da19 da20;
test unrate lincperc;

log close;
exit;
