# delimit ;
clear;
cap log close;
*************************************************************;
* Replication program for Chapter 13 in SW3U;
*************************************************************;
set memory 50000;
set matsize 150;
***********************************;
log using ch13.log,replace;
set more 1;
***********************************;
* Read In Data; 
* (Note: Change path name so that it is appropriate for your computer);
use /Users/mwatson/Dropbox/TB/Supplements_3U/Web/Students/ReplicationFiles/Data/star_sw.dta;
********************************************;
*;
desc;
*;
*************************************************************;
* The following command are not executed.  They are included to;
* document how the variables in STAR_SW were computed from ;
* WEBSTAR;
*************************************************************;
*gen tscorek = tmathssk+treadssk;
*gen tscore1 = tmathss1+treadss1;
*gen tscore2 = tmathss2+treadss2;
*gen tscore3 = tmathss3+treadss3;
*gen sck = cltypek==1 if cltypek<9;
*gen sc1 = cltype1==1 if cltype1<9;
*gen sc2 = cltype2==1 if cltype2<9;
*gen sc3 = cltype3==1 if cltype3<9;
*gen rak = cltypek==3 if cltypek<9;
*gen ra1 = cltype1==3 if cltype1<9;
*gen ra2 = cltype2==3 if cltype2<9;
*gen ra3 = cltype3==3 if cltype3<9;
*gen white = (srace==1) if srace<=6;
*gen black = (srace==2) if srace<=6;
*gen other = (srace>2) if srace<=6;
*gen boy = (ssex==1) if ssex<=2;
*gen freelunk = (sesk==1) if sesk<=2;
*gen freelun1 = (ses1==1) if ses1<=2;
*gen freelun2 = (ses2==1) if ses2<=2;
*gen freelun3 = (ses3==1) if ses3<=2;
*************************************************************;
* Table 13.1: differences estimators;
*----- summary for K -----;
preserve;
 keep if stark==1;
 summ tscorek sck rak;
 reg tscorek sck rak, r;
restore;
*----- summary for 1 -----;
preserve;
 keep if star1==1;
 summ tscore1 sc1 ra1;
 reg tscore1 sc1 ra1, r;
restore;
*----- summary for 2 -----;
preserve;
 keep if star2==1;
 summ tscore2 sc2 ra2;
 reg tscore2 sc2 ra2, r;
restore;
*----- summary for 3 -----;
preserve;
 keep if star3==1;
 summ tscore3 sc3 ra3;
 reg tscore3 sc3 ra3, r;
restore;
******************************************************;
* Table 13.2: differences estimators with X's for K;
preserve;
 keep if stark==1;
 reg tscorek sck rak, r;
 dis "Adjusted Rsquared = " _result(8);
 reg tscorek sck rak totexpk, r; 
 dis "Adjusted Rsquared = " _result(8);
 areg tscorek sck rak totexpk, r absorb(schidkn);
 areg tscorek sck rak totexpk boy freelunk black other, r absorb(schidkn);
restore;
******************************************************;

log close;

exit;
