# delimit ;
clear;
cap log close;
cap program drop _all;
log using ch15_3e.log,replace;
set more 1;
set matsize 60;
*************************************************************;
* ch15_3u.do            JS  9/19/01, updated 7/27/06;
*   STATA command file for ch15 in SW3U;
*   this file also applies to Ch 13 in 1e - no changes in text,
*   minor changes in the STATA code file;
*   executed in STATA 9.0 7/27/06;
*   Uses OJ.DTA;
************************************************************;
program define getdm;
 cap drop dm sedm; gen dm=0; gen sedm=0;
 quietly {;
  replace dm = _b[l0fdd] in 1/1;    replace sedm = _se[l0fdd] in 1/1;
  replace dm = _b[l1fdd] in 2/2;    replace sedm = _se[l1fdd] in 2/2;
  replace dm = _b[l2fdd] in 3/3;    replace sedm = _se[l2fdd] in 3/3;
  replace dm = _b[l3fdd] in 4/4;    replace sedm = _se[l3fdd] in 4/4;
  replace dm = _b[l4fdd] in 5/5;    replace sedm = _se[l4fdd] in 5/5;
  replace dm = _b[l5fdd] in 6/6;    replace sedm = _se[l5fdd] in 6/6;
  replace dm = _b[l6fdd] in 7/7;    replace sedm = _se[l6fdd] in 7/7;
  replace dm = _b[l7fdd] in 8/8;    replace sedm = _se[l7fdd] in 8/8;
  replace dm = _b[l8fdd] in 9/9;    replace sedm = _se[l8fdd] in 9/9;
  replace dm = _b[l9fdd] in 10/10;  replace sedm = _se[l9fdd] in 10/10;
  replace dm = _b[l10fdd] in 11/11; replace sedm = _se[l10fdd] in 11/11;
  replace dm = _b[l11fdd] in 12/12; replace sedm = _se[l11fdd] in 12/12;
  replace dm = _b[l12fdd] in 13/13; replace sedm = _se[l12fdd] in 13/13;
  replace dm = _b[l13fdd] in 14/14; replace sedm = _se[l13fdd] in 14/14;
  replace dm = _b[l14fdd] in 15/15; replace sedm = _se[l14fdd] in 15/15;
  replace dm = _b[l15fdd] in 16/16; replace sedm = _se[l15fdd] in 16/16;
  replace dm = _b[l16fdd] in 17/17; replace sedm = _se[l16fdd] in 17/17;
  replace dm = _b[l17fdd] in 18/18; replace sedm = _se[l17fdd] in 18/18;
  replace dm = _b[l18fdd] in 19/19; replace sedm = _se[l18fdd] in 19/19;
 };
 local i = 1;
  while `i'<=19 {;
   dis %8.2f dm[`i']; dis "(" %8.2f sedm[`i'] ")";
   local i = `i' + 1;
  };
end;
*;
program define getcdm;
 cap drop cdm secdm; gen cdm=0; gen secdm=0;
 quietly {;
  replace cdm = _b[dl0fdd] in 1/1;    replace secdm = _se[dl0fdd] in 1/1;
  replace cdm = _b[dl1fdd] in 2/2;    replace secdm = _se[dl1fdd] in 2/2;
  replace cdm = _b[dl2fdd] in 3/3;    replace secdm = _se[dl2fdd] in 3/3;
  replace cdm = _b[dl3fdd] in 4/4;    replace secdm = _se[dl3fdd] in 4/4;
  replace cdm = _b[dl4fdd] in 5/5;    replace secdm = _se[dl4fdd] in 5/5;
  replace cdm = _b[dl5fdd] in 6/6;    replace secdm = _se[dl5fdd] in 6/6;
  replace cdm = _b[dl6fdd] in 7/7;    replace secdm = _se[dl6fdd] in 7/7;
  replace cdm = _b[dl7fdd] in 8/8;    replace secdm = _se[dl7fdd] in 8/8;
  replace cdm = _b[dl8fdd] in 9/9;    replace secdm = _se[dl8fdd] in 9/9;
  replace cdm = _b[dl9fdd] in 10/10;  replace secdm = _se[dl9fdd] in 10/10;
  replace cdm = _b[dl10fdd] in 11/11; replace secdm = _se[dl10fdd] in 11/11;
  replace cdm = _b[dl11fdd] in 12/12; replace secdm = _se[dl11fdd] in 12/12;
  replace cdm = _b[dl12fdd] in 13/13; replace secdm = _se[dl12fdd] in 13/13;
  replace cdm = _b[dl13fdd] in 14/14; replace secdm = _se[dl13fdd] in 14/14;
  replace cdm = _b[dl14fdd] in 15/15; replace secdm = _se[dl14fdd] in 15/15;
  replace cdm = _b[dl15fdd] in 16/16; replace secdm = _se[dl15fdd] in 16/16;
  replace cdm = _b[dl16fdd] in 17/17; replace secdm = _se[dl16fdd] in 17/17;
  replace cdm = _b[dl17fdd] in 18/18; replace secdm = _se[dl17fdd] in 18/18;
  replace cdm = _b[l18fdd] in 19/19;  replace secdm = _se[l18fdd] in 19/19;
 };
 local i = 1;
  while `i'<=19 {;
   dis %8.2f cdm[`i']; dis "(" %8.2f secdm[`i'] ")";
   local i = `i' + 1;
  };
end;
*;
program define qlr6;
  cap drop qall; gen qall = .;
  local i = 25+93;
  sca qlrstat=0;
  while `i'<=(636-93) {;
    cap gen di = (_n > `i');
    cap gen l0fdd_d = di*l0fdd;

    cap gen l1fdd_d = di*l1fdd;

    cap gen l2fdd_d = di*l2fdd;

    cap gen l3fdd_d = di*l3fdd;

    cap gen l4fdd_d = di*l4fdd;

    cap gen l5fdd_d = di*l5fdd;

    cap gen l6fdd_d = di*l6fdd; 
    preserve;
     qui newey dlpoj $lfdd6
              di l0fdd_d l1fdd_d l2fdd_d l3fdd_d l4fdd_d l5fdd_d l6fdd_d 
                 if tin(1950m1,2000m12), lag(7);
    restore;
     qui test di l0fdd_d l1fdd_d l2fdd_d l3fdd_d l4fdd_d l5fdd_d l6fdd_d;
     sca chow = r(F);
     if chow>qlrstat {;
        sca qlrstat = chow; sca imax = `i';
        };
     cap replace qall = r(F) in `i';
     dis "`i'   " %tm time[`i'] "   " %8.2f chow;
     drop di l0fdd_d l1fdd_d l2fdd_d l3fdd_d l4fdd_d l5fdd_d l6fdd_d;
    local i = `i' + 1;
   };
   dis "QLR stat = " %9.3f qlrstat "   at obs# " %6.0f imax
       "    date: " %tm time[imax];
end;
*;
program define qlr18;
  cap drop qall; gen qall = .;
  local i = 25+93;
  sca qlrstat=0;
  while `i'<=(636-93) {;
    cap gen di = (_n > `i');
    cap gen l0fdd_d = di*l0fdd;

    cap gen l1fdd_d = di*l1fdd;

    cap gen l2fdd_d = di*l2fdd;

    cap gen l3fdd_d = di*l3fdd;

    cap gen l4fdd_d = di*l4fdd;

    cap gen l5fdd_d = di*l5fdd;

    cap gen l6fdd_d = di*l6fdd; 

    cap gen l7fdd_d = di*l7fdd; 

    cap gen l8fdd_d = di*l8fdd;

    cap gen l9fdd_d = di*l9fdd; 


    cap gen l10fdd_d = di*l10fdd; 

    cap gen l11fdd_d = di*l11fdd;

    cap gen l12fdd_d = di*l12fdd;

    cap gen l13fdd_d = di*l13fdd;

    cap gen l14fdd_d = di*l14fdd;

    cap gen l15fdd_d = di*l15fdd;

    cap gen l16fdd_d = di*l16fdd; 

    cap gen l17fdd_d = di*l17fdd; 

    cap gen l18fdd_d = di*l18fdd;

 

   preserve;
     qui newey dlpoj $dlfdd18
              di l0fdd_d l1fdd_d l2fdd_d l3fdd_d l4fdd_d l5fdd_d l6fdd_d 
              l7fdd_d l8fdd_d l9fdd_d l10fdd_d l11fdd_d l12fdd_d 
              l13fdd_d l14fdd_d l15fdd_d l16fdd_d l17fdd_d l18fdd_d
                 if tin(1950m1,2000m12), lag(7);
    restore;
     qui test di l0fdd_d l1fdd_d l2fdd_d l3fdd_d l4fdd_d l5fdd_d l6fdd_d 
              l7fdd_d l8fdd_d l9fdd_d l10fdd_d l11fdd_d l12fdd_d 
              l13fdd_d l14fdd_d l15fdd_d l16fdd_d l17fdd_d l18fdd_d;
     sca chow = r(F);
     if chow>qlrstat {;
        sca qlrstat = chow; sca imax = `i';
        };
     cap replace qall = r(F) in `i';
     dis "`i'   " %tm time[`i'] "   " %8.2f chow;
     drop di l0fdd_d l1fdd_d l2fdd_d l3fdd_d l4fdd_d l5fdd_d l6fdd_d 
                 l7fdd_d l8fdd_d l9fdd_d l10fdd_d l11fdd_d l12fdd_d 
                 l13fdd_d l14fdd_d l15fdd_d l16fdd_d l17fdd_d l18fdd_d;
    local i = `i' + 1;
   };
   dis "QLR stat = " %9.3f qlrstat "   at obs# " %6.0f imax
       "    date: " %tm time[imax];
end;
*************************;
* Read In Data; 
* (Note: Change path name so that it is appropriate for your computer);
use /Users/mwatson/Dropbox/TB/Supplements_3U/Web/Students/ReplicationFiles/Data/oj.dta;
drop day01 - day31;
desc;
tsset time;
*************************;
* transformations;
*************************;
gen poj = ppioj/pwf;
gen lpoj = log(poj);
gen dlpoj = 100*D.lpoj;
gen nfd = temp1;
gen fdd = temp4;
list time fdd poj pwf;
gen l0fdd = L0.fdd; gen l1fdd = L1.fdd; gen l2fdd = L2.fdd;
gen l3fdd = L3.fdd; gen l4fdd = L4.fdd; gen l5fdd = L5.fdd;
gen l6fdd = L6.fdd; gen l7fdd = L7.fdd; gen l8fdd = L8.fdd;
gen l9fdd = L9.fdd; gen l10fdd = L10.fdd; gen l11fdd = L11.fdd;
gen l12fdd = L12.fdd; gen l13fdd = L13.fdd; gen l14fdd = L14.fdd;
gen l15fdd = L15.fdd; gen l16fdd = L16.fdd; gen l17fdd = L17.fdd;
gen l18fdd = L18.fdd;
*;
gen dl0fdd  = D.l0fdd; gen dl1fdd  = D.l1fdd; gen dl2fdd  = D.l2fdd;
gen dl3fdd  = D.l3fdd; gen dl4fdd  = D.l4fdd; gen dl5fdd  = D.l5fdd;
gen dl6fdd  = D.l6fdd; gen dl7fdd  = D.l7fdd; gen dl8fdd  = D.l8fdd;
gen dl9fdd  = D.l9fdd; gen dl10fdd = D.l10fdd; gen dl11fdd = D.l11fdd;
gen dl12fdd = D.l12fdd; gen dl13fdd = D.l13fdd; gen dl14fdd = D.l14fdd;
gen dl15fdd = D.l15fdd; gen dl16fdd = D.l16fdd; gen dl17fdd = D.l17fdd;
gen dl18fdd = d.l18fdd;
*;
global lfdd6  "l0fdd l1fdd l2fdd l3fdd l4fdd l5fdd l6fdd";
global lfdd18 "l0fdd l1fdd l2fdd l3fdd l4fdd l5fdd l6fdd 
               l7fdd l8fdd l9fdd l10fdd l11fdd l12fdd 
               l13fdd l14fdd l15fdd l16fdd l17fdd l18fdd";
global dlfdd18 "dl0fdd dl1fdd dl2fdd dl3fdd dl4fdd dl5fdd dl6fdd 
                dl7fdd dl8fdd dl9fdd dl10fdd dl11fdd dl12fdd 
                dl13fdd dl14fdd dl15fdd dl16fdd dl17fdd l18fdd";
*;
gen l0nfd = L0.nfd; gen l1nfd = L1.nfd; gen l2nfd = L2.nfd;
gen l3nfd = L3.nfd; gen l4nfd = L4.nfd; gen l5nfd = L5.nfd;
gen l6nfd = L6.nfd; gen l7nfd = L7.nfd; gen l8nfd = L8.nfd;
gen l9nfd = L9.nfd; gen l10nfd = L10.nfd; gen l11nfd = L11.nfd;
gen l12nfd = L12.nfd; gen l13nfd = L13.nfd; gen l14nfd = L14.nfd;
gen l15nfd = L15.nfd; gen l16nfd = L16.nfd; gen l17nfd = L17.nfd;
gen l18nfd = L18.nfd;
global lnfd18 "l0nfd l1nfd l2nfd l3nfd l4nfd l5nfd l6nfd 
               l7nfd l8nfd l9nfd l10nfd l11nfd l12nfd 
               l13nfd l14nfd l15nfd l16nfd l17nfd l18nfd";
gen m1 = (month(dofm(time))==1); gen m2 = (month(dofm(time))==2);
gen m3 = (month(dofm(time))==3); gen m4 = (month(dofm(time))==4);
gen m5 = (month(dofm(time))==5); gen m6 = (month(dofm(time))==6);
gen m7 = (month(dofm(time))==7); gen m8 = (month(dofm(time))==8);
gen m9 = (month(dofm(time))==9); gen m10 = (month(dofm(time))==10);
gen m11 = (month(dofm(time))==11);
global seasons "m1 m2 m3 m4 m5 m6 m7 m8 m9 m10 m11";
*;
gen d74m1 = tin(1974m1,);
gen l0fdd_7 = d74m1*l0fdd; gen l1fdd_7 = d74m1*l1fdd;
gen l2fdd_7 = d74m1*l2fdd; gen l3fdd_7 = d74m1*l3fdd;
gen l4fdd_7 = d74m1*l4fdd; gen l5fdd_7 = d74m1*l5fdd;
gen l6fdd_7 = d74m1*l6fdd; gen l7fdd_7 = d74m1*l7fdd;
gen l8fdd_7 = d74m1*l8fdd; gen l9fdd_7 = d74m1*l9fdd;
gen l10fdd_7 = d74m1*l10fdd; gen l11fdd_7 = d74m1*l11fdd;
gen l12fdd_7 = d74m1*l12fdd; gen l13fdd_7 = d74m1*l13fdd;
gen l14fdd_7 = d74m1*l14fdd; gen l15fdd_7 = d74m1*l15fdd;
gen l16fdd_7 = d74m1*l16fdd; gen l17fdd_7 = d74m1*l17fdd;
gen l18fdd_7 = d74m1*l18fdd; 
global lfdd_74 "l0fdd_7 l1fdd_7 l2fdd_7 l3fdd_7 l4fdd_7 l5fdd_7 l6fdd_7 
                l7fdd_7 l8fdd_7 l9fdd_7 l10fdd_7 l11fdd_7 l12fdd_7 
                l13fdd_7 l14fdd_7 l15fdd_7 l16fdd_7 l17fdd_7 l18fdd_7";
*************************;
*  15.1: preliminary analysis;
*************************;
* figure 15.1 TS plots;
graph7 poj time if tin(1950m1,2000m12),
    xlab ylab s(.) c(l) saving(f15_2e_1a.gph,replace);
graph7 dlpoj time if tin(1950m1,2000m12),
    xlab ylab s(.) c(l) saving(f15_2e_1b.gph,replace);
graph7 fdd time if tin(1950m1,2000m12),
    xlab ylab s(.) c(l) saving(f15_2e_1c.gph,replace);
*  dlpoj on FDD(t-1);
preserve;
 newey dlpoj l0fdd if tin(1950m1,2000m12), lag(7);
restore;
*  dlpoj on FDD, six lags;
preserve;
 newey dlpoj $lfdd6 if tin(1950m1,2000m12), lag(7);
restore;
test l1fdd l2fdd l3fdd l4fdd l5fdd l6fdd;


*************************;
* 15.4: HAC SEs
*************************;
reg dlpoj l0fdd if tin(1950m1,2000m12), r;
predict ehat, resid;
su l0fdd if tin(1950m1,2000m12);
gen zhat = (l0fdd-r(mean))*ehat;
corrgram zhat if tin(1950m1,2000m12), noplot lags(12);
preserve;
 newey dlpoj l0fdd if tin(1950m1,2000m12), lag(7);
restore;

*************************;
* 15.6: More complete analysis of OJ data;
*************************;
* (0a) Base specification - dynamic multipliers;
preserve;
 newey dlpoj $lfdd18 if tin(1950m1,2000m12), lag(7);
restore;
getdm; gen dm_0 = dm; gen sedm_0 = sedm;
*;
* (0b) Base specification - cumulative dynamic multipliers;
preserve;
 newey dlpoj $dlfdd18 if tin(1950m1,2000m12), lag(7);
restore;
getcdm; gen cdm_0 = cdm; gen secdm_0 = secdm;
*;
* (1) include seasonals;
preserve;
 newey dlpoj $dlfdd18 $seasons if tin(1950m1,2000m12), lag(7);
restore;
test $seasons;
getcdm; gen cdm_1 = cdm; gen secdm_1 = secdm;
*;
* (2) Sensitivity of SEs to doubling NW lag window;
preserve;
 newey dlpoj $dlfdd18 if tin(1950m1,2000m12), lag(14);
restore;
getcdm; gen cdm_2 = cdm; gen secdm_2 = secdm;
*;
* (3) Different nonlinearity: #days < 32 degrees;
preserve;
 newey dlpoj $dlfdd18 $lnfd18 if tin(1950m1,2000m12), lag(7);
restore;
test $lnfd18;
getcdm; gen cdm_3 = cdm; gen secdm_3 = secdm;
*;
* (4) Break in 1974 from Orlando airport move?;
preserve;
 newey dlpoj $dlfdd18 d74m1 if tin(1950m1,2000m12), lag(7);
restore;
preserve;
 newey dlpoj $dlfdd18 d74m1 $lfdd_74 if tin(1950m1,2000m12), lag(7);
restore;
test d74m1 $lfdd_74;
test $lfdd_74;
*;
* (5) Test for break at unknown date;
qlr6;
qlr18;
*sca imax = 125;
*;
* (6) divide sample into three periods;
 preserve;
  newey dlpoj $dlfdd18 if tin(1950m1,1966m12), lag(4);
 restore;
 getcdm; gen cdm_6a = cdm; gen secdm_6a = secdm;
*;
 preserve;
  newey dlpoj $dlfdd18 if tin(1967m1,1983m12), lag(4);
 restore;
 getcdm; gen cdm_6b = cdm; gen secdm_6b = secdm;
*;
 preserve;
  newey dlpoj $dlfdd18 if tin(1984m1,2000m12), lag(4);
 restore;
 getcdm; gen cdm_6c = cdm; gen secdm_6c = secdm;

* Graph multipliers;
gen lagno=_n-1;
preserve; keep in 1/19;
 gen cilo_0=dm_0-1.96*sedm_0; gen ciup_0=dm_0+1.96*sedm_0;
 graph7 dm_0 cilo_0 ciup_0 lagno, xlab ylab s(...) c(lll)
   title(Figure 15.2a. Dynamic multipliers, base case)
   saving(f15_2e_2a.gph,replace);
*;
 gen ccilo_0=cdm_0-1.96*secdm_0; gen cciup_0=cdm_0+1.96*secdm_0;
 graph7 cdm_0 ccilo_0 cciup_0 lagno, xlab ylab s(...) c(lll)
   title(Figure 15.2b. Cumulative dynamic multipliers, base case)
   saving(f15_2e_2b.gph,replace);
*;
 graph7 cdm_6a cdm_6b cdm_6c lagno, xlab ylab s(...) c(lll)
   title(Figure 15.3.  Cumulative dynamic multipliers, three subsamples)
   saving(f15_2e_3.gph,replace);
*;
restore;
************************************************************;
log close;
clear;

