# delimit ;
clear;
log using ch2_bad_day_box.log,replace;
set more 1;
set matsize 60;
*************************************************************;
*   STATA command file for ch2 - Bad Day on Wall Street;
************************************************************;
use /Users/mwatson/Dropbox/TB/Supplements_3U/Web/Students/ReplicationFiles/Data/djia_daily.dta;
tsset date; sort date;
desc;
*************************;
* transformations;
*************************;
gen dpctchg = 100*(djia[_n]-djia[_n-1])/djia[_n-1];
*list date djia dpctchg;
************;
* tabulate extremes;
su dpctchg if tin(01jan1980,31dec1989);
su dpctchg if tin(01jan1980,31dec2012);
sca vv = r(Var);
sca ss = sqrt(vv);
sca mm = r(mean);
gen dpctchg_std = (dpctchg-mm)/ss;
gen pnorm = 2*normal(-abs(dpctchg_std));
gen pnorm_app = (2/sqrt(2*3.1416))*exp(-0.5*dpctchg_std*dpctchg_std-ln(abs(dpctchg_std)));
sort pnorm;
list date djia dpctchg dpctchg_std pnorm pnorm_app in 1/100;
preserve;
 format date %tdMonthDDCCYY;
 format dpctchg dpctchg_std %9.1f;
 format pnorm %9.1e;
 list date dpctchg dpctchg_std pnorm in 1/10, noobs;
restore;
sort date;
*************************;
format date %tdCCYY;
twoway tsline dpctchg if tin(01jan1980,31dec1989),
    ylabel(-25(5)10)
    tlabel(01jan1980 01jan1981 01jan1982 01jan1983 01jan1984 01jan1985 
           01jan1986 01jan1987 01jan1988 01jan1989 01jan1990)
    ytitle("Daily percent change") ttitle("Year")
    s(.) c(l) saving(f2_7.gph,replace);
************************************************************;
log close;
clear;
