#delimit ;
clear ;
*************************************************************;
* Replication program for Chapter 2 in SW3U;
* Summary Statistics Reported in The Distribution of Earnings in the United States in 2012;
*;
*************************************************************;
log using CPS_ch2.log,replace;
set more 1;
set memory 50000;
***********************************;
********************* Description of Variables *************;
**** a_age = age;
**** a_hga = education level ;
*     0  "Children";
*     31  "Less Than 1st Grade";
*     32  "1st,2nd,3rd,or 4th grade";
*     33  "5th Or 6th Grade";
*     34  "7th and 8th grade";
*     35  "9th Grade";
*     36  "10th Grade";
*     37  "11th Grade";
*     38  "12th Grade No Diploma";
*     39  "High school graduate-high school diploma";
*     40  "Some College But No Degree";
*     41  "Assc degree-occupation/vocation";
*     42  "Assc degree-academic program";
*     43  "Bachelor''s degree (BA,AB,BS)";
*     44  "Master''s degree (MA,MS,MENG,MED,MSW,MBA)";
*     45  "Professional school degree (MD,DDS,DVM,L";
*     46  "Doctorate degree (PHD,EDD)"  ;
*'     
**** a_sex = 1 male; 
*            2 female; 
******************* 2012 Data (from March 2013 CPS) **************** ;
use /Users/mwatson/Dropbox/TB/Supplements_3U/Web/Students/ReplicationFiles/Data/cps_ch2.dta;
desc;
*;
summarize ahe, detail;
summarize ahe if (a_sex==2)&(a_hga==39), detail;
summarize ahe if (a_sex==2)&(a_hga==43), detail;
summarize ahe if (a_sex==1)&(a_hga==39), detail;
summarize ahe if (a_sex==1)&(a_hga==43), detail;
log close;
clear;
exit;
