# delimit ;
clear;
cap log close;
*************************************************************;
*Replication program for Chapter 5 in SW3U;
*************************************************************;
log using ch5_EconomicValueBox.log,replace;
set more 1;
***********************************;
* Read In Data; 
* (Note: Change path name so that it is appropriate for your computer);
use /Users/mwatson/Dropbox/TB/Supplements_3U/Web/Students/ReplicationFiles/Data/ch5_cps_box.dta;
*;
*;
reg ahe yrseduc, robust;
predict t5;
predict u5, residual;
su u5 if yrseduc==10;
su u5 if yrseduc==12;
su u5 if yrseduc==16;
gr7 ahe t5 yrseduc if yrseduc<=18,
  s(Oi) c(.l) sort xlab ylab 
 l1(" ") l2("Average Hourly Earnings") b2("Years of Education")
 saving(figure53,replace);
*************************************************************;
keep yrseduc ahe t5 ;
outsheet using fig53_v1.csv,comma replace;

log close;
clear;
exit;
