# delimit ;
clear;
cap log close;
*************************************************************;
*Replication program for Chapter 4 in SW3U;
* Caschool.do;
* Prepare Final Data for Text book;
* California School District Data;
*************************************************************;
log using ch6_caschools.log,replace;
set more 1;
***********************************;
* Read In Data; 
* (Note: Change path name so that it is appropriate for your computer);
use /Users/mwatson/Dropbox/TB/Supplements_3U/Web/Students/ReplicationFiles/Data/caschool.dta;
*;
*;
* Decription of Data;
* dist_code -- district Code;
* Read_scr  -- avg Reading Score;
* Math_scr  -- avg Math Score;
* County   --  county;
* District -- District;
* gr_span -- grade span of district;
* enrl_tot -- total enrollment;
* teachers -- number of teachers;
* computer -- number of computers;
* testscr -- avg test score (= (read_scr+math_scr)/2 );
* comp_stu -- computers per student ( = computer/enrl_tot);
* expn_stu -- expentitures per student;
* str -- student teacher ration (teachers/enrl_tot);
* el_pct -- percent of English Learners;
* Meal_pct -- Percent qualifying for reduced-price lunch;
* calw_pct -- Percent qualifying for CalWorks;
* avginc -- district average income (in $1000's);

**************************************************************;
***** Table 6.1 ******
**************************************************************;
gen str_20 = (str<20);
gen ts_lostr = testscr if str_20==1;
gen ts_histr = testscr if str_20==0;
gen elq1 = (el_pct<1.9);
gen elq2 = (el_pct>=1.9)*(el_pct<8.8);
gen elq3 = (el_pct>=8.8)*(el_pct<23.0);
gen elq4 = (el_pct>=23.0);
ttest ts_lostr=ts_histr, unp une;
ttest ts_lostr=ts_histr if elq1==1, unp une;
ttest ts_lostr=ts_histr if elq2==1, unp une;
ttest ts_lostr=ts_histr if elq3==1, unp une;
ttest ts_lostr=ts_histr if elq4==1, unp une;
**************************************************************;
***** Eq 6.11 ******
**************************************************************;
reg testscr str, r;
**************************************************************;
***** Eq 6.12 ******
**************************************************************;
reg testscr str el_pct, r;
**************************************************************;
log close;
clear;
exit;
