# delimit ;
set more off;
set linesize 240;
clear all;
*************************************************************;
* Returns to Education Box in Chapter 8 of SW3U;
*************************************************************;
log using returns_to_education_box.log,replace;
***********************************;
* Read In Data; 
* (Note: Change path name so that it is appropriate for your computer);
use /Users/mwatson/Dropbox/TB/Supplements_3U/Web/Students/ReplicationFiles/Data/ch8_cps.dta;
*;
keep if (age >= 30) & (age <= 64);
desc;
summarize ahe;
summarize age;
summarize yrseduc;
*;
gen lahe = ln(ahe);
gen fem_yrse = female*yrseduc;
gen pexp = age - (yrseduc+6);
gen pexp_2 = pexp*pexp;
* Box in Chapter 8;
reg lahe yrseduc, robust;
dis "Adjusted Rsquared = " _result(8);
reg lahe female yrseduc, robust;
dis "Adjusted Rsquared = " _result(8);
reg lahe female yrseduc fem_yrse, robust;
dis "Adjusted Rsquared = " _result(8);
 test yrseduc fem_yrse;
reg lahe female yrseduc fem_yrse pexp pexp_2
        midwest south west, robust;
dis "Adjusted Rsquared = " _result(8);
 test yrseduc fem_yrse;
 test pexp pexp_2;
 
*************************************************************;
log close;
