import java.math.BigInteger;

/***
 * This class provides constants for use with the Diffie-Hellman algorithm. Namely, we provide a g and p value in the
 * form of BigIntegers to be used as your initial primes.
 */
public class DHConstants {
    private static final String gStr = "C";
    private static final String pStr = "0FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B"
            + "22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5C"
            + "B6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE65381FFFFFFFFFFFFFFFF";   // 1024 bits

    // These values are suitable for use in the Diffie-Hellman algorithm.
    public static final BigInteger g = new BigInteger(gStr, 16);
    public static final BigInteger p = new BigInteger(pStr, 16);

}