/*
 * Decompiled with CFR 0.152.
 */
import java.math.BigInteger;

public class KeyExchange {
    public static final int OUTPUT_SIZE_BYTES = 32;
    private static final BigInteger a = DHConstants.g;
    private static final BigInteger b = DHConstants.p;
    private static final BigInteger c = b.subtract(BigInteger.ONE);
    private BigInteger d;
    private BigInteger e;

    public KeyExchange(PRGen pRGen, boolean bl) {
        do {
            this.d = new BigInteger(b.bitLength() - 1, pRGen);
            this.e = a.modPow(this.d, b);
        } while (this.e.equals(BigInteger.ONE) || this.e.equals(c));
    }

    public byte[] prepareOutMessage() {
        return HW2Util.bigIntegerToBytes(this.e, (this.e.bitLength() - 1) / 8 + 1);
    }

    public byte[] processInMessage(byte[] object) {
        if (object == null) {
            throw new NullPointerException();
        }
        BigInteger bigInteger = HW2Util.bytesToBigInteger((byte[])object);
        object = bigInteger;
        if (bigInteger.compareTo(BigInteger.ONE) <= 0) {
            return null;
        }
        if (((BigInteger)object).compareTo(c) >= 0) {
            return null;
        }
        object = ((BigInteger)object).modPow(this.d, b);
        return HashFunction.computeHash(HW2Util.bigIntegerToBytes((BigInteger)object, (((BigInteger)object).bitLength() - 1) / 8 + 1));
    }
}

