/*
 * Decompiled with CFR 0.152.
 */
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.ShortBufferException;

public class PRF {
    public static final int KEY_SIZE_BYTES = 32;
    public static final int OUTPUT_SIZE_BYTES = 32;
    private Mac a;

    public PRF(byte[] object) {
        assert (((byte[])object).length == 32);
        try {
            this.a = Mac.getInstance("HmacSHA256");
            KeyGenerator keyGenerator = KeyGenerator.getInstance("HmacSHA256");
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            secureRandom.setSeed((byte[])object);
            keyGenerator.init(256, secureRandom);
            object = keyGenerator.generateKey();
            this.a.init((Key)object);
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            NoSuchAlgorithmException noSuchAlgorithmException2 = noSuchAlgorithmException;
            noSuchAlgorithmException.printStackTrace(System.err);
            return;
        }
        catch (InvalidKeyException invalidKeyException) {
            InvalidKeyException invalidKeyException2 = invalidKeyException;
            invalidKeyException.printStackTrace(System.err);
            return;
        }
    }

    public synchronized void update(byte[] byArray, int n, int n2) {
        this.a.update(byArray, n, n2);
    }

    public synchronized void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    public synchronized void eval(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        try {
            this.a.update(byArray, n, n2);
            this.a.doFinal(byArray2, n3);
            return;
        }
        catch (ShortBufferException shortBufferException) {
            throw new IndexOutOfBoundsException();
        }
    }

    public synchronized byte[] eval(byte[] byArray, int n, int n2) {
        try {
            byte[] byArray2 = new byte[32];
            this.eval(byArray, n, n2, byArray2, 0);
            return byArray2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new RuntimeException("Should never get here.");
        }
    }

    public byte[] eval(byte[] byArray) {
        return this.eval(byArray, 0, byArray.length);
    }
}

