/*
 * Decompiled with CFR 0.152.
 */
import java.math.BigInteger;

public class RSAKey {
    private BigInteger a;
    private BigInteger b;

    public RSAKey(BigInteger bigInteger, BigInteger bigInteger2) {
        this.a = bigInteger;
        this.b = bigInteger2;
    }

    public BigInteger getExponent() {
        return this.a;
    }

    public BigInteger getModulus() {
        return this.b;
    }

    public byte[] addPadding(byte[] byArray) {
        byte[] byArray2 = new byte[this.maxPlaintextLength() + 1];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byArray2[byArray.length] = -1;
        return byArray2;
    }

    public byte[] removePadding(byte[] byArray) {
        int n = 0;
        for (int i = byArray.length - 1; i >= 0; --i) {
            if (byArray[i] != -1) continue;
            n = i;
            break;
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    public byte[] encodeOaep(byte[] byArray, PRGen pRGen) {
        byte[] byArray2 = new byte[byArray.length + 16];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byArray = new byte[16];
        for (int i = 0; i < 16; ++i) {
            byArray[i] = (byte)pRGen.next(8);
        }
        byte[] byArray3 = new byte[32];
        System.arraycopy(byArray, 0, byArray3, 0, 16);
        pRGen = new PRGen(byArray3);
        byArray3 = new byte[byArray2.length];
        for (int i = 0; i < byArray3.length; ++i) {
            byArray3[i] = (byte)pRGen.next(8);
        }
        byte[] byArray4 = new byte[byArray2.length];
        for (int i = 0; i < byArray2.length; ++i) {
            byArray4[i] = (byte)(byArray2[i] ^ byArray3[i]);
        }
        byte[] byArray5 = HashFunction.computeHash(byArray4);
        byArray2 = new byte[16];
        for (int i = 0; i < 16; ++i) {
            byArray2[i] = (byte)(byArray[i] ^ byArray5[i]);
        }
        byte[] byArray6 = new byte[byArray4.length + 16];
        System.arraycopy(byArray4, 0, byArray6, 0, byArray4.length);
        System.arraycopy(byArray2, 0, byArray6, byArray4.length, 16);
        return byArray6;
    }

    public byte[] decodeOaep(byte[] object) {
        int n;
        byte[] byArray = new byte[this.maxPlaintextLength() + 16 + 1];
        System.arraycopy(object, 0, byArray, 0, byArray.length);
        byte[] byArray2 = new byte[16];
        System.arraycopy(object, byArray.length, byArray2, 0, 16);
        object = HashFunction.computeHash(byArray);
        byte[] byArray3 = new byte[16];
        for (int i = 0; i < 16; ++i) {
            byArray3[i] = (byte)(object[i] ^ byArray2[i]);
        }
        byte[] byArray4 = new byte[32];
        System.arraycopy(byArray3, 0, byArray4, 0, 16);
        object = new PRGen(byArray4);
        byArray2 = new byte[byArray.length];
        for (int i = 0; i < byArray2.length; ++i) {
            byArray2[i] = (byte)((PRGen)object).next(8);
        }
        byte[] byArray5 = new byte[byArray.length];
        for (n = 0; n < byArray.length; ++n) {
            byArray5[n] = (byte)(byArray2[n] ^ byArray[n]);
        }
        for (n = byArray5.length - 16; n < byArray5.length; ++n) {
            if (byArray5[n] == 0) continue;
            return null;
        }
        byte[] byArray6 = new byte[byArray5.length - 16];
        System.arraycopy(byArray5, 0, byArray6, 0, byArray6.length);
        return byArray6;
    }

    public int maxPlaintextLength() {
        int n = this.b.bitLength() - 128 - 128 - 8 - 1;
        return n / 8;
    }

    public byte[] encrypt(byte[] object, PRGen pRGen) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (((byte[])object).length > this.maxPlaintextLength()) {
            throw new IllegalArgumentException("Plaintext is too long to encrypt with this key.");
        }
        object = this.addPadding((byte[])object);
        object = this.encodeOaep((byte[])object, pRGen);
        BigInteger bigInteger = HW2Util.bytesToBigInteger(object);
        object = bigInteger;
        BigInteger bigInteger2 = bigInteger.modPow(this.a, this.b);
        object = bigInteger2;
        return HW2Util.bigIntegerToBytes(bigInteger2, (this.b.bitLength() - 1) / 8 + 1);
    }

    public byte[] decrypt(byte[] object) {
        if (object == null) {
            throw new NullPointerException();
        }
        BigInteger bigInteger = HW2Util.bytesToBigInteger(object);
        object = bigInteger;
        object = bigInteger.modPow(this.a, this.b);
        int n = this.maxPlaintextLength() + 16 + 16 + 1;
        object = HW2Util.bigIntegerToBytes((BigInteger)object, n);
        if ((object = this.decodeOaep((byte[])object)) == null) {
            return null;
        }
        object = this.removePadding((byte[])object);
        return object;
    }

    public byte[] sign(byte[] object, PRGen pRGen) {
        if (object == null) {
            throw new NullPointerException();
        }
        object = HashFunction.computeHash((byte[])object);
        BigInteger bigInteger = HW2Util.bytesToBigInteger((byte[])object);
        object = bigInteger;
        BigInteger bigInteger2 = bigInteger.modPow(this.a, this.b);
        object = bigInteger2;
        return HW2Util.bigIntegerToBytes(bigInteger2, (((BigInteger)object).bitLength() - 1) / 8 + 1);
    }

    public boolean verifySignature(byte[] object, byte[] object2) {
        if (object == null || object2 == null) {
            throw new NullPointerException();
        }
        BigInteger bigInteger = HW2Util.bytesToBigInteger((byte[])object2);
        object2 = bigInteger;
        object2 = bigInteger.modPow(this.a, this.b);
        object = HashFunction.computeHash(object);
        object = HW2Util.bytesToBigInteger(object);
        return ((BigInteger)object2).equals(object);
    }
}

