(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    350676,       6179]
NotebookOptionsPosition[    349377,       6134]
NotebookOutlinePosition[    349724,       6149]
CellTagsIndexPosition[    349681,       6146]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"prob", "[", 
    RowBox[{"n_", ",", "m_", ",", "a_", ",", "hh_", ",", "b_"}], "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"cv", "=", 
      RowBox[{
       RowBox[{"Quantile", "[", 
        RowBox[{
         RowBox[{"StudentTDistribution", "[", 
          RowBox[{
           RowBox[{"Min", "[", 
            RowBox[{"n", ",", "n"}], "]"}], "-", "1"}], "]"}], ",", "0.975"}],
         "]"}], "^", "2"}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"Lamrt", "=", 
      RowBox[{"DiagonalMatrix", "[", 
       RowBox[{"Join", "[", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{"1", ",", 
           RowBox[{"{", 
            RowBox[{"n", "/", "2"}], "}"}]}], "]"}], ",", 
         RowBox[{"Table", "[", 
          RowBox[{"hh", " ", ",", 
           RowBox[{"{", 
            RowBox[{"n", "/", "2"}], "}"}]}], "]"}], ",", 
         RowBox[{"Table", "[", 
          RowBox[{"a", ",", 
           RowBox[{"{", 
            RowBox[{"m", "/", "2"}], "}"}]}], "]"}], ",", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"a", " ", "hh"}], ",", 
           RowBox[{"{", 
            RowBox[{"m", "/", "2"}], "}"}]}], "]"}]}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"en", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", "1", "}"}], ",", 
        RowBox[{"{", "n", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Mn", "=", 
      RowBox[{
       RowBox[{"IdentityMatrix", "[", 
        RowBox[{"IntegerPart", "[", "n", "]"}], "]"}], "-", 
       RowBox[{
        RowBox[{"en", ".", 
         RowBox[{"Transpose", "[", "en", "]"}]}], "/", "n"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"em", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", "1", "}"}], ",", 
        RowBox[{"{", "m", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Mm", "=", 
      RowBox[{
       RowBox[{"IdentityMatrix", "[", 
        RowBox[{"IntegerPart", "[", "m", "]"}], "]"}], "-", 
       RowBox[{
        RowBox[{"em", ".", 
         RowBox[{"Transpose", "[", "em", "]"}]}], "/", "m"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"xx", "=", 
      RowBox[{"ArrayFlatten", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"en", ".", 
              RowBox[{"Transpose", "[", "en", "]"}]}], "/", 
             RowBox[{"n", "^", "2"}]}], "-", 
            RowBox[{"cv", " ", 
             RowBox[{"Mn", "/", 
              RowBox[{"(", 
               RowBox[{"n", 
                RowBox[{"(", 
                 RowBox[{"n", "-", "1"}], ")"}]}], ")"}]}]}]}], ",", 
           RowBox[{
            RowBox[{"en", ".", 
             RowBox[{"Transpose", "[", "em", "]"}]}], "/", 
            RowBox[{"(", 
             RowBox[{"n", " ", "m"}], ")"}]}]}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"em", ".", 
             RowBox[{"Transpose", "[", "en", "]"}]}], "/", 
            RowBox[{"(", 
             RowBox[{"n", " ", "m"}], ")"}]}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"em", ".", 
              RowBox[{"Transpose", "[", "em", "]"}]}], "/", 
             RowBox[{"m", "^", "2"}]}], "-", 
            RowBox[{"cv", " ", 
             RowBox[{"Mm", "/", 
              RowBox[{"(", 
               RowBox[{"m", 
                RowBox[{"(", 
                 RowBox[{"m", "-", "1"}], ")"}]}], ")"}]}]}]}]}], "}"}]}], 
        "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"g", ",", "P"}], "}"}], "=", 
      RowBox[{"Eigensystem", "[", 
       RowBox[{"Lamrt", ".", "xx", ".", "Lamrt"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"P", "=", 
      RowBox[{"Transpose", "[", "P", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"w", "=", 
      RowBox[{"b", " ", 
       RowBox[{
        RowBox[{"Transpose", "[", "P", "]"}], ".", 
        RowBox[{"Inverse", "[", "Lamrt", "]"}], ".", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"i", "<=", "n"}], ",", "1", ",", "0"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "1", ",", 
            RowBox[{"m", "+", "n"}]}], "}"}]}], "]"}]}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Phi", "[", "t_", "]"}], "=", 
      RowBox[{"Product", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Exp", "[", 
          RowBox[{"I", " ", 
           RowBox[{
            RowBox[{"w", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "^", "2"}], " ", 
           RowBox[{"g", "[", 
            RowBox[{"[", "i", "]"}], "]"}], 
           RowBox[{"t", "/", 
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{"2", " ", "I", " ", 
               RowBox[{"g", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "t"}]}], ")"}]}]}], "]"}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"2", " ", "I", " ", 
             RowBox[{"g", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "t"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "/", "2"}], ")"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", 
          RowBox[{"n", "+", "m"}]}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{".5", "+", 
      RowBox[{
       RowBox[{"1", "/", "Pi"}], " ", 
       RowBox[{"NIntegrate", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Im", "[", 
           RowBox[{"Phi", "[", "t", "]"}], "]"}], "/", "t"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]}]}]}], 
    ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"kv", "[", 
    RowBox[{"n_", ",", "m_", ",", "a_", ",", "hh_"}], "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Lamrt", "=", 
      RowBox[{"DiagonalMatrix", "[", 
       RowBox[{"Join", "[", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{"1", ",", 
           RowBox[{"{", 
            RowBox[{"n", "/", "2"}], "}"}]}], "]"}], ",", 
         RowBox[{"Table", "[", 
          RowBox[{"hh", " ", ",", 
           RowBox[{"{", 
            RowBox[{"n", "/", "2"}], "}"}]}], "]"}], ",", 
         RowBox[{"Table", "[", 
          RowBox[{"a", ",", 
           RowBox[{"{", 
            RowBox[{"m", "/", "2"}], "}"}]}], "]"}], ",", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"a", " ", "hh"}], ",", 
           RowBox[{"{", 
            RowBox[{"m", "/", "2"}], "}"}]}], "]"}]}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"en", "=", 
      RowBox[{"Table", "[", 
       RowBox[{"1", ",", 
        RowBox[{"{", "n", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"em", "=", 
      RowBox[{"Table", "[", 
       RowBox[{"1", ",", 
        RowBox[{"{", "m", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"xx", "=", 
      RowBox[{"Flatten", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"en", "/", "n"}], ",", 
         RowBox[{"em", "/", "m"}]}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(", 
      RowBox[{"xx", ".", "Lamrt", ".", "Lamrt", ".", "xx"}], ")"}]}], ")"}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"refpower", "[", "b_", "]"}], "=", 
   RowBox[{"1", "-", 
    RowBox[{"CDF", "[", 
     RowBox[{
      RowBox[{"NoncentralChiSquareDistribution", "[", 
       RowBox[{"1", ",", " ", 
        RowBox[{"b", "^", "2"}]}], "]"}], ",", 
      RowBox[{
       RowBox[{"Quantile", "[", 
        RowBox[{
         RowBox[{"NormalDistribution", "[", 
          RowBox[{"0", ",", "1"}], "]"}], ",", "0.975"}], "]"}], "^", "2"}]}],
      "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"probos", "[", 
    RowBox[{"n_", ",", "hh_", ",", "mu_"}], "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"cv", "=", 
      RowBox[{
       RowBox[{"Quantile", "[", 
        RowBox[{
         RowBox[{"StudentTDistribution", "[", 
          RowBox[{"n", "-", "1"}], "]"}], ",", "0.975"}], "]"}], "^", "2"}]}],
      ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Lamrt", "=", 
      RowBox[{"DiagonalMatrix", "[", 
       RowBox[{"Join", "[", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{"1", ",", 
           RowBox[{"{", 
            RowBox[{"n", "/", "2"}], "}"}]}], "]"}], ",", 
         RowBox[{"Table", "[", 
          RowBox[{"hh", " ", ",", 
           RowBox[{"{", 
            RowBox[{"n", "/", "2"}], "}"}]}], "]"}]}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"e", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", "1", "}"}], ",", 
        RowBox[{"{", "n", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Me", "=", 
      RowBox[{
       RowBox[{"IdentityMatrix", "[", 
        RowBox[{"IntegerPart", "[", "n", "]"}], "]"}], "-", 
       RowBox[{
        RowBox[{"e", ".", 
         RowBox[{"Transpose", "[", "e", "]"}]}], "/", "n"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"g", ",", "P"}], "}"}], "=", 
      RowBox[{"Eigensystem", "[", 
       RowBox[{"Lamrt", ".", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"e", ".", 
           RowBox[{"Transpose", "[", "e", "]"}]}], "-", 
          RowBox[{
           RowBox[{"n", "/", 
            RowBox[{"(", 
             RowBox[{"n", "-", "1"}], ")"}]}], "cv", " ", "Me"}]}], ")"}], 
        ".", "Lamrt"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"P", "=", 
      RowBox[{"Transpose", "[", "P", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"w", "=", 
      RowBox[{"mu", " ", 
       RowBox[{
        RowBox[{"Transpose", "[", "P", "]"}], ".", 
        RowBox[{"Inverse", "[", "Lamrt", "]"}], ".", "e"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Phi", "[", "t_", "]"}], "=", 
      RowBox[{
       RowBox[{"Product", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Exp", "[", 
           RowBox[{"I", " ", 
            RowBox[{
             RowBox[{"w", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "^", "2"}], " ", 
            RowBox[{"g", "[", 
             RowBox[{"[", "i", "]"}], "]"}], 
            RowBox[{"t", "/", 
             RowBox[{"(", 
              RowBox[{"1", "-", 
               RowBox[{"2", " ", "I", " ", 
                RowBox[{"g", "[", 
                 RowBox[{"[", "i", "]"}], "]"}], "t"}]}], ")"}]}]}], "]"}], 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"2", " ", "I", " ", 
              RowBox[{"g", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "t"}]}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "/", "2"}], ")"}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{".5", "+", 
      RowBox[{
       RowBox[{"1", "/", "Pi"}], " ", 
       RowBox[{"NIntegrate", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Im", "[", 
           RowBox[{"Phi", "[", "t", "]"}], "]"}], "/", "t"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]}]}]}], 
    ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"style", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Hue", "[", "1", "]"}], ",", 
       RowBox[{"Thickness", "[", "0.008", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Black", ",", 
       RowBox[{"AbsoluteDashing", "[", 
        RowBox[{"{", 
         RowBox[{".8", ",", "2.2"}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Black", ",", 
       RowBox[{"AbsoluteDashing", "[", 
        RowBox[{"{", 
         RowBox[{"6", ",", "3"}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", "Black", "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"pbp", "[", 
    RowBox[{"n_", ",", "m_", ",", "a_", ",", "hh_", ",", "b_"}], "]"}], ":=", 
   RowBox[{"prob", "[", 
    RowBox[{"n", ",", "m", ",", "a", ",", "hh", ",", 
     RowBox[{"b", " ", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"kv", "[", 
        RowBox[{"n", ",", "m", ",", "a", ",", "hh"}], "]"}], "]"}]}]}], 
    "]"}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mkplot1", ":=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"refpower", "[", "b", "]"}], ",", 
       RowBox[{"pbp", "[", 
        RowBox[{"4", ",", "4", ",", "a0", ",", "hh0", ",", "b"}], "]"}], ",", 
       RowBox[{"pbp", "[", 
        RowBox[{"8", ",", "8", ",", "a0", ",", "hh0", ",", "b"}], "]"}], ",", 
       RowBox[{"pbp", "[", 
        RowBox[{"16", ",", "16", ",", "a0", ",", "hh0", ",", "b"}], "]"}]}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "0", ",", "6"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1.05"}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "style"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mkplot2", ":=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"refpower", "[", "b", "]"}], ",", 
       RowBox[{"pbp", "[", 
        RowBox[{"4", ",", "8", ",", "a0", ",", "hh0", ",", "b"}], "]"}], ",", 
       RowBox[{"pbp", "[", 
        RowBox[{"4", ",", "16", ",", "a0", ",", "hh0", ",", "b"}], "]"}], ",", 
       RowBox[{"pbp", "[", 
        RowBox[{"8", ",", "16", ",", "a0", ",", "hh0", ",", "b"}], "]"}]}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "0", ",", "6"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1.05"}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "style"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a0", "=", "1"}], ";", 
  RowBox[{"hh0", "=", "1"}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.624789614374919*^9, 3.624789632907956*^9}, {
   3.624789703078656*^9, 3.6247897815642624`*^9}, {3.6247898417810345`*^9, 
   3.624789865056533*^9}, 3.6247899160399866`*^9, {3.6247899628571873`*^9, 
   3.624789964963214*^9}, {3.624790049829302*^9, 3.624790094055869*^9}, {
   3.6247901935237446`*^9, 3.6247902115575757`*^9}, {3.6247903603542833`*^9, 
   3.6247904026318254`*^9}, 3.6247904377525625`*^9, {3.6247904835574703`*^9, 
   3.6247905075817785`*^9}, 3.624790540997407*^9, {3.6247908067236147`*^9, 
   3.6247908069888177`*^9}, {3.6247908719188504`*^9, 3.624790888127458*^9}, 
   3.6247909251165323`*^9, {3.6247910886866293`*^9, 3.6247911270475216`*^9}, {
   3.6247911960940065`*^9, 3.6247912378879423`*^9}, {3.6247913595081015`*^9, 
   3.6247914460426016`*^9}, {3.624793514625181*^9, 3.6247935205688577`*^9}, {
   3.624793732735578*^9, 3.6247937747313166`*^9}, 3.62479393880162*^9, {
   3.6247942511382246`*^9, 3.6247942754589367`*^9}, 3.624794324912571*^9, {
   3.624794365114286*^9, 3.624794556423539*^9}, {3.6247947171242*^9, 
   3.6247947698216753`*^9}, {3.6247948315370665`*^9, 3.624794896871704*^9}, {
   3.62479496518498*^9, 3.6247952134961615`*^9}, {3.624795335866824*^9, 
   3.624795349421747*^9}, {3.6247954772810125`*^9, 3.6247955071551056`*^9}, 
   3.624795656414916*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "4"}], "}"}]], "Output",
 CellChangeTimes->{{3.624789769597909*^9, 3.624789783311485*^9}, {
   3.6247898434970565`*^9, 3.62478986716256*^9}, 3.6247899196748333`*^9, 
   3.6247900226849537`*^9, 3.624790095086482*^9, 3.624790214334411*^9, 
   3.624790442996087*^9, {3.624790486225105*^9, 3.6247905083617887`*^9}, 
   3.6247905419334188`*^9, 3.62479080795603*^9, {3.6247908735724716`*^9, 
   3.6247908889542685`*^9}, 3.62479092645815*^9, 3.624791099871973*^9, 
   3.6247911314935784`*^9, {3.6247912303374453`*^9, 3.6247912409455814`*^9}, {
   3.624791362628142*^9, 3.624791448959893*^9}, {3.6247945612908015`*^9, 
   3.6247945727725487`*^9}, 3.6247947405401*^9, 3.6247947795249996`*^9, 
   3.624794853845352*^9, 3.624794903330187*^9, {3.624795075420994*^9, 
   3.624795094858843*^9}, {3.624795173282048*^9, 3.624795214681632*^9}, 
   3.624795352900168*^9, 3.6247955082938766`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "4"}], "}"}]], "Output",
 CellChangeTimes->{{3.624789769597909*^9, 3.624789783311485*^9}, {
   3.6247898434970565`*^9, 3.62478986716256*^9}, 3.6247899196748333`*^9, 
   3.6247900226849537`*^9, 3.624790095086482*^9, 3.624790214334411*^9, 
   3.624790442996087*^9, {3.624790486225105*^9, 3.6247905083617887`*^9}, 
   3.6247905419334188`*^9, 3.62479080795603*^9, {3.6247908735724716`*^9, 
   3.6247908889542685`*^9}, 3.62479092645815*^9, 3.624791099871973*^9, 
   3.6247911314935784`*^9, {3.6247912303374453`*^9, 3.6247912409455814`*^9}, {
   3.624791362628142*^9, 3.624791448959893*^9}, {3.6247945612908015`*^9, 
   3.6247945727725487`*^9}, 3.6247947405401*^9, 3.6247947795249996`*^9, 
   3.624794853845352*^9, 3.624794903330187*^9, {3.624795075420994*^9, 
   3.624795094858843*^9}, {3.624795173282048*^9, 3.624795214681632*^9}, 
   3.624795352900168*^9, 3.6247955082938766`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Null", ",", "Null", ",", "Null"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Null", ",", "Null", ",", "Null"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Null", ",", "Null", ",", "Null"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.624789769597909*^9, 3.624789783311485*^9}, {
   3.6247898434970565`*^9, 3.62478986716256*^9}, 3.6247899196748333`*^9, 
   3.6247900226849537`*^9, 3.624790095086482*^9, 3.624790214334411*^9, 
   3.624790442996087*^9, {3.624790486225105*^9, 3.6247905083617887`*^9}, 
   3.6247905419334188`*^9, 3.62479080795603*^9, {3.6247908735724716`*^9, 
   3.6247908889542685`*^9}, 3.62479092645815*^9, 3.624791099871973*^9, 
   3.6247911314935784`*^9, {3.6247912303374453`*^9, 3.6247912409455814`*^9}, {
   3.624791362628142*^9, 3.624791448959893*^9}, {3.6247945612908015`*^9, 
   3.6247945727725487`*^9}, 3.6247947405401*^9, 3.6247947795249996`*^9, 
   3.624794853845352*^9, 3.624794903330187*^9, {3.624795075420994*^9, 
   3.624795094858843*^9}, {3.624795173282048*^9, 3.624795214681632*^9}, 
   3.624795352900168*^9, 3.6247955082938766`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"a0list", "=", 
  RowBox[{"{", 
   RowBox[{"1", ",", "3"}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{"hhlist", "=", 
  RowBox[{"{", 
   RowBox[{"1", ",", "3"}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{"p", "=", 
  RowBox[{"Table", "[", 
   RowBox[{",", 
    RowBox[{"{", "2", "}"}], ",", 
    RowBox[{"{", "2", "}"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a0", "=", 
     RowBox[{"a0list", "[", 
      RowBox[{"[", "i", "]"}], "]"}]}], ";", 
    RowBox[{"hh0", "=", 
     RowBox[{"hhlist", "[", 
      RowBox[{"[", "j", "]"}], "]"}]}], ";", 
    RowBox[{
     RowBox[{"p", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", "mkplot1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "1", ",", "2"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"Transpose", "[", "p", "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.624795250354944*^9, 3.624795283378545*^9}, {
   3.624795373645907*^9, 3.6247953742386427`*^9}, 3.6247956599002843`*^9, {
   3.6248106879276543`*^9, 3.62481069968989*^9}, {3.6248113162473736`*^9, 
   3.624811317230186*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "3"}], "}"}]], "Output",
 CellChangeTimes->{{3.6247952635511055`*^9, 3.624795284330041*^9}, 
   3.6247954074162264`*^9, 3.6247955944036684`*^9, 3.6248107020199366`*^9, 
   3.624811319258212*^9, 3.6248115001601315`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "3"}], "}"}]], "Output",
 CellChangeTimes->{{3.6247952635511055`*^9, 3.624795284330041*^9}, 
   3.6247954074162264`*^9, 3.6247955944036684`*^9, 3.6248107020199366`*^9, 
   3.624811319258212*^9, 3.6248115001601315`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Null", ",", "Null"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Null", ",", "Null"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6247952635511055`*^9, 3.624795284330041*^9}, 
   3.6247954074162264`*^9, 3.6247955944036684`*^9, 3.6248107020199366`*^9, 
   3.624811319258212*^9, 3.6248115001601315`*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      GraphicsBox[{{}, {}, 
        {Hue[1], Thickness[0.008], LineBox[CompressedData["
1:eJwV13k4Fl8bB3BtyPrsDyWJCP1alVbuO0kqJa/KLgpJsiVJKYTKEllKdql4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          "]]}, 
        {GrayLevel[0], AbsoluteDashing[{0.8, 2.2}], LineBox[CompressedData["
1:eJwV0nk41OsbBvAJxUmFLF91tFkmkqUsbYf7VU77Mi1KKmeUJAk5HUSWKBUz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          "]]}, 
        {GrayLevel[0], AbsoluteDashing[{6, 3}], LineBox[CompressedData["
1:eJwV1Xc81t8XAHAjkcp4piRkZZSkNIhzk5BURJIykySkJatICHkkKxV6HmRX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          "]]}, 
        {GrayLevel[0], LineBox[CompressedData["
1:eJwV1Xk0Vt0XB3CSSIZnflCGFJGUUpJi7yRJRC8VkrEklVSSipLwlimZM6se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          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesLabel->{None, None},
       AxesOrigin->{0, 0},
       Method->{},
       PlotRange->{{0, 6}, {0, 1.05}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], Automatic}], {192., -118.66252583997979`}, 
      ImageScaled[{0.5, 0.5}], {360., 222.4922359499621}], InsetBox[
      GraphicsBox[{{}, {}, 
        {Hue[1], Thickness[0.008], LineBox[CompressedData["
1:eJwV13k4Fl8bB3BtyPrsDyWJCP1alVbuO0kqJa/KLgpJsiVJKYTKEllKdql4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          "]]}, 
        {GrayLevel[0], AbsoluteDashing[{0.8, 2.2}], LineBox[CompressedData["
1:eJwV0Xk01OsfB/BBIopJ+KooWcZWUdFtuXp/k7K0kWKSRKXrukISg0RZ6g7T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          "]]}, 
        {GrayLevel[0], AbsoluteDashing[{6, 3}], LineBox[CompressedData["
1:eJwV1Xc8Vu8bB3ApGdnPUrJHqBCRFNdNQlEIGZUQkq9CX5VZkmQnoySzeh5b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          "]]}, 
        {GrayLevel[0], LineBox[CompressedData["
1:eJwV1Hk4VV8XB3CkDIU7X5WQpFBSJCrWDmnSjyIhMlSShCRJpoTKnCkyl7pX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          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesLabel->{None, None},
       AxesOrigin->{0, 0},
       Method->{},
       PlotRange->{{0, 6}, {0, 1.05}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], Automatic}], {576., -118.66252583997979`}, 
      ImageScaled[{0.5, 0.5}], {360., 222.4922359499621}]}, {InsetBox[
      GraphicsBox[{{}, {}, 
        {Hue[1], Thickness[0.008], LineBox[CompressedData["
1:eJwV13k4Fl8bB3BtyPrsDyWJCP1alVbuO0kqJa/KLgpJsiVJKYTKEllKdql4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          "]]}, 
        {GrayLevel[0], AbsoluteDashing[{0.8, 2.2}], LineBox[CompressedData["
1:eJwV0nk01P0XB/ApikpRYUqbqAntRKpH70/aPRWlJEVDkqhoU6h8ZyxFJsMg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          "]]}, 
        {GrayLevel[0], AbsoluteDashing[{6, 3}], LineBox[CompressedData["
1:eJwV1Hk4VV/3APAb6RoS3eEcU5KQKCnfNFs7eVWqFyWUIUJJ4lZemYpMyTxn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          "]]}, 
        {GrayLevel[0], LineBox[CompressedData["
1:eJwV1nk0lV8XB3BEJNOdpTKFRAORqNjHkCZlliQhSX6SCiFKQiUkQwkZck0p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          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesLabel->{None, None},
       AxesOrigin->{0, 0},
       Method->{},
       PlotRange->{{0, 6}, {0, 1.05}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], Automatic}], {192., -355.98757751993935`}, 
      ImageScaled[{0.5, 0.5}], {360., 222.4922359499621}], InsetBox[
      GraphicsBox[{{}, {}, 
        {Hue[1], Thickness[0.008], LineBox[CompressedData["
1:eJwV13k4Fl8bB3BtyPrsDyWJCP1alVbuO0kqJa/KLgpJsiVJKYTKEllKdql4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          "]]}, 
        {GrayLevel[0], AbsoluteDashing[{0.8, 2.2}], LineBox[CompressedData["
1:eJwVlWlczPsfxadIXbRRjTWtI9my5BbqfJHClcKV0GVSkqTFTfsyorjTb2qa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          "]]}, 
        {GrayLevel[0], AbsoluteDashing[{6, 3}], LineBox[CompressedData["
1:eJwV1Hk81dsWAPAjGUKZzqDZUKIeuQi5sbbhlqmHRIZu15xkvr1CZOiQa56S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          "]]}, 
        {GrayLevel[0], LineBox[CompressedData["
1:eJwV1Xk4VV0XAPBLRFLcWYokhEreSBpYOyGVioyJTJE0ISmzhEqmhEyJ6CKS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          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesLabel->{None, None},
       AxesOrigin->{0, 0},
       Method->{},
       PlotRange->{{0, 6}, {0, 1.05}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], Automatic}], {576., -355.98757751993935`}, 
      ImageScaled[{0.5, 0.5}], {360., 222.4922359499621}]}}, {}},
  ContentSelectable->True,
  ImageSize->{657.3333333333328, Automatic},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{{3.6247952635511055`*^9, 3.624795284330041*^9}, 
   3.6247954074162264`*^9, 3.6247955944036684`*^9, 3.6248107020199366`*^9, 
   3.624811319258212*^9, 3.6248115409400544`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"Transpose", "[", "p", "]"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "350"}], ",", 
   RowBox[{"Spacings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Scaled", "[", "0.1", "]"}], ",", 
      RowBox[{"Scaled", "[", "0.5", "]"}]}], "}"}]}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
  "\"\<c:/dropbox/mystuff/BehrensFisher/Figures/power1.pdf\>\"", ",", "%"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.6248107602821035`*^9, 3.624810777914456*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      GraphicsBox[{{}, {}, 
        {Hue[1], Thickness[0.008], LineBox[CompressedData["
1:eJwV13k4Fl8bB3BtyPrsDyWJCP1alVbuO0kqJa/KLgpJsiVJKYTKEllKdql4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          "]]}, 
        {GrayLevel[0], AbsoluteDashing[{0.8, 2.2}], LineBox[CompressedData["
1:eJwV0nk41OsbBvAJxUmFLF91tFkmkqUsbYf7VU77Mi1KKmeUJAk5HUSWKBUz
wndkjVGpSJK0CZHsxQgNhawR8tWeCr/5/fFez/X567mf673n7XffdlCKxWLd
lrz/zx8b3C5x3IMsRU7LLI1O0Ah1nK9by7aH8UAHs0TiF0PdLny2G7hnV8ts
k/im6hthc5IXuFvc/fwlHr67iufKDoBH3mGbPIln6r16PC4ORlDq2mg5XxoW
PmGLKpNCkU20FztLzC23vB7tEAYP85lmzRIHq33W2MuOQHbIpsQ9fjRe5myv
jP4aiezwd46MxI6vDU5/F0eDpaIcLThJ4+sEOezNE2Cu9SStDf6SvHqdI0VJ
F5Gd9oNSDqBBbc3P1QmMw1xt3WODEt/wuege5pAA0ZQmQ3Egjery9T3b2cng
Lu1oaj9FI8t7OmevjBBBv9+UjgfT8A4PvBXxVYj2hQnqxqdpyN3d7fxZfBmi
323Dz0JpiMrKSnUqr4Cjtdhb7xyN+NcmWrZ5VyF62uGYcp7GAqlpbflJ18CK
XeDzhEfjk6rfCoZ/HdlbHicfjqDxWK8vbl7gDXDPxRrqRNLYuPXp9lCHDARF
7uWJaBruQq/KLewszNVy5fxIpLE0t4sdTN2Gx6HQOoNkGixH3ZV2Mtlg1VcX
HRfSqPSOSeF9zYZx1a1B8zQadinudh/FOeAm1UXwbtOw1GOfD+PcheKo5sVN
OTQ077Y80Kq8C+GXRqW592gMlK1T3ZmXC3K04/BIHo2TQ1qivKT78Lhved+/
XPJfPq/Htqs+gHH8fN+qKhrWUlEGH/gPEPT32CPdGhpT1cbC5gQ+BGud8M6M
RhrJFk1/n3bIQ1GpQsqLLhrFPN7jTexCBDk89wqQEaCwv/m5fHohRFm+wyv/
ECB/7fy2Sv0n8AjZOFVjmgB7pBxYV9SLwDpuv2SKugA2hb8058wuBidkMLB7
oQDrzRc5U3ol4I5OivSyE2Btj9jDy6UEor8OzArlCrBGEHCi8WYJhCXLj2Y4
CWD9qTqMNnyGoiWG+xb9K4BlltMtBdNScI76FizlC2DCTvoki3IYOxZEGZUK
sLhx5S+noHIIbTfa854LYHz6vXRZcTlIf6vyWL0Ahp3mqqetKzB86or13C4B
dJPrlrDWVyK7x1+OKxUDDTVZ/x87qtEemhFRax2DiZM8Zd+71GJ4UXtmSHMM
+tYFKny+Xouip/UjTZ0xqOLzqNHuWnAPGojJYAzKw+rpc0YiCKNCNq8dj0H4
9KErSekitDcwQebsi1DR1Hr27FIduBqGF6K9L4JtxZdRDa0H9/hkw390Y0F1
0XIJV+vBSbD1nGIaC7kzCVPmlNQjKGpJ5nPEor/iuooeqwFcq4RpobticZvz
VNvCtwHGPy8Pt5yNxVLud+uDbo0QvZ+1ZfZgLNYFOpy5t1OMdiWpxD9K4rD4
QvHq1ONiiH7IixpFcdBImSfHjxZD8dSEnNy2OAwXdoQ51ojBeSrPy/gZh4tj
DpHKq5swnDV1ordJPLr99yceM2uGyJ7xu3gjHkEnD9wxUHmDoP7lrfKpCXDh
lXjOWPwGonMb3czuJGBHkpbpRM4beDwaMfQsTsD8/K77LeFv0O5ylqPTmYCa
Xwfyw6VbwDk7EOGpnQgNP8fy959aYHzTuDkzMxEPThxsTatrgzCc51JUnYRr
lkfEMz+1oeisNuvD2yRclD5Wd2H6WxhvSm80/pIEL/7J0hPb32I4fsLuMY1L
ME+lb21qfAuSc/foHfdL2NPdXujr2i7p33Nr/xnJeC2vcEHTowOiAXptU0AK
mu2OGHl6d6HJ4+NR2XWpCOtc4xob2gU5/SeLYZOK5S7a6fkxXWjftqjulEMq
kk60asrmdkHdJOPafN9UcOO2qCUNd+GhqHLit5up6G00GS093A2RQuV8odJl
fOX8rpqxtwfnpkyrt+y5DKU1fKdi0osfFd1GnKyrsE7Ph/7WXnDcSyPiCq/C
R35QPcahF5HaIVFDNVfRXru+2jm4F2sHH0eXMFeRbStnrPisF+fanL4qLU4D
xyVkxH5NH+S6BytWPUpDJP8E7/em93iosMBK/eU1KDYczFmyZwByi/aGHjFM
B/lg1b/jyADUDamgdqt0eEyarenpN4C10sylAzbpqFv6KiozcQAVPWU2gpPp
iL60+ti8lgH4bBJrC6vToXpovrH8vkFwmiPuO7pmYObPvltt9h8kuUU2BQ9v
Qmuua/qZ/QzUxU165/2zsLT1aLVV9EcIVHpvu+rkoPhn0MaGxM/4EtdrHFlx
D85PKioKg7/iLyUD+670R4g/cH2mKvc7BOvH5nkOF8DAtuPb2MERXGP/6ep4
oRhtn7fUkHW/wFNmX1X66xk+vZ1hrGYzisENysUvDpcj8qbvoV27xiEV9vFO
aG0V2Apym3wSWcTZLG7FziU1uO8RdDMiZQJhOwdHByjXoUGHlt0aLUVyqzam
O8rUQzukXndfvDT5GW8l5by0Ecs4b01TEmXIQ6lFyiPeYrR6nLHk8yaSdnl5
2T3CZuQs2z21NGoSofm0YL2k12o7y5tvnJElwg0ZWXbWbUAnK+rpcTliXBvs
P2TRjng156lsnz/IeT+HbdaSHgYnHz5r5jKZhGw9v+x4WCcu1cSVRXjIk8wi
P/lX97rg70YPz/KcQsLt+1YNv+zGgIOu+u79U0nAQrNg3foehI/2y7Q5TSNO
GaGTc1veIW9wDTPNToFIJaYZ3CnvxSudpZ3LtRXJ4HOpGT+FfXDWO2BEpymS
hJ5j/27wf4/inXv8rGYrkc2Gkw69XtEPE9v+dJVUJXLV5uv52pF+uIasFlv8
OZ384ERPiZP04pyT3M8J9HRyXHVHfq3+IApmOYz3qyiTBU7uH2IfDuLRWKj0
gghlUtx3+l2XwQfU3F3Vz1dSISq/L+/4L/kDSuc6lfGiVcjfjx/6mo1/wOkH
Nqkdk1UJx8d3m+rmIezVbLHfw1clrGnhOpZxQ/h13+hPfVk1UjieO6uyfggn
pd8/jwlQI/VD41d+TWSgpr3MQYdFETv9XZfXmDIg8We+y0lRxHXbZWGPxIen
veQPSlOEO9ZgHmLGIP+HS95dWYp0JBbrF5gz2P8iSXmlAkWCTF0sFi5jkOXF
KrOfTZHcdgeD7xYMVleWL4j7iyJ9OjE3rNYw8Hbb+WXyCYqcZUzYubYMNMwd
K9h+FBnrMDBZt5tB0eixpJX+kn30sppWiSfz+da+pyhyoTHm9sQ9DJJvPhO8
P0+Rc25VbM4+BmV9i80qEijiZj9HU+TAQOWAgteZfIqYXrkzJ8CFwaMFs9an
FlKk8OcLj4lHGNh/WjC7oIgiqTqbbXkS3zi1uuzLM4p8Mg8YiHNlsELor+b4
QpL/2z29W26S+1oH7q9so4jg4KjFU08GsmkjYfbtFAnTuaa86l8Gma6y//h2
UiRr1qOQEom//dKUzXlHEY6qhmnJcQZhM+12zWMosu1MaUuBFwOjzkP6Fh8p
IqWYzVvhzaAh/b9x288UUdEZb3oo8exlUdcjv1OSPpetyfFhUMJK8cscoUhg
22MXwxMMnCsyt1T8oohih6J+hsRTIvO0ukcp8kUsfV7Hl8GdXRXfx8cp0qZX
f1oo8f8AjyY4LQ==
          "]]}, 
        {GrayLevel[0], AbsoluteDashing[{6, 3}], LineBox[CompressedData["
1:eJwV1Xc81t8XAHAjkcp4piRkZZSkNIhzk5BURJIykySkJatICHkkKxV6HmRX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          "]]}, 
        {GrayLevel[0], LineBox[CompressedData["
1:eJwV1Xk0Vt0XB3CSSIZnflCGFJGUUpJi7yRJRC8VkrEklVSSipLwlimZM6se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          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesLabel->{None, None},
       AxesOrigin->{0, 0},
       Method->{},
       PlotRange->{{0, 6}, {0, 1.05}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], Automatic}], {192., -148.32815729997475`}, 
      ImageScaled[{0.5, 0.5}], {360., 222.49223594996215`}], InsetBox[
      GraphicsBox[{{}, {}, 
        {Hue[1], Thickness[0.008], LineBox[CompressedData["
1:eJwV13k4Fl8bB3BtyPrsDyWJCP1alVbuO0kqJa/KLgpJsiVJKYTKEllKdql4
SIQoyVL2EirJLkshjCUpSu9p/pn5XOeame+5r/ucuWbZMcf/Wc/l4+M7O4eP
79/55z6HuIOOXuqh0XfIwQN/qxWKdQrmkNjFiH9AXDvSaxes4ABdnPi0WuJ0
dmtic6wb8F3TKBaL5sFozs4ge4VLQDMRaTtJvEjp4/O/TT5gES4yp5NYzT1g
XXWsPyDNaLVDDA8sKtVTwiwDQCZYxIobywMfzoSUqcINKEnUuttC/C5bvzps
MhQSX6wcyI/jgVXLKt+ppjAYXdu3OTOeB5NzBMG0IALqZZNuliSQvErdv0pi
b0FoZNjEt0QecPUKc+UvRwFaj5mvu8uDVPdbjgGW0XBw9/T70GQevK7c26ev
EA+h+uy2uAc8eHSOcdB0fiLIyD5z3JfKg3OBlzNuTCaC015lMWYaDwRzjGwn
mu5ColKt/WgGD+orKsrlq5OBTzV/FX8WD+60qMgZFtwDp12d0xuzeaA8V6yj
MPYB1K8Ked6Tx4Nx9oVtVHAKyExMZlo+48Fzpf6oZZdTof6mYfav5zzQ0Xup
72+ZBgeXzu85V8oDx0S3al2FR1B/697cjFoebM7tUfDhZoJTmPvZmXoe8Fkp
ahjPz4K1YWnTxz/woPpcZELQZBaU+OeqX2nlgXGCo/FYUzbwCauXTA/yQF1J
4XrAwRxI9Cr6JEnxQDanLV+uOgf4DqxdqD/Bg28Ve9hHCnKBdk34CfM3Dy6O
yNUXxOZB/eIk3bdiaWDh3jKrz84Hi5ZA9SJmGmjOvblqODgfZLYp6VRJpIEo
ZzZg6eWnwGe+sVJZLg3i1T7t8rUsANoZnoHSljQoDQp6vl+hCOqZH6tF7dKg
aLD5jTCvCEo0R+tXO6dBofaKjuqVxVByWiDBwT0NTOZa8iVLlICThtWtvVfT
4HDRjOxS6VKor8yXdn2QBntV19lylV7BaHsvLWQwDbT7mpzc7F6B124R3biJ
NNgdcel8Y/orOCjb6Fjzm+Qdfx0QvroMZEQFLL3F00H9kU2G+IZy6PIx3HJM
NR1UFGLHBaASvGpXh45dT4f1jRozNl7ELn5DIxHpsNZ3YF5FaSU4LRfbL5yY
Dqu7Vdm+mlWA6V1ySXnpoBjfsIlvbzXQVgyd3NGXDlIcAc+fh15D1ytv1yPa
D2EBv4vAgF0deC06eblXPgP691wWn0ipgyz6RH61SgbUBAdx//TWgczs0501
OzKgMuB9+LU19eAl62O+xDwDAhkjybG8eijZGtIrHJUBLFm5srK4BsCQX0Yi
9EegsCN4Ptv/PdA0Kuofkj7h9oQLRt97D3y9LgfmKGWCoF+0yNJXZFypx9l5
ayYMVqWwlPg+QFaI4pN7ZpmQefDlcjWPD5C4K+yCwf1M2GwxpWnt0Ag/NU13
/JTKgj2XLf2eHGmC0QMZJ+YWZsH6kFKtJNcmsi4MTm6syAKphGWCwWFN4L5N
6/PZ+iwYLfocYPW2CT4NPt6ytC8Lbs1ahjK1PsG1IHjCFH8MvZ7HYpw3NgPf
fr8lftaPwevi8cerWK0Q6pskECGVDXZBr1wk17dCVwmN566YDYdi5TYsONgK
2oc4o3YbsmFFYU9eW2ArWPRTru462fB25nhh4Lw2sL2n5rvJMxukLlhVDoy3
gaGjtOjuz9mQf966/X5DBxjGFDjk5eTAA/VTTYvGO0DmoWuqx8scuDXPuSGE
0Qldsx7Kug054BZ8sfy8fifQbFaJK1E5oJoUnrG/sRNwyOxm4spcMOntKvKw
7wIZre1KiSm50CIsHiLr9Bk2s42EqfQn0Gx8ao3LuR7o7xt+pfIlHwK6d9vf
9u8B7crWG41T+bDVbjmvMLIH+KadR/wWPoXY8+2yArk98NNr0omx6ilYROly
Ykd7wNAiIrXF9Sl8bVT5U36yF2TuPeJXEngGkwd/10ia9oFhaveuCtUCoO8O
tinFr2DYzz2r8bIQNHmFsFLvK6Q6qx4wbS4Ed+EhiUjLr2DRKhR9dbQQuur2
vrb1+Qoy3zqCGUtfQJah4Fpa2VcI3Rg9Z/riCzhod+WX+e5+kDiu81V8exGE
Bp8P+r1/ALz+p6dmVlkMtA/W2ZtMvsHTRrnX+6+XgpyMPc/vGAUW3RbSKivL
YXP76dc7wsbg0P5rdyj+aiid9tL5EDMBvnYvXzjm1oJtcVVVkc8k1LfrHMrG
BrhzPGUR22IKFF8ys4eq38Mqw88/Zq1/kf27uW59/kfomNB9i3tmoCZpfNO7
8GYY75Rcyzn8B6KV6mMMKtsgNN3jhIHBX9DxdHbQ+tUJCuKC+91j+DA6zF7o
oMdnyHPySr+RMAdf6NlzzRg98EE+XEAvbC6eXmUastG3F5Zfea9odmce1t+X
3GA67wtsOdi5ISFmPo4GBjZ2WH2Fdic/9eCgBXhs5MT20Vv9kL3FSLT8Jj+y
10VMKFcMAOdIZXOqnwCqXl96pL1sEKCb7+ZLV0EsH1y2ySj5G9zh2IoquC/E
snEpPT+3IfCJP3l1o50Q8gsezdsuMwwaJjZDBxyEsGTOqE2v7DDMkziuZ+si
hG6dXM0A+WHwvWm6OMZDCI2D7f3rlYfB31c3ky9QCGv1hLft3jgM1+02Nr1O
F0Jv4dne9j3DEKo6Z8WxYSH89b3WPNd5GOLeRlXccBLGnGrru4qFwyD1DOdF
ugrjXPnGz4eLhiE2uR9i3IVR1V3dz7tkmFxvfpbiJYzFy25Ovy8bhjuyn9JL
QoXRdGz3Y+vaYYh0494czxJG9p3bXds7hiFY+pbJkTFh7DF73lM0OwyeDuGj
S1xEsMvTWnvTthHY+3Jde8dZEaxuefmlZ/sISHDqqxPOi+D26gOaIeojkPtC
JHmZtwhqlm6D7h0jMCjif1g+VAS33nXRPK89Aobp7gX/PRLBXxI/RewPj8CG
fjPfbYMieNugP9HWYQS+WSpKGB0TRd7XHPuO2BEwtm9decpGFJ9uT1E0ix+B
Krcb4GknigP8q263JIzA/cDvNkkuosjYNHqj4e4IHH1S8mTARxQF/A1mM1NH
4L2gkb5HsijOHCnzXZM7As8zr9+I6RXFujWRTuo1IxD4Z3B+h40YHqwYSi8f
HwFt54iqNDsx9Lv792H3xAjM71MLOucghoecZJ7Mfh+BS29CmXQ3MfwiN96m
MjUCTjGqspp+YjhaERsTNjMCR7b4QFqyGAbUThnLzqdA9qykh1uXGKpsfSUc
wqKgYGg3JWYsjpeimpYXradA9UZsQJWZOFY0MyXjVCjIXjMm72MpjnPNl2hc
2EABzyXadNJWHN0+FG7YqEpB1M+h6tZz4thVIp+esIUCt/lh91IjxfEcu1df
FylQkWoz0mgQx/MgsXvJfgoevVg7OfNBHEWi21p7iJWP+oU++SSOQcLaebwD
JN/d1ZWKXeIYF7BcXeUgBQxF7w3ilDh+LzNNVdOn4KdkuIADPw2zei4ZrTWi
4KP85u6ty2l4MqKzINSKgt4G+52oQMOP+QG/dK0pGPdMurdLkYZpCT2OYjYU
iH8UOnHwPxrmSyznv36CAm3/9m/WG2iofcJt0NWO1OOLz2SoJg19ZjdKKzpR
kJBSK/jVioZPHwX58F0g+fXn2g3Z0PDcnDODKcSFf1Vfj9nS8E9yRtyBixR8
MkgM/m1Pw0t8Pv13PEl+wTMMxlkaPlLSklH0osDXVkJKzY+G8j80YuX8KLBV
Or4m/D4NT8TMfIy+QYG0UHj/2RQatrx/vlAuhIL3gy+TDHk0/Ga9NzONWP2h
LEs6g4Ypr5IPPQ2lgLmm+2dqLg2TWsZZtWEUFG2wfFn0ioYa03H1bbcoYOHR
w4Ofaei3htKJiqegRiZErLaHhvxP3PLEEyi4PKe4MrOPhnee9yX6Ew++lN56
doCGq3tXTbskUlC8q0Oab4yGUY81anbdpcBun1k/m4+OdZV31D/cp6D0iMmF
HdJ0XKNyxfT2QwoqwthVOjJ0/M/X3lkwg4I3b+tYhrJ0RImLfOeJP2lpPnJQ
oGOcLSPE8BEFo6qrPsespuPW3ysu0rPI/Ll/tX6o03FSb/eCUzkUeDTdZaQf
peOrvU+3lzyjwItpdjTPkjx/xCxgWQEF/rrch6XH6bgyOsPSh/hmZeCuTyfo
WJAtn6nxnILUfFf3BU50dNpj+e5FIemX21odR73omD22OTG+mPSn4SCPlUTH
153CHqLlFHRVJRz4c5eO3yLQ2IQ4aMvhib57dBRY/6AzlfjLopLt+al0/LzS
ulWjgoLo9sg6oyw69lTtS3SppGDu8R2T8cV0/Hq0KL20moL601Go1EHHo5J5
UjJvKfDs2N9H76Lj9sMX9xwnVtadFzD9mY4uCfwKD4h91zq8f91HR/VmHqVc
R8GmiZ02DsN0jOZStWvrKYh3pwJzftPxA/3dzKp3FNhf0WpSW8zA24vzto02
kvUR0PBVagkDpVSfNSl+pMAvzPTnjDQDPdZ3rrEkjk9ykSyQZaDzSAq7gbi+
ON5EVZmBSTEZRRlNpB6/f3Su3sJAoXl9pcbNFEy7pvQvNWDgKS7HzK+N1Pvi
+l+zhgxsCjvw9wkx0/fFwg5jBtYmf7H+Qvxf+HvlWHMGJoSt8dZqp8D88V97
CRsGruuifszrIP0ybDBGO8tAHd8OlmsnBddsBKfnhDNwQ8anF8rdFFhXL4lf
GMnARyHdfQbEGv+paNBvMzBqPLDel3hmzCxAJoaB8++1jbQTO3jmLIJkBi6U
2mkQ3EPB4QjzbRdzGNh2IZ/1uZfsJy9zL/54z8CrMT7LzL9S8Hd5jcxsIwOL
HbvkfInbrnaWLfjEQBU5szEe8a39QqLsNgYau2aPfCde2Hw0TqWXgRmHCs5f
6yf9SgkVOX1n4FBYt8CDAQpeLLH8O8hi4s+CAxmF3yjAJ84zdRwmyu1j2bcQ
l+n4TOVKMHF73OF5P4nfXEimLkkxcZyaW7h+iLy/ua+TsZyJmTlzTR4Q/460
K9mqwkSL1jY3/2EKtom5egfoMdEz/bLBSoqs7/u+no76TNwq7HhBk1hDLfL8
ocNMlCzR9DQj3muf5yxtRJyza3EIsXHNT8tsCyb2VfKXjxJ7+HtqtDgy0WuZ
znjGKAXPZv3nKd9g4j6m1EvaOAU3xpaFbwpl4qR6S/YK4mO9hbK7wpi4F9Z6
qxML1YzvsLjFRGWmcf4pYtNIc69b8Uw0N7x1o4x4dqXqn7mZTEzZEyXuNEGB
plHfj9Y6Jm58MH4t8zsFEjpe/gMNTIyyNfR+STykvpgz9Z6JVlbppo3Ekcv1
NjI+MZHvcH7hNPEXqvCMdhfJq/lYQXOSguv+EaO5o0wM3v7tVQPx25ydg8F0
Fp4wsVBs/kGBj1pu300mC800FS73E6tWLv8cyWZhjalR0RRxfMuCT3GSLOy/
cO0He4qC03OqyjOWsfBdbaCeHrGIrk5S7ToWJkzm1b4i3jt4yFD0fyyUvpSU
E/WTzO9MuT79EAvbS/7o3yfO/rNRl32EhU0OQV2PiRfRuVpLjFmofDGrqIZ4
YFOzyqpjLBwVlgibIb7mZya+34WFnXuWZBj9oqBcxqYiKIyFkqbcU4LTFMh0
Nkg6RLDwy+J3TAaxR5zaad1bLEwrX/ZoMfHaRWwWI5qFV0/U5q8mjmWWWd5O
YuGqL47LDhG78sv+ScpiocItW/NY4uVD7Sr5b1no/b13VnaG7Pdpe65G1bOw
eHrVrDJxi+2TlvPvWEhVHBhbTxzaF+S9/SMLbwcb52gQ/+7YVlfazsKz7nap
lsQfGu7YvRli4fOBFKs4Yt/8w0mfhdj4ccYnXOQ3ydew79o3ETaO8t8vYBK3
Du5wnBRj4/qvFY2LiNdLr1ZbyGSjuIZ+vyJxpy9/89rFbCwuu+alSbz1f/k0
r5VsVJ3/Leg88eiQhJe0DhvXNbUFtRLH8oufUDzARn3vpMOfiXfLLDiw/iAb
g8R9WF+J4/XHFmsdYuPZix9cx4n3FVTnnzZlo5LzyVLBPxQ8uOpBFdqzUXfU
+rYKsalsm7lJMBv/LBGP8SF+5FQbpxHCxsvpT777E88pLmpTuslGu3PauwP/
3W+SZPwzgo1JX0ybwolHI2yORMay8Uer1b17xL4CY/vr0tmY2v15uoz44dAC
tZ01bPRYatTBN0v6Z+vUBeU3bBS2G7adT6x3vb+A/pZNvgf3hwWIf8i/3tzV
wEbt5OQ+MWI8GrrBs5mN9WH1oVKz/+q/6L/8fjZOWri3qhLP5K1ZvFKAgw9a
F1w8Qbw69ke54EIOhmrM329HbOH9wumLEAclJkwlTxOX7dtXkSTGwTO2W+65
EAd12ThLcDgoJ3bsiiexlFB85QJ5Dk5dcjgdRrzdTMS1S4ODT6+4SD8jdtB4
L12kScZTck88J05cEV0do8XBHbAs4wXx/PEVSw32cjDO6+Z/L4nf+O+sqdXj
4Mcwl9kaYtMsD5nnFhxUM1GfaCW+OG/gTeQlDpocido9868+O7cKx3pxcDNT
ds8fYm/fwD13fTgoFvJD6y+x/4LVFY/8Odiy5M6meX8pCBE4U1x5g4PSg2eG
hYjvCv95/Cueg3krW7MkiauZ9NtmxRysEjYv3kCsc+hY4/FSDjrv+nBYlfht
RA7T7hUHv8GBgU3E79hHQt0qORikfUxgG3EbN+Z6SB0HbcOjZXYQjy6Wv1ja
ycGUuqzXOsSc5Vss5fm4+OXZrPwxYrzjNyU4l4vfEul6x4lPir0LHprHxdkG
MQ8r4sKfdgU5AlzyP9FYbkN8rDaWqSHORY+bPzRPET9y46swl+bivEsOvWeI
taorlaO2c9FdKaroCrGTOqv0gjoXH4hoZ/gS38mxMDiKXMyz3B3tRzwU9+uK
giYXM2rA8SpxmMvK9tx9XDTwtlkQSNyxOCSkwZiLI+Hfe28Sn3M48l3oPBff
tV++Ek8spWpVpXCBi9sC9AwSiEv+OMdqeHKxRs9JKZFYKDhY08Obi26b71Yl
Ecenl0UMXOfiwP51E/eIK/rXb6yK5iL3/LOZNOJTWbiwN5aLup1NT9KJae4H
2v/Gc7GfcnV4SGwsYOe3KZmLkXmqrRnEw/JJjQ/SuSioqZScRcw6Lu7mV8hF
kwVq1BPiZ8pL9iYVcfHYbFRYHrH5uLL0ixIuLh9N2JBPnOqtVfG9jIsqCs9c
nxJvS/TkWNVysTLLoq/gX73bv+VpdHDxxoecgGJigfu/Asy7uGgnOCJZQvzQ
XuCoRzepV9l0yj//mJEVyP7CxbQlkSWlxAGLjA2WUVx8bifa+4p4TfeJlWpj
XHxBl7IrI/7AO/vXcIKLNjbi1D9Lb7mZEjrFxdXtDyfLiV/xJVx4+IuLXgYm
5yqIbase6lbNkH5ZMzX1zyKhBXK9f7h4+5rPuUrixwZVU3//crHw8t/Jf/4/
bYtsKA==
          "]]}, 
        {GrayLevel[0], AbsoluteDashing[{0.8, 2.2}], LineBox[CompressedData["
1:eJwV0Xk01OsfB/BBIopJ+KooWcZWUdFtuXp/k7K0kWKSRKXrukISg0RZ6g7T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          "]]}, 
        {GrayLevel[0], AbsoluteDashing[{6, 3}], LineBox[CompressedData["
1:eJwV1Xc8Vu8bB3ApGdnPUrJHqBCRFNdNQlEIGZUQkq9CX5VZkmQnoySzeh5b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          "]]}, 
        {GrayLevel[0], LineBox[CompressedData["
1:eJwV1Hk4VV8XB3CkDIU7X5WQpFBSJCrWDmnSjyIhMlSShCRJpoTKnCkyl7pX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          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesLabel->{None, None},
       AxesOrigin->{0, 0},
       Method->{},
       PlotRange->{{0, 6}, {0, 1.05}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], Automatic}], {576., -148.32815729997475`}, 
      ImageScaled[{0.5, 0.5}], {360., 222.49223594996215`}]}, {InsetBox[
      GraphicsBox[{{}, {}, 
        {Hue[1], Thickness[0.008], LineBox[CompressedData["
1:eJwV13k4Fl8bB3BtyPrsDyWJCP1alVbuO0kqJa/KLgpJsiVJKYTKEllKdql4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          "]]}, 
        {GrayLevel[0], AbsoluteDashing[{0.8, 2.2}], LineBox[CompressedData["
1:eJwV0nk01P0XB/ApikpRYUqbqAntRKpH70/aPRWlJEVDkqhoU6h8ZyxFJsMg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          "]]}, 
        {GrayLevel[0], AbsoluteDashing[{6, 3}], LineBox[CompressedData["
1:eJwV1Hk4VV/3APAb6RoS3eEcU5KQKCnfNFs7eVWqFyWUIUJJ4lZemYpMyTxn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          "]]}, 
        {GrayLevel[0], LineBox[CompressedData["
1:eJwV1nk0lV8XB3BEJNOdpTKFRAORqNjHkCZlliQhSX6SCiFKQiUkQwkZck0p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          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesLabel->{None, None},
       AxesOrigin->{0, 0},
       Method->{},
       PlotRange->{{0, 6}, {0, 1.05}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], Automatic}], {192., -444.9844718999242}, 
      ImageScaled[{0.5, 0.5}], {360., 222.4922359499621}], InsetBox[
      GraphicsBox[{{}, {}, 
        {Hue[1], Thickness[0.008], LineBox[CompressedData["
1:eJwV13k4Fl8bB3BtyPrsDyWJCP1alVbuO0kqJa/KLgpJsiVJKYTKEllKdql4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          "]]}, 
        {GrayLevel[0], AbsoluteDashing[{0.8, 2.2}], LineBox[CompressedData["
1:eJwVlWlczPsfxadIXbRRjTWtI9my5BbqfJHClcKV0GVSkqTFTfsyorjTb2qa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          "]]}, 
        {GrayLevel[0], AbsoluteDashing[{6, 3}], LineBox[CompressedData["
1:eJwV1Hk81dsWAPAjGUKZzqDZUKIeuQi5sbbhlqmHRIZu15xkvr1CZOiQa56S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          "]]}, 
        {GrayLevel[0], LineBox[CompressedData["
1:eJwV1Xk4VV0XAPBLRFLcWYokhEreSBpYOyGVioyJTJE0ISmzhEqmhEyJ6CKS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          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesLabel->{None, None},
       AxesOrigin->{0, 0},
       Method->{},
       PlotRange->{{0, 6}, {0, 1.05}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], Automatic}], {576., -444.9844718999242}, 
      ImageScaled[{0.5, 0.5}], {360., 222.4922359499621}]}}, {}},
  ContentSelectable->True,
  ImageSize->350,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{{3.624810762292144*^9, 3.624810778334464*^9}, {
   3.624811359506728*^9, 3.624811370489269*^9}, 3.624811541018055*^9}],

Cell[BoxData["\<\"c:/dropbox/mystuff/BehrensFisher/Figures/power1.pdf\"\>"], \
"Output",
 CellChangeTimes->{{3.624810762292144*^9, 3.624810778334464*^9}, {
   3.624811359506728*^9, 3.624811370489269*^9}, 3.6248115413612595`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"a0list", "=", 
  RowBox[{"{", 
   RowBox[{"1", ",", 
    RowBox[{"1", "/", "3"}], ",", "3"}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{"hhlist", "=", 
  RowBox[{"{", 
   RowBox[{"1", ",", "3"}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{"p", "=", 
  RowBox[{"Table", "[", 
   RowBox[{",", 
    RowBox[{"{", "3", "}"}], ",", 
    RowBox[{"{", "2", "}"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a0", "=", 
     RowBox[{"a0list", "[", 
      RowBox[{"[", "i", "]"}], "]"}]}], ";", 
    RowBox[{"hh0", "=", 
     RowBox[{"hhlist", "[", 
      RowBox[{"[", "j", "]"}], "]"}]}], ";", 
    RowBox[{
     RowBox[{"p", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", "mkplot2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "1", ",", "2"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.624795675507284*^9, 3.6247956872275763`*^9}, {
   3.6247958098734245`*^9, 3.6247958104506245`*^9}, {3.624797644027168*^9, 
   3.6247977151026793`*^9}, 3.624797834820614*^9, {3.624810605401004*^9, 
   3.624810608361063*^9}, {3.624811450520295*^9, 3.624811453562334*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   FractionBox["1", "3"], ",", "3"}], "}"}]], "Output",
 CellChangeTimes->{
  3.624795688350748*^9, 3.624795811792224*^9, {3.6247976742759557`*^9, 
   3.624797688144533*^9}, 3.6248106115511265`*^9, 3.624811456136367*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "3"}], "}"}]], "Output",
 CellChangeTimes->{
  3.624795688350748*^9, 3.624795811792224*^9, {3.6247976742759557`*^9, 
   3.624797688144533*^9}, 3.6248106115511265`*^9, 3.624811456136367*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Null", ",", "Null"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Null", ",", "Null"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Null", ",", "Null"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.624795688350748*^9, 3.624795811792224*^9, {3.6247976742759557`*^9, 
   3.624797688144533*^9}, 3.6248106115511265`*^9, 3.624811456151967*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"Transpose", "[", "p", "]"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "500"}], ",", 
   RowBox[{"Spacings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Scaled", "[", "0.1", "]"}], ",", 
      RowBox[{"Scaled", "[", "0.5", "]"}]}], "}"}]}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
  "\"\<c:/dropbox/mystuff/BehrensFisher/Figures/power2.pdf\>\"", ",", "%"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.6247978397658777`*^9, 3.624797906161329*^9}, 
   3.6247979534777355`*^9, {3.624798009891059*^9, 3.624798086723044*^9}, 
   3.6247981306810865`*^9, {3.624798192271245*^9, 3.6247982437873955`*^9}, {
   3.624798397221738*^9, 3.624798470752446*^9}, {3.6247985390053215`*^9, 
   3.6247985392861247`*^9}, {3.624798572623752*^9, 3.62479861299807*^9}, {
   3.6247989175823755`*^9, 3.624798922870843*^9}, {3.624798976739334*^9, 
   3.62479897720734*^9}, {3.6247990267535753`*^9, 3.624799026987578*^9}, {
   3.6248106191922793`*^9, 3.624810619372283*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      GraphicsBox[{{}, {}, 
        {Hue[1], Thickness[0.008], LineBox[CompressedData["
1:eJwV13k4Fl8bB3BtyPrsDyWJCP1alVbuO0kqJa/KLgpJsiVJKYTKEllKdql4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          "]]}, 
        {GrayLevel[0], AbsoluteDashing[{0.8, 2.2}], LineBox[CompressedData["
1:eJwV1Hk01N//B/Ap1cwnibK820MZS4kkqT48bxRCx5RIKtEiyQ9tUipT0TKZ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          "]]}, 
        {GrayLevel[0], AbsoluteDashing[{6, 3}], LineBox[CompressedData["
1:eJwV0nk4lQkbBvCjFBVZwik1ETmoSSoZNV/uN4koxSSpZBCSlFPNZ19OoRoc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          "]]}, 
        {GrayLevel[0], LineBox[CompressedData["
1:eJwV1Hk4VesXB/CTEil1nFFCSEKTi1SK9SapJEMoCRlKciXUFcUlIYmIKBk6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          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesLabel->{None, None},
       AxesOrigin->{0, 0},
       Method->{},
       PlotRange->{{0, 6}, {0, 1.05}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], Automatic}], {193.5, -148.32815729997475`}, 
      ImageScaled[{0.5, 0.5}], {360., 222.49223594996215`}], InsetBox[
      GraphicsBox[{{}, {}, 
        {Hue[1], Thickness[0.008], LineBox[CompressedData["
1:eJwV13k4Fl8bB3BtyPrsDyWJCP1alVbuO0kqJa/KLgpJsiVJKYTKEllKdql4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          "]]}, 
        {GrayLevel[0], AbsoluteDashing[{0.8, 2.2}], LineBox[CompressedData["
1:eJwV0Xs41AkXB/BJipDbMiNJRQbZSlJY1feXvG7VQ6vc66Uk4S3Z1q1iIta6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          "]]}, 
        {GrayLevel[0], AbsoluteDashing[{6, 3}], LineBox[CompressedData["
1:eJwV0WtYzPkbBvDpYKdFKmp+qVCqUWyiKKy6v8hx+TeEdFg7HSjMEmtrlFSW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          "]]}, 
        {GrayLevel[0], LineBox[CompressedData["
1:eJwV1Wk4VW0XB3BJOU04s5CknAwlpVA9rJs8KmQoUZGplDyUJMpQEiqZMoVk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          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesLabel->{None, None},
       AxesOrigin->{0, 0},
       Method->{},
       PlotRange->{{0, 6}, {0, 1.05}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], Automatic}], {580.5, -148.32815729997475`}, 
      ImageScaled[{0.5, 0.5}], {360., 222.49223594996215`}], InsetBox[
      GraphicsBox[{{}, {}, 
        {Hue[1], Thickness[0.008], LineBox[CompressedData["
1:eJwV13k4Fl8bB3BtyPrsDyWJCP1alVbuO0kqJa/KLgpJsiVJKYTKEllKdql4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          "]]}, 
        {GrayLevel[0], AbsoluteDashing[{0.8, 2.2}], LineBox[CompressedData["
1:eJwV1Hk01VsbB/ATGYo0cM4plQyRoaKUhnv13SjdVDfNkkSZUhkKEV0n/E7C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          "]]}, 
        {GrayLevel[0], AbsoluteDashing[{6, 3}], LineBox[CompressedData["
1:eJwV1Xk0Ve0XB/AbGTJkugMqQpHqlZTeJr5PhkoaNEsJJSGpvF7XVG6mZB4y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          "]]}, 
        {GrayLevel[0], LineBox[CompressedData["
1:eJwV1HdYzt8bB/CklFU9OyQV0qChxDfqviUJoWQkTRQSEqIUSUKKtJSepyEk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          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesLabel->{None, None},
       AxesOrigin->{0, 0},
       Method->{},
       PlotRange->{{0, 6}, {0, 1.05}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], Automatic}], {967.5, -148.32815729997475`}, 
      ImageScaled[{0.5, 0.5}], {360., 222.49223594996215`}]}, {InsetBox[
      GraphicsBox[{{}, {}, 
        {Hue[1], Thickness[0.008], LineBox[CompressedData["
1:eJwV13k4Fl8bB3BtyPrsDyWJCP1alVbuO0kqJa/KLgpJsiVJKYTKEllKdql4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          "]]}, 
        {GrayLevel[0], AbsoluteDashing[{0.8, 2.2}], LineBox[CompressedData["
1:eJwV1Hk0lXsXB/AnFJUi4XSlkuFE3VKaqPj+KjcaRCmV1CVDrhSl8BziMZ3q
GDqZEgenq0jkllxKEjI3cU0ls2Sqg5QGyXveP/ba67P2H3uvvfbai4+57XWU
oCjqoTj+n7/tPJVo4cYYFdnMfRG4kwbXYYn2K/ZRUDu0Qv4W+4XonUs4+xSK
/rDImLKLRobSW+EbgSeoyCEIxR6+vzXMle0HyiRhq58ZDRWdxkeTTYEoMtfO
S9hNw9Cbt6pKwAU5eSvhmzkN2wqjtEg7Hig9l0/Re2gEKo+q2rAjwEh8L3C3
pPFftmVV5Bc+iPyCidD9NByalwd/bYoEc/htzvsDNL5MkYFNfjTIvXPvGWvx
vDpd34sEsWD+dom2PkKDtacgR8s/Dsylc8UetjRuece68eziwfhHuD+3p/Gs
YkePJTsJ1KMfdptO0MjyUrCwkRKC6jiZYelGwyvU/07EFyGY6hUhtz1oyNw/
5Dza9DeY7ed+KJ+nUVNeXqZVlQLqdyr590Aa15pXaxzMvwHKqbsn4AKNpRKz
2woEqSBrD7oNRtL4pOSzcSg8DaS9rmAyjsYjnb64xf63QH76lFgm09i1p8SS
a3cbjP2T2Y8yabgJPavM2VlgbHbZX6imoZ/TzQ5k/QNi91g7/j8alIP2Fmup
uyiadaj1QzONKq+Y5LAvd0FCp6/Z+4GGdbKb9UhTNqi524MXKHBgpMO+xLO4
D2Jqn7VSlQP1+y15GlX3Qb3+d1Ywm4PB8u1KVvk5YOAfNbiRA1+RRk2+IBcM
f15r4V8c2Ho3/7JUygNhV9TUn+PAWOLK8o/heWBac3cvC+RglvIv3iL/B2Cc
ds6LT+AgyfD1H8F2+aDMe9YztRwUh4U9MmMXoqhMZx5nuw8KB948n5leCOb0
r80T1j4oMF3SVrXsCYq4RsYvXH1wWMKOSplXBOZ9tdq+Kz7YXziuvmhhMagZ
xGOy1Qc71q1yZuk8BeMRuLs9xBemPU3uni5PQckt7zQQ+MIk2o9uyHiKorTy
jK5sXxh/esaLWlGKouJLOxd1+sIoy+mO3JoyUNattMnm81jNFnySRgUIVzbP
Rd4Peg1bxp0YsSufT+Qs88PK4H7J8uIKUNFjS81N/LCia51SsHElKIlHWR7+
ftBOql1P7agCdUznFjPqB1Vl6fPf9j0Dc+5iQdmAP6ZOOyPd7/IKlKqMqcfM
APRt95cbTRP7gOaNMdUAVIeHsSbeiZ2tlZW0IgAVvLqoi7o1EKoNzDiyNwCh
CqIUQXoNmMyG1OiEACiqa5SWJtaiQ18zf2JNINibw6WUuHVgUg+u1Q0OAqs7
Sib+Rh2EbhbPnOODIBMSL7voqbhe5mJQdTcIA5VpijpUPajCnv5frUH4x6JE
05BTj6LcvTnYEAx926/Gjqca0DGygtL+EYzt/nYh/1o1QdinVqIWx4Xe5eJt
1882gWRuyvkvmwvV5MUy4ZFiS1SdzHzBxXBhJ8/hZRMYE4dLTZIXEPvLjj93
22t0tG5InX3mAt6dP5Zweu0bCOmXtQpWF8H42t9brvgWQq+Sq9MNeXAJe3rm
N723KDrx5HarDQ/7BBprplq8BbVTekOLLw9LCrpzW0Lfwjbupvahxzy8HLcv
CJVsgVpqf8U+EgpVH4eK/k8tsDVQ2XN8dxjyaMfWm7VtEK7iFyeFRiDV6EST
yiexo7ln5udEIFbydO1lhXZQ764IX7REwDPct4y2bEdHbPrIfysuY931qDtm
De2wbZNqcWi4jMPvOgo5rh0o+nNTg20sH80z5S6ru3eixpCbKJSIxF7RHNkj
TCfu3v+nab9KJKprFC9d5XeCzLzRuEQvEvkxKkGy9zoh7A1zVD8WifhFbK+x
kU4Ml8kkeDyNhPVqwz+rPbqwssJXMSY0Cm+sT+ie8eqG7S3r6h16MeB1mbhe
5XbDPd8xs3tnDDa4aKYXxHSDycg/e9UxBgK6VV06R2xP42HzazHiPZkrC4a7
UdTlOH+aRCx6G1ZPlP31Dmr8ybCo17H4YvGz+jebHnRoW4XGxMch9fVraZzo
Ed+DNCc1Lw5Wtv8aO3B6xP9ulUJ9fRweuJ0qzIrrgbxihFeI3DX4RnTc29rQ
g5rq7r+3cK9B8nlp3Mnd7+HOWtyuR8djjkm4UzHpBfWlsM/snADG6QVYtqcX
Hd9GWl7GCeA988O8GDux776P8CgQoOPVjmfOgb2QV7nsoS2ViLsHZVbKl/aC
/4O3ektMIixcgr4fNelDTVyL2h+FSeCH02E/zfrBaLA3ScQKIV/vmL3+8CCE
thY68w1TQD5uHth3YhAWvKtsXcsUuE9bqH7GZxCVzWmnrf5KQa1+45XMhEEw
y5Tl22NSEJm47fTilkHo32j4481QCpSOL1k588gH8O25W73TbkDlR9+dtqMf
8UBquWSMVio01FzTQ44NocajeX7L0XSEtS2+Hn56CKby3X063ukYEzTFxTBD
4EuJZHlX0lH529aLN5OG0PH56qmA0nS4zlU5XtY8hGEMs82W3cZhSYfIQJ1h
yHysemXz8zZujs2xKLk+jCKvxin+mZnQbz35bHPkCIhBdX+P+l0U/2B21SeM
4nfBdllffg6cn1RWFgZ+gWDstsqFIw9xzT5NRcn2K5hHpguH7hdi+cHOsV+O
38H1nn5mdlwJ2kbNX5Lt4yjI+L5HW1SGT+2/rVTeP4HXASdCprRUgZ/BOX7g
wCRyT3TWeE++AFtOxsw7gSIfPIb2akyvRa47kxGRPIXwf/KnZVnVoV4rSnpP
pATZsP6IXmV4AzSD6rSPXJMkeQuPm8lRr2Fg0b4mOUGKGFk+NbFwbUare4hR
eNhU4se51a+b1YJsg0Ozyq5MI/vH1vqYqrRD2ariza0QacL2en56W3oH0EVd
KTkrQ6xuY/XAg05cU3aexfaeTmKTW5vkG7sQmPTXhbUuM0jK42tbGxu6kfgy
rjzCfSb5NpqnE9X2DudPRQ0vOCNLNu6a7f6tvgeDdtrzDh2bRfZbmPesynqP
0IkBqTan2WSN9lLm39Be5H8wGZptLUe4piVSa8z60Kil37VBU570Ze18Hvir
D8469rpRN+UJo7bY2PReP4qtDvtsXjiH/N4791jyzgGsPjiQrnh9DpEYVCiv
6xmAa9C2JsP5CsTCPlog6TKIi04yP6ZEKRAH1iVD+c5BPF5gNzmgOJc41241
kTjwAQ9/cSWXRswlOfMmjHUffcDL+1sHwucokrUz59pcX/ARZWpO5WGRiqTr
5dTEx2c/Ijhv//XOGUok/smXQaXCj7BRbzl6OFyJJJWqcYVTRRjP1Z2/TFqZ
lIVOCvw2i+Ar2f88xk+ZGGiMzF7vKYKypoGdFsUiVvr5fNN0EbxOWX2eQbMI
KW7RulMnguo6h0q2D4uoZp9M/LNehKKJ04It51lEwuvbgzkNIswIDzfmBLBI
44bolrONIiRllEb3X2IR6oZc87o3IpT36a2tjGeRLHrXq/Q2ERTt5TxDCsT9
TH1v7+oX4eHSBTuuF7JI3LOggVGxj35auvBxEYsU3l1fFz8gwq2AbeWfS1nE
xUQ/uXdQhI3C88oOL1hE7XuK1nmRCMdaB3O3tLGIuaeRbNyoCNI3v/OOdrBI
iqdxn8FnETJdpf/kdLGIey1xeyv22Li6dPZ7FnHKuuO3YEwEnor1gcVDLGLt
ZpaW+E0E3a7jywxHWOTN5/G2Td9FqE8/N3lwlEU2/igueSv2QoMrafyvLJK2
T/PyvHERnlLJPpnfWWSGt4x3rtjOlZnmleMsIvMgata+nyLI8vM13k2wiGZX
v/mI2PcOVH6dnBTv4+EKREyI8D9B6oSr
          "]]}, 
        {GrayLevel[0], AbsoluteDashing[{6, 3}], LineBox[CompressedData["
1:eJwVz3k81PkfB/DZFLYLhdms5KgptaiUVMvrU6loa3O0QliEJDn6tY6a4etI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          "]]}, 
        {GrayLevel[0], LineBox[CompressedData["
1:eJwV1Hk4lN3/B/CpyCSi2W4kyTK2ComHis8hj9LyRAslCSFJUo8vKkmShEGW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          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesLabel->{None, None},
       AxesOrigin->{0, 0},
       Method->{},
       PlotRange->{{0, 6}, {0, 1.05}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], Automatic}], {193.5, -444.9844718999242}, 
      ImageScaled[{0.5, 0.5}], {360., 222.4922359499621}], InsetBox[
      GraphicsBox[{{}, {}, 
        {Hue[1], Thickness[0.008], LineBox[CompressedData["
1:eJwV13k4Fl8bB3BtyPrsDyWJCP1alVbuO0kqJa/KLgpJsiVJKYTKEllKdql4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          "]]}, 
        {GrayLevel[0], AbsoluteDashing[{0.8, 2.2}], LineBox[CompressedData["
1:eJwV0nk01fkbB/BbKqJFtttissRFaaIUph/vT400adOGUF1rkrJMP0uyZC25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          "]]}, 
        {GrayLevel[0], AbsoluteDashing[{6, 3}], LineBox[CompressedData["
1:eJwVlHk01Psbxyd0TYtI+KorWWqypCRtlPcnV5Si0ULhymRJciPdhLIkFBlk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          "]]}, 
        {GrayLevel[0], LineBox[CompressedData["
1:eJwV1Hk8lNsfB/DJ0ohCmZlHJckyjRTa1Y3vaV/UiyhEdY1lQi4q105DSBjZ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          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesLabel->{None, None},
       AxesOrigin->{0, 0},
       Method->{},
       PlotRange->{{0, 6}, {0, 1.05}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], Automatic}], {580.5, -444.9844718999242}, 
      ImageScaled[{0.5, 0.5}], {360., 222.4922359499621}], InsetBox[
      GraphicsBox[{{}, {}, 
        {Hue[1], Thickness[0.008], LineBox[CompressedData["
1:eJwV13k4Fl8bB3BtyPrsDyWJCP1alVbuO0kqJa/KLgpJsiVJKYTKEllKdql4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          "]]}, 
        {GrayLevel[0], AbsoluteDashing[{0.8, 2.2}], LineBox[CompressedData["
1:eJwV1Hk41GsbB/CJHEJRYeQ4kWUiVydHKVp8f+JY6jiJLEkytrwI1diXJtub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          "]]}, 
        {GrayLevel[0], AbsoluteDashing[{6, 3}], LineBox[CompressedData["
1:eJwV1Hk01dv7B/CPoSgi4pzIjUxJt7gpafL+hFS63XQTUolCziHiyiwf06lw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          "]]}, 
        {GrayLevel[0], LineBox[CompressedData["
1:eJwV1nk4Vd0XB3AZohLXnY6IZCqUFC8NsnaSouiSKSRzUkryVkRJUgmZc7ld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          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesLabel->{None, None},
       AxesOrigin->{0, 0},
       Method->{},
       PlotRange->{{0, 6}, {0, 1.05}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], Automatic}], {967.5, -444.9844718999242}, 
      ImageScaled[{0.5, 0.5}], {360., 222.4922359499621}]}}, {}},
  ContentSelectable->True,
  ImageSize->500,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{{3.6247978436045265`*^9, 3.624797848830594*^9}, {
   3.6247978910759354`*^9, 3.6247979069569387`*^9}, 3.624797954117344*^9, {
   3.6247980705768375`*^9, 3.6247981116901875`*^9}, 3.6247981932653437`*^9, {
   3.6247982250135183`*^9, 3.624798245136531*^9}, {3.6247983983898544`*^9, 
   3.624798426977285*^9}, {3.624798457272873*^9, 3.62479847182886*^9}, 
   3.624798540003734*^9, 3.6247985729669566`*^9, {3.62479860828681*^9, 
   3.6247986134348755`*^9}, 3.624798923635253*^9, 3.6247989782837534`*^9, 
   3.6247990275647855`*^9, 3.62481065422398*^9, 3.624811499676525*^9}],

Cell[BoxData["\<\"c:/dropbox/mystuff/BehrensFisher/Figures/power2.pdf\"\>"], \
"Output",
 CellChangeTimes->{{3.6247978436045265`*^9, 3.624797848830594*^9}, {
   3.6247978910759354`*^9, 3.6247979069569387`*^9}, 3.624797954117344*^9, {
   3.6247980705768375`*^9, 3.6247981116901875`*^9}, 3.6247981932653437`*^9, {
   3.6247982250135183`*^9, 3.624798245136531*^9}, {3.6247983983898544`*^9, 
   3.624798426977285*^9}, {3.624798457272873*^9, 3.62479847182886*^9}, 
   3.624798540003734*^9, 3.6247985729669566`*^9, {3.62479860828681*^9, 
   3.6247986134348755`*^9}, 3.624798923635253*^9, 3.6247989782837534`*^9, 
   3.6247990275647855`*^9, 3.62481065422398*^9, 3.6248115001445312`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pbp", "[", 
  RowBox[{"4", ",", "16", ",", "3", ",", "1", ",", "0"}], "]"}]], "Input",
 CellChangeTimes->{{3.625231893408774*^9, 3.6252319114885817`*^9}}],

Cell[BoxData[
 RowBox[{"0.005611859967525001`", "\[VeryThinSpace]", "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellChangeTimes->{{3.625231899538387*^9, 3.625231911930626*^9}}]
}, Open  ]]
},
WindowSize->{1574, 849},
WindowMargins->{{Automatic, 356}, {Automatic, 25}},
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (November 20, 2012)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 15878, 428, 1322, "Input"],
Cell[16460, 452, 936, 14, 44, "Output"],
Cell[17399, 468, 936, 14, 44, "Output"],
Cell[18338, 484, 1140, 20, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19515, 509, 1250, 34, 162, "Input"],
Cell[20768, 545, 267, 5, 44, "Output"],
Cell[21038, 552, 267, 5, 44, "Output"],
Cell[21308, 559, 377, 9, 44, "Output"],
Cell[21688, 570, 95951, 1610, 632, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[117676, 2185, 561, 15, 75, "Input"],
Cell[118240, 2202, 95868, 1609, 389, "Output"],
Cell[214111, 3813, 228, 3, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[214376, 3821, 1256, 34, 162, "Input"],
Cell[215635, 3857, 270, 6, 65, "Output"],
Cell[215908, 3865, 238, 5, 44, "Output"],
Cell[216149, 3872, 413, 11, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[216599, 3888, 1061, 22, 75, "Input"],
Cell[217663, 3912, 130605, 2195, 366, "Output"],
Cell[348271, 6109, 679, 9, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[348987, 6123, 178, 3, 45, "Input"],
Cell[349168, 6128, 193, 3, 44, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
