** This do file runs all the tables in Obstfeld Shambaugh and Taylor AEJmacro
** open the datafile "OSTdatatoshare" and then run this file
** the outreg commands are "**" and not currently in use.  If you have installed outreg and want to generate the tables automatically, unstar them

* first run the core regressions so we can limit to same sample
clear all
use "C:\Dropbox\mystuff\BehrensFisher\Replication\Obstfeld_etal\OSTdata_mod.dta"

sort ifs year
reg lnresgdp lpop lnimportsgdp evol lngdppercap if year > 1979   , cluster(ifs) 
gen samp1 = 0
replace samp1 = 1 if e(sample) == 1
reg lnresgdp newkopen2 peg lnm2gdp lntradegdp advanced if year > 1979  , cluster(ifs) 
gen samp2 = 0
replace samp2 = 1 if e(sample) == 1

** Table 1  HORSERACE

reg lnresgdp lpop lntradegdp evol lngdppercap if year > 1979  & samp1 == 1 & samp2 == 1, cluster(ifs) 
*outreg lpop lntradegdp evol lngdppercap using OSTtab1 , se nolabel noparen bdec(3) 10pct  ctitle("OLD no FE ") replace

reg lnresgdp newkopen2 lpop lntradegdp evol lngdppercap if year > 1979  & samp1 == 1 & samp2 == 1, cluster(ifs) 
*outreg newkopen2 lpop lntradegdp evol lngdppercap using OSTtab1 , se nolabel noparen bdec(3) 10pct  ctitle(" no FE ") append

reg lnresgdp peg softpeg lpop lntradegdp evol lngdppercap if year > 1979  & samp1 == 1 & samp2 == 1, cluster(ifs) 
*outreg peg softpeg lpop lntradegdp evol lngdppercap using OSTtab1 , se nolabel noparen bdec(3) 10pct  ctitle(" no FE ") append

reg lnresgdp lnm2gdp lpop lntradegdp evol lngdppercap if year > 1979   & samp1 == 1 & samp2 == 1, cluster(ifs) 
*outreg lnm2gdp lpop lntradegdp evol lngdppercap using OSTtab1 , se nolabel noparen bdec(3) 10pct  ctitle(" no FE ") append




reg lnresgdp newkopen2 peg softpeg lnm2gdp lntradegdp advanced lpop evol lngdppercap if year > 1979 & samp1 == 1 & samp2 == 1, cluster(ifs) 
*outreg newkopen2 peg softpeg lnm2gdp lntradegdp advanced lpop evol lngdppercap using OSTtab1 , se nolabel noparen bdec(3) 10pct  ctitle("horserace ") append

**********************************************
*The regressions below determine estimates and standard errors for selected financial stability variables newkopen2 (financial stability), peg (peg), softpeg (soft peg), lnm2gdp (ln(M2/GDP))
*Standard errors are clustered by ifs (country), and each regression is run seperately for each value of coarsecluster (broader geographic region)
*From top to bottom, the rows of each matrix corresponds to estimates for newkopen2, peg, softpeg, and lnm2gdp in each of seven regions (sorted by column)
**********************************************

egen group2 = group(coarsecluster)
sum group2
scalar numgroups = r(max)

scalar tempnum = 0
matrix betas = (.\ .\.\ .)
matrix SEs = (. \ .\ .\ .)
forvalues X=1/`=numgroups'{
	sum lnresgdp newkopen2 peg softpeg lnm2gdp advanced lntradegdp lpop evol lngdppercap if year > 1979 & samp1 == 1 & samp2 == 1 & group2 == `X'
	scalar tempnum = r(N)
	if tempnum > 0{
	reg lnresgdp newkopen2 peg softpeg lnm2gdp advanced lntradegdp lpop evol lngdppercap if year > 1979 & samp1 == 1 & samp2 == 1 & group2 == `X', cluster(ifs)
	matrix betatemp = (_b[newkopen2]\ _b[peg]\ _b[softpeg]\ _b[lnm2gdp])
	matrix betas = (betas, betatemp)
	matrix SEstemp = (_se[newkopen2]\ _se[peg]\ _se[softpeg]\ _se[lnm2gdp])
	matrix SEs = (SEs, SEstemp)
	sum ifscode if group2 == `X'
	scalar tempnum2 = r(mean)
**	matrix countryid = (countryid \ tempnum2)
	}
}


matrix list betas
matrix list SEs




