#include <oxstd.h>	   
#include <arma.h>
#include <oxprob.h>
#include <oxdraw.h>
#include <oxfloat.h>
 

decl loops=10000;
decl sn=10000;

main()
{
	format(5000);
	decl Ts={5,10,20};
	decl qs={4,8,16};
	decl rhos={0,.5};
	decl sigs={1,2};
	decl dists={TRUE,FALSE};

	decl outtabs=new array[4];
	outtabs[]=zeros(6,12);

	for(decl Tlc=0;Tlc<3;Tlc++)
	for(decl qlc=0;qlc<3;qlc++)
	for(decl rlc=0;rlc<2;rlc++)
	for(decl slc=0;slc<2;slc++)
	for(decl dlc=0;dlc<2;dlc++){
	
	decl T=Ts[Tlc], q=qs[qlc], rho=rhos[rlc], sig=sigs[slc], dist=dists[dlc];
	decl RP=0;
	decl RPOLS,RPIM,RPswitch;
	RPOLS=RPIM=RPswitch=RP;
	ranseed(12);
	for(decl lc=0;lc<loops;lc++){
		decl y=rann(T,q);
		if(!dist) y=sqr(y)-1;
		y[][0:q/2-1]*=sig;
		y=cumsum(y,rho);
		decl V=varr(meanc(y));
		decl shat=sqrt(varc(y)/(T-1));
		decl clustertest=meanc(varr(rann(sn,q).*shat).>V).<0.05;
		RP+=meanc(varr(rann(sn,q).*shat).>V).<0.05;

		decl OLSttest=fabs((q*T)^.5*meanr(meanc(y))/sqrt((q*T/(q*T-1))*varc(vec(y))))>quant(0.975,q*T-1);
		RPOLS+=OLSttest;
		decl IMttest=fabs((q^.5*meanr(meanc(y))/sqrt((q/(q-1))*varr(meanc(y)))))>quant(0.975,q-1);
		RPIM+=IMttest;
		RPswitch+=clustertest?IMttest:OLSttest;
	}
	outtabs[0][qlc+3*dlc][6*rlc+3*slc+Tlc]=RP/loops;
	outtabs[1][qlc+3*dlc][6*rlc+3*slc+Tlc]=RPswitch/loops;
	outtabs[2][qlc+3*dlc][6*rlc+3*slc+Tlc]=RPIM/loops;
	outtabs[3][qlc+3*dlc][6*rlc+3*slc+Tlc]=RPOLS/loops;

	print(outtabs);

	}
}

		
			
