#include <oxstd.h>
#include <arma.h>
#include <database.h>
#include <oxdraw.h>
#include <oxfloat.h>

decl alpha;

decl l1,l2,w0,w1,w2;

g(const s)
{
	return s.^(.5*(l1+l2+3)).*(s+w0).^(-.5).*(s+w1).^(-.5*l1).*(s+w2).^(-.5*l2);
}

g2(const s)
{
	return s.^(.5*(l1+l2+2)).*(s+w1).^(-.5*l1).*(s+w2).^(-.5*l2);
}

F1(const s)
{	return -2*sqrt((1-s)./s);
}

F2(const s)
{	return 2*asin(sqrt(s));
}

Jup(const q)
{
	if(w0>0.0){
		decl i=range(2,q);
		decl J=sumr( ( i.*g((i-1)/q)-(i-1).*g(i/q) )  .* (F1(i/q)-F1((i-1)/q))   );
		i=range(1,q);
		J+=q*sumr((g(i/q)-g((i-1)/q)).*(F2(i/q)-F2((i-1)/q)));
		return J/M_PI;
	}
	decl i=range(2,q);
	decl J=sumr( ( i.*g2((i-1)/q)-(i-1).*g2(i/q) )  .* (F1(i/q)-F1((i-1)/q))   );
	i=range(1,q);
	J+=q*sumr((g2(i/q)-g2((i-1)/q)).*(F2(i/q)-F2((i-1)/q)));
	return J/M_PI;
}

main()
{
	format(5000);
	decl alist=range(0.001,0.10,0.001)';
	decl initime=timer();
	
	decl nmax;
	for(decl ia=0;ia<rows(alist);ia++){
	alpha=alist[ia];
	if(alpha<=0.083+1E-5)
		nmax=50;
	else
		nmax=14;

	for(decl m=2;m<=nmax;m++){
	print(alpha~m,timespan(initime));		

	for(decl n=2;n<=nmax;n++){
		decl cv=quant(1-alpha/2,min(m,n)-1)^2;
		for(decl ms=1;ms<=m;ms++)
		for(decl ns=1;ns<=n;ns++){
			decl M=0;
			decl dn=sqr(ns)*(1/sqr(n)-cv*((n-ns)/(ns*sqr(n)*(n-1))));	
			decl dm=sqr(ms)*(1/sqr(m)-cv*((m-ms)/(ms*sqr(m)*(m-1))));
			if(dm<0 && dm*(dn*dm-sqr(ms*ns/(m*n)))<0){
				continue
				};
			if(dn>0){
				decl k0=dn/ns;
				decl k1=max(dm/ms,ms*sqr(ns)/(dn*sqr(m*n)));
				decl h=sqrt(ms*k1/(ns*k0));
				decl psi0=-(k0/ms)*(dn*sqr(h)-2*h*ms*ns/(m*n)+dm);
				psi0=(psi0<=0)? 0.0 : psi0;
				w0=psi0/(k0+k1)^2;
				w1=cv/(n*(n-1)*(k0+k1));
				w2=cv/(m*(m-1)*(k0+k1));
				l1=ns-1;
				l2=ms-1;
				if(Jup(100)<alpha) {
					continue
				};
			}			
			M=1;
			l1=ns-1;l2=ms-1;
			decl maxJ=1.0;
			while(maxJ>alpha){
				M*=2;
				maxJ=0.0;
				for(decl i=1;i<=M;i++){
					decl b=(i-1)/M	;
					decl s,evmin;
					if(b==0) evmin=max(-dn/ns,0.0);
					else {
						s=- (dn*m*ms*n-sqr(b)*dm*m*n*ns+sqrt(4*sqr(b)*ms^3*ns^3+sqr(dn*m*ms*n-sqr(b)*dm*m*n*ns)))/(2*b*sqr(ms)*ns);
						evmin=-(dn+2*s*ms*ns*b/(m*n)+s^2*dm*b^2)/(ns+s^2*ms);
					}
					b=i/M	;
					s=- (dn*m*ms*n-sqr(b)*dm*m*n*ns-sqrt(4*sqr(b)*ms^3*ns^3+sqr(dn*m*ms*n-sqr(b)*dm*m*n*ns)))/(2*b*sqr(ms)*ns);
					decl evmax=(dn+2*s*ms*ns*b/(m*n)+s^2*dm*b^2)/(ns+s^2*ms);
					w0=cv*evmin/evmax;
					w1=cv/(n*(n-1)*evmax);
					w2=sqr((i-1)/M)*cv/(m*(m-1)*evmax);
					maxJ=max(maxJ,Jup(100));
				}
				if(M>10000) {print("bound doesn't work for ",m~n~ms~ns~M~maxJ); exit(0);}
	
			}
			
		}
	}
	}
	}
}