module basicmodule
	use myfuncs
	use dotops
	use ziggurat
	use lapack95, only: potrf,potrs,getrs
	use ML
	
	implicit none
	
	logical, parameter	:: realrun=.true.		! false is for Geweke check of sampler correctness
	
	integer, parameter	:: nphi=merge(12,3,realrun)
	integer, parameter	:: nld=min(merge(merge(nphi,6,nphi==4),2,realrun),nphi)
	integer, parameter	:: nh=nphi

	integer				:: nfac=0,n=2,na,np,nsv,nmu
	
	integer				:: capT=merge(500,2,realrun), ntcoefs
	real				:: largestev_cutoff=0.9, s2mui=merge(100.0,.1**2,realrun)
	
	real, allocatable	:: r_ys(:,:),ys(:,:),ymus(:,:),loads(:,:,:,:)
	real, allocatable	:: s2bs(:,:),s2s(:,:),s2beos(:,:),s2eos(:,:),phis(:,:,:),us(:,:),eos(:,:)
	real, allocatable	:: acholini(:,:,:)
	real, allocatable	:: s2phi(:,:,:),s2loads(:,:,:,:)
	real, allocatable	:: s2phi_prior(:,:,:),s2phi_prior_prior(:,:,:,:)
	real, allocatable	:: s2coefs(:,:) !s2coefs(ntcoefs+3,0:na)
	real				:: s2coefs_var(4),s2coefs_prior_prior(4,2,0:1)
	integer, parameter	:: oeo=1,omud=2,ou0=3,oup=4
	integer				:: ns2c
	
	real, allocatable	:: tdfs(:)	
	real				:: tdf_var, tdf_prior_prior(2,0:1)
	real, allocatable	:: tdfes(:)	
	real				:: tdfe_var, tdfe_prior_prior(2,0:1)
	
	real, allocatable	:: s2loads_prior_prior(:,:,:,:)
	real, allocatable	:: s2loads_prior(:,:,:,:)
	logical,allocatable	:: missing(:,:)
	real, allocatable	:: cost(:,:),acost(:)
	real				:: df_offset=2.0, df_max=10000.0
	real				:: s2fac_prior(2)
	character(len=20)	:: data_name
	real, parameter		:: maxs2phid=merge(.02**2,10.0**2,realrun)
	real, parameter		:: maxs2loadd=merge(.02**2,10.0**2,realrun)
	real				:: global_eo_mud_prior(2,2)	
	
	real				:: tgs2			! global log-variance parameter
	real, parameter		:: gs2_prior(2)=[0.0,merge(1E6,3.3,realrun)]
	
	logical	:: runflags(5)=.true.
	integer, parameter	:: ohp=1,ot=2,oe=3,osv=4,otvp=5
	
	integer, allocatable	:: ipivot(:)
	real, allocatable		:: mys(:,:)
	integer,allocatable		:: transcode(:)
	
	integer					:: imh=0			! imh>0 toggles mh draws that isolate one component to adjust step size
	real, dimension(0:8,15)	:: mhscales, mhscales0, acc, accx
	real, allocatable		:: accj(:,:,:)
	integer					::	os2coefs=1, os2coefs_var=2, os2eglobal=3, os2mudglobal=4, os2phi=5, os2phi_prior=6, ofs_fast=7, odf_prior=8, otdfs=9, oas2load=10, oas2load_prior=11, odfe_prior=12,  otdfes=13, ogymus=14, ogeos=15
	integer:: imhmax(size(mhscales,2))=[4         ,8				,0            ,0		,0           ,4           ,2           ,6          ,3        ,0,         4					,4					,2        ,0		,0]
	contains
	
	function getrun_name() result(val)
		character(len=40)	:: val
		integer	:: i
		val=trim(data_name)
		do i=1,size(runflags)
			val=trim(val)//merge("T","F",runflags(i))
		enddo
		val=trim(val)//convtos(nfac)
	end function
	

	function get_gamma_from_phi(phi) result(val)
		use lapack95, only: getrf,getrs
		real ::	phi(nphi), val(nphi),r(0:nphi,1)
		real	:: A(0:nphi,0:nphi)
		integer	:: i,j,ipiv(0:nphi)
		
		do i=0,nphi
			a(:,i)=0
			a(i,i)=1
			do j=1,nphi
				A(abs(j-i),i)=A(abs(j-i),i)-phi(j)
			enddo
		enddo
		
		call getrf(A,ipiv)
		r(1:,1)=0
		r(0,1)=1
		call getrs(A,ipiv,r,'T')
		val=r(0:nphi-1,1)
	end function
	
	function getll_startup(j,s2) result(val)
		real	:: s2,val
		integer	:: j
		val=-.5*sum(matmul(acholini(:,:,j),us(-nphi+1:0,j))**2)/s2-.5*nphi*log(s2)
	end function

	function adjust_phi(phi) result(val)
		use lapack95, only: gees
		real	:: phi(nphi),val(nphi)
		real	:: A(nphi,nphi), evr(nphi),evi(nphi),rn
		complex	:: r(nphi),pc(nphi+1),pcx(nphi+1)
		complex, parameter	:: cmplxone=(1.0,0.0), cmplxzero=(0.0,0.0)
		integer	:: i,j
		
		A(1,:)=phi
		A(2:,:)=0
		do i=1,nphi-1
			A(i+1,i)=1
		enddo
		if(nphi==1) then
			evr=a(1,1); evi=0
		else
			call gees(A,evr,evi)
		endif
		rn=sqrt(maxval(evr**2+evi**2))		
		if(rn<largestev_cutoff) then
			val=phi
			return
		endif
		r=cmplx(evr,evi)
		r=(largestev_cutoff/rn)*r
		pc=0
		pc(1)=-r(1)
		pc(2)=cmplxone
		do i=2,size(r)
			pcx(1:i)=pc(1:i)
			pc(1:i)=-r(i)*pc(1:i)
			pc(2:i+1)=pc(2:i+1)+pcx(1:i)
		enddo
		val=-real(pc(nphi:1:-1))
	end function
	
	function getlargestev(phi) result(val)
		use lapack95, only: gees
		real	:: phi(nphi),val
		real	:: A(nphi,nphi), evr(nphi),evi(nphi)
		integer	:: i,j
		
		A(1,:)=phi
		A(2:,:)=0
		do i=1,nphi-1
			A(i+1,i)=1
		enddo
		call gees(A,evr,evi)
		val=sqrt(maxval(evr**2+evi**2))
	end function
	
	subroutine set_cost
		integer	:: t,i
		real	:: sig(capT,capT),tmp(ntcoefs)
		do t=1,capT
			do i=1,capT
				sig(i,t)=real(min(i,t)-1) !/capT
			enddo
			do i=1,ntcoefs
				cost(i,t)=sqrt(2.0)*cos(Pi*(t-.5)*i/real(capT))
			enddo
		enddo
		acost=cost(1:,1)
		do i=1,ntcoefs
			cost(i,:)=cost(i,:)*sqrt(sum(cost(i,:)*matmul(sig,cost(i,:))))/capT
			acost(i)=maxval(cost(i,:))
		enddo
		acost=acost/maxval(acost)
		cost(0,:)=1.0
		if(.not.runflags(osv)) cost(1:,:)=0
	end subroutine
		
	subroutine invertL(L,Li)
        real    :: L(:,:),Li(:,:)
        real    :: Lx(size(L,1),size(L,1))
        integer :: i
        Li=eye(size(L,1))
		call getrs(transpose(L),ipivot(1:size(L,1)),Li,"T")
	end subroutine
	
end module