module compute
	use draw_phi_mod
	use draw_factors
	use draw_muy_mod
	use draw_loads_mod
	use draw_globals
	use draw_gymus_mod
	use draw_geos_mod
	use StochVola
	use fcst
	use data_mod
	implicit none
	
	contains
	
	subroutine prep
		integer	:: i,j,t,l
		
		mhscales=0.0/0.0
		mhscales(0:4,os2coefs)=[0.5,1.0,1.0,1.0,2.0]
		mhscales(0:8,os2coefs_var)=[0.25,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0]
		mhscales(0:0,os2eglobal)=[2.5]
		mhscales(0:0,os2mudglobal)=[2.5]
		mhscales(0:0,os2phi)=[1.5]
		mhscales(0:4,os2phi_prior)=[.5,1.0,3.0,1.0,3.0]
		mhscales(0:2,ofs_fast)=[.5,2.0,2.0]
		mhscales(0:6,odf_prior)=[.5,5.0,5.0,3.0,3.0,3.0,3.0]
		mhscales(0:3,otdfs)=[.5,3.0,3.0,3.0]
		mhscales(0:0,oas2load)=[1.0]
		mhscales(0:4,oas2load_prior)=[.5,4.0,3.0,3.0,3.0]
		mhscales(0:4,odfe_prior)=[.5,5.0,5.0,5.0,5.0]
		mhscales(0:2,otdfes)=[1.0,2.0,2.0]
		mhscales(0:0,ogymus)=[2.0]
		mhscales(0:0,ogeos)=[2.0]

		mhscales0=mhscales
		if(allocated(accj)) deallocate(accj)
		allocate(accj(lbound(mhscales,1):ubound(mhscales,1),size(mhscales,2),na))
				
		do i=1,nphi
			s2phi(i,1,:)=(.3/i)**2
			s2phi(i,2,:)=(.2/(i))**2
		enddo	
		s2s=1
		do j=1,n
			do l=1,nfac
				do t=1,capT
					call rnnoa(loads(:,t,l,j))
				enddo
			enddo
		enddo
		
		loads=1
		loads(:,-nphi+1:0,:,:)=0
		ymus=0
		do j=1,n
			call rnnoa(us(:,j))
		enddo
		s2loads=0.2
	
		s2loads_prior(:,:,2,:)=1
		s2loads_prior(:,:,1,:)=log(.2)
		s2loads_prior_prior(:,:,:,2)=0.4**2
		s2loads_prior_prior(:,:,1,1)=log(.2)
		s2loads_prior_prior(:,:,2,1)=log(0.1)
		s2loads_prior_prior(1,1,1,2)=0.2**2		! this is the variance of first factor; all other variances normalized to unity
		
		s2s=1
		
		s2fac_prior=[-.2,.4]
		global_eo_mud_prior(:,1)=[-.5,-1.3]
		global_eo_mud_prior(:,2)=[2.0,0.2]
		
		phis=0
		do i=1,2
			do j=1,2
				call rnnoa(s2phi_prior_prior(:,:,i,j))
			enddo
		enddo
		s2phi_prior_prior(:,:,:,2)=exp(s2phi_prior_prior(:,:,:,2))

		do i=1,nphi
			s2phi(i,1,:)=.1**2/i**2
			s2phi(i,2,:)=.02**2/i**2
			s2phi(i,2,np+1:)=0
		enddo	
  
		s2phi_prior(:,1,1)=0					! common value of coefficients
		s2phi_prior(:,2,1)=s2phi(:,1,1)			! variance of initial value (constant across series)
		s2phi_prior(:,1,2)=log(s2phi(:,2,1))	! mean value of variance of TV
		s2phi_prior(:,2,2)=s2phi(:,2,1)			! variance of variance of TV across series
  
  
		s2phi_prior_prior(:,1,1,1)=s2phi_prior(:,1,1)
		s2phi_prior_prior(:,2,1,1)=log(s2phi_prior(:,2,1))
		s2phi_prior_prior(:,1,2,1)=s2phi_prior(:,1,2)
		s2phi_prior_prior(:,2,2,1)=log(s2phi_prior(:,2,2))
		
		s2phi_prior_prior(:,:,:,2)=4
		s2phi_prior_prior(:,1,1,2)=s2phi(:,1,1)	
				
		tdf_prior_prior(1,0)=log(5-df_offset)		! mean of common shifter
		tdf_prior_prior(2,0)=1						! variance of common shifter
		tdf_prior_prior(1,1)=log(1.0**2)			! variance across series
		tdf_prior_prior(2,1)=1
		
		tdfe_prior_prior(1,0)=log(6-df_offset)		! mean of common shifter
		tdfe_prior_prior(2,0)=.5						! variance of common shifter
		tdfe_prior_prior(1,1)=log(0.3**2)			! variance across series
		tdfe_prior_prior(2,1)=.8

		s2coefs_prior_prior(:,1,1)=log(0.7**2)
		s2coefs_prior_prior(:,2,1)=.5**2

		s2coefs_prior_prior(oeo,1,0)=log(0.1*2)
		s2coefs_prior_prior(omud,1,0)=log((.1)**2)
		s2coefs_prior_prior(ou0,1,0)=0
		s2coefs_prior_prior(oup,1,0)=0
		s2coefs_prior_prior(:,2,0)=.2**2
		
		if(nfac>0) then
			do l=1,nfac
				s2s(:,n+l)=.1**2/l**2
				s2fac_prior=[log(s2s(1,n+l)),4.0]
				do i=1,nld
					s2loads(i,1,l,:)=merge(merge(1.0**2,1.0,l==1),.1**2/(i-1)**2,i==1)
					s2loads(i,2,l,:)=merge((.001)**2,0.001**2/(i-1)**2,i==1)	!*s2loads(i,1,l,:)
				enddo	
			enddo
		
			s2loads_prior(:,1,1,:)=0						! common mean
			s2loads_prior(1,1,1,1)=1
			s2loads_prior(:,2,1,:)=s2loads(:,1,:,1)			! variance of initial value (constant across series)
			s2loads_prior(:,1,2,:)=log(s2loads(:,2,:,1))	! mean value of variance of innovation
			s2loads_prior(:,2,2,:)=s2loads(:,2,:,1)			! variance of innovation variance across series
			
			s2loads_prior_prior(:,1,:,1)=s2loads_prior(:,1,:,1)
			s2loads_prior_prior(:,2,:,1)=log(s2loads_prior(:,2,:,1))
			s2loads_prior_prior(:,:,:,2)=2**2
			s2loads_prior_prior(:,1,1,2)=s2loads(:,1,1,1)	! variance of common values equal to baseline variance 
			s2loads_prior_prior(1,1,1,2)=0					! common contemporaneous mean is fixed 
		endif

		missing=.false.
	end subroutine
	
	subroutine prep_real	
		integer	:: i,j,t,l
		real, parameter		:: hpvar_def=0.5**2

		largestev_cutoff=0.98
		us=0
		
		mhscales=0.0/0.0
		mhscales(0:4,os2coefs)=[0.4,35.0,20.0,3.0,2.0]
		mhscales(0:8,os2coefs_var)=[0.25,40.0,10.0,3.0,20.0,150.0,25.0,8.0,8.0]
		mhscales(0:0,os2eglobal)=[5.0]
		mhscales(0:0,os2mudglobal)=[2.5]
		mhscales(0:0,os2phi)=[5.0]
		mhscales(0:4,os2phi_prior)=[.5,25.0,80.0,50.0,100.0]
		mhscales(0:2,ofs_fast)=[.5,5.0,5.0]
		mhscales(0:6,odf_prior)=[.4,40.0,20.0,10.0,10.0,10.0,20.0]
		mhscales(0:3,otdfs)=[.3,10.0,2.0,3.0]
		mhscales(0:0,oas2load)=[10.0]
		mhscales(0:4,oas2load_prior)=[.5,60.0,40.0,40.0,50.0]
		mhscales(0:4,odfe_prior)=[.4,100.0,30.0,10.0,50.0]
		mhscales(0:2,otdfes)=[0.5,20.0,10.0]
		mhscales(0:0,ogymus)=[3.0]
		mhscales(0:0,ogeos)=[2.5]
		
		mhscales0=mhscales
		if(allocated(accj)) deallocate(accj)
		allocate(accj(lbound(mhscales,1):ubound(mhscales,1),size(mhscales,2),na))

		missing=.false.
		missing(1:capT+nh,1:n)=.not. isfinite(r_ys(1:capT+nh,1:n))
		do j=1,n
			do t=1,capT
				if(missing(t,j)) then
					call rnnoa(us(t:t,j))
				else
					us(t,j)=r_ys(t,j)
				endif
			enddo
		enddo
		phis=0
		if(nfac>0) then
			loads=0
			loads(1,1:capT,1,:)=1
		endif

		ymus=0; eos=0
		
		do i=1,nphi
			s2phi(i,1,:)=.2**2/i**2
			s2phi(i,2,:)=merge(.005**2/i**2,1E-20,runflags(otvp))
			s2phi(i,1,np+1:)=.2**2/i**2
			s2phi(i,2,np+1:)=0
		enddo	

		s2phi_prior(:,1,1)=0					! common value of coefficients
		s2phi_prior(:,2,1)=s2phi(:,1,1)			! variance of initial value (constant across series)
		s2phi_prior(:,1,2)=log(s2phi(:,2,1))	! mean value of variance of TV
		s2phi_prior(:,2,2)=0.3**2				! variance of variance of TV across series


		s2phi_prior_prior(:,1,1,1)=s2phi_prior(:,1,1)
		s2phi_prior_prior(:,2,1,1)=log(s2phi_prior(:,2,1))
		s2phi_prior_prior(:,1,2,1)=s2phi_prior(:,1,2)
		s2phi_prior_prior(:,2,2,1)=log(s2phi_prior(:,2,2))
		
		s2phi_prior_prior(:,:,:,2)=hpvar_def
		s2phi_prior_prior(:,1,1,2)=0.5**2*s2phi(:,1,1)	
		
		tdfs=log(12-df_offset)
		tdf_var=0.5**2
		
		tdf_prior_prior(1,0)=tdfs(0)				! mean of common shifter
		tdf_prior_prior(2,0)=hpvar_def						! variance of common shifter
		tdf_prior_prior(1,1)=log(tdf_var)			! variance across series
		tdf_prior_prior(2,1)=hpvar_def
		
		tdfes=log(4-df_offset)
		tdfe_var=0.5**2
		
		tdfe_prior_prior(1,0)=tdfes(0)				! mean of common shifter
		tdfe_prior_prior(2,0)=hpvar_def				! variance of common shifter
		tdfe_prior_prior(1,1)=log(tdfe_var)			! variance across series
		tdfe_prior_prior(2,1)=hpvar_def

		s2bs=1;   s2s=1
		s2beos=1; s2eos=merge(0.1**2,1E10,runflags(oe))
		s2coefs(oeo,:)=log(s2eos(1,1))
		s2coefs(omud,:)=log(merge(.005**2,1E-20,runflags(otvp)))

		if(nfac>0) then
			global_eo_mud_prior(:,1)=s2coefs([oeo,omud],n+1)
			global_eo_mud_prior(:,2)=hpvar_def
			global_eo_mud_prior(omud,2)=4			! allow for more RW variation
		endif	
		
		s2coefs(ou0,:)=log(s2s(1,1))
		s2coefs(oup:,:)=0
		
		s2coefs_var=0.3**2
		
		s2coefs_var(oup)=.01**2 
		
		s2coefs_prior_prior(oeo,1,0)=s2coefs(oeo,0)		
		s2coefs_prior_prior(omud,1,0)=s2coefs(omud,0)
		s2coefs_prior_prior(ou0,1,0)=s2coefs(ou0,0)
		s2coefs_prior_prior(:,2,0)=hpvar_def
		s2coefs_prior_prior(omud,2,0)=4			! allow for more random walk variation
		s2coefs_prior_prior(oup,2,0)=0.01**2		! variance for common stochastic volatility
		
		s2coefs_prior_prior(:,1,1)=log(s2coefs_var)		! mean for log-variance across series 
		s2coefs_prior_prior(:,2,1)=hpvar_def

		tgs2=0
		
		
		if(nfac>0) then
			do l=1,nfac
				s2s(:,n+l)=.2**2
				s2coefs(ou0,n+l)=log(s2s(1,n+l))
				s2fac_prior=[s2coefs(ou0,n+l),1.0]
				do i=1,nld
					s2loads(i,1,l,:)=merge(merge(0.2**2,1.0,l==1),.05**2/(i-1)**2,i==1)
					s2loads(i,2,l,:)=merge(merge((0.005)**2,(0.005)**2/i**2,i==1),1E-20,runflags(otvp))	!*s2loads(i,1,l,:)
				enddo	
			enddo
		
			s2loads_prior(:,1,1,:)=0						! common mean
			s2loads_prior(1,1,1,1)=1						! one for contemporaneous first factor
			s2loads_prior(:,2,1,:)=s2loads(:,1,:,1)			! variance of initial value (constant across series)
			s2loads_prior(:,1,2,:)=log(s2loads(:,2,:,1))	! mean value of variance of innovation
			s2loads_prior(:,2,2,:)=0.3**2  !s2loads(:,2,:,1)			! variance of innovation variance across series
			
			s2loads_prior_prior(:,1,:,1)=s2loads_prior(:,1,:,1)
			s2loads_prior_prior(:,2,:,1)=log(s2loads_prior(:,2,:,1))
			s2loads_prior_prior(:,:,:,2)=hpvar_def
			
			s2loads_prior_prior(:,1,1,2)=0.5**2*s2loads(:,1,1,1)	! variance of common values equal to baseline variance 
			s2loads_prior_prior(1,1,1,2)=0					! common contemporaneous mean is fixed 
		endif
		
		do j=1,na
			acholini(:,:,j)=eye(nphi)
		enddo

	end subroutine
	
	function get_hps() result(val)
		real	:: val(51,4)
		real, parameter		:: nan=0.0/0.0,nan4(4)=nan
		integer	:: i,l
		i=1
		l=1;
		val(i:i+l-1,1)=exp(tgs2)*mys(2,1)**2
		val(i:i+l-1,2)=1.0/0.0
		val(i:i+l-1,3)=s2coefs(omud,0)-tgs2
		val(i:i+l-1,4)=s2coefs_var(omud)
		val(i+l,:)=nan; i=i+l+1

		l=1
		val(i:i+l-1,1)=s2coefs(ou0,0)-tgs2
		val(i:i+l-1,2)=s2coefs_var(ou0)
		val(i:i+l-1,3)=nan
		val(i:i+l-1,4)=nan
		val(i+l,:)=nan; i=i+l+1

		l=nphi
		val(i:i+l-1,1)=s2phi_prior(:,1,1)
		val(i:i+l-1,2)=s2phi_prior(:,2,1)
		val(i:i+l-1,3)=s2phi_prior(:,1,2)
		val(i:i+l-1,4)=s2phi_prior(:,2,2)
		val(i+l,:)=nan; i=i+l+1

		l=1
		if(runflags(ot)) then
			val(i:i+l-1,1)=tdfs(0)
			val(i:i+l-1,2)=tdf_var
		endif
		if(runflags(oe)) then
			val(i:i+l-1,3)=tdfes(0)
			val(i:i+l-1,4)=tdfe_var
		endif
		val(i+l,:)=nan; i=i+l+1

		l=1
		val(i:i+l-1,1)=s2coefs(oeo,0)-tgs2
		val(i:i+l-1,2)=s2coefs_var(oeo)
		val(i:i+l-1,3)=nan
		val(i:i+l-1,4)=nan
		val(i+l,:)=nan; i=i+l+1
				
		l=nld
		if(nfac>0) then
			val(i:i+l-1,1)=s2loads_prior(:,1,1,1)
			val(i:i+l-1,2)=s2loads_prior(:,2,1,1)
			val(i:i+l-1,3)=s2loads_prior(:,1,2,1)
			val(i:i+l-1,4)=s2loads_prior(:,2,2,1)
		endif
		val(i+l,:)=nan; i=i+l+1

		l=ntcoefs
		if(otvp) then
			val(i:i+l-1,1)=s2coefs(oup:,0)
			val(i:i+l-1,2)=s2coefs_var(oup)
		endif
	end function		
	
	subroutine check
		real	:: delta(1:capT,n)
		integer	:: i,j,t
		delta=us(1:capT,1:n)
		do j=1,n
			delta(:,j)=delta(:,j)+ymus(:,j)+eos(:,j)+ymus(:,n+1)+eos(:,n+1)
			do t=1,capT
				delta(t,j)=delta(t,j)+sum(loads(:,t,1,j)*us(t:t-nld+1:-1,n+1))
			enddo
		enddo
		delta=delta-r_ys(1:capT,1:n)
		print *,maxval(abs(delta))	
	end subroutine 
	
	subroutine draw_all_adjust(l)
		integer	:: j,l,i
!$omp parallel do 
		do j=1,n
			call add_ymus(j)
		enddo
		if(runflags(ohp)) then
			do imh=0,imhmax(os2coefs_var)
				call draw_s2coefs_var
			enddo
		endif
		do imh=0,imhmax(os2coefs)
!$omp parallel do
			do j=1,n
				call draw_s2coefs(j)
			enddo
		enddo
!$omp parallel do 
		do j=1,n
			call draw_ymu_ustartup(j)
		enddo
		if(runflags(ohp))	call draw_phi1_0
		if(nfac>0)	then
			imh=0
			call draw_gymus
			call draw_geos
			call set_globals_mV
			if(runflags(oe)) call draw_s2eglobal
			call draw_s2mudglobal
			call draw_path_globals
			do imh=0,imhmax(ofs_fast)
				call draw_fs_fast
			enddo
!$omp parallel do 
			do j=1,n
				call add_aloads(j)
			enddo
			do imh=0,imhmax(oas2load)
!$omp parallel do
				do j=1,n
					call draw_as2load(j)
				enddo
			enddo
			do imh=0,imhmax(oas2load_prior)
				call draw_as2load_prior
			enddo
!$omp parallel do 
			do j=1,n
				call draw_aloads(j)
			enddo
		endif		
		if(runflags(ohp)) then
			do imh=0,imhmax(os2phi_prior)
				call draw_s2phi_prior
			enddo
		endif
		if(runflags(otvp)) then
			do imh=0,imhmax(os2phi)
!$omp parallel do
				do j=1,na
					call draw_s2phi(j)
				enddo
			enddo			
		endif	
!$omp parallel do
		do j=1,na
			call draw_phi(j)
		enddo		

		if(runflags(ot)) then
!$omp parallel do
			do j=1,nsv
				call set_eps2(j)
			enddo
			if(runflags(ohp)) then
				do imh=0,imhmax(odf_prior)
					call draw_df_prior
				enddo
			endif		
			do imh=0,imhmax(otdfs)
!$omp parallel do 
				do j=1,nsv
					call draw_tdfs(j)
				enddo
			enddo
		endif
		if(runflags(oe)) then
			if(runflags(ohp)) then
				do imh=0,imhmax(odfe_prior)
					call draw_dfe_prior
				enddo
			endif		
			do imh=0,imhmax(otdfes)
!$omp parallel do 
				do j=1,nsv
					call draw_tdfes(j)
				enddo	
			enddo
		endif
		if(runflags(oe).or.runflags(ot)) then
!$omp parallel do
			do j=1,nsv
				call draw_s2bs(j)
			enddo	
		endif	
		call draw_gs2
	end subroutine

	subroutine draw_all(l)
		integer	:: j,l,i
		imh=0
!$omp parallel do private(j)
		do j=1,n		
			call add_ymus(j)
		enddo
		if(runflags(ohp).and.l>0) then
			call draw_s2coefs_var
		endif
!$omp parallel do private(j)
		do j=1,n
			call draw_s2coefs(j)
		enddo
		if(runflags(ohp).and.l>0) then
			call draw_s2coefs_var
		endif
!$omp parallel do
		do j=1,n
			call draw_ymu_ustartup(j)
		enddo
		if(runflags(ohp))	call draw_phi1_0
		if(nfac>0 .and. l>0)	then
			call draw_gymus
			call draw_geos
			call set_globals_mV
			call draw_s2eglobal
			call draw_s2mudglobal
			call draw_path_globals

			call draw_fs_fast
!$omp parallel do 
			do j=1,n
				call add_aloads(j)
				call draw_as2load(j)
			enddo
			if(runflags(ohp)) call draw_as2load_prior
			
!$omp parallel do 
			do j=1,n
				call draw_aloads(j)
			enddo
		endif
		if(runflags(ohp).and.l>0) call draw_s2phi_prior
!$omp parallel do 
		do j=1,na
			if(runflags(otvp)) call draw_s2phi(j)
			call draw_phi(j)
		enddo
		if(runflags(ot).or.runflags(oe)) then		
!$omp parallel do 
			do j=1,nsv
				call set_eps2(j)
			enddo
		endif
		if(runflags(ohp).and.l>0) then
			if(runflags(ot)) call draw_df_prior
			if(runflags(oe)) call draw_dfe_prior
		endif
		if(runflags(ot).or.runflags(oe)) then
!$omp parallel do 
			do j=1,nsv
				if(runflags(oe)) call draw_tdfes(j)
				if(runflags(ot)) call draw_tdfs(j)
				call draw_s2bs(j)
			enddo
		endif
		call draw_gs2
	end subroutine
	
	subroutine print_acc(l)
		integer	:: l
		accx=acc/l
		accx(:,[os2coefs,os2phi,otdfs,oas2load,otdfes])=sum(accj(:,[os2coefs,os2phi,otdfs,oas2load,otdfes],:),dim=3)/(na*l)
		if(maxval(accx(1:,:))==0) then
			call mdisp(accx(0,:))
		else
			call mdisp(accx)
		endif
	end subroutine	
	
	function transfe(e) result(val)
		real	:: e(nh,n),val(nh,n)
		integer	:: t,j
		val=e
		do t=2,nh
			where(transcode==5.or.transcode==6) val(t,:)=val(t,:)+val(t-1,:)
		enddo
	end function
	
	function transo(e) result(val)
		real	:: e(nh,n),val(nh,n)
		integer	:: j
		do j=1,n
			val(:,j)=mys(2,j)*e(:,j)+mys(1,j)
		enddo
	end function
	
	function gettstats() result(val)
		real, allocatable	:: val(:)
		val=[tgs2]
	end function
	
	subroutine adjust_mhscales(l)
		integer	:: l
		real	:: r(0:ubound(acc,1),size(acc,2))
		acc=acc/l
		acc(:,[os2coefs,os2phi,otdfs,oas2load,otdfes])=sum(accj(:,[os2coefs,os2phi,otdfs,oas2load,otdfes],:),dim=3)/(na*l)
		r=max(min(exp(.4*invlogit(acc)),3.0),1/3.0)
		mhscales=mhscales*r
	end subroutine
	
	subroutine setfcsts(init)
		logical	:: init
		integer :: nsim
		integer	:: l,ind(2),j,i
		real	:: mf(nh,n),stats(3,20)
		real, allocatable, save	:: fcomp(:,:,:,:),mfs(:,:),fall(:,:,:),fall0(:,:,:),capTs(:),fhps(:,:,:),quantfs(:,:,:,:)
		real, allocatable		:: ds_f(:,:,:),ds_f0(:,:,:),tstats(:,:),hps(:,:,:),hp(:,:),quantf(:,:,:)
		real, parameter	:: qs(9)=[0.05, 0.10, 0.167, 0.25, 0.50, 0.75, 0.833, 0.90, 0.95]
		integer, parameter	:: nqs=size(qs)
		integer, save	:: irun
		
		nsim=1000+1000*nfac	
		if(n>20) nsim=nsim*2
		if(init) then
			if(allocated(fcomp)) deallocate(fcomp,fall,fall0,mfs,capTs,fhps,quantfs)
			allocate(fcomp(nh,n,2,0),fall(nh,n,0),fall0(nh,n,0),mfs(0,n),capTs(0),fhps(0,0,0),quantfs(0,0,0,0))
			irun=0
			return
		endif
		hp=get_hps()
		allocate(ds_f(capT+1:capT+nh,n,nsim),ds_f0(capT+1:capT+nh,n,nsim),hps(size(hp,dim=1),size(hp,dim=2),nsim),quantf(nqs,nh,n))
		
		allocate(tstats(size(gettstats()),nsim))
		irun=irun+1
		do l=-min(200,nsim/3),0
			call draw_all(l)	! 200 draws without hp and factor
		enddo

		acc=0;accj=0
		do l=1,nsim/3
			mhscales(0,:)=mhscales0(0,:)*5.0**(1-l/(nsim/3.0))
			call draw_all(l)
		enddo
!		print *,"step 1"
		acc=0;accj=0
		do l=1,nsim/3		
			call draw_all_adjust(l)
			if(mod(l,200)==0) then
				call adjust_mhscales(200)
!				call mdisp(acc)
!				call mdisp(mhscales)
				acc=0;accj=0
			endif
		enddo
		acc=0;accj=0
		stats=0
		mf=0

		do l=1,nsim
			call draw_all(l)
			hps(:,:,l)=get_hps()			
			call fcst_all
			ds_f0(:,:,l)=f_ys0(capT+1:,:)
			ds_f(:,:,l)=f_ys(capT+1:,:)
			if(mod(l,1000)==-1) then
				call mdisp(maxval(abs(eos),dim=1))
			endif
		enddo
!		print *,"done with posterior draws"
		call print_acc(l)
		
		mf=sum(ds_f0,dim=3)/nsim
		
		
		do i=1,nh
			do j=1,n
				quantf(:,i,j)=quantile_v(ds_f(capT+i,j,:),qs)
			enddo
		enddo
		fall0=reshape([fall0,transo(r_ys(capT+1:capT+nh,:))],[nh,n,irun])
		fall=reshape([fall,transo(mf)],[nh,n,irun])
		capTs=[capTs,real(capT)]
		fhps=reshape([fhps,sum(hps,dim=3)/nsim],[size(hp,1),size(hp,2),irun])
		quantfs=reshape([quantfs,quantf],[nqs,nh,n,irun])
		call storeML(fall0,"fcsts0")
		call storeML(fall,"fcsts")
		call storeML(fhps,"hps")
		call storeML(quantfs,"quantfs")
		call storeML(capTs,"Ts")
		
		return
		
		! The following code compares forecasts to AR baseline. This code relies on the least squares routine "rlse" of the IMSL library
!block
!	real, allocatable	:: arf(:,:),c(:,:)
!	real	:: mr(nh),mr2(2,nh)
!
!	arf=getARfcsts(nphi)
!	fcomp=reshape([fcomp,transfe(arf-r_ys(capT+1:capT+nh,:)),transfe(mf-r_ys(capT+1:capT+nh,:))],[nh,n,2,irun])
!
!	print *,"RMSEs current forecasts"
!	call mdisp(sqrt((sum(fcomp(:,:,1,irun)**2,dim=2).cvr.sum(fcomp(:,:,2,irun)**2,dim=2))/n))
!	
!	do i=1,nh
!		do j=1,2
!			mr2(j,i)=quantile(abs(fcomp(i,:,j,irun)),.5)
!		enddo
!	enddo
!	print *,"median absolute error current forecast"
!	call mdisp(mr2)
!
!	do i=1,nh
!		do j=1,2
!			mr2(j,i)=quantile([abs(fcomp(i,:,j,:))],.5)
!		enddo
!	enddo
!	print *,"median absolute error all forecast"
!	call mdisp(mr2)
!
!	print *,"relative RMSE all forecasts"
!	call mdisp(sqrt(sum(sum(fcomp(:,:,2,:)**2,dim=3),dim=2)/sum(sum(fcomp(:,:,1,:)**2,dim=3),dim=2)))
!
!	c=sqrt(fcomp(:,:,2,irun)**2/fcomp(:,:,1,irun)**2)
!	do i=1,nh
!		mr(i)=quantile(c(i,:),.5)
!	enddo
!
!	!print *,"RMSE mean and median of current forecast relative to AR"
!	!call mdisp(sum(c,dim=2)/n.cvr.mr)
!
!	c=sqrt(sum(fcomp(:,:,2,:)**2,dim=3)/sum(fcomp(:,:,1,:)**2,dim=3))
!	do i=1,nh
!		mr(i)=quantile(c(i,:),.5)
!	enddo
!	print *,"RMSE mean and median of all forecasts relative to AR"
!	call mdisp(sum(c,dim=2)/n.cvr.mr)
!	
!	c=sum(abs(fcomp(:,:,2,:)),dim=3)/sum(abs(fcomp(:,:,1,:)),dim=3)
!	do i=1,nh
!		mr(i)=quantile(c(i,:),.5)
!	enddo
!	print *,"same for absolute errors"
!	call mdisp(sum(c,dim=2)/n.cvr.mr)
!	
!end block	
!		call printtime
	end subroutine
		
	!function getARfcsts(nq) result(val)	
	!	use rlse_int
	!	integer	:: nq
	!	real	:: val(nh,n)
	!	integer	:: j,i,t
	!	real	:: X(nq+1:capT+1,0:nq),y(nq+1:capT),beta(0:nq)
	!	integer, allocatable	:: inds(:)
	!	do j=1,n
	!		X(:,0)=1
	!		do t=nq+1,capT
	!			X(t,1:)=r_ys(t-1:t-nq:-1,j)
	!			y(t)=r_ys(t,j)
	!		enddo
	!		t=capT+1
	!		X(t,1:)=r_ys(t-1:t-nq:-1,j)
	!		if(.not. all(isfinite(X(t,:)))) then
	!			val(:,j)=0
	!			cycle
	!		endif
	!		do i=1,nh
	!			inds=[integer::]
	!			do t=nq+1,capT+1-i
	!				if(.not. isfinite(y(i+t-1))) cycle
	!				if(.not. all(isfinite(X(t,:)))) cycle
	!				inds=[inds,t]
	!			enddo
	!			if(size(inds)<20) then
	!				val(i,j)=0
	!				cycle
	!			endif
	!			call rlse(y(inds+i-1),X(inds,:),beta,intcep=0)
	!			val(i,j)=sum(beta*X(capT+1,:))
	!		enddo
	!	enddo
	!end function
	
end module