module draw_phi_mod
	use basicmodule
	implicit none
	
	contains
	
	subroutine draw_phi_prop(j)
		integer	:: j
		real	:: V(nphi,nphi),varstate(nphi),uvarstate(nphi)
		real	:: h(nphi),Vh(nphi),ev
		real	:: shat(nphi,2),s0(nphi),s0s(nphi,capT)
		real	:: shats(nphi,2,capT), Vs(nphi,nphi,capT),z(nphi),yeps(capT),as(2,capT),bs(nphi,capT)
		real	:: r(nphi,2),effvar,sig(nphi,nphi)
		integer	:: t,i

		uvarstate=s2phi(:,1,j)
		varstate=min(s2phi(:,2,j),maxs2phid)
		V=diagmat(uvarstate)
		call rnnoa(z)
		s0=sqrt(uvarstate)*z
		call rnnoa(yeps)
		shat(:,1)=s2phi_prior(:,1,1)
		shat(:,2)=0
		do t=1,capT
			s0s(:,t)=s0
			shats(:,:,t)=shat
			Vs(:,:,t)=V	
			h=us(t-1:t-nphi:-1,j)
			Vh=matmul(V,h)
			effvar=s2s(t,j)
			ev=sum(Vh*h)+effvar
			ev=1.0/ev
			as(:,t)=[us(t,j)-sum(h*shat(:,1)),sum(h*(s0-shat(:,2)))+sqrt(effvar)*yeps(t)]*ev
			shat(:,1)=shat(:,1)+as(1,t)*Vh
			shat(:,2)=shat(:,2)+as(2,t)*Vh
			bs(:,t)=ev*Vh
			if(t==capT) exit
			do i=1,nphi
				V(:,i)=V(:,i)-bs(i,t)*Vh
			enddo
			call rnnoa(z)
			s0=s0+sqrt(varstate)*z
			do i=1,nphi
				V(i,i)=V(i,i)+varstate(i)
			enddo
		enddo
		r=0
		do t=capT,1,-1
			h=us(t-1:t-nphi:-1,j)
			r(:,1)=r(:,1)+(as(1,t)-sum(bs(:,t)*r(:,1)))*h
			r(:,2)=r(:,2)+(as(2,t)-sum(bs(:,t)*r(:,2)))*h
			shat=shats(:,:,t)+matmul(Vs(:,:,t),r)
			phis(:,t,j)=shat(:,1)-shat(:,2)+s0s(:,t)
		enddo
		phis(:,0,j)=adjust_phi(phis(:,1,j))
		sig=toepmat(get_gamma_from_phi(phis(:,0,j)))
		sig=choleski(sig)
		call invertL(sig,acholini(:,:,j))
	end subroutine
	
	subroutine set_phi1_mV(j,m,sig)
		integer	:: j
		real	:: V(nphi,nphi),varstate(nphi),uvarstate(nphi)
		real	:: h(nphi),Vh(nphi),ev
		real	:: shat(nphi,1)
		real	:: shats(nphi,1,capT), Vs(nphi,nphi,capT),z(nphi),yeps(capT),as(1,capT),bs(nphi,capT), evs(capT)
		real	:: r(nphi,1),effvar,sig(nphi,nphi),Q(nphi,nphi),x(nphi),c,m(nphi)
		integer	:: t,i

		uvarstate=s2phi(:,1,j)
		varstate=min(s2phi(:,2,j),maxs2phid)
		V=diagmat(uvarstate)
		shat(:,1)=0 
		do t=1,capT
			shats(:,:,t)=shat
			Vs(:,:,t)=V	
			h=us(t-1:t-nphi:-1,j)
			Vh=matmul(V,h)
			effvar=s2s(t,j)
			ev=sum(Vh*h)+effvar
			ev=1.0/ev
			evs(t)=ev
			as(:,t)=[us(t,j)-sum(h*shat(:,1))]*ev
			shat(:,1)=shat(:,1)+as(1,t)*Vh
			bs(:,t)=ev*Vh
			if(t==capT) exit
			do i=1,nphi
				V(:,i)=V(:,i)-bs(i,t)*Vh
			enddo
			do i=1,nphi
				V(i,i)=V(i,i)+varstate(i)
			enddo
		enddo
		r=0; Q=0
		do t=capT,1,-1
			h=us(t-1:t-nphi:-1,j)
			r(:,1)=r(:,1)+(as(1,t)-sum(bs(:,t)*r(:,1)))*h
			x=matmul(Q,bs(:,t))
			c=evs(t)+sum(bs(:,t)*x)
			do i=1,nphi
				Q(:,i)=Q(:,i)-x(i)*h-h(i)*x+h*h(i)*c
			enddo
		enddo
		m=shats(:,1,1)+matmul(Vs(:,:,1),r(:,1))
		sig=Vs(:,:,1)-matmul(Vs(:,:,1),matmul(Q,Vs(:,:,1)))
	end subroutine

	subroutine draw_phi_cond(j,phi1)
		integer	:: j
		real	:: phi1(nphi)
		real	:: V(nphi,nphi),varstate(nphi),uvarstate(nphi)
		real	:: h(nphi),Vh(nphi),ev
		real	:: shat(nphi,2),s0(nphi),s0s(nphi,capT)
		real	:: shats(nphi,2,capT), Vs(nphi,nphi,capT),z(nphi),yeps(capT),as(2,capT),bs(nphi,capT)
		real	:: r(nphi,2),effvar,sig(nphi,nphi)
		integer	:: t,i

		varstate=min(s2phi(:,2,j),maxs2phid)
		uvarstate=0
		V=diagmat(varstate)
		shat(:,1)=phi1
		shat(:,2)=0
		call rnnoa(z)
		s0=sqrt(varstate)*z
		call rnnoa(yeps)
		do t=2,capT
			s0s(:,t)=s0
			shats(:,:,t)=shat
			Vs(:,:,t)=V	
			h=us(t-1:t-nphi:-1,j)
			Vh=matmul(V,h)
			effvar=s2s(t,j)
			ev=sum(Vh*h)+effvar
			ev=1.0/ev
			as(:,t)=[us(t,j)-sum(h*shat(:,1)),sum(h*(s0-shat(:,2)))+sqrt(effvar)*yeps(t)]*ev
			shat(:,1)=shat(:,1)+as(1,t)*Vh
			shat(:,2)=shat(:,2)+as(2,t)*Vh
			bs(:,t)=ev*Vh
			if(t==capT) exit
			do i=1,nphi
				V(:,i)=V(:,i)-bs(i,t)*Vh
			enddo
			call rnnoa(z)
			s0=s0+sqrt(varstate)*z
			do i=1,nphi
				V(i,i)=V(i,i)+varstate(i)
			enddo
		enddo
		r=0
		do t=capT,2,-1
			h=us(t-1:t-nphi:-1,j)
			r(:,1)=r(:,1)+(as(1,t)-sum(bs(:,t)*r(:,1)))*h
			r(:,2)=r(:,2)+(as(2,t)-sum(bs(:,t)*r(:,2)))*h
			shat=shats(:,:,t)+matmul(Vs(:,:,t),r)
			phis(:,t,j)=shat(:,1)-shat(:,2)+s0s(:,t)			
		enddo
	end subroutine

	function get_phi_ll(j,s2phi,s2phi_prior,phi1,cholini) result(val)
		real	:: s2phi(nphi,2),s2phi_prior(nphi,2,2),phi1(nphi),val,cholini(nphi,nphi)
		integer	:: j
		real	:: V(nphi,nphi),varstate(nphi),uvarstate(nphi)
		real	:: h(nphi),Vh(nphi),ev,e,effvar
		real	:: shat(nphi)
		integer	:: t,i

		val=-.5*sum((log(s2phi(:,2))-s2phi_prior(:,1,2))**2/s2phi_prior(:,2,2)) 

		val=val+get_phiadjust_ll(j,cholini)
		t=1
		val=val-.5*(us(t,j)-sum(us(t-1:t-nphi:-1,j)*phi1))**2/s2s(1,j)
		varstate=min(s2phi(:,2),maxs2phid)
		V=diagmat(varstate)
		shat=merge(phi1,0.0,j<=np)
		do t=2,capT
			h=us(t-1:t-nphi:-1,j)
			Vh=matmul(V,h)
			effvar=s2s(t,j)
			ev=sum(Vh*h)+effvar
			ev=1.0/ev
			e=us(t,j)-sum(h*shat)
			val=val-.5*e**2*ev+.5*log(ev)
			if(t==capT) exit
			shat=shat+ev*e*Vh
			do i=1,nphi
				V(:,i)=V(:,i)-ev*Vh(i)*Vh
			enddo
			do i=1,nphi
				V(i,i)=V(i,i)+varstate(i)
			enddo
		enddo
	end function
	
	subroutine draw_s2phi(j)
		integer	:: j
		real	:: new_s(nphi,2)
		real	:: ll,z(nphi),u(1)
		
		new_s(:,1)=s2phi(:,1,j)
		call rnnoa(z)
		new_s(:,2)=s2phi(:,2,j)*exp(mhscales(0,os2phi)*z*sqrt(s2phi_prior(:,2,2)/capT))
		ll=get_phi_ll(j,new_s,s2phi_prior,phis(:,1,j),acholini(:,:,j))
		ll=ll-get_phi_ll(j,s2phi(:,:,j),s2phi_prior,phis(:,1,j),acholini(:,:,j))
		call rnun(u)
		if(u(1)<exp(ll)) then
			s2phi(:,:,j)=new_s		
			accj(imh,os2phi,j)=accj(imh,os2phi,j)+1
		endif
	end subroutine
	
	subroutine draw_s2phi_prior
		integer	:: j,i
		real	:: new_s(nphi,2,np)
		real	:: ll,z(nphi,2),u(1)
		real	:: new_prior(nphi,2,2),e(nphi), new_phis(nphi,0:1,np),new_cholinis(nphi,nphi,np),sig(nphi,nphi)

		if(imh==0) then
			call rnnoa(z)
			z=z*mhscales(0,os2phi_prior)
		else
			z=0
			if(imh<3) then
				call rnnoa(z(:,imh:imh))
			endif
		endif		
		do i=1,nphi
			new_prior(i,1,1)=s2phi_prior(i,1,1)+mhscales(1,os2phi_prior)*sqrt(i*s2phi_prior_prior(i,1,1,2)/(nphi*n*capT))*z(i,1)
		enddo
		new_prior(:,1,2)=s2phi_prior(:,1,2)+mhscales(2,os2phi_prior)*sqrt(s2phi_prior_prior(:,1,2,2)/(nphi*n*capT))*z(:,2)
		if(imh==0) then
			call rnnoa(z)
			z=z*mhscales(0,os2phi_prior)
		else
			z=0
			if(imh>2) call rnnoa(z(:,imh-2:imh-2))
		endif
		new_prior(:,2,1)=s2phi_prior(:,2,1)*exp(mhscales(3,os2phi_prior)*sqrt(s2phi_prior_prior(:,2,1,2)/(nphi*n*capT))*z(:,1))
		new_prior(:,2,2)=s2phi_prior(:,2,2)*exp(mhscales(4,os2phi_prior)*sqrt(s2phi_prior_prior(:,2,2,2)/(nphi*n*capT))*z(:,2))
		ll=get_s2phi_prior_ll(new_prior)-get_s2phi_prior_ll(s2phi_prior)
!$omp parallel do private(e,sig) reduction(+:ll)		
		do j=1,np
			new_s(:,1,j)=new_prior(:,2,1)
			e=log(s2phi(:,2,j))-s2phi_prior(:,1,2)
			e=e*sqrt(new_prior(:,2,2)/s2phi_prior(:,2,2))
			e=e+new_prior(:,1,2)
			new_s(:,2,j)=exp(e)
			new_phis(:,1,j)=phis(:,1,j)-s2phi_prior(:,1,1)
			new_phis(:,1,j)=sqrt(new_prior(:,2,1)/s2phi_prior(:,2,1))*new_phis(:,1,j)+new_prior(:,1,1)
			new_phis(:,0,j)=adjust_phi(new_phis(:,1,j))
			sig=choleski(toepmat(get_gamma_from_phi(new_phis(:,0,j))))
			call invertL(sig,new_cholinis(:,:,j))
			ll=ll+get_phi_ll(j,new_s(:,:,j),new_prior,new_phis(:,1,j),new_cholinis(:,:,j))
			ll=ll-get_phi_ll(j,s2phi(:,:,j),s2phi_prior,phis(:,1,j),acholini(:,:,j))
		enddo
		call rnun(u)
		if(u(1)<exp(ll)) then
			s2phi(:,:,1:np)=new_s
			s2phi_prior=new_prior
			phis(:,0:1,1:np)=new_phis
			acholini(:,:,1:np)=new_cholinis
			acc(imh,os2phi_prior)=acc(imh,os2phi_prior)+1
		endif
	
	end subroutine	

	function get_s2phi_prior_ll(prior) result(val)
		real	:: prior(nphi,2,2),val
		integer	:: i
		val=-.5*sum((prior(:,1,:)-s2phi_prior_prior(:,1,:,1))**2/s2phi_prior_prior(:,1,:,2))
		val=val-.5*sum((log(prior(:,2,:))-s2phi_prior_prior(:,2,:,1))**2/s2phi_prior_prior(:,2,:,2))
	end function

	
	function get_phiadjust_ll(j,acholini) result(val)
		integer	:: j,i
		real	:: acholini(nphi,nphi),val			
		val=1
		do i=1,nphi
			val=val*acholini(i,i)
		enddo
		val=log(val)
		val=val-.5*sum(matmul(acholini,us(-nphi+1:0,j))**2)/s2s(0,j)
	end function

	subroutine draw_phi(j)
		integer	:: j
		real	:: z(nphi,2),u(1),ll,old_phis(nphi,0:capT),old_acholini(nphi,nphi)

		call draw_phi_cond(j,phis(:,1,j))
		
		old_phis=phis(:,:,j)
		old_acholini=acholini(:,:,j)
		call draw_phi_prop(j)

		ll=get_phiadjust_ll(j,acholini(:,:,j))-get_phiadjust_ll(j,old_acholini)
		
		call rnun(u)
		if(u(1)>exp(ll)) then		! don't accept
			phis(:,:,j)=old_phis
			acholini(:,:,j)=old_acholini
		endif
	end subroutine

	subroutine draw_phi1_0
		use lapack95, only: potrf,potrs,getrs
		real	:: old_phis(nphi,0:1,np),old_acholini(nphi,nphi,np), old_prior(nphi,2,2)
		real	:: ms(nphi,np),Vs(nphi,nphi,2,np),sm(nphi),sV(nphi,nphi),sm0(nphi),sv0(nphi,nphi)
		real	:: ll,u(1),sig(nphi,nphi)
		logical	:: accept_flag
		integer	:: j,i,i2,itry
		
		old_phis=phis(:,0:1,:)
		old_acholini=acholini
		old_prior=s2phi_prior

		sV=diagmat(1/s2phi_prior_prior(:,1,1,2))
		sm=s2phi_prior_prior(:,1,1,1)/s2phi_prior_prior(:,1,1,2)
!$omp parallel do private(i,sig) reduction(+:sv,sm)		
		do j=1,np
			call set_phi1_mV(j,ms(:,j),sig)
			Vs(:,:,1,j)=sig
			
			do i=1,nphi
				do i2=1,nphi
					sig(i2,i)=sig(i2,i)/(s2phi(i,1,j)*s2phi(i2,1,j))
				enddo
			enddo
			sV=sV-sig
			do i=1,nphi
				sV(i,i)=sV(i,i)+1/s2phi(i,1,j)
			enddo
			sm=sm+ms(:,j)/s2phi(:,1,j)
			Vs(:,:,2,j)=choleski(Vs(:,:,1,j))
		enddo
		call potrf(sV)
		call zero_lower(sV)
		call potrs(sV,sm)
		sm0=sm
		sv0=sv
		accept_flag=.false.
		do itry=1,merge(merge(5,3,n>20),1,realrun)		
			call rnnoa(s2phi_prior(:,1,1))
			call getrs(sV0,ipivot(1:nphi),s2phi_prior(:,1:1,1))
			s2phi_prior(:,1,1)=sm0+s2phi_prior(:,1,1)
			ll=0
!$omp parallel do private(i,sm,sig) reduction(+:ll)		
			do j=1,np
				sm=ms(:,j)-s2phi_prior(:,1,1)+matmul(Vs(:,:,1,j),s2phi_prior(:,1,1)/s2phi(:,1,j))
				call rnnoa(phis(:,1,j))
				phis(:,1,j)=matmul(Vs(:,:,2,j),phis(:,1,j))+s2phi_prior(:,1,1)+sm
				phis(:,0,j)=adjust_phi(phis(:,1,j))
				sig=choleski(toepmat(get_gamma_from_phi(phis(:,0,j))))
				call invertL(sig,acholini(:,:,j))
				ll=ll+get_phiadjust_ll(j,acholini(:,:,j))-get_phiadjust_ll(j,old_acholini(:,:,j))
			enddo
			call rnun(u)
			if(u(1)>exp(ll)) then		! don't accept
				phis(:,0:1,:)=old_phis
				acholini=old_acholini
				s2phi_prior=old_prior
			else
				accept_flag=.true.
			endif
		enddo
		if(accept_flag) then		! we accepted, so draw the rest
			acc(8,os2phi_prior)=acc(8,os2phi_prior)+1
!$omp parallel do
			do j=1,np
				call draw_phi_cond(j,phis(:,1,j))
			enddo
		endif
		
	contains
	
		subroutine zero_lower(A)
			real	:: A(nphi,nphi)
			integer	:: i,j
			do i=1,nphi-1
				A(i+1:,i)=0
			enddo
		end subroutine
	end subroutine

	
end module
