module fcst
	use basicmodule
	use StochVola
	implicit none
	
	real, allocatable	:: f_aus(:,:)
	real, allocatable	:: f_ys(:,:),f_ys0(:,:)

	
	contains
	
	subroutine fcst_ys
		integer	:: j,t,l
		real	:: aphi(nphi),phi(nphi),v(1),z(1),s2,df
		real	:: gmu(0:nh),mu,load(nld),zl(nld)
!$omp parallel do private(phi,s2,df,aphi,z,v)		
		do j=1,na
			f_aus(capT-nphi+1:capT,j)=us(capT-nphi+1:capT,j)
			phi=phis(:,capT,j)
			s2=exp(sum(cost(:,capT)*s2coefs(ou0:,j)))
			df=merge(min(df_offset+exp(tdfs(j)),df_max),1.0,runflags(ot))
			v=1
			do t=capT+1,capT+nh
				call rnnoa(aphi)
				phi=phi+sqrt(min(s2phi(:,2,j),maxs2phid))*aphi
				aphi=adjust_phi(phi)
				if(runflags(osv)) then
					call rnnoa(z)
					s2=s2*exp(z(1)*sqrt(s2coefs_var(oup)))
				endif
				if(runflags(ot)) call rnchi2(df,v)
				call rnnoa(z)
				f_aus(t,j)=sum(aphi*f_aus(t-1:t-nphi:-1,j))+sqrt(s2*df/v(1))*z(1)
			enddo
		enddo

		if(nfac>0) then
			gmu(0)=ymus(capT,n+1)
			do t=1,nh
				call rnnoa(z)
				gmu(t)=gmu(t-1)+z(1)*exp(.5*s2coefs(omud,n+1))
			enddo
			if(runflags(oe)) then
				df=min(df_offset+exp(tdfes(n+1)),df_max)
				do t=1,nh
					call rnchi2(df,v)
					call rnnoa(z)
					gmu(t)=gmu(t)+z(1)*sqrt(exp(s2coefs(oeo,n+1))*df/v(1))
				enddo
			endif
		endif
		
!$omp parallel do private(mu,load,t,z,v,zl,df)		
		do j=1,n
			mu=ymus(capT,j)
			if(nfac>0) load=loads(:,capT,1,j)
			do t=capT+1,capT+nh
				call rnnoa(z)
				mu=mu+z(1)*exp(.5*s2coefs(omud,j))
				f_ys(t,j)=f_aus(t,j)+mu
				if(runflags(oe)) then
					df=min(df_offset+exp(tdfes(j)),df_max)
					call rnchi2(df,v)					
					call rnnoa(z)
					f_ys(t,j)=f_ys(t,j)+z(1)*sqrt(exp(s2coefs(oeo,j))*df/v(1))
				endif
				if(nfac>0) then
					call rnnoa(zl)
					load=load+sqrt(min(s2loads(:,2,1,j),maxs2loadd))*zl
					f_ys(t,j)=f_ys(t,j)+sum(load*f_aus(t:t-nld+1:-1,n+1))
				endif
			enddo
			if(nfac>0)	f_ys(capT+1:capT+nh,j)=f_ys(capT+1:capT+nh,j)+gmu(1:)

			f_ys(:,j)=f_ys(:,j)*mys(2,j)+mys(1,j)
			do t=capT+2,capT+nh
				f_ys(t,j)=f_ys(t-1,j)+f_ys(t,j)
			enddo
		enddo		
	end subroutine	
	
	subroutine fcst_ys0
		integer	:: j,t,l
		real	:: aphi(nphi)
		do j=1,na
			f_aus(capT-nphi+1:capT,j)=us(capT-nphi+1:capT,j)
			aphi=adjust_phi(phis(:,capT,j))
			do t=capT+1,capT+nh
				f_aus(t,j)=sum(aphi*f_aus(t-1:t-nphi:-1,j))			
			enddo
		enddo
		do j=1,n
			do t=capT+1,capT+nh
				f_ys0(t,j)=ymus(capT,j)+f_aus(t,j)
				do l=1,nfac
					f_ys0(t,j)=f_ys0(t,j)+sum(loads(:,capT,l,j)*f_aus(t:t-nld+1:-1,n+l))
				enddo
			enddo
			if(nfac>0) f_ys0(:,j)=f_ys0(:,j)+ymus(capT,n+1)
		enddo		
	end subroutine
	
	subroutine fcst_all
		call fcst_ys0
		call fcst_ys
	end subroutine

end module