program mfort
	use compute
	use Geweke
	use omp_lib
	use data_mod
	use marginallikelihood
	implicit none
	
	integer	:: i,ix,irun,idata,j
	integer	:: capTrange(2,0:2)
	real	:: BFout(0:2,11)
	real, allocatable	:: aBF(:,:)
	

	call openML
	call inittime
	CALL OMP_SET_NUM_THREADS(merge(24,1,realrun))
	call init_ziggurat(139992834)
	
	if(.not. realrun) then
		runflags=.true.
		ntcoefs=min(5,capT-1)		
		call malloc	
		call Gcheck		
		stop
	endif
	
!	goto 30				! compute BF factors directly, rather than first computing all forecasts
	
	capTrange(:,1)=[311,795]	! PCE inflation
	capTrange(:,0)=[119,423]	! state employment
	capTrange(:,2)=[119,579]	! IP Europe

	do idata=0,2
		do irun=6,0,-1
			call setfcsts(.true.)
			do capT=capTrange(1,idata),capTrange(2,idata)
				call init_ziggurat(162967+121618*ix)
		!$omp parallel do		
				do i=1,24
					call init_ziggurat(132543+2652548*(i+1846*ix))
				enddo
				ntcoefs=capT/merge(12,36,nphi==4)
				runflags=.false.
				runflags(1:min(irun,size(runflags)))=.true.
				
				nfac=max(0,irun-size(runflags))

				select case(idata)
				case(0)
					n=51
					call malloc
					call loaddata("StateEmployment")		
				case(1)
					n=17
					call malloc	
					call loaddata("PCE_Inflation")		
				case(2)
					n=16
					call malloc	
					call loaddata("IP_Europe")		
				end select
				CALL OMP_SET_NUM_THREADS(merge(min(24,na),1,realrun))
				print *,getrun_name()
				call prep_real
				call setfcsts(.false.)
			enddo			
			print *,"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
			print *,"XXXXXXXXXXXXXX   all done with "//trim(getrun_name())//"XXXXXXXXXX"
			print *,"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
			call execinML("save('c:/dropbox/mystuff/macroforecasting/fcsts/"//trim(getrun_name())//".mat','fcsts','fcsts0','Ts','hps','quantfs')")
		enddo
	enddo
	
30	capTrange(:,1)=[311,731]	! fredmd
	capTrange(:,0)=[119,359]	! state employment
	capTrange(:,2)=[119,533]	! IP Europe
	allocate(aBF(0,size(Bfout,2)))

	do ix=1,10			! compute BF factors 10 times to get a sense of their variability
	print *,"ix=",ix
	BFout=0
	do idata=0,2
		call setfcsts(.true.)
		capT=capTrange(2,idata)
		!$omp parallel do		
		do i=1,24
			call init_ziggurat(1324543+262848*(i+1846*ix))
		enddo
		ntcoefs=capT/merge(12,36,nphi==4)
		runflags=.true.
		nfac=1
		select case(idata)
		case(0)
			n=51
			call malloc
			call loaddata("StateEmployment")		
		case(1)
			n=17
			call malloc	
			call loaddata("PCE_Inflation")		
		case(2)
			n=16
			call malloc	
			call loaddata("IP_Europe")		
		end select
		CALL OMP_SET_NUM_THREADS(merge(min(24,na),1,realrun))
		print *,getrun_name()
		do i=1,8
!$omp parallel do		
			do j=1,24
				call init_ziggurat(1324543+262848*(j+1846*ix))
			enddo
			print *,"XXXXXXXXXXXXXXXXX",i,"XXXXXXXXXXXXXXXXX"
			call setml(i,BFout(idata,max(i,1)))
			print *,"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF"
			call execinML(trim(getrun_name())//"_"//convtos(i)//"_"//convtos(ix)//"=tsa")
			call mdisp(Bfout)
			call printtime
		enddo
	enddo	
	aBF=aBF.cud.BFout.cud.[(0.0/0.0,i=1,11)]
	call mdisp(aBF)
	
	enddo
	contains
		subroutine malloc
		
		na=n+nfac; np=na
		nsv=na; nmu=na
		ns2c=ntcoefs+3
		
		if(allocated(ys)) then
			deallocate(ys,ymus,acholini,s2phi,s2loads,loads,mV)
			deallocate(cost,tdfs,tdfes,s2bs,s2s,s2beos,s2eos,phis, us,eos,missing,eps2,r_ys,f_aus,f_ys,f_ys0,ipivot)
			deallocate(s2loads_prior,s2phi_prior,s2phi_prior_prior,s2loads_prior_prior,s2coefs)
			deallocate(mys,transcode)
		endif

		allocate(ys(capT,n),ymus(capT,nmu),loads(nld,-nphi+1:capT,nfac,n),cost(0:ntcoefs,capT))
		allocate(s2bs(capT,na),s2s(0:capT,na),tdfs(0:na),tdfes(0:na),s2beos(capT,na),s2eos(capT,na),s2coefs(ns2c,0:na),phis(nphi,0:capT,na), us(-nphi+1:capT,na),eos(1:capT,na),missing(capT+nh,nmu))
		allocate(eps2(capT,na))
		allocate(r_ys(1:capT+nh,1:n),acholini(nphi,nphi,na))
		allocate(s2phi(nphi,2,na),s2loads(nld,2,nfac,n),mV(2,capT,2))
		allocate(f_aus(capT-nphi+1:capT+nh,na),f_ys(capT+1:capT+nh,n),f_ys0(capT+1:capT+nh,n),ipivot(capT+nphi))
		allocate(s2loads_prior(nld,2,2,nfac),s2phi_prior(nphi,2,2),s2phi_prior_prior(nphi,2,2,2),s2loads_prior_prior(nld,2,2,2))
		allocate(mys(2,n),transcode(n))
		
		call set_cost
		ipivot=[(i,i=1,capT+nphi)]
		end subroutine
end program