% Construct AR forecasts for the Euro-Area Industrial Production
clearvars;
small = 1.0e-8;
big = 1.0e+8;
this_date = datestr(now,'yyyymmdd');

% -- File Directories  
datadir='../Data/'; 
outdir = 'out/';
figdir = 'fig/';
matdir = 'mat/';

% Add paths for Matlab Utility Functions
addpath('../Matlab_Utility_Programs/');

% Parameters for the exercise
n_arlags = 12;          % Number of AR lags
i_constant = 1;         % Include a constant term
first_fcst = [1985 6];  % First forecast period
n_h = 12;                % Number of forecast periods

% Read PCED Data
load([datadir 'IP_Europe_Data.mat']);
calds = calds_m;
dnobs = size(calds,1);
data_mat = lfd_data;
n_sectors = size(data_mat,2);

% Matrices for saving the results
rslt_fcsts = NaN(n_h,n_sectors,dnobs);        % Forecasted values
rslt_actual = NaN(n_h,n_sectors,dnobs);       % Actual values
sd_fcsts = zeros(n_h,n_sectors,dnobs);        % SD of forecast
sd_fcsts_accum = zeros(n_h,n_sectors,dnobs);  % STD of forecast accumulated values

% Find first forecast period .. find first_fcst in calds
t_first = find(calds(:,1) == first_fcst(1) & calds(:,2) == first_fcst(2));

for i_sec = 1:n_sectors
    for t = t_first:dnobs
        % Construct the forecast for period t
        tmp_data = data_mat(2:t,i_sec);  % Missing data in period 1 from first differences
        [arcoef,constant,ser] = uar_c(tmp_data,n_arlags,i_constant);
        % Convert to state space form
        [s,phi,theta] = ar_withconstant_to_ss(arcoef,constant,ser);
        n_state = size(phi,1);
        % Forecast
        % State Vector
        x = zeros(n_arlags+1,1);
        x(end) = 1;  % Constant term
        x(1:n_arlags) = flipud(data_mat(t-n_arlags+1:t,i_sec));
        for i_h = 1:n_h
            x = phi*x;
            rslt_fcsts(i_h,i_sec,t) = s*x;
            if (t+i_h <= dnobs)
                rslt_actual(i_h,i_sec,t) = lfd_data(t+i_h,i_sec);
            end
        end
        % Comput Covariance Matrix of forecast errors
        P_h = zeros(n_state,n_state);
        Sigma_Fcst_Errors = SS_Model_Fcst_Error_Covmatrix(s,phi,theta,n_h,P_h);
        sd_fcsts(:,i_sec,t) = sqrt(diag(Sigma_Fcst_Errors));
        % Accumulated values
        A = tril(ones(n_h,n_h));
        sd_fcsts_accum(:,i_sec,t) = sqrt(diag(A*Sigma_Fcst_Errors*A'));
    end
end

% Save the results
% Variables to save
var_save = {'rslt_fcsts','rslt_actual','sd_fcsts','sd_fcsts_accum'};
save([matdir 'ar_fcst_ipeurope.mat'],var_save{:});
