% Prior plots for AR coefficients for Model 1 and Model 2
clearvars;
small = 1.0e-8;
big = 1.0e+8;
this_date = datestr(now,'yyyymmdd');

% -- File Directories  
datadir='../Data/'; 
outdir = 'out/';
figdir = 'fig/';
matdir = 'mat/';
umdir = '../Fortran_fcsts/';  % location of forecasts from UM's Fortran implementations

% Add paths for Matlab Utility Functions
addpath('../Matlab_Utility_Programs/');

% Dates for the various forecast files ... 
% UM forecasts
first_date_um = [1999 12];
last_date_um = [2024 4];

% Dates for prior/posteriors 
pp_date = [2019 6];  % Last forecast period evaluation period

% Set up a calendar to use across forecasts
[dnobs_um,calvec_um,calds_um] = calendar_make(first_date_um,last_date_um,12);
t_pp = find(calds_um(:,1) == pp_date(1) & calds_um(:,2) == pp_date(2));

% Load the UM forecasts
% UM Models
UM_Model_1 = 'FFFFF0';
load([umdir 'StateEmployment' UM_Model_1 '.mat' ]);
mv_mat_1 = squeeze(hps(:,:,t_pp)); 

UM_Model_2 = 'TFFFF0';
load([umdir 'StateEmployment' UM_Model_2 '.mat' ]);
mv_mat_2 = squeeze(hps(:,:,t_pp)); 

% Get a general grid for standard normal for plotting
n_grid = 51;  % Number of grid points for plotting
z_grid = linspace(-3,3,n_grid)';  % Standard normal grid for plotting

% Construct a series of figures
% -- Step 1: Plot the priors for the AR coefficients
phi_row = 5;   % Phis .. 5 - 16    
prior_lag_mat_1 = NaN(n_grid,12);
prior_lag_mat_2 = NaN(n_grid,12);
x_grid_mat_1 = NaN(n_grid,12);
x_grid_mat_2 = NaN(n_grid,12);
for lag = 1:12
    row = phi_row + lag - 1;  % Row in the matrix for the lag
    mean_1 = mv_mat_1(row,1);
    variance_1 = mv_mat_1(row,2);
    mean_2 = mv_mat_2(row,1);
    variance_2 = mv_mat_2(row,2);
    x_grid_1 = z_grid * sqrt(variance_1) + mean_1;  % Grid for model 1
    x_grid_2 = z_grid * sqrt(variance_2) + mean_2;  % Grid for model 2
    prior_lag_mat_1(:,lag) = normpdf(x_grid_1,mean_1,sqrt(variance_1));
    prior_lag_mat_2(:,lag) = normpdf(x_grid_2,mean_2,sqrt(variance_2));
    x_grid_mat_1(:,lag) = x_grid_1;
    x_grid_mat_2(:,lag) = x_grid_2;
end

% Plot 
% fig = figure('units','normalized','outerposition',[0 0 0.5 0.75]);  % Dell
fig = figure('units','normalized','outerposition',[0 0 0.65 1.0]);  % Dell
leg_fs = 8;
ax_fs = 10;
for i = 1:12
    subplot(3,4,i);
    plot(x_grid_mat_1(:,i),prior_lag_mat_1(:,i),'-- r','LineWidth',2);
    hold on;
        plot(x_grid_mat_2(:,i),prior_lag_mat_2(:,i),'- b','LineWidth',2);
    hold off;
    title(['Lag ' num2str(i)]);
    xlim([-0.6 0.6]);
    set(gca,'FontSize',ax_fs);
    if i == 1
        legend('Minnesota Prior','Hierarchical Bayes','Location','NorthWest','FontSize',leg_fs);
    end
end

% Save the figure
% figure_to_png(figdir, 'Prior_Plots_AR_Coefficients_Model1_Model2');
figure_to_png(figdir, 'Figure_3');
close(fig);

% --- Format for the input files 

% % I also now save the hyperpriors (for all runs, it's not more work and maybe useful). The new matlab files (will) have one more variable called "hps". This is a 51x4xM matrix, where M is the number of runs. The rows of the matrix contain the posterior means of the hyperpriors, with the first two columns corresponding to the level, and the last two columns corresponding to the time variation in that parameter. If not applicable, value is NaN. Each type of parameter is separated from other parameters by a single row of NaNs.

% % First row: mean mu

% % Third row: variance sigma^2

% % 5th row: phis

% % 18th row: nu, degree of freedom parameter

% % 20th row: kappa, scale of outliers

% % 22th row: lambdas, factor parameters

% % 29th row: xis, q coefficients of time varying volatility (padded with additional NaN rows so they fit even for T=770). Note that the q coefficients have a common variance parameter in the hyperprior)