perc_rpt = [0.05 0.10 0.25 0.75 0.90 0.95];
n_perc_rpt = length(perc_rpt);
% summarize quantile results
fprintf(fid,'Model,');
for i_q = 1:n_perc_rpt
    fprintf(fid,'%6.2f,',perc_rpt(i_q));
end
fprintf(fid,',90-10 Interval \n');


for i_h = 1:length(h_rpt)
    i_h = h_rpt(i_h);
    fprintf(fid,'\n\n Horizon %i \n',i_h);
    fprintf(fid,'AR(12),');
    for i_q = 1:n_perc_rpt
        fprintf(fid,'1.0,');
    end
    fprintf(fid,',1.0 \n');

    for i_model = 1:n_models
        fprintf(fid,'%s,',UM_Models{i_model});
        tmp_actual = squeeze(actual_accum(i_h,:,t_first_fcst:t_last_fcst));
        for j_q = 1:n_perc_rpt
            perc = perc_rpt(j_q);
            i_q = find(pct_vec == perc);
            tmp_ar = squeeze(quantiles_ar_accum(i_q,i_h,:,t_first_fcst:t_last_fcst));
            risk_ar = quantile_sample_risk(tmp_actual(:),tmp_ar(:),perc);
            tmp_um = squeeze(quantiles_um_accum(i_q,i_h,:,t_first_fcst:t_last_fcst,i_model));
            risk_um = quantile_sample_risk(tmp_actual(:),tmp_um(:),perc);
            rel_um = risk_um/risk_ar;
            fprintf(fid,'%6.2f,',rel_um);
        end
        fprintf(fid,',');
        perc = 0.10;
        i_lower = find(pct_vec == perc);
        i_upper = find(pct_vec == 1-perc);
        tmp_actual = squeeze(actual_accum(i_h,:,t_first_fcst:t_last_fcst));
        tmp_ar_lower = squeeze(quantiles_ar_accum(i_lower,i_h,:,t_first_fcst:t_last_fcst));
        tmp_ar_upper = squeeze(quantiles_ar_accum(i_upper,i_h,:,t_first_fcst:t_last_fcst));
        risk_ar = interval_sample_risk(tmp_actual(:),tmp_ar_lower(:),tmp_ar_upper(:),perc);
        tmp_um_lower = squeeze(quantiles_um_accum(i_lower,i_h,:,t_first_fcst:t_last_fcst,i_model));
        tmp_um_upper = squeeze(quantiles_um_accum(i_upper,i_h,:,t_first_fcst:t_last_fcst,i_model));
        risk_um = interval_sample_risk(tmp_actual(:),tmp_um_lower(:),tmp_um_upper(:),perc);
        rel_um = risk_um/risk_ar;
        fprintf(fid,'%6.2f \n',rel_um);

    end
end

