function [Sigma_Fcst_Errors] = SS_Model_Fcst_Error_Covmatrix(s,phi,theta,n_h,P_h)
    % The model has the form:
    %   h(t) = phi*h(t-1) + theta*u(t)
    %   y(t) = s*h(t)
    %   Where u(t) is iid (0,I) 
    %         Note: in this program y(t) can be a vector
    % 
    %   Here P_h is the state error covariance matrix at time t.  
    %    Let e(t+k|t) = y(t+k) - E(y(t+k)|A(t))  Where A(t) is the information set at time t
    %        Note that P_h = var(h(t)|A(t)) is the state error covariance matrix
    %    This function computes the covariance matrix of [e(t+1|t); e(t+2|t) ; ... ; e(t+n_h|t)]


    n_state = size(phi,1);  % Number of states
    V = theta*theta';       % Variance of theta*u(t)

    
    % Step 1 ... compute the covariance matrix for the forecasts errors of the state
    % Let w(t+k|t) = h(t+k) - E(h(t+k)|A(t))  
    % Compute the covariance matrix of [w(t+1|t); w(t+2|t) ; ... ; w(t+n_h|t)]
    sigma_wh = zeros(n_state*n_h,n_state*n_h); 
    Tmp = P_h;  % Matrix to hold the previous diagonal block of sigma_wh .. initialize at P_h
    for i_h = 1:n_h
       ii = (i_h-1)*n_state;
       sigma_wh(ii+1:ii+n_state,ii+1:ii+n_state) = phi*Tmp*phi'+V;      % Error at the last horizon times phi + new error
       Tmp = sigma_wh(ii+1:ii+n_state,ii+1:ii+n_state);                 % Update Tmp
       for j = i_h+1:n_h
           jj = (j-1)*n_state;
           kk = (j-2)*n_state;
           sigma_wh(jj+1:jj+n_state,ii+1:ii+n_state) = phi*sigma_wh(kk+1:kk+n_state,ii+1:ii+n_state);
           sigma_wh(ii+1:ii+n_state,jj+1:jj+n_state) = sigma_wh(jj+1:jj+n_state,ii+1:ii+n_state)';
       end
    end 

    % Step 2 ... Map forecast errors for the state into forecast errors for the observations
    S_F = kron(eye(n_h),s);
    Sigma_Fcst_Errors = S_F*sigma_wh*S_F';
end