function [s,phi,theta] = ar_withconstant_to_ss(rho,constant,se)
    % Convert to AR model to a SS model of the form
    % h(t) = phi*h(t-1) + theta*u(t)
    % y(t) = s*h(t)
    % where h(t) is the state variable, u(t) is the innovation with unit variance, and y(t) is the observation
    % rho is a colum vector the vector AR coefficients
    % constant is the constant term in the AR model
    % se is the standard error of the innovations from the AR model
    % In this version the constant term (1) is added as the last element of the state vector
    n_ar = size(rho,1);
    phi = zeros(n_ar+1,n_ar+1);
    phi(1,1:n_ar) = rho';
    if n_ar > 1
        phi(2:n_ar,1:n_ar-1) = eye(n_ar-1);
    end
    % Add the constant term in the last row
    phi(1,n_ar+1) = constant;
    phi(n_ar+1,n_ar+1) = 1;
    % Mapping from state to observation
    s = zeros(1,n_ar+1);
    s(1,1)=1;
    theta = zeros(n_ar+1,1);
    theta(1,1) = se;
end