function [ycoef,zcoef,constant,residuals] = uar_c_residual(y,z,ny_lags,nz_lags,i_constant)
% AR coefficients and SER ... flag for constant term
% Also returns the residuals
T = size(y,1);
ii = (1:1:T)';

    x = NaN(size(y,1),ny_lags+nz_lags);
    for i = 1:ny_lags
        x(:,i) = lag(y,i);
    end
    for i = 1:nz_lags
        x(:,ny_lags+i) = lag(z,i);
    end
    if i_constant == 1
        x = [x ones(size(x,1),1)];
    end
    tmp = packr([y x ii]);
    y = tmp(:,1);
    x = tmp(:,2:end-1);
    ii_incl = tmp(:,end);
    bols = x\y;
    e = y - x*bols;
    ycoef = bols(1:ny_lags);
    if nz_lags > 0
        zcoef = bols(ny_lags+1:ny_lags+nz_lags);
    else
        zcoef = 0;
    end
    constant = NaN; % Default   
    if i_constant == 1
        constant = bols(end);
    end
    residuals = NaN(T,1);
    residuals(ii_incl) = e;

end

