program mfortran
	use basicmodule
	use compute
	use iomodule
	use cymod
	integer	:: i
	type(tpara)	:: para
	real		:: LL1
	character(len=20)	:: cname	
	real		:: BFout(0:6,pmax)=-1
	
	call openML
	call execinML("close all")
	call rnset(120656)
!$omp parallel do
	do i=1,100
		call rnset(3491284*i)
	enddo
	call inittime

	if(CYrun) then		! generate 1000 draws within 2 log points of maximum for Campbell Yogo application
		capn=50
		hub=capn*pi
		call loaddata
		p=1
		call maxLL(LL1)
		p=2
		call genpoints(LL1)
		stop
	endif
	
	
	p=5				! generate random draws from baseline prior for Figure 3
	capN=50
	hhf=1
	Tdata=230			
	hhspecialflag=0
	priorkappa=200
	hub=capn*pi
	maxhhfac=1.0
	rawpriorflag=.true.

	priorkappa=200
	hhpriorset=.false.
	call iterate(.true.)
	priorkappa=0
	hhpriorset=.false.
	call iterate(.true.)
	
	do icase=0,6		! compute the results for Figures 2 and 4, and Tables 2 and 3
		rawpriorflag=.false.
		capN=50
		hhf=1
		hhspecialflag=0
		priorkappa=200
		
		select case(icase)
			case(0)
				cname="default"
			case(1)
				cname="kappa=500"
				priorkappa=500
			case(2)
				cname="kappa=0"
				priorkappa=0
			case(3)
				cname="half of quarter-life"
				hhf=2
			case(4)
				cname="double of sqrt(1/2)-life"
				hhf=0.5
			case(5)
				cname="sum of AR half-life"
				hhspecialflag=1
			case(6)
				cname="absolute sum of corr half-life"
				hhspecialflag=2
		end select
		hub=capn*pi
		maxhhfac=merge(1.0,.25*hhf,hhspecialflag==2)
		call loaddata
		BFs=1

		print *,"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"		
		print *,"XXXXXXXXXXXXXX    ", icase, trim(cname),"  XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"		
		print *,"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"		

		do p=1,pmax
			hhpriorset=.false.
			call iterate(.true.)
		enddo
		do p=1,pmax
			hhpriorset=.true.
			call iterate(.false.)
		enddo
		do p=2,pmax
			BFs(p)=BFs(p)*BFs(p-1)
		enddo
		BFout(icase,:)=BFs
		print *,"Bayes Factors"
		call mdisp(BFout)
		call printtime
	enddo
end program