%/*** Compute LEFT critical value of test 
%    given confidence interval for c and delta ***/

function crit=BonLcrit(cL,cU,d,quant)

% local i, delta, Ndelta, dist1, dist2, crit;

% /* Choose nearest delta in grid */

delta = seqa(-1,0.025,40);
Ndelta = size(delta,1);

i = 1;
while (delta(i)<d) && (i<Ndelta)
    i = i+1;
end

dist1 = abs(delta(i-1)-d);
dist2 = abs(delta(i)-d);

if dist1<dist2;
    i = i-1;
end

% /* Compute critical value */

crit = Lcrit(cL,cU,quant(i,:)');

end