function [c]=getcfromh(hvec)
% INVERSE TRANSFORMATION OF REPARAMETRIZED PARAMETERS) BACK TO PARAMETERS IN THE ORIGINAL MODEL

    p = length(hvec);

    c = zeros(1,p);

    if p == 1
        c = hvec;
    else
        for j = 1:floor(p/2)
            h1 = hvec(2*j-1);
            h2 = hvec(2*j);

            d = sqrt(h2^2-h1^2);

            c((2*j-1):(2*j)) = [h2-d,h2+d];
        end
        if mod(p,2) == 1
            c(end) = hvec(end);
        end
    end

end