clear all

%% read random draws of GLTU parameters
load CYpoints.txt

%% load critical values of Campbell and Yogo (2006) %%
load DFbelt.mat 
load DFGLSbelt.mat 
load Qconf.mat 
load tquantL.mat 
load tquantR.mat 
load tconf.mat

%% environment %%
maxp = 8; % as in Campbell and Yogo (2006)
alpha = 0.05;

c_mle = 23.1; % MLE of LTU c using limited-information likelihood  under zero initial condition
load innovCov.mat; % estimated covariance matrix of the innovations to predictor and return.

%% simulations %%
Nsimu = 20000;
p = 2;
T = 1098;

rejprobVec = zeros(1,size(CYpoints,2));

parpool('local',8)
parfor i=1:size(CYpoints,2)
    paras = CYpoints(3:5,i);
    cvec = getcfromh(paras(1:p));
    gvec = getcfromh(paras(p+1:end));

    [rsim,xsim] = DGPsimuZero(cvec,gvec,T,Sigma,Nsimu);

    [rejprobVec(i)] = rejprobCY(rsim,xsim,maxp,DFbelt,DFGLSbelt, tconf, tquantL, tquantR, Qconf,alpha);
end
delete(gcp)

CYpoints = [CYpoints;rejprobVec];

save CYpoints_Rejprob.txt CYpoints -ascii -double

