(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.4' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    495705,      10089]
NotebookOptionsPosition[    491497,      10026]
NotebookOutlinePosition[    491901,      10042]
CellTagsIndexPosition[    491858,      10039]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"dhl", ",", "al", ",", "ah"}], "}"}], "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"Import", "[", 
     RowBox[{"\"\<H:/mystuff/cred/IMbounds.dat\>\"", ",", "\"\<Table\>\""}], 
     "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Transpose", "[", 
     RowBox[{"{", 
      RowBox[{"dhl", ",", "al"}], "}"}], "]"}], ",", 
    RowBox[{"Transpose", "[", 
     RowBox[{"{", 
      RowBox[{"dhl", ",", "ah"}], "}"}], "]"}]}], "}"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"u", "[", "x_", "]"}], "=", 
  RowBox[{
   RowBox[{"Interpolation", "[", 
    RowBox[{"Transpose", "[", 
     RowBox[{"{", 
      RowBox[{"dhl", ",", "ah"}], "}"}], "]"}], "]"}], "[", "x", 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"l", "[", "x_", "]"}], "=", 
   RowBox[{
    RowBox[{"Interpolation", "[", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{"dhl", ",", "al"}], "}"}], "]"}], "]"}], "[", "x", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"rho", "=", "0"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"level", "=", "0.05"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Sig", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"2", "-", 
       RowBox[{"2", "rho"}]}], ",", 
      RowBox[{"rho", "-", "1"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"rho", "-", "1"}], ",", "1"}], "}"}]}], 
   "}"}]}], "\[IndentingNewLine]", 
 RowBox[{"omeg", "=", 
  RowBox[{"Sqrt", "[", 
   RowBox[{"1", "-", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"rho", "-", "1"}], ")"}], "^", "2"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "-", 
       RowBox[{"2", "rho"}]}], ")"}]}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kappa", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"rho", "-", "1"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"2", "-", 
      RowBox[{"2", "rho"}]}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"grid", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"j", "+", ".01"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", "10", ",", "0.2"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xdel", "=", "0.2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xgrid", "=", 
    RowBox[{"Table", "[", 
     RowBox[{"j", ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", 
        RowBox[{
         RowBox[{"Min", "[", "grid", "]"}], "-", "4"}], ",", 
        RowBox[{
         RowBox[{"Max", "[", "grid", "]"}], "+", "4"}], ",", "xdel"}], 
       "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"cv", "=", 
  RowBox[{"Quantile", "[", 
   RowBox[{
    RowBox[{"NormalDistribution", "[", 
     RowBox[{"0", ",", "1"}], "]"}], ",", 
    RowBox[{"1", "-", 
     RowBox[{"level", "/", "2"}]}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x_", ",", "th_"}], "]"}], "=", 
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"NormalDistribution", "[", 
      RowBox[{"th", ",", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"2", "-", 
         RowBox[{"2", "rho"}]}], "]"}]}], "]"}], ",", "x"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"w", "[", 
   RowBox[{"x_", ",", "th_"}], "]"}], "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"CDF", "[", 
       RowBox[{
        RowBox[{"NormalDistribution", "[", 
         RowBox[{"0", ",", "1"}], "]"}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"l", "[", "x", "]"}], "-", 
           RowBox[{"lam", " ", "th"}], "+", 
           RowBox[{"kappa", 
            RowBox[{"(", 
             RowBox[{"x", "-", "th"}], ")"}]}]}], ")"}], "/", "omeg"}]}], 
       "]"}], "+", "1", "-", 
      RowBox[{"CDF", "[", 
       RowBox[{
        RowBox[{"NormalDistribution", "[", 
         RowBox[{"0", ",", "1"}], "]"}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"u", "[", "x", "]"}], "-", 
           RowBox[{"lam", " ", "th"}], "+", 
           RowBox[{"kappa", 
            RowBox[{"(", 
             RowBox[{"x", "-", "th"}], ")"}]}]}], ")"}], "/", "omeg"}]}], 
       "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"lam", ",", "0", ",", "1"}], "}"}]}], "]"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Aavemw", "=", 
    RowBox[{"ParallelTable", "[", 
     RowBox[{
      RowBox[{"NIntegrate", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"f", "[", 
          RowBox[{"x", ",", 
           RowBox[{"grid", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}], "]"}], 
         RowBox[{"w", "[", 
          RowBox[{"x", ",", 
           RowBox[{"grid", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"xgrid", "[", 
           RowBox[{"[", "j", "]"}], "]"}], ",", 
          RowBox[{
           RowBox[{"xgrid", "[", 
            RowBox[{"[", "j", "]"}], "]"}], "+", "xdel"}]}], "}"}], ",", 
        RowBox[{"AccuracyGoal", "\[Rule]", "12"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"Length", "[", "grid", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "1", ",", 
        RowBox[{"Length", "[", "xgrid", "]"}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"B", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"NIntegrate", "[", 
       RowBox[{
        RowBox[{"f", "[", 
         RowBox[{"x", ",", 
          RowBox[{"grid", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"xgrid", "[", 
           RowBox[{"[", "j", "]"}], "]"}], ",", 
          RowBox[{
           RowBox[{"xgrid", "[", 
            RowBox[{"[", "j", "]"}], "]"}], "+", "xdel"}]}], "}"}]}], "]"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"Length", "[", "grid", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "1", ",", 
        RowBox[{"Length", "[", "xgrid", "]"}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"w", "[", 
   RowBox[{"x_", ",", "th_"}], "]"}], "=", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{
     RowBox[{"NormalDistribution", "[", 
      RowBox[{"0", ",", "1"}], "]"}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"l", "[", "x", "]"}], "-", 
        RowBox[{".5", "th"}], "+", 
        RowBox[{"kappa", 
         RowBox[{"(", 
          RowBox[{"x", "-", "th"}], ")"}]}]}], ")"}], "/", "omeg"}]}], "]"}], 
   "+", "1", "-", 
   RowBox[{"CDF", "[", 
    RowBox[{
     RowBox[{"NormalDistribution", "[", 
      RowBox[{"0", ",", "1"}], "]"}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"u", "[", "x", "]"}], "-", 
        RowBox[{".5", "th"}], "+", 
        RowBox[{"kappa", 
         RowBox[{"(", 
          RowBox[{"x", "-", "th"}], ")"}]}]}], ")"}], "/", "omeg"}]}], "]"}]}]
   }], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A05emw", "=", 
   RowBox[{"ParallelTable", "[", 
    RowBox[{
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"f", "[", 
         RowBox[{"x", ",", 
          RowBox[{"grid", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], "]"}], 
        RowBox[{"w", "[", 
         RowBox[{"x", ",", 
          RowBox[{"grid", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"xgrid", "[", 
          RowBox[{"[", "j", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"xgrid", "[", 
           RowBox[{"[", "j", "]"}], "]"}], "+", "xdel"}]}], "}"}], ",", 
       RowBox[{"AccuracyGoal", "\[Rule]", "12"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "grid", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "1", ",", 
       RowBox[{"Length", "[", "xgrid", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"w", "[", 
   RowBox[{"x_", ",", "th_"}], "]"}], "=", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{
     RowBox[{"NormalDistribution", "[", 
      RowBox[{"0", ",", "1"}], "]"}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"l", "[", "x", "]"}], "+", 
        RowBox[{"kappa", 
         RowBox[{"(", 
          RowBox[{"x", "-", "th"}], ")"}]}]}], ")"}], "/", "omeg"}]}], "]"}], 
   "+", "1", "-", 
   RowBox[{"CDF", "[", 
    RowBox[{
     RowBox[{"NormalDistribution", "[", 
      RowBox[{"0", ",", "1"}], "]"}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"u", "[", "x", "]"}], "+", 
        RowBox[{"kappa", 
         RowBox[{"(", 
          RowBox[{"x", "-", "th"}], ")"}]}]}], ")"}], "/", "omeg"}]}], 
    "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A00emw", "=", 
   RowBox[{"ParallelTable", "[", 
    RowBox[{
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"f", "[", 
         RowBox[{"x", ",", 
          RowBox[{"grid", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], "]"}], 
        RowBox[{"w", "[", 
         RowBox[{"x", ",", 
          RowBox[{"grid", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"xgrid", "[", 
          RowBox[{"[", "j", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"xgrid", "[", 
           RowBox[{"[", "j", "]"}], "]"}], "+", "xdel"}]}], "}"}], ",", 
       RowBox[{"AccuracyGoal", "\[Rule]", "12"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "grid", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "1", ",", 
       RowBox[{"Length", "[", "xgrid", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"w", "[", 
   RowBox[{"x_", ",", "th_"}], "]"}], "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"CDF", "[", 
       RowBox[{
        RowBox[{"NormalDistribution", "[", 
         RowBox[{"0", ",", "1"}], "]"}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"l", "[", "x", "]"}], "-", 
           RowBox[{"lam", " ", "th"}], "+", 
           RowBox[{"kappa", 
            RowBox[{"(", 
             RowBox[{"x", "-", "th"}], ")"}]}]}], ")"}], "/", "omeg"}]}], 
       "]"}], "+", "1", "-", 
      RowBox[{"CDF", "[", 
       RowBox[{
        RowBox[{"NormalDistribution", "[", 
         RowBox[{"0", ",", "1"}], "]"}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"u", "[", "x", "]"}], "-", 
           RowBox[{"lam", " ", "th"}], "+", 
           RowBox[{"kappa", 
            RowBox[{"(", 
             RowBox[{"x", "-", "th"}], ")"}]}]}], ")"}], "/", "omeg"}]}], 
       "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"lam", ",", "0", ",", "1"}], "}"}]}], "]"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Aavemw", "=", 
    RowBox[{"ParallelTable", "[", 
     RowBox[{
      RowBox[{"NIntegrate", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"f", "[", 
          RowBox[{"x", ",", 
           RowBox[{"grid", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}], "]"}], 
         RowBox[{"w", "[", 
          RowBox[{"x", ",", 
           RowBox[{"grid", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"xgrid", "[", 
           RowBox[{"[", "j", "]"}], "]"}], ",", 
          RowBox[{
           RowBox[{"xgrid", "[", 
            RowBox[{"[", "j", "]"}], "]"}], "+", "xdel"}]}], "}"}], ",", 
        RowBox[{"AccuracyGoal", "\[Rule]", "12"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"Length", "[", "grid", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "1", ",", 
        RowBox[{"Length", "[", "xgrid", "]"}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"w", "[", 
   RowBox[{"x_", ",", "th_"}], "]"}], "=", 
  RowBox[{"Piecewise", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"x", "<", 
        RowBox[{
         RowBox[{"-", "2"}], " ", "cv"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Simplify", "[", 
        RowBox[{
         RowBox[{"CDF", "[", 
          RowBox[{
           RowBox[{"NormalDistribution", "[", 
            RowBox[{"0", ",", "1"}], "]"}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "cv"}], "-", 
              RowBox[{"0.5", "th"}], "+", 
              RowBox[{"kappa", 
               RowBox[{"(", 
                RowBox[{"x", "-", "th"}], ")"}]}]}], ")"}], "/", "omeg"}]}], 
          "]"}], "+", "1", "-", 
         RowBox[{"CDF", "[", 
          RowBox[{
           RowBox[{"NormalDistribution", "[", 
            RowBox[{"0", ",", "1"}], "]"}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"x", "+", "cv", "-", 
              RowBox[{"0.5", "th"}], "+", 
              RowBox[{"kappa", 
               RowBox[{"(", 
                RowBox[{"x", "-", "th"}], ")"}]}]}], ")"}], "/", "omeg"}]}], 
          "]"}]}], "]"}], ",", "True"}], "}"}]}], "}"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A05st", "=", 
   RowBox[{"ParallelTable", "[", 
    RowBox[{
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"f", "[", 
         RowBox[{"x", ",", 
          RowBox[{"grid", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], "]"}], 
        RowBox[{"w", "[", 
         RowBox[{"x", ",", 
          RowBox[{"grid", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"xgrid", "[", 
          RowBox[{"[", "j", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"xgrid", "[", 
           RowBox[{"[", "j", "]"}], "]"}], "+", "xdel"}]}], "}"}], ",", 
       RowBox[{"AccuracyGoal", "\[Rule]", "12"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "grid", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "1", ",", 
       RowBox[{"Length", "[", "xgrid", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"w", "[", 
   RowBox[{"x_", ",", "th_"}], "]"}], "=", 
  RowBox[{"Piecewise", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"x", "<", 
        RowBox[{
         RowBox[{"-", "2"}], " ", "cv"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Simplify", "[", 
        RowBox[{
         RowBox[{"CDF", "[", 
          RowBox[{
           RowBox[{"NormalDistribution", "[", 
            RowBox[{"0", ",", "1"}], "]"}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "cv"}], "+", 
              RowBox[{"kappa", 
               RowBox[{"(", 
                RowBox[{"x", "-", "th"}], ")"}]}]}], ")"}], "/", "omeg"}]}], 
          "]"}], "+", "1", "-", 
         RowBox[{"CDF", "[", 
          RowBox[{
           RowBox[{"NormalDistribution", "[", 
            RowBox[{"0", ",", "1"}], "]"}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"x", "+", "cv", "+", 
              RowBox[{"kappa", 
               RowBox[{"(", 
                RowBox[{"x", "-", "th"}], ")"}]}]}], ")"}], "/", "omeg"}]}], 
          "]"}]}], "]"}], ",", "True"}], "}"}]}], "}"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A00st", "=", 
   RowBox[{"ParallelTable", "[", 
    RowBox[{
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"f", "[", 
         RowBox[{"x", ",", 
          RowBox[{"grid", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], "]"}], 
        RowBox[{"w", "[", 
         RowBox[{"x", ",", 
          RowBox[{"grid", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"xgrid", "[", 
          RowBox[{"[", "j", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"xgrid", "[", 
           RowBox[{"[", "j", "]"}], "]"}], "+", "xdel"}]}], "}"}], ",", 
       RowBox[{"AccuracyGoal", "\[Rule]", "12"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "grid", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "1", ",", 
       RowBox[{"Length", "[", "xgrid", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"w", "[", 
   RowBox[{"x_", ",", "th_"}], "]"}], "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Piecewise", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"x", "<", 
           RowBox[{
            RowBox[{"-", "2"}], " ", "cv"}]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Simplify", "[", 
           RowBox[{
            RowBox[{"CDF", "[", 
             RowBox[{
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "1"}], "]"}], ",", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "cv"}], "-", 
                 RowBox[{"lam", " ", "th"}], "+", 
                 RowBox[{"kappa", 
                  RowBox[{"(", 
                   RowBox[{"x", "-", "th"}], ")"}]}]}], ")"}], "/", 
               "omeg"}]}], "]"}], "+", "1", "-", 
            RowBox[{"CDF", "[", 
             RowBox[{
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "1"}], "]"}], ",", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"x", "+", "cv", "-", 
                 RowBox[{"lam", " ", "th"}], "+", 
                 RowBox[{"kappa", 
                  RowBox[{"(", 
                   RowBox[{"x", "-", "th"}], ")"}]}]}], ")"}], "/", 
               "omeg"}]}], "]"}]}], "]"}], ",", "True"}], "}"}]}], "}"}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"lam", ",", "0", ",", "1"}], "}"}]}], "]"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Aavst", "=", 
   RowBox[{"ParallelTable", "[", 
    RowBox[{
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"f", "[", 
         RowBox[{"x", ",", 
          RowBox[{"grid", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], "]"}], 
        RowBox[{"w", "[", 
         RowBox[{"x", ",", 
          RowBox[{"grid", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"xgrid", "[", 
          RowBox[{"[", "j", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"xgrid", "[", 
           RowBox[{"[", "j", "]"}], "]"}], "+", "xdel"}]}], "}"}], ",", 
       RowBox[{"AccuracyGoal", "\[Rule]", "12"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "grid", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "1", ",", 
       RowBox[{"Length", "[", "xgrid", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.672312399054838*^9, 3.6723125557985115`*^9}, {
   3.67231304903183*^9, 3.672313058058732*^9}, {3.672313112995225*^9, 
   3.672313150165942*^9}, {3.672313220732998*^9, 3.672313232093134*^9}, {
   3.672397300562496*^9, 3.672397321908631*^9}, {3.6723973901204515`*^9, 
   3.672397395238963*^9}, {3.672397512332671*^9, 3.6723975251159496`*^9}, {
   3.672401382252714*^9, 3.6724014184783363`*^9}, {3.672402627196196*^9, 
   3.6724026321396904`*^9}, {3.672403507995267*^9, 3.6724035417836456`*^9}, 
   3.6724044859820557`*^9},ExpressionUUID->"1ceab222-40dd-4c77-8cd9-\
3e00efc88346"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.007333333333333334], 
     AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxd1AlMVEcYAOBlWY7lXK4FuZdlgVIPBApCKW+oUqxEcRGqUdNGBbQe4FFA
BEslxWITwAMREChYwAssiFAIgRk1QU4RrSJCioKlVawFD473lqX63jxMZpLN
5s+b/5v3/vnzy7bGhUcLBQJB3bvf+39uWaHiZ2GDuwMNUUH++2WJwruDll4Y
MEBe7LJE4lUJe0ySDFB31/slRfoDTbqVUgMUwy4p8i9T3kq+po84T4rCk8+j
H8P1sWeBCuprYjrH9bBngbaNDmRGZOthzxyVmFfEKxbrYc8c9aVP9y7vFmPP
HLl7+t+v2y3Gnhly8fH5NM1AjD0ztCpwMKK6Uhd7pqhC+bf5ytW62DNFDYHx
duEvdbBnihxtz9zuy9bBngkqPvk4cmSpDvZM0PnaqZbUP7SxJ0FhuTKtxkRt
7EnQl+uRotBGG3sSlNpR6eWLtHC+MarcvnJXfrQW3m+E3rabhNzT10LscfmG
qC88NmfyqgixfJcBopsDMqSbRNgzQLE2RXdDRCLs6aPOV241JVc0saeHluzJ
Uy/bqIk9Maq/mB7orqOJPV2U8VvZr9l1Quzpopr+zUZHo4XY00EPlvlrLLQU
Yk8baV5bklHaoYE9LaR0cjPW/UEDeyL07wm1PM1XA3siFNzS4uA1IcCeJspr
c68NrBJgT4h82h3Xte0SYE8DhUx0p71aKMCeAGnrX5lqejIH57gFF801xSnj
5mA0m6+GCSrT1n7hHOT2q+DaqysyUgvV0JM9j4Exz+D6LQFqmMf6M7Ay43Ph
8eFZ7E3Ba5n9mobZs9ibhGMPzUrag2ax9waKpr6ur6BV2HsNI0uPRMU3qrA3
ATNVku+mD6ugmvX+g8GxRw6OhqhgB5v/AkaJL8e9kKrgGXb/Myg55n6p+jkD
o9jzRmHwEN18/wYDPVh/BMKy8tDZYgbSrDcE9wwrdnV8z8AcNr8fbvmrqnxk
CwMXs/vvQUHUqX1vQhiYxT5vh5uLPL2ueDAwjY0b4WdRa3rabBjI3UdDwKCf
5ROhmIFXuedUuYPTBdk0DSu4fGpthO2N8X9o6M/51A7Xl9eDBmhYwp1P7Z22
rh27TUNN1ntMjdywPd1xk4Y+3PtTQ4WlfS2NNNzJfR9VutH5z8pqGhZx3095
y7dnp1yg4R2uPtS35x6+tiqlITdjxinbmJ6ncQU0PMvVl7Jqq+nel0PDT7j6
U/oeSakm2TTs4e6H8j6/W7riZxru4O6PyvHaNCE4ynvTlGXMTENQGg0Lufun
vFqXxwtTeY+hug4/rQpK4T0V9VXHmROCQ7ynplLa9zosP0hDDa6AwCKrOVSS
SMPbXH+Cu9Bjwf4E/n01wPrp2aL4d/F2rr9BSdm9Mfd3+725/gc66R/1ls17
IuD/Kmzn9CHeEwHGxi0p4Hve0wKPXHOTM9L499EG7s43D73+ifd0wN6Gb46f
zOI9XXDw5VF5Yi7v6YIVufefVv7Ce2JQnfMgz/cS7+kBeeedNkk97+mDKnFV
suIm7xmAzcuGZRG9vGcA9nVuGt35mPcMAfKby3MZ5z0jcHmobpungMGeMZhy
DI5zkzDYk4CMUnjslAOD6yMB5bl9rROLGIjnJ3hUlzv5uz+fbwKUoeN1kcEM
xPMXrIx06fRbzXumYMdgQtIDJe+Zgh7N4ZTycN4zBS2ma2M/DuM9M/BojVcM
/QXvmQE7/wOdtX68Zw4Kzk4qxa68Zw6Me28FNBsx+PvNwcjpWOG5cb5eFsAx
9HlCfheNPQug9OwpPnWOr58UDKkHQzP38/0gBZc3bC3OCuDrKQUJCZIjFwW8
Zwla365bMt0ygz1LsM53Q+/ZxBnsWYEDJ697N7nPQG5+WoHwBvv0MSWN59WH
mJu3C+Zjbr5+iLl2tp6POc+a8KwJz4bwbAjPlvBsCc+W8OwIz47w7AnPnvDs
Cc+B8BwIz5HY70j4jkT+h5jrJ0fCkxGejPBkhCcjPBnhORGeE+F9iLn+cCI8
J8KTE56c8OSEJyc8OeE5E54z4TkTnjPhOROegvAUhKcgPAXhKQjPhfBcCM+F
8FwIz4XwXAnPlfBcCc+V8FwJz20+/h9IvnPL
      "]]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], PointSize[0.007333333333333334], 
     AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJwt1A1UlFUaB/CZkcFhGGBmmGH4GIb5ngE3ozS1NbyPuSvFpmkHLWrrBMnH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      "]]}, {}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-6., 12.}, {-3.655481072605837, 13.645}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.6723975263250704`*^9, 3.6724014204215307`*^9, 
  3.672402635264003*^9, 3.672403555918059*^9, 3.67240452433189*^9, 
  3.672572636822505*^9},ExpressionUUID->"5d8f31df-0d32-46a3-a72f-\
afe1c0e1b3de"],

Cell[BoxData[
 RowBox[{
  TagBox[
   TemplateBox[{
     RowBox[{
       StyleBox[
        TagBox["InterpolatingFunction", "SummaryHead"], 
        "NonInterpretableSummary"], 
       StyleBox["[", "NonInterpretableSummary"], 
       DynamicModuleBox[{Typeset`open$$ = False}, 
        PanelBox[
         PaneSelectorBox[{False -> GridBox[{{
               PaneBox[
                ButtonBox[
                 DynamicBox[
                  FEPrivate`FrontEndResource[
                  "FEBitmaps", "SquarePlusIconMedium"]], 
                 ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                 None, Evaluator -> Automatic, Method -> "Preemptive"], 
                Alignment -> {Center, Center}, ImageSize -> 
                Dynamic[{
                  Automatic, 
                   3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
               GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAGa+G6///F8AEPYEOk8ECwLHNhJqG
0xbAOppvSOyJAcAYzwMVx40VwIC0Y+UGNgDAoWKExp1dFMCbPA++huz9v9lN
huBrMxPATRVP/+Rz+7/hGwnG8+8RwAHZZZCkvfi/CXyN4hHCEMBFukjVMyz2
vwN+JZXT9Q7AaLVAkHFW879UszI2cnMMwPQWO6i8fPC/5wxDRT0cCsD8lZs0
BIHrvxksVet7kgfAYnVUK05c5b+Mb2r/5jMFwDpdPf02wd6/YGKC5EDhAsA0
h5/BEXTSv9ManGAOXADA5qUmemthsb8O73GVEAT8vzRFKI5cRMM/tDOvl+vq
9r9R+X/uwLzZPxzX8Tuk6fG/LcAJqgk/5T8NhnV4a33qv3C58SKnb+0/XnQO
1Vxd4L/U+5Ihm1PzP9POz6b/p8u/SPSteEC/9z/Fs/ssdZy6Pw/Fi3pHofw/
R0bQ4cPC2j9L6fbywL4AQMk+JISDwuY/9Q+2BHwIA0D5oaxd63bwPweiM2vG
hwVAC9xAHTw29T+HFWovrd8HQFu3zzqv3fk/vhTj3hkuCkBuB1sqO+r+P/GA
g/YFsQxAfwfwHjfQAUCRRCcGgQsPQKjFsBHdXQRAmlTynQTOEEBw1G4zlN8G
QCJzXSG4EhJA974p5x42CUCjoywXS0QTQN/j4gM2vwtA+q57CMqSFECF5Jiy
IB0OQGAutNQszRVA5RomSI43EEBIV3yfcAEXQLngfmvSeRFAO0fJ8ZhMGEBs
FNZXgKYSQGun/0XAehlAT2WseHTsE0CF2aosNrcaQBIkgWLSHBVASvL1URHS
G0Aki9TjOEcWQOIiBOKg2hxAZg+nmeWKF0CuhqhBcusdQIcBeBj8uBhAFyy4
dMFPH0DaEMjLWAAaQHffh9ZpSiBAfMiWFr5BG0BJO+97HOsgQP3tYyqNbRxA
CM7VBQSBIUCvMLByorIdQGLv+6mOIyJAQeH6gyHiHkCrR6EyTrsiQBEdYpbU
BSBAG/QFBxJQI0AZWAaFO6cgQCMvqvV48SNAEcopWNc9IUAboc3IFIgkQKHK
jEUW4SFAq6EwtlMrJUBZH69+WYEiQGP2Uu+WyyVAAatQnNEWI0ALgvQMD2Em
QEHFMdTsuCNAS5zVRCoDJ0BxFpLwPFAkQHvtNWF6midAOfYxJzD0JEBDzdWX
bT4oQCkqkaknlSVAMwE1GmXfKEAIlW8QVCsmQBJsE4GRdSlAgI6NkSPOJkCK
ZTECYRgqQOe+KvcnZidA8ZXOZ2WwKkCNV8P1//8nQJcuZ2Y9SitALwmyqA==

                    "]]}}}, {}}, {
                DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                 All, DisplayFunction -> Identity, AspectRatio -> 1, 
                 Axes -> {False, False}, AxesLabel -> {None, None}, 
                 AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                 Frame -> {{True, True}, {True, True}}, 
                 FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                 Directive[
                   Opacity[0.5], 
                   Thickness[Tiny], 
                   RGBColor[0.368417, 0.506779, 0.709798]], 
                 FrameTicks -> {{None, None}, {None, None}}, 
                 GridLines -> {None, None}, GridLinesStyle -> Directive[
                   GrayLevel[0.5, 0.4]], ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                 Method -> {
                  "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                   AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                 PlotRange -> {{-6., 12.}, {-2.3445187695684826`, 
                  13.644999694915255`}}, PlotRangeClipping -> True, 
                 PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
               GridBox[{{
                  RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                  RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
                False, GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                GridBoxSpacings -> {
                 "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                BaseStyle -> {
                 ShowStringCharacters -> False, NumberMarks -> False, 
                  PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
             GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             BaselinePosition -> {1, 1}], True -> GridBox[{{
               PaneBox[
                ButtonBox[
                 DynamicBox[
                  FEPrivate`FrontEndResource[
                  "FEBitmaps", "SquareMinusIconMedium"]], 
                 ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                 None, Evaluator -> Automatic, Method -> "Preemptive"], 
                Alignment -> {Center, Center}, ImageSize -> 
                Dynamic[{
                  Automatic, 
                   3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
               GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAGa+G6///F8AEPYEOk8ECwLHNhJqG
0xbAOppvSOyJAcAYzwMVx40VwIC0Y+UGNgDAoWKExp1dFMCbPA++huz9v9lN
huBrMxPATRVP/+Rz+7/hGwnG8+8RwAHZZZCkvfi/CXyN4hHCEMBFukjVMyz2
vwN+JZXT9Q7AaLVAkHFW879UszI2cnMMwPQWO6i8fPC/5wxDRT0cCsD8lZs0
BIHrvxksVet7kgfAYnVUK05c5b+Mb2r/5jMFwDpdPf02wd6/YGKC5EDhAsA0
h5/BEXTSv9ManGAOXADA5qUmemthsb8O73GVEAT8vzRFKI5cRMM/tDOvl+vq
9r9R+X/uwLzZPxzX8Tuk6fG/LcAJqgk/5T8NhnV4a33qv3C58SKnb+0/XnQO
1Vxd4L/U+5Ihm1PzP9POz6b/p8u/SPSteEC/9z/Fs/ssdZy6Pw/Fi3pHofw/
R0bQ4cPC2j9L6fbywL4AQMk+JISDwuY/9Q+2BHwIA0D5oaxd63bwPweiM2vG
hwVAC9xAHTw29T+HFWovrd8HQFu3zzqv3fk/vhTj3hkuCkBuB1sqO+r+P/GA
g/YFsQxAfwfwHjfQAUCRRCcGgQsPQKjFsBHdXQRAmlTynQTOEEBw1G4zlN8G
QCJzXSG4EhJA974p5x42CUCjoywXS0QTQN/j4gM2vwtA+q57CMqSFECF5Jiy
IB0OQGAutNQszRVA5RomSI43EEBIV3yfcAEXQLngfmvSeRFAO0fJ8ZhMGEBs
FNZXgKYSQGun/0XAehlAT2WseHTsE0CF2aosNrcaQBIkgWLSHBVASvL1URHS
G0Aki9TjOEcWQOIiBOKg2hxAZg+nmeWKF0CuhqhBcusdQIcBeBj8uBhAFyy4
dMFPH0DaEMjLWAAaQHffh9ZpSiBAfMiWFr5BG0BJO+97HOsgQP3tYyqNbRxA
CM7VBQSBIUCvMLByorIdQGLv+6mOIyJAQeH6gyHiHkCrR6EyTrsiQBEdYpbU
BSBAG/QFBxJQI0AZWAaFO6cgQCMvqvV48SNAEcopWNc9IUAboc3IFIgkQKHK
jEUW4SFAq6EwtlMrJUBZH69+WYEiQGP2Uu+WyyVAAatQnNEWI0ALgvQMD2Em
QEHFMdTsuCNAS5zVRCoDJ0BxFpLwPFAkQHvtNWF6midAOfYxJzD0JEBDzdWX
bT4oQCkqkaknlSVAMwE1GmXfKEAIlW8QVCsmQBJsE4GRdSlAgI6NkSPOJkCK
ZTECYRgqQOe+KvcnZidA8ZXOZ2WwKkCNV8P1//8nQJcuZ2Y9SitALwmyqA==

                    "]]}}}, {}}, {
                DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                 All, DisplayFunction -> Identity, AspectRatio -> 1, 
                 Axes -> {False, False}, AxesLabel -> {None, None}, 
                 AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                 Frame -> {{True, True}, {True, True}}, 
                 FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                 Directive[
                   Opacity[0.5], 
                   Thickness[Tiny], 
                   RGBColor[0.368417, 0.506779, 0.709798]], 
                 FrameTicks -> {{None, None}, {None, None}}, 
                 GridLines -> {None, None}, GridLinesStyle -> Directive[
                   GrayLevel[0.5, 0.4]], ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                 Method -> {
                  "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                   AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                 PlotRange -> {{-6., 12.}, {-2.3445187695684826`, 
                  13.644999694915255`}}, PlotRangeClipping -> True, 
                 PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
               GridBox[{{
                  RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                  RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}, {
                  RowBox[{
                    TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["3", "SummaryItem"]}]}, {
                  RowBox[{
                    TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                  RowBox[{
                    TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["False", "SummaryItem"]}]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
                False, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                GridBoxSpacings -> {
                 "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                BaseStyle -> {
                 ShowStringCharacters -> False, NumberMarks -> False, 
                  PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
             GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             BaselinePosition -> {1, 1}]}, 
          Dynamic[Typeset`open$$], ImageSize -> Automatic], BaselinePosition -> 
         Baseline], DynamicModuleValues :> {}], 
       StyleBox["]", "NonInterpretableSummary"]}]},
    "CopyTag",
    DisplayFunction->(#& ),
    InterpretationFunction->("InterpolatingFunction[{{-6., 12.}}, <>]"& )],
   False,
   Editable->False,
   SelectWithContents->True,
   Selectable->False], "[", "x", "]"}]], "Output",
 CellChangeTimes->{3.6723975263250704`*^9, 3.6724014204215307`*^9, 
  3.672402635264003*^9, 3.672403555918059*^9, 3.67240452433189*^9, 
  3.6725726369405165`*^9},ExpressionUUID->"ed24cc01-6f1f-4452-8d12-\
8eb8a9a38f5f"],

Cell[BoxData[
 RowBox[{
  TagBox[
   TemplateBox[{
     RowBox[{
       StyleBox[
        TagBox["InterpolatingFunction", "SummaryHead"], 
        "NonInterpretableSummary"], 
       StyleBox["[", "NonInterpretableSummary"], 
       DynamicModuleBox[{Typeset`open$$ = False}, 
        PanelBox[
         PaneSelectorBox[{False -> GridBox[{{
               PaneBox[
                ButtonBox[
                 DynamicBox[
                  FEPrivate`FrontEndResource[
                  "FEBitmaps", "SquarePlusIconMedium"]], 
                 ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                 None, Evaluator -> Automatic, Method -> "Preemptive"], 
                Alignment -> {Center, Center}, ImageSize -> 
                Dynamic[{
                  Automatic, 
                   3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
               GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJxFzn9Q02UABvCN/XKKaxM2YWwTHPJ10zOFmtTQvURGZgR5dE5xxq3DvEBo
BIRJBAjjSMad2JR2lEIeVHA3Ey+XZ3tfRyhJwmIrLoqDTScnA4ELhrxfdNk/
3/3x3HOfv54nTl+0Py+MRqOlPMv/HW01+oPB9WhbXGN/we616Ie7tRajS4Q2
0y3TsdJwFDXEEN42CZH14Tev1vtWozZ97a2vdJFoIYG+7fEvXPRXhnEiPykC
hQvyUn3dq5Anhnvr31kBemXfeJqwmoO4FSavwMFHs5ayUW4hGzEqN5ldizyU
JWfdtbzBQtk9iarij8LR34TQG/EiE02Gp+3ZJVmNjhGS5BU1A0Vvfcd/spmD
bvKqco+pw1Bj0QfBB0ks5Ot1bEA5dJSrr7kPPGHopOGtbnszDbnErbm8wzS0
d8DMZbcHIW/WYOYzV+DVJRXRWvAUXk2ynvdPBSAnMdMVc+gJlIzMqy89nIeJ
1wJ8RcMKXGssLc//dAraL/RkNARIeKSE98dh3QRkqMSNe2tI6Boc6gh2DkD5
o/rj4AUS9vWQW0tbr2uGuTeIqiUM019zenodoxrmzRMzzt8w/HV3fO0pxwON
kXYo/Ucrhstt3Tp/2Zwmsv16eVsLhmv+AdIU1aImLPNsqqwBw5xrQy9bx5Y1
zxcHamorMSzk5CjVU081pbjL4fwYw884c7KdTjpI+KRw8GwZht/2XRaM6ZhA
dPv9bG0Fhh+6C5O+GGeDLnmLzHYawyW7YlKm4oKL/HebHl3CcPyel6GCa4By
YbP4xrN/dfdbrsRKeaBk7usZA8bQJ054vWknHzTNa3UNBAl/mqjMHz4hACyL
Ilq8j4QFkX8eqOpYB5hvdtiCWSTMzOsuL5mOACPO5SH2FhKui6/WD0uEwJvs
+pl0Yxh/2n0vOV0EFo7YH1/IwPDoc51f+j5fD2RjrIuJNcuwnl4etWKLAmnf
0wzCHAxH+f0DWpoY7LfJ6vxvY1jRf05kT42h/GTmPaXpuISydfvl4vYrUsqp
HnwqziujLJDqz7lZsZSjtew6dWfIgjsK7ciuOMptdxr3iDwhH9xgrTxYvZEy
vSur9XeRPLTXt8M9bQvZIGqeS8mKp/xSYAexfSFkhfLMd4R5E+VV5iJ+9pYE
ylVNpjPywZAn7col4ihB2XSgdzEYDPk/F+PlOQ==
                    "]]}}}, {}}, {
                DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                 All, DisplayFunction -> Identity, AspectRatio -> 1, 
                 Axes -> {False, False}, AxesLabel -> {None, None}, 
                 AxesOrigin -> {0, -3.9000000000000004`}, DisplayFunction :> 
                 Identity, Frame -> {{True, True}, {True, True}}, 
                 FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                 Directive[
                   Opacity[0.5], 
                   Thickness[Tiny], 
                   RGBColor[0.368417, 0.506779, 0.709798]], 
                 FrameTicks -> {{None, None}, {None, None}}, 
                 GridLines -> {None, None}, GridLinesStyle -> Directive[
                   GrayLevel[0.5, 0.4]], ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                 Method -> {
                  "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                   AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                 PlotRange -> {{-6., 
                  12.}, {-3.6554809253467715`, -1.5942865610975967`}}, 
                 PlotRangeClipping -> True, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
               GridBox[{{
                  RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                  RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
                False, GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                GridBoxSpacings -> {
                 "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                BaseStyle -> {
                 ShowStringCharacters -> False, NumberMarks -> False, 
                  PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
             GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             BaselinePosition -> {1, 1}], True -> GridBox[{{
               PaneBox[
                ButtonBox[
                 DynamicBox[
                  FEPrivate`FrontEndResource[
                  "FEBitmaps", "SquareMinusIconMedium"]], 
                 ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                 None, Evaluator -> Automatic, Method -> "Preemptive"], 
                Alignment -> {Center, Center}, ImageSize -> 
                Dynamic[{
                  Automatic, 
                   3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
               GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJxFzn9Q02UABvCN/XKKaxM2YWwTHPJ10zOFmtTQvURGZgR5dE5xxq3DvEBo
BIRJBAjjSMad2JR2lEIeVHA3Ey+XZ3tfRyhJwmIrLoqDTScnA4ELhrxfdNk/
3/3x3HOfv54nTl+0Py+MRqOlPMv/HW01+oPB9WhbXGN/we616Ie7tRajS4Q2
0y3TsdJwFDXEEN42CZH14Tev1vtWozZ97a2vdJFoIYG+7fEvXPRXhnEiPykC
hQvyUn3dq5Anhnvr31kBemXfeJqwmoO4FSavwMFHs5ayUW4hGzEqN5ldizyU
JWfdtbzBQtk9iarij8LR34TQG/EiE02Gp+3ZJVmNjhGS5BU1A0Vvfcd/spmD
bvKqco+pw1Bj0QfBB0ks5Ot1bEA5dJSrr7kPPGHopOGtbnszDbnErbm8wzS0
d8DMZbcHIW/WYOYzV+DVJRXRWvAUXk2ynvdPBSAnMdMVc+gJlIzMqy89nIeJ
1wJ8RcMKXGssLc//dAraL/RkNARIeKSE98dh3QRkqMSNe2tI6Boc6gh2DkD5
o/rj4AUS9vWQW0tbr2uGuTeIqiUM019zenodoxrmzRMzzt8w/HV3fO0pxwON
kXYo/Ucrhstt3Tp/2Zwmsv16eVsLhmv+AdIU1aImLPNsqqwBw5xrQy9bx5Y1
zxcHamorMSzk5CjVU081pbjL4fwYw884c7KdTjpI+KRw8GwZht/2XRaM6ZhA
dPv9bG0Fhh+6C5O+GGeDLnmLzHYawyW7YlKm4oKL/HebHl3CcPyel6GCa4By
YbP4xrN/dfdbrsRKeaBk7usZA8bQJ054vWknHzTNa3UNBAl/mqjMHz4hACyL
Ilq8j4QFkX8eqOpYB5hvdtiCWSTMzOsuL5mOACPO5SH2FhKui6/WD0uEwJvs
+pl0Yxh/2n0vOV0EFo7YH1/IwPDoc51f+j5fD2RjrIuJNcuwnl4etWKLAmnf
0wzCHAxH+f0DWpoY7LfJ6vxvY1jRf05kT42h/GTmPaXpuISydfvl4vYrUsqp
HnwqziujLJDqz7lZsZSjtew6dWfIgjsK7ciuOMptdxr3iDwhH9xgrTxYvZEy
vSur9XeRPLTXt8M9bQvZIGqeS8mKp/xSYAexfSFkhfLMd4R5E+VV5iJ+9pYE
ylVNpjPywZAn7col4ihB2XSgdzEYDPk/F+PlOQ==
                    "]]}}}, {}}, {
                DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                 All, DisplayFunction -> Identity, AspectRatio -> 1, 
                 Axes -> {False, False}, AxesLabel -> {None, None}, 
                 AxesOrigin -> {0, -3.9000000000000004`}, DisplayFunction :> 
                 Identity, Frame -> {{True, True}, {True, True}}, 
                 FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                 Directive[
                   Opacity[0.5], 
                   Thickness[Tiny], 
                   RGBColor[0.368417, 0.506779, 0.709798]], 
                 FrameTicks -> {{None, None}, {None, None}}, 
                 GridLines -> {None, None}, GridLinesStyle -> Directive[
                   GrayLevel[0.5, 0.4]], ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                 Method -> {
                  "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                   AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                 PlotRange -> {{-6., 
                  12.}, {-3.6554809253467715`, -1.5942865610975967`}}, 
                 PlotRangeClipping -> True, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
               GridBox[{{
                  RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                  RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}, {
                  RowBox[{
                    TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["3", "SummaryItem"]}]}, {
                  RowBox[{
                    TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                  RowBox[{
                    TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["False", "SummaryItem"]}]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
                False, GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                GridBoxSpacings -> {
                 "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                BaseStyle -> {
                 ShowStringCharacters -> False, NumberMarks -> False, 
                  PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
             GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             BaselinePosition -> {1, 1}]}, 
          Dynamic[Typeset`open$$], ImageSize -> Automatic], BaselinePosition -> 
         Baseline], DynamicModuleValues :> {}], 
       StyleBox["]", "NonInterpretableSummary"]}]},
    "CopyTag",
    DisplayFunction->(#& ),
    InterpretationFunction->("InterpolatingFunction[{{-6., 12.}}, <>]"& )],
   False,
   Editable->False,
   SelectWithContents->True,
   Selectable->False], "[", "x", "]"}]], "Output",
 CellChangeTimes->{3.6723975263250704`*^9, 3.6724014204215307`*^9, 
  3.672402635264003*^9, 3.672403555918059*^9, 3.67240452433189*^9, 
  3.672572636961519*^9},ExpressionUUID->"3e221838-7f28-42aa-bc00-\
8ac0ae471dc8"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.6723975263250704`*^9, 3.6724014204215307`*^9, 
  3.672402635264003*^9, 3.672403555918059*^9, 3.67240452433189*^9, 
  3.6725726369625187`*^9},ExpressionUUID->"36bb7b11-e8a6-4941-9df3-\
120bd0f4b245"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6723975263250704`*^9, 3.6724014204215307`*^9, 
  3.672402635264003*^9, 3.672403555918059*^9, 3.67240452433189*^9, 
  3.672572636963519*^9},ExpressionUUID->"d6487f5f-60ec-4bbc-a5ec-\
eae0d3739585"],

Cell[BoxData[
 FractionBox["1", 
  SqrtBox["2"]]], "Output",
 CellChangeTimes->{3.6723975263250704`*^9, 3.6724014204215307`*^9, 
  3.672402635264003*^9, 3.672403555918059*^9, 3.67240452433189*^9, 
  3.6725726369645195`*^9},ExpressionUUID->"de279a16-2280-4be9-9925-\
c66d6b75b458"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["1", "2"]}]], "Output",
 CellChangeTimes->{3.6723975263250704`*^9, 3.6724014204215307`*^9, 
  3.672402635264003*^9, 3.672403555918059*^9, 3.67240452433189*^9, 
  3.6725726369645195`*^9},ExpressionUUID->"bafa4f6e-3f11-4a0d-a437-\
4c0954171b3a"],

Cell[BoxData["1.959963984540054`"], "Output",
 CellChangeTimes->{3.6723975263250704`*^9, 3.6724014204215307`*^9, 
  3.672402635264003*^9, 3.672403555918059*^9, 3.67240452433189*^9, 
  3.6725726376345863`*^9},ExpressionUUID->"382c45ad-4ad4-4594-8d5c-\
d525e886ba71"],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "4"]}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "th"}], "+", "x"}], ")"}], "2"]}]], 
  RowBox[{"2", " ", 
   SqrtBox["\[Pi]"]}]]], "Output",
 CellChangeTimes->{3.6723975263250704`*^9, 3.6724014204215307`*^9, 
  3.672402635264003*^9, 3.672403555918059*^9, 3.67240452433189*^9, 
  3.6725726376355863`*^9},ExpressionUUID->"25a64b4c-1dc0-4516-b223-\
a9244f15296f"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "4"], " ", 
  RowBox[{"(", 
   RowBox[{"4", "+", 
    RowBox[{
     FractionBox["1", "th"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", 
             FractionBox["1", "4"]}], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"th", "+", "x", "-", 
               RowBox[{"2", " ", 
                RowBox[{
                 TagBox[
                  TemplateBox[{
                    RowBox[{
                    StyleBox[
                    TagBox["InterpolatingFunction", "SummaryHead"], 
                    "NonInterpretableSummary"], 
                    StyleBox["[", "NonInterpretableSummary"], 
                    DynamicModuleBox[{Typeset`open$$ = False}, 
                    PanelBox[
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquarePlusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJxFzn9Q02UABvCN/XKKaxM2YWwTHPJ10zOFmtTQvURGZgR5dE5xxq3DvEBo
BIRJBAjjSMad2JR2lEIeVHA3Ey+XZ3tfRyhJwmIrLoqDTScnA4ELhrxfdNk/
3/3x3HOfv54nTl+0Py+MRqOlPMv/HW01+oPB9WhbXGN/we616Ie7tRajS4Q2
0y3TsdJwFDXEEN42CZH14Tev1vtWozZ97a2vdJFoIYG+7fEvXPRXhnEiPykC
hQvyUn3dq5Anhnvr31kBemXfeJqwmoO4FSavwMFHs5ayUW4hGzEqN5ldizyU
JWfdtbzBQtk9iarij8LR34TQG/EiE02Gp+3ZJVmNjhGS5BU1A0Vvfcd/spmD
bvKqco+pw1Bj0QfBB0ks5Ot1bEA5dJSrr7kPPGHopOGtbnszDbnErbm8wzS0
d8DMZbcHIW/WYOYzV+DVJRXRWvAUXk2ynvdPBSAnMdMVc+gJlIzMqy89nIeJ
1wJ8RcMKXGssLc//dAraL/RkNARIeKSE98dh3QRkqMSNe2tI6Boc6gh2DkD5
o/rj4AUS9vWQW0tbr2uGuTeIqiUM019zenodoxrmzRMzzt8w/HV3fO0pxwON
kXYo/Ucrhstt3Tp/2Zwmsv16eVsLhmv+AdIU1aImLPNsqqwBw5xrQy9bx5Y1
zxcHamorMSzk5CjVU081pbjL4fwYw884c7KdTjpI+KRw8GwZht/2XRaM6ZhA
dPv9bG0Fhh+6C5O+GGeDLnmLzHYawyW7YlKm4oKL/HebHl3CcPyel6GCa4By
YbP4xrN/dfdbrsRKeaBk7usZA8bQJ054vWknHzTNa3UNBAl/mqjMHz4hACyL
Ilq8j4QFkX8eqOpYB5hvdtiCWSTMzOsuL5mOACPO5SH2FhKui6/WD0uEwJvs
+pl0Yxh/2n0vOV0EFo7YH1/IwPDoc51f+j5fD2RjrIuJNcuwnl4etWKLAmnf
0wzCHAxH+f0DWpoY7LfJ6vxvY1jRf05kT42h/GTmPaXpuISydfvl4vYrUsqp
HnwqziujLJDqz7lZsZSjtew6dWfIgjsK7ciuOMptdxr3iDwhH9xgrTxYvZEy
vSur9XeRPLTXt8M9bQvZIGqeS8mKp/xSYAexfSFkhfLMd4R5E+VV5iJ+9pYE
ylVNpjPywZAn7col4ihB2XSgdzEYDPk/F+PlOQ==
                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, -3.9000000000000004`}, DisplayFunction :> 
                    Identity, Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {"DefaultBoundaryStyle" -> Automatic, 
                    "DefaultMeshStyle" -> AbsolutePointSize[6], 
                    "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 
                    12.}, {-3.6554809253467715`, -1.5942865610975967`}}, 
                    PlotRangeClipping -> True, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquareMinusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJxFzn9Q02UABvCN/XKKaxM2YWwTHPJ10zOFmtTQvURGZgR5dE5xxq3DvEBo
BIRJBAjjSMad2JR2lEIeVHA3Ey+XZ3tfRyhJwmIrLoqDTScnA4ELhrxfdNk/
3/3x3HOfv54nTl+0Py+MRqOlPMv/HW01+oPB9WhbXGN/we616Ie7tRajS4Q2
0y3TsdJwFDXEEN42CZH14Tev1vtWozZ97a2vdJFoIYG+7fEvXPRXhnEiPykC
hQvyUn3dq5Anhnvr31kBemXfeJqwmoO4FSavwMFHs5ayUW4hGzEqN5ldizyU
JWfdtbzBQtk9iarij8LR34TQG/EiE02Gp+3ZJVmNjhGS5BU1A0Vvfcd/spmD
bvKqco+pw1Bj0QfBB0ks5Ot1bEA5dJSrr7kPPGHopOGtbnszDbnErbm8wzS0
d8DMZbcHIW/WYOYzV+DVJRXRWvAUXk2ynvdPBSAnMdMVc+gJlIzMqy89nIeJ
1wJ8RcMKXGssLc//dAraL/RkNARIeKSE98dh3QRkqMSNe2tI6Boc6gh2DkD5
o/rj4AUS9vWQW0tbr2uGuTeIqiUM019zenodoxrmzRMzzt8w/HV3fO0pxwON
kXYo/Ucrhstt3Tp/2Zwmsv16eVsLhmv+AdIU1aImLPNsqqwBw5xrQy9bx5Y1
zxcHamorMSzk5CjVU081pbjL4fwYw884c7KdTjpI+KRw8GwZht/2XRaM6ZhA
dPv9bG0Fhh+6C5O+GGeDLnmLzHYawyW7YlKm4oKL/HebHl3CcPyel6GCa4By
YbP4xrN/dfdbrsRKeaBk7usZA8bQJ054vWknHzTNa3UNBAl/mqjMHz4hACyL
Ilq8j4QFkX8eqOpYB5hvdtiCWSTMzOsuL5mOACPO5SH2FhKui6/WD0uEwJvs
+pl0Yxh/2n0vOV0EFo7YH1/IwPDoc51f+j5fD2RjrIuJNcuwnl4etWKLAmnf
0wzCHAxH+f0DWpoY7LfJ6vxvY1jRf05kT42h/GTmPaXpuISydfvl4vYrUsqp
HnwqziujLJDqz7lZsZSjtew6dWfIgjsK7ciuOMptdxr3iDwhH9xgrTxYvZEy
vSur9XeRPLTXt8M9bQvZIGqeS8mKp/xSYAexfSFkhfLMd4R5E+VV5iJ+9pYE
ylVNpjPywZAn7col4ihB2XSgdzEYDPk/F+PlOQ==
                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, -3.9000000000000004`}, DisplayFunction :> 
                    Identity, Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {"DefaultBoundaryStyle" -> Automatic, 
                    "DefaultMeshStyle" -> AbsolutePointSize[6], 
                    "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 
                    12.}, {-3.6554809253467715`, -1.5942865610975967`}}, 
                    PlotRangeClipping -> True, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["3", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["False", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic], 
                    BaselinePosition -> Baseline], DynamicModuleValues :> {}], 
                    StyleBox["]", "NonInterpretableSummary"]}]},
                   "CopyTag",
                   DisplayFunction->(#& ),
                   
                   InterpretationFunction->(
                    "InterpolatingFunction[{{-6., 12.}}, <>]"& )],
                  False,
                  Editable->False,
                  SelectWithContents->True,
                  Selectable->False], "[", "x", "]"}]}]}], ")"}], "2"]}]]}], 
         SqrtBox["\[Pi]"]]}], "+", 
       FractionBox[
        RowBox[{"2", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", 
            FractionBox["1", "4"]}], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"th", "-", "x", "+", 
              RowBox[{"2", " ", 
               RowBox[{
                TagBox[
                 TemplateBox[{
                   RowBox[{
                    StyleBox[
                    TagBox["InterpolatingFunction", "SummaryHead"], 
                    "NonInterpretableSummary"], 
                    StyleBox["[", "NonInterpretableSummary"], 
                    DynamicModuleBox[{Typeset`open$$ = False}, 
                    PanelBox[
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquarePlusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJxFzn9Q02UABvCN/XKKaxM2YWwTHPJ10zOFmtTQvURGZgR5dE5xxq3DvEBo
BIRJBAjjSMad2JR2lEIeVHA3Ey+XZ3tfRyhJwmIrLoqDTScnA4ELhrxfdNk/
3/3x3HOfv54nTl+0Py+MRqOlPMv/HW01+oPB9WhbXGN/we616Ie7tRajS4Q2
0y3TsdJwFDXEEN42CZH14Tev1vtWozZ97a2vdJFoIYG+7fEvXPRXhnEiPykC
hQvyUn3dq5Anhnvr31kBemXfeJqwmoO4FSavwMFHs5ayUW4hGzEqN5ldizyU
JWfdtbzBQtk9iarij8LR34TQG/EiE02Gp+3ZJVmNjhGS5BU1A0Vvfcd/spmD
bvKqco+pw1Bj0QfBB0ks5Ot1bEA5dJSrr7kPPGHopOGtbnszDbnErbm8wzS0
d8DMZbcHIW/WYOYzV+DVJRXRWvAUXk2ynvdPBSAnMdMVc+gJlIzMqy89nIeJ
1wJ8RcMKXGssLc//dAraL/RkNARIeKSE98dh3QRkqMSNe2tI6Boc6gh2DkD5
o/rj4AUS9vWQW0tbr2uGuTeIqiUM019zenodoxrmzRMzzt8w/HV3fO0pxwON
kXYo/Ucrhstt3Tp/2Zwmsv16eVsLhmv+AdIU1aImLPNsqqwBw5xrQy9bx5Y1
zxcHamorMSzk5CjVU081pbjL4fwYw884c7KdTjpI+KRw8GwZht/2XRaM6ZhA
dPv9bG0Fhh+6C5O+GGeDLnmLzHYawyW7YlKm4oKL/HebHl3CcPyel6GCa4By
YbP4xrN/dfdbrsRKeaBk7usZA8bQJ054vWknHzTNa3UNBAl/mqjMHz4hACyL
Ilq8j4QFkX8eqOpYB5hvdtiCWSTMzOsuL5mOACPO5SH2FhKui6/WD0uEwJvs
+pl0Yxh/2n0vOV0EFo7YH1/IwPDoc51f+j5fD2RjrIuJNcuwnl4etWKLAmnf
0wzCHAxH+f0DWpoY7LfJ6vxvY1jRf05kT42h/GTmPaXpuISydfvl4vYrUsqp
HnwqziujLJDqz7lZsZSjtew6dWfIgjsK7ciuOMptdxr3iDwhH9xgrTxYvZEy
vSur9XeRPLTXt8M9bQvZIGqeS8mKp/xSYAexfSFkhfLMd4R5E+VV5iJ+9pYE
ylVNpjPywZAn7col4ihB2XSgdzEYDPk/F+PlOQ==
                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, -3.9000000000000004`}, DisplayFunction :> 
                    Identity, Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {"DefaultBoundaryStyle" -> Automatic, 
                    "DefaultMeshStyle" -> AbsolutePointSize[6], 
                    "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 
                    12.}, {-3.6554809253467715`, -1.5942865610975967`}}, 
                    PlotRangeClipping -> True, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquareMinusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJxFzn9Q02UABvCN/XKKaxM2YWwTHPJ10zOFmtTQvURGZgR5dE5xxq3DvEBo
BIRJBAjjSMad2JR2lEIeVHA3Ey+XZ3tfRyhJwmIrLoqDTScnA4ELhrxfdNk/
3/3x3HOfv54nTl+0Py+MRqOlPMv/HW01+oPB9WhbXGN/we616Ie7tRajS4Q2
0y3TsdJwFDXEEN42CZH14Tev1vtWozZ97a2vdJFoIYG+7fEvXPRXhnEiPykC
hQvyUn3dq5Anhnvr31kBemXfeJqwmoO4FSavwMFHs5ayUW4hGzEqN5ldizyU
JWfdtbzBQtk9iarij8LR34TQG/EiE02Gp+3ZJVmNjhGS5BU1A0Vvfcd/spmD
bvKqco+pw1Bj0QfBB0ks5Ot1bEA5dJSrr7kPPGHopOGtbnszDbnErbm8wzS0
d8DMZbcHIW/WYOYzV+DVJRXRWvAUXk2ynvdPBSAnMdMVc+gJlIzMqy89nIeJ
1wJ8RcMKXGssLc//dAraL/RkNARIeKSE98dh3QRkqMSNe2tI6Boc6gh2DkD5
o/rj4AUS9vWQW0tbr2uGuTeIqiUM019zenodoxrmzRMzzt8w/HV3fO0pxwON
kXYo/Ucrhstt3Tp/2Zwmsv16eVsLhmv+AdIU1aImLPNsqqwBw5xrQy9bx5Y1
zxcHamorMSzk5CjVU081pbjL4fwYw884c7KdTjpI+KRw8GwZht/2XRaM6ZhA
dPv9bG0Fhh+6C5O+GGeDLnmLzHYawyW7YlKm4oKL/HebHl3CcPyel6GCa4By
YbP4xrN/dfdbrsRKeaBk7usZA8bQJ054vWknHzTNa3UNBAl/mqjMHz4hACyL
Ilq8j4QFkX8eqOpYB5hvdtiCWSTMzOsuL5mOACPO5SH2FhKui6/WD0uEwJvs
+pl0Yxh/2n0vOV0EFo7YH1/IwPDoc51f+j5fD2RjrIuJNcuwnl4etWKLAmnf
0wzCHAxH+f0DWpoY7LfJ6vxvY1jRf05kT42h/GTmPaXpuISydfvl4vYrUsqp
HnwqziujLJDqz7lZsZSjtew6dWfIgjsK7ciuOMptdxr3iDwhH9xgrTxYvZEy
vSur9XeRPLTXt8M9bQvZIGqeS8mKp/xSYAexfSFkhfLMd4R5E+VV5iJ+9pYE
ylVNpjPywZAn7col4ihB2XSgdzEYDPk/F+PlOQ==
                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, -3.9000000000000004`}, DisplayFunction :> 
                    Identity, Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {"DefaultBoundaryStyle" -> Automatic, 
                    "DefaultMeshStyle" -> AbsolutePointSize[6], 
                    "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 
                    12.}, {-3.6554809253467715`, -1.5942865610975967`}}, 
                    PlotRangeClipping -> True, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["3", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["False", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic], 
                    BaselinePosition -> Baseline], DynamicModuleValues :> {}], 
                    StyleBox["]", "NonInterpretableSummary"]}]},
                  "CopyTag",
                  DisplayFunction->(#& ),
                  
                  InterpretationFunction->(
                   "InterpolatingFunction[{{-6., 12.}}, <>]"& )],
                 False,
                 Editable->False,
                 SelectWithContents->True,
                 Selectable->False], "[", "x", "]"}]}]}], ")"}], "2"]}]]}], 
        SqrtBox["\[Pi]"]], "+", 
       RowBox[{
        RowBox[{"Erfc", "[", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"th", "+", "x", "-", 
            RowBox[{"2", " ", 
             RowBox[{
              TagBox[
               TemplateBox[{
                 RowBox[{
                   StyleBox[
                    TagBox["InterpolatingFunction", "SummaryHead"], 
                    "NonInterpretableSummary"], 
                   StyleBox["[", "NonInterpretableSummary"], 
                   DynamicModuleBox[{Typeset`open$$ = False}, 
                    PanelBox[
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquarePlusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJxFzn9Q02UABvCN/XKKaxM2YWwTHPJ10zOFmtTQvURGZgR5dE5xxq3DvEBo
BIRJBAjjSMad2JR2lEIeVHA3Ey+XZ3tfRyhJwmIrLoqDTScnA4ELhrxfdNk/
3/3x3HOfv54nTl+0Py+MRqOlPMv/HW01+oPB9WhbXGN/we616Ie7tRajS4Q2
0y3TsdJwFDXEEN42CZH14Tev1vtWozZ97a2vdJFoIYG+7fEvXPRXhnEiPykC
hQvyUn3dq5Anhnvr31kBemXfeJqwmoO4FSavwMFHs5ayUW4hGzEqN5ldizyU
JWfdtbzBQtk9iarij8LR34TQG/EiE02Gp+3ZJVmNjhGS5BU1A0Vvfcd/spmD
bvKqco+pw1Bj0QfBB0ks5Ot1bEA5dJSrr7kPPGHopOGtbnszDbnErbm8wzS0
d8DMZbcHIW/WYOYzV+DVJRXRWvAUXk2ynvdPBSAnMdMVc+gJlIzMqy89nIeJ
1wJ8RcMKXGssLc//dAraL/RkNARIeKSE98dh3QRkqMSNe2tI6Boc6gh2DkD5
o/rj4AUS9vWQW0tbr2uGuTeIqiUM019zenodoxrmzRMzzt8w/HV3fO0pxwON
kXYo/Ucrhstt3Tp/2Zwmsv16eVsLhmv+AdIU1aImLPNsqqwBw5xrQy9bx5Y1
zxcHamorMSzk5CjVU081pbjL4fwYw884c7KdTjpI+KRw8GwZht/2XRaM6ZhA
dPv9bG0Fhh+6C5O+GGeDLnmLzHYawyW7YlKm4oKL/HebHl3CcPyel6GCa4By
YbP4xrN/dfdbrsRKeaBk7usZA8bQJ054vWknHzTNa3UNBAl/mqjMHz4hACyL
Ilq8j4QFkX8eqOpYB5hvdtiCWSTMzOsuL5mOACPO5SH2FhKui6/WD0uEwJvs
+pl0Yxh/2n0vOV0EFo7YH1/IwPDoc51f+j5fD2RjrIuJNcuwnl4etWKLAmnf
0wzCHAxH+f0DWpoY7LfJ6vxvY1jRf05kT42h/GTmPaXpuISydfvl4vYrUsqp
HnwqziujLJDqz7lZsZSjtew6dWfIgjsK7ciuOMptdxr3iDwhH9xgrTxYvZEy
vSur9XeRPLTXt8M9bQvZIGqeS8mKp/xSYAexfSFkhfLMd4R5E+VV5iJ+9pYE
ylVNpjPywZAn7col4ihB2XSgdzEYDPk/F+PlOQ==
                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, -3.9000000000000004`}, DisplayFunction :> 
                    Identity, Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 
                    12.}, {-3.6554809253467715`, -1.5942865610975967`}}, 
                    PlotRangeClipping -> True, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquareMinusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJxFzn9Q02UABvCN/XKKaxM2YWwTHPJ10zOFmtTQvURGZgR5dE5xxq3DvEBo
BIRJBAjjSMad2JR2lEIeVHA3Ey+XZ3tfRyhJwmIrLoqDTScnA4ELhrxfdNk/
3/3x3HOfv54nTl+0Py+MRqOlPMv/HW01+oPB9WhbXGN/we616Ie7tRajS4Q2
0y3TsdJwFDXEEN42CZH14Tev1vtWozZ97a2vdJFoIYG+7fEvXPRXhnEiPykC
hQvyUn3dq5Anhnvr31kBemXfeJqwmoO4FSavwMFHs5ayUW4hGzEqN5ldizyU
JWfdtbzBQtk9iarij8LR34TQG/EiE02Gp+3ZJVmNjhGS5BU1A0Vvfcd/spmD
bvKqco+pw1Bj0QfBB0ks5Ot1bEA5dJSrr7kPPGHopOGtbnszDbnErbm8wzS0
d8DMZbcHIW/WYOYzV+DVJRXRWvAUXk2ynvdPBSAnMdMVc+gJlIzMqy89nIeJ
1wJ8RcMKXGssLc//dAraL/RkNARIeKSE98dh3QRkqMSNe2tI6Boc6gh2DkD5
o/rj4AUS9vWQW0tbr2uGuTeIqiUM019zenodoxrmzRMzzt8w/HV3fO0pxwON
kXYo/Ucrhstt3Tp/2Zwmsv16eVsLhmv+AdIU1aImLPNsqqwBw5xrQy9bx5Y1
zxcHamorMSzk5CjVU081pbjL4fwYw884c7KdTjpI+KRw8GwZht/2XRaM6ZhA
dPv9bG0Fhh+6C5O+GGeDLnmLzHYawyW7YlKm4oKL/HebHl3CcPyel6GCa4By
YbP4xrN/dfdbrsRKeaBk7usZA8bQJ054vWknHzTNa3UNBAl/mqjMHz4hACyL
Ilq8j4QFkX8eqOpYB5hvdtiCWSTMzOsuL5mOACPO5SH2FhKui6/WD0uEwJvs
+pl0Yxh/2n0vOV0EFo7YH1/IwPDoc51f+j5fD2RjrIuJNcuwnl4etWKLAmnf
0wzCHAxH+f0DWpoY7LfJ6vxvY1jRf05kT42h/GTmPaXpuISydfvl4vYrUsqp
HnwqziujLJDqz7lZsZSjtew6dWfIgjsK7ciuOMptdxr3iDwhH9xgrTxYvZEy
vSur9XeRPLTXt8M9bQvZIGqeS8mKp/xSYAexfSFkhfLMd4R5E+VV5iJ+9pYE
ylVNpjPywZAn7col4ihB2XSgdzEYDPk/F+PlOQ==
                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, -3.9000000000000004`}, DisplayFunction :> 
                    Identity, Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 
                    12.}, {-3.6554809253467715`, -1.5942865610975967`}}, 
                    PlotRangeClipping -> True, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["3", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["False", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic], 
                    BaselinePosition -> Baseline], DynamicModuleValues :> {}], 
                   StyleBox["]", "NonInterpretableSummary"]}]},
                "CopyTag",
                DisplayFunction->(#& ),
                
                InterpretationFunction->(
                 "InterpolatingFunction[{{-6., 12.}}, <>]"& )],
               False,
               Editable->False,
               SelectWithContents->True,
               Selectable->False], "[", "x", "]"}]}]}], ")"}]}], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{"th", "+", "x", "-", 
          RowBox[{"2", " ", 
           RowBox[{
            TagBox[
             TemplateBox[{
               RowBox[{
                 StyleBox[
                  TagBox["InterpolatingFunction", "SummaryHead"], 
                  "NonInterpretableSummary"], 
                 StyleBox["[", "NonInterpretableSummary"], 
                 DynamicModuleBox[{Typeset`open$$ = False}, 
                  PanelBox[
                   PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquarePlusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJxFzn9Q02UABvCN/XKKaxM2YWwTHPJ10zOFmtTQvURGZgR5dE5xxq3DvEBo
BIRJBAjjSMad2JR2lEIeVHA3Ey+XZ3tfRyhJwmIrLoqDTScnA4ELhrxfdNk/
3/3x3HOfv54nTl+0Py+MRqOlPMv/HW01+oPB9WhbXGN/we616Ie7tRajS4Q2
0y3TsdJwFDXEEN42CZH14Tev1vtWozZ97a2vdJFoIYG+7fEvXPRXhnEiPykC
hQvyUn3dq5Anhnvr31kBemXfeJqwmoO4FSavwMFHs5ayUW4hGzEqN5ldizyU
JWfdtbzBQtk9iarij8LR34TQG/EiE02Gp+3ZJVmNjhGS5BU1A0Vvfcd/spmD
bvKqco+pw1Bj0QfBB0ks5Ot1bEA5dJSrr7kPPGHopOGtbnszDbnErbm8wzS0
d8DMZbcHIW/WYOYzV+DVJRXRWvAUXk2ynvdPBSAnMdMVc+gJlIzMqy89nIeJ
1wJ8RcMKXGssLc//dAraL/RkNARIeKSE98dh3QRkqMSNe2tI6Boc6gh2DkD5
o/rj4AUS9vWQW0tbr2uGuTeIqiUM019zenodoxrmzRMzzt8w/HV3fO0pxwON
kXYo/Ucrhstt3Tp/2Zwmsv16eVsLhmv+AdIU1aImLPNsqqwBw5xrQy9bx5Y1
zxcHamorMSzk5CjVU081pbjL4fwYw884c7KdTjpI+KRw8GwZht/2XRaM6ZhA
dPv9bG0Fhh+6C5O+GGeDLnmLzHYawyW7YlKm4oKL/HebHl3CcPyel6GCa4By
YbP4xrN/dfdbrsRKeaBk7usZA8bQJ054vWknHzTNa3UNBAl/mqjMHz4hACyL
Ilq8j4QFkX8eqOpYB5hvdtiCWSTMzOsuL5mOACPO5SH2FhKui6/WD0uEwJvs
+pl0Yxh/2n0vOV0EFo7YH1/IwPDoc51f+j5fD2RjrIuJNcuwnl4etWKLAmnf
0wzCHAxH+f0DWpoY7LfJ6vxvY1jRf05kT42h/GTmPaXpuISydfvl4vYrUsqp
HnwqziujLJDqz7lZsZSjtew6dWfIgjsK7ciuOMptdxr3iDwhH9xgrTxYvZEy
vSur9XeRPLTXt8M9bQvZIGqeS8mKp/xSYAexfSFkhfLMd4R5E+VV5iJ+9pYE
ylVNpjPywZAn7col4ihB2XSgdzEYDPk/F+PlOQ==
                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, -3.9000000000000004`}, DisplayFunction :> 
                    Identity, Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 
                    12.}, {-3.6554809253467715`, -1.5942865610975967`}}, 
                    PlotRangeClipping -> True, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquareMinusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJxFzn9Q02UABvCN/XKKaxM2YWwTHPJ10zOFmtTQvURGZgR5dE5xxq3DvEBo
BIRJBAjjSMad2JR2lEIeVHA3Ey+XZ3tfRyhJwmIrLoqDTScnA4ELhrxfdNk/
3/3x3HOfv54nTl+0Py+MRqOlPMv/HW01+oPB9WhbXGN/we616Ie7tRajS4Q2
0y3TsdJwFDXEEN42CZH14Tev1vtWozZ97a2vdJFoIYG+7fEvXPRXhnEiPykC
hQvyUn3dq5Anhnvr31kBemXfeJqwmoO4FSavwMFHs5ayUW4hGzEqN5ldizyU
JWfdtbzBQtk9iarij8LR34TQG/EiE02Gp+3ZJVmNjhGS5BU1A0Vvfcd/spmD
bvKqco+pw1Bj0QfBB0ks5Ot1bEA5dJSrr7kPPGHopOGtbnszDbnErbm8wzS0
d8DMZbcHIW/WYOYzV+DVJRXRWvAUXk2ynvdPBSAnMdMVc+gJlIzMqy89nIeJ
1wJ8RcMKXGssLc//dAraL/RkNARIeKSE98dh3QRkqMSNe2tI6Boc6gh2DkD5
o/rj4AUS9vWQW0tbr2uGuTeIqiUM019zenodoxrmzRMzzt8w/HV3fO0pxwON
kXYo/Ucrhstt3Tp/2Zwmsv16eVsLhmv+AdIU1aImLPNsqqwBw5xrQy9bx5Y1
zxcHamorMSzk5CjVU081pbjL4fwYw884c7KdTjpI+KRw8GwZht/2XRaM6ZhA
dPv9bG0Fhh+6C5O+GGeDLnmLzHYawyW7YlKm4oKL/HebHl3CcPyel6GCa4By
YbP4xrN/dfdbrsRKeaBk7usZA8bQJ054vWknHzTNa3UNBAl/mqjMHz4hACyL
Ilq8j4QFkX8eqOpYB5hvdtiCWSTMzOsuL5mOACPO5SH2FhKui6/WD0uEwJvs
+pl0Yxh/2n0vOV0EFo7YH1/IwPDoc51f+j5fD2RjrIuJNcuwnl4etWKLAmnf
0wzCHAxH+f0DWpoY7LfJ6vxvY1jRf05kT42h/GTmPaXpuISydfvl4vYrUsqp
HnwqziujLJDqz7lZsZSjtew6dWfIgjsK7ciuOMptdxr3iDwhH9xgrTxYvZEy
vSur9XeRPLTXt8M9bQvZIGqeS8mKp/xSYAexfSFkhfLMd4R5E+VV5iJ+9pYE
ylVNpjPywZAn7col4ihB2XSgdzEYDPk/F+PlOQ==
                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, -3.9000000000000004`}, DisplayFunction :> 
                    Identity, Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 
                    12.}, {-3.6554809253467715`, -1.5942865610975967`}}, 
                    PlotRangeClipping -> True, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["3", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["False", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic], 
                   BaselinePosition -> Baseline], DynamicModuleValues :> {}], 
                 StyleBox["]", "NonInterpretableSummary"]}]},
              "CopyTag",
              DisplayFunction->(#& ),
              
              InterpretationFunction->(
               "InterpolatingFunction[{{-6., 12.}}, <>]"& )],
             False,
             Editable->False,
             SelectWithContents->True,
             Selectable->False], "[", "x", "]"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"Erfc", "[", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "th"}], "+", "x", "-", 
            RowBox[{"2", " ", 
             RowBox[{
              TagBox[
               TemplateBox[{
                 RowBox[{
                   StyleBox[
                    TagBox["InterpolatingFunction", "SummaryHead"], 
                    "NonInterpretableSummary"], 
                   StyleBox["[", "NonInterpretableSummary"], 
                   DynamicModuleBox[{Typeset`open$$ = False}, 
                    PanelBox[
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquarePlusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJxFzn9Q02UABvCN/XKKaxM2YWwTHPJ10zOFmtTQvURGZgR5dE5xxq3DvEBo
BIRJBAjjSMad2JR2lEIeVHA3Ey+XZ3tfRyhJwmIrLoqDTScnA4ELhrxfdNk/
3/3x3HOfv54nTl+0Py+MRqOlPMv/HW01+oPB9WhbXGN/we616Ie7tRajS4Q2
0y3TsdJwFDXEEN42CZH14Tev1vtWozZ97a2vdJFoIYG+7fEvXPRXhnEiPykC
hQvyUn3dq5Anhnvr31kBemXfeJqwmoO4FSavwMFHs5ayUW4hGzEqN5ldizyU
JWfdtbzBQtk9iarij8LR34TQG/EiE02Gp+3ZJVmNjhGS5BU1A0Vvfcd/spmD
bvKqco+pw1Bj0QfBB0ks5Ot1bEA5dJSrr7kPPGHopOGtbnszDbnErbm8wzS0
d8DMZbcHIW/WYOYzV+DVJRXRWvAUXk2ynvdPBSAnMdMVc+gJlIzMqy89nIeJ
1wJ8RcMKXGssLc//dAraL/RkNARIeKSE98dh3QRkqMSNe2tI6Boc6gh2DkD5
o/rj4AUS9vWQW0tbr2uGuTeIqiUM019zenodoxrmzRMzzt8w/HV3fO0pxwON
kXYo/Ucrhstt3Tp/2Zwmsv16eVsLhmv+AdIU1aImLPNsqqwBw5xrQy9bx5Y1
zxcHamorMSzk5CjVU081pbjL4fwYw884c7KdTjpI+KRw8GwZht/2XRaM6ZhA
dPv9bG0Fhh+6C5O+GGeDLnmLzHYawyW7YlKm4oKL/HebHl3CcPyel6GCa4By
YbP4xrN/dfdbrsRKeaBk7usZA8bQJ054vWknHzTNa3UNBAl/mqjMHz4hACyL
Ilq8j4QFkX8eqOpYB5hvdtiCWSTMzOsuL5mOACPO5SH2FhKui6/WD0uEwJvs
+pl0Yxh/2n0vOV0EFo7YH1/IwPDoc51f+j5fD2RjrIuJNcuwnl4etWKLAmnf
0wzCHAxH+f0DWpoY7LfJ6vxvY1jRf05kT42h/GTmPaXpuISydfvl4vYrUsqp
HnwqziujLJDqz7lZsZSjtew6dWfIgjsK7ciuOMptdxr3iDwhH9xgrTxYvZEy
vSur9XeRPLTXt8M9bQvZIGqeS8mKp/xSYAexfSFkhfLMd4R5E+VV5iJ+9pYE
ylVNpjPywZAn7col4ihB2XSgdzEYDPk/F+PlOQ==
                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, -3.9000000000000004`}, DisplayFunction :> 
                    Identity, Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 
                    12.}, {-3.6554809253467715`, -1.5942865610975967`}}, 
                    PlotRangeClipping -> True, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquareMinusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJxFzn9Q02UABvCN/XKKaxM2YWwTHPJ10zOFmtTQvURGZgR5dE5xxq3DvEBo
BIRJBAjjSMad2JR2lEIeVHA3Ey+XZ3tfRyhJwmIrLoqDTScnA4ELhrxfdNk/
3/3x3HOfv54nTl+0Py+MRqOlPMv/HW01+oPB9WhbXGN/we616Ie7tRajS4Q2
0y3TsdJwFDXEEN42CZH14Tev1vtWozZ97a2vdJFoIYG+7fEvXPRXhnEiPykC
hQvyUn3dq5Anhnvr31kBemXfeJqwmoO4FSavwMFHs5ayUW4hGzEqN5ldizyU
JWfdtbzBQtk9iarij8LR34TQG/EiE02Gp+3ZJVmNjhGS5BU1A0Vvfcd/spmD
bvKqco+pw1Bj0QfBB0ks5Ot1bEA5dJSrr7kPPGHopOGtbnszDbnErbm8wzS0
d8DMZbcHIW/WYOYzV+DVJRXRWvAUXk2ynvdPBSAnMdMVc+gJlIzMqy89nIeJ
1wJ8RcMKXGssLc//dAraL/RkNARIeKSE98dh3QRkqMSNe2tI6Boc6gh2DkD5
o/rj4AUS9vWQW0tbr2uGuTeIqiUM019zenodoxrmzRMzzt8w/HV3fO0pxwON
kXYo/Ucrhstt3Tp/2Zwmsv16eVsLhmv+AdIU1aImLPNsqqwBw5xrQy9bx5Y1
zxcHamorMSzk5CjVU081pbjL4fwYw884c7KdTjpI+KRw8GwZht/2XRaM6ZhA
dPv9bG0Fhh+6C5O+GGeDLnmLzHYawyW7YlKm4oKL/HebHl3CcPyel6GCa4By
YbP4xrN/dfdbrsRKeaBk7usZA8bQJ054vWknHzTNa3UNBAl/mqjMHz4hACyL
Ilq8j4QFkX8eqOpYB5hvdtiCWSTMzOsuL5mOACPO5SH2FhKui6/WD0uEwJvs
+pl0Yxh/2n0vOV0EFo7YH1/IwPDoc51f+j5fD2RjrIuJNcuwnl4etWKLAmnf
0wzCHAxH+f0DWpoY7LfJ6vxvY1jRf05kT42h/GTmPaXpuISydfvl4vYrUsqp
HnwqziujLJDqz7lZsZSjtew6dWfIgjsK7ciuOMptdxr3iDwhH9xgrTxYvZEy
vSur9XeRPLTXt8M9bQvZIGqeS8mKp/xSYAexfSFkhfLMd4R5E+VV5iJ+9pYE
ylVNpjPywZAn7col4ihB2XSgdzEYDPk/F+PlOQ==
                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, -3.9000000000000004`}, DisplayFunction :> 
                    Identity, Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 
                    12.}, {-3.6554809253467715`, -1.5942865610975967`}}, 
                    PlotRangeClipping -> True, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["3", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["False", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic], 
                    BaselinePosition -> Baseline], DynamicModuleValues :> {}], 
                   StyleBox["]", "NonInterpretableSummary"]}]},
                "CopyTag",
                DisplayFunction->(#& ),
                InterpretationFunction->(
                 "InterpolatingFunction[{{-6., 12.}}, <>]"& )],
               False,
               Editable->False,
               SelectWithContents->True,
               Selectable->False], "[", "x", "]"}]}]}], ")"}]}], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{"th", "-", "x", "+", 
          RowBox[{"2", " ", 
           RowBox[{
            TagBox[
             TemplateBox[{
               RowBox[{
                 StyleBox[
                  TagBox["InterpolatingFunction", "SummaryHead"], 
                  "NonInterpretableSummary"], 
                 StyleBox["[", "NonInterpretableSummary"], 
                 DynamicModuleBox[{Typeset`open$$ = False}, 
                  PanelBox[
                   PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquarePlusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJxFzn9Q02UABvCN/XKKaxM2YWwTHPJ10zOFmtTQvURGZgR5dE5xxq3DvEBo
BIRJBAjjSMad2JR2lEIeVHA3Ey+XZ3tfRyhJwmIrLoqDTScnA4ELhrxfdNk/
3/3x3HOfv54nTl+0Py+MRqOlPMv/HW01+oPB9WhbXGN/we616Ie7tRajS4Q2
0y3TsdJwFDXEEN42CZH14Tev1vtWozZ97a2vdJFoIYG+7fEvXPRXhnEiPykC
hQvyUn3dq5Anhnvr31kBemXfeJqwmoO4FSavwMFHs5ayUW4hGzEqN5ldizyU
JWfdtbzBQtk9iarij8LR34TQG/EiE02Gp+3ZJVmNjhGS5BU1A0Vvfcd/spmD
bvKqco+pw1Bj0QfBB0ks5Ot1bEA5dJSrr7kPPGHopOGtbnszDbnErbm8wzS0
d8DMZbcHIW/WYOYzV+DVJRXRWvAUXk2ynvdPBSAnMdMVc+gJlIzMqy89nIeJ
1wJ8RcMKXGssLc//dAraL/RkNARIeKSE98dh3QRkqMSNe2tI6Boc6gh2DkD5
o/rj4AUS9vWQW0tbr2uGuTeIqiUM019zenodoxrmzRMzzt8w/HV3fO0pxwON
kXYo/Ucrhstt3Tp/2Zwmsv16eVsLhmv+AdIU1aImLPNsqqwBw5xrQy9bx5Y1
zxcHamorMSzk5CjVU081pbjL4fwYw884c7KdTjpI+KRw8GwZht/2XRaM6ZhA
dPv9bG0Fhh+6C5O+GGeDLnmLzHYawyW7YlKm4oKL/HebHl3CcPyel6GCa4By
YbP4xrN/dfdbrsRKeaBk7usZA8bQJ054vWknHzTNa3UNBAl/mqjMHz4hACyL
Ilq8j4QFkX8eqOpYB5hvdtiCWSTMzOsuL5mOACPO5SH2FhKui6/WD0uEwJvs
+pl0Yxh/2n0vOV0EFo7YH1/IwPDoc51f+j5fD2RjrIuJNcuwnl4etWKLAmnf
0wzCHAxH+f0DWpoY7LfJ6vxvY1jRf05kT42h/GTmPaXpuISydfvl4vYrUsqp
HnwqziujLJDqz7lZsZSjtew6dWfIgjsK7ciuOMptdxr3iDwhH9xgrTxYvZEy
vSur9XeRPLTXt8M9bQvZIGqeS8mKp/xSYAexfSFkhfLMd4R5E+VV5iJ+9pYE
ylVNpjPywZAn7col4ihB2XSgdzEYDPk/F+PlOQ==
                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, -3.9000000000000004`}, DisplayFunction :> 
                    Identity, Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 
                    12.}, {-3.6554809253467715`, -1.5942865610975967`}}, 
                    PlotRangeClipping -> True, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquareMinusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJxFzn9Q02UABvCN/XKKaxM2YWwTHPJ10zOFmtTQvURGZgR5dE5xxq3DvEBo
BIRJBAjjSMad2JR2lEIeVHA3Ey+XZ3tfRyhJwmIrLoqDTScnA4ELhrxfdNk/
3/3x3HOfv54nTl+0Py+MRqOlPMv/HW01+oPB9WhbXGN/we616Ie7tRajS4Q2
0y3TsdJwFDXEEN42CZH14Tev1vtWozZ97a2vdJFoIYG+7fEvXPRXhnEiPykC
hQvyUn3dq5Anhnvr31kBemXfeJqwmoO4FSavwMFHs5ayUW4hGzEqN5ldizyU
JWfdtbzBQtk9iarij8LR34TQG/EiE02Gp+3ZJVmNjhGS5BU1A0Vvfcd/spmD
bvKqco+pw1Bj0QfBB0ks5Ot1bEA5dJSrr7kPPGHopOGtbnszDbnErbm8wzS0
d8DMZbcHIW/WYOYzV+DVJRXRWvAUXk2ynvdPBSAnMdMVc+gJlIzMqy89nIeJ
1wJ8RcMKXGssLc//dAraL/RkNARIeKSE98dh3QRkqMSNe2tI6Boc6gh2DkD5
o/rj4AUS9vWQW0tbr2uGuTeIqiUM019zenodoxrmzRMzzt8w/HV3fO0pxwON
kXYo/Ucrhstt3Tp/2Zwmsv16eVsLhmv+AdIU1aImLPNsqqwBw5xrQy9bx5Y1
zxcHamorMSzk5CjVU081pbjL4fwYw884c7KdTjpI+KRw8GwZht/2XRaM6ZhA
dPv9bG0Fhh+6C5O+GGeDLnmLzHYawyW7YlKm4oKL/HebHl3CcPyel6GCa4By
YbP4xrN/dfdbrsRKeaBk7usZA8bQJ054vWknHzTNa3UNBAl/mqjMHz4hACyL
Ilq8j4QFkX8eqOpYB5hvdtiCWSTMzOsuL5mOACPO5SH2FhKui6/WD0uEwJvs
+pl0Yxh/2n0vOV0EFo7YH1/IwPDoc51f+j5fD2RjrIuJNcuwnl4etWKLAmnf
0wzCHAxH+f0DWpoY7LfJ6vxvY1jRf05kT42h/GTmPaXpuISydfvl4vYrUsqp
HnwqziujLJDqz7lZsZSjtew6dWfIgjsK7ciuOMptdxr3iDwhH9xgrTxYvZEy
vSur9XeRPLTXt8M9bQvZIGqeS8mKp/xSYAexfSFkhfLMd4R5E+VV5iJ+9pYE
ylVNpjPywZAn7col4ihB2XSgdzEYDPk/F+PlOQ==
                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, -3.9000000000000004`}, DisplayFunction :> 
                    Identity, Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 
                    12.}, {-3.6554809253467715`, -1.5942865610975967`}}, 
                    PlotRangeClipping -> True, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["3", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["False", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic], 
                   BaselinePosition -> Baseline], DynamicModuleValues :> {}], 
                 StyleBox["]", "NonInterpretableSummary"]}]},
              "CopyTag",
              DisplayFunction->(#& ),
              
              InterpretationFunction->(
               "InterpolatingFunction[{{-6., 12.}}, <>]"& )],
             False,
             Editable->False,
             SelectWithContents->True,
             Selectable->False], "[", "x", "]"}]}]}], ")"}]}]}], ")"}]}], "-", 
    RowBox[{
     FractionBox["1", "th"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", 
             FractionBox["1", "4"]}], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"th", "+", "x", "-", 
               RowBox[{"2", " ", 
                RowBox[{
                 TagBox[
                  TemplateBox[{
                    RowBox[{
                    StyleBox[
                    TagBox["InterpolatingFunction", "SummaryHead"], 
                    "NonInterpretableSummary"], 
                    StyleBox["[", "NonInterpretableSummary"], 
                    DynamicModuleBox[{Typeset`open$$ = False}, 
                    PanelBox[
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquarePlusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAGa+G6///F8AEPYEOk8ECwLHNhJqG
0xbAOppvSOyJAcAYzwMVx40VwIC0Y+UGNgDAoWKExp1dFMCbPA++huz9v9lN
huBrMxPATRVP/+Rz+7/hGwnG8+8RwAHZZZCkvfi/CXyN4hHCEMBFukjVMyz2
vwN+JZXT9Q7AaLVAkHFW879UszI2cnMMwPQWO6i8fPC/5wxDRT0cCsD8lZs0
BIHrvxksVet7kgfAYnVUK05c5b+Mb2r/5jMFwDpdPf02wd6/YGKC5EDhAsA0
h5/BEXTSv9ManGAOXADA5qUmemthsb8O73GVEAT8vzRFKI5cRMM/tDOvl+vq
9r9R+X/uwLzZPxzX8Tuk6fG/LcAJqgk/5T8NhnV4a33qv3C58SKnb+0/XnQO
1Vxd4L/U+5Ihm1PzP9POz6b/p8u/SPSteEC/9z/Fs/ssdZy6Pw/Fi3pHofw/
R0bQ4cPC2j9L6fbywL4AQMk+JISDwuY/9Q+2BHwIA0D5oaxd63bwPweiM2vG
hwVAC9xAHTw29T+HFWovrd8HQFu3zzqv3fk/vhTj3hkuCkBuB1sqO+r+P/GA
g/YFsQxAfwfwHjfQAUCRRCcGgQsPQKjFsBHdXQRAmlTynQTOEEBw1G4zlN8G
QCJzXSG4EhJA974p5x42CUCjoywXS0QTQN/j4gM2vwtA+q57CMqSFECF5Jiy
IB0OQGAutNQszRVA5RomSI43EEBIV3yfcAEXQLngfmvSeRFAO0fJ8ZhMGEBs
FNZXgKYSQGun/0XAehlAT2WseHTsE0CF2aosNrcaQBIkgWLSHBVASvL1URHS
G0Aki9TjOEcWQOIiBOKg2hxAZg+nmeWKF0CuhqhBcusdQIcBeBj8uBhAFyy4
dMFPH0DaEMjLWAAaQHffh9ZpSiBAfMiWFr5BG0BJO+97HOsgQP3tYyqNbRxA
CM7VBQSBIUCvMLByorIdQGLv+6mOIyJAQeH6gyHiHkCrR6EyTrsiQBEdYpbU
BSBAG/QFBxJQI0AZWAaFO6cgQCMvqvV48SNAEcopWNc9IUAboc3IFIgkQKHK
jEUW4SFAq6EwtlMrJUBZH69+WYEiQGP2Uu+WyyVAAatQnNEWI0ALgvQMD2Em
QEHFMdTsuCNAS5zVRCoDJ0BxFpLwPFAkQHvtNWF6midAOfYxJzD0JEBDzdWX
bT4oQCkqkaknlSVAMwE1GmXfKEAIlW8QVCsmQBJsE4GRdSlAgI6NkSPOJkCK
ZTECYRgqQOe+KvcnZidA8ZXOZ2WwKkCNV8P1//8nQJcuZ2Y9SitALwmyqA==

                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                    Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {"DefaultBoundaryStyle" -> Automatic, 
                    "DefaultMeshStyle" -> AbsolutePointSize[6], 
                    "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 12.}, {-2.3445187695684826`, 
                    13.644999694915255`}}, PlotRangeClipping -> True, 
                    PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquareMinusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAGa+G6///F8AEPYEOk8ECwLHNhJqG
0xbAOppvSOyJAcAYzwMVx40VwIC0Y+UGNgDAoWKExp1dFMCbPA++huz9v9lN
huBrMxPATRVP/+Rz+7/hGwnG8+8RwAHZZZCkvfi/CXyN4hHCEMBFukjVMyz2
vwN+JZXT9Q7AaLVAkHFW879UszI2cnMMwPQWO6i8fPC/5wxDRT0cCsD8lZs0
BIHrvxksVet7kgfAYnVUK05c5b+Mb2r/5jMFwDpdPf02wd6/YGKC5EDhAsA0
h5/BEXTSv9ManGAOXADA5qUmemthsb8O73GVEAT8vzRFKI5cRMM/tDOvl+vq
9r9R+X/uwLzZPxzX8Tuk6fG/LcAJqgk/5T8NhnV4a33qv3C58SKnb+0/XnQO
1Vxd4L/U+5Ihm1PzP9POz6b/p8u/SPSteEC/9z/Fs/ssdZy6Pw/Fi3pHofw/
R0bQ4cPC2j9L6fbywL4AQMk+JISDwuY/9Q+2BHwIA0D5oaxd63bwPweiM2vG
hwVAC9xAHTw29T+HFWovrd8HQFu3zzqv3fk/vhTj3hkuCkBuB1sqO+r+P/GA
g/YFsQxAfwfwHjfQAUCRRCcGgQsPQKjFsBHdXQRAmlTynQTOEEBw1G4zlN8G
QCJzXSG4EhJA974p5x42CUCjoywXS0QTQN/j4gM2vwtA+q57CMqSFECF5Jiy
IB0OQGAutNQszRVA5RomSI43EEBIV3yfcAEXQLngfmvSeRFAO0fJ8ZhMGEBs
FNZXgKYSQGun/0XAehlAT2WseHTsE0CF2aosNrcaQBIkgWLSHBVASvL1URHS
G0Aki9TjOEcWQOIiBOKg2hxAZg+nmeWKF0CuhqhBcusdQIcBeBj8uBhAFyy4
dMFPH0DaEMjLWAAaQHffh9ZpSiBAfMiWFr5BG0BJO+97HOsgQP3tYyqNbRxA
CM7VBQSBIUCvMLByorIdQGLv+6mOIyJAQeH6gyHiHkCrR6EyTrsiQBEdYpbU
BSBAG/QFBxJQI0AZWAaFO6cgQCMvqvV48SNAEcopWNc9IUAboc3IFIgkQKHK
jEUW4SFAq6EwtlMrJUBZH69+WYEiQGP2Uu+WyyVAAatQnNEWI0ALgvQMD2Em
QEHFMdTsuCNAS5zVRCoDJ0BxFpLwPFAkQHvtNWF6midAOfYxJzD0JEBDzdWX
bT4oQCkqkaknlSVAMwE1GmXfKEAIlW8QVCsmQBJsE4GRdSlAgI6NkSPOJkCK
ZTECYRgqQOe+KvcnZidA8ZXOZ2WwKkCNV8P1//8nQJcuZ2Y9SitALwmyqA==

                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                    Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {"DefaultBoundaryStyle" -> Automatic, 
                    "DefaultMeshStyle" -> AbsolutePointSize[6], 
                    "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 12.}, {-2.3445187695684826`, 
                    13.644999694915255`}}, PlotRangeClipping -> True, 
                    PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["3", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["False", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic], 
                    BaselinePosition -> Baseline], DynamicModuleValues :> {}], 
                    StyleBox["]", "NonInterpretableSummary"]}]},
                   "CopyTag",
                   DisplayFunction->(#& ),
                   
                   InterpretationFunction->(
                    "InterpolatingFunction[{{-6., 12.}}, <>]"& )],
                  False,
                  Editable->False,
                  SelectWithContents->True,
                  Selectable->False], "[", "x", "]"}]}]}], ")"}], "2"]}]]}], 
         SqrtBox["\[Pi]"]]}], "+", 
       FractionBox[
        RowBox[{"2", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", 
            FractionBox["1", "4"]}], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"th", "-", "x", "+", 
              RowBox[{"2", " ", 
               RowBox[{
                TagBox[
                 TemplateBox[{
                   RowBox[{
                    StyleBox[
                    TagBox["InterpolatingFunction", "SummaryHead"], 
                    "NonInterpretableSummary"], 
                    StyleBox["[", "NonInterpretableSummary"], 
                    DynamicModuleBox[{Typeset`open$$ = False}, 
                    PanelBox[
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquarePlusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAGa+G6///F8AEPYEOk8ECwLHNhJqG
0xbAOppvSOyJAcAYzwMVx40VwIC0Y+UGNgDAoWKExp1dFMCbPA++huz9v9lN
huBrMxPATRVP/+Rz+7/hGwnG8+8RwAHZZZCkvfi/CXyN4hHCEMBFukjVMyz2
vwN+JZXT9Q7AaLVAkHFW879UszI2cnMMwPQWO6i8fPC/5wxDRT0cCsD8lZs0
BIHrvxksVet7kgfAYnVUK05c5b+Mb2r/5jMFwDpdPf02wd6/YGKC5EDhAsA0
h5/BEXTSv9ManGAOXADA5qUmemthsb8O73GVEAT8vzRFKI5cRMM/tDOvl+vq
9r9R+X/uwLzZPxzX8Tuk6fG/LcAJqgk/5T8NhnV4a33qv3C58SKnb+0/XnQO
1Vxd4L/U+5Ihm1PzP9POz6b/p8u/SPSteEC/9z/Fs/ssdZy6Pw/Fi3pHofw/
R0bQ4cPC2j9L6fbywL4AQMk+JISDwuY/9Q+2BHwIA0D5oaxd63bwPweiM2vG
hwVAC9xAHTw29T+HFWovrd8HQFu3zzqv3fk/vhTj3hkuCkBuB1sqO+r+P/GA
g/YFsQxAfwfwHjfQAUCRRCcGgQsPQKjFsBHdXQRAmlTynQTOEEBw1G4zlN8G
QCJzXSG4EhJA974p5x42CUCjoywXS0QTQN/j4gM2vwtA+q57CMqSFECF5Jiy
IB0OQGAutNQszRVA5RomSI43EEBIV3yfcAEXQLngfmvSeRFAO0fJ8ZhMGEBs
FNZXgKYSQGun/0XAehlAT2WseHTsE0CF2aosNrcaQBIkgWLSHBVASvL1URHS
G0Aki9TjOEcWQOIiBOKg2hxAZg+nmeWKF0CuhqhBcusdQIcBeBj8uBhAFyy4
dMFPH0DaEMjLWAAaQHffh9ZpSiBAfMiWFr5BG0BJO+97HOsgQP3tYyqNbRxA
CM7VBQSBIUCvMLByorIdQGLv+6mOIyJAQeH6gyHiHkCrR6EyTrsiQBEdYpbU
BSBAG/QFBxJQI0AZWAaFO6cgQCMvqvV48SNAEcopWNc9IUAboc3IFIgkQKHK
jEUW4SFAq6EwtlMrJUBZH69+WYEiQGP2Uu+WyyVAAatQnNEWI0ALgvQMD2Em
QEHFMdTsuCNAS5zVRCoDJ0BxFpLwPFAkQHvtNWF6midAOfYxJzD0JEBDzdWX
bT4oQCkqkaknlSVAMwE1GmXfKEAIlW8QVCsmQBJsE4GRdSlAgI6NkSPOJkCK
ZTECYRgqQOe+KvcnZidA8ZXOZ2WwKkCNV8P1//8nQJcuZ2Y9SitALwmyqA==

                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                    Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {"DefaultBoundaryStyle" -> Automatic, 
                    "DefaultMeshStyle" -> AbsolutePointSize[6], 
                    "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 12.}, {-2.3445187695684826`, 
                    13.644999694915255`}}, PlotRangeClipping -> True, 
                    PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquareMinusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAGa+G6///F8AEPYEOk8ECwLHNhJqG
0xbAOppvSOyJAcAYzwMVx40VwIC0Y+UGNgDAoWKExp1dFMCbPA++huz9v9lN
huBrMxPATRVP/+Rz+7/hGwnG8+8RwAHZZZCkvfi/CXyN4hHCEMBFukjVMyz2
vwN+JZXT9Q7AaLVAkHFW879UszI2cnMMwPQWO6i8fPC/5wxDRT0cCsD8lZs0
BIHrvxksVet7kgfAYnVUK05c5b+Mb2r/5jMFwDpdPf02wd6/YGKC5EDhAsA0
h5/BEXTSv9ManGAOXADA5qUmemthsb8O73GVEAT8vzRFKI5cRMM/tDOvl+vq
9r9R+X/uwLzZPxzX8Tuk6fG/LcAJqgk/5T8NhnV4a33qv3C58SKnb+0/XnQO
1Vxd4L/U+5Ihm1PzP9POz6b/p8u/SPSteEC/9z/Fs/ssdZy6Pw/Fi3pHofw/
R0bQ4cPC2j9L6fbywL4AQMk+JISDwuY/9Q+2BHwIA0D5oaxd63bwPweiM2vG
hwVAC9xAHTw29T+HFWovrd8HQFu3zzqv3fk/vhTj3hkuCkBuB1sqO+r+P/GA
g/YFsQxAfwfwHjfQAUCRRCcGgQsPQKjFsBHdXQRAmlTynQTOEEBw1G4zlN8G
QCJzXSG4EhJA974p5x42CUCjoywXS0QTQN/j4gM2vwtA+q57CMqSFECF5Jiy
IB0OQGAutNQszRVA5RomSI43EEBIV3yfcAEXQLngfmvSeRFAO0fJ8ZhMGEBs
FNZXgKYSQGun/0XAehlAT2WseHTsE0CF2aosNrcaQBIkgWLSHBVASvL1URHS
G0Aki9TjOEcWQOIiBOKg2hxAZg+nmeWKF0CuhqhBcusdQIcBeBj8uBhAFyy4
dMFPH0DaEMjLWAAaQHffh9ZpSiBAfMiWFr5BG0BJO+97HOsgQP3tYyqNbRxA
CM7VBQSBIUCvMLByorIdQGLv+6mOIyJAQeH6gyHiHkCrR6EyTrsiQBEdYpbU
BSBAG/QFBxJQI0AZWAaFO6cgQCMvqvV48SNAEcopWNc9IUAboc3IFIgkQKHK
jEUW4SFAq6EwtlMrJUBZH69+WYEiQGP2Uu+WyyVAAatQnNEWI0ALgvQMD2Em
QEHFMdTsuCNAS5zVRCoDJ0BxFpLwPFAkQHvtNWF6midAOfYxJzD0JEBDzdWX
bT4oQCkqkaknlSVAMwE1GmXfKEAIlW8QVCsmQBJsE4GRdSlAgI6NkSPOJkCK
ZTECYRgqQOe+KvcnZidA8ZXOZ2WwKkCNV8P1//8nQJcuZ2Y9SitALwmyqA==

                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                    Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {"DefaultBoundaryStyle" -> Automatic, 
                    "DefaultMeshStyle" -> AbsolutePointSize[6], 
                    "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 12.}, {-2.3445187695684826`, 
                    13.644999694915255`}}, PlotRangeClipping -> True, 
                    PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["3", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["False", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic], 
                    BaselinePosition -> Baseline], DynamicModuleValues :> {}], 
                    StyleBox["]", "NonInterpretableSummary"]}]},
                  "CopyTag",
                  DisplayFunction->(#& ),
                  
                  InterpretationFunction->(
                   "InterpolatingFunction[{{-6., 12.}}, <>]"& )],
                 False,
                 Editable->False,
                 SelectWithContents->True,
                 Selectable->False], "[", "x", "]"}]}]}], ")"}], "2"]}]]}], 
        SqrtBox["\[Pi]"]], "+", 
       RowBox[{
        RowBox[{"Erfc", "[", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"th", "+", "x", "-", 
            RowBox[{"2", " ", 
             RowBox[{
              TagBox[
               TemplateBox[{
                 RowBox[{
                   StyleBox[
                    TagBox["InterpolatingFunction", "SummaryHead"], 
                    "NonInterpretableSummary"], 
                   StyleBox["[", "NonInterpretableSummary"], 
                   DynamicModuleBox[{Typeset`open$$ = False}, 
                    PanelBox[
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquarePlusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAGa+G6///F8AEPYEOk8ECwLHNhJqG
0xbAOppvSOyJAcAYzwMVx40VwIC0Y+UGNgDAoWKExp1dFMCbPA++huz9v9lN
huBrMxPATRVP/+Rz+7/hGwnG8+8RwAHZZZCkvfi/CXyN4hHCEMBFukjVMyz2
vwN+JZXT9Q7AaLVAkHFW879UszI2cnMMwPQWO6i8fPC/5wxDRT0cCsD8lZs0
BIHrvxksVet7kgfAYnVUK05c5b+Mb2r/5jMFwDpdPf02wd6/YGKC5EDhAsA0
h5/BEXTSv9ManGAOXADA5qUmemthsb8O73GVEAT8vzRFKI5cRMM/tDOvl+vq
9r9R+X/uwLzZPxzX8Tuk6fG/LcAJqgk/5T8NhnV4a33qv3C58SKnb+0/XnQO
1Vxd4L/U+5Ihm1PzP9POz6b/p8u/SPSteEC/9z/Fs/ssdZy6Pw/Fi3pHofw/
R0bQ4cPC2j9L6fbywL4AQMk+JISDwuY/9Q+2BHwIA0D5oaxd63bwPweiM2vG
hwVAC9xAHTw29T+HFWovrd8HQFu3zzqv3fk/vhTj3hkuCkBuB1sqO+r+P/GA
g/YFsQxAfwfwHjfQAUCRRCcGgQsPQKjFsBHdXQRAmlTynQTOEEBw1G4zlN8G
QCJzXSG4EhJA974p5x42CUCjoywXS0QTQN/j4gM2vwtA+q57CMqSFECF5Jiy
IB0OQGAutNQszRVA5RomSI43EEBIV3yfcAEXQLngfmvSeRFAO0fJ8ZhMGEBs
FNZXgKYSQGun/0XAehlAT2WseHTsE0CF2aosNrcaQBIkgWLSHBVASvL1URHS
G0Aki9TjOEcWQOIiBOKg2hxAZg+nmeWKF0CuhqhBcusdQIcBeBj8uBhAFyy4
dMFPH0DaEMjLWAAaQHffh9ZpSiBAfMiWFr5BG0BJO+97HOsgQP3tYyqNbRxA
CM7VBQSBIUCvMLByorIdQGLv+6mOIyJAQeH6gyHiHkCrR6EyTrsiQBEdYpbU
BSBAG/QFBxJQI0AZWAaFO6cgQCMvqvV48SNAEcopWNc9IUAboc3IFIgkQKHK
jEUW4SFAq6EwtlMrJUBZH69+WYEiQGP2Uu+WyyVAAatQnNEWI0ALgvQMD2Em
QEHFMdTsuCNAS5zVRCoDJ0BxFpLwPFAkQHvtNWF6midAOfYxJzD0JEBDzdWX
bT4oQCkqkaknlSVAMwE1GmXfKEAIlW8QVCsmQBJsE4GRdSlAgI6NkSPOJkCK
ZTECYRgqQOe+KvcnZidA8ZXOZ2WwKkCNV8P1//8nQJcuZ2Y9SitALwmyqA==

                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                    Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 12.}, {-2.3445187695684826`, 
                    13.644999694915255`}}, PlotRangeClipping -> True, 
                    PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquareMinusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAGa+G6///F8AEPYEOk8ECwLHNhJqG
0xbAOppvSOyJAcAYzwMVx40VwIC0Y+UGNgDAoWKExp1dFMCbPA++huz9v9lN
huBrMxPATRVP/+Rz+7/hGwnG8+8RwAHZZZCkvfi/CXyN4hHCEMBFukjVMyz2
vwN+JZXT9Q7AaLVAkHFW879UszI2cnMMwPQWO6i8fPC/5wxDRT0cCsD8lZs0
BIHrvxksVet7kgfAYnVUK05c5b+Mb2r/5jMFwDpdPf02wd6/YGKC5EDhAsA0
h5/BEXTSv9ManGAOXADA5qUmemthsb8O73GVEAT8vzRFKI5cRMM/tDOvl+vq
9r9R+X/uwLzZPxzX8Tuk6fG/LcAJqgk/5T8NhnV4a33qv3C58SKnb+0/XnQO
1Vxd4L/U+5Ihm1PzP9POz6b/p8u/SPSteEC/9z/Fs/ssdZy6Pw/Fi3pHofw/
R0bQ4cPC2j9L6fbywL4AQMk+JISDwuY/9Q+2BHwIA0D5oaxd63bwPweiM2vG
hwVAC9xAHTw29T+HFWovrd8HQFu3zzqv3fk/vhTj3hkuCkBuB1sqO+r+P/GA
g/YFsQxAfwfwHjfQAUCRRCcGgQsPQKjFsBHdXQRAmlTynQTOEEBw1G4zlN8G
QCJzXSG4EhJA974p5x42CUCjoywXS0QTQN/j4gM2vwtA+q57CMqSFECF5Jiy
IB0OQGAutNQszRVA5RomSI43EEBIV3yfcAEXQLngfmvSeRFAO0fJ8ZhMGEBs
FNZXgKYSQGun/0XAehlAT2WseHTsE0CF2aosNrcaQBIkgWLSHBVASvL1URHS
G0Aki9TjOEcWQOIiBOKg2hxAZg+nmeWKF0CuhqhBcusdQIcBeBj8uBhAFyy4
dMFPH0DaEMjLWAAaQHffh9ZpSiBAfMiWFr5BG0BJO+97HOsgQP3tYyqNbRxA
CM7VBQSBIUCvMLByorIdQGLv+6mOIyJAQeH6gyHiHkCrR6EyTrsiQBEdYpbU
BSBAG/QFBxJQI0AZWAaFO6cgQCMvqvV48SNAEcopWNc9IUAboc3IFIgkQKHK
jEUW4SFAq6EwtlMrJUBZH69+WYEiQGP2Uu+WyyVAAatQnNEWI0ALgvQMD2Em
QEHFMdTsuCNAS5zVRCoDJ0BxFpLwPFAkQHvtNWF6midAOfYxJzD0JEBDzdWX
bT4oQCkqkaknlSVAMwE1GmXfKEAIlW8QVCsmQBJsE4GRdSlAgI6NkSPOJkCK
ZTECYRgqQOe+KvcnZidA8ZXOZ2WwKkCNV8P1//8nQJcuZ2Y9SitALwmyqA==

                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                    Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 12.}, {-2.3445187695684826`, 
                    13.644999694915255`}}, PlotRangeClipping -> True, 
                    PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["3", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["False", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic], 
                    BaselinePosition -> Baseline], DynamicModuleValues :> {}], 
                   StyleBox["]", "NonInterpretableSummary"]}]},
                "CopyTag",
                DisplayFunction->(#& ),
                
                InterpretationFunction->(
                 "InterpolatingFunction[{{-6., 12.}}, <>]"& )],
               False,
               Editable->False,
               SelectWithContents->True,
               Selectable->False], "[", "x", "]"}]}]}], ")"}]}], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{"th", "+", "x", "-", 
          RowBox[{"2", " ", 
           RowBox[{
            TagBox[
             TemplateBox[{
               RowBox[{
                 StyleBox[
                  TagBox["InterpolatingFunction", "SummaryHead"], 
                  "NonInterpretableSummary"], 
                 StyleBox["[", "NonInterpretableSummary"], 
                 DynamicModuleBox[{Typeset`open$$ = False}, 
                  PanelBox[
                   PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquarePlusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAGa+G6///F8AEPYEOk8ECwLHNhJqG
0xbAOppvSOyJAcAYzwMVx40VwIC0Y+UGNgDAoWKExp1dFMCbPA++huz9v9lN
huBrMxPATRVP/+Rz+7/hGwnG8+8RwAHZZZCkvfi/CXyN4hHCEMBFukjVMyz2
vwN+JZXT9Q7AaLVAkHFW879UszI2cnMMwPQWO6i8fPC/5wxDRT0cCsD8lZs0
BIHrvxksVet7kgfAYnVUK05c5b+Mb2r/5jMFwDpdPf02wd6/YGKC5EDhAsA0
h5/BEXTSv9ManGAOXADA5qUmemthsb8O73GVEAT8vzRFKI5cRMM/tDOvl+vq
9r9R+X/uwLzZPxzX8Tuk6fG/LcAJqgk/5T8NhnV4a33qv3C58SKnb+0/XnQO
1Vxd4L/U+5Ihm1PzP9POz6b/p8u/SPSteEC/9z/Fs/ssdZy6Pw/Fi3pHofw/
R0bQ4cPC2j9L6fbywL4AQMk+JISDwuY/9Q+2BHwIA0D5oaxd63bwPweiM2vG
hwVAC9xAHTw29T+HFWovrd8HQFu3zzqv3fk/vhTj3hkuCkBuB1sqO+r+P/GA
g/YFsQxAfwfwHjfQAUCRRCcGgQsPQKjFsBHdXQRAmlTynQTOEEBw1G4zlN8G
QCJzXSG4EhJA974p5x42CUCjoywXS0QTQN/j4gM2vwtA+q57CMqSFECF5Jiy
IB0OQGAutNQszRVA5RomSI43EEBIV3yfcAEXQLngfmvSeRFAO0fJ8ZhMGEBs
FNZXgKYSQGun/0XAehlAT2WseHTsE0CF2aosNrcaQBIkgWLSHBVASvL1URHS
G0Aki9TjOEcWQOIiBOKg2hxAZg+nmeWKF0CuhqhBcusdQIcBeBj8uBhAFyy4
dMFPH0DaEMjLWAAaQHffh9ZpSiBAfMiWFr5BG0BJO+97HOsgQP3tYyqNbRxA
CM7VBQSBIUCvMLByorIdQGLv+6mOIyJAQeH6gyHiHkCrR6EyTrsiQBEdYpbU
BSBAG/QFBxJQI0AZWAaFO6cgQCMvqvV48SNAEcopWNc9IUAboc3IFIgkQKHK
jEUW4SFAq6EwtlMrJUBZH69+WYEiQGP2Uu+WyyVAAatQnNEWI0ALgvQMD2Em
QEHFMdTsuCNAS5zVRCoDJ0BxFpLwPFAkQHvtNWF6midAOfYxJzD0JEBDzdWX
bT4oQCkqkaknlSVAMwE1GmXfKEAIlW8QVCsmQBJsE4GRdSlAgI6NkSPOJkCK
ZTECYRgqQOe+KvcnZidA8ZXOZ2WwKkCNV8P1//8nQJcuZ2Y9SitALwmyqA==

                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                    Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 12.}, {-2.3445187695684826`, 
                    13.644999694915255`}}, PlotRangeClipping -> True, 
                    PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquareMinusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAGa+G6///F8AEPYEOk8ECwLHNhJqG
0xbAOppvSOyJAcAYzwMVx40VwIC0Y+UGNgDAoWKExp1dFMCbPA++huz9v9lN
huBrMxPATRVP/+Rz+7/hGwnG8+8RwAHZZZCkvfi/CXyN4hHCEMBFukjVMyz2
vwN+JZXT9Q7AaLVAkHFW879UszI2cnMMwPQWO6i8fPC/5wxDRT0cCsD8lZs0
BIHrvxksVet7kgfAYnVUK05c5b+Mb2r/5jMFwDpdPf02wd6/YGKC5EDhAsA0
h5/BEXTSv9ManGAOXADA5qUmemthsb8O73GVEAT8vzRFKI5cRMM/tDOvl+vq
9r9R+X/uwLzZPxzX8Tuk6fG/LcAJqgk/5T8NhnV4a33qv3C58SKnb+0/XnQO
1Vxd4L/U+5Ihm1PzP9POz6b/p8u/SPSteEC/9z/Fs/ssdZy6Pw/Fi3pHofw/
R0bQ4cPC2j9L6fbywL4AQMk+JISDwuY/9Q+2BHwIA0D5oaxd63bwPweiM2vG
hwVAC9xAHTw29T+HFWovrd8HQFu3zzqv3fk/vhTj3hkuCkBuB1sqO+r+P/GA
g/YFsQxAfwfwHjfQAUCRRCcGgQsPQKjFsBHdXQRAmlTynQTOEEBw1G4zlN8G
QCJzXSG4EhJA974p5x42CUCjoywXS0QTQN/j4gM2vwtA+q57CMqSFECF5Jiy
IB0OQGAutNQszRVA5RomSI43EEBIV3yfcAEXQLngfmvSeRFAO0fJ8ZhMGEBs
FNZXgKYSQGun/0XAehlAT2WseHTsE0CF2aosNrcaQBIkgWLSHBVASvL1URHS
G0Aki9TjOEcWQOIiBOKg2hxAZg+nmeWKF0CuhqhBcusdQIcBeBj8uBhAFyy4
dMFPH0DaEMjLWAAaQHffh9ZpSiBAfMiWFr5BG0BJO+97HOsgQP3tYyqNbRxA
CM7VBQSBIUCvMLByorIdQGLv+6mOIyJAQeH6gyHiHkCrR6EyTrsiQBEdYpbU
BSBAG/QFBxJQI0AZWAaFO6cgQCMvqvV48SNAEcopWNc9IUAboc3IFIgkQKHK
jEUW4SFAq6EwtlMrJUBZH69+WYEiQGP2Uu+WyyVAAatQnNEWI0ALgvQMD2Em
QEHFMdTsuCNAS5zVRCoDJ0BxFpLwPFAkQHvtNWF6midAOfYxJzD0JEBDzdWX
bT4oQCkqkaknlSVAMwE1GmXfKEAIlW8QVCsmQBJsE4GRdSlAgI6NkSPOJkCK
ZTECYRgqQOe+KvcnZidA8ZXOZ2WwKkCNV8P1//8nQJcuZ2Y9SitALwmyqA==

                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                    Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 12.}, {-2.3445187695684826`, 
                    13.644999694915255`}}, PlotRangeClipping -> True, 
                    PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["3", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["False", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic], 
                   BaselinePosition -> Baseline], DynamicModuleValues :> {}], 
                 StyleBox["]", "NonInterpretableSummary"]}]},
              "CopyTag",
              DisplayFunction->(#& ),
              
              InterpretationFunction->(
               "InterpolatingFunction[{{-6., 12.}}, <>]"& )],
             False,
             Editable->False,
             SelectWithContents->True,
             Selectable->False], "[", "x", "]"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"Erfc", "[", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "th"}], "+", "x", "-", 
            RowBox[{"2", " ", 
             RowBox[{
              TagBox[
               TemplateBox[{
                 RowBox[{
                   StyleBox[
                    TagBox["InterpolatingFunction", "SummaryHead"], 
                    "NonInterpretableSummary"], 
                   StyleBox["[", "NonInterpretableSummary"], 
                   DynamicModuleBox[{Typeset`open$$ = False}, 
                    PanelBox[
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquarePlusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAGa+G6///F8AEPYEOk8ECwLHNhJqG
0xbAOppvSOyJAcAYzwMVx40VwIC0Y+UGNgDAoWKExp1dFMCbPA++huz9v9lN
huBrMxPATRVP/+Rz+7/hGwnG8+8RwAHZZZCkvfi/CXyN4hHCEMBFukjVMyz2
vwN+JZXT9Q7AaLVAkHFW879UszI2cnMMwPQWO6i8fPC/5wxDRT0cCsD8lZs0
BIHrvxksVet7kgfAYnVUK05c5b+Mb2r/5jMFwDpdPf02wd6/YGKC5EDhAsA0
h5/BEXTSv9ManGAOXADA5qUmemthsb8O73GVEAT8vzRFKI5cRMM/tDOvl+vq
9r9R+X/uwLzZPxzX8Tuk6fG/LcAJqgk/5T8NhnV4a33qv3C58SKnb+0/XnQO
1Vxd4L/U+5Ihm1PzP9POz6b/p8u/SPSteEC/9z/Fs/ssdZy6Pw/Fi3pHofw/
R0bQ4cPC2j9L6fbywL4AQMk+JISDwuY/9Q+2BHwIA0D5oaxd63bwPweiM2vG
hwVAC9xAHTw29T+HFWovrd8HQFu3zzqv3fk/vhTj3hkuCkBuB1sqO+r+P/GA
g/YFsQxAfwfwHjfQAUCRRCcGgQsPQKjFsBHdXQRAmlTynQTOEEBw1G4zlN8G
QCJzXSG4EhJA974p5x42CUCjoywXS0QTQN/j4gM2vwtA+q57CMqSFECF5Jiy
IB0OQGAutNQszRVA5RomSI43EEBIV3yfcAEXQLngfmvSeRFAO0fJ8ZhMGEBs
FNZXgKYSQGun/0XAehlAT2WseHTsE0CF2aosNrcaQBIkgWLSHBVASvL1URHS
G0Aki9TjOEcWQOIiBOKg2hxAZg+nmeWKF0CuhqhBcusdQIcBeBj8uBhAFyy4
dMFPH0DaEMjLWAAaQHffh9ZpSiBAfMiWFr5BG0BJO+97HOsgQP3tYyqNbRxA
CM7VBQSBIUCvMLByorIdQGLv+6mOIyJAQeH6gyHiHkCrR6EyTrsiQBEdYpbU
BSBAG/QFBxJQI0AZWAaFO6cgQCMvqvV48SNAEcopWNc9IUAboc3IFIgkQKHK
jEUW4SFAq6EwtlMrJUBZH69+WYEiQGP2Uu+WyyVAAatQnNEWI0ALgvQMD2Em
QEHFMdTsuCNAS5zVRCoDJ0BxFpLwPFAkQHvtNWF6midAOfYxJzD0JEBDzdWX
bT4oQCkqkaknlSVAMwE1GmXfKEAIlW8QVCsmQBJsE4GRdSlAgI6NkSPOJkCK
ZTECYRgqQOe+KvcnZidA8ZXOZ2WwKkCNV8P1//8nQJcuZ2Y9SitALwmyqA==

                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                    Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 12.}, {-2.3445187695684826`, 
                    13.644999694915255`}}, PlotRangeClipping -> True, 
                    PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquareMinusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAGa+G6///F8AEPYEOk8ECwLHNhJqG
0xbAOppvSOyJAcAYzwMVx40VwIC0Y+UGNgDAoWKExp1dFMCbPA++huz9v9lN
huBrMxPATRVP/+Rz+7/hGwnG8+8RwAHZZZCkvfi/CXyN4hHCEMBFukjVMyz2
vwN+JZXT9Q7AaLVAkHFW879UszI2cnMMwPQWO6i8fPC/5wxDRT0cCsD8lZs0
BIHrvxksVet7kgfAYnVUK05c5b+Mb2r/5jMFwDpdPf02wd6/YGKC5EDhAsA0
h5/BEXTSv9ManGAOXADA5qUmemthsb8O73GVEAT8vzRFKI5cRMM/tDOvl+vq
9r9R+X/uwLzZPxzX8Tuk6fG/LcAJqgk/5T8NhnV4a33qv3C58SKnb+0/XnQO
1Vxd4L/U+5Ihm1PzP9POz6b/p8u/SPSteEC/9z/Fs/ssdZy6Pw/Fi3pHofw/
R0bQ4cPC2j9L6fbywL4AQMk+JISDwuY/9Q+2BHwIA0D5oaxd63bwPweiM2vG
hwVAC9xAHTw29T+HFWovrd8HQFu3zzqv3fk/vhTj3hkuCkBuB1sqO+r+P/GA
g/YFsQxAfwfwHjfQAUCRRCcGgQsPQKjFsBHdXQRAmlTynQTOEEBw1G4zlN8G
QCJzXSG4EhJA974p5x42CUCjoywXS0QTQN/j4gM2vwtA+q57CMqSFECF5Jiy
IB0OQGAutNQszRVA5RomSI43EEBIV3yfcAEXQLngfmvSeRFAO0fJ8ZhMGEBs
FNZXgKYSQGun/0XAehlAT2WseHTsE0CF2aosNrcaQBIkgWLSHBVASvL1URHS
G0Aki9TjOEcWQOIiBOKg2hxAZg+nmeWKF0CuhqhBcusdQIcBeBj8uBhAFyy4
dMFPH0DaEMjLWAAaQHffh9ZpSiBAfMiWFr5BG0BJO+97HOsgQP3tYyqNbRxA
CM7VBQSBIUCvMLByorIdQGLv+6mOIyJAQeH6gyHiHkCrR6EyTrsiQBEdYpbU
BSBAG/QFBxJQI0AZWAaFO6cgQCMvqvV48SNAEcopWNc9IUAboc3IFIgkQKHK
jEUW4SFAq6EwtlMrJUBZH69+WYEiQGP2Uu+WyyVAAatQnNEWI0ALgvQMD2Em
QEHFMdTsuCNAS5zVRCoDJ0BxFpLwPFAkQHvtNWF6midAOfYxJzD0JEBDzdWX
bT4oQCkqkaknlSVAMwE1GmXfKEAIlW8QVCsmQBJsE4GRdSlAgI6NkSPOJkCK
ZTECYRgqQOe+KvcnZidA8ZXOZ2WwKkCNV8P1//8nQJcuZ2Y9SitALwmyqA==

                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                    Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 12.}, {-2.3445187695684826`, 
                    13.644999694915255`}}, PlotRangeClipping -> True, 
                    PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["3", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["False", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic], 
                    BaselinePosition -> Baseline], DynamicModuleValues :> {}], 
                   StyleBox["]", "NonInterpretableSummary"]}]},
                "CopyTag",
                DisplayFunction->(#& ),
                
                InterpretationFunction->(
                 "InterpolatingFunction[{{-6., 12.}}, <>]"& )],
               False,
               Editable->False,
               SelectWithContents->True,
               Selectable->False], "[", "x", "]"}]}]}], ")"}]}], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{"th", "-", "x", "+", 
          RowBox[{"2", " ", 
           RowBox[{
            TagBox[
             TemplateBox[{
               RowBox[{
                 StyleBox[
                  TagBox["InterpolatingFunction", "SummaryHead"], 
                  "NonInterpretableSummary"], 
                 StyleBox["[", "NonInterpretableSummary"], 
                 DynamicModuleBox[{Typeset`open$$ = False}, 
                  PanelBox[
                   PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquarePlusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAGa+G6///F8AEPYEOk8ECwLHNhJqG
0xbAOppvSOyJAcAYzwMVx40VwIC0Y+UGNgDAoWKExp1dFMCbPA++huz9v9lN
huBrMxPATRVP/+Rz+7/hGwnG8+8RwAHZZZCkvfi/CXyN4hHCEMBFukjVMyz2
vwN+JZXT9Q7AaLVAkHFW879UszI2cnMMwPQWO6i8fPC/5wxDRT0cCsD8lZs0
BIHrvxksVet7kgfAYnVUK05c5b+Mb2r/5jMFwDpdPf02wd6/YGKC5EDhAsA0
h5/BEXTSv9ManGAOXADA5qUmemthsb8O73GVEAT8vzRFKI5cRMM/tDOvl+vq
9r9R+X/uwLzZPxzX8Tuk6fG/LcAJqgk/5T8NhnV4a33qv3C58SKnb+0/XnQO
1Vxd4L/U+5Ihm1PzP9POz6b/p8u/SPSteEC/9z/Fs/ssdZy6Pw/Fi3pHofw/
R0bQ4cPC2j9L6fbywL4AQMk+JISDwuY/9Q+2BHwIA0D5oaxd63bwPweiM2vG
hwVAC9xAHTw29T+HFWovrd8HQFu3zzqv3fk/vhTj3hkuCkBuB1sqO+r+P/GA
g/YFsQxAfwfwHjfQAUCRRCcGgQsPQKjFsBHdXQRAmlTynQTOEEBw1G4zlN8G
QCJzXSG4EhJA974p5x42CUCjoywXS0QTQN/j4gM2vwtA+q57CMqSFECF5Jiy
IB0OQGAutNQszRVA5RomSI43EEBIV3yfcAEXQLngfmvSeRFAO0fJ8ZhMGEBs
FNZXgKYSQGun/0XAehlAT2WseHTsE0CF2aosNrcaQBIkgWLSHBVASvL1URHS
G0Aki9TjOEcWQOIiBOKg2hxAZg+nmeWKF0CuhqhBcusdQIcBeBj8uBhAFyy4
dMFPH0DaEMjLWAAaQHffh9ZpSiBAfMiWFr5BG0BJO+97HOsgQP3tYyqNbRxA
CM7VBQSBIUCvMLByorIdQGLv+6mOIyJAQeH6gyHiHkCrR6EyTrsiQBEdYpbU
BSBAG/QFBxJQI0AZWAaFO6cgQCMvqvV48SNAEcopWNc9IUAboc3IFIgkQKHK
jEUW4SFAq6EwtlMrJUBZH69+WYEiQGP2Uu+WyyVAAatQnNEWI0ALgvQMD2Em
QEHFMdTsuCNAS5zVRCoDJ0BxFpLwPFAkQHvtNWF6midAOfYxJzD0JEBDzdWX
bT4oQCkqkaknlSVAMwE1GmXfKEAIlW8QVCsmQBJsE4GRdSlAgI6NkSPOJkCK
ZTECYRgqQOe+KvcnZidA8ZXOZ2WwKkCNV8P1//8nQJcuZ2Y9SitALwmyqA==

                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                    Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 12.}, {-2.3445187695684826`, 
                    13.644999694915255`}}, PlotRangeClipping -> True, 
                    PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquareMinusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAGa+G6///F8AEPYEOk8ECwLHNhJqG
0xbAOppvSOyJAcAYzwMVx40VwIC0Y+UGNgDAoWKExp1dFMCbPA++huz9v9lN
huBrMxPATRVP/+Rz+7/hGwnG8+8RwAHZZZCkvfi/CXyN4hHCEMBFukjVMyz2
vwN+JZXT9Q7AaLVAkHFW879UszI2cnMMwPQWO6i8fPC/5wxDRT0cCsD8lZs0
BIHrvxksVet7kgfAYnVUK05c5b+Mb2r/5jMFwDpdPf02wd6/YGKC5EDhAsA0
h5/BEXTSv9ManGAOXADA5qUmemthsb8O73GVEAT8vzRFKI5cRMM/tDOvl+vq
9r9R+X/uwLzZPxzX8Tuk6fG/LcAJqgk/5T8NhnV4a33qv3C58SKnb+0/XnQO
1Vxd4L/U+5Ihm1PzP9POz6b/p8u/SPSteEC/9z/Fs/ssdZy6Pw/Fi3pHofw/
R0bQ4cPC2j9L6fbywL4AQMk+JISDwuY/9Q+2BHwIA0D5oaxd63bwPweiM2vG
hwVAC9xAHTw29T+HFWovrd8HQFu3zzqv3fk/vhTj3hkuCkBuB1sqO+r+P/GA
g/YFsQxAfwfwHjfQAUCRRCcGgQsPQKjFsBHdXQRAmlTynQTOEEBw1G4zlN8G
QCJzXSG4EhJA974p5x42CUCjoywXS0QTQN/j4gM2vwtA+q57CMqSFECF5Jiy
IB0OQGAutNQszRVA5RomSI43EEBIV3yfcAEXQLngfmvSeRFAO0fJ8ZhMGEBs
FNZXgKYSQGun/0XAehlAT2WseHTsE0CF2aosNrcaQBIkgWLSHBVASvL1URHS
G0Aki9TjOEcWQOIiBOKg2hxAZg+nmeWKF0CuhqhBcusdQIcBeBj8uBhAFyy4
dMFPH0DaEMjLWAAaQHffh9ZpSiBAfMiWFr5BG0BJO+97HOsgQP3tYyqNbRxA
CM7VBQSBIUCvMLByorIdQGLv+6mOIyJAQeH6gyHiHkCrR6EyTrsiQBEdYpbU
BSBAG/QFBxJQI0AZWAaFO6cgQCMvqvV48SNAEcopWNc9IUAboc3IFIgkQKHK
jEUW4SFAq6EwtlMrJUBZH69+WYEiQGP2Uu+WyyVAAatQnNEWI0ALgvQMD2Em
QEHFMdTsuCNAS5zVRCoDJ0BxFpLwPFAkQHvtNWF6midAOfYxJzD0JEBDzdWX
bT4oQCkqkaknlSVAMwE1GmXfKEAIlW8QVCsmQBJsE4GRdSlAgI6NkSPOJkCK
ZTECYRgqQOe+KvcnZidA8ZXOZ2WwKkCNV8P1//8nQJcuZ2Y9SitALwmyqA==

                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                    Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 12.}, {-2.3445187695684826`, 
                    13.644999694915255`}}, PlotRangeClipping -> True, 
                    PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["3", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["False", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic], 
                   BaselinePosition -> Baseline], DynamicModuleValues :> {}], 
                 StyleBox["]", "NonInterpretableSummary"]}]},
              "CopyTag",
              DisplayFunction->(#& ),
              
              InterpretationFunction->(
               "InterpolatingFunction[{{-6., 12.}}, <>]"& )],
             False,
             Editable->False,
             SelectWithContents->True,
             Selectable->False], "[", "x", "]"}]}]}], ")"}]}]}], ")"}]}]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{3.6723975263250704`*^9, 3.6724014204215307`*^9, 
  3.672402635264003*^9, 3.672403555918059*^9, 3.67240452433189*^9, 
  3.6725726493117533`*^9},ExpressionUUID->"094ce12a-eb61-4669-9996-\
0d9e0c6a11d9"],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"Erfc", "[", 
    RowBox[{
     RowBox[{"0.5`", " ", "th"}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "th"}], "+", "x"}], ")"}]}], "-", 
     RowBox[{
      TagBox[
       TemplateBox[{
         RowBox[{
           StyleBox[
            TagBox["InterpolatingFunction", "SummaryHead"], 
            "NonInterpretableSummary"], 
           StyleBox["[", "NonInterpretableSummary"], 
           DynamicModuleBox[{Typeset`open$$ = False}, 
            PanelBox[
             PaneSelectorBox[{False -> GridBox[{{
                   PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquarePlusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                   GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJxFzn9Q02UABvCN/XKKaxM2YWwTHPJ10zOFmtTQvURGZgR5dE5xxq3DvEBo
BIRJBAjjSMad2JR2lEIeVHA3Ey+XZ3tfRyhJwmIrLoqDTScnA4ELhrxfdNk/
3/3x3HOfv54nTl+0Py+MRqOlPMv/HW01+oPB9WhbXGN/we616Ie7tRajS4Q2
0y3TsdJwFDXEEN42CZH14Tev1vtWozZ97a2vdJFoIYG+7fEvXPRXhnEiPykC
hQvyUn3dq5Anhnvr31kBemXfeJqwmoO4FSavwMFHs5ayUW4hGzEqN5ldizyU
JWfdtbzBQtk9iarij8LR34TQG/EiE02Gp+3ZJVmNjhGS5BU1A0Vvfcd/spmD
bvKqco+pw1Bj0QfBB0ks5Ot1bEA5dJSrr7kPPGHopOGtbnszDbnErbm8wzS0
d8DMZbcHIW/WYOYzV+DVJRXRWvAUXk2ynvdPBSAnMdMVc+gJlIzMqy89nIeJ
1wJ8RcMKXGssLc//dAraL/RkNARIeKSE98dh3QRkqMSNe2tI6Boc6gh2DkD5
o/rj4AUS9vWQW0tbr2uGuTeIqiUM019zenodoxrmzRMzzt8w/HV3fO0pxwON
kXYo/Ucrhstt3Tp/2Zwmsv16eVsLhmv+AdIU1aImLPNsqqwBw5xrQy9bx5Y1
zxcHamorMSzk5CjVU081pbjL4fwYw884c7KdTjpI+KRw8GwZht/2XRaM6ZhA
dPv9bG0Fhh+6C5O+GGeDLnmLzHYawyW7YlKm4oKL/HebHl3CcPyel6GCa4By
YbP4xrN/dfdbrsRKeaBk7usZA8bQJ054vWknHzTNa3UNBAl/mqjMHz4hACyL
Ilq8j4QFkX8eqOpYB5hvdtiCWSTMzOsuL5mOACPO5SH2FhKui6/WD0uEwJvs
+pl0Yxh/2n0vOV0EFo7YH1/IwPDoc51f+j5fD2RjrIuJNcuwnl4etWKLAmnf
0wzCHAxH+f0DWpoY7LfJ6vxvY1jRf05kT42h/GTmPaXpuISydfvl4vYrUsqp
HnwqziujLJDqz7lZsZSjtew6dWfIgjsK7ciuOMptdxr3iDwhH9xgrTxYvZEy
vSur9XeRPLTXt8M9bQvZIGqeS8mKp/xSYAexfSFkhfLMd4R5E+VV5iJ+9pYE
ylVNpjPywZAn7col4ihB2XSgdzEYDPk/F+PlOQ==
                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, -3.9000000000000004`}, DisplayFunction :> 
                    Identity, Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 
                    12.}, {-3.6554809253467715`, -1.5942865610975967`}}, 
                    PlotRangeClipping -> True, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                   GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                 GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False,
                  GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                 BaselinePosition -> {1, 1}], True -> GridBox[{{
                   PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquareMinusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                   GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJxFzn9Q02UABvCN/XKKaxM2YWwTHPJ10zOFmtTQvURGZgR5dE5xxq3DvEBo
BIRJBAjjSMad2JR2lEIeVHA3Ey+XZ3tfRyhJwmIrLoqDTScnA4ELhrxfdNk/
3/3x3HOfv54nTl+0Py+MRqOlPMv/HW01+oPB9WhbXGN/we616Ie7tRajS4Q2
0y3TsdJwFDXEEN42CZH14Tev1vtWozZ97a2vdJFoIYG+7fEvXPRXhnEiPykC
hQvyUn3dq5Anhnvr31kBemXfeJqwmoO4FSavwMFHs5ayUW4hGzEqN5ldizyU
JWfdtbzBQtk9iarij8LR34TQG/EiE02Gp+3ZJVmNjhGS5BU1A0Vvfcd/spmD
bvKqco+pw1Bj0QfBB0ks5Ot1bEA5dJSrr7kPPGHopOGtbnszDbnErbm8wzS0
d8DMZbcHIW/WYOYzV+DVJRXRWvAUXk2ynvdPBSAnMdMVc+gJlIzMqy89nIeJ
1wJ8RcMKXGssLc//dAraL/RkNARIeKSE98dh3QRkqMSNe2tI6Boc6gh2DkD5
o/rj4AUS9vWQW0tbr2uGuTeIqiUM019zenodoxrmzRMzzt8w/HV3fO0pxwON
kXYo/Ucrhstt3Tp/2Zwmsv16eVsLhmv+AdIU1aImLPNsqqwBw5xrQy9bx5Y1
zxcHamorMSzk5CjVU081pbjL4fwYw884c7KdTjpI+KRw8GwZht/2XRaM6ZhA
dPv9bG0Fhh+6C5O+GGeDLnmLzHYawyW7YlKm4oKL/HebHl3CcPyel6GCa4By
YbP4xrN/dfdbrsRKeaBk7usZA8bQJ054vWknHzTNa3UNBAl/mqjMHz4hACyL
Ilq8j4QFkX8eqOpYB5hvdtiCWSTMzOsuL5mOACPO5SH2FhKui6/WD0uEwJvs
+pl0Yxh/2n0vOV0EFo7YH1/IwPDoc51f+j5fD2RjrIuJNcuwnl4etWKLAmnf
0wzCHAxH+f0DWpoY7LfJ6vxvY1jRf05kT42h/GTmPaXpuISydfvl4vYrUsqp
HnwqziujLJDqz7lZsZSjtew6dWfIgjsK7ciuOMptdxr3iDwhH9xgrTxYvZEy
vSur9XeRPLTXt8M9bQvZIGqeS8mKp/xSYAexfSFkhfLMd4R5E+VV5iJ+9pYE
ylVNpjPywZAn7col4ihB2XSgdzEYDPk/F+PlOQ==
                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, -3.9000000000000004`}, DisplayFunction :> 
                    Identity, Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 
                    12.}, {-3.6554809253467715`, -1.5942865610975967`}}, 
                    PlotRangeClipping -> True, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                   GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["3", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["False", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                 GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False,
                  GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                 BaselinePosition -> {1, 1}]}, 
              Dynamic[Typeset`open$$], ImageSize -> Automatic], 
             BaselinePosition -> Baseline], DynamicModuleValues :> {}], 
           StyleBox["]", "NonInterpretableSummary"]}]},
        "CopyTag",
        DisplayFunction->(#& ),
        InterpretationFunction->("InterpolatingFunction[{{-6., 12.}}, <>]"& )],
       False,
       Editable->False,
       SelectWithContents->True,
       Selectable->False], "[", "x", "]"}]}], "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"Erfc", "[", 
    RowBox[{
     RowBox[{"0.5`", " ", "th"}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "th"}], "+", "x"}], ")"}]}], "-", 
     RowBox[{
      TagBox[
       TemplateBox[{
         RowBox[{
           StyleBox[
            TagBox["InterpolatingFunction", "SummaryHead"], 
            "NonInterpretableSummary"], 
           StyleBox["[", "NonInterpretableSummary"], 
           DynamicModuleBox[{Typeset`open$$ = False}, 
            PanelBox[
             PaneSelectorBox[{False -> GridBox[{{
                   PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquarePlusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                   GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAGa+G6///F8AEPYEOk8ECwLHNhJqG
0xbAOppvSOyJAcAYzwMVx40VwIC0Y+UGNgDAoWKExp1dFMCbPA++huz9v9lN
huBrMxPATRVP/+Rz+7/hGwnG8+8RwAHZZZCkvfi/CXyN4hHCEMBFukjVMyz2
vwN+JZXT9Q7AaLVAkHFW879UszI2cnMMwPQWO6i8fPC/5wxDRT0cCsD8lZs0
BIHrvxksVet7kgfAYnVUK05c5b+Mb2r/5jMFwDpdPf02wd6/YGKC5EDhAsA0
h5/BEXTSv9ManGAOXADA5qUmemthsb8O73GVEAT8vzRFKI5cRMM/tDOvl+vq
9r9R+X/uwLzZPxzX8Tuk6fG/LcAJqgk/5T8NhnV4a33qv3C58SKnb+0/XnQO
1Vxd4L/U+5Ihm1PzP9POz6b/p8u/SPSteEC/9z/Fs/ssdZy6Pw/Fi3pHofw/
R0bQ4cPC2j9L6fbywL4AQMk+JISDwuY/9Q+2BHwIA0D5oaxd63bwPweiM2vG
hwVAC9xAHTw29T+HFWovrd8HQFu3zzqv3fk/vhTj3hkuCkBuB1sqO+r+P/GA
g/YFsQxAfwfwHjfQAUCRRCcGgQsPQKjFsBHdXQRAmlTynQTOEEBw1G4zlN8G
QCJzXSG4EhJA974p5x42CUCjoywXS0QTQN/j4gM2vwtA+q57CMqSFECF5Jiy
IB0OQGAutNQszRVA5RomSI43EEBIV3yfcAEXQLngfmvSeRFAO0fJ8ZhMGEBs
FNZXgKYSQGun/0XAehlAT2WseHTsE0CF2aosNrcaQBIkgWLSHBVASvL1URHS
G0Aki9TjOEcWQOIiBOKg2hxAZg+nmeWKF0CuhqhBcusdQIcBeBj8uBhAFyy4
dMFPH0DaEMjLWAAaQHffh9ZpSiBAfMiWFr5BG0BJO+97HOsgQP3tYyqNbRxA
CM7VBQSBIUCvMLByorIdQGLv+6mOIyJAQeH6gyHiHkCrR6EyTrsiQBEdYpbU
BSBAG/QFBxJQI0AZWAaFO6cgQCMvqvV48SNAEcopWNc9IUAboc3IFIgkQKHK
jEUW4SFAq6EwtlMrJUBZH69+WYEiQGP2Uu+WyyVAAatQnNEWI0ALgvQMD2Em
QEHFMdTsuCNAS5zVRCoDJ0BxFpLwPFAkQHvtNWF6midAOfYxJzD0JEBDzdWX
bT4oQCkqkaknlSVAMwE1GmXfKEAIlW8QVCsmQBJsE4GRdSlAgI6NkSPOJkCK
ZTECYRgqQOe+KvcnZidA8ZXOZ2WwKkCNV8P1//8nQJcuZ2Y9SitALwmyqA==

                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                    Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 12.}, {-2.3445187695684826`, 
                    13.644999694915255`}}, PlotRangeClipping -> True, 
                    PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                   GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}}, GridBoxAlignment -> 
                    {"Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                 GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False,
                  GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                 BaselinePosition -> {1, 1}], True -> GridBox[{{
                   PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquareMinusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                   GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAGa+G6///F8AEPYEOk8ECwLHNhJqG
0xbAOppvSOyJAcAYzwMVx40VwIC0Y+UGNgDAoWKExp1dFMCbPA++huz9v9lN
huBrMxPATRVP/+Rz+7/hGwnG8+8RwAHZZZCkvfi/CXyN4hHCEMBFukjVMyz2
vwN+JZXT9Q7AaLVAkHFW879UszI2cnMMwPQWO6i8fPC/5wxDRT0cCsD8lZs0
BIHrvxksVet7kgfAYnVUK05c5b+Mb2r/5jMFwDpdPf02wd6/YGKC5EDhAsA0
h5/BEXTSv9ManGAOXADA5qUmemthsb8O73GVEAT8vzRFKI5cRMM/tDOvl+vq
9r9R+X/uwLzZPxzX8Tuk6fG/LcAJqgk/5T8NhnV4a33qv3C58SKnb+0/XnQO
1Vxd4L/U+5Ihm1PzP9POz6b/p8u/SPSteEC/9z/Fs/ssdZy6Pw/Fi3pHofw/
R0bQ4cPC2j9L6fbywL4AQMk+JISDwuY/9Q+2BHwIA0D5oaxd63bwPweiM2vG
hwVAC9xAHTw29T+HFWovrd8HQFu3zzqv3fk/vhTj3hkuCkBuB1sqO+r+P/GA
g/YFsQxAfwfwHjfQAUCRRCcGgQsPQKjFsBHdXQRAmlTynQTOEEBw1G4zlN8G
QCJzXSG4EhJA974p5x42CUCjoywXS0QTQN/j4gM2vwtA+q57CMqSFECF5Jiy
IB0OQGAutNQszRVA5RomSI43EEBIV3yfcAEXQLngfmvSeRFAO0fJ8ZhMGEBs
FNZXgKYSQGun/0XAehlAT2WseHTsE0CF2aosNrcaQBIkgWLSHBVASvL1URHS
G0Aki9TjOEcWQOIiBOKg2hxAZg+nmeWKF0CuhqhBcusdQIcBeBj8uBhAFyy4
dMFPH0DaEMjLWAAaQHffh9ZpSiBAfMiWFr5BG0BJO+97HOsgQP3tYyqNbRxA
CM7VBQSBIUCvMLByorIdQGLv+6mOIyJAQeH6gyHiHkCrR6EyTrsiQBEdYpbU
BSBAG/QFBxJQI0AZWAaFO6cgQCMvqvV48SNAEcopWNc9IUAboc3IFIgkQKHK
jEUW4SFAq6EwtlMrJUBZH69+WYEiQGP2Uu+WyyVAAatQnNEWI0ALgvQMD2Em
QEHFMdTsuCNAS5zVRCoDJ0BxFpLwPFAkQHvtNWF6midAOfYxJzD0JEBDzdWX
bT4oQCkqkaknlSVAMwE1GmXfKEAIlW8QVCsmQBJsE4GRdSlAgI6NkSPOJkCK
ZTECYRgqQOe+KvcnZidA8ZXOZ2WwKkCNV8P1//8nQJcuZ2Y9SitALwmyqA==

                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                    Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 12.}, {-2.3445187695684826`, 
                    13.644999694915255`}}, PlotRangeClipping -> True, 
                    PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                   GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["3", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["False", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                 GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False,
                  GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                 BaselinePosition -> {1, 1}]}, 
              Dynamic[Typeset`open$$], ImageSize -> Automatic], 
             BaselinePosition -> Baseline], DynamicModuleValues :> {}], 
           StyleBox["]", "NonInterpretableSummary"]}]},
        "CopyTag",
        DisplayFunction->(#& ),
        InterpretationFunction->("InterpolatingFunction[{{-6., 12.}}, <>]"& )],
       False,
       Editable->False,
       SelectWithContents->True,
       Selectable->False], "[", "x", "]"}]}], "]"}]}]}]], "Output",
 CellChangeTimes->{3.6723975263250704`*^9, 3.6724014204215307`*^9, 
  3.672402635264003*^9, 3.672403555918059*^9, 3.67240452433189*^9, 
  3.6725727450903306`*^9},ExpressionUUID->"36ed4812-e1d6-4dde-badf-\
e867b0e17af5"],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"Erfc", "[", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "th"}], "+", "x"}], ")"}]}], "-", 
     RowBox[{
      TagBox[
       TemplateBox[{
         RowBox[{
           StyleBox[
            TagBox["InterpolatingFunction", "SummaryHead"], 
            "NonInterpretableSummary"], 
           StyleBox["[", "NonInterpretableSummary"], 
           DynamicModuleBox[{Typeset`open$$ = False}, 
            PanelBox[
             PaneSelectorBox[{False -> GridBox[{{
                   PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquarePlusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                   GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJxFzn9Q02UABvCN/XKKaxM2YWwTHPJ10zOFmtTQvURGZgR5dE5xxq3DvEBo
BIRJBAjjSMad2JR2lEIeVHA3Ey+XZ3tfRyhJwmIrLoqDTScnA4ELhrxfdNk/
3/3x3HOfv54nTl+0Py+MRqOlPMv/HW01+oPB9WhbXGN/we616Ie7tRajS4Q2
0y3TsdJwFDXEEN42CZH14Tev1vtWozZ97a2vdJFoIYG+7fEvXPRXhnEiPykC
hQvyUn3dq5Anhnvr31kBemXfeJqwmoO4FSavwMFHs5ayUW4hGzEqN5ldizyU
JWfdtbzBQtk9iarij8LR34TQG/EiE02Gp+3ZJVmNjhGS5BU1A0Vvfcd/spmD
bvKqco+pw1Bj0QfBB0ks5Ot1bEA5dJSrr7kPPGHopOGtbnszDbnErbm8wzS0
d8DMZbcHIW/WYOYzV+DVJRXRWvAUXk2ynvdPBSAnMdMVc+gJlIzMqy89nIeJ
1wJ8RcMKXGssLc//dAraL/RkNARIeKSE98dh3QRkqMSNe2tI6Boc6gh2DkD5
o/rj4AUS9vWQW0tbr2uGuTeIqiUM019zenodoxrmzRMzzt8w/HV3fO0pxwON
kXYo/Ucrhstt3Tp/2Zwmsv16eVsLhmv+AdIU1aImLPNsqqwBw5xrQy9bx5Y1
zxcHamorMSzk5CjVU081pbjL4fwYw884c7KdTjpI+KRw8GwZht/2XRaM6ZhA
dPv9bG0Fhh+6C5O+GGeDLnmLzHYawyW7YlKm4oKL/HebHl3CcPyel6GCa4By
YbP4xrN/dfdbrsRKeaBk7usZA8bQJ054vWknHzTNa3UNBAl/mqjMHz4hACyL
Ilq8j4QFkX8eqOpYB5hvdtiCWSTMzOsuL5mOACPO5SH2FhKui6/WD0uEwJvs
+pl0Yxh/2n0vOV0EFo7YH1/IwPDoc51f+j5fD2RjrIuJNcuwnl4etWKLAmnf
0wzCHAxH+f0DWpoY7LfJ6vxvY1jRf05kT42h/GTmPaXpuISydfvl4vYrUsqp
HnwqziujLJDqz7lZsZSjtew6dWfIgjsK7ciuOMptdxr3iDwhH9xgrTxYvZEy
vSur9XeRPLTXt8M9bQvZIGqeS8mKp/xSYAexfSFkhfLMd4R5E+VV5iJ+9pYE
ylVNpjPywZAn7col4ihB2XSgdzEYDPk/F+PlOQ==
                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, -3.9000000000000004`}, DisplayFunction :> 
                    Identity, Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 
                    12.}, {-3.6554809253467715`, -1.5942865610975967`}}, 
                    PlotRangeClipping -> True, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                   GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                 GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False,
                  GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                 BaselinePosition -> {1, 1}], True -> GridBox[{{
                   PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquareMinusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                   GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJxFzn9Q02UABvCN/XKKaxM2YWwTHPJ10zOFmtTQvURGZgR5dE5xxq3DvEBo
BIRJBAjjSMad2JR2lEIeVHA3Ey+XZ3tfRyhJwmIrLoqDTScnA4ELhrxfdNk/
3/3x3HOfv54nTl+0Py+MRqOlPMv/HW01+oPB9WhbXGN/we616Ie7tRajS4Q2
0y3TsdJwFDXEEN42CZH14Tev1vtWozZ97a2vdJFoIYG+7fEvXPRXhnEiPykC
hQvyUn3dq5Anhnvr31kBemXfeJqwmoO4FSavwMFHs5ayUW4hGzEqN5ldizyU
JWfdtbzBQtk9iarij8LR34TQG/EiE02Gp+3ZJVmNjhGS5BU1A0Vvfcd/spmD
bvKqco+pw1Bj0QfBB0ks5Ot1bEA5dJSrr7kPPGHopOGtbnszDbnErbm8wzS0
d8DMZbcHIW/WYOYzV+DVJRXRWvAUXk2ynvdPBSAnMdMVc+gJlIzMqy89nIeJ
1wJ8RcMKXGssLc//dAraL/RkNARIeKSE98dh3QRkqMSNe2tI6Boc6gh2DkD5
o/rj4AUS9vWQW0tbr2uGuTeIqiUM019zenodoxrmzRMzzt8w/HV3fO0pxwON
kXYo/Ucrhstt3Tp/2Zwmsv16eVsLhmv+AdIU1aImLPNsqqwBw5xrQy9bx5Y1
zxcHamorMSzk5CjVU081pbjL4fwYw884c7KdTjpI+KRw8GwZht/2XRaM6ZhA
dPv9bG0Fhh+6C5O+GGeDLnmLzHYawyW7YlKm4oKL/HebHl3CcPyel6GCa4By
YbP4xrN/dfdbrsRKeaBk7usZA8bQJ054vWknHzTNa3UNBAl/mqjMHz4hACyL
Ilq8j4QFkX8eqOpYB5hvdtiCWSTMzOsuL5mOACPO5SH2FhKui6/WD0uEwJvs
+pl0Yxh/2n0vOV0EFo7YH1/IwPDoc51f+j5fD2RjrIuJNcuwnl4etWKLAmnf
0wzCHAxH+f0DWpoY7LfJ6vxvY1jRf05kT42h/GTmPaXpuISydfvl4vYrUsqp
HnwqziujLJDqz7lZsZSjtew6dWfIgjsK7ciuOMptdxr3iDwhH9xgrTxYvZEy
vSur9XeRPLTXt8M9bQvZIGqeS8mKp/xSYAexfSFkhfLMd4R5E+VV5iJ+9pYE
ylVNpjPywZAn7col4ihB2XSgdzEYDPk/F+PlOQ==
                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, -3.9000000000000004`}, DisplayFunction :> 
                    Identity, Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 
                    12.}, {-3.6554809253467715`, -1.5942865610975967`}}, 
                    PlotRangeClipping -> True, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                   GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["3", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["False", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                 GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False,
                  GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                 BaselinePosition -> {1, 1}]}, 
              Dynamic[Typeset`open$$], ImageSize -> Automatic], 
             BaselinePosition -> Baseline], DynamicModuleValues :> {}], 
           StyleBox["]", "NonInterpretableSummary"]}]},
        "CopyTag",
        DisplayFunction->(#& ),
        InterpretationFunction->("InterpolatingFunction[{{-6., 12.}}, <>]"& )],
       False,
       Editable->False,
       SelectWithContents->True,
       Selectable->False], "[", "x", "]"}]}], "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"Erfc", "[", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "th"}], "+", "x"}], ")"}]}], "-", 
     RowBox[{
      TagBox[
       TemplateBox[{
         RowBox[{
           StyleBox[
            TagBox["InterpolatingFunction", "SummaryHead"], 
            "NonInterpretableSummary"], 
           StyleBox["[", "NonInterpretableSummary"], 
           DynamicModuleBox[{Typeset`open$$ = False}, 
            PanelBox[
             PaneSelectorBox[{False -> GridBox[{{
                   PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquarePlusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                   GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAGa+G6///F8AEPYEOk8ECwLHNhJqG
0xbAOppvSOyJAcAYzwMVx40VwIC0Y+UGNgDAoWKExp1dFMCbPA++huz9v9lN
huBrMxPATRVP/+Rz+7/hGwnG8+8RwAHZZZCkvfi/CXyN4hHCEMBFukjVMyz2
vwN+JZXT9Q7AaLVAkHFW879UszI2cnMMwPQWO6i8fPC/5wxDRT0cCsD8lZs0
BIHrvxksVet7kgfAYnVUK05c5b+Mb2r/5jMFwDpdPf02wd6/YGKC5EDhAsA0
h5/BEXTSv9ManGAOXADA5qUmemthsb8O73GVEAT8vzRFKI5cRMM/tDOvl+vq
9r9R+X/uwLzZPxzX8Tuk6fG/LcAJqgk/5T8NhnV4a33qv3C58SKnb+0/XnQO
1Vxd4L/U+5Ihm1PzP9POz6b/p8u/SPSteEC/9z/Fs/ssdZy6Pw/Fi3pHofw/
R0bQ4cPC2j9L6fbywL4AQMk+JISDwuY/9Q+2BHwIA0D5oaxd63bwPweiM2vG
hwVAC9xAHTw29T+HFWovrd8HQFu3zzqv3fk/vhTj3hkuCkBuB1sqO+r+P/GA
g/YFsQxAfwfwHjfQAUCRRCcGgQsPQKjFsBHdXQRAmlTynQTOEEBw1G4zlN8G
QCJzXSG4EhJA974p5x42CUCjoywXS0QTQN/j4gM2vwtA+q57CMqSFECF5Jiy
IB0OQGAutNQszRVA5RomSI43EEBIV3yfcAEXQLngfmvSeRFAO0fJ8ZhMGEBs
FNZXgKYSQGun/0XAehlAT2WseHTsE0CF2aosNrcaQBIkgWLSHBVASvL1URHS
G0Aki9TjOEcWQOIiBOKg2hxAZg+nmeWKF0CuhqhBcusdQIcBeBj8uBhAFyy4
dMFPH0DaEMjLWAAaQHffh9ZpSiBAfMiWFr5BG0BJO+97HOsgQP3tYyqNbRxA
CM7VBQSBIUCvMLByorIdQGLv+6mOIyJAQeH6gyHiHkCrR6EyTrsiQBEdYpbU
BSBAG/QFBxJQI0AZWAaFO6cgQCMvqvV48SNAEcopWNc9IUAboc3IFIgkQKHK
jEUW4SFAq6EwtlMrJUBZH69+WYEiQGP2Uu+WyyVAAatQnNEWI0ALgvQMD2Em
QEHFMdTsuCNAS5zVRCoDJ0BxFpLwPFAkQHvtNWF6midAOfYxJzD0JEBDzdWX
bT4oQCkqkaknlSVAMwE1GmXfKEAIlW8QVCsmQBJsE4GRdSlAgI6NkSPOJkCK
ZTECYRgqQOe+KvcnZidA8ZXOZ2WwKkCNV8P1//8nQJcuZ2Y9SitALwmyqA==

                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                    Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 12.}, {-2.3445187695684826`, 
                    13.644999694915255`}}, PlotRangeClipping -> True, 
                    PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                   GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                 GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False,
                  GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                 BaselinePosition -> {1, 1}], True -> GridBox[{{
                   PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquareMinusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                   GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAGa+G6///F8AEPYEOk8ECwLHNhJqG
0xbAOppvSOyJAcAYzwMVx40VwIC0Y+UGNgDAoWKExp1dFMCbPA++huz9v9lN
huBrMxPATRVP/+Rz+7/hGwnG8+8RwAHZZZCkvfi/CXyN4hHCEMBFukjVMyz2
vwN+JZXT9Q7AaLVAkHFW879UszI2cnMMwPQWO6i8fPC/5wxDRT0cCsD8lZs0
BIHrvxksVet7kgfAYnVUK05c5b+Mb2r/5jMFwDpdPf02wd6/YGKC5EDhAsA0
h5/BEXTSv9ManGAOXADA5qUmemthsb8O73GVEAT8vzRFKI5cRMM/tDOvl+vq
9r9R+X/uwLzZPxzX8Tuk6fG/LcAJqgk/5T8NhnV4a33qv3C58SKnb+0/XnQO
1Vxd4L/U+5Ihm1PzP9POz6b/p8u/SPSteEC/9z/Fs/ssdZy6Pw/Fi3pHofw/
R0bQ4cPC2j9L6fbywL4AQMk+JISDwuY/9Q+2BHwIA0D5oaxd63bwPweiM2vG
hwVAC9xAHTw29T+HFWovrd8HQFu3zzqv3fk/vhTj3hkuCkBuB1sqO+r+P/GA
g/YFsQxAfwfwHjfQAUCRRCcGgQsPQKjFsBHdXQRAmlTynQTOEEBw1G4zlN8G
QCJzXSG4EhJA974p5x42CUCjoywXS0QTQN/j4gM2vwtA+q57CMqSFECF5Jiy
IB0OQGAutNQszRVA5RomSI43EEBIV3yfcAEXQLngfmvSeRFAO0fJ8ZhMGEBs
FNZXgKYSQGun/0XAehlAT2WseHTsE0CF2aosNrcaQBIkgWLSHBVASvL1URHS
G0Aki9TjOEcWQOIiBOKg2hxAZg+nmeWKF0CuhqhBcusdQIcBeBj8uBhAFyy4
dMFPH0DaEMjLWAAaQHffh9ZpSiBAfMiWFr5BG0BJO+97HOsgQP3tYyqNbRxA
CM7VBQSBIUCvMLByorIdQGLv+6mOIyJAQeH6gyHiHkCrR6EyTrsiQBEdYpbU
BSBAG/QFBxJQI0AZWAaFO6cgQCMvqvV48SNAEcopWNc9IUAboc3IFIgkQKHK
jEUW4SFAq6EwtlMrJUBZH69+WYEiQGP2Uu+WyyVAAatQnNEWI0ALgvQMD2Em
QEHFMdTsuCNAS5zVRCoDJ0BxFpLwPFAkQHvtNWF6midAOfYxJzD0JEBDzdWX
bT4oQCkqkaknlSVAMwE1GmXfKEAIlW8QVCsmQBJsE4GRdSlAgI6NkSPOJkCK
ZTECYRgqQOe+KvcnZidA8ZXOZ2WwKkCNV8P1//8nQJcuZ2Y9SitALwmyqA==

                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                    Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 12.}, {-2.3445187695684826`, 
                    13.644999694915255`}}, PlotRangeClipping -> True, 
                    PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                   GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["3", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["False", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                 GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False,
                  GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                 BaselinePosition -> {1, 1}]}, 
              Dynamic[Typeset`open$$], ImageSize -> Automatic], 
             BaselinePosition -> Baseline], DynamicModuleValues :> {}], 
           StyleBox["]", "NonInterpretableSummary"]}]},
        "CopyTag",
        DisplayFunction->(#& ),
        InterpretationFunction->("InterpolatingFunction[{{-6., 12.}}, <>]"& )],
       False,
       Editable->False,
       SelectWithContents->True,
       Selectable->False], "[", "x", "]"}]}], "]"}]}]}]], "Output",
 CellChangeTimes->{3.6723975263250704`*^9, 3.6724014204215307`*^9, 
  3.672402635264003*^9, 3.672403555918059*^9, 3.67240452433189*^9, 
  3.672572772194041*^9},ExpressionUUID->"f6f421d6-98ea-45ce-b80d-\
3a72a12796b3"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "4"], " ", 
  RowBox[{"(", 
   RowBox[{"4", "+", 
    RowBox[{
     FractionBox["1", "th"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", 
             FractionBox["1", "4"]}], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"th", "+", "x", "-", 
               RowBox[{"2", " ", 
                RowBox[{
                 TagBox[
                  TemplateBox[{
                    RowBox[{
                    StyleBox[
                    TagBox["InterpolatingFunction", "SummaryHead"], 
                    "NonInterpretableSummary"], 
                    StyleBox["[", "NonInterpretableSummary"], 
                    DynamicModuleBox[{Typeset`open$$ = False}, 
                    PanelBox[
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquarePlusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJxFzn9Q02UABvCN/XKKaxM2YWwTHPJ10zOFmtTQvURGZgR5dE5xxq3DvEBo
BIRJBAjjSMad2JR2lEIeVHA3Ey+XZ3tfRyhJwmIrLoqDTScnA4ELhrxfdNk/
3/3x3HOfv54nTl+0Py+MRqOlPMv/HW01+oPB9WhbXGN/we616Ie7tRajS4Q2
0y3TsdJwFDXEEN42CZH14Tev1vtWozZ97a2vdJFoIYG+7fEvXPRXhnEiPykC
hQvyUn3dq5Anhnvr31kBemXfeJqwmoO4FSavwMFHs5ayUW4hGzEqN5ldizyU
JWfdtbzBQtk9iarij8LR34TQG/EiE02Gp+3ZJVmNjhGS5BU1A0Vvfcd/spmD
bvKqco+pw1Bj0QfBB0ks5Ot1bEA5dJSrr7kPPGHopOGtbnszDbnErbm8wzS0
d8DMZbcHIW/WYOYzV+DVJRXRWvAUXk2ynvdPBSAnMdMVc+gJlIzMqy89nIeJ
1wJ8RcMKXGssLc//dAraL/RkNARIeKSE98dh3QRkqMSNe2tI6Boc6gh2DkD5
o/rj4AUS9vWQW0tbr2uGuTeIqiUM019zenodoxrmzRMzzt8w/HV3fO0pxwON
kXYo/Ucrhstt3Tp/2Zwmsv16eVsLhmv+AdIU1aImLPNsqqwBw5xrQy9bx5Y1
zxcHamorMSzk5CjVU081pbjL4fwYw884c7KdTjpI+KRw8GwZht/2XRaM6ZhA
dPv9bG0Fhh+6C5O+GGeDLnmLzHYawyW7YlKm4oKL/HebHl3CcPyel6GCa4By
YbP4xrN/dfdbrsRKeaBk7usZA8bQJ054vWknHzTNa3UNBAl/mqjMHz4hACyL
Ilq8j4QFkX8eqOpYB5hvdtiCWSTMzOsuL5mOACPO5SH2FhKui6/WD0uEwJvs
+pl0Yxh/2n0vOV0EFo7YH1/IwPDoc51f+j5fD2RjrIuJNcuwnl4etWKLAmnf
0wzCHAxH+f0DWpoY7LfJ6vxvY1jRf05kT42h/GTmPaXpuISydfvl4vYrUsqp
HnwqziujLJDqz7lZsZSjtew6dWfIgjsK7ciuOMptdxr3iDwhH9xgrTxYvZEy
vSur9XeRPLTXt8M9bQvZIGqeS8mKp/xSYAexfSFkhfLMd4R5E+VV5iJ+9pYE
ylVNpjPywZAn7col4ihB2XSgdzEYDPk/F+PlOQ==
                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, -3.9000000000000004`}, DisplayFunction :> 
                    Identity, Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {"DefaultBoundaryStyle" -> Automatic, 
                    "DefaultMeshStyle" -> AbsolutePointSize[6], 
                    "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 
                    12.}, {-3.6554809253467715`, -1.5942865610975967`}}, 
                    PlotRangeClipping -> True, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquareMinusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJxFzn9Q02UABvCN/XKKaxM2YWwTHPJ10zOFmtTQvURGZgR5dE5xxq3DvEBo
BIRJBAjjSMad2JR2lEIeVHA3Ey+XZ3tfRyhJwmIrLoqDTScnA4ELhrxfdNk/
3/3x3HOfv54nTl+0Py+MRqOlPMv/HW01+oPB9WhbXGN/we616Ie7tRajS4Q2
0y3TsdJwFDXEEN42CZH14Tev1vtWozZ97a2vdJFoIYG+7fEvXPRXhnEiPykC
hQvyUn3dq5Anhnvr31kBemXfeJqwmoO4FSavwMFHs5ayUW4hGzEqN5ldizyU
JWfdtbzBQtk9iarij8LR34TQG/EiE02Gp+3ZJVmNjhGS5BU1A0Vvfcd/spmD
bvKqco+pw1Bj0QfBB0ks5Ot1bEA5dJSrr7kPPGHopOGtbnszDbnErbm8wzS0
d8DMZbcHIW/WYOYzV+DVJRXRWvAUXk2ynvdPBSAnMdMVc+gJlIzMqy89nIeJ
1wJ8RcMKXGssLc//dAraL/RkNARIeKSE98dh3QRkqMSNe2tI6Boc6gh2DkD5
o/rj4AUS9vWQW0tbr2uGuTeIqiUM019zenodoxrmzRMzzt8w/HV3fO0pxwON
kXYo/Ucrhstt3Tp/2Zwmsv16eVsLhmv+AdIU1aImLPNsqqwBw5xrQy9bx5Y1
zxcHamorMSzk5CjVU081pbjL4fwYw884c7KdTjpI+KRw8GwZht/2XRaM6ZhA
dPv9bG0Fhh+6C5O+GGeDLnmLzHYawyW7YlKm4oKL/HebHl3CcPyel6GCa4By
YbP4xrN/dfdbrsRKeaBk7usZA8bQJ054vWknHzTNa3UNBAl/mqjMHz4hACyL
Ilq8j4QFkX8eqOpYB5hvdtiCWSTMzOsuL5mOACPO5SH2FhKui6/WD0uEwJvs
+pl0Yxh/2n0vOV0EFo7YH1/IwPDoc51f+j5fD2RjrIuJNcuwnl4etWKLAmnf
0wzCHAxH+f0DWpoY7LfJ6vxvY1jRf05kT42h/GTmPaXpuISydfvl4vYrUsqp
HnwqziujLJDqz7lZsZSjtew6dWfIgjsK7ciuOMptdxr3iDwhH9xgrTxYvZEy
vSur9XeRPLTXt8M9bQvZIGqeS8mKp/xSYAexfSFkhfLMd4R5E+VV5iJ+9pYE
ylVNpjPywZAn7col4ihB2XSgdzEYDPk/F+PlOQ==
                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, -3.9000000000000004`}, DisplayFunction :> 
                    Identity, Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {"DefaultBoundaryStyle" -> Automatic, 
                    "DefaultMeshStyle" -> AbsolutePointSize[6], 
                    "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 
                    12.}, {-3.6554809253467715`, -1.5942865610975967`}}, 
                    PlotRangeClipping -> True, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["3", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["False", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic], 
                    BaselinePosition -> Baseline], DynamicModuleValues :> {}], 
                    StyleBox["]", "NonInterpretableSummary"]}]},
                   "CopyTag",
                   DisplayFunction->(#& ),
                   
                   InterpretationFunction->(
                    "InterpolatingFunction[{{-6., 12.}}, <>]"& )],
                  False,
                  Editable->False,
                  SelectWithContents->True,
                  Selectable->False], "[", "x", "]"}]}]}], ")"}], "2"]}]]}], 
         SqrtBox["\[Pi]"]]}], "+", 
       FractionBox[
        RowBox[{"2", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", 
            FractionBox["1", "4"]}], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"th", "-", "x", "+", 
              RowBox[{"2", " ", 
               RowBox[{
                TagBox[
                 TemplateBox[{
                   RowBox[{
                    StyleBox[
                    TagBox["InterpolatingFunction", "SummaryHead"], 
                    "NonInterpretableSummary"], 
                    StyleBox["[", "NonInterpretableSummary"], 
                    DynamicModuleBox[{Typeset`open$$ = False}, 
                    PanelBox[
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquarePlusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJxFzn9Q02UABvCN/XKKaxM2YWwTHPJ10zOFmtTQvURGZgR5dE5xxq3DvEBo
BIRJBAjjSMad2JR2lEIeVHA3Ey+XZ3tfRyhJwmIrLoqDTScnA4ELhrxfdNk/
3/3x3HOfv54nTl+0Py+MRqOlPMv/HW01+oPB9WhbXGN/we616Ie7tRajS4Q2
0y3TsdJwFDXEEN42CZH14Tev1vtWozZ97a2vdJFoIYG+7fEvXPRXhnEiPykC
hQvyUn3dq5Anhnvr31kBemXfeJqwmoO4FSavwMFHs5ayUW4hGzEqN5ldizyU
JWfdtbzBQtk9iarij8LR34TQG/EiE02Gp+3ZJVmNjhGS5BU1A0Vvfcd/spmD
bvKqco+pw1Bj0QfBB0ks5Ot1bEA5dJSrr7kPPGHopOGtbnszDbnErbm8wzS0
d8DMZbcHIW/WYOYzV+DVJRXRWvAUXk2ynvdPBSAnMdMVc+gJlIzMqy89nIeJ
1wJ8RcMKXGssLc//dAraL/RkNARIeKSE98dh3QRkqMSNe2tI6Boc6gh2DkD5
o/rj4AUS9vWQW0tbr2uGuTeIqiUM019zenodoxrmzRMzzt8w/HV3fO0pxwON
kXYo/Ucrhstt3Tp/2Zwmsv16eVsLhmv+AdIU1aImLPNsqqwBw5xrQy9bx5Y1
zxcHamorMSzk5CjVU081pbjL4fwYw884c7KdTjpI+KRw8GwZht/2XRaM6ZhA
dPv9bG0Fhh+6C5O+GGeDLnmLzHYawyW7YlKm4oKL/HebHl3CcPyel6GCa4By
YbP4xrN/dfdbrsRKeaBk7usZA8bQJ054vWknHzTNa3UNBAl/mqjMHz4hACyL
Ilq8j4QFkX8eqOpYB5hvdtiCWSTMzOsuL5mOACPO5SH2FhKui6/WD0uEwJvs
+pl0Yxh/2n0vOV0EFo7YH1/IwPDoc51f+j5fD2RjrIuJNcuwnl4etWKLAmnf
0wzCHAxH+f0DWpoY7LfJ6vxvY1jRf05kT42h/GTmPaXpuISydfvl4vYrUsqp
HnwqziujLJDqz7lZsZSjtew6dWfIgjsK7ciuOMptdxr3iDwhH9xgrTxYvZEy
vSur9XeRPLTXt8M9bQvZIGqeS8mKp/xSYAexfSFkhfLMd4R5E+VV5iJ+9pYE
ylVNpjPywZAn7col4ihB2XSgdzEYDPk/F+PlOQ==
                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, -3.9000000000000004`}, DisplayFunction :> 
                    Identity, Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {"DefaultBoundaryStyle" -> Automatic, 
                    "DefaultMeshStyle" -> AbsolutePointSize[6], 
                    "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 
                    12.}, {-3.6554809253467715`, -1.5942865610975967`}}, 
                    PlotRangeClipping -> True, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquareMinusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJxFzn9Q02UABvCN/XKKaxM2YWwTHPJ10zOFmtTQvURGZgR5dE5xxq3DvEBo
BIRJBAjjSMad2JR2lEIeVHA3Ey+XZ3tfRyhJwmIrLoqDTScnA4ELhrxfdNk/
3/3x3HOfv54nTl+0Py+MRqOlPMv/HW01+oPB9WhbXGN/we616Ie7tRajS4Q2
0y3TsdJwFDXEEN42CZH14Tev1vtWozZ97a2vdJFoIYG+7fEvXPRXhnEiPykC
hQvyUn3dq5Anhnvr31kBemXfeJqwmoO4FSavwMFHs5ayUW4hGzEqN5ldizyU
JWfdtbzBQtk9iarij8LR34TQG/EiE02Gp+3ZJVmNjhGS5BU1A0Vvfcd/spmD
bvKqco+pw1Bj0QfBB0ks5Ot1bEA5dJSrr7kPPGHopOGtbnszDbnErbm8wzS0
d8DMZbcHIW/WYOYzV+DVJRXRWvAUXk2ynvdPBSAnMdMVc+gJlIzMqy89nIeJ
1wJ8RcMKXGssLc//dAraL/RkNARIeKSE98dh3QRkqMSNe2tI6Boc6gh2DkD5
o/rj4AUS9vWQW0tbr2uGuTeIqiUM019zenodoxrmzRMzzt8w/HV3fO0pxwON
kXYo/Ucrhstt3Tp/2Zwmsv16eVsLhmv+AdIU1aImLPNsqqwBw5xrQy9bx5Y1
zxcHamorMSzk5CjVU081pbjL4fwYw884c7KdTjpI+KRw8GwZht/2XRaM6ZhA
dPv9bG0Fhh+6C5O+GGeDLnmLzHYawyW7YlKm4oKL/HebHl3CcPyel6GCa4By
YbP4xrN/dfdbrsRKeaBk7usZA8bQJ054vWknHzTNa3UNBAl/mqjMHz4hACyL
Ilq8j4QFkX8eqOpYB5hvdtiCWSTMzOsuL5mOACPO5SH2FhKui6/WD0uEwJvs
+pl0Yxh/2n0vOV0EFo7YH1/IwPDoc51f+j5fD2RjrIuJNcuwnl4etWKLAmnf
0wzCHAxH+f0DWpoY7LfJ6vxvY1jRf05kT42h/GTmPaXpuISydfvl4vYrUsqp
HnwqziujLJDqz7lZsZSjtew6dWfIgjsK7ciuOMptdxr3iDwhH9xgrTxYvZEy
vSur9XeRPLTXt8M9bQvZIGqeS8mKp/xSYAexfSFkhfLMd4R5E+VV5iJ+9pYE
ylVNpjPywZAn7col4ihB2XSgdzEYDPk/F+PlOQ==
                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, -3.9000000000000004`}, DisplayFunction :> 
                    Identity, Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {"DefaultBoundaryStyle" -> Automatic, 
                    "DefaultMeshStyle" -> AbsolutePointSize[6], 
                    "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 
                    12.}, {-3.6554809253467715`, -1.5942865610975967`}}, 
                    PlotRangeClipping -> True, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["3", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["False", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic], 
                    BaselinePosition -> Baseline], DynamicModuleValues :> {}], 
                    StyleBox["]", "NonInterpretableSummary"]}]},
                  "CopyTag",
                  DisplayFunction->(#& ),
                  
                  InterpretationFunction->(
                   "InterpolatingFunction[{{-6., 12.}}, <>]"& )],
                 False,
                 Editable->False,
                 SelectWithContents->True,
                 Selectable->False], "[", "x", "]"}]}]}], ")"}], "2"]}]]}], 
        SqrtBox["\[Pi]"]], "+", 
       RowBox[{
        RowBox[{"Erfc", "[", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"th", "+", "x", "-", 
            RowBox[{"2", " ", 
             RowBox[{
              TagBox[
               TemplateBox[{
                 RowBox[{
                   StyleBox[
                    TagBox["InterpolatingFunction", "SummaryHead"], 
                    "NonInterpretableSummary"], 
                   StyleBox["[", "NonInterpretableSummary"], 
                   DynamicModuleBox[{Typeset`open$$ = False}, 
                    PanelBox[
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquarePlusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJxFzn9Q02UABvCN/XKKaxM2YWwTHPJ10zOFmtTQvURGZgR5dE5xxq3DvEBo
BIRJBAjjSMad2JR2lEIeVHA3Ey+XZ3tfRyhJwmIrLoqDTScnA4ELhrxfdNk/
3/3x3HOfv54nTl+0Py+MRqOlPMv/HW01+oPB9WhbXGN/we616Ie7tRajS4Q2
0y3TsdJwFDXEEN42CZH14Tev1vtWozZ97a2vdJFoIYG+7fEvXPRXhnEiPykC
hQvyUn3dq5Anhnvr31kBemXfeJqwmoO4FSavwMFHs5ayUW4hGzEqN5ldizyU
JWfdtbzBQtk9iarij8LR34TQG/EiE02Gp+3ZJVmNjhGS5BU1A0Vvfcd/spmD
bvKqco+pw1Bj0QfBB0ks5Ot1bEA5dJSrr7kPPGHopOGtbnszDbnErbm8wzS0
d8DMZbcHIW/WYOYzV+DVJRXRWvAUXk2ynvdPBSAnMdMVc+gJlIzMqy89nIeJ
1wJ8RcMKXGssLc//dAraL/RkNARIeKSE98dh3QRkqMSNe2tI6Boc6gh2DkD5
o/rj4AUS9vWQW0tbr2uGuTeIqiUM019zenodoxrmzRMzzt8w/HV3fO0pxwON
kXYo/Ucrhstt3Tp/2Zwmsv16eVsLhmv+AdIU1aImLPNsqqwBw5xrQy9bx5Y1
zxcHamorMSzk5CjVU081pbjL4fwYw884c7KdTjpI+KRw8GwZht/2XRaM6ZhA
dPv9bG0Fhh+6C5O+GGeDLnmLzHYawyW7YlKm4oKL/HebHl3CcPyel6GCa4By
YbP4xrN/dfdbrsRKeaBk7usZA8bQJ054vWknHzTNa3UNBAl/mqjMHz4hACyL
Ilq8j4QFkX8eqOpYB5hvdtiCWSTMzOsuL5mOACPO5SH2FhKui6/WD0uEwJvs
+pl0Yxh/2n0vOV0EFo7YH1/IwPDoc51f+j5fD2RjrIuJNcuwnl4etWKLAmnf
0wzCHAxH+f0DWpoY7LfJ6vxvY1jRf05kT42h/GTmPaXpuISydfvl4vYrUsqp
HnwqziujLJDqz7lZsZSjtew6dWfIgjsK7ciuOMptdxr3iDwhH9xgrTxYvZEy
vSur9XeRPLTXt8M9bQvZIGqeS8mKp/xSYAexfSFkhfLMd4R5E+VV5iJ+9pYE
ylVNpjPywZAn7col4ihB2XSgdzEYDPk/F+PlOQ==
                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, -3.9000000000000004`}, DisplayFunction :> 
                    Identity, Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 
                    12.}, {-3.6554809253467715`, -1.5942865610975967`}}, 
                    PlotRangeClipping -> True, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquareMinusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJxFzn9Q02UABvCN/XKKaxM2YWwTHPJ10zOFmtTQvURGZgR5dE5xxq3DvEBo
BIRJBAjjSMad2JR2lEIeVHA3Ey+XZ3tfRyhJwmIrLoqDTScnA4ELhrxfdNk/
3/3x3HOfv54nTl+0Py+MRqOlPMv/HW01+oPB9WhbXGN/we616Ie7tRajS4Q2
0y3TsdJwFDXEEN42CZH14Tev1vtWozZ97a2vdJFoIYG+7fEvXPRXhnEiPykC
hQvyUn3dq5Anhnvr31kBemXfeJqwmoO4FSavwMFHs5ayUW4hGzEqN5ldizyU
JWfdtbzBQtk9iarij8LR34TQG/EiE02Gp+3ZJVmNjhGS5BU1A0Vvfcd/spmD
bvKqco+pw1Bj0QfBB0ks5Ot1bEA5dJSrr7kPPGHopOGtbnszDbnErbm8wzS0
d8DMZbcHIW/WYOYzV+DVJRXRWvAUXk2ynvdPBSAnMdMVc+gJlIzMqy89nIeJ
1wJ8RcMKXGssLc//dAraL/RkNARIeKSE98dh3QRkqMSNe2tI6Boc6gh2DkD5
o/rj4AUS9vWQW0tbr2uGuTeIqiUM019zenodoxrmzRMzzt8w/HV3fO0pxwON
kXYo/Ucrhstt3Tp/2Zwmsv16eVsLhmv+AdIU1aImLPNsqqwBw5xrQy9bx5Y1
zxcHamorMSzk5CjVU081pbjL4fwYw884c7KdTjpI+KRw8GwZht/2XRaM6ZhA
dPv9bG0Fhh+6C5O+GGeDLnmLzHYawyW7YlKm4oKL/HebHl3CcPyel6GCa4By
YbP4xrN/dfdbrsRKeaBk7usZA8bQJ054vWknHzTNa3UNBAl/mqjMHz4hACyL
Ilq8j4QFkX8eqOpYB5hvdtiCWSTMzOsuL5mOACPO5SH2FhKui6/WD0uEwJvs
+pl0Yxh/2n0vOV0EFo7YH1/IwPDoc51f+j5fD2RjrIuJNcuwnl4etWKLAmnf
0wzCHAxH+f0DWpoY7LfJ6vxvY1jRf05kT42h/GTmPaXpuISydfvl4vYrUsqp
HnwqziujLJDqz7lZsZSjtew6dWfIgjsK7ciuOMptdxr3iDwhH9xgrTxYvZEy
vSur9XeRPLTXt8M9bQvZIGqeS8mKp/xSYAexfSFkhfLMd4R5E+VV5iJ+9pYE
ylVNpjPywZAn7col4ihB2XSgdzEYDPk/F+PlOQ==
                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, -3.9000000000000004`}, DisplayFunction :> 
                    Identity, Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 
                    12.}, {-3.6554809253467715`, -1.5942865610975967`}}, 
                    PlotRangeClipping -> True, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["3", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["False", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic], 
                    BaselinePosition -> Baseline], DynamicModuleValues :> {}], 
                   StyleBox["]", "NonInterpretableSummary"]}]},
                "CopyTag",
                DisplayFunction->(#& ),
                
                InterpretationFunction->(
                 "InterpolatingFunction[{{-6., 12.}}, <>]"& )],
               False,
               Editable->False,
               SelectWithContents->True,
               Selectable->False], "[", "x", "]"}]}]}], ")"}]}], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{"th", "+", "x", "-", 
          RowBox[{"2", " ", 
           RowBox[{
            TagBox[
             TemplateBox[{
               RowBox[{
                 StyleBox[
                  TagBox["InterpolatingFunction", "SummaryHead"], 
                  "NonInterpretableSummary"], 
                 StyleBox["[", "NonInterpretableSummary"], 
                 DynamicModuleBox[{Typeset`open$$ = False}, 
                  PanelBox[
                   PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquarePlusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJxFzn9Q02UABvCN/XKKaxM2YWwTHPJ10zOFmtTQvURGZgR5dE5xxq3DvEBo
BIRJBAjjSMad2JR2lEIeVHA3Ey+XZ3tfRyhJwmIrLoqDTScnA4ELhrxfdNk/
3/3x3HOfv54nTl+0Py+MRqOlPMv/HW01+oPB9WhbXGN/we616Ie7tRajS4Q2
0y3TsdJwFDXEEN42CZH14Tev1vtWozZ97a2vdJFoIYG+7fEvXPRXhnEiPykC
hQvyUn3dq5Anhnvr31kBemXfeJqwmoO4FSavwMFHs5ayUW4hGzEqN5ldizyU
JWfdtbzBQtk9iarij8LR34TQG/EiE02Gp+3ZJVmNjhGS5BU1A0Vvfcd/spmD
bvKqco+pw1Bj0QfBB0ks5Ot1bEA5dJSrr7kPPGHopOGtbnszDbnErbm8wzS0
d8DMZbcHIW/WYOYzV+DVJRXRWvAUXk2ynvdPBSAnMdMVc+gJlIzMqy89nIeJ
1wJ8RcMKXGssLc//dAraL/RkNARIeKSE98dh3QRkqMSNe2tI6Boc6gh2DkD5
o/rj4AUS9vWQW0tbr2uGuTeIqiUM019zenodoxrmzRMzzt8w/HV3fO0pxwON
kXYo/Ucrhstt3Tp/2Zwmsv16eVsLhmv+AdIU1aImLPNsqqwBw5xrQy9bx5Y1
zxcHamorMSzk5CjVU081pbjL4fwYw884c7KdTjpI+KRw8GwZht/2XRaM6ZhA
dPv9bG0Fhh+6C5O+GGeDLnmLzHYawyW7YlKm4oKL/HebHl3CcPyel6GCa4By
YbP4xrN/dfdbrsRKeaBk7usZA8bQJ054vWknHzTNa3UNBAl/mqjMHz4hACyL
Ilq8j4QFkX8eqOpYB5hvdtiCWSTMzOsuL5mOACPO5SH2FhKui6/WD0uEwJvs
+pl0Yxh/2n0vOV0EFo7YH1/IwPDoc51f+j5fD2RjrIuJNcuwnl4etWKLAmnf
0wzCHAxH+f0DWpoY7LfJ6vxvY1jRf05kT42h/GTmPaXpuISydfvl4vYrUsqp
HnwqziujLJDqz7lZsZSjtew6dWfIgjsK7ciuOMptdxr3iDwhH9xgrTxYvZEy
vSur9XeRPLTXt8M9bQvZIGqeS8mKp/xSYAexfSFkhfLMd4R5E+VV5iJ+9pYE
ylVNpjPywZAn7col4ihB2XSgdzEYDPk/F+PlOQ==
                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, -3.9000000000000004`}, DisplayFunction :> 
                    Identity, Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 
                    12.}, {-3.6554809253467715`, -1.5942865610975967`}}, 
                    PlotRangeClipping -> True, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquareMinusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJxFzn9Q02UABvCN/XKKaxM2YWwTHPJ10zOFmtTQvURGZgR5dE5xxq3DvEBo
BIRJBAjjSMad2JR2lEIeVHA3Ey+XZ3tfRyhJwmIrLoqDTScnA4ELhrxfdNk/
3/3x3HOfv54nTl+0Py+MRqOlPMv/HW01+oPB9WhbXGN/we616Ie7tRajS4Q2
0y3TsdJwFDXEEN42CZH14Tev1vtWozZ97a2vdJFoIYG+7fEvXPRXhnEiPykC
hQvyUn3dq5Anhnvr31kBemXfeJqwmoO4FSavwMFHs5ayUW4hGzEqN5ldizyU
JWfdtbzBQtk9iarij8LR34TQG/EiE02Gp+3ZJVmNjhGS5BU1A0Vvfcd/spmD
bvKqco+pw1Bj0QfBB0ks5Ot1bEA5dJSrr7kPPGHopOGtbnszDbnErbm8wzS0
d8DMZbcHIW/WYOYzV+DVJRXRWvAUXk2ynvdPBSAnMdMVc+gJlIzMqy89nIeJ
1wJ8RcMKXGssLc//dAraL/RkNARIeKSE98dh3QRkqMSNe2tI6Boc6gh2DkD5
o/rj4AUS9vWQW0tbr2uGuTeIqiUM019zenodoxrmzRMzzt8w/HV3fO0pxwON
kXYo/Ucrhstt3Tp/2Zwmsv16eVsLhmv+AdIU1aImLPNsqqwBw5xrQy9bx5Y1
zxcHamorMSzk5CjVU081pbjL4fwYw884c7KdTjpI+KRw8GwZht/2XRaM6ZhA
dPv9bG0Fhh+6C5O+GGeDLnmLzHYawyW7YlKm4oKL/HebHl3CcPyel6GCa4By
YbP4xrN/dfdbrsRKeaBk7usZA8bQJ054vWknHzTNa3UNBAl/mqjMHz4hACyL
Ilq8j4QFkX8eqOpYB5hvdtiCWSTMzOsuL5mOACPO5SH2FhKui6/WD0uEwJvs
+pl0Yxh/2n0vOV0EFo7YH1/IwPDoc51f+j5fD2RjrIuJNcuwnl4etWKLAmnf
0wzCHAxH+f0DWpoY7LfJ6vxvY1jRf05kT42h/GTmPaXpuISydfvl4vYrUsqp
HnwqziujLJDqz7lZsZSjtew6dWfIgjsK7ciuOMptdxr3iDwhH9xgrTxYvZEy
vSur9XeRPLTXt8M9bQvZIGqeS8mKp/xSYAexfSFkhfLMd4R5E+VV5iJ+9pYE
ylVNpjPywZAn7col4ihB2XSgdzEYDPk/F+PlOQ==
                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, -3.9000000000000004`}, DisplayFunction :> 
                    Identity, Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 
                    12.}, {-3.6554809253467715`, -1.5942865610975967`}}, 
                    PlotRangeClipping -> True, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["3", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["False", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic], 
                   BaselinePosition -> Baseline], DynamicModuleValues :> {}], 
                 StyleBox["]", "NonInterpretableSummary"]}]},
              "CopyTag",
              DisplayFunction->(#& ),
              
              InterpretationFunction->(
               "InterpolatingFunction[{{-6., 12.}}, <>]"& )],
             False,
             Editable->False,
             SelectWithContents->True,
             Selectable->False], "[", "x", "]"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"Erfc", "[", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "th"}], "+", "x", "-", 
            RowBox[{"2", " ", 
             RowBox[{
              TagBox[
               TemplateBox[{
                 RowBox[{
                   StyleBox[
                    TagBox["InterpolatingFunction", "SummaryHead"], 
                    "NonInterpretableSummary"], 
                   StyleBox["[", "NonInterpretableSummary"], 
                   DynamicModuleBox[{Typeset`open$$ = False}, 
                    PanelBox[
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquarePlusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJxFzn9Q02UABvCN/XKKaxM2YWwTHPJ10zOFmtTQvURGZgR5dE5xxq3DvEBo
BIRJBAjjSMad2JR2lEIeVHA3Ey+XZ3tfRyhJwmIrLoqDTScnA4ELhrxfdNk/
3/3x3HOfv54nTl+0Py+MRqOlPMv/HW01+oPB9WhbXGN/we616Ie7tRajS4Q2
0y3TsdJwFDXEEN42CZH14Tev1vtWozZ97a2vdJFoIYG+7fEvXPRXhnEiPykC
hQvyUn3dq5Anhnvr31kBemXfeJqwmoO4FSavwMFHs5ayUW4hGzEqN5ldizyU
JWfdtbzBQtk9iarij8LR34TQG/EiE02Gp+3ZJVmNjhGS5BU1A0Vvfcd/spmD
bvKqco+pw1Bj0QfBB0ks5Ot1bEA5dJSrr7kPPGHopOGtbnszDbnErbm8wzS0
d8DMZbcHIW/WYOYzV+DVJRXRWvAUXk2ynvdPBSAnMdMVc+gJlIzMqy89nIeJ
1wJ8RcMKXGssLc//dAraL/RkNARIeKSE98dh3QRkqMSNe2tI6Boc6gh2DkD5
o/rj4AUS9vWQW0tbr2uGuTeIqiUM019zenodoxrmzRMzzt8w/HV3fO0pxwON
kXYo/Ucrhstt3Tp/2Zwmsv16eVsLhmv+AdIU1aImLPNsqqwBw5xrQy9bx5Y1
zxcHamorMSzk5CjVU081pbjL4fwYw884c7KdTjpI+KRw8GwZht/2XRaM6ZhA
dPv9bG0Fhh+6C5O+GGeDLnmLzHYawyW7YlKm4oKL/HebHl3CcPyel6GCa4By
YbP4xrN/dfdbrsRKeaBk7usZA8bQJ054vWknHzTNa3UNBAl/mqjMHz4hACyL
Ilq8j4QFkX8eqOpYB5hvdtiCWSTMzOsuL5mOACPO5SH2FhKui6/WD0uEwJvs
+pl0Yxh/2n0vOV0EFo7YH1/IwPDoc51f+j5fD2RjrIuJNcuwnl4etWKLAmnf
0wzCHAxH+f0DWpoY7LfJ6vxvY1jRf05kT42h/GTmPaXpuISydfvl4vYrUsqp
HnwqziujLJDqz7lZsZSjtew6dWfIgjsK7ciuOMptdxr3iDwhH9xgrTxYvZEy
vSur9XeRPLTXt8M9bQvZIGqeS8mKp/xSYAexfSFkhfLMd4R5E+VV5iJ+9pYE
ylVNpjPywZAn7col4ihB2XSgdzEYDPk/F+PlOQ==
                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, -3.9000000000000004`}, DisplayFunction :> 
                    Identity, Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 
                    12.}, {-3.6554809253467715`, -1.5942865610975967`}}, 
                    PlotRangeClipping -> True, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquareMinusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJxFzn9Q02UABvCN/XKKaxM2YWwTHPJ10zOFmtTQvURGZgR5dE5xxq3DvEBo
BIRJBAjjSMad2JR2lEIeVHA3Ey+XZ3tfRyhJwmIrLoqDTScnA4ELhrxfdNk/
3/3x3HOfv54nTl+0Py+MRqOlPMv/HW01+oPB9WhbXGN/we616Ie7tRajS4Q2
0y3TsdJwFDXEEN42CZH14Tev1vtWozZ97a2vdJFoIYG+7fEvXPRXhnEiPykC
hQvyUn3dq5Anhnvr31kBemXfeJqwmoO4FSavwMFHs5ayUW4hGzEqN5ldizyU
JWfdtbzBQtk9iarij8LR34TQG/EiE02Gp+3ZJVmNjhGS5BU1A0Vvfcd/spmD
bvKqco+pw1Bj0QfBB0ks5Ot1bEA5dJSrr7kPPGHopOGtbnszDbnErbm8wzS0
d8DMZbcHIW/WYOYzV+DVJRXRWvAUXk2ynvdPBSAnMdMVc+gJlIzMqy89nIeJ
1wJ8RcMKXGssLc//dAraL/RkNARIeKSE98dh3QRkqMSNe2tI6Boc6gh2DkD5
o/rj4AUS9vWQW0tbr2uGuTeIqiUM019zenodoxrmzRMzzt8w/HV3fO0pxwON
kXYo/Ucrhstt3Tp/2Zwmsv16eVsLhmv+AdIU1aImLPNsqqwBw5xrQy9bx5Y1
zxcHamorMSzk5CjVU081pbjL4fwYw884c7KdTjpI+KRw8GwZht/2XRaM6ZhA
dPv9bG0Fhh+6C5O+GGeDLnmLzHYawyW7YlKm4oKL/HebHl3CcPyel6GCa4By
YbP4xrN/dfdbrsRKeaBk7usZA8bQJ054vWknHzTNa3UNBAl/mqjMHz4hACyL
Ilq8j4QFkX8eqOpYB5hvdtiCWSTMzOsuL5mOACPO5SH2FhKui6/WD0uEwJvs
+pl0Yxh/2n0vOV0EFo7YH1/IwPDoc51f+j5fD2RjrIuJNcuwnl4etWKLAmnf
0wzCHAxH+f0DWpoY7LfJ6vxvY1jRf05kT42h/GTmPaXpuISydfvl4vYrUsqp
HnwqziujLJDqz7lZsZSjtew6dWfIgjsK7ciuOMptdxr3iDwhH9xgrTxYvZEy
vSur9XeRPLTXt8M9bQvZIGqeS8mKp/xSYAexfSFkhfLMd4R5E+VV5iJ+9pYE
ylVNpjPywZAn7col4ihB2XSgdzEYDPk/F+PlOQ==
                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, -3.9000000000000004`}, DisplayFunction :> 
                    Identity, Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 
                    12.}, {-3.6554809253467715`, -1.5942865610975967`}}, 
                    PlotRangeClipping -> True, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["3", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["False", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic], 
                    BaselinePosition -> Baseline], DynamicModuleValues :> {}], 
                   StyleBox["]", "NonInterpretableSummary"]}]},
                "CopyTag",
                DisplayFunction->(#& ),
                InterpretationFunction->(
                 "InterpolatingFunction[{{-6., 12.}}, <>]"& )],
               False,
               Editable->False,
               SelectWithContents->True,
               Selectable->False], "[", "x", "]"}]}]}], ")"}]}], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{"th", "-", "x", "+", 
          RowBox[{"2", " ", 
           RowBox[{
            TagBox[
             TemplateBox[{
               RowBox[{
                 StyleBox[
                  TagBox["InterpolatingFunction", "SummaryHead"], 
                  "NonInterpretableSummary"], 
                 StyleBox["[", "NonInterpretableSummary"], 
                 DynamicModuleBox[{Typeset`open$$ = False}, 
                  PanelBox[
                   PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquarePlusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJxFzn9Q02UABvCN/XKKaxM2YWwTHPJ10zOFmtTQvURGZgR5dE5xxq3DvEBo
BIRJBAjjSMad2JR2lEIeVHA3Ey+XZ3tfRyhJwmIrLoqDTScnA4ELhrxfdNk/
3/3x3HOfv54nTl+0Py+MRqOlPMv/HW01+oPB9WhbXGN/we616Ie7tRajS4Q2
0y3TsdJwFDXEEN42CZH14Tev1vtWozZ97a2vdJFoIYG+7fEvXPRXhnEiPykC
hQvyUn3dq5Anhnvr31kBemXfeJqwmoO4FSavwMFHs5ayUW4hGzEqN5ldizyU
JWfdtbzBQtk9iarij8LR34TQG/EiE02Gp+3ZJVmNjhGS5BU1A0Vvfcd/spmD
bvKqco+pw1Bj0QfBB0ks5Ot1bEA5dJSrr7kPPGHopOGtbnszDbnErbm8wzS0
d8DMZbcHIW/WYOYzV+DVJRXRWvAUXk2ynvdPBSAnMdMVc+gJlIzMqy89nIeJ
1wJ8RcMKXGssLc//dAraL/RkNARIeKSE98dh3QRkqMSNe2tI6Boc6gh2DkD5
o/rj4AUS9vWQW0tbr2uGuTeIqiUM019zenodoxrmzRMzzt8w/HV3fO0pxwON
kXYo/Ucrhstt3Tp/2Zwmsv16eVsLhmv+AdIU1aImLPNsqqwBw5xrQy9bx5Y1
zxcHamorMSzk5CjVU081pbjL4fwYw884c7KdTjpI+KRw8GwZht/2XRaM6ZhA
dPv9bG0Fhh+6C5O+GGeDLnmLzHYawyW7YlKm4oKL/HebHl3CcPyel6GCa4By
YbP4xrN/dfdbrsRKeaBk7usZA8bQJ054vWknHzTNa3UNBAl/mqjMHz4hACyL
Ilq8j4QFkX8eqOpYB5hvdtiCWSTMzOsuL5mOACPO5SH2FhKui6/WD0uEwJvs
+pl0Yxh/2n0vOV0EFo7YH1/IwPDoc51f+j5fD2RjrIuJNcuwnl4etWKLAmnf
0wzCHAxH+f0DWpoY7LfJ6vxvY1jRf05kT42h/GTmPaXpuISydfvl4vYrUsqp
HnwqziujLJDqz7lZsZSjtew6dWfIgjsK7ciuOMptdxr3iDwhH9xgrTxYvZEy
vSur9XeRPLTXt8M9bQvZIGqeS8mKp/xSYAexfSFkhfLMd4R5E+VV5iJ+9pYE
ylVNpjPywZAn7col4ihB2XSgdzEYDPk/F+PlOQ==
                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, -3.9000000000000004`}, DisplayFunction :> 
                    Identity, Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 
                    12.}, {-3.6554809253467715`, -1.5942865610975967`}}, 
                    PlotRangeClipping -> True, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquareMinusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJxFzn9Q02UABvCN/XKKaxM2YWwTHPJ10zOFmtTQvURGZgR5dE5xxq3DvEBo
BIRJBAjjSMad2JR2lEIeVHA3Ey+XZ3tfRyhJwmIrLoqDTScnA4ELhrxfdNk/
3/3x3HOfv54nTl+0Py+MRqOlPMv/HW01+oPB9WhbXGN/we616Ie7tRajS4Q2
0y3TsdJwFDXEEN42CZH14Tev1vtWozZ97a2vdJFoIYG+7fEvXPRXhnEiPykC
hQvyUn3dq5Anhnvr31kBemXfeJqwmoO4FSavwMFHs5ayUW4hGzEqN5ldizyU
JWfdtbzBQtk9iarij8LR34TQG/EiE02Gp+3ZJVmNjhGS5BU1A0Vvfcd/spmD
bvKqco+pw1Bj0QfBB0ks5Ot1bEA5dJSrr7kPPGHopOGtbnszDbnErbm8wzS0
d8DMZbcHIW/WYOYzV+DVJRXRWvAUXk2ynvdPBSAnMdMVc+gJlIzMqy89nIeJ
1wJ8RcMKXGssLc//dAraL/RkNARIeKSE98dh3QRkqMSNe2tI6Boc6gh2DkD5
o/rj4AUS9vWQW0tbr2uGuTeIqiUM019zenodoxrmzRMzzt8w/HV3fO0pxwON
kXYo/Ucrhstt3Tp/2Zwmsv16eVsLhmv+AdIU1aImLPNsqqwBw5xrQy9bx5Y1
zxcHamorMSzk5CjVU081pbjL4fwYw884c7KdTjpI+KRw8GwZht/2XRaM6ZhA
dPv9bG0Fhh+6C5O+GGeDLnmLzHYawyW7YlKm4oKL/HebHl3CcPyel6GCa4By
YbP4xrN/dfdbrsRKeaBk7usZA8bQJ054vWknHzTNa3UNBAl/mqjMHz4hACyL
Ilq8j4QFkX8eqOpYB5hvdtiCWSTMzOsuL5mOACPO5SH2FhKui6/WD0uEwJvs
+pl0Yxh/2n0vOV0EFo7YH1/IwPDoc51f+j5fD2RjrIuJNcuwnl4etWKLAmnf
0wzCHAxH+f0DWpoY7LfJ6vxvY1jRf05kT42h/GTmPaXpuISydfvl4vYrUsqp
HnwqziujLJDqz7lZsZSjtew6dWfIgjsK7ciuOMptdxr3iDwhH9xgrTxYvZEy
vSur9XeRPLTXt8M9bQvZIGqeS8mKp/xSYAexfSFkhfLMd4R5E+VV5iJ+9pYE
ylVNpjPywZAn7col4ihB2XSgdzEYDPk/F+PlOQ==
                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, -3.9000000000000004`}, DisplayFunction :> 
                    Identity, Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 
                    12.}, {-3.6554809253467715`, -1.5942865610975967`}}, 
                    PlotRangeClipping -> True, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["3", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["False", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic], 
                   BaselinePosition -> Baseline], DynamicModuleValues :> {}], 
                 StyleBox["]", "NonInterpretableSummary"]}]},
              "CopyTag",
              DisplayFunction->(#& ),
              
              InterpretationFunction->(
               "InterpolatingFunction[{{-6., 12.}}, <>]"& )],
             False,
             Editable->False,
             SelectWithContents->True,
             Selectable->False], "[", "x", "]"}]}]}], ")"}]}]}], ")"}]}], "-", 
    RowBox[{
     FractionBox["1", "th"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", 
             FractionBox["1", "4"]}], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"th", "+", "x", "-", 
               RowBox[{"2", " ", 
                RowBox[{
                 TagBox[
                  TemplateBox[{
                    RowBox[{
                    StyleBox[
                    TagBox["InterpolatingFunction", "SummaryHead"], 
                    "NonInterpretableSummary"], 
                    StyleBox["[", "NonInterpretableSummary"], 
                    DynamicModuleBox[{Typeset`open$$ = False}, 
                    PanelBox[
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquarePlusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAGa+G6///F8AEPYEOk8ECwLHNhJqG
0xbAOppvSOyJAcAYzwMVx40VwIC0Y+UGNgDAoWKExp1dFMCbPA++huz9v9lN
huBrMxPATRVP/+Rz+7/hGwnG8+8RwAHZZZCkvfi/CXyN4hHCEMBFukjVMyz2
vwN+JZXT9Q7AaLVAkHFW879UszI2cnMMwPQWO6i8fPC/5wxDRT0cCsD8lZs0
BIHrvxksVet7kgfAYnVUK05c5b+Mb2r/5jMFwDpdPf02wd6/YGKC5EDhAsA0
h5/BEXTSv9ManGAOXADA5qUmemthsb8O73GVEAT8vzRFKI5cRMM/tDOvl+vq
9r9R+X/uwLzZPxzX8Tuk6fG/LcAJqgk/5T8NhnV4a33qv3C58SKnb+0/XnQO
1Vxd4L/U+5Ihm1PzP9POz6b/p8u/SPSteEC/9z/Fs/ssdZy6Pw/Fi3pHofw/
R0bQ4cPC2j9L6fbywL4AQMk+JISDwuY/9Q+2BHwIA0D5oaxd63bwPweiM2vG
hwVAC9xAHTw29T+HFWovrd8HQFu3zzqv3fk/vhTj3hkuCkBuB1sqO+r+P/GA
g/YFsQxAfwfwHjfQAUCRRCcGgQsPQKjFsBHdXQRAmlTynQTOEEBw1G4zlN8G
QCJzXSG4EhJA974p5x42CUCjoywXS0QTQN/j4gM2vwtA+q57CMqSFECF5Jiy
IB0OQGAutNQszRVA5RomSI43EEBIV3yfcAEXQLngfmvSeRFAO0fJ8ZhMGEBs
FNZXgKYSQGun/0XAehlAT2WseHTsE0CF2aosNrcaQBIkgWLSHBVASvL1URHS
G0Aki9TjOEcWQOIiBOKg2hxAZg+nmeWKF0CuhqhBcusdQIcBeBj8uBhAFyy4
dMFPH0DaEMjLWAAaQHffh9ZpSiBAfMiWFr5BG0BJO+97HOsgQP3tYyqNbRxA
CM7VBQSBIUCvMLByorIdQGLv+6mOIyJAQeH6gyHiHkCrR6EyTrsiQBEdYpbU
BSBAG/QFBxJQI0AZWAaFO6cgQCMvqvV48SNAEcopWNc9IUAboc3IFIgkQKHK
jEUW4SFAq6EwtlMrJUBZH69+WYEiQGP2Uu+WyyVAAatQnNEWI0ALgvQMD2Em
QEHFMdTsuCNAS5zVRCoDJ0BxFpLwPFAkQHvtNWF6midAOfYxJzD0JEBDzdWX
bT4oQCkqkaknlSVAMwE1GmXfKEAIlW8QVCsmQBJsE4GRdSlAgI6NkSPOJkCK
ZTECYRgqQOe+KvcnZidA8ZXOZ2WwKkCNV8P1//8nQJcuZ2Y9SitALwmyqA==

                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                    Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {"DefaultBoundaryStyle" -> Automatic, 
                    "DefaultMeshStyle" -> AbsolutePointSize[6], 
                    "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 12.}, {-2.3445187695684826`, 
                    13.644999694915255`}}, PlotRangeClipping -> True, 
                    PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquareMinusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAGa+G6///F8AEPYEOk8ECwLHNhJqG
0xbAOppvSOyJAcAYzwMVx40VwIC0Y+UGNgDAoWKExp1dFMCbPA++huz9v9lN
huBrMxPATRVP/+Rz+7/hGwnG8+8RwAHZZZCkvfi/CXyN4hHCEMBFukjVMyz2
vwN+JZXT9Q7AaLVAkHFW879UszI2cnMMwPQWO6i8fPC/5wxDRT0cCsD8lZs0
BIHrvxksVet7kgfAYnVUK05c5b+Mb2r/5jMFwDpdPf02wd6/YGKC5EDhAsA0
h5/BEXTSv9ManGAOXADA5qUmemthsb8O73GVEAT8vzRFKI5cRMM/tDOvl+vq
9r9R+X/uwLzZPxzX8Tuk6fG/LcAJqgk/5T8NhnV4a33qv3C58SKnb+0/XnQO
1Vxd4L/U+5Ihm1PzP9POz6b/p8u/SPSteEC/9z/Fs/ssdZy6Pw/Fi3pHofw/
R0bQ4cPC2j9L6fbywL4AQMk+JISDwuY/9Q+2BHwIA0D5oaxd63bwPweiM2vG
hwVAC9xAHTw29T+HFWovrd8HQFu3zzqv3fk/vhTj3hkuCkBuB1sqO+r+P/GA
g/YFsQxAfwfwHjfQAUCRRCcGgQsPQKjFsBHdXQRAmlTynQTOEEBw1G4zlN8G
QCJzXSG4EhJA974p5x42CUCjoywXS0QTQN/j4gM2vwtA+q57CMqSFECF5Jiy
IB0OQGAutNQszRVA5RomSI43EEBIV3yfcAEXQLngfmvSeRFAO0fJ8ZhMGEBs
FNZXgKYSQGun/0XAehlAT2WseHTsE0CF2aosNrcaQBIkgWLSHBVASvL1URHS
G0Aki9TjOEcWQOIiBOKg2hxAZg+nmeWKF0CuhqhBcusdQIcBeBj8uBhAFyy4
dMFPH0DaEMjLWAAaQHffh9ZpSiBAfMiWFr5BG0BJO+97HOsgQP3tYyqNbRxA
CM7VBQSBIUCvMLByorIdQGLv+6mOIyJAQeH6gyHiHkCrR6EyTrsiQBEdYpbU
BSBAG/QFBxJQI0AZWAaFO6cgQCMvqvV48SNAEcopWNc9IUAboc3IFIgkQKHK
jEUW4SFAq6EwtlMrJUBZH69+WYEiQGP2Uu+WyyVAAatQnNEWI0ALgvQMD2Em
QEHFMdTsuCNAS5zVRCoDJ0BxFpLwPFAkQHvtNWF6midAOfYxJzD0JEBDzdWX
bT4oQCkqkaknlSVAMwE1GmXfKEAIlW8QVCsmQBJsE4GRdSlAgI6NkSPOJkCK
ZTECYRgqQOe+KvcnZidA8ZXOZ2WwKkCNV8P1//8nQJcuZ2Y9SitALwmyqA==

                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                    Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {"DefaultBoundaryStyle" -> Automatic, 
                    "DefaultMeshStyle" -> AbsolutePointSize[6], 
                    "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 12.}, {-2.3445187695684826`, 
                    13.644999694915255`}}, PlotRangeClipping -> True, 
                    PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["3", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["False", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic], 
                    BaselinePosition -> Baseline], DynamicModuleValues :> {}], 
                    StyleBox["]", "NonInterpretableSummary"]}]},
                   "CopyTag",
                   DisplayFunction->(#& ),
                   
                   InterpretationFunction->(
                    "InterpolatingFunction[{{-6., 12.}}, <>]"& )],
                  False,
                  Editable->False,
                  SelectWithContents->True,
                  Selectable->False], "[", "x", "]"}]}]}], ")"}], "2"]}]]}], 
         SqrtBox["\[Pi]"]]}], "+", 
       FractionBox[
        RowBox[{"2", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", 
            FractionBox["1", "4"]}], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"th", "-", "x", "+", 
              RowBox[{"2", " ", 
               RowBox[{
                TagBox[
                 TemplateBox[{
                   RowBox[{
                    StyleBox[
                    TagBox["InterpolatingFunction", "SummaryHead"], 
                    "NonInterpretableSummary"], 
                    StyleBox["[", "NonInterpretableSummary"], 
                    DynamicModuleBox[{Typeset`open$$ = False}, 
                    PanelBox[
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquarePlusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAGa+G6///F8AEPYEOk8ECwLHNhJqG
0xbAOppvSOyJAcAYzwMVx40VwIC0Y+UGNgDAoWKExp1dFMCbPA++huz9v9lN
huBrMxPATRVP/+Rz+7/hGwnG8+8RwAHZZZCkvfi/CXyN4hHCEMBFukjVMyz2
vwN+JZXT9Q7AaLVAkHFW879UszI2cnMMwPQWO6i8fPC/5wxDRT0cCsD8lZs0
BIHrvxksVet7kgfAYnVUK05c5b+Mb2r/5jMFwDpdPf02wd6/YGKC5EDhAsA0
h5/BEXTSv9ManGAOXADA5qUmemthsb8O73GVEAT8vzRFKI5cRMM/tDOvl+vq
9r9R+X/uwLzZPxzX8Tuk6fG/LcAJqgk/5T8NhnV4a33qv3C58SKnb+0/XnQO
1Vxd4L/U+5Ihm1PzP9POz6b/p8u/SPSteEC/9z/Fs/ssdZy6Pw/Fi3pHofw/
R0bQ4cPC2j9L6fbywL4AQMk+JISDwuY/9Q+2BHwIA0D5oaxd63bwPweiM2vG
hwVAC9xAHTw29T+HFWovrd8HQFu3zzqv3fk/vhTj3hkuCkBuB1sqO+r+P/GA
g/YFsQxAfwfwHjfQAUCRRCcGgQsPQKjFsBHdXQRAmlTynQTOEEBw1G4zlN8G
QCJzXSG4EhJA974p5x42CUCjoywXS0QTQN/j4gM2vwtA+q57CMqSFECF5Jiy
IB0OQGAutNQszRVA5RomSI43EEBIV3yfcAEXQLngfmvSeRFAO0fJ8ZhMGEBs
FNZXgKYSQGun/0XAehlAT2WseHTsE0CF2aosNrcaQBIkgWLSHBVASvL1URHS
G0Aki9TjOEcWQOIiBOKg2hxAZg+nmeWKF0CuhqhBcusdQIcBeBj8uBhAFyy4
dMFPH0DaEMjLWAAaQHffh9ZpSiBAfMiWFr5BG0BJO+97HOsgQP3tYyqNbRxA
CM7VBQSBIUCvMLByorIdQGLv+6mOIyJAQeH6gyHiHkCrR6EyTrsiQBEdYpbU
BSBAG/QFBxJQI0AZWAaFO6cgQCMvqvV48SNAEcopWNc9IUAboc3IFIgkQKHK
jEUW4SFAq6EwtlMrJUBZH69+WYEiQGP2Uu+WyyVAAatQnNEWI0ALgvQMD2Em
QEHFMdTsuCNAS5zVRCoDJ0BxFpLwPFAkQHvtNWF6midAOfYxJzD0JEBDzdWX
bT4oQCkqkaknlSVAMwE1GmXfKEAIlW8QVCsmQBJsE4GRdSlAgI6NkSPOJkCK
ZTECYRgqQOe+KvcnZidA8ZXOZ2WwKkCNV8P1//8nQJcuZ2Y9SitALwmyqA==

                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                    Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {"DefaultBoundaryStyle" -> Automatic, 
                    "DefaultMeshStyle" -> AbsolutePointSize[6], 
                    "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 12.}, {-2.3445187695684826`, 
                    13.644999694915255`}}, PlotRangeClipping -> True, 
                    PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquareMinusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAGa+G6///F8AEPYEOk8ECwLHNhJqG
0xbAOppvSOyJAcAYzwMVx40VwIC0Y+UGNgDAoWKExp1dFMCbPA++huz9v9lN
huBrMxPATRVP/+Rz+7/hGwnG8+8RwAHZZZCkvfi/CXyN4hHCEMBFukjVMyz2
vwN+JZXT9Q7AaLVAkHFW879UszI2cnMMwPQWO6i8fPC/5wxDRT0cCsD8lZs0
BIHrvxksVet7kgfAYnVUK05c5b+Mb2r/5jMFwDpdPf02wd6/YGKC5EDhAsA0
h5/BEXTSv9ManGAOXADA5qUmemthsb8O73GVEAT8vzRFKI5cRMM/tDOvl+vq
9r9R+X/uwLzZPxzX8Tuk6fG/LcAJqgk/5T8NhnV4a33qv3C58SKnb+0/XnQO
1Vxd4L/U+5Ihm1PzP9POz6b/p8u/SPSteEC/9z/Fs/ssdZy6Pw/Fi3pHofw/
R0bQ4cPC2j9L6fbywL4AQMk+JISDwuY/9Q+2BHwIA0D5oaxd63bwPweiM2vG
hwVAC9xAHTw29T+HFWovrd8HQFu3zzqv3fk/vhTj3hkuCkBuB1sqO+r+P/GA
g/YFsQxAfwfwHjfQAUCRRCcGgQsPQKjFsBHdXQRAmlTynQTOEEBw1G4zlN8G
QCJzXSG4EhJA974p5x42CUCjoywXS0QTQN/j4gM2vwtA+q57CMqSFECF5Jiy
IB0OQGAutNQszRVA5RomSI43EEBIV3yfcAEXQLngfmvSeRFAO0fJ8ZhMGEBs
FNZXgKYSQGun/0XAehlAT2WseHTsE0CF2aosNrcaQBIkgWLSHBVASvL1URHS
G0Aki9TjOEcWQOIiBOKg2hxAZg+nmeWKF0CuhqhBcusdQIcBeBj8uBhAFyy4
dMFPH0DaEMjLWAAaQHffh9ZpSiBAfMiWFr5BG0BJO+97HOsgQP3tYyqNbRxA
CM7VBQSBIUCvMLByorIdQGLv+6mOIyJAQeH6gyHiHkCrR6EyTrsiQBEdYpbU
BSBAG/QFBxJQI0AZWAaFO6cgQCMvqvV48SNAEcopWNc9IUAboc3IFIgkQKHK
jEUW4SFAq6EwtlMrJUBZH69+WYEiQGP2Uu+WyyVAAatQnNEWI0ALgvQMD2Em
QEHFMdTsuCNAS5zVRCoDJ0BxFpLwPFAkQHvtNWF6midAOfYxJzD0JEBDzdWX
bT4oQCkqkaknlSVAMwE1GmXfKEAIlW8QVCsmQBJsE4GRdSlAgI6NkSPOJkCK
ZTECYRgqQOe+KvcnZidA8ZXOZ2WwKkCNV8P1//8nQJcuZ2Y9SitALwmyqA==

                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                    Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {"DefaultBoundaryStyle" -> Automatic, 
                    "DefaultMeshStyle" -> AbsolutePointSize[6], 
                    "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 12.}, {-2.3445187695684826`, 
                    13.644999694915255`}}, PlotRangeClipping -> True, 
                    PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["3", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["False", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic], 
                    BaselinePosition -> Baseline], DynamicModuleValues :> {}], 
                    StyleBox["]", "NonInterpretableSummary"]}]},
                  "CopyTag",
                  DisplayFunction->(#& ),
                  
                  InterpretationFunction->(
                   "InterpolatingFunction[{{-6., 12.}}, <>]"& )],
                 False,
                 Editable->False,
                 SelectWithContents->True,
                 Selectable->False], "[", "x", "]"}]}]}], ")"}], "2"]}]]}], 
        SqrtBox["\[Pi]"]], "+", 
       RowBox[{
        RowBox[{"Erfc", "[", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"th", "+", "x", "-", 
            RowBox[{"2", " ", 
             RowBox[{
              TagBox[
               TemplateBox[{
                 RowBox[{
                   StyleBox[
                    TagBox["InterpolatingFunction", "SummaryHead"], 
                    "NonInterpretableSummary"], 
                   StyleBox["[", "NonInterpretableSummary"], 
                   DynamicModuleBox[{Typeset`open$$ = False}, 
                    PanelBox[
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquarePlusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAGa+G6///F8AEPYEOk8ECwLHNhJqG
0xbAOppvSOyJAcAYzwMVx40VwIC0Y+UGNgDAoWKExp1dFMCbPA++huz9v9lN
huBrMxPATRVP/+Rz+7/hGwnG8+8RwAHZZZCkvfi/CXyN4hHCEMBFukjVMyz2
vwN+JZXT9Q7AaLVAkHFW879UszI2cnMMwPQWO6i8fPC/5wxDRT0cCsD8lZs0
BIHrvxksVet7kgfAYnVUK05c5b+Mb2r/5jMFwDpdPf02wd6/YGKC5EDhAsA0
h5/BEXTSv9ManGAOXADA5qUmemthsb8O73GVEAT8vzRFKI5cRMM/tDOvl+vq
9r9R+X/uwLzZPxzX8Tuk6fG/LcAJqgk/5T8NhnV4a33qv3C58SKnb+0/XnQO
1Vxd4L/U+5Ihm1PzP9POz6b/p8u/SPSteEC/9z/Fs/ssdZy6Pw/Fi3pHofw/
R0bQ4cPC2j9L6fbywL4AQMk+JISDwuY/9Q+2BHwIA0D5oaxd63bwPweiM2vG
hwVAC9xAHTw29T+HFWovrd8HQFu3zzqv3fk/vhTj3hkuCkBuB1sqO+r+P/GA
g/YFsQxAfwfwHjfQAUCRRCcGgQsPQKjFsBHdXQRAmlTynQTOEEBw1G4zlN8G
QCJzXSG4EhJA974p5x42CUCjoywXS0QTQN/j4gM2vwtA+q57CMqSFECF5Jiy
IB0OQGAutNQszRVA5RomSI43EEBIV3yfcAEXQLngfmvSeRFAO0fJ8ZhMGEBs
FNZXgKYSQGun/0XAehlAT2WseHTsE0CF2aosNrcaQBIkgWLSHBVASvL1URHS
G0Aki9TjOEcWQOIiBOKg2hxAZg+nmeWKF0CuhqhBcusdQIcBeBj8uBhAFyy4
dMFPH0DaEMjLWAAaQHffh9ZpSiBAfMiWFr5BG0BJO+97HOsgQP3tYyqNbRxA
CM7VBQSBIUCvMLByorIdQGLv+6mOIyJAQeH6gyHiHkCrR6EyTrsiQBEdYpbU
BSBAG/QFBxJQI0AZWAaFO6cgQCMvqvV48SNAEcopWNc9IUAboc3IFIgkQKHK
jEUW4SFAq6EwtlMrJUBZH69+WYEiQGP2Uu+WyyVAAatQnNEWI0ALgvQMD2Em
QEHFMdTsuCNAS5zVRCoDJ0BxFpLwPFAkQHvtNWF6midAOfYxJzD0JEBDzdWX
bT4oQCkqkaknlSVAMwE1GmXfKEAIlW8QVCsmQBJsE4GRdSlAgI6NkSPOJkCK
ZTECYRgqQOe+KvcnZidA8ZXOZ2WwKkCNV8P1//8nQJcuZ2Y9SitALwmyqA==

                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                    Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 12.}, {-2.3445187695684826`, 
                    13.644999694915255`}}, PlotRangeClipping -> True, 
                    PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquareMinusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAGa+G6///F8AEPYEOk8ECwLHNhJqG
0xbAOppvSOyJAcAYzwMVx40VwIC0Y+UGNgDAoWKExp1dFMCbPA++huz9v9lN
huBrMxPATRVP/+Rz+7/hGwnG8+8RwAHZZZCkvfi/CXyN4hHCEMBFukjVMyz2
vwN+JZXT9Q7AaLVAkHFW879UszI2cnMMwPQWO6i8fPC/5wxDRT0cCsD8lZs0
BIHrvxksVet7kgfAYnVUK05c5b+Mb2r/5jMFwDpdPf02wd6/YGKC5EDhAsA0
h5/BEXTSv9ManGAOXADA5qUmemthsb8O73GVEAT8vzRFKI5cRMM/tDOvl+vq
9r9R+X/uwLzZPxzX8Tuk6fG/LcAJqgk/5T8NhnV4a33qv3C58SKnb+0/XnQO
1Vxd4L/U+5Ihm1PzP9POz6b/p8u/SPSteEC/9z/Fs/ssdZy6Pw/Fi3pHofw/
R0bQ4cPC2j9L6fbywL4AQMk+JISDwuY/9Q+2BHwIA0D5oaxd63bwPweiM2vG
hwVAC9xAHTw29T+HFWovrd8HQFu3zzqv3fk/vhTj3hkuCkBuB1sqO+r+P/GA
g/YFsQxAfwfwHjfQAUCRRCcGgQsPQKjFsBHdXQRAmlTynQTOEEBw1G4zlN8G
QCJzXSG4EhJA974p5x42CUCjoywXS0QTQN/j4gM2vwtA+q57CMqSFECF5Jiy
IB0OQGAutNQszRVA5RomSI43EEBIV3yfcAEXQLngfmvSeRFAO0fJ8ZhMGEBs
FNZXgKYSQGun/0XAehlAT2WseHTsE0CF2aosNrcaQBIkgWLSHBVASvL1URHS
G0Aki9TjOEcWQOIiBOKg2hxAZg+nmeWKF0CuhqhBcusdQIcBeBj8uBhAFyy4
dMFPH0DaEMjLWAAaQHffh9ZpSiBAfMiWFr5BG0BJO+97HOsgQP3tYyqNbRxA
CM7VBQSBIUCvMLByorIdQGLv+6mOIyJAQeH6gyHiHkCrR6EyTrsiQBEdYpbU
BSBAG/QFBxJQI0AZWAaFO6cgQCMvqvV48SNAEcopWNc9IUAboc3IFIgkQKHK
jEUW4SFAq6EwtlMrJUBZH69+WYEiQGP2Uu+WyyVAAatQnNEWI0ALgvQMD2Em
QEHFMdTsuCNAS5zVRCoDJ0BxFpLwPFAkQHvtNWF6midAOfYxJzD0JEBDzdWX
bT4oQCkqkaknlSVAMwE1GmXfKEAIlW8QVCsmQBJsE4GRdSlAgI6NkSPOJkCK
ZTECYRgqQOe+KvcnZidA8ZXOZ2WwKkCNV8P1//8nQJcuZ2Y9SitALwmyqA==

                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                    Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 12.}, {-2.3445187695684826`, 
                    13.644999694915255`}}, PlotRangeClipping -> True, 
                    PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["3", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["False", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic], 
                    BaselinePosition -> Baseline], DynamicModuleValues :> {}], 
                   StyleBox["]", "NonInterpretableSummary"]}]},
                "CopyTag",
                DisplayFunction->(#& ),
                
                InterpretationFunction->(
                 "InterpolatingFunction[{{-6., 12.}}, <>]"& )],
               False,
               Editable->False,
               SelectWithContents->True,
               Selectable->False], "[", "x", "]"}]}]}], ")"}]}], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{"th", "+", "x", "-", 
          RowBox[{"2", " ", 
           RowBox[{
            TagBox[
             TemplateBox[{
               RowBox[{
                 StyleBox[
                  TagBox["InterpolatingFunction", "SummaryHead"], 
                  "NonInterpretableSummary"], 
                 StyleBox["[", "NonInterpretableSummary"], 
                 DynamicModuleBox[{Typeset`open$$ = False}, 
                  PanelBox[
                   PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquarePlusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAGa+G6///F8AEPYEOk8ECwLHNhJqG
0xbAOppvSOyJAcAYzwMVx40VwIC0Y+UGNgDAoWKExp1dFMCbPA++huz9v9lN
huBrMxPATRVP/+Rz+7/hGwnG8+8RwAHZZZCkvfi/CXyN4hHCEMBFukjVMyz2
vwN+JZXT9Q7AaLVAkHFW879UszI2cnMMwPQWO6i8fPC/5wxDRT0cCsD8lZs0
BIHrvxksVet7kgfAYnVUK05c5b+Mb2r/5jMFwDpdPf02wd6/YGKC5EDhAsA0
h5/BEXTSv9ManGAOXADA5qUmemthsb8O73GVEAT8vzRFKI5cRMM/tDOvl+vq
9r9R+X/uwLzZPxzX8Tuk6fG/LcAJqgk/5T8NhnV4a33qv3C58SKnb+0/XnQO
1Vxd4L/U+5Ihm1PzP9POz6b/p8u/SPSteEC/9z/Fs/ssdZy6Pw/Fi3pHofw/
R0bQ4cPC2j9L6fbywL4AQMk+JISDwuY/9Q+2BHwIA0D5oaxd63bwPweiM2vG
hwVAC9xAHTw29T+HFWovrd8HQFu3zzqv3fk/vhTj3hkuCkBuB1sqO+r+P/GA
g/YFsQxAfwfwHjfQAUCRRCcGgQsPQKjFsBHdXQRAmlTynQTOEEBw1G4zlN8G
QCJzXSG4EhJA974p5x42CUCjoywXS0QTQN/j4gM2vwtA+q57CMqSFECF5Jiy
IB0OQGAutNQszRVA5RomSI43EEBIV3yfcAEXQLngfmvSeRFAO0fJ8ZhMGEBs
FNZXgKYSQGun/0XAehlAT2WseHTsE0CF2aosNrcaQBIkgWLSHBVASvL1URHS
G0Aki9TjOEcWQOIiBOKg2hxAZg+nmeWKF0CuhqhBcusdQIcBeBj8uBhAFyy4
dMFPH0DaEMjLWAAaQHffh9ZpSiBAfMiWFr5BG0BJO+97HOsgQP3tYyqNbRxA
CM7VBQSBIUCvMLByorIdQGLv+6mOIyJAQeH6gyHiHkCrR6EyTrsiQBEdYpbU
BSBAG/QFBxJQI0AZWAaFO6cgQCMvqvV48SNAEcopWNc9IUAboc3IFIgkQKHK
jEUW4SFAq6EwtlMrJUBZH69+WYEiQGP2Uu+WyyVAAatQnNEWI0ALgvQMD2Em
QEHFMdTsuCNAS5zVRCoDJ0BxFpLwPFAkQHvtNWF6midAOfYxJzD0JEBDzdWX
bT4oQCkqkaknlSVAMwE1GmXfKEAIlW8QVCsmQBJsE4GRdSlAgI6NkSPOJkCK
ZTECYRgqQOe+KvcnZidA8ZXOZ2WwKkCNV8P1//8nQJcuZ2Y9SitALwmyqA==

                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                    Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 12.}, {-2.3445187695684826`, 
                    13.644999694915255`}}, PlotRangeClipping -> True, 
                    PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquareMinusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAGa+G6///F8AEPYEOk8ECwLHNhJqG
0xbAOppvSOyJAcAYzwMVx40VwIC0Y+UGNgDAoWKExp1dFMCbPA++huz9v9lN
huBrMxPATRVP/+Rz+7/hGwnG8+8RwAHZZZCkvfi/CXyN4hHCEMBFukjVMyz2
vwN+JZXT9Q7AaLVAkHFW879UszI2cnMMwPQWO6i8fPC/5wxDRT0cCsD8lZs0
BIHrvxksVet7kgfAYnVUK05c5b+Mb2r/5jMFwDpdPf02wd6/YGKC5EDhAsA0
h5/BEXTSv9ManGAOXADA5qUmemthsb8O73GVEAT8vzRFKI5cRMM/tDOvl+vq
9r9R+X/uwLzZPxzX8Tuk6fG/LcAJqgk/5T8NhnV4a33qv3C58SKnb+0/XnQO
1Vxd4L/U+5Ihm1PzP9POz6b/p8u/SPSteEC/9z/Fs/ssdZy6Pw/Fi3pHofw/
R0bQ4cPC2j9L6fbywL4AQMk+JISDwuY/9Q+2BHwIA0D5oaxd63bwPweiM2vG
hwVAC9xAHTw29T+HFWovrd8HQFu3zzqv3fk/vhTj3hkuCkBuB1sqO+r+P/GA
g/YFsQxAfwfwHjfQAUCRRCcGgQsPQKjFsBHdXQRAmlTynQTOEEBw1G4zlN8G
QCJzXSG4EhJA974p5x42CUCjoywXS0QTQN/j4gM2vwtA+q57CMqSFECF5Jiy
IB0OQGAutNQszRVA5RomSI43EEBIV3yfcAEXQLngfmvSeRFAO0fJ8ZhMGEBs
FNZXgKYSQGun/0XAehlAT2WseHTsE0CF2aosNrcaQBIkgWLSHBVASvL1URHS
G0Aki9TjOEcWQOIiBOKg2hxAZg+nmeWKF0CuhqhBcusdQIcBeBj8uBhAFyy4
dMFPH0DaEMjLWAAaQHffh9ZpSiBAfMiWFr5BG0BJO+97HOsgQP3tYyqNbRxA
CM7VBQSBIUCvMLByorIdQGLv+6mOIyJAQeH6gyHiHkCrR6EyTrsiQBEdYpbU
BSBAG/QFBxJQI0AZWAaFO6cgQCMvqvV48SNAEcopWNc9IUAboc3IFIgkQKHK
jEUW4SFAq6EwtlMrJUBZH69+WYEiQGP2Uu+WyyVAAatQnNEWI0ALgvQMD2Em
QEHFMdTsuCNAS5zVRCoDJ0BxFpLwPFAkQHvtNWF6midAOfYxJzD0JEBDzdWX
bT4oQCkqkaknlSVAMwE1GmXfKEAIlW8QVCsmQBJsE4GRdSlAgI6NkSPOJkCK
ZTECYRgqQOe+KvcnZidA8ZXOZ2WwKkCNV8P1//8nQJcuZ2Y9SitALwmyqA==

                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                    Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 12.}, {-2.3445187695684826`, 
                    13.644999694915255`}}, PlotRangeClipping -> True, 
                    PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["3", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["False", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic], 
                   BaselinePosition -> Baseline], DynamicModuleValues :> {}], 
                 StyleBox["]", "NonInterpretableSummary"]}]},
              "CopyTag",
              DisplayFunction->(#& ),
              
              InterpretationFunction->(
               "InterpolatingFunction[{{-6., 12.}}, <>]"& )],
             False,
             Editable->False,
             SelectWithContents->True,
             Selectable->False], "[", "x", "]"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"Erfc", "[", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "th"}], "+", "x", "-", 
            RowBox[{"2", " ", 
             RowBox[{
              TagBox[
               TemplateBox[{
                 RowBox[{
                   StyleBox[
                    TagBox["InterpolatingFunction", "SummaryHead"], 
                    "NonInterpretableSummary"], 
                   StyleBox["[", "NonInterpretableSummary"], 
                   DynamicModuleBox[{Typeset`open$$ = False}, 
                    PanelBox[
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquarePlusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAGa+G6///F8AEPYEOk8ECwLHNhJqG
0xbAOppvSOyJAcAYzwMVx40VwIC0Y+UGNgDAoWKExp1dFMCbPA++huz9v9lN
huBrMxPATRVP/+Rz+7/hGwnG8+8RwAHZZZCkvfi/CXyN4hHCEMBFukjVMyz2
vwN+JZXT9Q7AaLVAkHFW879UszI2cnMMwPQWO6i8fPC/5wxDRT0cCsD8lZs0
BIHrvxksVet7kgfAYnVUK05c5b+Mb2r/5jMFwDpdPf02wd6/YGKC5EDhAsA0
h5/BEXTSv9ManGAOXADA5qUmemthsb8O73GVEAT8vzRFKI5cRMM/tDOvl+vq
9r9R+X/uwLzZPxzX8Tuk6fG/LcAJqgk/5T8NhnV4a33qv3C58SKnb+0/XnQO
1Vxd4L/U+5Ihm1PzP9POz6b/p8u/SPSteEC/9z/Fs/ssdZy6Pw/Fi3pHofw/
R0bQ4cPC2j9L6fbywL4AQMk+JISDwuY/9Q+2BHwIA0D5oaxd63bwPweiM2vG
hwVAC9xAHTw29T+HFWovrd8HQFu3zzqv3fk/vhTj3hkuCkBuB1sqO+r+P/GA
g/YFsQxAfwfwHjfQAUCRRCcGgQsPQKjFsBHdXQRAmlTynQTOEEBw1G4zlN8G
QCJzXSG4EhJA974p5x42CUCjoywXS0QTQN/j4gM2vwtA+q57CMqSFECF5Jiy
IB0OQGAutNQszRVA5RomSI43EEBIV3yfcAEXQLngfmvSeRFAO0fJ8ZhMGEBs
FNZXgKYSQGun/0XAehlAT2WseHTsE0CF2aosNrcaQBIkgWLSHBVASvL1URHS
G0Aki9TjOEcWQOIiBOKg2hxAZg+nmeWKF0CuhqhBcusdQIcBeBj8uBhAFyy4
dMFPH0DaEMjLWAAaQHffh9ZpSiBAfMiWFr5BG0BJO+97HOsgQP3tYyqNbRxA
CM7VBQSBIUCvMLByorIdQGLv+6mOIyJAQeH6gyHiHkCrR6EyTrsiQBEdYpbU
BSBAG/QFBxJQI0AZWAaFO6cgQCMvqvV48SNAEcopWNc9IUAboc3IFIgkQKHK
jEUW4SFAq6EwtlMrJUBZH69+WYEiQGP2Uu+WyyVAAatQnNEWI0ALgvQMD2Em
QEHFMdTsuCNAS5zVRCoDJ0BxFpLwPFAkQHvtNWF6midAOfYxJzD0JEBDzdWX
bT4oQCkqkaknlSVAMwE1GmXfKEAIlW8QVCsmQBJsE4GRdSlAgI6NkSPOJkCK
ZTECYRgqQOe+KvcnZidA8ZXOZ2WwKkCNV8P1//8nQJcuZ2Y9SitALwmyqA==

                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                    Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 12.}, {-2.3445187695684826`, 
                    13.644999694915255`}}, PlotRangeClipping -> True, 
                    PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquareMinusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAGa+G6///F8AEPYEOk8ECwLHNhJqG
0xbAOppvSOyJAcAYzwMVx40VwIC0Y+UGNgDAoWKExp1dFMCbPA++huz9v9lN
huBrMxPATRVP/+Rz+7/hGwnG8+8RwAHZZZCkvfi/CXyN4hHCEMBFukjVMyz2
vwN+JZXT9Q7AaLVAkHFW879UszI2cnMMwPQWO6i8fPC/5wxDRT0cCsD8lZs0
BIHrvxksVet7kgfAYnVUK05c5b+Mb2r/5jMFwDpdPf02wd6/YGKC5EDhAsA0
h5/BEXTSv9ManGAOXADA5qUmemthsb8O73GVEAT8vzRFKI5cRMM/tDOvl+vq
9r9R+X/uwLzZPxzX8Tuk6fG/LcAJqgk/5T8NhnV4a33qv3C58SKnb+0/XnQO
1Vxd4L/U+5Ihm1PzP9POz6b/p8u/SPSteEC/9z/Fs/ssdZy6Pw/Fi3pHofw/
R0bQ4cPC2j9L6fbywL4AQMk+JISDwuY/9Q+2BHwIA0D5oaxd63bwPweiM2vG
hwVAC9xAHTw29T+HFWovrd8HQFu3zzqv3fk/vhTj3hkuCkBuB1sqO+r+P/GA
g/YFsQxAfwfwHjfQAUCRRCcGgQsPQKjFsBHdXQRAmlTynQTOEEBw1G4zlN8G
QCJzXSG4EhJA974p5x42CUCjoywXS0QTQN/j4gM2vwtA+q57CMqSFECF5Jiy
IB0OQGAutNQszRVA5RomSI43EEBIV3yfcAEXQLngfmvSeRFAO0fJ8ZhMGEBs
FNZXgKYSQGun/0XAehlAT2WseHTsE0CF2aosNrcaQBIkgWLSHBVASvL1URHS
G0Aki9TjOEcWQOIiBOKg2hxAZg+nmeWKF0CuhqhBcusdQIcBeBj8uBhAFyy4
dMFPH0DaEMjLWAAaQHffh9ZpSiBAfMiWFr5BG0BJO+97HOsgQP3tYyqNbRxA
CM7VBQSBIUCvMLByorIdQGLv+6mOIyJAQeH6gyHiHkCrR6EyTrsiQBEdYpbU
BSBAG/QFBxJQI0AZWAaFO6cgQCMvqvV48SNAEcopWNc9IUAboc3IFIgkQKHK
jEUW4SFAq6EwtlMrJUBZH69+WYEiQGP2Uu+WyyVAAatQnNEWI0ALgvQMD2Em
QEHFMdTsuCNAS5zVRCoDJ0BxFpLwPFAkQHvtNWF6midAOfYxJzD0JEBDzdWX
bT4oQCkqkaknlSVAMwE1GmXfKEAIlW8QVCsmQBJsE4GRdSlAgI6NkSPOJkCK
ZTECYRgqQOe+KvcnZidA8ZXOZ2WwKkCNV8P1//8nQJcuZ2Y9SitALwmyqA==

                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                    Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 12.}, {-2.3445187695684826`, 
                    13.644999694915255`}}, PlotRangeClipping -> True, 
                    PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["3", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["False", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic], 
                    BaselinePosition -> Baseline], DynamicModuleValues :> {}], 
                   StyleBox["]", "NonInterpretableSummary"]}]},
                "CopyTag",
                DisplayFunction->(#& ),
                
                InterpretationFunction->(
                 "InterpolatingFunction[{{-6., 12.}}, <>]"& )],
               False,
               Editable->False,
               SelectWithContents->True,
               Selectable->False], "[", "x", "]"}]}]}], ")"}]}], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{"th", "-", "x", "+", 
          RowBox[{"2", " ", 
           RowBox[{
            TagBox[
             TemplateBox[{
               RowBox[{
                 StyleBox[
                  TagBox["InterpolatingFunction", "SummaryHead"], 
                  "NonInterpretableSummary"], 
                 StyleBox["[", "NonInterpretableSummary"], 
                 DynamicModuleBox[{Typeset`open$$ = False}, 
                  PanelBox[
                   PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquarePlusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAGa+G6///F8AEPYEOk8ECwLHNhJqG
0xbAOppvSOyJAcAYzwMVx40VwIC0Y+UGNgDAoWKExp1dFMCbPA++huz9v9lN
huBrMxPATRVP/+Rz+7/hGwnG8+8RwAHZZZCkvfi/CXyN4hHCEMBFukjVMyz2
vwN+JZXT9Q7AaLVAkHFW879UszI2cnMMwPQWO6i8fPC/5wxDRT0cCsD8lZs0
BIHrvxksVet7kgfAYnVUK05c5b+Mb2r/5jMFwDpdPf02wd6/YGKC5EDhAsA0
h5/BEXTSv9ManGAOXADA5qUmemthsb8O73GVEAT8vzRFKI5cRMM/tDOvl+vq
9r9R+X/uwLzZPxzX8Tuk6fG/LcAJqgk/5T8NhnV4a33qv3C58SKnb+0/XnQO
1Vxd4L/U+5Ihm1PzP9POz6b/p8u/SPSteEC/9z/Fs/ssdZy6Pw/Fi3pHofw/
R0bQ4cPC2j9L6fbywL4AQMk+JISDwuY/9Q+2BHwIA0D5oaxd63bwPweiM2vG
hwVAC9xAHTw29T+HFWovrd8HQFu3zzqv3fk/vhTj3hkuCkBuB1sqO+r+P/GA
g/YFsQxAfwfwHjfQAUCRRCcGgQsPQKjFsBHdXQRAmlTynQTOEEBw1G4zlN8G
QCJzXSG4EhJA974p5x42CUCjoywXS0QTQN/j4gM2vwtA+q57CMqSFECF5Jiy
IB0OQGAutNQszRVA5RomSI43EEBIV3yfcAEXQLngfmvSeRFAO0fJ8ZhMGEBs
FNZXgKYSQGun/0XAehlAT2WseHTsE0CF2aosNrcaQBIkgWLSHBVASvL1URHS
G0Aki9TjOEcWQOIiBOKg2hxAZg+nmeWKF0CuhqhBcusdQIcBeBj8uBhAFyy4
dMFPH0DaEMjLWAAaQHffh9ZpSiBAfMiWFr5BG0BJO+97HOsgQP3tYyqNbRxA
CM7VBQSBIUCvMLByorIdQGLv+6mOIyJAQeH6gyHiHkCrR6EyTrsiQBEdYpbU
BSBAG/QFBxJQI0AZWAaFO6cgQCMvqvV48SNAEcopWNc9IUAboc3IFIgkQKHK
jEUW4SFAq6EwtlMrJUBZH69+WYEiQGP2Uu+WyyVAAatQnNEWI0ALgvQMD2Em
QEHFMdTsuCNAS5zVRCoDJ0BxFpLwPFAkQHvtNWF6midAOfYxJzD0JEBDzdWX
bT4oQCkqkaknlSVAMwE1GmXfKEAIlW8QVCsmQBJsE4GRdSlAgI6NkSPOJkCK
ZTECYRgqQOe+KvcnZidA8ZXOZ2WwKkCNV8P1//8nQJcuZ2Y9SitALwmyqA==

                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                    Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 12.}, {-2.3445187695684826`, 
                    13.644999694915255`}}, PlotRangeClipping -> True, 
                    PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SquareMinusIconMedium"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, Evaluator -> Automatic, Method -> "Preemptive"], 
                    Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GraphicsBox[{{{{}, {}, {
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAGa+G6///F8AEPYEOk8ECwLHNhJqG
0xbAOppvSOyJAcAYzwMVx40VwIC0Y+UGNgDAoWKExp1dFMCbPA++huz9v9lN
huBrMxPATRVP/+Rz+7/hGwnG8+8RwAHZZZCkvfi/CXyN4hHCEMBFukjVMyz2
vwN+JZXT9Q7AaLVAkHFW879UszI2cnMMwPQWO6i8fPC/5wxDRT0cCsD8lZs0
BIHrvxksVet7kgfAYnVUK05c5b+Mb2r/5jMFwDpdPf02wd6/YGKC5EDhAsA0
h5/BEXTSv9ManGAOXADA5qUmemthsb8O73GVEAT8vzRFKI5cRMM/tDOvl+vq
9r9R+X/uwLzZPxzX8Tuk6fG/LcAJqgk/5T8NhnV4a33qv3C58SKnb+0/XnQO
1Vxd4L/U+5Ihm1PzP9POz6b/p8u/SPSteEC/9z/Fs/ssdZy6Pw/Fi3pHofw/
R0bQ4cPC2j9L6fbywL4AQMk+JISDwuY/9Q+2BHwIA0D5oaxd63bwPweiM2vG
hwVAC9xAHTw29T+HFWovrd8HQFu3zzqv3fk/vhTj3hkuCkBuB1sqO+r+P/GA
g/YFsQxAfwfwHjfQAUCRRCcGgQsPQKjFsBHdXQRAmlTynQTOEEBw1G4zlN8G
QCJzXSG4EhJA974p5x42CUCjoywXS0QTQN/j4gM2vwtA+q57CMqSFECF5Jiy
IB0OQGAutNQszRVA5RomSI43EEBIV3yfcAEXQLngfmvSeRFAO0fJ8ZhMGEBs
FNZXgKYSQGun/0XAehlAT2WseHTsE0CF2aosNrcaQBIkgWLSHBVASvL1URHS
G0Aki9TjOEcWQOIiBOKg2hxAZg+nmeWKF0CuhqhBcusdQIcBeBj8uBhAFyy4
dMFPH0DaEMjLWAAaQHffh9ZpSiBAfMiWFr5BG0BJO+97HOsgQP3tYyqNbRxA
CM7VBQSBIUCvMLByorIdQGLv+6mOIyJAQeH6gyHiHkCrR6EyTrsiQBEdYpbU
BSBAG/QFBxJQI0AZWAaFO6cgQCMvqvV48SNAEcopWNc9IUAboc3IFIgkQKHK
jEUW4SFAq6EwtlMrJUBZH69+WYEiQGP2Uu+WyyVAAatQnNEWI0ALgvQMD2Em
QEHFMdTsuCNAS5zVRCoDJ0BxFpLwPFAkQHvtNWF6midAOfYxJzD0JEBDzdWX
bT4oQCkqkaknlSVAMwE1GmXfKEAIlW8QVCsmQBJsE4GRdSlAgI6NkSPOJkCK
ZTECYRgqQOe+KvcnZidA8ZXOZ2WwKkCNV8P1//8nQJcuZ2Y9SitALwmyqA==

                    "]]}}}, {}}, {
                    DisplayFunction -> Identity, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                    All, DisplayFunction -> Identity, AspectRatio -> 1, 
                    Axes -> {False, False}, AxesLabel -> {None, None}, 
                    AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                    Frame -> {{True, True}, {True, True}}, 
                    FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                    Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                    FrameTicks -> {{None, None}, {None, None}}, 
                    GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], 
                    Method -> {
                    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None}, 
                    PlotRange -> {{-6., 12.}, {-2.3445187695684826`, 
                    13.644999694915255`}}, PlotRangeClipping -> True, 
                    PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "6.`"}], ",", "12.`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["3", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["False", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic], 
                   BaselinePosition -> Baseline], DynamicModuleValues :> {}], 
                 StyleBox["]", "NonInterpretableSummary"]}]},
              "CopyTag",
              DisplayFunction->(#& ),
              
              InterpretationFunction->(
               "InterpolatingFunction[{{-6., 12.}}, <>]"& )],
             False,
             Editable->False,
             SelectWithContents->True,
             Selectable->False], "[", "x", "]"}]}]}], ")"}]}]}], ")"}]}]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{3.6723975263250704`*^9, 3.6724014204215307`*^9, 
  3.672402635264003*^9, 3.672403555918059*^9, 3.67240452433189*^9, 
  3.672572809172738*^9},ExpressionUUID->"9282c8b1-0afc-4714-b797-\
0666e0dc0ea2"],

Cell[BoxData[
 TagBox[GridBox[{
    {"\[Piecewise]", GridBox[{
       {"1", 
        RowBox[{"x", "<", 
         RowBox[{"-", "3.919927969080108`"}]}]},
       {
        RowBox[{"0.5`", " ", 
         RowBox[{"(", 
          RowBox[{"2.`", "\[VeryThinSpace]", "-", 
           RowBox[{"1.`", " ", 
            RowBox[{"Erfc", "[", 
             RowBox[{
              RowBox[{"-", "1.959963984540054`"}], "-", 
              RowBox[{"0.5`", " ", "x"}]}], "]"}]}], "+", 
           RowBox[{"Erfc", "[", 
            RowBox[{"1.959963984540054`", "\[VeryThinSpace]", "+", 
             RowBox[{"0.5`", " ", "x"}]}], "]"}]}], ")"}]}], 
        TagBox["True",
         "PiecewiseDefault",
         AutoDelete->True]}
      },
      AllowedDimensions->{2, Automatic},
      Editable->True,
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{
       "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.84]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}},
      Selectable->True]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.35]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  "Piecewise",
  DeleteWithContents->True,
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellChangeTimes->{3.6723975263250704`*^9, 3.6724014204215307`*^9, 
  3.672402635264003*^9, 3.672403555918059*^9, 3.67240452433189*^9, 
  3.6725728851923394`*^9},ExpressionUUID->"1faba3f0-0070-40d1-a044-\
6d2c9ebd2c66"],

Cell[BoxData[
 TagBox[GridBox[{
    {"\[Piecewise]", GridBox[{
       {"1", 
        RowBox[{"x", "<", 
         RowBox[{"-", "3.919927969080108`"}]}]},
       {
        RowBox[{"0.5`", " ", 
         RowBox[{"(", 
          RowBox[{"2.`", "\[VeryThinSpace]", "-", 
           RowBox[{"1.`", " ", 
            RowBox[{"Erfc", "[", 
             RowBox[{
              RowBox[{"-", "1.959963984540054`"}], "-", 
              RowBox[{"0.5`", " ", "th"}], "-", 
              RowBox[{"0.5`", " ", "x"}]}], "]"}]}], "+", 
           RowBox[{"Erfc", "[", 
            RowBox[{"1.959963984540054`", "\[VeryThinSpace]", "-", 
             RowBox[{"0.5`", " ", "th"}], "+", 
             RowBox[{"0.5`", " ", "x"}]}], "]"}]}], ")"}]}], 
        TagBox["True",
         "PiecewiseDefault",
         AutoDelete->True]}
      },
      AllowedDimensions->{2, Automatic},
      Editable->True,
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{
       "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.84]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}},
      Selectable->True]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.35]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  "Piecewise",
  DeleteWithContents->True,
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellChangeTimes->{3.6723975263250704`*^9, 3.6724014204215307`*^9, 
  3.672402635264003*^9, 3.672403555918059*^9, 3.67240452433189*^9, 
  3.672572900369857*^9},ExpressionUUID->"a959a7bb-a562-4fba-8959-\
ef0ce2738c75"],

Cell[BoxData[
 TagBox[GridBox[{
    {"\[Piecewise]", GridBox[{
       {"1.`", 
        RowBox[{"x", "<", 
         RowBox[{"-", "3.919927969080108`"}]}]},
       {
        RowBox[{
         FractionBox["1", "th"], 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", "0.25`"}], " ", 
           SuperscriptBox["th", "2"]}]], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "0.012108788549536662`"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{"th", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1.9599639845400538`"}], "-", 
                 RowBox[{"0.5`", " ", "x"}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1.9599639845400538`"}], "-", 
                 RowBox[{"0.25`", " ", "x"}]}], ")"}], " ", "x"}]}]]}], "+", 
           RowBox[{"0.012108788549536662`", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{"th", " ", 
               RowBox[{"(", 
                RowBox[{"1.9599639845400538`", "\[VeryThinSpace]", "+", 
                 RowBox[{"0.5`", " ", "x"}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1.9599639845400538`"}], "-", 
                 RowBox[{"0.25`", " ", "x"}]}], ")"}], " ", "x"}]}]]}], "+", 
           RowBox[{"1.0000000000000002`", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"0.25`", " ", 
              SuperscriptBox["th", "2"]}]], " ", "th"}], "+", 
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"0.25`", " ", 
              SuperscriptBox["th", "2"]}]], " ", 
            RowBox[{"(", 
             RowBox[{"1.959963984540054`", "\[VeryThinSpace]", "-", 
              RowBox[{"0.5000000000000001`", " ", "th"}], "+", 
              RowBox[{"0.5000000000000001`", " ", "x"}]}], ")"}], " ", 
            RowBox[{"Erf", "[", 
             RowBox[{"1.9599639845400538`", "\[VeryThinSpace]", "-", 
              RowBox[{"0.5`", " ", "th"}], "+", 
              RowBox[{"0.5`", " ", "x"}]}], "]"}]}], "+", 
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"0.25`", " ", 
              SuperscriptBox["th", "2"]}]], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1.959963984540054`"}], "-", 
              RowBox[{"0.5000000000000001`", " ", "th"}], "-", 
              RowBox[{"0.5000000000000001`", " ", "x"}]}], ")"}], " ", 
            RowBox[{"Erf", "[", 
             RowBox[{"1.9599639845400538`", "\[VeryThinSpace]", "+", 
              RowBox[{"0.5`", " ", "th"}], "+", 
              RowBox[{"0.5`", " ", "x"}]}], "]"}]}]}], ")"}]}], 
        TagBox["True",
         "PiecewiseDefault",
         AutoDelete->True]}
      },
      AllowedDimensions->{2, Automatic},
      Editable->True,
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{
       "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.84]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}},
      Selectable->True]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.35]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  "Piecewise",
  DeleteWithContents->True,
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellChangeTimes->{3.6723975263250704`*^9, 3.6724014204215307`*^9, 
  3.672402635264003*^9, 3.672403555918059*^9, 3.67240452433189*^9, 
  3.672572929840804*^9},ExpressionUUID->"9df39d6d-0b76-42da-8bdc-\
4086aa553dcb"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"As", "=", 
   RowBox[{"{", 
    RowBox[{"Aavemw", ",", "A05emw", ",", "A00emw"}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6721535044668465`*^9, 3.672153512722672*^9}, {
  3.6723975001364517`*^9, 3.672397506968135*^9}, {3.6724014404585342`*^9, 
  3.6724014432268105`*^9}},ExpressionUUID->"448ad9d4-24ad-441f-9f74-\
1ba82b846ead"],

Cell[BoxData[
 RowBox[{
  RowBox[{"As", "=", 
   RowBox[{"{", 
    RowBox[{"Aavst", ",", "A05st", ",", "A00st"}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.672397536105048*^9, 3.672397542265664*^9}, {
  3.672401445979086*^9, 
  3.67240144901939*^9}},ExpressionUUID->"852c7025-6ee7-4a51-a8f8-\
25115613978c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"bEW", "[", "betlevel_", "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A", "=", 
     RowBox[{
      RowBox[{"As", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "-", 
      RowBox[{"betlevel", " ", "B"}]}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Aw", "=", 
     RowBox[{
      RowBox[{"As", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "-", 
      RowBox[{"betlevel", " ", "B"}]}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"cpi", "=", 
     RowBox[{"-", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{"1", ",", 
         RowBox[{"{", 
          RowBox[{"Length", "[", "grid", "]"}], "}"}]}], "]"}], ".", 
       "Aw"}]}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"xs", "=", 
     RowBox[{"LinearProgramming", "[", 
      RowBox[{"cpi", ",", "A", ",", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"10", "^", 
           RowBox[{"(", 
            RowBox[{"-", "14"}], ")"}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"Length", "[", "grid", "]"}], "}"}]}], "]"}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "xgrid", "]"}]}], "}"}]}], "]"}], ",", 
       RowBox[{"Tolerance", "\[Rule]", 
        RowBox[{"10", "^", 
         RowBox[{"(", 
          RowBox[{"-", "12"}], ")"}]}]}]}], "]"}]}], ";"}], 
   ")"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ew", "[", 
   RowBox[{"betlevel_", ",", "i_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"bEW", "[", "betlevel", "]"}], ";", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"As", "[", 
          RowBox[{"[", "i", "]"}], "]"}], "-", 
         RowBox[{"betlevel", " ", "B"}]}], ")"}], ".", "xs"}], "/", 
      RowBox[{"(", 
       RowBox[{"1", "-", "betlevel"}], ")"}]}], ")"}]}], 
   ")"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"prob", "[", 
   RowBox[{"betlevel_", ",", "i_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"bEW", "[", "betlevel", "]"}], ";", 
    RowBox[{"B", ".", "xs"}]}], ")"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"crp", "[", 
   RowBox[{"betlevel_", ",", "i_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"bEW", "[", 
     RowBox[{"betlevel", ",", 
      RowBox[{"Table", "[", 
       RowBox[{"1", ",", 
        RowBox[{"{", 
         RowBox[{"Length", "[", "grid", "]"}], "}"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "/", "3"}], ",", 
        RowBox[{"1", "/", "3"}], ",", 
        RowBox[{"1", "/", "3"}]}], "}"}]}], "]"}], ";", 
    RowBox[{"avx", "=", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"As", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "-", 
          RowBox[{"betlevel", " ", "B"}]}], ")"}], ".", "xs"}], "/", 
       RowBox[{"(", 
        RowBox[{"1", "-", "betlevel"}], ")"}]}], ")"}]}], ";", 
    RowBox[{"px", "=", 
     RowBox[{"B", ".", "xs"}]}], ";", 
    RowBox[{"betlevel", "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "betlevel"}], ")"}], 
      RowBox[{"avx", "/", "px"}]}]}]}], 
   ")"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.6723126334312735`*^9, 3.67231263449338*^9}, {
  3.6723974124856873`*^9, 3.6723974149659357`*^9}, {3.672397565450983*^9, 
  3.6723976547189083`*^9}, {3.672401453579846*^9, 3.672401600273514*^9}, {
  3.6724018329547796`*^9, 
  3.672401834889973*^9}},ExpressionUUID->"803eb0c3-c59e-406d-b09b-\
7bcb2fb5b2b2"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"style", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AbsoluteThickness", "[", "1.4", "]"}], ",", "Black"}], "}"}],
       ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AbsoluteThickness", "[", ".8", "]"}], ",", 
        RowBox[{"AbsoluteDashing", "[", 
         RowBox[{"{", 
          RowBox[{"2", ",", "2"}], "}"}], "]"}], ",", "Black"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AbsoluteDashing", "[", 
         RowBox[{"{", 
          RowBox[{"8", ",", "2"}], "}"}], "]"}], ",", 
        RowBox[{"AbsoluteThickness", "[", ".8", "]"}], ",", "Black"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AbsoluteDashing", "[", 
         RowBox[{"{", 
          RowBox[{"8", ",", "0"}], "}"}], "]"}], ",", 
        RowBox[{"AbsoluteThickness", "[", ".8", "]"}], ",", "Black"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AbsoluteDashing", "[", 
         RowBox[{"{", 
          RowBox[{"2", ",", "2"}], "}"}], "]"}], ",", 
        RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", "Black"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AbsoluteDashing", "[", 
         RowBox[{"{", 
          RowBox[{"8", ",", "0"}], "}"}], "]"}], ",", 
        RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", "Black"}], "}"}]}],
      "}"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p00", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"p05", "=", 
    RowBox[{"{", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"betlevels", "=", 
    RowBox[{"{", 
     RowBox[{"0.05", ",", "0.06", ",", "0.1", ",", ".5"}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"AppendTo", "[", 
     RowBox[{"p00", ",", 
      RowBox[{"ListPlot", "[", 
       RowBox[{
        RowBox[{"Transpose", "[", 
         RowBox[{"{", 
          RowBox[{"grid", ",", 
           RowBox[{"100", 
            RowBox[{"ew", "[", 
             RowBox[{
              RowBox[{"betlevels", "[", 
               RowBox[{"[", "ib", "]"}], "]"}], ",", "3"}], "]"}]}]}], "}"}], 
         "]"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
        RowBox[{"Joined", "\[Rule]", "True"}], ",", 
        RowBox[{"PlotStyle", "\[Rule]", 
         RowBox[{"style", "[", 
          RowBox[{"[", "ib", "]"}], "]"}]}], ",", 
        RowBox[{"LabelStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"FontFamily", "\[Rule]", "\"\<Cmr10\>\""}], ",", 
           RowBox[{"FontSize", "\[Rule]", "15"}]}], "}"}]}], ",", 
        RowBox[{"AxesStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"AbsoluteThickness", "[", ".8", "]"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"AbsoluteThickness", "[", ".8", "]"}], "}"}]}], "}"}]}]}],
        "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"AppendTo", "[", 
     RowBox[{"p05", ",", 
      RowBox[{"ListPlot", "[", 
       RowBox[{
        RowBox[{"Transpose", "[", 
         RowBox[{"{", 
          RowBox[{"grid", ",", 
           RowBox[{"100", 
            RowBox[{"ew", "[", 
             RowBox[{
              RowBox[{"betlevels", "[", 
               RowBox[{"[", "ib", "]"}], "]"}], ",", "2"}], "]"}]}]}], "}"}], 
         "]"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
        RowBox[{"Joined", "\[Rule]", "True"}], ",", 
        RowBox[{"PlotStyle", "\[Rule]", 
         RowBox[{"style", "[", 
          RowBox[{"[", "ib", "]"}], "]"}]}], ",", 
        RowBox[{"LabelStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"FontFamily", "\[Rule]", "\"\<Cmr10\>\""}], ",", 
           RowBox[{"FontSize", "\[Rule]", "15"}]}], "}"}]}], ",", 
        RowBox[{"AxesStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"AbsoluteThickness", "[", ".8", "]"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"AbsoluteThickness", "[", ".8", "]"}], "}"}]}], "}"}]}]}],
        "]"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"ib", ",", "1", ",", 
     RowBox[{"Length", "[", "betlevels", "]"}]}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", "p00", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", "p05", "]"}]}], "Input",
 CellChangeTimes->{
  3.672401696151101*^9, {3.6724017854670315`*^9, 3.6724017881693015`*^9}, {
   3.6724020629487767`*^9, 
   3.6724020650439863`*^9}},ExpressionUUID->"ae982477-4ae7-4e9b-ad82-\
824690495181"],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.011000000000000001`], AbsoluteThickness[1.4], 
      LineBox[CompressedData["
1:eJwt0ntIU1EcwPGZD9ZcbubMZb7mRCdBIUVlde/5KebCpqCYOdpILTF8rFVK
YJqvjOaD1cSCYrMyWZAtFUOF/lhbSmzCtMxXPtJJtWbrMV8z/6i7e/84HL7n
jw/nHH68vEsZ+dtoNNqB/4vYr3N0woXym8g8ogmOHaLDYjlxYEJxN/Y6baWe
gDMm2uXYNAqto2O9njS4ZU/vD6u3orOlwqjuqr9omUi7DXV+ihFMpWygWInS
sCr4heQzK8bU/lUkJVLiRI3FJpdvjhPdIVK5hljRalCzfyMjkQYXapHt2+or
/4HWiFzdQqZm18eEuW/IfT0ODUTDlu4O+RJyp84D5g2bWn/xZ3SSSKEnwJyf
2Vwyhdy54AVlo62ypfgPiHyfD5xiGCQbicOUR4eF4qE1fdxbytsOrKzcE7ns
15TnCyJ5vJd9vYfymDD7Xqntdj6jPD+IFaTlSFfakPt7GGxoGNY+2OFoQe6c
YINRq5qUHr2NnhLZ7g9VNQPMov4KdJlI+U7QA3d066Eckf8bANpsRpPkTR7l
cUAa+HN/dlcm5XFAWDVoaUxLprxASNEbz9TUH6a8XXDabsnoSBJQXhAYUjQj
T2q5lMeFa6KLYd44nfK48Mp6jB9UuY6T3m4QZ9uqWalfcNILBg9zQ+1z/RhO
ensgZ5rvKHAYyGSEgFaTda7Z0YWTXgjYmsZfNPaoKS8UCsdnDo4rFJQXBiaf
tMELijLKC4dZVefLe5ZcvJ6YJ+8IeMzsky1aRbh7nooiQKxj9uZvHsIziPEa
jQAssC0mYZmHE5l+hAfv1Mll4iJfPJwANDxIkv2Zr7i7gpFeJKiMk/1fE+cw
0osEV8F9vWpsECO9SJgJUGTSrDpswO3xobBAdhUvacVIjw/RddWt36MrKS8K
jrMeKbOvnMf+AcRbdgc=
       "]]}}, {}}, {{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.011000000000000001`], AbsoluteThickness[0.8], 
      AbsoluteDashing[{2, 2}], LineBox[CompressedData["
1:eJwt0ntIU1EcwPG5Wbk1Y9p0j3zsYWL0UHoxtHvPb39NwgjNxZxaIpVakUoo
ZRppm4lhDkEzpdDW1P5wItXahMQ007RSQRtNl65pvsoVMs1qVHf3/nE4fM8f
H845/MSZuUln6TQa7cD/RezXuEaFo0iDOrktjZnKLfC5iDgYQvPzHOurI3TA
WVZ9HmZDFZYA2f5ZDypfTjSHaZ3IQD++UFy1gb4SubyIbgsjHVcK19CutOpe
d9R3VEEvVkevr6J0ItNWUaPnoI3V8QPpiKxeQ+XJ/kzV7ArqI7J3A7XGaZ62
X1pCa0S6/yB5VKVCHvAFea/HpUFsQj2vyeVA3jT6QENfaoJUPYXiiVQwQJiS
HHlqYAJ50+EL0a59XKN8FJHv2wwZ2RbUXDtAeX6wJ9ItXGnqoTwmTEVpi8ve
mihvK2gjTG9Ks4yUx4aUpauX87v0lLcNxoeYI4Jv9cj7PSwOFGZIxj6230He
tHJAN4GlM7LK0CMi9QFwZudhGaeiAOUTmRcIOh3Ts1Cbjcj/3Q58y5NfQzmp
lMeF6wyNq9V+jPK4wO7zrJeOIMoLgkp5XOehmhjKC4a/3Mf+2XMiyuOBaqJr
eM7OoTw+xHQm55hLaJTHh08lJjG73oWTngBG6ji2m212nPSEoDGdqA48OoyT
3g5o91vSP7xvJpMVAj1in3fB/Qac9EJgukCgeD1TQ3mhwJ8RT5/zv0F5YRD6
QSEQ9J+nvHBwov6OZqcS1xLztEkEgWyDAauS4955uiCCUdtduaxhN55EjNeY
CDYuatRt8UE4kYkyMZzcVvfezaPh4QTwQAylo72nu+3zGOlJIFZqeZmuHsNI
TwItk4v39N1mjPQkoMqcfPYioRmzeD0pDLKUqr3mWxjpSYFn/P2zyplLeREw
+HycYfVVYv8ASzxwBA==
       "]]}}, {}}, {{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.011000000000000001`], AbsoluteThickness[0.8], 
      AbsoluteDashing[{8, 2}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwBmIQXS2yzv1hVYv933lMJgdYmB0eVYEETtmHSO1asdX9
r70d1/XFBba37GOmVzxjmfvdvu114A651sf28e+Uzitf+mz/BsR9/dJ+xvRU
Xknej/aaMf2Hvmp8sLfVD8/92f3WPhbEjflsz3jAeGVN5kv7CSBu/zd7pdm/
/jVWPbU/DOIe+ml/XH1Z7r1dD+2/gbhf/9jf1DWOv1lzxx7sPBEGB4arH7Y8
s75mD+auY3Rwb3E7W3njgr0HiOvO7LBElLmp9dgJezD3IYtDueU11q3rD9pD
/Mfm8CWPpWZZ6w6oeRwOrV+X/ohq2QA1j9NB9NiGgOyFS6HmcTtUPp7cId83
G2oej4PMQy/tdtGJUPP4HNJy9k2IXtRiDw4eLgGH6PDNglu9KuzB3OsCDv3f
j7+9+iTbfgmIu1jQ4ev5h9HBzvH2hSBugZCDqSj7gQqZQGj4Cjsse3GJP8jP
CWqeiMPPKeYeM9WMoeaJOOhqZD9nn6UMNU/U4WFJwO6excJQ88Qclib77+lx
YYaaJ+4QvbNkbXvLJwiXS8JBnWXxRJOCh3YQ8yQcYv8FuJtLXLCDmCfpoKRm
3GAov9cOYp6Ug3+7o2vMlZV2EAOkHf5XnDpqWDYNap6Mw4nbFpJs6s1Q82Qc
lCcxOyYyF0DNk3WQMNX9ftIxCmqenION7p/lr6RdoebJO7DzOh6VWmJg1wpK
T6wKDk6O+0XSdknagdNTtoKD5I96ofkNzHZBoOR1UcGhn/9y0qe/b2xB3EAL
RYd3X37I5ShetZUHGTBP0eH0Apcz14z32ULMU3Jg0OedIae11BZinpIDx21T
z5WivbYQ85QcbFk113nMKLbdCTZP2cHli/r+6MeRUPOUHY5Hu0h1HnGAmqfi
UBvu28/uo2oLAPnaY/U=
       "]]}}, {}}, {{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.011000000000000001`], AbsoluteThickness[0.8], 
      AbsoluteDashing[{8, 0}], LineBox[CompressedData["
1:eJwt0mtIk1EYwPF512XqdKa26W4ONKmFFY3Yu/OMLjYjxiQSTUkyE51XzAum
ieIqlzn7kNhNC224BJuzloYFLWZlls2mokLl7K7hrOYthXovHw6H//nw45zD
wzuRn5DhSqPRdvxf+H6G2RU3XV6LdOIhFsvbjuzl+MEgGviRuZRUOIGk9PG2
AmwSTbxd3LOXN4LOzSp7I9QzqLZr/3wFbRDN4Tn7HSULOYr1djOKTtGanVEO
5B9c5xBpHqFUPFN+oxZfHTu+1Yga8dQuoqDaHPNAqx49w9O8gr44BRYX8W20
iKdzDVk+yfUvLjYh4npMGqyvFiQu9dYjIrtcQJlaUnFksBodxDPODQ7XzXB9
8ooRkdPuoEjvVmexsxD5Pk8ofun3TdSeQnnewEjO7XgwoqA8H+B22JylEhnl
bQB5mbhybXcs5fkCp6HTduANn/L8wKuhc1a7HIiI76EHwOcZeo/ooSsicjwA
PN3fz0Uzfknb8WxjgCB012pk0LS0EM+CQJj0jtrpuD4sJf83CFRbp+Qed/vJ
pDPBOWRkL5fppaTHhBxLjP9rURPlBcPJxG6VZqGG8jbBpY+atXumfMoLAf3x
urFXnsmUFwq5h2Sl2xb2UV4ofF3q32JQb6e8MBCqjKfs2jDK2wwDihum4nQ3
ymNBVVx4jHFsDiM9NjAay0drvEYx0mODrcRQKg98gpFeOJRdZvCszDsY6UXA
sT/2D/y/9RjpcUBXbS0KuVCEqfF58uCCTcvTrAwnYcQ8qbhgjt3oGt0HWAI+
XlYucGy3sh1SIYanUsyDzKka1tMSOsbBgRYeXBnNmLdGOSSkx4fnhptesqR3
EtLjw33u436LySQhPT5cPRtvOB95TdJHeALQGYQ/V6sqJaQngOXJ+LzTyjTK
i4S07KPNjB6Z5B+O/23C
       "]]}}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  AxesStyle->{{
     AbsoluteThickness[0.8]}, {
     AbsoluteThickness[0.8]}},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Cmr10", FontSize -> 15},
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 10.01}, {0, 3.096758087131183}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.6724017421517005`*^9, 3.672401790207505*^9, {3.6724019107505584`*^9, 
   3.6724019386043434`*^9}, 3.672404338858345*^9, 3.67240772334676*^9, 
   3.6724078016065855`*^9},ExpressionUUID->"9fc96f5d-07e0-44fd-97c2-\
73b30bbd6b10"],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.011000000000000001`], AbsoluteThickness[1.4], 
      LineBox[CompressedData["
1:eJwt0l1Ik1EYwPG5zVgzdNPVlk7d1D7MzM8LwbbzVKQ1MvErSJ2KJYQu/Egp
FExskyaaw1zUFMkmUoaz1ELNl9mGWSqkpEgukS29ELNCN8kpVu/ec3E4/M/F
j3MOjzi/OLWATqPRYv4vcq/iGRKtlUqkdY/eezvGAlsleTCBMoZf7vZ8oYOU
Pa8vkSygovtdLYWhu6huLWUwQPUdafzTZLYhO/pB5toqcmYalHnMnyg0u8nk
OP4bmVv97FX5K0hOZvYmoqWFm/f+LCINmU1bqExGsIafzyIzmaZt5MjUrDW7
TaEtMh27KJbLEoq7Tch1PR4Nlm4rxo3lg8iVBjcwWT0tk9W96AKZiQxY4tTP
Gdf1yJVWJoR6BKwwxh8j6n374Ej6XLnk7APssUBtq/22ElKLvf2Qpp2vpssr
sOcB1femw+6+uoG9A2D8lWqx/c3CnieoM+iytqPJyPU9bA4My6/pW/cAuXKe
A0s3dRPCU9Gok0w9F66Yzyn7vYJRKZkl3mB8ymfXt/gg6n99YGPDeFHTx8Ae
D2g1Jx26gk0p5fEgCrV1O3ttUso7CDpL/GypbkZKeYegkdnLV8WMSimPD4qp
sMVSYQ+VbAG8qOsyfKh5gj0BtNujzI3vVdg7DK8ZOYXX2WXY84XogRPMYoYc
e35QGZnn0DYkYE8Il67KkhoskdgTwkLOV/t5rgB7/pDcuZjTH0vDXgBEdex0
ItGyhAIC4ZFHWHnu+phERc6Tuwjq05dP850dEtc8FYlg4F14Vu6zJEkqOV4z
IvDqv6XtUJYRZKbEieFMxOfYikkFEUgC7WJwM9VMCTh5BOUFQbNezRRykwnK
C4KP/u3xk5p4gvKC4E3EHbkv/Rgx5PKCwfdywidrkjf2guGheNQ2vb0zQnkh
oFiN61Prl0f+ASXDb+w=
       "]]}}, {}}, {{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.011000000000000001`], AbsoluteThickness[0.8], 
      AbsoluteDashing[{2, 2}], LineBox[CompressedData["
1:eJwt0mtIk1EYwPHNMuctN93ytunmJRWVMjG03M7jhzCHCl5Sm0omDl2SmyFU
WmLkpbB0WsNRS7MZBPPyyZm0lViTViQopdJQmkqZ81ZjQrl1efeeD4fD/3z4
cc7h4ZVLc8UuFAol8f8i9gbmcLq5vhklMR1Ntnw3WK4nDt4hAz/TcFFNBYHH
vFrG/4yiw8eX8lN/o1ZLzvOQlhW0mvHNpy3BijaItHxHvmxrWU6fBcWUdE7a
oneQYsjtRfadFVRKZIkVTQwOP+AmmZCcyM5dpPNOLDY+mkWviZz8hZIf90ir
PY1ol0ibHa0VTjm2OiaQ83pMCoS6t2kqm0eRM4epYHZkW+OvatBpItP3wWjE
km32RD9ypnk/8ES9FkOKApHvOwBnK2Y2Y4ZuY48G7XuLutTGRuy5g1Cj/aMw
1GLPE5S0ZYohrwJ7XpBWF9lmny7A3kFg3WvZaA/MQM7v8aCDdq50fIp5Ejlz
ng5zWhd5rToODRCpZsDx7kq/okEOqiVS5gsKjVL2in0Qkf/rB6IrseXidQeZ
HkyI8i9KecPcFJAeE1T0vQuSpyYB6bFAxA+SC0eMAtI7BI3iqdWorDEBCfgD
Je0mI75vAHsB4C+faQh+24W9AKh6lqUZ+Xgde4HQVVM4KBFWYS8IaAy1sSMy
D3vBMF8sqf4SyMceG9JFVmpfQiT22FBXfES1nemNPQ7UCLo+2L/+5JNeCAiq
3neq/n7CQCj4qtZczdGj/BZinly5cCbmnNT0sJXvnKdqLoyVaafvRsn0ucR4
zXBhTRzLp49d0hOZk8wDms81Bj2uUh9KAL08uJzEukG9X6gnvTBYZC10FyhP
6UkvDHrWNfJt6THshQHraFd/iImjH3d64SB5qVp1OeyGvXDgKJ943RL+0JFe
BOyc3wpusi/o/gEdsGz9
       "]]}}, {}}, {{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.011000000000000001`], AbsoluteThickness[0.8], 
      AbsoluteDashing[{8, 2}], LineBox[CompressedData["
1:eJwt0mtIk1EYwPHZpuiyoTmdldNtBik6lDQL6t151EonJmg1LS3UmqVGM8WK
LZqZBik4SQhiItGMMfNWuZryCjqzcCOWmZnXmiM1Tai8NMO03suHw+F/Pvw4
5/AIcxVp8i0MBiPq/yJ2Fbc1wa6sQBvZvz/KWUyYVhIHFuTMYU92pKwjCXtE
V4SNISefc/eTcRndWUg1BVY6kOrWYGn7wCL6TuTCN6TApLMxnK8oNEtjXgn5
gdqi1eqQ2El0hsisJWSIXMCHnEOolkjNKip+32/utlpQH5HmNdTd5L1HZuhF
q0SurKPZsHZz8ucXiLwelwEtNcwljX8LIrPVBUQ5HZoo8SOUSGQCExQnziae
P3YfkWlnQZXDJKueqkLU+9wAn8sQ/Hmjpj13OJ5tYkWUFNOeB8xeeHkz3k1O
e1vBu43n11yeTnuesGxv5CisUtrjAFOwIRX3HUTk97C9YKnkQcTVFDEic8QL
No/mF4TJAlEjkTpv6BLPjzcPcNAVIou2A1vRs1b5cENC/a8P6OyxX3LGF6lk
c2HYYKgQVkxIKI8Lea69mZ4tFgnl+UKPQN29V2GSUJ4fTATnrUfPPaY9HlQf
mbMa99fRnj/way7/en2jjPb8QW7bfB6jL6S9HcArvp1ZqpfR3k6IP2WNNPHj
aG8XXGrW59piw2kvAOw/Owu013xpLwBMYXi5sGsTozw++DwJTXplnsEoLxDu
JX0Y7m+wYRQQBH/dazN4kUaskpgnVwFcfyvd14VpMXKeCgUAktH8Hn0ZlkaM
16AAHOhkSqbvOYzI1ANCuKgLL+uciceCCKBBCO5jWdrkeiHticBoUT7bFrd8
iPJEoHp6mjPv0Y9TnghKGZb5AYcN7yS9YLCz6sOb8sw45QXDVN30Yee7dpzy
doPSpXxUla7F/wH2xncY
       "]]}}, {}}, {{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.011000000000000001`], AbsoluteThickness[0.8], 
      AbsoluteDashing[{8, 0}], LineBox[CompressedData["
1:eJwt0mtIk1EYwPHp1HlZ4mXmpja3VwuLbMY0S/fuPJZkRBcmKxZpqGlEdrFh
0ayZhjcQmyZNw0uKStJy4oXUMrOZc3kLrbCkIC+UoaKWLrOkeveeD4fD/3z4
cc7hESZcik6yZjAY4v+L2q9z9FETaVmor2p9eoE1iSbTqIN+1PKJ8IplfUBS
x7GaFHIcdZ/oDxx2GEE5s7J2fvYU+rJrUT3UbURzVM5+Q6b11guqoWdoa4zG
sBKwiPLPui3N+LegWCpjfiBj/gxq961HhVRqzOh4ZLqr/UgF6qHS8As5VQx0
dLrdQWYqV/6go6WiWrU6G1mux2HARbKkdr+LCllSbwUFeq3OoDuPDlAZxQQ2
8XO4wiMOWXLCBpRi/y3nWmSIfp8d5LEUBpH3PuzZw2Nzw8eosGDsOcA267VE
d6vN2HMCVdrzlwmJHthjwyq77XbGKVvsOUOPPLy4c2GZ/h5HF3AQJC8l8qel
lhxzAaeQ16uB5lFpLZU1rhAYkDvgk/tCepnKFDcIt9POB5kapTTgDqLtc+GV
e8uxx4HMdmJdWpeHPQ4UGPnuSZwr2POAR++bewf18djbCNXlB/dc4x7Gnics
9RZGzKhCsceFrlFeWE8xgT0u6L6y5WXv2NjjQXNTFtr5fYWkPS+QPxC9Kor/
TNKAN5w+pkfa330k7flAug5uFoU2kbTnA7JgOeJLS0na2wSDT1y5E50Z2OOD
zX1xgvLhGez5Qj07MlfDO0JmU/NkK4Abd5PHr94Tk5Z5ShbAU7FJYWLxyGhq
vEYEkFqlbJtX/JVQKdstBOYa840RTUl8KaBSCF2Zq6PVO/oktEfArboidUOc
TkJ7BESEMZ3LWjUS2iOgRCgL0jGUkg6L5wcnl4m33mw59vygu1GQumE6BHv+
cEigyClI8ZT8A2d/Zvk=
       "]]}}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  AxesStyle->{{
     AbsoluteThickness[0.8]}, {
     AbsoluteThickness[0.8]}},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Cmr10", FontSize -> 15},
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 10.01}, {-1.0526315789473705`*^-12, 3.0965404376044696`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.6724017421517005`*^9, 3.672401790207505*^9, {3.6724019107505584`*^9, 
   3.6724019386043434`*^9}, 3.672404338858345*^9, 3.67240772334676*^9, 
   3.672407801613586*^9},ExpressionUUID->"ecac3b92-853f-4b27-8739-\
37736c07b6dd"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"p00st", "=", "p00"}], ";", " ", 
  RowBox[{"p05st", "=", "p05"}], ";"}]], "Input",ExpressionUUID->"ef8a1162-\
be5d-4153-96bd-fdd6101de5fa"],

Cell[BoxData[
 RowBox[{
  RowBox[{"p00emw", "=", "p00"}], ";", " ", 
  RowBox[{"p05emw", "=", "p05"}], ";"}]], "Input",ExpressionUUID->"802e4257-\
1fca-4e40-a530-9908247924b6"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"pr", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "5"}], "}"}]}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{"pf", "=", 
  RowBox[{"GraphicsGrid", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Show", "[", 
         RowBox[{"p00st", ",", 
          RowBox[{"PlotRange", "\[Rule]", "pr"}]}], "]"}], ",", 
        RowBox[{"Show", "[", 
         RowBox[{"p05st", ",", 
          RowBox[{"PlotRange", "\[Rule]", "pr"}]}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Show", "[", 
         RowBox[{"p00emw", ",", 
          RowBox[{"PlotRange", "\[Rule]", "pr"}]}], "]"}], ",", 
        RowBox[{"Show", "[", 
         RowBox[{"p05emw", ",", 
          RowBox[{"PlotRange", "\[Rule]", "pr"}]}], "]"}]}], "}"}]}], "}"}], 
    ",", 
    RowBox[{"Spacings", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Scaled", "[", 
        RowBox[{"-", "0.05"}], "]"}], ",", 
       RowBox[{"Scaled", "[", "0.30", "]"}]}], "}"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
  "\"\<C:/Dropbox/mystuff/cred/ECMAScndRev/IMdest.pdf\>\"", ",", "pf", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "500"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.672154522584648*^9, 3.672154522743664*^9}, {
   3.672154560761465*^9, 3.6721545652719164`*^9}, 3.672401950142497*^9, {
   3.672407983893812*^9, 3.672407996486071*^9}, {3.672408078890311*^9, 
   3.67240808668209*^9}, {3.6725726582236447`*^9, 
   3.672572665967419*^9}},ExpressionUUID->"8f8f8aee-c67c-4894-b719-\
a347ae5c7a4c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "5"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6724019445459375`*^9, 3.672401969557439*^9}, 
   3.672407807517176*^9, 3.6724079999404163`*^9, {3.672408083189741*^9, 
   3.672408087063128*^9}},ExpressionUUID->"c13bd7ef-bb7f-4223-92d7-\
b06c75ec9c47"],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      GraphicsBox[{{{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.011000000000000001`], AbsoluteThickness[
           1.4], LineBox[CompressedData["
1:eJwt0ntIU1EcwPGZD9ZcbubMZb7mRCdBIUVlde/5KebCpqCYOdpILTF8rFVK
YJqvjOaD1cSCYrMyWZAtFUOF/lhbSmzCtMxXPtJJtWbrMV8z/6i7e/84HL7n
jw/nHH68vEsZ+dtoNNqB/4vYr3N0woXym8g8ogmOHaLDYjlxYEJxN/Y6baWe
gDMm2uXYNAqto2O9njS4ZU/vD6u3orOlwqjuqr9omUi7DXV+ihFMpWygWInS
sCr4heQzK8bU/lUkJVLiRI3FJpdvjhPdIVK5hljRalCzfyMjkQYXapHt2+or
/4HWiFzdQqZm18eEuW/IfT0ODUTDlu4O+RJyp84D5g2bWn/xZ3SSSKEnwJyf
2Vwyhdy54AVlo62ypfgPiHyfD5xiGCQbicOUR4eF4qE1fdxbytsOrKzcE7ns
15TnCyJ5vJd9vYfymDD7Xqntdj6jPD+IFaTlSFfakPt7GGxoGNY+2OFoQe6c
YINRq5qUHr2NnhLZ7g9VNQPMov4KdJlI+U7QA3d066Eckf8bANpsRpPkTR7l
cUAa+HN/dlcm5XFAWDVoaUxLprxASNEbz9TUH6a8XXDabsnoSBJQXhAYUjQj
T2q5lMeFa6KLYd44nfK48Mp6jB9UuY6T3m4QZ9uqWalfcNILBg9zQ+1z/RhO
ensgZ5rvKHAYyGSEgFaTda7Z0YWTXgjYmsZfNPaoKS8UCsdnDo4rFJQXBiaf
tMELijLKC4dZVefLe5ZcvJ6YJ+8IeMzsky1aRbh7nooiQKxj9uZvHsIziPEa
jQAssC0mYZmHE5l+hAfv1Mll4iJfPJwANDxIkv2Zr7i7gpFeJKiMk/1fE+cw
0osEV8F9vWpsECO9SJgJUGTSrDpswO3xobBAdhUvacVIjw/RddWt36MrKS8K
jrMeKbOvnMf+AcRbdgc=
            "]]}}, {}}, {{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.011000000000000001`], AbsoluteThickness[
           0.8], AbsoluteDashing[{2, 2}], LineBox[CompressedData["
1:eJwt0ntIU1EcwPG5Wbk1Y9p0j3zsYWL0UHoxtHvPb39NwgjNxZxaIpVakUoo
ZRppm4lhDkEzpdDW1P5wItXahMQ007RSQRtNl65pvsoVMs1qVHf3/nE4fM8f
H845/MSZuUln6TQa7cD/RezXuEaFo0iDOrktjZnKLfC5iDgYQvPzHOurI3TA
WVZ9HmZDFZYA2f5ZDypfTjSHaZ3IQD++UFy1gb4SubyIbgsjHVcK19CutOpe
d9R3VEEvVkevr6J0ItNWUaPnoI3V8QPpiKxeQ+XJ/kzV7ArqI7J3A7XGaZ62
X1pCa0S6/yB5VKVCHvAFea/HpUFsQj2vyeVA3jT6QENfaoJUPYXiiVQwQJiS
HHlqYAJ50+EL0a59XKN8FJHv2wwZ2RbUXDtAeX6wJ9ItXGnqoTwmTEVpi8ve
mihvK2gjTG9Ks4yUx4aUpauX87v0lLcNxoeYI4Jv9cj7PSwOFGZIxj6230He
tHJAN4GlM7LK0CMi9QFwZudhGaeiAOUTmRcIOh3Ts1Cbjcj/3Q58y5NfQzmp
lMeF6wyNq9V+jPK4wO7zrJeOIMoLgkp5XOehmhjKC4a/3Mf+2XMiyuOBaqJr
eM7OoTw+xHQm55hLaJTHh08lJjG73oWTngBG6ji2m212nPSEoDGdqA48OoyT
3g5o91vSP7xvJpMVAj1in3fB/Qac9EJgukCgeD1TQ3mhwJ8RT5/zv0F5YRD6
QSEQ9J+nvHBwov6OZqcS1xLztEkEgWyDAauS4955uiCCUdtduaxhN55EjNeY
CDYuatRt8UE4kYkyMZzcVvfezaPh4QTwQAylo72nu+3zGOlJIFZqeZmuHsNI
TwItk4v39N1mjPQkoMqcfPYioRmzeD0pDLKUqr3mWxjpSYFn/P2zyplLeREw
+HycYfVVYv8ASzxwBA==
            "]]}}, {}}, {{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.011000000000000001`], AbsoluteThickness[
           0.8], AbsoluteDashing[{8, 2}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwBmIQXS2yzv1hVYv933lMJgdYmB0eVYEETtmHSO1asdX9
r70d1/XFBba37GOmVzxjmfvdvu114A651sf28e+Uzitf+mz/BsR9/dJ+xvRU
Xknej/aaMf2Hvmp8sLfVD8/92f3WPhbEjflsz3jAeGVN5kv7CSBu/zd7pdm/
/jVWPbU/DOIe+ml/XH1Z7r1dD+2/gbhf/9jf1DWOv1lzxx7sPBEGB4arH7Y8
s75mD+auY3Rwb3E7W3njgr0HiOvO7LBElLmp9dgJezD3IYtDueU11q3rD9pD
/Mfm8CWPpWZZ6w6oeRwOrV+X/ohq2QA1j9NB9NiGgOyFS6HmcTtUPp7cId83
G2oej4PMQy/tdtGJUPP4HNJy9k2IXtRiDw4eLgGH6PDNglu9KuzB3OsCDv3f
j7+9+iTbfgmIu1jQ4ev5h9HBzvH2hSBugZCDqSj7gQqZQGj4Cjsse3GJP8jP
CWqeiMPPKeYeM9WMoeaJOOhqZD9nn6UMNU/U4WFJwO6excJQ88Qclib77+lx
YYaaJ+4QvbNkbXvLJwiXS8JBnWXxRJOCh3YQ8yQcYv8FuJtLXLCDmCfpoKRm
3GAov9cOYp6Ug3+7o2vMlZV2EAOkHf5XnDpqWDYNap6Mw4nbFpJs6s1Q82Qc
lCcxOyYyF0DNk3WQMNX9ftIxCmqenION7p/lr6RdoebJO7DzOh6VWmJg1wpK
T6wKDk6O+0XSdknagdNTtoKD5I96ofkNzHZBoOR1UcGhn/9y0qe/b2xB3EAL
RYd3X37I5ShetZUHGTBP0eH0Apcz14z32ULMU3Jg0OedIae11BZinpIDx21T
z5WivbYQ85QcbFk113nMKLbdCTZP2cHli/r+6MeRUPOUHY5Hu0h1HnGAmqfi
UBvu28/uo2oLAPnaY/U=
            "]]}}, {}}, {{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.011000000000000001`], AbsoluteThickness[
           0.8], AbsoluteDashing[{8, 0}], LineBox[CompressedData["
1:eJwt0mtIk1EYwPF512XqdKa26W4ONKmFFY3Yu/OMLjYjxiQSTUkyE51XzAum
ieIqlzn7kNhNC224BJuzloYFLWZlls2mokLl7K7hrOYthXovHw6H//nw45zD
wzuRn5DhSqPRdvxf+H6G2RU3XV6LdOIhFsvbjuzl+MEgGviRuZRUOIGk9PG2
AmwSTbxd3LOXN4LOzSp7I9QzqLZr/3wFbRDN4Tn7HSULOYr1djOKTtGanVEO
5B9c5xBpHqFUPFN+oxZfHTu+1Yga8dQuoqDaHPNAqx49w9O8gr44BRYX8W20
iKdzDVk+yfUvLjYh4npMGqyvFiQu9dYjIrtcQJlaUnFksBodxDPODQ7XzXB9
8ooRkdPuoEjvVmexsxD5Pk8ofun3TdSeQnnewEjO7XgwoqA8H+B22JylEhnl
bQB5mbhybXcs5fkCp6HTduANn/L8wKuhc1a7HIiI76EHwOcZeo/ooSsicjwA
PN3fz0Uzfknb8WxjgCB012pk0LS0EM+CQJj0jtrpuD4sJf83CFRbp+Qed/vJ
pDPBOWRkL5fppaTHhBxLjP9rURPlBcPJxG6VZqGG8jbBpY+atXumfMoLAf3x
urFXnsmUFwq5h2Sl2xb2UV4ofF3q32JQb6e8MBCqjKfs2jDK2wwDihum4nQ3
ymNBVVx4jHFsDiM9NjAay0drvEYx0mODrcRQKg98gpFeOJRdZvCszDsY6UXA
sT/2D/y/9RjpcUBXbS0KuVCEqfF58uCCTcvTrAwnYcQ8qbhgjt3oGt0HWAI+
XlYucGy3sh1SIYanUsyDzKka1tMSOsbBgRYeXBnNmLdGOSSkx4fnhptesqR3
EtLjw33u436LySQhPT5cPRtvOB95TdJHeALQGYQ/V6sqJaQngOXJ+LzTyjTK
i4S07KPNjB6Z5B+O/23C
            "]]}}, {}}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->{True, True},
       AxesLabel->{None, None},
       AxesOrigin->{0, 0},
       AxesStyle->{{
          AbsoluteThickness[0.8]}, {
          AbsoluteThickness[0.8]}},
       DisplayFunction->Identity,
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->All,
       LabelStyle->{FontFamily -> "Cmr10", FontSize -> 15},
       Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
              Part[#, 1]], 
             (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
              Part[#, 1]], 
             (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
              Part[#, 2]]}& )}},
       PlotRange->{{0, 5}, {0, 5}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.02], 
          Scaled[0.02]}, {
          Scaled[0.02], 
          Scaled[0.05]}},
       Ticks->{Automatic, Automatic}], {174., -133.49534156997728}, 
      ImageScaled[{0.5, 0.5}], {360., 222.49223594996215}], InsetBox[
      GraphicsBox[{{{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.011000000000000001`], AbsoluteThickness[
           1.4], LineBox[CompressedData["
1:eJwt0l1Ik1EYwPG5zVgzdNPVlk7d1D7MzM8LwbbzVKQ1MvErSJ2KJYQu/Egp
FExskyaaw1zUFMkmUoaz1ELNl9mGWSqkpEgukS29ELNCN8kpVu/ec3E4/M/F
j3MOjzi/OLWATqPRYv4vcq/iGRKtlUqkdY/eezvGAlsleTCBMoZf7vZ8oYOU
Pa8vkSygovtdLYWhu6huLWUwQPUdafzTZLYhO/pB5toqcmYalHnMnyg0u8nk
OP4bmVv97FX5K0hOZvYmoqWFm/f+LCINmU1bqExGsIafzyIzmaZt5MjUrDW7
TaEtMh27KJbLEoq7Tch1PR4Nlm4rxo3lg8iVBjcwWT0tk9W96AKZiQxY4tTP
Gdf1yJVWJoR6BKwwxh8j6n374Ej6XLnk7APssUBtq/22ElKLvf2Qpp2vpssr
sOcB1femw+6+uoG9A2D8lWqx/c3CnieoM+iytqPJyPU9bA4My6/pW/cAuXKe
A0s3dRPCU9Gok0w9F66Yzyn7vYJRKZkl3mB8ymfXt/gg6n99YGPDeFHTx8Ae
D2g1Jx26gk0p5fEgCrV1O3ttUso7CDpL/GypbkZKeYegkdnLV8WMSimPD4qp
sMVSYQ+VbAG8qOsyfKh5gj0BtNujzI3vVdg7DK8ZOYXX2WXY84XogRPMYoYc
e35QGZnn0DYkYE8Il67KkhoskdgTwkLOV/t5rgB7/pDcuZjTH0vDXgBEdex0
ItGyhAIC4ZFHWHnu+phERc6Tuwjq05dP850dEtc8FYlg4F14Vu6zJEkqOV4z
IvDqv6XtUJYRZKbEieFMxOfYikkFEUgC7WJwM9VMCTh5BOUFQbNezRRykwnK
C4KP/u3xk5p4gvKC4E3EHbkv/Rgx5PKCwfdywidrkjf2guGheNQ2vb0zQnkh
oFiN61Prl0f+ASXDb+w=
            "]]}}, {}}, {{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.011000000000000001`], AbsoluteThickness[
           0.8], AbsoluteDashing[{2, 2}], LineBox[CompressedData["
1:eJwt0mtIk1EYwPHNMuctN93ytunmJRWVMjG03M7jhzCHCl5Sm0omDl2SmyFU
WmLkpbB0WsNRS7MZBPPyyZm0lViTViQopdJQmkqZ81ZjQrl1efeeD4fD/3z4
cc7h4ZVLc8UuFAol8f8i9gbmcLq5vhklMR1Ntnw3WK4nDt4hAz/TcFFNBYHH
vFrG/4yiw8eX8lN/o1ZLzvOQlhW0mvHNpy3BijaItHxHvmxrWU6fBcWUdE7a
oneQYsjtRfadFVRKZIkVTQwOP+AmmZCcyM5dpPNOLDY+mkWviZz8hZIf90ir
PY1ol0ibHa0VTjm2OiaQ83pMCoS6t2kqm0eRM4epYHZkW+OvatBpItP3wWjE
km32RD9ypnk/8ES9FkOKApHvOwBnK2Y2Y4ZuY48G7XuLutTGRuy5g1Cj/aMw
1GLPE5S0ZYohrwJ7XpBWF9lmny7A3kFg3WvZaA/MQM7v8aCDdq50fIp5Ejlz
ng5zWhd5rToODRCpZsDx7kq/okEOqiVS5gsKjVL2in0Qkf/rB6IrseXidQeZ
HkyI8i9KecPcFJAeE1T0vQuSpyYB6bFAxA+SC0eMAtI7BI3iqdWorDEBCfgD
Je0mI75vAHsB4C+faQh+24W9AKh6lqUZ+Xgde4HQVVM4KBFWYS8IaAy1sSMy
D3vBMF8sqf4SyMceG9JFVmpfQiT22FBXfES1nemNPQ7UCLo+2L/+5JNeCAiq
3neq/n7CQCj4qtZczdGj/BZinly5cCbmnNT0sJXvnKdqLoyVaafvRsn0ucR4
zXBhTRzLp49d0hOZk8wDms81Bj2uUh9KAL08uJzEukG9X6gnvTBYZC10FyhP
6UkvDHrWNfJt6THshQHraFd/iImjH3d64SB5qVp1OeyGvXDgKJ943RL+0JFe
BOyc3wpusi/o/gEdsGz9
            "]]}}, {}}, {{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.011000000000000001`], AbsoluteThickness[
           0.8], AbsoluteDashing[{8, 2}], LineBox[CompressedData["
1:eJwt0mtIk1EYwPHZpuiyoTmdldNtBik6lDQL6t151EonJmg1LS3UmqVGM8WK
LZqZBik4SQhiItGMMfNWuZryCjqzcCOWmZnXmiM1Tai8NMO03suHw+F/Pvw4
5/AIcxVp8i0MBiPq/yJ2Fbc1wa6sQBvZvz/KWUyYVhIHFuTMYU92pKwjCXtE
V4SNISefc/eTcRndWUg1BVY6kOrWYGn7wCL6TuTCN6TApLMxnK8oNEtjXgn5
gdqi1eqQ2El0hsisJWSIXMCHnEOolkjNKip+32/utlpQH5HmNdTd5L1HZuhF
q0SurKPZsHZz8ucXiLwelwEtNcwljX8LIrPVBUQ5HZoo8SOUSGQCExQnziae
P3YfkWlnQZXDJKueqkLU+9wAn8sQ/Hmjpj13OJ5tYkWUFNOeB8xeeHkz3k1O
e1vBu43n11yeTnuesGxv5CisUtrjAFOwIRX3HUTk97C9YKnkQcTVFDEic8QL
No/mF4TJAlEjkTpv6BLPjzcPcNAVIou2A1vRs1b5cENC/a8P6OyxX3LGF6lk
c2HYYKgQVkxIKI8Lea69mZ4tFgnl+UKPQN29V2GSUJ4fTATnrUfPPaY9HlQf
mbMa99fRnj/way7/en2jjPb8QW7bfB6jL6S9HcArvp1ZqpfR3k6IP2WNNPHj
aG8XXGrW59piw2kvAOw/Owu013xpLwBMYXi5sGsTozw++DwJTXplnsEoLxDu
JX0Y7m+wYRQQBH/dazN4kUaskpgnVwFcfyvd14VpMXKeCgUAktH8Hn0ZlkaM
16AAHOhkSqbvOYzI1ANCuKgLL+uciceCCKBBCO5jWdrkeiHticBoUT7bFrd8
iPJEoHp6mjPv0Y9TnghKGZb5AYcN7yS9YLCz6sOb8sw45QXDVN30Yee7dpzy
doPSpXxUla7F/wH2xncY
            "]]}}, {}}, {{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.011000000000000001`], AbsoluteThickness[
           0.8], AbsoluteDashing[{8, 0}], LineBox[CompressedData["
1:eJwt0mtIk1EYwPHp1HlZ4mXmpja3VwuLbMY0S/fuPJZkRBcmKxZpqGlEdrFh
0ayZhjcQmyZNw0uKStJy4oXUMrOZc3kLrbCkIC+UoaKWLrOkeveeD4fD/3z4
cc7hESZcik6yZjAY4v+L2q9z9FETaVmor2p9eoE1iSbTqIN+1PKJ8IplfUBS
x7GaFHIcdZ/oDxx2GEE5s7J2fvYU+rJrUT3UbURzVM5+Q6b11guqoWdoa4zG
sBKwiPLPui3N+LegWCpjfiBj/gxq961HhVRqzOh4ZLqr/UgF6qHS8As5VQx0
dLrdQWYqV/6go6WiWrU6G1mux2HARbKkdr+LCllSbwUFeq3OoDuPDlAZxQQ2
8XO4wiMOWXLCBpRi/y3nWmSIfp8d5LEUBpH3PuzZw2Nzw8eosGDsOcA267VE
d6vN2HMCVdrzlwmJHthjwyq77XbGKVvsOUOPPLy4c2GZ/h5HF3AQJC8l8qel
lhxzAaeQ16uB5lFpLZU1rhAYkDvgk/tCepnKFDcIt9POB5kapTTgDqLtc+GV
e8uxx4HMdmJdWpeHPQ4UGPnuSZwr2POAR++bewf18djbCNXlB/dc4x7Gnics
9RZGzKhCsceFrlFeWE8xgT0u6L6y5WXv2NjjQXNTFtr5fYWkPS+QPxC9Kor/
TNKAN5w+pkfa330k7flAug5uFoU2kbTnA7JgOeJLS0na2wSDT1y5E50Z2OOD
zX1xgvLhGez5Qj07MlfDO0JmU/NkK4Abd5PHr94Tk5Z5ShbAU7FJYWLxyGhq
vEYEkFqlbJtX/JVQKdstBOYa840RTUl8KaBSCF2Zq6PVO/oktEfArboidUOc
TkJ7BESEMZ3LWjUS2iOgRCgL0jGUkg6L5wcnl4m33mw59vygu1GQumE6BHv+
cEigyClI8ZT8A2d/Zvk=
            "]]}}, {}}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->{True, True},
       AxesLabel->{None, None},
       AxesOrigin->{0, 0},
       AxesStyle->{{
          AbsoluteThickness[0.8]}, {
          AbsoluteThickness[0.8]}},
       DisplayFunction->Identity,
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->All,
       LabelStyle->{FontFamily -> "Cmr10", FontSize -> 15},
       Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
              Part[#, 1]], 
             (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
              Part[#, 1]], 
             (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
              Part[#, 2]]}& )}},
       PlotRange->{{0, 5}, {0, 5}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.02], 
          Scaled[0.02]}, {
          Scaled[0.05], 
          Scaled[0.05]}},
       Ticks->{Automatic, Automatic}], {522., -133.49534156997728}, 
      ImageScaled[{0.5, 0.5}], {360., 222.49223594996215}]}, {InsetBox[
      GraphicsBox[{{{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.011000000000000001`], AbsoluteThickness[
           1.4], LineBox[CompressedData["
1:eJwt0mtIk1EYwPGVU3TzMtvKu3NqkCYp6Ydp7j1PNNvCVmqikBN1ZSpGMyUt
Q8zoNXKWFWRIKLoNKVCjjLwQZdMswykiuTIQp23iJZLZhrpm9e49Hw6H//nw
45zDI1AoMwp3MxiM+P+L2q/zeiTG6lvoney19SiXCQvV1MFnlDjY8N1sYwDB
MmjKRLNo+u2MS5TgL6pfTe8PJRdRcZxJ4yXcQWtUri6jpFf93WdYOyhK3qSz
HlhHggHfs7YJB8qlUr6BukZGLNm+DnSfyiYbOv6bkyvpsKNhKnVbKGBw5KZ3
3RayUWn9g+ZmZ0a/TduQ83o8BkzH5ZDMiQ3kzJ5dEK1gq1KeriMplRIXiHaP
iK2PWUXONDLhnJLFzKkzIfp9bjAzTroeIeex5w6pJ8f0dZ1fsecBUO+d0Do3
hT02WNLm5L9ix7DnCSsNWT2Hxe+x5w0/QlTbp1l9yPk9LA6IT/GHrOvdyJkG
DrTUyBITrGqkpVLjC636haWu4sfoMpVle2DJ55PJHt+I6P/lgq6z0rO0+Qb2
eKAqnjebfSqwxwOhmNu6UFKIvb3gIHmZIbezsbcPvPLMCnvqCez5wZqyXzfe
noQ9f9DmDU0OVxzEnj/o3gSqiwaDsBcAV8Sjdnk5G3uBcKlXZKno2CZoLwiu
Scr5jsxlOlnBILFrhDXtBoL2ggHlr8UuPflA0F4ItOXLxQ8KegnaCwXDw3J9
qGcH9viQkOxBxpTcJUhqnlzDoOlZ7Re18SrhnKfSMHhxb5Ot154nMqjxmgqD
R0VV6kPjaQSV6UIBVCoLqpiTSQSfAtoEcKxWJVjZjsReOOieW3LdAjnYC4ef
LUP5H5M3RbQXDsyL2r62RaNowOlFQIpElnXBNCaivQho3O/nrih4KaK9SLgj
k0q5zS2if2uMcug=
            "]]}}, {}}, {{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.011000000000000001`], AbsoluteThickness[
           0.8], AbsoluteDashing[{2, 2}], LineBox[CompressedData["
1:eJwt0ntIU1EcwPEtZ+gUH9t8VEu3uT9MVmFKGnLv+bGMWVDmJHv4nkSgaAtT
S4vUplhYLqUSRam0JWU6DSo1V+nSDB9of2hWkpvJUmeWeNOlUHf3/HE4fM8f
H845/MSqs8rTm1gsVsj/Re8FghbFdL4GPTycNq7uZ4Mpnz74gDjuBa1uyxuI
5I43qIlJlCIN6Dx18y8qnY956VdiRgNKS8qVbza0QOf8D7Sxal00D9rQjoSK
npXAJTSRe49ov2tDiXQmLCPLcKEx6dMa0tJZQaF3kaw7XpmrqJfOnjUU39t8
8FoihSg6V9YRn/vEcn9sGdmvJ2CBVJ461cr+hezZwobA22vtO+ULKIpOhQO8
miuzNb6eRfac5oBPeZgs++00Yt63GbKeabop8yT2nCBOOG/NMX7EnjNcONSV
7BQxiD0X0LW6z3Kqe7HnCtEmQ5jv+U7suYHG5P1YmNqG7N/D9QD1GW3mPkKH
7DnuAScq//BedNWiRjobPCHZA95wv2rROTrVPHA6WbV+wEGD/5cPGwp57J7g
POwJIBd0Rtb+dOwJILR4dzePn4g9Lyi/Ss1Ql6Kx5w17K1zrQvWAPR9IytFL
2cpg7PlCev2Xo7paMfZ8oQ81H3O87om9LSDrGy5R+LOxtxVU5WncStUSyXjb
YLF0l7naMMUkVwjmolxXSdQgyXhCMB3RqYaKO0jG2w4zx5tGRrU6kvH8oCUv
MoRTVYU9f2DbIi/qdYVkCT1PjiKYS/jMc36fQdrnKUMEM0EZQ1GdcaSSHq9R
ERhRXcpIhJykMyZcDC6ypu9tehnpTwP1YrDGhWuzJd7Yk0Dho3hnysDCngSK
nrLR6ISFYDwJBF2u4av4Y0SH3QuA2N/N1M+BDoLxAuDWwPMbDtwHBONJod9P
lGU1lBH/AGDRcPQ=
            "]]}}, {}}, {{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.011000000000000001`], AbsoluteThickness[
           0.8], AbsoluteDashing[{8, 2}], LineBox[CompressedData["
1:eJwt0n8s1GEcwPE7J+PCxCm/75fStZmzQ2f6fp9P+uESa2ftEro2+dGEJE1j
ReTHkqmMqyarTptmKdetUtMtLsmkWeUqjNNscuJShLlW3+/3+ePZs/fzx2vP
8+wjTD2ZkG7HYrFk/xe1F/PaY8xFF5E0qkPseX0RTRZRB/1opanWfdX2E5Fc
kzaP+Ip0pN7YoLOiSovyWUDFN/TYlvwm5YwVzVJp+Y7YewsE6hwrkqTUdS9u
taJOWzFb729FR6hM+YWSs0SntS1z6AqVdUuoTFHZncqbRT1Udq8g6cKt1Z2v
p9ESlYtriJOV1uTvPIXo6/FYsE/1KX6GNCM629lwWbOc4R07ghRUxnBg9GgB
6THxEdFptgf+lprCQzODiHmfA+Sqd+3xCunFniNEBsdeDZ98iT0n6JG88mgd
12NvPby48DcpKLsNe84QOBVUVFNxB3uu8Ei5EFo90IDo7+G6gdPB+8kj2ZcQ
nSY36A3wURh2lKAWKrUbwEmfFaaxz0enqMxzh6E+E6crLg3/rwf8TvrTOHZY
hT0eDKssxgE3BfZ4UL2962ZOUiT2PIHj62DfvHkb9jaCzHFMVX/cB3ubQJs2
eL5KyMWeF8TPZoraVCsk43lBQq20PN1zmmQ8b4iob5Pb8oZJxvMBjXTuwYdS
I8l4vhC+ql7OUOuY5PqBOTSMrRTfxp4fhPk58+YHa7DnD+/4+Y3BJYXYC4CQ
L1WG8rPHsMcH92taVe29A2QFNU/rBBAePb9/XB5J0vN0QgDW1ueSridiMoEa
ryEBSB/eyOiRu5JUKuVCGBA2y/RPlwg+BTQLocUlV+ZrmCAYTwT1Jq1LdEQf
wXgiEOveWn5IOgjGE8H7xAjj2qiG6KQ9MfQn5o9n7i7FnhjqooRr5wzp2AuE
Ibu7k5/L4oh/u6trWQ==
            "]]}}, {}}, {{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.011000000000000001`], AbsoluteThickness[
           0.8], AbsoluteDashing[{8, 0}], LineBox[CompressedData["
1:eJxd0q1PQmEUx/FHBafgmC/XFxBB1CCZYvGlYYWMxc1kACtUsOJfYIFMlorN
ZmKzgclhcGOwuRH0PEd/Z/s9292zzw3f3Xt2Mtfl4s28cy73+8hdCzr5QbV+
7v7OsCovXuCzSL9VOX2D70eFp1TjHf4Ujj7gbKnZmxx/wVfC0hh+EDan8LOw
9w1PhZMZ7D8vcBf/9uzMwZfC/ALsOQjB+n+LsPaWqLdMvSj1VqgXg/14Iquw
Z9/cFrbW4DthZR3W+W5QL6CeWXub1Nui3jb1dqhn1l6cegnq7VIvST2z9vao
l6JeGm7IPoX3Yb9Pt+airNerWVg4ycBpCTyatXdAPbP2zF3fO6SeWXtH8A8u
UKzj
            "]]}}, {}}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->{True, True},
       AxesLabel->{None, None},
       AxesOrigin->{0, 0},
       AxesStyle->{{
          AbsoluteThickness[0.8]}, {
          AbsoluteThickness[0.8]}},
       DisplayFunction->Identity,
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->All,
       LabelStyle->{FontFamily -> "Cmr10", FontSize -> 15},
       Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
              Part[#, 1]], 
             (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
              Part[#, 1]], 
             (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
              Part[#, 2]]}& )}},
       PlotRange->{{0, 5}, {0, 5}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.02], 
          Scaled[0.02]}, {
          Scaled[0.02], 
          Scaled[0.05]}},
       Ticks->{Automatic, Automatic}], {174., -400.4860247099318}, 
      ImageScaled[{0.5, 0.5}], {360., 222.4922359499621}], InsetBox[
      GraphicsBox[{{{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.011000000000000001`], AbsoluteThickness[
           1.4], LineBox[CompressedData["
1:eJwt0ntIU1EcwPGl17FNaVPnozl1DwMn4h8t8pF35+crm+uBCoKhpPkiE1Iz
tBlpNUdmsdJqDdQS0yxQUcNmdEH0j2oUYfhIrdQpmmgpmdpkSN7d88fh8D1/
fDjn8JOeu5iS58RisZR7i94rhV2Jc1odAs5uQaMHAVYtfWBBnXG2UjObBSre
RGsxOYWiDOyPCqUN6VeSzQE186i7L79Oe30DrdK5sozOPn7ChYFfSJFhGNoM
Xkfz/yKlbepFlElnxgZSj+cdulYyi+7RadhCYqd295AfE2iYziEb4vutv07l
jqAtOjftqGD6KXd7+R1yXE/IgpmDOecXqgaRI7v2wdzP+jhjVj86TmeiM4ga
m6o0XzqRI+cI8HYd775c04qY97HB5bR5USEyYY8DaUWHx2N6DdjjQmbbWnx6
203sucKbRiJcvVSOPTew3yKj3G8XYW8/hK1J0sb6s5Dje3gCyLVPzZuUqciR
EwJgB6WPHW1JQM/obHWHk7I6dbY1HJXQWewB0c68I6VfFYj5X08gZAVWTr4f
9oRAfNrZqS9xw54Qwo0dq6NLdhXjeUF29LdCO7WqYjxvkMZvJG3/mVYxng+U
1c54TRosTPJ84e1sDxH53KxiPF9osFzVP0ptx94ByOGbmjZfNWBPBBXZoXzW
72rs+UHw+t0EfmwR9sQw7KqX35lKw54YamvPVKZMxmDPH8peVvvrPoRgLwDc
Kq5oPBWe2AsETt93TdR7G1lDz5OLBMq3xv6qR2ZIxzxdkECcVNuRuztIptDj
NSIB/Wd9rM+CiaQzOUIKAvl0j2DwFBVIA83SPe/SwxZdKcV4MtAZX0zaLIUU
48mgmRIl3dBkUownA3L4QU9n4AlqwOHJIeBYrzhpMQJ7cjBZ08WEJQh7QaAM
Gw11uS+g/gNrx2rA
            "]]}}, {}}, {{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.011000000000000001`], AbsoluteThickness[
           0.8], AbsoluteDashing[{2, 2}], LineBox[CompressedData["
1:eJwt0mtIk1EYwPFtZuqUMHszb+mmIxQjRmFk+e48UTLBC2xCiqnDWyaJl0Lz
FiJLC8O0Eitzas1LmDpMl5cc5aW0JZNZtrSy3D6saZEpm4km9e49Hw6H//nw
45zDw03OFqexGAzGkf+L2ouJbuFi0VVUSUgfz7xmgr6IOlCjBvHTWnbgFhKw
dfIcch4Fcyb0retmVLEsGvAuNyB+kMwS9HkF/aBy2YTKl3rOCi+bUEB89ajZ
fwX13RLqbyzrUQKV8WvoOa/S/L3tE6qhstqCyE57pmXhHRqjcnQDHc8KqWEQ
U8hCpXkLnZC33f1aOoas1yMYIP+teT8rG0LW7GZCacQBCX+uB4VRKbQByf2K
Ux3SdmTNxR3wJK5wezizEdHv2wnqqqNJrdF3sGcP6fmRnW0e17HnAKsx/LjI
sivYcwSDXUEzbyAXe06gVM756b+lYm8XPKgsnOzixCLr97Cd4dmConT2TDiy
ps4ZGt4E100kCFALlfLdIP2w/Xekgo9yqcxxgZjht5uxTVz8v3vAIHbNs0t3
wR4BVRlFBaZpFvYISHRqUkdpVwW0txdSJKhs5LxeQHuuUHZo3DavXiugvX3g
nkkY7XNf0sl2g/he983TG10C2nODh6aO2pVH9dhzh9Tpc9pNx2vY84AoRcs9
XdIl7HkCTxvGl8ok2POC2kmRSvQzDHteUPexKtxu6TD29oN3V3HKepYn9rwh
OOBkh2WKhT0fiGU49PfNG8lyap5sOZD4pZN/W6MmrfN0gQMyljH/YEk7KabG
S8sBNhGRPSTMIKkUHePCr7RA0rn/osqHAhq54G9z85VmO1tFe77wZ5Cr1JUk
q2jPF/qTDYuKULGK9nwhIX0rWlMMqkGr5wdrmshohjEQe34wHvJCGVroij0e
ZM4oQnsTmap/YHd5MQ==
            "]]}}, {}}, {{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.011000000000000001`], AbsoluteThickness[
           0.8], AbsoluteDashing[{8, 2}], LineBox[CompressedData["
1:eJwt0mtIk1EYwPGpJXlpqZtm5mVTw2qDnBaVsJ1HG7puC/0kOl3O1cQuXrOc
Gl10djFd64MiKJI3lJxmZGq+lU5jdDFX6tTS8Eq2SFG8oWi9e8+Hw+F/Pvw4
5/CwZUkRFyxpNFrg/0XuWUxt2LgyF+1rGVSwipfQhJI8+ICedQa2JdbOI4Gt
sTKZP4ImZ+ovnzsxi1Sm8FbPvEkU3U/X3B+cQH/INM2iuvyG3K9l39EBSVHX
0v551PtmZIs//Q3FkClZRC1TfbxUziekJrNoGZlu5ztal+iQjsyuNTSzFuxC
vG9Hy2QubaA0uZ8saPU5Ml+PSYMHanpBSGMtMqfWAsSbFk+P15QjEZlhViAc
OCVJv/4EmXN8G8g07QlDwnuIep81+DITrbhNOdjbATf168HX+lKwZwPDoTYV
6yty7NnB47nF/tHASOzZg4ZbkTonO409OsjOzDdGSQXI/D22DhAl7/yhueWP
zGl0AJ4oxlSvZqMqMisdQfmzaqhJ7IRSyEx2ghK9/lVogyX+XwZYM5aFcVUL
VNoyIYTLGRAETAgojwkE74pEF20QUJ4znC17W+zHfSegPBdgjAyqLRMaBBSw
GxzijV65u0qx5wpXxTdEr7NU2HOFhcN2zTXDqdjbA0dKs9bjqmOx5warRnl3
PEOEvb0wmcG1/8wLwJ479NSLPXYK3bDnDmn+hayYaQvseYC6w9X3hWqGT3me
oFdZMWM39HwK8IKC1jVVy9Fqfh45T9tZkNl9KPPuRSnfPE+XWPBSOzq19TCN
iCDHy8CCv1+mzyt6kggyw4+xQbOpXJHQZYQXCZSz4WOAu1uGNpygPG+QSDME
nGZEUJ43BKUbfhc2HcSeN/jX6HojFc5Em9nzgZzsRydLlDTs+cCYtPaOIvtX
B+X5whgnoaeuzNDxD6KmdrQ=
            "]]}}, {}}, {{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.011000000000000001`], AbsoluteThickness[
           0.8], AbsoluteDashing[{8, 0}], LineBox[CompressedData["
1:eJxd0q1PQmEUx/FHBafgmC/XFxBB1CCZYvGlYYWMxc1kACtUsOJfYIFMlorN
ZmKzgclhcGOwuRH0PEd/Z/s9292zzw3f3Xt2Mtfl4s28cy73+8hdCzr5QbV+
7v7OsCovXuCzSL9VOX2D70eFp1TjHf4Ujj7gbKnZmxx/wVfC0hh+EDan8LOw
9w1PhZMZ7D8vcBf/9uzMwZfC/ALsOQjB+n+LsPaWqLdMvSj1VqgXg/14Iquw
Z9/cFrbW4DthZR3W+W5QL6CeWXub1Nui3jb1dqhn1l6cegnq7VIvST2z9vao
l6JeGm7IPoX3Yb9Pt+airNerWVg4ycBpCTyatXdAPbP2zF3fO6SeWXtH8A8u
UKzj
            "]]}}, {}}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->{True, True},
       AxesLabel->{None, None},
       AxesOrigin->{0, 0},
       AxesStyle->{{
          AbsoluteThickness[0.8]}, {
          AbsoluteThickness[0.8]}},
       DisplayFunction->Identity,
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->All,
       LabelStyle->{FontFamily -> "Cmr10", FontSize -> 15},
       Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
              Part[#, 1]], 
             (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
              Part[#, 1]], 
             (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
              Part[#, 2]]}& )}},
       PlotRange->{{0, 5}, {0, 5}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.02], 
          Scaled[0.02]}, {
          Scaled[0.05], 
          Scaled[0.05]}},
       Ticks->{Automatic, Automatic}], {522., -400.4860247099318}, 
      ImageScaled[{0.5, 0.5}], {360., 222.4922359499621}]}}, {}},
  ContentSelectable->True,
  ImageSize->500,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{{3.6724019445459375`*^9, 3.672401969557439*^9}, 
   3.672407807517176*^9, 3.6724079999404163`*^9, {3.672408083189741*^9, 
   3.672408087105132*^9}},ExpressionUUID->"2337bff1-bb8e-4716-8c97-\
a5115f6740a0"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Export", "::", "infer"}], "MessageName"], ":", 
  " ", "\<\"Cannot infer format of file \[NoBreak]\\!\\(\\*RowBox[{\\\"\\\\\\\
\"IMdest\\\\\\\"\\\"}]\\)\[NoBreak]. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Export/infer\\\", \
ButtonNote -> \\\"Export::infer\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{{3.67240808327975*^9, 
  3.6724080871111326`*^9}},ExpressionUUID->"2ac124f1-19e0-4549-ac20-\
7b87f395be22"],

Cell[BoxData["$Failed"], "Output",
 CellChangeTimes->{{3.6724019445459375`*^9, 3.672401969557439*^9}, 
   3.672407807517176*^9, 3.6724079999404163`*^9, {3.672408083189741*^9, 
   3.672408087112133*^9}},ExpressionUUID->"e5dde27e-31d8-416e-8731-\
5452de67ffab"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"style", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AbsoluteThickness", "[", "1.4", "]"}], ",", "Black"}], "}"}],
       ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AbsoluteThickness", "[", ".8", "]"}], ",", 
        RowBox[{"AbsoluteDashing", "[", 
         RowBox[{"{", 
          RowBox[{"2", ",", "2"}], "}"}], "]"}], ",", "Black"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AbsoluteDashing", "[", 
         RowBox[{"{", 
          RowBox[{"8", ",", "2"}], "}"}], "]"}], ",", 
        RowBox[{"AbsoluteThickness", "[", ".8", "]"}], ",", "Black"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AbsoluteDashing", "[", 
         RowBox[{"{", 
          RowBox[{"8", ",", "0"}], "}"}], "]"}], ",", 
        RowBox[{"AbsoluteThickness", "[", ".8", "]"}], ",", "Black"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AbsoluteDashing", "[", 
         RowBox[{"{", 
          RowBox[{"2", ",", "2"}], "}"}], "]"}], ",", 
        RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", "Black"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AbsoluteDashing", "[", 
         RowBox[{"{", 
          RowBox[{"8", ",", "0"}], "}"}], "]"}], ",", 
        RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", "Black"}], "}"}]}],
      "}"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pprob", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"pcrp", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", "}"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"betlevels", "=", 
    RowBox[{"{", 
     RowBox[{"0.05", ",", "0.06", ",", "0.1", ",", ".5"}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"AppendTo", "[", 
     RowBox[{
      RowBox[{"pprob", "[", 
       RowBox[{"[", "j", "]"}], "]"}], ",", 
      RowBox[{"ListPlot", "[", 
       RowBox[{
        RowBox[{"Transpose", "[", 
         RowBox[{"{", 
          RowBox[{"grid", ",", 
           RowBox[{"100", 
            RowBox[{"prob", "[", 
             RowBox[{
              RowBox[{"betlevels", "[", 
               RowBox[{"[", "ib", "]"}], "]"}], ",", 
              RowBox[{"4", "-", "j"}]}], "]"}]}]}], "}"}], "]"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
        RowBox[{"Joined", "\[Rule]", "True"}], ",", 
        RowBox[{"PlotStyle", "\[Rule]", 
         RowBox[{"style", "[", 
          RowBox[{"[", "ib", "]"}], "]"}]}], ",", 
        RowBox[{"LabelStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"FontFamily", "\[Rule]", "\"\<Cmr10\>\""}], ",", 
           RowBox[{"FontSize", "\[Rule]", "15"}]}], "}"}]}], ",", 
        RowBox[{"AxesStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"AbsoluteThickness", "[", ".8", "]"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"AbsoluteThickness", "[", ".8", "]"}], "}"}]}], "}"}]}]}],
        "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"AppendTo", "[", 
     RowBox[{
      RowBox[{"pcrp", "[", 
       RowBox[{"[", "j", "]"}], "]"}], ",", 
      RowBox[{"ListPlot", "[", 
       RowBox[{
        RowBox[{"Transpose", "[", 
         RowBox[{"{", 
          RowBox[{"grid", ",", 
           RowBox[{"100", 
            RowBox[{"crp", "[", 
             RowBox[{
              RowBox[{"betlevels", "[", 
               RowBox[{"[", "ib", "]"}], "]"}], ",", 
              RowBox[{"4", "-", "j"}]}], "]"}]}]}], "}"}], "]"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
        RowBox[{"Joined", "\[Rule]", "True"}], ",", 
        RowBox[{"PlotStyle", "\[Rule]", 
         RowBox[{"style", "[", 
          RowBox[{"[", "ib", "]"}], "]"}]}], ",", 
        RowBox[{"LabelStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"FontFamily", "\[Rule]", "\"\<Cmr10\>\""}], ",", 
           RowBox[{"FontSize", "\[Rule]", "15"}]}], "}"}]}], ",", 
        RowBox[{"AxesStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"AbsoluteThickness", "[", ".8", "]"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"AbsoluteThickness", "[", ".8", "]"}], "}"}]}], "}"}]}]}],
        "]"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"ib", ",", "1", ",", 
     RowBox[{"Length", "[", "betlevels", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "1", ",", "2"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"pr1", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "40"}], "}"}]}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{"pr2", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "100"}], "}"}]}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{"pf", "=", 
  RowBox[{"GraphicsGrid", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Show", "[", 
         RowBox[{
          RowBox[{"pprob", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", 
          RowBox[{"PlotRange", "\[Rule]", "pr1"}]}], "]"}], ",", 
        RowBox[{"Show", "[", 
         RowBox[{
          RowBox[{"pprob", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", 
          RowBox[{"PlotRange", "\[Rule]", "pr1"}]}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Show", "[", 
         RowBox[{
          RowBox[{"pcrp", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", 
          RowBox[{"PlotRange", "\[Rule]", "pr2"}]}], "]"}], ",", 
        RowBox[{"Show", "[", 
         RowBox[{
          RowBox[{"pcrp", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", 
          RowBox[{"PlotRange", "\[Rule]", "pr2"}]}], "]"}]}], "}"}]}], "}"}], 
    ",", 
    RowBox[{"Spacings", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Scaled", "[", 
        RowBox[{"-", "0.00"}], "]"}], ",", 
       RowBox[{"Scaled", "[", "0.30", "]"}]}], "}"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.672402013391822*^9, 3.672402048450327*^9}, {
  3.6724020790593877`*^9, 3.672402232857766*^9}, {3.6724022766501446`*^9, 
  3.6724023109885783`*^9}, {3.672402486133091*^9, 3.672402571876664*^9}, {
  3.672407746110036*^9, 
  3.6724077720646315`*^9}},ExpressionUUID->"a389518f-9a2b-49ab-8ec5-\
32f955cef1f8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "40"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6724021554450254`*^9, 3.6724021902875094`*^9}, {
   3.672402222403721*^9, 3.6724022340448847`*^9}, {3.6724022795994396`*^9, 
   3.6724023117106504`*^9}, 3.6724025249649734`*^9, 3.6724025742349005`*^9, {
   3.6724077369661217`*^9, 3.672407773189744*^9}, 3.6724078137087955`*^9, 
   3.6724080160590286`*^9, {3.6724081110695286`*^9, 3.6724081251779394`*^9}, 
   3.6725729544192615`*^9, 
   3.6725730027340927`*^9},ExpressionUUID->"dd32373d-c252-48cc-96f1-\
2ee4d434bee8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "100"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6724021554450254`*^9, 3.6724021902875094`*^9}, {
   3.672402222403721*^9, 3.6724022340448847`*^9}, {3.6724022795994396`*^9, 
   3.6724023117106504`*^9}, 3.6724025249649734`*^9, 3.6724025742349005`*^9, {
   3.6724077369661217`*^9, 3.672407773189744*^9}, 3.6724078137087955`*^9, 
   3.6724080160590286`*^9, {3.6724081110695286`*^9, 3.6724081251779394`*^9}, 
   3.6725729544192615`*^9, 
   3.6725730027360926`*^9},ExpressionUUID->"49016daa-d87b-4ea0-9572-\
7ada69e23679"],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      GraphicsBox[{{{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.011000000000000001`], AbsoluteThickness[
           1.4], LineBox[CompressedData["
1:eJwt0n8slHEcwPE7SULt4vy4HO5cHLU1wzDreb4f143GbXLrjNKvu5hLwlVL
1PwYtdtV3FBoaeM26g8OW/qhZcftUtzQFQmLU01nFQ4xKc89zx/Pnr2/2/Pa
8/3sw5XmiNPtaDRa2NZDvAuZrXHTBWWoU5XGN01HwUwBcfAWtdDD741rwwF3
Gm3KxcZRl6uhe/BnCNy0JD3zLTejHu+eFoPwAMwTaZlDb96nygPqAiA4rUK3
HPQbaTob+eYRDpwkMm0JWcdOmPbrWVBJZMUKGjmuyNnIcINeInVrKDlfqHHs
coEVIpc30BgjFxVN24Pt95g0cO+V3ZJ+/Its2UoHWtvBmcgFKzpCZNw24Fni
m0K/zCNbbn1XfykznnfHjMj7OUChh1re/+8TIj1HiIiE+4fXhihvJ2x+zTCm
6vSU5wxFZpExWPqS8lxAXZWduD6npbzdcLF9MlFQqkG28TgxgM+uHQjMrEW2
HGXAhJHrJi+5jTRENu0BBUsu+iEpRnlE5rrCQPOCSHJagcj5ukEoI0d2LfYc
5THBb1LtEmuVUB4THjdUJ0+I4yjPHTzqVA6yxCjK84A/ZoNd5+cgyvMETFwY
0/zLi/K8gD1xeXFW6Uh5XnB1qS+Erl3FSY8FAmXXk83sbzjp7QWDdHAs7IMJ
Jz1veB0oHH61riPTiQ3pKUFJ7ctanPTYkBe+40zpi4eU5wOHrPUJPneVlOcL
qhT60QeqK5TnB4unni5qh87i5cQ+bedA+q4VwcKsCLftUxYHCqKNgzPrEbiY
WK9hDtRU9vXnz3NxIpOiuHDMt8pTmeWM+xFAAxck+aySSrUVIz1/iOHjCauC
KYz0/OH89YyOWpMeIz1/iL7Q3WFvbsWe2zwePHqn30TZNRjp8WCqrLjREniD
8vbBqrDte4pChv0H2whzUA==
            "]]}}, {}}, {{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.011000000000000001`], AbsoluteThickness[
           0.8], AbsoluteDashing[{2, 2}], LineBox[CompressedData["
1:eJwt0ntIU1EcwPFpKnP5mDofNR/b3RAfJVpgRt57fgqllGEzVllqZSjhBs4s
EbNY4EoEpw7TMtnUWYqIiU5ZCkpKGWqaEi0jrTlprqn5SNNIqrt7/zgcvueP
D+ccfvzM3JQsewaDcfj/IvfbnI4EY1EJinNcFC9XR8N8EXkwika6hneiGw8B
wTJoZfgnpC4hdnVEBNy3ivSBChMy/Z1obgkOgSUyrRZUGlH1WPoLg9C0iqHN
kFUULzlo7TsZAOlkpm2gDGN+cG2sD1SSWbGFOtfNDjW1bBgmc2gHYYLlnwli
JmyRufkHWXxv2mOldmC7HocB95ayXGumtpEtO+zg6jP59J24NZRIZsIe6DXG
c72qzMiWRgewnu8+InnyBVHvc4Ji1btU4+R7RHlM2NWmZrxZHKU9ZxAwp1+x
OS9pby9cmjvR0pTQQ3su0G+5gJU7tdGeGyQVb5+V4Rpk+x4WG779xsM02Spk
SwMbbiiF3d3HFaiZTK0H5Deo+Rp+IcojU+YJ8o7gGNHnHET9rxeE3y07ahGn
0x4H1uZlnS65ybTHgfbRmSa9AmjPG8Y9r7wOYUXRng/MVYvqAefTni8oZx5p
VrgetOcHQ1xzz0YLg/b8oJL31alw8gdBeftAWlDrUzE2S1Defujt+ohJL48R
lMeFU9fPZIa16alk+UNfNl94YPwpQXn+sBJ/Tt64oKK9AFA/j5JK3eW0Fwj1
x+qqBSM5tBcE7qHMGs2CmFCQ8+TIg8hYN4muPI6wzZOEB2V5BdHaunAihRyv
KR60KiN1HxK9CTJFMXyYaA8VOPsxiCASUPNBqBswvZ0145SHgTlNNXjt4hRO
eRg4Fva7tg7occrDYP178unBpEb8hc0TwK3yh7II/QOc8gQw35DTpTTl0p4Q
5KsGwuAgxv8BLcRsPg==
            "]]}}, {}}, {{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.011000000000000001`], AbsoluteThickness[
           0.8], AbsoluteDashing[{8, 2}], LineBox[CompressedData["
1:eJwt0m1IU1EYwPHVrOkq58umm0236bQ2g4kvFMW951GJVSTkEsJwlYJ9SGma
ZjANNJ24MrWyZaBpOkNbSRRiiopN0zQEk2yVk9jEyLcSRal0Wvfe8+Fw+J8P
P845PLI0nSZ9O4vFivq/qD2f36Z26EuQreKe/80+FTj11MEIUsZUOZeuK4Dk
2pqyiK9oVp3kuiqRQ+l84usgwzQyvzJoIo5IYIHK+VlkSM+oR+P+oEiptK7u
X0K/DxbV+016g5bKlBW0cvFJw6UELlRRWbmGjPaAIuTOhn4qrX+QvIPbnOC5
jtaoXN1A3YsdSt30MqKvx2fBs5F2SP0+i+hs2wa1pnKtVedAx6hUs+FK5F2H
fI8N0elwAw57441rbhQx79sJeYczDF68fuy5wxd9dGrPRAf2PEDVuMh5EPsc
e7sgp4AXHVb/GHu74fyoZsv1sRp7nnBqPc5iUpYh+nu4XnCNc8ckvJGP6LR5
gWkwKY7VeRmZqWzyhuF9LrF04gLKpjLLBx7+XcvJE2oQ87++cL8g2VgjiMce
H1wbt2S1vVHY48MPy5DPpIccewIY7zpdZ1/2xZ4f5Fpah97q2djzh/LwFV1s
yzKTXCFsCkRWZ6mDZDwhFM81nPMLGyMZTwSf3gUWG1U9JOMFwPC3TEXjVCvJ
AHtBPlnUH5dvwp4YBqwtaS8UxdgTQ7p7+/sutyzsBYJzpMwREH8We0HAFv3s
KxMfxZ4Eqrlj4WnmCNJAzdMOKVRkJoaau0QkPU8ZUtAKKjidhWxSQ43XBymo
X/LUnM0FgsrEQzI4U9IdkyubICQU8EgGktqtcXtUL8F4wTClmumTKpsJxguG
X6PawaeC2wTjBUNvYfmB4zU5RCfthYDlxBAvZToZeyFg/7wVaRwA7MmhMXum
jnMylPgHH55svw==
            "]]}}, {}}, {{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.011000000000000001`], AbsoluteThickness[
           0.8], AbsoluteDashing[{8, 0}], LineBox[CompressedData["
1:eJwt0l1Ik1EYwPGlK3WKqJs2bTm3OVDpcxqK7N15LN26MmdmGoqyJQRqKjrB
lS3Cz1W6FEQqIpyhppiorURTXNhFE5yU8yPSppiUVkNz1uzzfd9zcTj8z8WP
cw6PQFWUmufGYDCi/y9yv8LpVdi1VSjP6Cx/nLODlrXkwWuU49PM7Kx3IBlr
1lhMLCDPxkLmpe8fUc268nlo9QpS1ar5TbCENshc/4Q0SZOjPotvUWRWo3k7
woH6nm7EwDkLyiYzawtN/X5mtzWMIwOZjU6kGuMn/uGb0EsyzT/Rco7QmpLR
jZxkbv9CBd86bGtNDxF1PQ4DDi+af5QNNiMqe/fA/dLP6SJXDTpNpsId4ksk
obtyLaLSzgSjZD6dU1GI6Pftg/x33v4zJ3Kx5wma4o6RpatK7HnB1hzPoL9+
EnveEBnDcjRIorHnAz2K4wWWOhH2fCEou9Uj7hobUd/D8gMdq7NNxXZHVM76
QeBailWVvClrJ9PoDxMh56vk8XZZCZnFASBP9nUETk7J6P9lQ7fYra321Qid
LA5k6CVJsfVdMtrjwGDfHM8U14K9QJCrs9NkzhvYC4K/ohZ7+XAR9vaD78ic
VuB1AXtceNL/VafYTMQeF4govfJozTHsBYOlXx2sNARjLwT0q5UB7Wp37B2A
cdtC9axtg6A9Hgx39py54zFD0B4PdpD4VFrAKEF7B8FiYDNmOI8I2gsFZsvt
m+LdWwTt8aF+tS2dW1dKVJPztDcM+nvsIa6pTIKap/ww2D1UcSRyCIhUcrym
w+BewXyVQyYmyFTGCcB1Ni9qvJxF8EnggQAGVjRb0xEOKe0JQdc15pWQ+UZK
e0L4MGR9MWEySWlPCNxEa19t+F3pEOWJoIt/8YtLVymlPRHEvs+4XKbMxV44
mDVZrf4DCdJ/2QJsVw==
            "]]}}, {}}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->{True, True},
       AxesLabel->{None, None},
       AxesOrigin->{0, 0},
       AxesStyle->{{
          AbsoluteThickness[0.8]}, {
          AbsoluteThickness[0.8]}},
       DisplayFunction->Identity,
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->All,
       LabelStyle->{FontFamily -> "Cmr10", FontSize -> 15},
       Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
              Part[#, 1]], 
             (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
              Part[#, 1]], 
             (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
              Part[#, 2]]}& )}},
       PlotRange->{{0, 5}, {0, 40}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.02], 
          Scaled[0.02]}, {
          Scaled[0.02], 
          Scaled[0.05]}},
       Ticks->{Automatic, Automatic}], {180., -133.49534156997728}, 
      ImageScaled[{0.5, 0.5}], {360., 222.49223594996215}], InsetBox[
      GraphicsBox[{{{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.011000000000000001`], AbsoluteThickness[
           1.4], LineBox[CompressedData["
1:eJwt0n8slHEcwPE7SULt4vy4HO5cHLU1wzDreb4f143GbXLrjNKvu5hLwlVL
1PwYtdtV3FBoaeM26g8OW/qhZcftUtzQFQmLU01nFQ4xKc89zx/Pnr2/2/Pa
8/3sw5XmiNPtaDRa2NZDvAuZrXHTBWWoU5XGN01HwUwBcfAWtdDD741rwwF3
Gm3KxcZRl6uhe/BnCNy0JD3zLTejHu+eFoPwAMwTaZlDb96nygPqAiA4rUK3
HPQbaTob+eYRDpwkMm0JWcdOmPbrWVBJZMUKGjmuyNnIcINeInVrKDlfqHHs
coEVIpc30BgjFxVN24Pt95g0cO+V3ZJ+/Its2UoHWtvBmcgFKzpCZNw24Fni
m0K/zCNbbn1XfykznnfHjMj7OUChh1re/+8TIj1HiIiE+4fXhihvJ2x+zTCm
6vSU5wxFZpExWPqS8lxAXZWduD6npbzdcLF9MlFQqkG28TgxgM+uHQjMrEW2
HGXAhJHrJi+5jTRENu0BBUsu+iEpRnlE5rrCQPOCSHJagcj5ukEoI0d2LfYc
5THBb1LtEmuVUB4THjdUJ0+I4yjPHTzqVA6yxCjK84A/ZoNd5+cgyvMETFwY
0/zLi/K8gD1xeXFW6Uh5XnB1qS+Erl3FSY8FAmXXk83sbzjp7QWDdHAs7IMJ
Jz1veB0oHH61riPTiQ3pKUFJ7ctanPTYkBe+40zpi4eU5wOHrPUJPneVlOcL
qhT60QeqK5TnB4unni5qh87i5cQ+bedA+q4VwcKsCLftUxYHCqKNgzPrEbiY
WK9hDtRU9vXnz3NxIpOiuHDMt8pTmeWM+xFAAxck+aySSrUVIz1/iOHjCauC
KYz0/OH89YyOWpMeIz1/iL7Q3WFvbsWe2zwePHqn30TZNRjp8WCqrLjREniD
8vbBqrDte4pChv0H2whzUA==
            "]]}}, {}}, {{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.011000000000000001`], AbsoluteThickness[
           0.8], AbsoluteDashing[{2, 2}], LineBox[CompressedData["
1:eJwt0ntIU1EcwPFpKnP5mDofNR/b3RAfJVpgRt57fgqllGEzVllqZSjhBs4s
EbNY4EoEpw7TMtnUWYqIiU5ZCkpKGWqaEi0jrTlprqn5SNNIqrt7/zgcvueP
D+ccfvzM3JQsewaDcfj/IvfbnI4EY1EJinNcFC9XR8N8EXkwika6hneiGw8B
wTJoZfgnpC4hdnVEBNy3ivSBChMy/Z1obgkOgSUyrRZUGlH1WPoLg9C0iqHN
kFUULzlo7TsZAOlkpm2gDGN+cG2sD1SSWbGFOtfNDjW1bBgmc2gHYYLlnwli
JmyRufkHWXxv2mOldmC7HocB95ayXGumtpEtO+zg6jP59J24NZRIZsIe6DXG
c72qzMiWRgewnu8+InnyBVHvc4Ji1btU4+R7RHlM2NWmZrxZHKU9ZxAwp1+x
OS9pby9cmjvR0pTQQ3su0G+5gJU7tdGeGyQVb5+V4Rpk+x4WG779xsM02Spk
SwMbbiiF3d3HFaiZTK0H5Deo+Rp+IcojU+YJ8o7gGNHnHET9rxeE3y07ahGn
0x4H1uZlnS65ybTHgfbRmSa9AmjPG8Y9r7wOYUXRng/MVYvqAefTni8oZx5p
VrgetOcHQ1xzz0YLg/b8oJL31alw8gdBeftAWlDrUzE2S1Defujt+ohJL48R
lMeFU9fPZIa16alk+UNfNl94YPwpQXn+sBJ/Tt64oKK9AFA/j5JK3eW0Fwj1
x+qqBSM5tBcE7qHMGs2CmFCQ8+TIg8hYN4muPI6wzZOEB2V5BdHaunAihRyv
KR60KiN1HxK9CTJFMXyYaA8VOPsxiCASUPNBqBswvZ0145SHgTlNNXjt4hRO
eRg4Fva7tg7occrDYP178unBpEb8hc0TwK3yh7II/QOc8gQw35DTpTTl0p4Q
5KsGwuAgxv8BLcRsPg==
            "]]}}, {}}, {{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.011000000000000001`], AbsoluteThickness[
           0.8], AbsoluteDashing[{8, 2}], LineBox[CompressedData["
1:eJwt0m1IU1EYwPHVrOkq58umm0236bQ2g4kvFMW951GJVSTkEsJwlYJ9SGma
ZjANNJ24MrWyZaBpOkNbSRRiiopN0zQEk2yVk9jEyLcSRal0Wvfe8+Fw+J8P
P845PLI0nSZ9O4vFivq/qD2f36Z26EuQreKe/80+FTj11MEIUsZUOZeuK4Dk
2pqyiK9oVp3kuiqRQ+l84usgwzQyvzJoIo5IYIHK+VlkSM+oR+P+oEiptK7u
X0K/DxbV+016g5bKlBW0cvFJw6UELlRRWbmGjPaAIuTOhn4qrX+QvIPbnOC5
jtaoXN1A3YsdSt30MqKvx2fBs5F2SP0+i+hs2wa1pnKtVedAx6hUs+FK5F2H
fI8N0elwAw57441rbhQx79sJeYczDF68fuy5wxd9dGrPRAf2PEDVuMh5EPsc
e7sgp4AXHVb/GHu74fyoZsv1sRp7nnBqPc5iUpYh+nu4XnCNc8ckvJGP6LR5
gWkwKY7VeRmZqWzyhuF9LrF04gLKpjLLBx7+XcvJE2oQ87++cL8g2VgjiMce
H1wbt2S1vVHY48MPy5DPpIccewIY7zpdZ1/2xZ4f5Fpah97q2djzh/LwFV1s
yzKTXCFsCkRWZ6mDZDwhFM81nPMLGyMZTwSf3gUWG1U9JOMFwPC3TEXjVCvJ
AHtBPlnUH5dvwp4YBqwtaS8UxdgTQ7p7+/sutyzsBYJzpMwREH8We0HAFv3s
KxMfxZ4Eqrlj4WnmCNJAzdMOKVRkJoaau0QkPU8ZUtAKKjidhWxSQ43XBymo
X/LUnM0FgsrEQzI4U9IdkyubICQU8EgGktqtcXtUL8F4wTClmumTKpsJxguG
X6PawaeC2wTjBUNvYfmB4zU5RCfthYDlxBAvZToZeyFg/7wVaRwA7MmhMXum
jnMylPgHH55svw==
            "]]}}, {}}, {{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.011000000000000001`], AbsoluteThickness[
           0.8], AbsoluteDashing[{8, 0}], LineBox[CompressedData["
1:eJwt0l1Ik1EYwPGlK3WKqJs2bTm3OVDpcxqK7N15LN26MmdmGoqyJQRqKjrB
lS3Cz1W6FEQqIpyhppiorURTXNhFE5yU8yPSppiUVkNz1uzzfd9zcTj8z8WP
cw6PQFWUmufGYDCi/y9yv8LpVdi1VSjP6Cx/nLODlrXkwWuU49PM7Kx3IBlr
1lhMLCDPxkLmpe8fUc268nlo9QpS1ar5TbCENshc/4Q0SZOjPotvUWRWo3k7
woH6nm7EwDkLyiYzawtN/X5mtzWMIwOZjU6kGuMn/uGb0EsyzT/Rco7QmpLR
jZxkbv9CBd86bGtNDxF1PQ4DDi+af5QNNiMqe/fA/dLP6SJXDTpNpsId4ksk
obtyLaLSzgSjZD6dU1GI6Pftg/x33v4zJ3Kx5wma4o6RpatK7HnB1hzPoL9+
EnveEBnDcjRIorHnAz2K4wWWOhH2fCEou9Uj7hobUd/D8gMdq7NNxXZHVM76
QeBailWVvClrJ9PoDxMh56vk8XZZCZnFASBP9nUETk7J6P9lQ7fYra321Qid
LA5k6CVJsfVdMtrjwGDfHM8U14K9QJCrs9NkzhvYC4K/ohZ7+XAR9vaD78ic
VuB1AXtceNL/VafYTMQeF4govfJozTHsBYOlXx2sNARjLwT0q5UB7Wp37B2A
cdtC9axtg6A9Hgx39py54zFD0B4PdpD4VFrAKEF7B8FiYDNmOI8I2gsFZsvt
m+LdWwTt8aF+tS2dW1dKVJPztDcM+nvsIa6pTIKap/ww2D1UcSRyCIhUcrym
w+BewXyVQyYmyFTGCcB1Ni9qvJxF8EnggQAGVjRb0xEOKe0JQdc15pWQ+UZK
e0L4MGR9MWEySWlPCNxEa19t+F3pEOWJoIt/8YtLVymlPRHEvs+4XKbMxV44
mDVZrf4DCdJ/2QJsVw==
            "]]}}, {}}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->{True, True},
       AxesLabel->{None, None},
       AxesOrigin->{0, 0},
       AxesStyle->{{
          AbsoluteThickness[0.8]}, {
          AbsoluteThickness[0.8]}},
       DisplayFunction->Identity,
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->All,
       LabelStyle->{FontFamily -> "Cmr10", FontSize -> 15},
       Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
              Part[#, 1]], 
             (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
              Part[#, 1]], 
             (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
              Part[#, 2]]}& )}},
       PlotRange->{{0, 5}, {0, 40}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.02], 
          Scaled[0.02]}, {
          Scaled[0.02], 
          Scaled[0.05]}},
       Ticks->{Automatic, Automatic}], {540., -133.49534156997728}, 
      ImageScaled[{0.5, 0.5}], {360., 222.49223594996215}]}, {InsetBox[
      GraphicsBox[{{{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.011000000000000001`], AbsoluteThickness[
           1.4], LineBox[CompressedData["
1:eJw90mtIk1Ecx/GVOlIzVy2dZnPzEl6ShpaatZ4fRc2RRpu3B7KLq16UxDR6
08qoyAtIbInWkhbZVuKFCaaiUJY3RJeQCdrUsmWQYhfDnM2Wa898nr04HL7n
xYdzDn+hQik/t5bFYiU4F7Vf5RolFtVtIpldqjO9E+GzijoYJC49kJY1xoiw
32dMXyAeJ9I7/Syhe0UomZO184unifopXUutTYRvVM7NEhHPgqJ2H49HdK66
ezFqnviYPsdvz9yFE1TmLhBXKhO1SROJ0FCpthJLvqmx5dN70ENlt43gdy1V
mfPEsFK5aCfeBu7Mu2UAXNfjsiA0VY9z+w7AlcY18FAd/BLtcwipVEo8MNmY
77nvggSutHhCMTSi/TQuxer72JAbRdu5sjTaWwdebFXh066jtOeNSI73qFlz
jPZ8cf5326D2uYz21iMpo+lOU6+c9jbAq/+F5N7rDLi+x4cD/PG3dBoy4cox
DuzBRSa9MgsGKvUboVgMqesRZKOQyoJNIE87dOXt2fT/bsZDVZw5ITmH9rh4
JTUvV9Tk0B4XX+NNp75bc2hvCzp0UZy+FJL2AuAX2Sw2KknaC0TtzeGAWC1J
ezxMisuVmjaS9ni40cK+u/CGpL0gxDQdLhN8YLxgTPU6Ht+fYbytGBrIP6mZ
Z7wQ+P/6KWJZGS8ETwzVR/Q2xtuG/r8DB9l2xuOjhHv2mvof44Wipi6ptXSF
RDE1T14CFDZUnhE6yNV5yhdgpiiu9bqz5dR4DQuQpk5PbXM2lbJkISouTrwc
dXYoBTwSon5EmzXrYLwwOHiK/gW3F4YGVl6Zze2FoUS9w2B3dofLC8fA8qB0
xe2F48fU+wiH24tAc8rlSqr/A2nbc64=
            "]]}}, {}}, {{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.011000000000000001`], AbsoluteThickness[
           0.8], AbsoluteDashing[{2, 2}], LineBox[CompressedData["
1:eJw90mtIk1Ecx/FH01CzqTWblTq3CVmEolYqXZ5fBU0JS2drU2aJkZiVmaGW
gVl5qQQXJSWURXjJEu0KrttAU6k5DK9L3+i8VM4uUl5bbu3M59mLw+F7Xnw4
5/AXJJ+SHLWnKCrUssh+ntsg1ucW0D2unof8/UMwnEsONHRiermmOj8YO1x0
lRnbB2i7dVpx391gFE3EqnwLR2iu4YmyLD0E30lOjNOdFzzz8wyhWK9QNk8H
TNIXr8Z3lDhsQSJJxR9aSJ2w3/Y0HNdJKmfo6LM3804ObcV7ks3z9Aa1Pt1c
RGOG5PQ/GlPKhyGanbBej0uBsnt5pNa4G9ZssMP+n6oK8b49iCQpXoKhmrpH
txojYU29A/6KeuczN+7F4vuWglPT+i7tQTTjOSGNN9d/2zGG8Zxx59M3uiQo
lvGWoTxw2E0TJWE8V6R4ZLdIY+IYj4P6+02jfByA9Xtc3DGY/DpDwJPCmjp3
BPH7OYd7pKgiWemBttkI1UDOQZwmmbECWl1pbZa9jPnflYhQxHW0ZckYj4vU
zC8qQ7eM8bgYM7x1lvDljOcJevBY740EOeOtgrlPLMMVOePx8LE9ldf+WM54
XqhQTynSWuSM5wVVkLqOo2O91TAlSMMUo6y3BtFdxhd1P1hvLYrjwt+4TbGe
N3wCpE6Jc6znDW8RtXyTkfV8kDXe89xlgfV8odU/O7fZxHp87Body/5l6UIy
T45+SA5NMSWZ5YvzdNwPX5Oo31WWlpDx6vRD4xm6W2tpkrHhAjQ5BbaNWJpP
gHsClF4zqybNrCeELr9reNbmCVFdX9BqtHlCaIsv9y1Y+pXVE+FzlMxgsnki
fHCLzzHbPH+EXXJUk/4PNN50tg==
            "]]}}, {}}, {{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.011000000000000001`], AbsoluteThickness[
           0.8], AbsoluteDashing[{8, 2}], LineBox[CompressedData["
1:eJw90mtIk1Ecx/HlJcu722w2bboZpGgqSmmiPj8RmwmhzssW2ZBkFlS66oWg
QSbTqDAlLMrSRYotEMEoa5GRmqK+iNYF04HD2dXNNhDv5tp5ep69OBy+58WH
cw5/8ckqmcqNw+EkORfZa/m90tkaDSUPqhYF1STDXEMOJqgEnVa5ZjmIDO/J
TnX6NHVa97X5ZlIyGi0FL0UNc5TtYdbhVmkKrCQtv6knwTGxG8JURJc2Dy1F
2SnbCO+Wrj0NJ0iWLlIdnu9VngMUWkg2L1O+xgJB/NNMDJMcWqPKr09Vtr7J
wjLJpU0qNXZ4rmslG/T1+BykQ1/3Ij8HdPZuw2r8n+Wx17nIISl1R582OeBj
3FHQOeuBxNuGxwltefj/vu1AQ+j9prV8xtuBQz95Q9cEMsbbieGLVkm3pJDx
fKC5VyyuFRQxni9GWhLL+heLGM8foUp7o6i/GPT3eAdC8yPOoFGWgM7JQERx
jW+7F0rQRbIzCKtevb/cVXKcJ6nm4tsBVV/PqJz5Xx6em6TRAcEKxuPDy3qu
alSmYDw+esrS8tT1CsYLRlGbn/JGt4LxdoHfYu9QDioYTwCtJePq/GfWC8Ed
P+5xs5n1QvClLuBIj5X1dmPdY5+6YpH1hMi8kOtmW2G9UHD3m+wL66wXhjSR
8PvMJuuF4cFgVZdwi/X2IGc+65hpi/VE6DTyrsgdrBeOmImmaq2zG8g8eUZg
euySftzZ9DydicCrkAE/s7NlZLwMETAWnhq3OZtkQYoYZx/5lK84O5wAHWK8
u9tfv+HyJKiYy3721+VJYPgkmdpyeRJ4XDZVOpytp71ICKYW9A6XFwkd58OM
w+Xthb+x1U76H+gMc3Y=
            "]]}}, {}}, {{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.011000000000000001`], AbsoluteThickness[
           0.8], AbsoluteDashing[{8, 0}], LineBox[CompressedData["
1:eJxF0l1Ik1Ecx/GtzHxDzKY5m3ObZYqIoDbqYj2/IpyYBc/jyx5weuEbhZV6
EZRlF9XEFJkzLGjmCF8ugkxTMI2iNAKNMmtoJqnTXogZCaJNt/bkedqzXRwO
33Px4ZzDX1lcyZRtE4lEaVuL7JclPVpbzQ2q1+92CcPQWKwhB+NUlNRoen2K
xpGg6Y4qzWcqV2Wt6q+kUWenn8gNS9RKD+bT+mksk7T/pKaPPq4xRjBI1BtH
1hJWqFVzu9pkYlBIUr9KWZVjV5yKHDSTNK5TrGV4IfhZDkZJjmxQD99l13JF
uVgnueaipEmdxxpEeeCvJxEh4cKtCnVbHvjsEaOiSF/SlZyPTJLa7WgOvD/z
qC8ffNr8kH3OvFQer8P/9/kjOpnOdDboPF4ADvpXx7TM6zxeIO42We+E7mc9
XjBo8Zmbn/SsxwtBQfH4y6561uOFglF3v8p6wIL/nqAw1GuWS1tHWfA5HYaz
jTHS1CkWnSQ7dqGbG6g1L7GoJlkVjsGk4abwX6znf3ejvK+t/d6q4ElwTXw4
PMQheBKcmAydc20KXgQqn3/Rf3cJXiQufn2bIXcL3h5spMyE2dyCF4UPO9VZ
LCd4UchIKnhv4QRPivRW+fwYJ3jRCEq3yxY5wdsL3dX4id+c4Mmg0QSU/fF6
MhQmnrzu9HoxSEwtHfjr9eSYaI2dcXu9WBTOTp3nttpA5mmHAv2RP4ZI8/NU
odh6z5s50gwZr0kFNjtbVkiTpA8pMXjA4SAdS4B2Jeouzbp8ngoftRa3z1NB
nHea83kq9Aa+4HuI9+JgaPzG+bw4LBxf43zePqQ8dfL9D7TgfR4=
            "]]}}, {}}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->{True, True},
       AxesLabel->{None, None},
       AxesOrigin->{0, 0},
       AxesStyle->{{
          AbsoluteThickness[0.8]}, {
          AbsoluteThickness[0.8]}},
       DisplayFunction->Identity,
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->All,
       LabelStyle->{FontFamily -> "Cmr10", FontSize -> 15},
       Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
              Part[#, 1]], 
             (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
              Part[#, 1]], 
             (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
              Part[#, 2]]}& )}},
       PlotRange->{{0, 5}, {0, 100}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.02], 
          Scaled[0.02]}, {
          Scaled[0.02], 
          Scaled[0.05]}},
       Ticks->{Automatic, Automatic}], {180., -400.4860247099318}, 
      ImageScaled[{0.5, 0.5}], {360., 222.4922359499621}], InsetBox[
      GraphicsBox[{{{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.011000000000000001`], AbsoluteThickness[
           1.4], LineBox[CompressedData["
1:eJwt0mtIk1Ecx/HZvOUl5vbsqu5eaiVZFonZnt+L0L2QwiWRtcAsJfI6Mmrt
TUQavbI0ocRLqOFKmlpemoLSVlQSXmJl1BRdJqjbUsKZpVTPPC8Oh+958eGc
w1+RV6rL38JisZL/L2Y3UZaMmWs36buWubjaD0lwXWMOhmmrZLwgvX4PNGET
LWWHv9CFVGLz6lAiKhezXkgrvtFaRZcuNXI33EwuztOPjz7tXLu+Ewn6KttK
/BLt/M4dU4sScIZJ/U/afSpsenA0DneYrPLR3cE61WLrDtiZtK3Rn2cbk1bu
bYePyZV12ruuF55oUMN/PYqF+D49u29ABX9aAqDWFHuXPUpomcxgY2OXc5Kz
Twl/zgRi4cENQWalApvvC8bwyKPGkHk58UJxwezSjZ2UE28rHHZbZZdZRrxw
GAJ9Ae5uKfEi4P1T50lxxBJvG+wX77+xBsbC/z1hHDRI3wXYj8TAnxMcjMrD
ez9VR6OVyZYoLDhdb5s8EhiYLOOixDBn8hyXkP/loceWXtzxSkw8CjlO/F3W
iIlHobajR/71pYh4fBgSs0vbMkXEE8D1ury9bUpIPCGmsxyXNVeExBMhu8B8
bIovJJ4IAxu/Pob0C4gnhrb62V7tOQHxJDCeLe89GCUgXjRWczufXLXziReD
5Ajs7zXyiReDH0nC/JZkPvFi0a5JPf97iSKeFDXGqg5TF0U8GSzG25c85RQq
mHkKkmPIGeSTHKI256lQjpxbkVwHm4KOGa9xObRzRTb3CA9MZqUo8P7AaWta
PQ8yBmhUoKTuIbupkEc8JfKeO3uW03jEUyLd19/M5/CIp4RMFyr2znJh9Xsq
mJYGzbkDXOKpkBuS6s2u4RJPDR1vMq+7iIt/dlBjaQ==
            "]]}}, {}}, {{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.011000000000000001`], AbsoluteThickness[
           0.8], AbsoluteDashing[{2, 2}], LineBox[CompressedData["
1:eJwt0mtIk1Ecx/GlZTYvqW3Ps/vtWV7Ja6QJ+vwsy8wMHL0w0yF5SYzlFF+E
Um90RqZMg9RKhKaBhgpBhDYRnCgWKvjCll2IqZXmonDMpl2oZ54Xh8P3vPhw
zuGvvlylK/Ph8XhJ/xe31wuGsxx1jezfwo9dG0wiluu4g1dsrd4V8V2ZgHS+
vdeY9pYtvpSYfCIhHk0beSMK0wqrcLIC4VAsnFxurLO+RfHt07IjiCo029yR
P9jlpfmUueEYFHFZ6GK1+qyuyuJotHFp3mKrYvzdntgoTHJp22Zb+9HgoiOx
xaX7Nztg2Fn4JYqA93oCHtyS+873ceHw5vAeBFPWJy0Fh3GGyyxfmOjshzGd
WnjTsReBJU/XfFcZ7L7PD5Xil423WIZ4/kja/PQut19DvAOw1admhMo1xAvA
5NhI6mC3mniBsFXbZ6hwNfGCMXXuxnjJiAre7+GHQLvuODauU8Gb9hCUr+pL
59eU6OOyNxSGtAlr+XElqrk0hiHOj0+FdSjI/x5C5qzi8dgfOfEEcI4uzl6r
khNPgGdR5yVnv8qIJ8RFtae5ySAjHoWBzUS50SMlHo277Uf7SpulxBPBfM/z
ZkEjJZ4IltfxlqQJCfHEGMu53RpWJiGeBBf8tmt9giXEk2LHmZ3zyComngy5
wpqADoOYeDK41DPTZkZMPDlYmWk+84OIeAoIiyvc1Q9ExFPiuWHw81KBCCZu
nvap0N0zZ85UiHbn6aoKbY5vD26u0tBx47WgQlPQys/8IRpc5qWowbOk1PRf
p6HkgB411vMtulOnaeJpcKX2Dj+AoomnQeiLzjX7F4p4GtiiDy62WCmMej0G
DSdzhUHtFPEYBBorhOkVFPG0YKb0yfszKPwDKdZUVA==
            "]]}}, {}}, {{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.011000000000000001`], AbsoluteThickness[
           0.8], AbsoluteDashing[{8, 2}], LineBox[CompressedData["
1:eJw10mtIk1Ecx/Fpls17OW2Z5uXZ5uYtddbE0udHGZMwUEsrcIUyTfSFm+Wk
lZfAS6Zh4IKGIYGOUsuoFJ2SeakgIXIk2sUaOrRCDU02zUTrmccXh8P3vPhw
zuHvn5mfkmXLYrHE/xezX+W0SyfV5XTWIxdPwxUJptTMwTDdu2Ac9ig5hDiH
8SZF7GdaYmgLddccROVscvf+ChOtn7NXzPREYY7J2Z/0xFKVunFRDFF63aBZ
uECbvppajkrEkDGZvkRfkrsWfbwZidtM1lnoUkulW85sBIaYHPxDHze2WjbO
RMDCpHmNtkmTdXS9D4f1ehwWRl3MI0+Tw2HNdhuUj6rFMT0HkMCkdBs6/xr7
c6fCYM1JO5y88Lu+yisMm+/bgYYnKzWxGaHE24mk2pYbpzpDiMdGQiW3sMUj
hHiOyHgDN8n1YOI5QRYZXOOwHEQ8FwwkNrlKVUGwfo+DG4o7uHHUugjWHHfD
B92Dx99vidDMZNMudLyOV83zRFAyqdgNp5LG4XuDQvK/7hiZSdflZQuJx0Gq
YL5mwlVIPA5qV00Xi/sCiecBPTukaEYZSDxPyITaFL0okHh7oJU7O9yfFhCP
i9xVTmqiTkA8Ln7pn42pcgTE24tS40bBtzAB8bygyD7cKV3hE28f3q3/iL/2
ik88byy1tuWcqOcTzxvajbt3yuV84vngLHuMbRPNJ95+PNfIlVrnLc8X5w0+
mqBpHiqYedruh7Vz846aPt7mPOX54aFNoW23locUZrwMfhiwSzOrVTwwmRzt
jwDklw2d5sGXARr9sdisDFVHbXkBGEo6klDtseUFQKIq65pYpogXgN62mE8Z
XyjorR4FRWpDpn0/RTwKBW9tj73QUcTjIabhZfXlWgr/AGEoYeE=
            "]]}}, {}}, {{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.011000000000000001`], AbsoluteThickness[
           0.8], AbsoluteDashing[{8, 0}], LineBox[CompressedData["
1:eJw10mtIk1Ecx/GZmbcpaqtMN90lRC2W0yCT9PlB1Bb0bM+WmaETvHRBIy2L
1NHVS4TYLFHBLPOSBKKJl+EFVDTRLMQoE8uBlzDUFMW2En1Rz3zOi8Phe158
OOfwlySl6y7u4PF4Yf8XuxsETcqZnDzKJytz/JROi9kc9mCEepp08k5vhBZR
LhO1GZHfqN8BJ0orZVoULGk7/PLnqHdCYdU0X4tfbC4tUIIu9+EiK4OgeGO/
JXCVitVmLb6eZqBnM36dqp4cNwZ/YFDMptFKuf4MWheaGAyw2b9BHa3vtr9b
zcDKpmWLelssvaIuYmC7noAHed2zB0+yGdiyyQ6lgfr0qEsMVGwq7aG4XeGV
cJaBLWd2Qte75rkMBtvv24Vbl2+aF+XEc0JCcm5LjIh4zpivaq86zCeeK6JX
r3kuWDWcx4fCLjxa9VXDee7ofB4WkWPSwPY9Lh5ISYszGco1sOWEB8JbInNP
Z2tQx2atJ0alfUHTcRpcZzPDC30h5Y7HKQ33v7sRs3L13AUZ8QRInGw9dMSJ
eAIYg2VFw8tqztsDk/J7otcXNefthZ9FUeDWrea8fWhrCxhpr1FznjeG7t23
7ipUc543NhvKxrYyibcfP84MiUr0xPNB2dSL+kEl8XzxStV4rDiUeELceC9u
WhERT4h0seP8lDPxRFizxI3FWGnO80OA/HNq7BzNef545JY6YB6jkc/Ok4MY
mw79G7M99PY8pYkxuqVCSiMNHTten8To6gk16ytpsKkNl0CuVB78WEjDnwVe
SvAn9nFFg4F4Ujwc6mj+m0Y8KULftDo3xxNPCl9D5/lRmkanzZNhMKQkmaGI
J4NkqIYfpiDeAeS5mVWZMhr/ANPZYE8=
            "]]}}, {}}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->{True, True},
       AxesLabel->{None, None},
       AxesOrigin->{0, 0},
       AxesStyle->{{
          AbsoluteThickness[0.8]}, {
          AbsoluteThickness[0.8]}},
       DisplayFunction->Identity,
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->All,
       LabelStyle->{FontFamily -> "Cmr10", FontSize -> 15},
       Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
              Part[#, 1]], 
             (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
              Part[#, 1]], 
             (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
              Part[#, 2]]}& )}},
       PlotRange->{{0, 5}, {0, 100}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.02], 
          Scaled[0.02]}, {
          Scaled[0.02], 
          Scaled[0.05]}},
       Ticks->{Automatic, Automatic}], {540., -400.4860247099318}, 
      ImageScaled[{0.5, 0.5}], {360., 222.4922359499621}]}}, {}},
  ContentSelectable->True,
  ImageSize->500,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{{3.6724021554450254`*^9, 3.6724021902875094`*^9}, {
   3.672402222403721*^9, 3.6724022340448847`*^9}, {3.6724022795994396`*^9, 
   3.6724023117106504`*^9}, 3.6724025249649734`*^9, 3.6724025742349005`*^9, {
   3.6724077369661217`*^9, 3.672407773189744*^9}, 3.6724078137087955`*^9, 
   3.6724080160590286`*^9, {3.6724081110695286`*^9, 3.6724081251779394`*^9}, 
   3.6725729544192615`*^9, 
   3.6725730027810974`*^9},ExpressionUUID->"2dd9010d-cf0d-41a8-8e03-\
af0f4e2eda55"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{
  "\"\<C:/Dropbox/mystuff/cred/ECMAScndRev/IMAdestSt.pdf\>\"", ",", "pf"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.672407922435667*^9, 3.672407964788902*^9}, 
   3.6724080290803304`*^9, {3.6724081151619377`*^9, 3.672408118410262*^9}, {
   3.6725726850083227`*^9, 
   3.6725727237932014`*^9}},ExpressionUUID->"52dbaa54-5768-4399-a28d-\
6a5e8372cab6"],

Cell[BoxData["\<\"C:/Dropbox/mystuff/cred/ECMAScndRev/IMAdestSt.pdf\"\>"], \
"Output",
 CellChangeTimes->{
  3.672407968430266*^9, {3.672408122136635*^9, 3.6724081289223137`*^9}, 
   3.6725730103598547`*^9},ExpressionUUID->"723f3e40-be3c-40ec-a839-\
c575afcb77e5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{
  "\"\<C:/Dropbox/mystuff/cred/ECMAScndRev/IMAdestEMW.pdf\>\"", ",", "pf"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.6724080337998023`*^9, 3.672408050333455*^9}, {
  3.6725726961124334`*^9, 
  3.672572728017624*^9}},ExpressionUUID->"ed456cec-f22e-4772-acb5-\
502f017ec837"],

Cell[BoxData["\<\"C:/Dropbox/mystuff/cred/ECMAScndRev/IMAdestEMW.pdf\"\>"], \
"Output",
 CellChangeTimes->{{3.6724080424416666`*^9, 3.6724080525826807`*^9}, 
   3.67257295490431*^9},ExpressionUUID->"15e3aa22-0ac8-4f14-a72a-\
cd3af3f3118d"]
}, Open  ]]
},
WindowSize->{1525.2, 820.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"13.0 for Microsoft Windows (64-bit) (February 4, 2022)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"1e92acec-25cb-467c-811c-a25c07194c4c"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 20471, 616, 1571, "Input",ExpressionUUID->"1ceab222-40dd-4c77-8cd9-3e00efc88346"],
Cell[21054, 640, 6142, 114, 311, "Output",ExpressionUUID->"5d8f31df-0d32-46a3-a72f-afe1c0e1b3de"],
Cell[27199, 756, 11964, 238, 66, "Output",ExpressionUUID->"ed24cc01-6f1f-4452-8d12-8eb8a9a38f5f"],
Cell[39166, 996, 11699, 231, 66, "Output",ExpressionUUID->"3e221838-7f28-42aa-bc00-8ac0ae471dc8"],
Cell[50868, 1229, 248, 4, 41, "Output",ExpressionUUID->"36bb7b11-e8a6-4941-9df3-120bd0f4b245"],
Cell[51119, 1235, 431, 12, 41, "Output",ExpressionUUID->"d6487f5f-60ec-4bbc-a5ec-eae0d3739585"],
Cell[51553, 1249, 280, 6, 64, "Output",ExpressionUUID->"de279a16-2280-4be9-9925-c66d6b75b458"],
Cell[51836, 1257, 286, 6, 59, "Output",ExpressionUUID->"bafa4f6e-3f11-4a0d-a437-4c0954171b3a"],
Cell[52125, 1265, 265, 4, 41, "Output",ExpressionUUID->"382c45ad-4ad4-4594-8d5c-d525e886ba71"],
Cell[52393, 1271, 517, 15, 76, "Output",ExpressionUUID->"25a64b4c-1dc0-4516-b223-a9244f15296f"],
Cell[52913, 1288, 149337, 2880, 644, "Output",ExpressionUUID->"094ce12a-eb61-4669-9996-0d9e0c6a11d9"],
Cell[202253, 4170, 24781, 488, 66, "Output",ExpressionUUID->"36ed4812-e1d6-4dde-badf-e867b0e17af5"],
Cell[227037, 4660, 24720, 487, 66, "Output",ExpressionUUID->"f6f421d6-98ea-45ce-b80d-3a72a12796b3"],
Cell[251760, 5149, 149335, 2880, 644, "Output",ExpressionUUID->"9282c8b1-0afc-4714-b797-0666e0dc0ea2"],
Cell[401098, 8031, 2220, 60, 63, "Output",ExpressionUUID->"1faba3f0-0070-40d1-a044-6d2c9ebd2c66"],
Cell[403321, 8093, 2315, 62, 63, "Output",ExpressionUUID->"a959a7bb-a562-4fba-8959-ef0ce2738c75"],
Cell[405639, 8157, 4500, 112, 115, "Output",ExpressionUUID->"9df39d6d-0b76-42da-8bdc-4086aa553dcb"]
}, Open  ]],
Cell[410154, 8272, 371, 8, 36, "Input",ExpressionUUID->"448ad9d4-24ad-441f-9f74-1ba82b846ead"],
Cell[410528, 8282, 313, 8, 36, "Input",ExpressionUUID->"852c7025-6ee7-4a51-a8f8-25115613978c"],
Cell[410844, 8292, 3706, 110, 309, "Input",ExpressionUUID->"803eb0c3-c59e-406d-b09b-7bcb2fb5b2b2"],
Cell[CellGroupData[{
Cell[414575, 8406, 4813, 133, 383, "Input",ExpressionUUID->"ae982477-4ae7-4e9b-ad82-824690495181"],
Cell[419391, 8541, 5944, 115, 317, "Output",ExpressionUUID->"9fc96f5d-07e0-44fd-97c2-73b30bbd6b10"],
Cell[425338, 8658, 5968, 115, 308, "Output",ExpressionUUID->"ecac3b92-853f-4b27-8739-37736c07b6dd"]
}, Open  ]],
Cell[431321, 8776, 174, 4, 36, "Input",ExpressionUUID->"ef8a1162-be5d-4153-96bd-fdd6101de5fa"],
Cell[431498, 8782, 176, 4, 36, "Input",ExpressionUUID->"802e4257-1fca-4e40-a530-9908247924b6"],
Cell[CellGroupData[{
Cell[431699, 8790, 1743, 46, 111, "Input",ExpressionUUID->"8f8f8aee-c67c-4894-b719-a347ae5c7a4c"],
Cell[433445, 8838, 396, 10, 41, "Output",ExpressionUUID->"c13bd7ef-bb7f-4223-92d7-b06c75ec9c47"],
Cell[433844, 8850, 23126, 434, 471, "Output",ExpressionUUID->"2337bff1-bb8e-4716-8c97-a5115f6740a0"],
Cell[456973, 9286, 555, 11, 32, "Message",ExpressionUUID->"2ac124f1-19e0-4549-ac20-7b87f395be22"],
Cell[457531, 9299, 259, 4, 41, "Output",ExpressionUUID->"e5dde27e-31d8-416e-8731-5452de67ffab"]
}, Open  ]],
Cell[CellGroupData[{
Cell[457827, 9308, 6877, 194, 458, "Input",ExpressionUUID->"a389518f-9a2b-49ab-8ec5-32f955cef1f8"],
Cell[464707, 9504, 663, 14, 41, "Output",ExpressionUUID->"dd32373d-c252-48cc-96f1-2ee4d434bee8"],
Cell[465373, 9520, 664, 14, 41, "Output",ExpressionUUID->"49016daa-d87b-4ea0-9572-7ada69e23679"],
Cell[466040, 9536, 24131, 447, 463, "Output",ExpressionUUID->"2dd9010d-cf0d-41a8-8e03-af0f4e2eda55"]
}, Open  ]],
Cell[CellGroupData[{
Cell[490208, 9988, 402, 9, 36, "Input",ExpressionUUID->"52dbaa54-5768-4399-a28d-6a5e8372cab6"],
Cell[490613, 9999, 264, 5, 41, "Output",ExpressionUUID->"723f3e40-be3c-40ec-a839-c575afcb77e5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[490914, 10009, 325, 8, 36, "Input",ExpressionUUID->"ed456cec-f22e-4772-acb5-502f017ec837"],
Cell[491242, 10019, 239, 4, 41, "Output",ExpressionUUID->"15e3aa22-0ac8-4f14-a72a-cd3af3f3118d"]
}, Open  ]]
}
]
*)

