(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    243155,       4337]
NotebookOptionsPosition[    241341,       4298]
NotebookOutlinePosition[    241823,       4315]
CellTagsIndexPosition[    241780,       4312]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
    "\"\<c:/dropbox/mystuff/cred/ECMAScndrev/LTU_Andrews.txt\>\"", ",", 
     "\"\<Table\>\""}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"d", "[", "2", "]"}], "=", "data"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
    "\"\<c:/dropbox/mystuff/cred/ECMAScndrev/LTU_Hansen.txt\>\"", ",", 
     "\"\<Table\>\""}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"d", "[", "1", "]"}], "=", "data"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"style", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"AbsoluteThickness", "[", "1.4", "]"}], ",", "Black"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"AbsoluteThickness", "[", ".8", "]"}], ",", 
       RowBox[{"AbsoluteDashing", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "2"}], "}"}], "]"}], ",", "Black"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"AbsoluteDashing", "[", 
        RowBox[{"{", 
         RowBox[{"8", ",", "2"}], "}"}], "]"}], ",", 
       RowBox[{"AbsoluteThickness", "[", ".8", "]"}], ",", "Black"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"AbsoluteDashing", "[", 
        RowBox[{"{", 
         RowBox[{"8", ",", "0"}], "}"}], "]"}], ",", 
       RowBox[{"AbsoluteThickness", "[", ".8", "]"}], ",", "Black"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"AbsoluteDashing", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "2"}], "}"}], "]"}], ",", 
       RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", "Black"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"AbsoluteDashing", "[", 
        RowBox[{"{", 
         RowBox[{"8", ",", "0"}], "}"}], "]"}], ",", 
       RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", "Black"}], "}"}]}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"grid", "=", 
    RowBox[{
     RowBox[{"d", "[", "1", "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"pEW", "=."}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"pEW", "[", "j", "]"}], "=", 
       RowBox[{"{", "}"}]}], ";"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "1", ",", "3"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"AppendTo", "[", 
       RowBox[{
        RowBox[{"pEW", "[", "j", "]"}], ",", 
        RowBox[{"ListPlot", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           RowBox[{"{", 
            RowBox[{"grid", ",", 
             RowBox[{"Map", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"Max", "[", 
                 RowBox[{"#", ",", "0"}], "]"}], "&"}], ",", 
               RowBox[{
                RowBox[{"d", "[", "j", "]"}], "[", 
                RowBox[{"[", 
                 RowBox[{"2", "+", "i"}], "]"}], "]"}]}], "]"}]}], "}"}], 
           "]"}], ",", 
          RowBox[{"Joined", "\[Rule]", "True"}], ",", 
          RowBox[{"PlotStyle", "\[Rule]", 
           RowBox[{"style", "[", 
            RowBox[{"[", 
             RowBox[{"i", "+", "1"}], "]"}], "]"}]}], ",", 
          RowBox[{"LabelStyle", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"FontFamily", "\[Rule]", "\"\<Cmr10\>\""}], ",", 
             RowBox[{"FontSize", "\[Rule]", "12"}]}], "}"}]}], ",", 
          RowBox[{"AxesStyle", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"AbsoluteThickness", "[", ".8", "]"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"AbsoluteThickness", "[", ".8", "]"}], "}"}]}], "}"}]}],
           ",", 
          RowBox[{"AxesOrigin", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}]}], ",", 
          RowBox[{"PlotRange", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "50"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "0.1"}], ",", "5"}], "}"}]}], "}"}]}]}], "]"}]}], 
       "]"}], ";"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "1", ",", "2"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pEW", "=", 
   RowBox[{"GraphicsGrid", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Show", "[", 
         RowBox[{"pEW", "[", "1", "]"}], "]"}], ",", 
        RowBox[{"Show", "[", 
         RowBox[{"pEW", "[", "2", "]"}], "]"}]}], "}"}], "}"}], ",", 
     RowBox[{"Spacings", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Scaled", "[", "0.05", "]"}], ",", 
        RowBox[{"Scaled", "[", "0.05", "]"}]}], "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.583155565644148*^9, 3.583155620743657*^9}, {
   3.5831682088114133`*^9, 3.5831682267332053`*^9}, {3.6539340480578723`*^9, 
   3.6539340804508724`*^9}, {3.6539341291738725`*^9, 3.653934211112872*^9}, 
   3.6539342650368724`*^9, {3.653934304784872*^9, 3.6539343554168725`*^9}, {
   3.6539344720828724`*^9, 3.6539345049558725`*^9}, {3.653985953908575*^9, 
   3.6539859716873527`*^9}, {3.6539860028434677`*^9, 
   3.6539860623234153`*^9}, {3.653986158001982*^9, 3.65398619528271*^9}, {
   3.653990329959136*^9, 3.6539903314472847`*^9}, 3.6539906226214*^9, {
   3.6721502783052626`*^9, 
   3.6721503466110926`*^9}},ExpressionUUID->"7559b377-2b55-46cc-94fa-\
b52524e84e25"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{{{}, {{}, {}, 
         {GrayLevel[0], PointSize[0.007333333333333334], AbsoluteThickness[
          1.4], LineBox[CompressedData["
1:eJxd2nlcTPsbB/BTulTcRJbsk4pSaioqUedJaSGZiiSqMTsu5hIiy7GTbSxd
uZY7shVhdOtK93LHtV9hLBHXMpb8smXsIeNX8/0yr3n80+v9+jzP95zvPONM
nTkuosmJUmuGYVyaMEzjz/rCV1eGigQsQ//NsWvbOd1Rx74XJs6ePfAqu3ZL
3O1etnr28pOZQe02PGBnFUw84WFbw67LzWgqjnzK+qdGj3CyMbBjVL3P35Aa
2B76GzGtbd6yXQ5Udn2/4A3r+LzO19Gmjm3/8syLjS3fszZTlru2tKln3aJD
mri+/MDWf17ZvJk1A3XDggT6rR/ZD2EjFje1tobapyMkmdpP7LOT1Vk/WNtA
cNtC/h+qz+zjZgde21g3hbz6YcbatHpWP3j6TzbWtvC77uK4djX17K1VYY+b
WNtDSb+LE/8J/cJW6poKm1i3gDvZZY/Krn5hzyVvTLK2doC1HiVFn5sZ2QcV
Bx8zVo5gOm53I5tRu34HY9UKfJfemdFimJEd5TemC2PVGnrKPWqzkozs9US4
9ZVxgrj6hGubso3s8Ey3jV+ZNmAVcO/4sC1G9nKu7fCvTFuI1LoML7xpZM9X
6S4YmXZwZlHekL1/GNmYTyU5RqY9tNwSkF9y2Mie6rQp2sg4Q9kPQ6ZZvTSy
EaFzbIxMB1g48eT6OxVGNpQbNPcL0xEUB8O6fqo1suXbPft/YTrBoF4re9t8
NLJBJ36sq2c6w595svIbdl/ZkkevSuqZLlBpk/DByvYre7BnuU890xWO3A1M
crlrZL1jtz37zHSDW/vWLD32Z8P59w2/NofhQXTK8JNPdhpZp6jfi+dwPFgZ
pz24tsFXkt3XzmFc4HBlUcCxyUZ2WJZd/BzOBR67ej4ZqzCyPy7P9p7DdIcC
xvmSeqyRrdj0wn4O1x12lxh/YQYY2RV7M57MZlzh+a27k2IdjKxtRcTu2Zwr
7FdM3fKfjZE9fbt00WzGDbz8Q3h2n78Qc27gl/f3wMc51Iw7sNV53rXst9wd
0t+23dmh+Rc2eFGvvtlMD3CL/Lig3ZV6Yq4HxJ0wtPLbRc30hMu/TPU8MP5b
3hMiRnYXfGnyLfeAlORfNyyY9JnmHvD5gK3xcGtqxhOC87Ov9731ieae8GXC
zOpZo6mZXjBD/uKP5j9+Yvd6/VY9k+sFyZs89/+96yMx4wW3uh69H+ZPzXkB
tMuP0C+ro7k3PG83/9CxcGrOG0S3f8wvzf9A897w+HGny6HP3tO8N1T3GD9u
0g/v2c5XnX7JYnzg0Ir8ZmFN3xFzPlCQU/jWyeEtzX2hzrkouLLjG5r7woeK
dUzfvq/Z1U/shgxg+PCy87+CtkmviIEPZSkJC8c5G4g5Pqx9Y2TjnWuJtXyI
jROcOKx5xkaHRu7oz/hBnq+vNqz8CTH4Qaard68Hmf8j5vygfYsDR3bMqybW
+sGLv1ZdWD38Ie33h1vrRrSa5H+f9vvD/c27LzmU3aX9/iBJux3VJOs/2u8P
xb+dSnTLqGKZtXM/hzABcDcUPlRXVBJDALRlHnbo8/YKMRcAi8S/hNr9pCPW
BsC4VeE9FzlU0P4+8F87aeBZtzO0vw8U3e/+IXPaCdrfB6rGxn3K9tTS/j4Q
P/BJc5f/HWEbripJIUxfyK9torp1spQY+sKIRZtX9jqhIeb6woGrMUOqXxQQ
a/uCC9vpyKTB22l/IEQ9dwK/4g20PxDWnAosVBStov2B0OJ/HWWKAWNpfyB8
u16T/qDv/jn4zb5+gMwha5GZYOg/taXdvc9DWNIfDCPaHCz+wzOdmAuG0/lP
nkuUEmJtMNSM93q/8c5UYqYfhL7a0ptXEs82Xpb6Qb/v65vM9QMr34CfNryb
QHItypkQS0MI3J9ZWJV3I4HUcyFwoXub0eFXE2k/qmf6f/fDe/IxDbuBU8M/
2ckPy1iTOZRr+0PviM7PHgSmkpwZABMflXtWlw4khgHw+6Ark976daP9A1D/
ADD2nPdhdccktvEyHsSEwl1+pwPdigxhJkPo93qTOWRtKNSvUPutL4im/WEg
nOqwzW6oiBjCoEBpU9imfyoxF4b6w+CWMeT270l1YSOW3m4RxLDfc5OBhZjj
SWdzZyWzJnMo17KwYfxvq8+0yGT3Rkxa0omB77nJPAC7TtvSPc8LSQ4A2Vtn
3vWPsyYWAuxLvZLgIHMl5gB+WVfttuEYsEsnrvDvpG7IL46fH9pjCrHWvL7J
eoDJopj4HpNGkJwJt8x54dC51vVwjzvTSQ4oF5ot3lhwtyOHrA6HGx/u81z+
DWJN1oaD4t94tmBFJLE+HPTloqisbAExM9Cyn4cMyMKBUJpo+6h1dDoLx0/l
dOTMuclqZC2yHpmJIJ8369LIerwIOFnbf8mZucnEEGFZL4yAup/7RCfPHcc2
vos7cubcZHUEtNZeeHDqHwHJtREw3FrU2udROLE+AipnDq+/12oEMRNp2c+L
hLZftm/qecON5IByYSRU96wM67LGk/3YpuFCy5lzk9WRsOS0U/iWpUkk10YC
+T0TiPWonhlkad4gOHUq4cjy1PGkHlAuRObMbjyrDupB0C3/cpeTFyNZk7Uo
1yMzUWDVt/Sn/b4DST0vyjIHZKHZxYqQ/h24KNj2tsM+jyMOrMlqlGuR9chM
tKV5yIAsNHv1upH/c+aQ1chaZD0yE2NpHjIgC80e/1fmemcOWR0DvciFlDVZ
i3I9MhMLRQPma5KKBpN6XqxlDrHQ8eNfDwqjU0kuRDlndvTjtayzOhamOmaW
7HVPY03WolyPzAy2NA8ZkIWDYWLQ8aChv4Wyro4Hn7XnzLnJamTtYODm82DJ
alqvRzkzxNK8IXBgdHxSW8m7MJMB5cIh9Po5iB7fnDMhFRvbq5G1yHpkJs7S
PGRAFsZBgmxhnP+UKPa2+ElEe86cm6xG1iLrkZmhluYhA7LQ7COrmhracchq
ZC2yHpmJtzQvHvzSllV2GxvMmgwoFyJz8WDVXnL+9bRRbO5h1y3t1ObcZC2y
HpkZZmneMDgXHFUcXRBL1gOUC82ech9i2nHDoOPXTVv6XnVmTVYPg9HNG/8i
jiLWDoOrDxMNk71orh8GkxXutsUfndgjSp5bc0YAhzPCGv7U7U3sKICQtcK9
m0qHE/ME5v02mi+AOU3Wdxp0fTDJwZzv+cH3k70AWYisROYEsGvn0u2V52JZ
k1UCiFulu3TtWTKxGtVrzM79NVRnr0XWIeuRDchMgqUdE0C/pdWuo8ejWZN5
KOcnQPbiHz406RrDLvSN220P5txkAbIQWYnMIauQ1QnQYd+Fr/tWjyHH05jz
KSdTZ9trEyCl88X68Q4C1mQdyvXIBmQmEXKrSo/eWedN+h0TLXNeIigjPxRN
KBlAcj7KIRF+dlmjj/o3mRWOGpdoLzDnJguRlYngl31z+q2OfqSeQ7kKWY2s
SaTvTzc2vnaGh73WnJusQ9YjG5CZJEs7IvOQ+WYPWLjEaAfIAmQhshKZQ1Yh
q5E1yFqzvZxzr9npkPXIBmRmuKUdkXnDwcXaYfvgCz6syXyUg9kd9u/YaydA
FiIrkTlkFbIaWYOsNbvZwGLOToesHw6+Y1pccxa3Y002oJwZYWlHZB4y3+x3
17XJdoAsQBYiK5E5ZBWyGllj9sMJl7zttMg6ZD2yAZlJtrQjMg+ZjwxmX2Hu
WtsJkIXJ368vJitRziGrkNXImmQY12XEUMdp3ch62mRoeWxF4tZxP7La3OdV
tjpzvcn6ZJhx46ZqnkxAcgPKmZH0/DqT3HGkZc5D5pt9oFfDX26ALEAWIitH
wh6QyS/3d2dN5lCuQlaPhAVFe5Iz0kaQes1IyFyw9nWtqzW75W+7xbbakdAr
8PG0ky5exLqRoMkMGzBE5UKsHwlDNMFbPlZ2JjaY1zeZSbG0IzIPmW/2iuHO
o20BWZACvoJEoVWcJ2uyEOVKZC4Ffk0XeV/1TSD1KpSrkTUpkOHe7c/mG9qw
M5/08LPVmnOTdSnQZOCz++cjw0muR7kBmRllaUdk3ihQTYg4FTwvgqzHRzmM
+n59NFmAcuEo2PfAtWbhm91hJitRziGrRsGYmsE2e+cJyHpqlGuQtcg6ZP0o
qLrW+Ad/AlnPgHImFe0fmYfMRwZkAbIQWYnMIauQ1cgaZC2yDlmPbEBmRqP9
I/OQ+ciALEAWIiuRObPPlJetaqpCViNrkLXIOmQ9sgGZGWNpR2QeMh8ZkAXI
QmQlMoesQlYja5C1Y+DVzZDgqs0xLNk/yvVjoMvDnBU7piSR3IByJg3tH5mX
BgdiD7tPOd6P9PPTwGdt84v6lyOJIQ20NpPuXEgaSixIg5NuY866lo0lFqZB
bYXNiSNLYomVabC5S+GxNysSibk0UOYpVAv2CIlVaRA/u3RHcHQasToNPGqz
1t/LFxNr0kB3/fjxuydpvTYNbKz8M5+r6Xq6NPj1h1tdElvQXJ8GGc0udki4
1Z/uH+2PSUf7TweJS4jNapvBpJ6XDmmfNu70PzWA7h/VA7IgHZrkvnoZ4EPr
hShXInPIqnQoFjfe2aCvrxrlGmRtOv08cKP7T4eW17/2q9gYRPefDsf2OrS5
qrei+0+H+1YH9WeHOhAzGTA4zX/12ufhxI4ZMPrFWN82mlC6/wz4p0ybU/em
Nd1/Bhz5KfPisJ+96fwz4NgSfdnKzb3o/DMsz0+YAR3bOyySWDnR+aOcQ1Yh
q5E1GVD5dN8+69JgOv8MKPScNL+w+Zcwsv8M0HuVv/u1ax+6/wzo9u6Gl3cZ
S/efAeRnD9b0vRoj/L6+ybbIjsjOyDxkD2Q+crDZzaPcp1kDcgyyADkFWYis
QFYiZyFzyMuQVUL6fVBL1uQ8lKuRC4SwcN3NFT6q22Ema4T0+7X+pL9MCJmz
S4LFeQHEWiEsza+uHjGwBfFZtJ4OuQpZj1yDbECuQ2bGWtoW2XEsuPZuvPMU
SM7PGeU8ZA9kPnIwMiDHIAuQU5CFyApkJXIWMoe8DFmFnIesRi5A1iCXIWuR
zyLrkKuQ9cg1yAbkOmRGZGlbZEdkZ2SeCCIDVT6B+4eT94eHCLa1aPymIIaY
j+qDkUEEqmOxV9WKrqQ+BuUC5BQRvBmXkfPX+3akXohyhYjej40luRLlWcic
CKr/mLPm07NBpH6ZCAb0ZpW5PYFYherzRPT6GUVytYjeP+1CXIDqNSKQ+Shn
FnXoR///m/Nin0k7rLQiGPrf38VXdkayJp8VwVj/EfxehQHEOlRfhawX0ftz
3qS+BuUGEXxSWT1tH9iG5HUimBB/pMu0S22JGTHsDOC/Lu7Rg9hWbNnviOyM
zBPDxRdtxs6MakX6PcTAOZ5TiZ/FEvPF0Ph4zIVpqcTB4u/XE5Ohof+EXdye
af2JY8Qw9OikVs7PhhAL0PFSxPBm/tWfn7nR4wnFcJdpfACrM7EC1SuRs5C5
huPfT234xHcj/cvE8E5ivBw0jp6vSgyrXpSqP5zmEeehfrUYVujned085Efy
AjFsfz+6f0LrRGKNGNZ8tQ7nWqQRl3073zhirZi+n+jrcRatr0OuQtYj14ih
fuIwVVVtV7KeQfz9/guZvxgOyG3PeGf70/lL6Pzp8W0lMDPr0vxqW09iRwma
vwSWR26X3mGjSM6TwJ8bPz/yAPr+9ZDQ+9FA54/6gyVQcc0tK6Ijff+BBIx5
13cfOkrXi5FAwjuvrS0v0fMTSKBml0icHj2GOEUCdgETv/47WEznL6G//6fQ
+Uvo9zcxxEoJqIMaHyCk55Ml+f48CZm/BF54tbyS9EhA5y+BuZlP/5XPDKPz
l0CPkPPeAw/1pfOXQOgsxcmfF9eHkfmj/RUgaySwtOCf3+5fCKHzl1j+f9Wi
+rMScA+MSS47WUnW10no9TSY1FdJvt//IfNH/TXIBuQ6CTQ+bTe9dTidvxTc
z02d081hIJ2/FHS1KhEXGUHnL4VDAYsvTnhOXy9nKWReKo86Pz+ezl8Kxddm
/X159Wg6fyn8c6Jkcu3BdDp/KdzsyYkk5+j8gqUw6/QxycPjMnZU+8OXGZDC
0eSBM2K3SIljGs7HZt/T6hnjiQVSKDl3f328m4I4RQqjZ9tzr1rQXCiFC+sn
2Eum0/UUUtiWW/Kgk/1kYqUUriftO3jAPpM4SwqHX/Xs1ek6NSeFOz1ue71J
nkO8TApr56ikx0/OI1ZJgSkcuuX2S444Twp9f8x5bOW9gFgthdKvVtf3pi0k
LpBCXntht63lNNdIYff8bpWaezQvk0LT3m7CzJnUWimkrHIvWnWI+qwU5Jf7
t1VeotZJQakJ8nPrSV3V8Pob4hTrUuj6einsGifo01I4n7hGCivLr9/ds5ee
r0EKzbKdIqb407xOCntnX4pZFEVzRgb/y0kcqNk7l9hWBvn285YETaC5owzW
he3PZ/vQ4zvLYGvs5r3ZEmqeDPJ2nHk58RO1hwyiz8K2tGOLifkyKOpyqt/T
mmXEwTL4i9e97wtRDp2/DJYt6JCkOb2czl8GonfRzk29qQUyWNPRSeRTSOtT
ZDB5yKMFAXUr6Pxl0OLCtI7jClfS+cvA9LhLK2qlDMr9CwKDW62i85eB9/wN
DVdEak4Go35an3P61ho6fxm4p77OSp2rovOXwWperij6IXWeDLLH5TB7Zqyl
85dBV+OvRQktqQtksCE/N3v+KGqNDDwv/dV5+j3qMhksdvt91tL/qLUyOPUw
PzWyzXo6fxmsODXZ3qvtBjr/hvVvby39z4e6Sgbnj3kt+LqfWi8DF9MHaC6d
vwwEzKmz6/r9Qucvg4unB1f8vo66TgYL4227ZNptpPOXw/Skfye4Z1LbyqEs
N33zqtw8On85uOd6PubVUDvLYa4ybFpR4q90/nIoWhkVdjCL2kMOIbPq7+5m
N9P5y6G10zVD7yLqYDkc2d14A5wa5HCAGxg6x2Ybnb8cDB2W62wDqQVyiBz6
9qOHK3WKHF5wz3I63N9K5y+H+LKRj/eX01zR4Mi//5j76Tc6fzkUt35TtLMt
dZYcKubeeXLRiZqTw7yAxk8M6mVykGyQpzv8Sa2Sw/3ItxOe7aHOa9jv16l5
vr5qOn85HCz9UNirD3WBHBp+eXPSRVJr5GAdW3V4/TLqMjlkedi/XT5gO3nu
XiuH6K/nSxVW+cRn5dB9d2TroyupdXL453ZtdVg/6io5SNcIAnbmUOtRfY0c
7I8a3cJmUBvkcCgnyH9NPT1enRyGFSVVZ0fRnFHAw6DFufa9qG0VUF4uPjT0
mx0VMM+no3/XXdTOCsjpZxuSWknNU0Djb8uO06k9FNBhlP+Z1weo+Qpo9nRD
dNA/1MEKSK1ct3oKfwcxKKCxO2cEdYwC4mfdq7sVQC1QwLjVRfX+ztQpCujJ
33p9ooBaqICprw6HhouoFQow3Z5rT61UAL+yItU+hjpLATs7jU1otYeaU4Dd
6eO7xBeplylg2sH1n4pLqFUKONMyN6riOXWeAsLLq0oSbXcSqxv6J+38ae23
+gIF/JAouvF+OrVGAdfmXa+vG0JdpgBDgE9n23P09dAqwK3xcfpp3+avgOuF
r0NdW32bvwLIc/rf5q+A31RbDx+6SeepV8DT9bfHOm2irlHA7CPDVltHUhsU
MP7vUid3l2/zV9DPA2pmHHRJLqt29dzO/h+HsjWL
           "]]}}, {}}, {{}, {{}, {}, 
         {GrayLevel[0], PointSize[0.007333333333333334], AbsoluteThickness[
          0.8], AbsoluteDashing[{2, 2}], LineBox[CompressedData["
1:eJxd23tcTOkbAPBTQrUuQ6ESDlKpaCqUbuepVBOlkdRUqjOoGfdZ65Ile1jX
tcu4ZzcMWbf9Ibfd7GKP3WXdDRaxLrNYct0JrVTqx3nfnfnM0z8+38/zvu+8
z3nOnDnve47uoyanFdgzDNO9GcN8+LdhZ/XllFFKjqF/xU4dPPNkRi6nZMH0
oQeucCtKk2/5OZq4v2Y/UX37+h736Y6Jv/o6VnFHuyZ/sfziEy44O3GEi4OZ
e1zgerbPbjPnbbquaO/wmvvu4In+0VdecbJntYEyh1pucqnrw6hl/3IOU5b0
bOvQwF110vaYUFTLNdR/+VFLewa+ivGZ3ya8jnsTPWJBC3t7CF7ecFz8pJ57
+tvfRc3tHSBk+9lRo0IauIct97x0sG8B9m02Dz7f9R1nGjx9goO9I9S4XJjU
58o77uZX0Q+b2TuDd7+kgN6hjdxVYwu+mX0rqOPdO/94o5E7nbFuuL19G/jN
Z4NC3qGJu3du70PGTgYh79pXXxvYxOW/WFXG2LWDmS1av3MZ2cRlBY3swti1
h5bPxr1cPaKJu5YGN5sYF1gXumj8oUVNXPpUr3VNjCuY685lbdrfxF1a45je
xHSAaavcHDIuNHFnK43nG5mO0Fiddyh4cxOnqDv4RSPTCSbMaGssntnEnei8
PrGRcYPEZVNbJOQ1cXFRxQ6NjDsoPjR418hFCfFz3jEekLm6/bwRNY3cj5t7
R7xjOsPxsIqp5w43cqG/tq5tYDxhAud+/9cJjdzBB9UHG5gucCmrsN0Xz99x
e31+7NvAdIVRGucN11XvuICkjU/rmW5wNKz66rItDVx6/5g/ihkWVDsNW550
auBcEg7sLxZYKH171ZMtqecuZ/RaUcx0h4OeVZu/P1/HpRY5DS0WuoP6t2g7
1551XOslswKKmR7gPanDb5D5lju3/rlzsdADTuyKKfmzuJZbuiv/8WymJzT6
+6cMnvuGczwXt2220BP4KWWnsj//lzt569D82YwXrHX6+Y+L39QQC17w2Y2o
mSrf1zTeC97JOgeUbn1J472gYMT8b74cV82FzffrP4vxhttrcuUVD/8hFryB
/SPeuUD9nMZ9IC3gh4MeK5/QuA/Yhdw9nlr6iMZ9QTG5Yvktj79p3BcmFyy5
ELz0Ho33hrKZzNKGT0003huqjpzsO+zoLRr3g7wFqzel11dyu/w3/T1T8IO5
oLm87clVYsYf2PVtNmyccZnG/WFd2rovR3tdpPEAuDGrOn7WkTM0HgCHOhef
a+lwksb7wBj2Yt+7db/QeB9Y2+PtYLbXMc7zisvaIqYvxF4svPpo3A/EQl+I
TK5/2PhkH40HwpPmmx4+iN9G44EQmva94uZXG7llj52GRDJy+OToxG2xkSuJ
QQ6tPep8KlQfEwty+O/6IFm0OjFqUFkEEwTVPz1e2+VePicZgmDhj1nn5+v+
jZYsBMGZnRvU44ZEkbj4Pn75/MEDG2XETLDteIAsIItWMyvm1IczIZDz0QHj
hbEdOckQYhsXQsCjaX1p/ytuJC6GQPoD2cef+PUmZvrBgBYbZOFVsbR/P7hy
e9qAB5sGEgv9oGRr8AlPh1zav59l/IoHFcPDmf5g8v+x5uuugzjJ0N82LiCL
yMwAmJjav9vs851o/wGQbj+qfd8HQcTCANQfmQmF8BX8rvWH+nEfh736biCE
WuKShVCIqbB3rnndncRFFGfCbA3IArIYBsPur548IaATGY8ZaIn7fdnHYSAg
CwPh+5Tqih0dh3GSRRRnwkHY9PFfoPAmcQhH/ZFFZCYCFp50iSldFMLdv6sZ
GQYRcKjJ7tqu3DhiIcLSXrIYAdOXPNk9d3cwiTORtnFAFpDFSOjm0vv8w49V
XGnIloOhTBQ0+nz2ZplHHDFEgXRdMPQiFqJgDLf0W8WxYGIxCl7k7HZZd78D
7R8NL7+/PP7AvjTaPxqap3bPfJKlpP2jQR08Qu63syftH22Zz4hFt1qFMhxs
8Lsb0n5zDCcZOOC+O7f62t1gYoGDcUvWXDr1aASxyMH0upjcrcoEblfcpIWd
GYBzp8Y5BDRzJGYB7ntsOt0404MYwPJ5knmAIC60X8H2VBIXAKoHr3xUF53M
LZq4NLizwRqXLFr7SzYBTM0bvW7HnXASZ2JgTPm99PHqBGI2Bpb+0veLrrUK
Yoix7c9b/WEUDwHZEAPt7vff++R/3pxkEcVNyEysrdlYcD6yKnX5xN6kP6A4
HwvPhs7YWHShBQfHT3zhIVjjkg2xlvNZshgLqsbZOeXpocQm1J6JszUbB27O
lW0Snr2KlgwozsfBX63HppvG+HOeT+8N8BCscckGZDEODqU5PmifGE3am+Jg
WL1j5jfZ7YiZQbbtWWRA5q1+68rcdxeQDcgisgmZibc1iwzIPLJg9dXoLsvd
DcgisgmZSbA1iwwJUPXtqNF5icmcZN4a368Nj3AXkA0JMOOW+f0vYgonWURx
EzKTaGs2EZodiF3x4lE/0h8S4eq5bGdFfSAxb22/bGXmIzcB2YAsIpuQGYWt
WQUUQsvtqUdcOcmA4rzV445MXeUmIBsUYHyhHyUMCuEkiwrwIxdWYpMCmgcZ
DwUaEomZJEiNaOifVTaUmE2ChLiTZem/xBFDEhzb1cb1ismOmE+CLd51s1e3
exNNPj8J3ixfUCULC+YSH67g3AxJlvlIFpFNyMxgW7OD4X6wy74+O1zJeIDi
vNU9ZXufdhKQDcjiYKib82GmYZxk02DwbGVsl171KFoyM8S2PYsMyDyyYDUT
fm5dJwOyiGxCZpJtzSJDMpT/vebpxJB4TjKfDKNcHZZP/iecuzX6cVwnIRl+
exGx8Pc5GcSGZMvvnWQxGaR1jCyC2GQdXzKTYmsWGVIgQD3xyw1mOh5vjR/+
qoW5o4BsQBaRTcjMUFuzyIDMIwtWr/mhZ2lHA7KIbEJmUm3NIgMyb/WU978y
HQVkA7KIbLL6sI71+ohR2lqGzCLLkcHq7c0D65yVyDyyDllA1ithSHnY+yVo
ACfZgOLlVq/5OsroLCIbkU3IZmRmmK1lyCyy3OrPA5O3OQOyEplH1iELyHpk
A3K51VN+y57tLCIbkU3IZmQmzdYyZDYNfgmsebWtRzwnWZ4G2/cd7fj6joIY
0uCmg9ta7m4Cx2eNTXNWpoHzzQfmJJ9gYt46nmQdsoCsT4PUM1sXDmA6k/4G
FC9Pg3D7iqwjKgU39MUMX2cxDWaVZZQcuw7ExjSYGHo8NGVTF2KTtb9kcxr8
akguO33Cl8SZ4bZxGTKLLB8OkX043RofJRf5+cJGJxgOqVU1PtWH44iVw2FA
VlnXLZeiiHlrf8k6ZAFZP5yu12JIfwOKlyOLVvu7rfnDyYhsQjYjM+m2liGz
yHJksNp9d9kuJyUyj6xDFpD1yAbkcmTR6pax+wUnI7IJ2YzMjLC1DJlFlltd
c03McAJkJTKPrEMWkPXIBuRyq++PvxjgJCIbkU3IZmQmw9YyZBZZjgxWX2bu
2DspkXlkHbKQQfdvvDnJ+gw4EH950uugbsSGDLBb/NOnHdy7EJdngIt5vJfT
L82JxQyYtaD5m2ZdwzhxzbNKR6N1fMkmZPP7/pVvIm+uqo+WzGTCsY3php9O
u5L+sky6fo4lZjNBp9zHfn7WiVieCXEnwj5zce7O7fGr3+MImZbxJSszYd6y
jENbyyJJnM+EZ4VPF2xvkBHrUHsBWZ8JY7uMSJFNCyTtDZmW/SrJ5db2pT87
LXAUMy3rVclGFDchmzPhxO55blU3fUh7RgVXHd8lH50URCxTQX7LC+7DbkYQ
syq6Hg8jlqvA4+2RezsTw7ml6W45jqAC30S7LfzJQcRKFcxy3ZP416fUvArG
Hw5xafVoMLFOBTtTSm/9o/QiFlQQqEzj7ZKTiPUqy36GZIMKTv/+wr5X8wHE
5SrYo3H8PWBWLDfzsXeQo6iCdlPuNP3uFEdsVIEwl4WFy6KITSooXhkxoUdI
KLH5v/n2I2ayQH/r66k5PWhclgW5deu2Bp9IJmaz6Pq5L7E8C7ZDoeZSRH9i
yIJma6r/CekbSazMgrYVe0ra3RlKzL8fbwnUtO2RRKzLghNnrxzeshqIhSxL
fSTrkQ3I5cgisjGL7t8MpvlngTG/ql3ZowSaf5alviT/bOjZ58Od5QCafzbs
H/1hZUGPB5sNDR5J83TNB9H8s8Ev2/WSs6Y9zT8bLtefvL4xi1qZDeNjm3bm
VrjR/LPhq+eHDG9Oymn+2XB4wtQLqR8H0PyzYV6F+sz0qfbE+mxIOTqpndtT
f2JDNso/G+4wHzbwaX8xG8IXbBswb2MnWv9sCCvSHR+9pCqa5J9N98+a0fyz
6fWG5svk0PUFPZ9kOZbvH8k/B+pKf8oNTImh+efAyrOfKX4u7kPzz7GdnxKZ
R9YhCzn0ehLE/f5jxVct9Dn0/teT2GBtL7kcWUQ2IptyYFiN/4a2F4PJeOYc
+Ltz57PNi1oRMyNt28tGQsOG0PwBQ15FS2ZRXI4MyEpkHlmHLCDrkQ3I5cgi
snEkxG81OV5T3yTzN6G4GZnJRfkjs8hyZEBWIvPIOmQhl55f1WS++ly6f9KT
1j8XLvyV/Vwd6Epcngvrqr/d5vJzLWkvovGMudCufuda9z9lpL0pF5b+ceKH
41/T/uZc6B5dfv9nYGn98+j1vzuxLA9y3R7HP5/Tn5jNA+chkYYJZ+KJ5Xn0
+tuDGPIs99Mk/zyomZf6ycsedP58Hqx/2X2Hx1E/Yl2e5XpA8s+DyaMUQ70n
0c/TIxvyIKzwxirxYTLNPw8GLVkbuXFtILGYB/P+tz0jP7cXsfH9+KcXxe+b
607zz6P7qXQ+5jw4MlPauab559P9XG+afz5c1w40xk0cQvPPp7+vSTT/fOjO
5sc2X5RI88+HJ8bHM0M7DqL5v+9/Q/9ZoYyj+efT5wE0H10+vZ/pQ/PPh3DW
qX56+xiafz78Xqp5NmRANM0/HzLalixKfgs0/3wYG7HtxZm+YTT/fBjv9+EX
ui/NP5/ur9PjbcqHoNzFV7upaX3M+fT5Q39uTO6thGYMb1lvS3bkIWHtuX1H
vutKLHvvPbD+6Y3aaMluPHh0ajN/jF1PEmd5SHmeYZqWKCP25cFtvZDfMwmI
5Tw8zl95xvUTOXEYT59vAPdRQq9p9sDT39tIYgUPdttaeRov9ydW8vBNl53H
Xi0NJlbx4BdrePxnWG20ZJ63nP+Stcg65CJkAXkxsp6HwuTjHporQeTzS3gw
1g2+ti6HITag9juQy5ErkEXkU8hG5EpkE3IVshm5FplR29oRWYbshsyqIe36
zfr0Dn7kePiiuBw5TA17coYO7zCmA62/Goqbreocf20wrb/acr9B6q+27B+S
+qthvmKhZ85Fev7wast+Oam/GsqnRkcO0Xcn1qHPL0IW/mtP67tYTe/vehHr
1aAos/f5U4yi9VfT+9WBtP5qy/NiUn816Aa9+d/4gwHE5WpYU3no6O2VrYgr
1BAU7/rCHPyCnL8ims8pNXQL+nTSZn86H6Pa8n0m9VeDp9egt/M69iA2of5V
yGbkWrXl+03qPwrVH1mG7DYK9s+dum/styzpz6K4L7IcOQwZkBXISmQVMo+s
RdYhFyELyIuR9cglyAbkHcjlyBVW7+87qcxORD6FbESuRDYhVyGbkWuRmdG2
dkSWIbshs8i+yHLkMGRAViArkVXIPLIWWYdchCwgL0bWI5cgG5B3IJcjVyCL
yKeQjciVyCbkKmQzci0yM8bWjsgyZDdkFtkXWY4chgzICmQlsgqZR9Yi65CL
kAXkxch65BJkA/IO5HLkCmQR+RSyEbkS2YRchWxGrkVmCmztiCxDdkNmkX2R
5chhVmd1+uESA8gKZCWyCplH1iLrkIuQhQL41mf6nG/avo2WvLgAQuemK6c0
u0qsR+1LCmB1w303r0oXTrKhAAo9bwxxmtGaeEcBXW80Iy4vgPFDD3eZdrGG
jFdRAJsD73xUtvQKsYjGP4VsRK4sgAunHzYPsXtC+ptQvArZjFyLzBTa2hFZ
huyGzCL7IsuRw5ABWYGsRFYVwpzdC8KyGy+R/HkU1yLrkIuQBeTFyHrkkkK4
7dRpkvF0Jfl8QyGc+8OrKM6jA61/IeR6lR12WNue1r8QTt8d9WR4iIy4ohBm
TujQ5kL1R8RiIXSsftRLJrYkPlUI2pQoz0mX6PljLIQpczu8b8EQVxbC/tyE
jJ48PV9NhfBCo1m0p+4lcVWh7flhLoR3M/ayLwpvE9cWwrG90bduex4nZjSo
/sgyZDdkVkP3D9qR+flqwO3mP1zV8rbEco1lv4nUXwPtrs+KuLLGiRg0lvep
SP014A07Hp6PdCBWauj6y45YpYGcR/OnLfZqovXXgGLvka9fXq8j1mrg1dj8
L478+y+xTgMpf5VOyJO/Ii7S0P29f4gFDd2f8CDjL9aA8ZrnrGEd3Yn1Grjv
nRXVcUUn4hIN3R/pRb//Gph/+PbZ4iletP4aOLbQVPHlN360/hq6XuhN66+h
zyt8yXv3ogbIutyb+JSGrs97ERs19P1OL+JKDURtXNut4kxPYpOGvm/Rg7hK
Y1nPSzZr6H6HP3GtBhz35t7Uqfzoe/9a6/uwH/4ctZb9BMkyreV5rmQ3LTxK
Gzni39wgYlZL97PlxL5a6FZz3T+gIpBYrrXsn0sO04K356dLF72h8wMtrPv7
aXDDdjo/hdbyPqdkpdbyvqZkldbyfqxkXmtZL5F0tJb9Bsk6rWU/V3KRFm4+
PPl6fi86H0Fre7wWa22Pl15re7xK0PEyaG3ruUNL30/yIS7X0ucXtL4VWqjW
3l98qJbWU9TCq2nujVdaU5/SgsrzQsO4NnT+Ri10l/7DA51vpRZS/vx5/+Wt
/Wj9teCXHtrpsz/p8ap6P9/ze2b5t6c2ay3Px0j9tZbnIaT+Y+nxj+D+DynV
Zjw=
           "]]}}, {}}, {{}, {{}, {}, 
         {GrayLevel[0], PointSize[0.007333333333333334], AbsoluteThickness[
          0.8], AbsoluteDashing[{8, 2}], LineBox[CompressedData["
1:eJxd2HdYE9nXB/ABUQHLBpEitiCoCIIBpJc5gEBQSkCalShp6qqxo646oiLW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           "]]}}, {}}, {{}, {{}, {}, 
         {GrayLevel[0], PointSize[0.007333333333333334], AbsoluteThickness[
          0.8], AbsoluteDashing[{8, 0}], LineBox[CompressedData["
1:eJxdz3uMFtUdxvEfLyu8u2g7FYWXi3UoF1dAGLDIy/0oCq+KOOXmgihT0Lq2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           "]]}}, {}}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0., 0.},
      AxesStyle->{{
         AbsoluteThickness[0.8]}, {
         AbsoluteThickness[0.8]}},
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      LabelStyle->{FontFamily -> "Cmr10", FontSize -> 12},
      Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
             Part[#, 1]], 
            (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
             Part[#, 1]], 
            (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{{0, 50}, {-0.1, 5}},
      PlotRangeClipping->True,
      PlotRangePadding->{{0, 0}, {0, 0}},
      Ticks->{Automatic, Automatic}], {186., -114.02727092435559}, 
     ImageScaled[{0.5, 0.5}], {360., 222.49223594996212}], InsetBox[
     GraphicsBox[{{{}, {{}, {}, 
         {GrayLevel[0], PointSize[0.007333333333333334], AbsoluteThickness[
          1.4], LineBox[CompressedData["
1:eJxd2nlcTN0fB/ArocJT9iz9DEIiWtCC7qeSQsu0b6rZZywxSmSJIUv2LJF9
7FkbezyWqUQRjT372HeyC+VXc86jV7d/er1fn+859577vXNn5t7pJBoXLDVi
GKZTfYap+f9718er/iI+y9C/VNNWHeIsdOzSyl6rOldcZ5et97tna6JngzdO
dn3r/pSdkp1QYGPyko08/9Fr+7K3rGO0T1gL43I24si2rR1KPrLd9Ld8mxt/
YX9NbN6sqvALa/H2Rx8L4x9sh/IK4Wz776xx4vwu5sa/WfeGPQOOtK5gf/9a
1LiREYMd3qnLB+z9yX53D5vT0MgILTbq3gQ+/sW+OfsspYGRMUwr/U6NbVbJ
Pm+0/5OxUUOs4nVR51+pZPXDJo4xNjJBRXNbl5O8KvbOYvfn9Y3M4HDtW87e
vlXsDV1DQX2jJpi+6Pho08lVbHH46hAjo38wpepw0IYlVezjkpznTD0LNPQp
3pO0qIqNf79iK1OvGbQH5KXSUVVslMMIK6ZeczxrHO2rVVSxN4Nx5w/TAl9n
Pt3gFVXFhk6wXv2HaYnhr9bEiXpVsVcyTUL/MK2gnWgv2sRUsRfLdJeqmNaw
2Xioweyblazvz8MLqpg26D3x117HFZVsYfs1PlWMJcK2vLV7drKS9RqUalzF
tEWregEfHqdWsoNU3tMrmXZ4frGxZuk/leyJzT0GVDLtcSlp8OnhPSpZ54Km
P34zHRDUItX9gkkle/jpx8O/GSsMX/7ip/u932xO9xO9fzP/w/JVF+42u/yb
7TV045tfTEcUdV0y0OL2bza0n8f1VIaHuwlt1r758pttMeTQwVQVD31PpJWt
mfWbvRredVkq0wkWKQLmUf3fbGCKaUCqqhM2Xs37yc77xTadP7VXKtMZjZtE
3X9d8ZMtWfPOLFXVGUm2bZndKT/ZhbvjX01jumBkVdbNHR8rWJMSrx3TVF3Q
fQzb9klaBXvu3pHZ0xhrTPDu0SmyFbXKGkcWVOlKVvygeVcs/Z2nTfrwneZd
kfarnnkTwXfWZbZtv6lMNwRmlL3/n/obsaobrntVr8CSmukOsejz+ATFV5p3
h1NoYehPU2rGBrvOxAnzUr/Q3AZHZ0/THbr9meY90Lriq9cYe2pVD6BlSdas
fp9obotlTVyPbuz0kd3dc9OzySpb9J3ZubVDr3JipicO2tW/HHzwPc17ouKU
/4xvXd7RvBf8+ziserX6Dc17YW2XnmeanHtFczvsedftx45XL2huh6lOo04P
c3/OdrjWYlUK0xts4uirCabPiFW9YSTvERWQ/4TmfWAVVSG1H/KY5n1wvO/0
R5nb9OySV6bDBzL2aBp67kxp7n1i2MPJITb9Rse7xCp7VNwuSg65cItYa4/C
id+Z+6tvsD6DBm8dwDhgcgmkv39dJYYD+L/2bbAx1RGrHDA/9u5du+JiYq0D
jt6OnD85/Bwd74iao7N+dj4d7wiThhbuKxWn6HhHkKtTLh3viCX1c1YNcDrA
Msum/3JjnFB5quX/+v67gxhO+P1gB/tr2RZilRMsO+/MeTF6LrHWCf9d78j4
vnWNvhhpFeZvkdyHjufk2lrnPs0NcWP6Yai5154VThNYg9EP2kY5sXeUKcSq
fvBJkjxbnacg1vbD+RYe6+e1oDnTHy1NBhTu9qBG/7rzq/rDcc+kXKt2E+l4
Ts44o0X5aGvTfG92vMvnPa5w/psbrHJG94pmZ0RNI0iudQbP6/w/tuNjiRkX
nCg7HGzyVETHu3DGu8CuwbZKc81EOp6TM65Y9yfCyvVqD9Z2kZ2xK1xhOH2E
NsQqV2SWHTl1f7kfsdb173iDGTd8HdmqcvOaHDreDci3FxSHael4N+zISlNv
DSuk490QLtqYefjxJWJmAIYaLvzX2CcP5SNcMABur1/mtrt9k1g1APc+djvj
3f0OsXYADmz3CRm05i4xMxDGT/RXHV7co+MHgj/27vfsMw/o+IGYsLbBHavg
h3T8QHgeyZv/8tZDdr3TlsPOzCBYN87S7hugJ8YgbAvNbzGlkuaqQZhx2i5y
d2Oaawfhara2uL/yv/Hu2OsKex/z/8a7I2DwmaPTp1Cr3JHs2pXX7RGt17qD
t9rlEyQP2bB595o4Myz8HjBOD/MeEINFithDyN9BrWLxImzDDaOp94m1LKqv
5l7zV91jd3uNndueAdb7+zDOC+8S84DJkyR7+/+5TYzqv76fn641KiMWAE9a
f07yCrlJrAKmzru7Wehwg52XsNCxvRqQfZu86FPJVWItYLjum1DrgTYbVy9Y
PFlHzHjgcEnnljEepcQ8D4in5Dc3t7lEDA8MsTaze1NVTCzwwKjezpavNUWs
eHX2g3YqD5TKcaptv0JitQc6ZK7L3n68gFjrAV7smOgexvnEeg94Wnst2Sc/
Scx4QiQ323Cr7DgxzxNPztk9fzH3BDE8sS34raLD62PEAk+0l1bKRCcOs8gr
XNBO5YmtryPcOm48Qqz2xMWRgcWuBw4Raz1RdnXrro0lOcR6T/w5YGFl5LOb
mPFChw9LFt14vpOY54V1j8cH2XXeQgwvPCjeef5okyxigRceWV/qeO3ObLbD
m8f926m88Nw4IfHHthBitRdOt/7ywNIog1jrBR8rq4gu/yYS673+vv4MZgbX
NY9jDEb0rEUqMx8BGS+ozStaMk/aqjhWD0anC20OZ6jGswZrObmeY8Yb19ef
LDL+PYrU87zr5vBGYP2GQzeF0/kE3lhfuHBOp8QFxCpvqD42afezezp7w91q
aVu1N8a8bX4jpv5UYm21X10JDXweT6yvnd9gZkhd8zgGx4JaH1S4DWirGoJr
AZeeNfSKZQ1Wc3Itx/oh8PdrI/rqE0nqGR8MSDI3ffgrhpjnU7cePtjbtu3T
3vmhJBf4wNKs7J8hb0PYJcsjXliqausNVvsgsapby856Psm1Puhyy79HTqaS
WM+pZ3xxb9b2E6rVUSTn+aLtH/cn+TMFxPBFI+HY74mbxhALfCFdPCV9yCQV
O+rkhBWWKl+cevb6fLeKIGK179/5Ddb6opvbxV6eB8JIrufkzFAcFHexyHkT
QXLe0Lo5OBYMxTvZELZdwGS6/aHYmsO7FNk3lfV5voy1VFfP9+miYJGvhFhb
O95g/VBIiw58bfJIQXJmWN2cxzGGwTx3f1azBwGkXjAM+06fsOUvXMbW7HUb
1TD8/JA3enV/P2J17XiDtRzrOWaGY8va5XsLriST8bzhdXMMx73cwt/3dBNI
LhiOtLx+k76cmUa3X1vPuJWsbqMejrOZhyYNiUlmDdYOR5jhDXQOsZ5Tz/iB
fO8Tkpznh+pvOy8/PVcRww//VMgbfpyZQCzw+zv+nviVVxuVHz1/hrIGqzm5
1g8DRx+LVexPIrneD7z1gVZ7Vo4lZvzr1vP8wVZd3eJeHEty+CN4evC7ax8V
xILa+uOLG5a3Vvnj9Enm18vrUtZgtf/fz1cGa/1RuNRhkl2nccR6f5Sf3dvG
y3U8MRNQdz4exwjAQv2MnrcP0HoBJ1fVOvNYl/Wt1QH46eUUuL+HkjVYG4DK
e7qVG6ZT6wNQsflq+prUOGImsO54XiCed0xdscNjPMkRiObbT+W16ZZELAjE
l+3H2DZNR7KJj+DbWlU73mB1IG7NXTC+qlsoybWBaJb44M95Uy9ifSDeBkza
mHK5P3tcybNuzPBxm625wo4jtuBjXX3jpC8/FhPz+Pj8XLnvm2YSsT0fT28/
i+l4M4YYfMzMeXlz9BQVu7NBn59mfD4yvtR8oBtJLOD/3T+DlXz6+UVIchUf
zoVPtkQPlhBn8PHu2MQt1taziNV8NN1Zcsl5yzpiDR8j+y8tEFStZTPXDtKZ
afn087OaWMdHzttZ1a+QlcR6PsodC4ZEnZlMXM7HHs/6B8ZUn98GM0FIiAyJ
ajlxPLFFEAI8pvdPvD+BmBcESf1XomvDlhHbByHD/1OX6YUL2LQ+fjvMEATD
93hBBjE/CKe3OUT7hKURC4Lw6crjRcIAFbEyCJrxlf+6J00kVgX9PT4GZ3Cs
5lgThKnyw2FDJTPYxLPR08y0QWA7Ss82UI8n1tXWG6wPwqWaj1fXgkleHoQn
LuWjjjt5ETPBdestOOYF49bD5qoZw6Sk3j4YK+qpF7Q/piBGMLJ3SUenLlOy
gqiRwWb82vEGC4IxrpdNkwt9F5BcGQz740GSfZtnE6s49RnBcHTjmf6aGExy
dTAaOOiO9FH7EGuqt7ckbFjpFxEb8H6SjZm2drzBumDE/Xv4kaaviuR6Tl4e
jJKj126mCwaSnAnBbN+5HWJKlcQWISjtM0wX/3ImMS+k7nj7Wg9Mm1tlihDY
XxfOiXGfxRrM5+SCEPQc0zCXFyMjuTIE87vxz3aem0CsCsGfQ8/Px0dPIM7g
jFdzrAlB4cCeIwudB5N6bW3e0zLzuqkuBK+qv/1krhKyButD0Gdu4pbYORLi
8hCoqq9mzdInETOhf98vDLYIxcXjLSMyU2nOC8WtzTVvUOOJ7UPrbg+haM3P
3rlUO45tu2/rblN+KC4VL/TT5giJBaH41N22/c1QGbGydrzBqlD6/hpH8oxQ
PLQ0UolLxxKrOfWaUDRZsWtW0NAEkmtDUXNbS5nBZxt5HlSZ6mrrDdaHYmWz
NqohrxJJXh6Kxe+OqL+fExAzYXjRt/HhAdsiiS3C6o7ncWwfBq8LgbtT3eLY
rze14aYIw/Jf8jZWd5oR88PQKafRisdPQogFteMNVnKsCsMMww2XeFKfwcnV
YRieXK+P0xgJyTW1+ZPRpb1MtRzrONaHYf1ZniZRIWQNLufkTHhdW3DM49g+
HJYrquLMzEeR+RCOXr2XXPC/nsheZR4YmfLDEaFZnHJwXRSxoDoXJizaUC4i
VtbOZ7AqHG2a25846TqN5BnhaPog4pnnsxnEak69JhzrljBjW/eZSHJtba7N
fFtmogtHC2HBtZ7SKNZgfTiGa1zWV9wYSFzOqWci6P2eQJJbRCDtnnfWlhGj
iHkR2Fn6T/UZOp7YPuLv+P22v/abgGN+BHzzQooyp4SzBgsiYMucc1K8HEes
5NSrOM6IQEGzmm+cfqReHQE3o9yok5GRxJra+vVnTOeYaCPQoufWZaU9x7IG
6zi5PgIteWYyv7xokpdHIGre1j0TJiUQM5F16y045kVi1t6d4fGx3qTePhLH
E79dVuxJZBeGWsaYIBLazmempzcNJ+ZXe0Xr3ns0rsSC2vkMVnKs4jiDY3Uk
HoxfsOTpp0AynyYSIas6LUkeP5qd/Kqbg4k2Etk7rN8oJ0iJdbXjDdZHYk/D
mi8w40hezsmZKGQe8f+Ymy0juUVU3ZwXRd8vnUhuz8nBMT8KX0aprvK3Cki9
gJMrOVZFIffi9PuvLoeQ+owopHZ6evLPUmp1FO64uZSts0wk1kRh5ZycnORd
HnT9nPl0HOujEOzVXtU0ne5POSdnouvaIhqG2y0H+KSeF40FL2/dDPwzma6f
U49omJzvNbV52RiS86Oxavkz65Wn/1s/p14ZjaM1h7u1kOQqTp7BsZpjDcda
jnUc66NBnnMp6fo5ORMDs5kjHhfVp/tjEcPpfwxsQ53bzLgrpuvn5IiBc+ii
z86b6fHic3IBx8oYHA/dbrf/40i6/hg0+19ChwOtx7HnT+QubpgRg+oXazv5
NSGxOgYfzWOm9L2RRKypnc9gbQxKxJeKeJOCSK6Lwbb8Ms+MtGBiPae+PAYf
nl4TxzQcQ3JmBDTnBw87NNmP2GIEbseqt2mNFMS8EXXH23OMEX/fDw3mj8BS
q9DHbueSiQWceiXHKo4zOFaPQC+LQT1WtJtC1z8Cb+93/BDW04tYy6nXjUAb
b/NpTcKn0fVz8nKOmVhYDt62I9Yvja4/Fo/q5eiL/KvcyfpjOevnGBzzY7F/
6LGuiXmudP2xeNa95s7RUGJlLPo33GDh9pL2RxWLlxXXhiS7CWj/YyHrrZy8
t+1I2n/O/JpYNAjsFPE6ik/XH4u99YZ5LfYU0f5z6vUcl3PMxNW1Bcc8ju05
RhziP1Sl5ETT/eVzcgHHyjgY7qNb0P1VxaFdwXq1/z//nf9x0ExwHzg8g57P
6ji8WlvsfPcePR81cXh6+obbeNfpdP1xaDz1zqOcYnp+6OJwUfH084KdY2n/
4/4+jyHrj0PTPSldPhfF0/M/nrP+eBS9Di8d+iGGnv+c3D4eDt4t35c70vMD
8XVfr/x4zMvO3/ToUjTtfzzyCw6Pe59DXx/KeHq/k+aqeByLd49yGGFH18/Z
nppjDcfaeFzxWK18aUfn18X/fT8j66/e3ommo84cEdP1x+N9iXHB8blRrCT2
3pD6jODvfAabcGwhwK8Yo/LAXcGk3pKT8wSYGZebJNwWQXIbTm7PsYsApu03
xvW4yGcbD+mabITa3GBfjvkCfFQ8ST/yI5TURwr+Pl8yWMCpV3CsFCCp+tvP
yk0TSH0KJ1cJMHLAjvcXevuSPF2AZ1cWa7LTk4gzBEi+sLW9MCiIOIszXi3A
9RtWCxOCx5M8WwDz95fvJLQZRawRYN6jLqJh1jTPFWCH+LLTt64xxFoBxol8
A7qN9SYu4syvE6Dm6Vj3W31JXibA7RRN4dhNycR6ARZ9Krko/J5A/JIzvlyA
vYsPtIibRdfzQ4DLBaZ+O5OHEzNC2MxyMe9uT8ebCLHOatfpzwtFxBZCWA1s
sdZ6lYTYUojZdjU/YEgj5gnR9FGWNNBoNLGNsO727YX0euZKchdODiHaVZx8
vMuHHi9fIS7a7Zt7dpCMmF+9vSY1d5zG0f4LodOxeYULhtH+C5FstbtHsdsI
YoUQzRbsU4+cLyVWCmFruODQ8y1FiKygXscOtwsmVgmRGGTXeUHxANp/IW7X
PK7soKL9F8J701LHx0ZK2n/O/qs5zhbC7M7T8qHdE2n/hfT+B11fLqdeK4RT
8Idd67/R41skhOekoetbBYmJdUKMuFAh+lAYQfsvRGREg1EOKQrafyFOf3dW
5LiPpf0XYlj35n79DtHjVy7EvjEdP63aE0/7L8SWg0J/aVAK7b8ID8ckiafk
0+NhIqq7fxYiZLs9leXWo8ffUgTH/bkuts70fOaJsOdQtGDpfLr/NiJc7ylt
+zhSTmwvwpiUKdt7edH+uIhw+/L3kCfbp9LXv4jej5lG+y/CINuqD+lm9Pzm
i5AQ1vx2o6ghtP8iFNa/sGPEo1Taf87+KkQIXZgu+tSQHh+lCKj4d9L1LAHt
vwj9ejS4H3c1kvafMz5dhA1pcs8VZ+n5nyGC+9s5RkfThLT/IsxrWd96Lej6
1SK0HlvhO2wKnS9bhNUTVqbdNqbXEw1n/lwRarqzyiiRPdh77NZ6WhGk43q8
WHhqEnGRCLGVZdbsY2qdCO373LduOFNKXCZC+Jd5so0jkoj1ImgWNb3/1lxC
/FKEzi69n+xoOIq4XIRPWTMv/PgeRfxDhKCvPTeYl3oSM2Lc7Xv01qwHMcQm
Yvp6URJbiP/uv8GWYnjkGpl9/eJBcp4YX2+EzYxuEkdsI4b3rTkd1wcmENuL
IYled+5bNJ3PRUzP7xBiiHH8if/0hQEyYl/O9vhitBvVcnnJazpfJCcXiEF+
lzaW5Aoxup1zrGz+cS6xUowum+1eBI9IJk4RI+V4+oezeyOIVZz50jnOEOP9
6zDJBAST+iwxGtxN7/7vmvHEajH8FutKr7+ZSJwthmXXl32+pM8k1oixbVEu
03eYnDhXDJPwGxc/9J1M+y/GtPUj87+toPVFYjgvmqX/+C6V9l+MO8aWq9iH
dP4yMQQpXYuTUmfQ/ouxT5txY9/GNNr/6vV3mLJw3vdFtP//zb+M9l8MFKzr
lxKfSfsvwZ6pkqQbA1fT/ksgUwxsdnZyFu2/BGoX1fSHZ9YQW0qw+2Z+r8NJ
a2n/JVA2er3Sx3kL7b8Efu3/GV6fpbaX4OidgjgbwVbafwnsOnX8MiZ8O+2/
BDU/H3N9Re0roZ9vs4n5EpTOk5s6Gu2m/ZcgZ6U0XRy7l1ggQXLRJWV99xza
/+r5PYZgThcN7b8E702b371fnzpFgrs/X7Gjp1OrJPi2KvF02dQDxOkSbLzW
S/c+4yBxRrWtY50qZIdo/yV4MtZiX6uEo7T/EsR47TqVfvQY7b8EcX5O999s
O0H7L8E/c0pv5uVR50ow9NOIh/PSTtL+V6//4qZxjVedpv2XoF7+vOZ2k7W0
/xL03u092GFyHu2/BBcWHcuMW0etl+CBVds9l/5Qv6ze3mjbhfm982n/Jbjv
GdGZX1lA+y9BZvnsuBnNC2n/pRiU1bLjpgxqEymUWYqMWTvP0f5LYa5LdT0U
e572X4qWNY/Xsopo/6XYu68sfmLgBdp/KfZta/WQ/4PaXgry3PAi7b8UHxYd
tZ3/9iIb1ebYFQZSlHw0Gxx4oYTYV4rcRp148Z6XiPlS+nyYOlKK1AYjz215
dZlYIIW1aX4rfnYpsUIKY1cb4Y531Mr/5tMRp0iRMTt1wHyTK8QqKbqWHK7s
2ZM6XYoTp80bmQZRZ0gxR1fzAZs6S4poyYCHgYuvEqulmJe+LqSYuUacLUWs
/lOkkyO1pnp9b9K9+mdQ50rRd66rx7oO14m1UuzaFoAWQuoiKRYYpXYOXE6t
k8IpaPb1d2+py6QYYyaZ2PoUtV6KEUy77cP/UL+Uwjbp8+KXG28Ql0uBNk3b
Lg2+Sfyj+vjsef1s0lpqRob0E+YY1eIWsYkM7Tdv2nXLjtpCBqsX/R/FraG2
lKHFuqWjvQqpeTJcDXlqMT6pjNhGBrNRP1rfXExtL0PzgMZxX1rdJnaRYdha
dseRkdSQoaXGalFZ9zu0/zJMunU7Y4aMmi+D4XLkcpf2X4b7U/zNzYZRC2T0
/i21QoZrLWt+QEutlIF59uFBkPge7b8MTWIOZa7+Ta2S4duMfz4/a3Cf9l+G
/PRUI5sh1BkyOGbIV49Lpc6SoebbZruv1GoZXA0P5B7Q/svA69G5wPYBtUaG
3Z8GdWnW7iHtvwwb2YTQnfWptTJIImueIFIXyZDX/3HxWBm1ToaOJyeOLBBS
l1Ufz5Y1P4Wl1svgMmrOq6lN9bT/Mkh3fZ2+1Yq6XIYuI51/ZplT/5BBbnu2
y8dPdDwjx6aBva6vfU5tIkfyfpuuxj1pvYUcD3jRPe90oLaU44v/2oben2k9
T45W4yT/q6hPcxs5YkotlkR9o7m9HM9ETfY++UHtIge7k8e2P04NOYr3JDUp
iqP2laNth645lx2o+XL6+zHqSDmGGd5A6fEVyKFXnG96Zh21Qk6fD1Ar5Vi9
xLW0bDXtV4qcfh6hVsnhcXJ/vKb9f/2XG35m5VdAz48MOeKkCSEDe1NnydHN
6pmgfz1qtRyzv7R0HXyPnm/ZcphtTuv9SEetkcNebHbTZR11bvXxdOlRMnX9
XfK7e60c/ZN8R22WUBfJYbx03Id2X+4Q6+R41WTRyb3zqcvkmGa7c1DXF7eJ
9XLcaln0ttcU6pdyBGzwKfxjRV0uh+HysLyM+Iccy5Hmv8GHmlFgTKZgvMvn
W8QmChR82BEzMZ3aQoHOfWctfvPwJrGlAhLN49DRQmqeAse81zR1LL5BbKPA
WrOPvicHUtsrkJWfJrtVfb0y2EUB75nuy7oPpYYCTcMcMqfnXyP2VUDxvLhf
A0dqvgLFLkMO+mRfJY5U4OCpmh+4UQsUQECW/drMK8QKBR4b77h2oim1UoEl
g6b2DlmhI05R0M/n1CoFdia3vz59dClxugKjtrpZFU25TJyhwMeyUlGP5ZeI
sxRgO1gPrphVQqxWwNOkaDU/7yJxtgJzIyubza1HraneX98WH5jq90eDcxX0
eVIx7b8ChwdNKUh9WkT7r4DX//IWr7Sj1ilwYOzJAY7h52n/FWiQPqttiOYc
7X/18VvwvF6vT4W0/wokl0w+d1pCXa5A9p4Bre9uO0v7r8Dd/jUfMAto/0fS
7xMF7P8BIZVXjQ==
           "]]}}, {}}, {{}, {{}, {}, 
         {GrayLevel[0], PointSize[0.007333333333333334], AbsoluteThickness[
          0.8], AbsoluteDashing[{2, 2}], LineBox[CompressedData["
1:eJxd2ndYFMcbB/AFEYGInooKlngqIirCIVJEYF86SDs6SFvwGhY8CyjGsrGX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           "]]}}, {}}, {{}, {{}, {}, 
         {GrayLevel[0], PointSize[0.007333333333333334], AbsoluteThickness[
          0.8], AbsoluteDashing[{8, 2}], LineBox[CompressedData["
1:eJxd2XtYFFUfB/AjogKSrimKirneUTAXEVmu8+OOgrDActlFY9RUSrP1+qJJ
jeaFUms1L5Skq5Zilm6mb+hrNlkampf1lmham1e8tlAaeX1lz8Q++91/9vk8
Z3575js7c87MmR5jXs8e58EY69GcscbvR1vqTo4YoxOErUdW/PxbvFDq7Rfw
ksomdLj97bERa04IyyrSLwzwsgvGAa+naAf+LsyufO37QK9aYbqtT8DsxdeF
wcaU3PaeDiFo/f96H3v3ttDXfjb1ec+/hKxPx7fdOc8hqG43DFJ5NgiG9Emx
247WCZ5T3+nV1vORMObVtG5XZtQLjx4uad3Kg1HW3sPnNzXUC3/H5i5o6eFB
C45NvP38mXrh1g9XS1p4eFJIq7iUrcZ64VqrbfWeHi3J11zskRRcJ9iHz5zk
6eFFadWtYtb4OYTzS2OvNffwoWOh9/t0bXtXOGNrKTb38KWdL+xL79DjtnAo
b3WOh0cbCk4eNfGPnJvCpSPbr7FmKrr/tad9XfZ1oejuBxtZs3b0dqfSFq8k
XxUMISO7sWbP0451B7J7/3ZJ+Dmbzj9l7Wn2677N5C/tgn5679VPWQcyD0s+
tn/tReHESi/9U+ZHyTtSKjtnnxd+qrEdfcI6ktfV0oCjy84KqQ92vvuEdaIJ
bYYNXJF+WjjQ9cOUJ8yf9izs3CXT86SQEFPq+YR1psGHQwctunhUiJGS3nzM
upDjU4fl3IxDwp71/aMes650tNdbGseFA0L49881PGIBVDZ3W2mzb/YLO6/U
7XzEulHkrGXeDWH7hO399rz4iL1Af0R2rT/uu0cIHrb21kPWnUzH/9y89OZO
QR8Wd7qUqSlwV6cTM9O/FNonf7WjVFJTavj+DT0ztgsn8/osK2U96DNRn93P
skXILPHOKJV60MrRF57bsGuD8Nw7bwSXsp6kHX/uA/lahXDkwzs+pVJPSuge
PDYhfLGw+LOiG3NYL7ra70xst/cNgteRhE1zpF60smbXNxeXBwsHL+yaP4f1
JqZ8nJbArA9N3thsb4vn9Xx7qU9Tu3b+gLA3WF/63+qHVwJpiOC01Bfa+7lb
ArNAaA+kxsNkMov891h/aAezAU3+LGjd1VkSmAVBexBN6jN99Q+GLIG3B9PE
3aHtfa8buaVgqB8I9S4HnGq/qoS96G4JzAZBu8vv3fBOi2YaKpzjI9X5Dhec
Jg3tnnr/WPHWMdyShr5KOjn5r5Du3LKGpmYN7PnuoSAhJSZxYxQLoa3Gk1lt
xvfiphA6HTSu86WCfG4ppKk/p+UQeufUsP/uqRis1A+mdpfDtt/8fLxSP9h9
e2kw1RVfLtvV0Ju3y652tuzNh5EslEoXzm3wCfARnKZQ+rzyuyG+3bO4pVD3
7WUwG0LtDlx5TvPnKKV+CLUpU+Uf+/UVpX4I1LtcdaUqJ5KFkTRXTQvfixGc
pjDK6L99pW1UNrcURouzzp5/qE/ilsModtTFL2v6juNmQyn63NElbw6ZpNQP
VY7Pv/VD3fuTh1L/lY75L72ltLNwOrzl49GvpsUIU7R/bo2gcFq1/GrvFfuI
WwqnT0I19Tv6JnPL4ZS86siXe7dmcDMtOcfn53KVei0t843479oeI5V6bVP/
vF5LI+7k2WekqJT6CLr+/VeenZslCQOWDPSMoAgaW7dm//AWudxSBPWItV7+
lkRuOYJWZL7/WmfTeG4WSYtDF0bErUlX6iPpcpd1h57MilTqI6l7yOzJ64Pi
lPpI+mNLxf0VFTlKfZRyfhYJl3+bMFJLUaRjB6qXR4znlqJoqGHjCxtOjOKW
o0j+csLxca+O4WbRVBX98xLfqROU+mhlPJuk1EfT9rii2Q+nTVHqo6k+PjJ6
ft00oSJ0w85wFkO/vjBfmuM9jptiaJfJsOAoy+eWYpqOn9NyTNP5z+tj6fAn
C4eyrjqlPtZ9ewksx9KhU5UzowPaC7mLLviGM0HpP4ybBPr7/QW1Km08tyRQ
X9OtyWtvityy0PR7nyVMXtiVkbvVYCLaNXOoYFjiJzgtEt0t/KL96sth3BLR
xLPzdx60JAiLXls8uKuFaHNPv4Md56Vzy0TT5+zUji3P4bYTPe7w49z8n17j
ZnFN/TmtjmsaT5ymOFpUuX/d70cjucU4umm7MSu8Y6IwdnXlr12kOBrTwfP9
1/8Yzm2Jo8Z/LyA6h1uOo0/Pb74c0nwct93Vn9Ms3t3qeLpYFPMsolJP8dS/
ZeqQuT3zuMV4CprUskpdOF6g7w6820Vy1TttActgO5gluFudQEvv7LL8fVDN
f58SaDONn3AiKoxbTKAxGz//LT19ghBw69LQLpKr3mkLWAbbwSzR3WowgcVE
2tD3wZwV7VoJ/3RglztLifRhfY/KLt8M4LYk0oM3X907/QMtt5xI2yZ4/Rj8
Rjy3PZF89n7wbAQYxs2SKNk5vei41UmUWXuvX93uHG5Kok31M+efmpfPLSYR
pe9fED2vUOk/iaKujK9qtq5IaLzL6GxJovKs4K93dhnDLSeRpXJSQY7hZW57
EpWI7PeEd8Zzs2RKs2or/jnzKNZpdTKdOWL0SX04iLdTclN+p0WXdxRHRnWW
wBawDLaDWYq71SnKeKkRnKYUavhPu2aXvP25Rdf27y3Pv+4vgS1gGWwHs1R3
q8EEFl1u/Jf9JbAFLIPtYDbM3WowgUWw5HLKtWWCvwUsg+1gNtzdajCBRZd7
qbbf6iSBLWB5ODVMzF96uP5BrNP24WTeN+yUpfgFwWmWRntnNY6kQdzqNDpy
undJQpcwbkpT7reiuMU0GrV52arDv8RxS2k0q1XJyf3jkgQWeWR1J0saffrJ
ovVnDg3jltNo+U9vpX5bOoLbnkbh+iV/hq/XcbN0Wl4yKzJ/RTa3Op0+Or77
l3sn9dyU3pTHadHlC2NvJHSSwBawDLaD2Qh3q8EEFl3evbSlo6MEtoBlsB3M
MtytBhNYBEsur/y6V0VHSwbNqxp9eOb0S7FOyxnUYkO/cdkJXQWn7RnU9uen
EUdW9+NmmfTGxrzyfWc13OpMOvTjXY8+LYZyUyb53174bOaL4hYzlfGBhKm/
U2pHKZOGtvxYFVkbz23JpLj+xt2dypO45cym/XPa7vJuk7p3a6ZztwqsBmvA
5PLmFoMe+OjAItgElsBmsAVsdXnlRzE2HxlsA9vBDjDLcrcKrAZrXH57UPom
HwLrwCLYBJbAZrAFbHV56g/GOT4y2Aa2gx1glu1uFVgN1oDJZdHwSraPDiyC
TWAJbAZbwFaXM+7+J9BHBtvAdrADzHLcrQKrwRqXo99e+MSbwLocmp69pdey
H+/EOi3m0KxJfm2O1bUWnDblUMiosjPdR/tzSzl0xutx+jeTe3Cbc+jHPVXP
Rpa+3JYc2j1p+rHMKcHc1hzKa1u+KP0fDbecQzFrV3WvOhwqBPmvPO1ty1Ge
p4dy23Po1MUZQ6+si+B25NC89/J2fbIxmpvpKUQIHzJus8Ct0pPj78XnlufG
cav19O/6oNMaPc3fffGn0qmJ3KRXxqtkofMXGz/z1umpRYht1yBLCreop4CW
f+ZXjxzGbdJTpvOBJ41b0iv7k85t1tPnX9QUzczM4Lbo6doHft+faabjturp
vi02z/GLYllPLdsU3/D5b5bQKn6H5G3TN81nTtv19KFq2rAzM3O4HXrlflDP
zXKV+TOXW5VL0ropz0bKPG51LnmMy9nmeDGfW5NLjcs+Fr8C4d7Pcp435dK8
bk9bzGMGbt2zetUh89hbisVc+kfzxrmZ543cply63yvp5YIDhdxSbtP547QZ
bAFbXb488Xiwtwy2ge1gB5jluVsFVoM1YHL5JPvVw1sHFsEmsAQ2gy1gK1h2
WV55u8bLBraDHWCW724VWA3WuLxtwMNtXgTWgUWwCSyBzWAL2OpyxbfeC7xk
sA1sBzvArMDdKrAarHF5sd6/0IvAOrAINoElsBlsAVtdnnWjb4iXDLaB7WAH
mBncrQKrwRoD3Z0wYdG2B/WxTpOBWuxZkz53SgvBaZ2BrqY1/2jsaRW3aFCe
lztxmwz0dVFs46sFbslAcVUePvf+6sFtNijP+324LQa6PqT1zqhPArmtBgrs
b2WbfIO5ZQMlvrMqeu2qQdw2A1mnx0anmUO47QZlPSWU22FoWk/g+Y1kvvDR
9MKe4dwqI80qOT73qlcEt9qojNdR3Boj9Q2YvXjR39HcZKSbvRyL1j2NVfIb
6axf6P5f3iYlv1HZnzglv5HeerHL4Bc+jVfyG5Xn/QQlv5G6bzjR7YdjiUp+
I11ol9H6pb+SlPxG5XimKPmNlFeX/OzJLFXJb6T2o78/FTRumJLfSPsW2quW
rBmu5DfSK58//vjOiTQlfyEtanz9MiVDyV+oHM9MJX8h/fuejOcvpBPRjS9m
FFMh9Xx8f4a9IkvJX0jTvnltU3x0tpK/UJk/FZsKaeHB9nEVi3KU/IV07Hfj
ndGD9IJz3jcXkt/j9R/2O6vYUkj6abu/0y3K5bYW0vIbjQtgedxyIaUvtR0/
fUuxrVCZf/O57YVN5y+/rwCzke5WgdVgDZjAOrAINoElsBlsAVvBMtgGtoMd
YDYK8oPVYA2YwDqwCDaBJbAZbAFbwTLYBraDHWD2EuQHq8EaMIF1YBFsAktg
M9gCtoJlsA1sBzteUsbfO7E8fxFNnetXd70P49eLqoj0V1RTpg3w5lYX0XC7
emL+4HbcmiLq0lqvGnHTj5uKlPXPLty6Iup+72xQcFV3brGITj48eHatoSe3
qajpfRbPX9S0HsDzF9HAhMaV1gHK9V+kjLfByvVfRA/Ezl33nBukXP9FdD17
ZO79USHK9V9EWfeCPm57fLBy/RfRlhEVF/7QDeF2FFGzTb4BtpNhwsujLiQ3
ZyIVPJlTaNWHc3uJtNa3caVPy60SyWYTvjvwbiS3v0gdf9M1TOoWza0Wm46v
04FgDVjrcuvkPjM8CJwK1oELwCK4GGwCl4AlcBnYDC4HW8CVYCu4CiyDq8E2
cA3YDq4FO8ANYDba3V5gFdgfrAYHgjVgLZjAqWAduAAsgovBJnAJWAKXgc3g
crAFXAm2gqvAMrgabAPXgO3gWrAD3ABmY9ztBVaB/cFqcCBYA9aCCZwK1oEL
wCK4GGwCl4AlcBnYDC4HW8CVYCu4yuUdL07e2EwGV4Nt4BqwHVwLdoAbwGys
u73AKrA/WA0OBGvAWjCBU8E6cAFYBBeDTeASsAQuA5vB5WALuBJsBVeBZXA1
2AauAdvBtWAHuAHMXna3F1gF9gerwYFgDVgLJnAqWAcuAIvgYrAJXAKWwGVg
M7gcbAFXgq3gKrAMrgbbwDVgO7gW7AA3gNk4d3uBVWB/sBocCNaAtS4bOn19
ghE4FawDF4BFcDHYBC4BS+AysBlcDraAK8FWcBVYBleDbeAasB1cC3aAG8Bs
vLu9wCqwP1gNDgRrwFowgVPBOnABWAQXg03gErAELgObweVgC7gSbAVXgWVw
NdgGrgHbwbVgB7gBzCa42wusAvuD1eBAsAasBRM4FawDF4BFcDHYBC4BS+Ay
sBlcDraAK8FWcJXLzo8MrgbbwDVgO7gW7AA3gFmxu73AKrA/WA0OBGvAWjCB
U8E6cAFYBBeDTeASsAQuA5vB5WALuBJsBVeBZXA12AauAdvBtWAHuAHMXqHE
zdcvFui0wv8BUCC2og==
           "]]}}, {}}, {{}, {{}, {}, 
         {GrayLevel[0], PointSize[0.007333333333333334], AbsoluteThickness[
          0.8], AbsoluteDashing[{8, 0}], LineBox[CompressedData["
1:eJxdz3uMFtUdxvEfLyu8u2g7FYWXi3UoF1dAGLDIy/0oCq+KOOXmgihT0Lq2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           "]]}}, {}}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0., 0.},
      AxesStyle->{{
         AbsoluteThickness[0.8]}, {
         AbsoluteThickness[0.8]}},
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      LabelStyle->{FontFamily -> "Cmr10", FontSize -> 12},
      Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
             Part[#, 1]], 
            (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
             Part[#, 1]], 
            (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{{0, 50}, {-0.1, 5}},
      PlotRangeClipping->True,
      PlotRangePadding->{{0, 0}, {0, 0}},
      Ticks->{Automatic, Automatic}], {558., -114.02727092435559}, 
     ImageScaled[{0.5, 0.5}], {360., 222.49223594996212}]}, {}},
  ContentSelectable->True,
  ImageSize->500,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{
  3.583155623610944*^9, 3.5834866647565184`*^9, {3.653934197848872*^9, 
   3.6539342272468724`*^9}, {3.6539342573238726`*^9, 
   3.6539342748218727`*^9}, {3.6539343175168724`*^9, 
   3.6539343430838723`*^9}, {3.6539344779898725`*^9, 
   3.6539345152608724`*^9}, {3.6539859584100246`*^9, 3.6539859746306467`*^9}, 
   3.6539860267638597`*^9, 3.6539861658257647`*^9, 3.6539861972809095`*^9, 
   3.6539902799431353`*^9, 3.6539903327334137`*^9, 3.653990623244462*^9, 
   3.672150375449976*^9, 3.6724081402634478`*^9, 3.6725032900841956`*^9, 
   3.672570259492796*^9, 
   3.672573919211731*^9},ExpressionUUID->"814e8375-9a96-4723-b0ae-\
166de78460e7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{
  "\"\<c:/dropbox/mystuff/cred/ECMAScndRev/LTUdest.pdf\>\"", ",", "pEW", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "500"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.672503312069394*^9, 3.672503316324819*^9}, {
  3.672570278170663*^9, 
  3.672570278330679*^9}},ExpressionUUID->"4ac42794-2f84-434b-b8b0-\
ab905f5b3fd8"],

Cell[BoxData["\<\"c:/dropbox/mystuff/cred/ECMAScndRev/LTUdest.pdf\"\>"], \
"Output",
 CellChangeTimes->{3.672503318660053*^9, 
  3.6725702821400604`*^9},ExpressionUUID->"19f9968e-c0e3-41ed-9b56-\
6fa39558a0bf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"pprob", "=."}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"pprob", "[", "j", "]"}], "=", 
      RowBox[{"{", "}"}]}], ";"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "1", ",", "3"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"alist", "=", 
  RowBox[{"{", 
   RowBox[{".05", ",", ".06", ",", ".1", ",", ".5"}], 
   "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"AppendTo", "[", 
       RowBox[{
        RowBox[{"pprob", "[", "j", "]"}], ",", 
        RowBox[{"ListPlot", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           RowBox[{"{", 
            RowBox[{"grid", ",", 
             RowBox[{"Map", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"Max", "[", 
                 RowBox[{"#", ",", "0"}], "]"}], "&"}], ",", 
               RowBox[{
                RowBox[{"d", "[", "j", "]"}], "[", 
                RowBox[{"[", 
                 RowBox[{"6", "+", "i"}], "]"}], "]"}]}], "]"}]}], "}"}], 
           "]"}], ",", 
          RowBox[{"Joined", "\[Rule]", "True"}], ",", 
          RowBox[{"PlotStyle", "\[Rule]", 
           RowBox[{"style", "[", 
            RowBox[{"[", 
             RowBox[{"i", "+", "1"}], "]"}], "]"}]}], ",", 
          RowBox[{"LabelStyle", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"FontFamily", "\[Rule]", "\"\<Cmr10\>\""}], ",", 
             RowBox[{"FontSize", "\[Rule]", "12"}]}], "}"}]}], ",", 
          RowBox[{"AxesStyle", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"AbsoluteThickness", "[", ".8", "]"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"AbsoluteThickness", "[", ".8", "]"}], "}"}]}], "}"}]}],
           ",", 
          RowBox[{"AxesOrigin", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}]}], ",", 
          RowBox[{"PlotRange", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "50"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "0.1"}], ",", "50"}], "}"}]}], "}"}]}]}], "]"}]}],
        "]"}], ";"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "1", ",", "2"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"pcrp", "=."}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"pcrp", "[", "j", "]"}], "=", 
      RowBox[{"{", "}"}]}], ";"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "1", ",", "3"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dx", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"d", "[", "1", "]"}], ",", 
      RowBox[{"d", "[", "2", "]"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"i", "\[Equal]", "2"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"dx", "[", 
           RowBox[{"[", "j", "]"}], "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"10", "+", "i"}], "]"}], "]"}], "=", 
         RowBox[{"Pick", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"dx", "[", 
             RowBox[{"[", "j", "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"10", "+", "i"}], "]"}], "]"}], ",", 
           RowBox[{"Map", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"#", "<", "20"}], "&"}], ",", "grid"}], "]"}]}], 
          "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"AppendTo", "[", 
       RowBox[{
        RowBox[{"pcrp", "[", "j", "]"}], ",", 
        RowBox[{"ListPlot", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Take", "[", 
              RowBox[{"grid", ",", 
               RowBox[{"Length", "[", 
                RowBox[{
                 RowBox[{"dx", "[", 
                  RowBox[{"[", "j", "]"}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"10", "+", "i"}], "]"}], "]"}], "]"}]}], "]"}], ",", 
             RowBox[{
              RowBox[{"dx", "[", 
               RowBox[{"[", "j", "]"}], "]"}], "[", 
              RowBox[{"[", 
               RowBox[{"10", "+", "i"}], "]"}], "]"}]}], "}"}], "]"}], ",", 
          RowBox[{"Joined", "\[Rule]", "True"}], ",", 
          RowBox[{"PlotStyle", "\[Rule]", 
           RowBox[{"style", "[", 
            RowBox[{"[", 
             RowBox[{"i", "+", "1"}], "]"}], "]"}]}], ",", 
          RowBox[{"LabelStyle", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"FontFamily", "\[Rule]", "\"\<Cmr10\>\""}], ",", 
             RowBox[{"FontSize", "\[Rule]", "12"}]}], "}"}]}], ",", 
          RowBox[{"AxesStyle", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"AbsoluteThickness", "[", ".8", "]"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"AbsoluteThickness", "[", ".8", "]"}], "}"}]}], "}"}]}],
           ",", 
          RowBox[{"AxesOrigin", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}]}], ",", 
          RowBox[{"PlotRange", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "50"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "0.1"}], ",", "60"}], "}"}]}], "}"}]}]}], "]"}]}],
        "]"}], ";"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "1", ",", "2"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"pfin", "=", 
  RowBox[{"GraphicsGrid", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Show", "[", 
         RowBox[{"pprob", "[", "1", "]"}], "]"}], ",", 
        RowBox[{"Show", "[", 
         RowBox[{"pprob", "[", "2", "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Show", "[", 
         RowBox[{"pcrp", "[", "1", "]"}], "]"}], ",", 
        RowBox[{"Show", "[", 
         RowBox[{"pcrp", "[", "2", "]"}], "]"}]}], "}"}]}], "}"}], ",", 
    RowBox[{"Spacings", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Scaled", "[", "0.05", "]"}], ",", 
       RowBox[{"Scaled", "[", "0.2", "]"}]}], "}"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.672150487192149*^9, 3.6721505107295027`*^9}, {
   3.6721505765390825`*^9, 3.6721505893733664`*^9}, {3.672150687855213*^9, 
   3.6721507808025074`*^9}, {3.672150812659693*^9, 3.6721508234937763`*^9}, {
   3.672150859687395*^9, 3.6721508702944555`*^9}, {3.672151022893714*^9, 
   3.672151070477472*^9}, {3.672151130257449*^9, 3.6721512886772895`*^9}, {
   3.672151498990319*^9, 3.6721515462220416`*^9}, {3.6721516004164605`*^9, 
   3.672151694644882*^9}, 3.6724082196493855`*^9, {3.672408733395755*^9, 
   3.672408823445759*^9}, {3.672503343414528*^9, 3.672503462394425*^9}, {
   3.672573936670477*^9, 
   3.6725739845772667`*^9}},ExpressionUUID->"1d5f9a63-cda3-4260-87e8-\
a2cb3b9262d0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.05`", ",", "0.06`", ",", "0.1`", ",", "0.5`"}], "}"}]], "Output",
 CellChangeTimes->{{3.672150498385268*^9, 3.672150511561586*^9}, 
   3.672150590200449*^9, 3.672150824917918*^9, {3.6721508611395397`*^9, 
   3.6721508707064967`*^9}, 3.6721511489433174`*^9, 3.6721512896393857`*^9, 
   3.6721514927666965`*^9, 3.67215154740516*^9, {3.672151632575676*^9, 
   3.6721516951519327`*^9}, 3.6724082005614767`*^9, 3.6724082458920093`*^9, 
   3.672408497932211*^9, 3.6724087776541805`*^9, 3.6724088252769423`*^9, 
   3.672503465516737*^9, 3.6725703329601417`*^9, {3.6725739378745975`*^9, 
   3.6725739849113007`*^9}},ExpressionUUID->"58068490-777f-4289-8f07-\
895c02740187"],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      GraphicsBox[{{{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.007333333333333334], AbsoluteThickness[
           1.4], LineBox[CompressedData["
1:eJw92nlcTN//B/ArSVKMPcXHUNqUplSSllfaSU37XrPVjC3xsWSJsW9Jliwf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            "]]}}, {}}, {{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.007333333333333334], AbsoluteThickness[
           0.8], AbsoluteDashing[{2, 2}], LineBox[CompressedData["
1:eJw123lcTN8bB/BbosVW2bLERKmIoj0yn5QWbdM+7bM3WbMnYihrRfHzLftY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            "]]}}, {}}, {{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.007333333333333334], AbsoluteThickness[
           0.8], AbsoluteDashing[{8, 2}], LineBox[CompressedData["
1:eJw12XlYTG8fx/FTQmWLpIUYSlEkS2Sp+WhPi2nfm6lpFiHZQxjZ9yyJbCMk
hCT7NnZZxx7CqKTkR0i2ylPu7+Mf1+s63eec+7xnzpylZ/ykQIk2x3E9W3Bc
8//1+7889IsX8Is27BlvddEKc/WMusUaqPkG4cMLb0qtsG6bb4mNroZ/fNjP
ywkvemN27sQrfXQr+TlP0k/d6NUbgyI9Qwx1avgKr4tzzb0sYaV55tVJp5bv
u0ryu3egBQw+/hxgoPOT33mzf/VQr17QmbLcooNOPV8Y3+/RgIE9Uf9nVZvW
2hy6HfvoLTLk4YdzyOJW2to4P2wJp6k0R/XVdykttXWQ192+w5aCrqhoffir
jnYr3Dx2+6TzKlNoxsyYoKOti7ZRxzIyU43xYrVzRQttfaydcDjr/TIjPFG3
ErXQbgtFrV9Wq+OGKArNDNLWbo/a1ybaihadUHrnSAWnZYC6NjOunJhuAOGn
Dbs5rY6IfZEcbmbSHhEDo805rU4I+DnBvNuqNngaiBd/OUNozt7tau2uh+Bp
lpl/uc7YeMFgymt+azzI0A3+yxnB/muBVZeUlrhdrL7byHVB3rqYcaZVLeD1
u3BFI2eMCJVO0qvV2rjWdYtnI2cCK/N3oqFxWnB1mqvTyJli2H55XkMMByeF
+7wGzgyHO/VrL2ts5J/Z1XdkA9cVD1e+aLBRNPCHXWn3s57rhoKtpg1yx3p+
YfmXwnrOHBrD6uBf3f/wj1ifsavnukP2ODUjtd9vfj/vHdV/uB6ovNj6SEzk
L36ww+jHczkelo8WvVNn/+QbehwrmKvgQfXh5rp73E/+w9De6+ZyPbHwdVdX
LvkHf2yKnv9cRU90nLR9/tmPdfx2y+f0m8v1wi+l7NiHqXX8O1v+05+r6IWs
jzv3abWo4688IKxK5Szw788zv/N177jmpCos2Dztv/OvlxxflMpZ4uEV9Yfy
O7XMCkv8WtrfKSuRzPWGYJLH3TC9/y/vjV1nLe+tyP3Gd1xk4zCHs0Jhr8Ts
+55khRWO9HS0K6v4SsutUdN5yt4di8kKa5QWJUlrLf6/vA8Ww25y+aUvtLwP
UnoXTZ0rJHN9USzutfd5fQ0t74tnL/4EG2WRORt0KNR2DR1Wwz9gu/PdLIUN
zJ2r3NL2f2bmbNFDlpXfUP6JltsiYuhUr8SeZK4fDL/l7TES/kfL+yGzXBHj
t+MjLe+P86vvrgl+U03L+2OqRDAxuVc1v9sjw00pnB38OvnceiX7wKyww9HA
0e5PjlTR8gF4Wv/TZ+XvSlo+AMf0t2rZeVXy11Tp+Yzi7GGRNjm5avN7Ztjj
4OYx/LcfK5gV9ti+dWjZEDeyyh4jy6WntHa+43s6ue0eyQ3EhjL/KlFDOTMG
InpExSixkKwYCPHcFhu6XitjVg2E6WQt+UY7MjcIL95F9Xi6tZTGD4KxcqJD
dVuyYhBOHwxb92DBWxo/CP/VPEtY/VvD59bN+zOCG4ylS+3nmc0kYzAWWy3v
/e7TG2bFYBgg0dD6x2tm1WBM1n407lUrMjcEvOPLN/wxf0Xjh6DtezOpfFQJ
jR/CzhvxL2n8EJgevPv34JoX/FPlp4JGcA5Iz75X4nr5OTMcsNHwP5s99cXM
CgdU7vmx+ogTWeWAcdNaHx28+BmNH4q54ZMe6z96SuOHQsS/2qqNNVkxFF7G
W0P1Fzyh8UNh1Nh20lPNYxo/DFzp4Vh3j8f8yY7fDg7HMLgcNRrS/+gjZsUw
nF4emRXVk6wahsmTg5OyNz1k5hwxI+nFqkcGZDji0ZIrD1VrH9B4R3xOj1e4
GZJVjph9uVOHPlvVNH44Sr5YXXS3VvNtVvXXGY7hGD3m44vXSfeZFcPxd6NN
QN2me8yq4ZAqBzXOvX6XmRuBnVW9rw9quEPjR+BiakH8qRFkxQh8efrr5O15
t2n8COQ87l1mUnSLxo/EuQ1j1040vcUveyOLdsRI5NQon0+fVMSsGIn3jif1
fty6yawaiX1Vx1octiVzo3CNlz9Fvu4GjR+FK7bNJ8rrNH4Ueod3u1efSFY1
+d8J/xp/2+DswmGcE5QNXh1NQ8lwgmlpuPHJB1eZFU5YoJ79c1AAWeWEwoob
wsjHV2i8Mz52ehLVIooMZ5iW213u/O4yjXfGPZMKnYlTyCpnfLhneP+59mV+
yNKStsM4PjoOHXU+cNMlZvAxd1Ttq0P9yAo+Uka7Jb64pmJW8ZHZwunxiTgV
/4Br0pKuHNCrtCJ4EEfmAZ2Kty2UuVxkBpAi4t66Lr/ALAIunOP+VD4+z6wA
ruqfTLXsfZ6/dOLKQV2VQDe9IcWPZ51jVjWtz1jhUfXwLLMGuHv03MHu9mRu
NPyeV7Wevu4MM280rH1N7t6qO82M0dg7TjCkg4gsavLYg5Ud7p7iizNzX5sp
RiM5ZqDFOSeycjR0N5SWGRacZFaNhnf74iflfcma0XC43/GX3d4TzJwLDnzL
/XnRgsxzQXS3jK25e48zwwX9ZJ9XnbAhi1xg/PjknaqCQj4uXVthpnBBYc+/
d3jOZKULfI7cvT7mzjFmlQtepVqckcWQNS7wyjUNdP9SwMy5wuXhvpDapWSe
K2JPvx4a1JMMVwzqdl+G80eZRa6YtjX5yJ2oo/xu1aVDzRSuOPH90fyn9fnM
Sle4rdDq5Kckq1whazpb9/Aga1zx6MLpi7NLjjBzbrA9P7Sr7UAyzw3Pxs8W
CFYcZoYbGj1zXPe9P8QscsMQg9vS9t6H+L86c2WmCjdUtCz23Hc4j1npBnXC
31HtTMgqN3zpN9oDiw8ya9wwJna7GHUHmDl3bB7iUZ2bSOa54+ggs1/nSvcz
wx1BG33KjGPJIndUZRUNe1mSS9t3x7Yrx19cic3lP3E2X2uqdMf49gZ3HpTt
Y1a5o3p41dyy8WSNO/J1AuOf1eUwcx44nTRm1qFFZJ4HtjX/3BmR4YEw9oFg
FnlAsaNV2/XOe/kF8hEjTRUeOHC2oE2rZ3uYlR54coy38cdkssoDWksFe6Ud
yJqm9RWILQyO7GbmPOEy03ubUQCZ54nqQIvawd+zmeGJC0s0p1ZtJYs84f9g
XXSjazZ/zfqw9yYKT9h/8QyQfdrFrPSE2vqrZVUWWeWJ0K9Hz8KbrPGE3foZ
u9f+UjJzXpi/KE61/iCZ5wUL3wC71UIyvPDEMsXVzIgs8sLzXuOG/d68k594
btoGE4UXrLoLhr7TJyu9sGbk3oXf5+9gVnmhusFjZNLP7cwaL6wWNl9hkTlv
+DbV9f66jZnnjbGtPIsOTiXDG5k3W8pqfmxlFjX9/b7pXR/PIyu84dF7unaW
7la+Z8U6vonSG4cu9ub+bsxiVnkj4pfE3sOSrPFG1p2UqKrjW5i5MZg8PHZB
pTeZNwbHL9eeX6LZzIwxWPMu5rtiFlk0Bg27tlg/67yZ3xSx2lgxBlo/9wUv
L8hkVo7B1vfLUjMDyaoxMBs/XzandhOzZgwGLPPyO7uZzPlA+1zLTp35ZJ4P
1rc6eXzx+wxm+EDT9LNjsJ4s8kHnGON5yc5khQ/sKt4vyfm4kc+NuJNprPRB
yyV5Sd+3kVU+uHJ6ianZWLLGB2sbM8c/0CZzvjCJ3L5t16kNzDxf5F9/Pk0n
mQxfhLr51f7qQxb5oizk6dBrZev5JeIqV2OFL+ambOJZKMlKX1jlrT5qGEtW
+aKk5mzVJnOyxhfZHj2L8l6vY+b8MP3Q+bEhu8g8P8zPLojzk5DhB1VzThuy
yA8dzixynfQlnX96dauaLgo/bCyJM9xymqz0g2B1ZlKnhWSVH1zu9A556UfW
+GH8lrY3vpmSOX+8L3shGHhvLTPPHwlH/WzMxpPhjx0ZhaVd9ckif3hsutP0
C7aGtu+PvEPFwhlj1/AzTlps66L0x7y3GZb3v69mVvlDaLUi/cx2ssYfjQum
vLzgSebGQu93G6f42lXMvLGwWFjivjmbjLHwMS//Lgoki8Zi4L03i1x0VvGn
vIVXF8VYPMm4/3XUqZXMyrFYmlTX+tZEsmosPMODr1ZZkjVjcS08R9jr9Qr+
6WSeZRtOgF0JUxJlm8kGAoxaOij4WjCZJ0D5mb7vjnci2wvw8VfWu4IHy5kh
gPYY19Uu65fz97Uc8FtfIIDVwV4lCcFkkQDh5sMfmpqQkwV0/l7GrBDgucXj
tvuzyekCPDtvtFwvkaxs2r58TV79IHK+AErTq61n1C/lZ2Q5qfVVAiS+tNdP
u0FWC7Ah1zg1awNZI0DXBSkxF0XkGgEChZtmJNqRuQA0P57IbVjCbBAAJ+8z
0q93ybwApHt73Lu8g2wfANcQ3707k5fwFw7wzdFHAEIm3Kle5koWBODamuu7
5hmTRQF4d2Lu2t/Vi5mTA/DvPl1FVgSg1Fzj3SaTnB6ASfFe/lZJZGUA6nPy
m+7oyPkBqKxbf11uvpg/5Wpkqr4qAIMDP+/fVreIWR2AuYd8VqvvkzUBsO7c
S2NwgFwTgAfNl6OLyFwgnn/0+r5dSDYIxLqE0M/JI8m8QHj9++KR7QMhFDb/
Qi1kRiBmlE45p/1gIV8UMS5QXxCI6uRpGZ8Ok0WBiPs7vekOg5wciKerZ3pe
TyQrAnHA+tvaC97k9EDMv5RUfKIPWRkI7bh94Q665PxADG213WBEZRrf/9PM
PvqqQIw7uP6m802yOhDbBMsUrrlkTdP6/oxIvreMXBOIjnkHMt+MI3NB2B1t
drFmDNkgCA7tVlRo9SPzgjDjygn3Le3I9kE4Oatsj/3nBfxRC5c06iEIuQ53
R/o/IAuC8KG6+QtCFgXh5b6ygS0yyMlBmDNuBbdvJlkRhAm9p2VejSCnB9H9
J1kZhLzcS0Pa9iDnB8EvUd4iX4usCsJ/th0eBpUr+LYmGY/11EFw+jaleO4N
siYIrwpN9/U8QK4JQv/U5k8ImQvGXSfL1M+TyAbBMG+5LM00iMwLxr+P91Cy
fTDdb5ERDOMTUtsBv+bzTQ/tPqAnCMZJNzvHhRfJomCEPvru9mwxOTkYdXHn
A2x9yYpgZNQsip3fiZweDIf5vuMfFc9jVgbjcbvOKdY7yfnBmLrt5aI5ErIq
GIa2u9fdt53Hb+1SoNBTB6PgdOIOi69zmTXBCPQadHDmKXJNMN1PkrkQpEsu
Xe3hTjYIgX3tsgdT25B5IbifJnh940Eqs30IJnU0qe66OZX//akqVA8hOLJR
skwcQxaEYKxF/6ZTNVkUgk9Ha3e1+TCHOTkEa3DusDCfrAjBqhcNNqqZ5PQQ
2I67NqyzM1kZgts/VrnJdcj5IUhcEhxw7tZsftn4+/30VCH499h2HVkdAt0j
MS+Sw8maEOxz6v3+andyTQj2PpOKe1fMYuZC4S61S56VRzYIhSuX/PH5VDIv
FKOzjjZdeZLtQ4Eh38qztMkIhfO9IXF/ilL4D7nX2nqCUGydWuMrX08WhWJL
u0FFNyPIyaGoK/iv0KEXWRGKoPD9yuwPM5nTQ9FB782froVkZSgmNj/OTSXn
h6KvUO2i7UFWhaK8Q6sdczrM5KsyPhbrqkPx9/ZxudaLGcyaUJxNrb4yeze5
JhRPHbeu4ZLIXBgE3LWb64eTDcJQdOOTdu+WZF4YXNeaOJ1UT2e2D8P50OYr
9un8wzZ/DusiDBl9K3iVcrIgDEn1y28tcSCLwrD3RfMJgJwchpJT1+pL1NOY
FWGYmh2zeONOcnoY9FZ9b+ebRFaGYef01ZtaOJHzw7AxceeaG22n8bdd1Fus
qwpDZaJtXearqczqMIwafzJGfpisCUP6eNdrjvPJNWF0v0HmwhG8pqi00YJs
EA7JXu++lXVTmHnhmHmuaNKDIrJ9ODw+OGU82jGFvzLYJEoX4TjZ1tGnaApZ
EI4lI/KSb3uSReEonJrV8oU5OTkcpXnLsiq/TWZWhGPSl5odLW6T08NR7xCx
u3s2WRmOysUjjT1mk/PDMfht5u9ZQZP5s6qsBuqqwul5B1kdjpuZgktvW5I1
4VDr7Vpo9zaZuSYcs5NnPk06S+YikFZ6Y/PZTWSDCFQJ19/qPJXMi0DAq+j6
iWPJ9hEwlu7a/qgfGREY9Vt42L0NWRCBFq28d4Y+mMQsikAb9zM7g9LJyRHo
tMhWKRhLVkTA7Mo2pV97cnoE3phoK8T3k5iVEdiTJBPOSifnR8D6pco8N4is
isABT7OSp13I6gh8uCWb1b1kIs0/Arb+x7tId5FrIjDhgXbhISmZi0TieDf7
9nZkg0hYdZu9cumPCTT/SFieONu68gLZPhIa6Zf4uGVkRCLSruv2b0FkQST+
ne57kEWR8Duf1HTGHE/zj8SNRZt9DpwgKyLRGH8iIWQROT0S/15LBJKVkZjY
4+umgz3I+ZHY09AhP/S/RJp/JLZ87Zlrdp6sjsSa94OVr1eRNZH4dzkdTa6J
xNBKn0nz7chcFGxfxchcG8fR/KPwulLszFOTeVFIrx1n1LCLbB9F50cyotj7
I3eyIAr7my8/jcmiKJiOmCFYXi2n+UfhjnuqtfQ8WRGFUfIZr6LWyfk3zpxa
3So9Cp+nphY6isnKKPy7XB1Gzo+C+lTzhTdZFYW0qzN+cK9kzOoofKtIPlSX
T9ZEQaw3XvxxEbkmCo9tJaal4WQuGkuGja+5YEM2iMaPCElOYaOUmRcNWaow
+sBDsn00zJZJBi/dQ0Y0/r3nSSELouF0QqKKGEMWRaPm0vjMod3IydEQlUv8
+tVImBXRMKwZb6l3mZwejet/Jv95t4GsjMas1ikPL0vI+dGwNZy3f+cwsioa
r7svUqTqkdXRaH7NgecJNP+m+fXYNtb8ILkmGsNts61+p5K5GNjxCrtf8CUb
xMDC6HqXtG5kXgxM9Ivbe3wU0/xj0O5vVSv9c2TEQLv2T+PdlWRBDH5Utvux
Loosalr/DVsDp77k5Kb1n3PS1foVT/OPQVRWVM+86+T0GKxPmTUibCNZGUPv
H8j5MdByOD7h0ACyKgaOho8WhzfE0fxj6HxK1sSg6pTZ84xN5JoY8DIdvyKB
zMUiK7b5hSzZIBadrVZJJX9ENP9Y+OgcmG9QRLaPxbXbj05nbyQjFs4bGr4N
EZEFsTgVad00ZbIoFpVdznRa8EFI84/Fy73tlu5dQFbE4t/lgwk5PRaXrxRO
+nQkluYfi+G9eVZvXcj5sej/7wclhuYfC57rjfY2k8nqWGzeM+haNx2yJhYr
By8ZPnprNM0/Fi0yvnwebEfmhKizcE8IvxZF8xciaXG+mU84mSdEfGedtZM+
R9L8hXgxfZJ7fBoZQtzVaX7CQhYIodrQxe5gfgTNXwjH7wvKt7uSk4WwXfQk
/PKLcJq/ED0M+96tmExOF6JTduroNnpkpRAtB6qPD1CG0fyF+HXRwiZ4GFkl
xEf/mTtS7oXS/IWIanNMfW8cWSOEf1Yr928cuUZI1y8h/ISYEo8WnAj57zKq
Jw4m64rQI/uB+dV7wcwGIqyObScwSySbiFBv5p2W3JLME6H57cTPPUHMfUQI
uZS7xx9kexH4B+9sfPomkNlRhL7/LvgD+W2aH9xBBMP5nadXdCd7idAgd5Qk
XQhgFojwPjA6pC6GHC6i+x+ySISCBdOOjtsrYJaLYLJFIbTwJieL8Ftk2vXM
87HMKSKc+6D1Lb0vWSHCvGnNv5j+zMua9rfxYbZzkR9zughay87ONjIlbxbh
Ssc9gR/lvsxKEebURedYXfJhzhVhyEujpk2S80UoM9tZ1DhrDPMpEbb+DTMf
/tCbWSWCD//tx6eDyDeb9nde85NNL2a1CPsvfFvZqdaTuViEsRF+zwxjyBoR
vn/L6WV03YO5smn9TVe3XQaQa0T4955a6c78U4Qns4Lr33Qkc3GYMmneFbeF
bsy6cWgvyV2xv9aV2SAO2cez705OIpvE0f23CzMvjs5P5D5xiNm3btOtl6OZ
7eOoH9mxaXuNVp17aUD94/BN57L/0USyVxz14lP/ODRdfKUXf3Km/nH4aG/V
cL4zWRSHT07RU0r6OlH/OLzmBr+5NHYU9Y/DvSt6vvumj6T+cfQ8fQT1j6Me
w6l/HGal3F/wTpecHofQLx4V6/iO1D8OPXlCl5ZLh1H/ODRufppz9PxQ6h9H
9w/k/Dik5e0LFcY4UP84+L28WPBwzxDqH4eWqpRW7RoGU/+m/dszMNIzhKyO
w4zlHw4tODSI+sehm6Xbr7QuZE0cnug2+J5PGkj94yCP+LF2caU99W/qWSt4
uSSA/DMO48xD/AymD6D+8Ui/4P1IKbej/vE4KXSOGBjdn/rH0/HsR/3j0TLb
WhLoakv94+l+04b6x0P/3wOCvtQ/Hm2Liq4eSutD/ePR4enf4Xcyral/PDqW
ORz5kGdF/ePxKeqQYWZZb+ofjzuPm19AkMPjsd9vW8lngSX1j8eS64ajty21
oP7xSOCv3Ot1oRf1j6fjRU6Jp+PVk/rHY/V/x5U/rvOofzw8HibVDuxBTo+n
z1936h+PicMuDfPbaU7945FRfPz8q/XdqP//j09X6h+P/q7/3pxR/3gElxtM
nmpjyi+wS9qtpYrHviF5305bmjDfjEdA2cZJE/oZM6ubtr9ubnX3IV2Yi+PR
uOOYyMnbiFkTj35R6Q87SjozV8ajYPoZp8A1hsw18XBML89df7IT8894GOlF
t+N/6sjMifFtwaPJ1ZZkXTH6RGy+32KcAbOBGB0vtg7eI+vAbCKGjU0/7UP6
7Zl5Ymz9tn1/z7NtmfuIkdA1Zoz2rDbM9mIs2jWu3N9Nn9lRjL3WM+Zt7aDH
DDGmJZq3UX1vzewlhtuhq5nlL1sxC8S4nNfK+G1JS+ZwMUbneW169UqHWSSG
6uAKoxevWzDLxfgkky09/FubOVlM/ckpYmQ7JyVc4WsxK8SYf/LdzUkzOOZl
YpwWnYl0jPzr/M/pYlh2cOsyrrSBebMYa87ffbAlsZ5ZKca+Pl/nZ7f7w5wr
RrLgKG/h7V/M+WI4piRfEi//yXxKDC3lgHg3zx/MqqbjPdqy8vGIOuabYih7
z5uz2vA7s1qMG9enaHVvXctcLMZ2S+3ZS4y+MWuajl/auq+fLL4yV4oxRsMb
HzboC3ONGOrfY55mRtUw/xQjz+ZDWr7eZ2Yugb7v/zHrJqBn+5ud48urmQ0S
sPJcgHr9hA/MJgn0+a1i5iWgW1t1x+DK98x9EvBu8NqCITkVzPYJOBzlH2SU
8I7ZMQHed0Rj+rmUMyMBNiHlupxtGbNXAjLbjwn161vKLEiAdbC89a9+b5nD
m/bPOb/sIjTMogRcUjxsv/TCa2Z5Ajrdy8y72vUVc3ICDgy+1/HiwpfMKQm4
V1TRcrDWC2ZFAualv13G21jMvCwB0yf5Pbo18Bn1T4BTZttpBz8/of4J8H02
qsTr1GPqn4BdA1632b3yEfVPQNqpuFszpj2k/gnYHxEqaC1/QP0T0MXw3PZg
qZr6J6DH79a1Q2vvUf8E7GycNdJ54F3q///9v039E+CyRWfm6eoi6p8A6QDz
8f3H3aT+TeuvM/5kVn+d+icg8L/avwv2XKP+CehqVKiMj79K/SUoHzV1tCvv
CvWX4Nq1ur9d9C5Tfwly/Gdf+PBFRf0lsDJQGSdrLlJ/CbiFKwv0X52n/hK0
PfVm2coB56i/BMb/DRa2TTtD/SWw6LXMYfXjU84RxicfcJDA85Syr1bgSWYv
Ccb7nzaffv84s0CCfe6bBpTMLGQOl6B++zDhUJ9jzCIJAuqK16R3L2CW/39/
85mTJZh1+fNfwwtHmFMkCHI4m3X4zCFmhQQvv4f67X1+kHmZBAY6V4x/mh1g
Tpeg63DjTykTc5k3S/D47MiSkNIcZqUEYonXU5F8L3OuBEO8B5ba6+5hzpeg
JEj7t93pbOZTElzffMTi68JdzCoJlui4R5QJlcw3JRhut9ihZdYOZrUEhrsE
6p2btjEXS7A17mPapuNZzBoJ1JPC/arqNjNXNm1vT55Foncmc40EG60fdPS8
kMH8s+n4P3jVJtBtIzMnhejmGfPTH9cz60oxtWL+SP+cdcwGUkTb9pd0nJzO
bCKl/VvDzJPS/q1i7iPFJ8Nu40dsWMFsL6Xey5gdpQi3r/37xmgp9ZdixCr7
0jWzFlN/KYocnEq2/F1I/aVo2d/sE5ebRv2lcLH88VcmWED9pbAdt6evbVcF
9ZfCJnp3TsntudRfioJu/IhHH+ZQfyku9Lf2VT+cRf2lcEg4PTTn50zqL4V3
bKfJJz1nUP+m9Z/xD5IenEb9pTgjjvKbPHAq9ZfCZJLPZ9M7k6m/FIMDjSbz
05Kp//+PVxL1l2KpbIPXYukE6i/FxpQ5I9P8E6m/FE5+NvPOCOXUX4q0dzsN
7LKk1F+KnHHahqLSBOovhcd2kycr48TUX4pr57q2nvEpjvpLoVX40+TVJhH1
l+JHS6FR2vFY6i/D/jk5xdfDo6m/DE+Vu6JaDo6k/jLMny7Y4eQWTv1leNfz
ueprcij1l0E/Z+QVy9PB1F+Gj1opex91C6L+MqxyWCP7uzWA+suwzyS8yjJQ
QP1lWPTD9elGA3/qL8PQiSu3PD/mQ/1lSFi/pJvJGm/qL0NbmYNQsNOT+stw
fGT5rmX57tS/af9eDLjqqOdG/WWY9S1aWjHThfrLcKdMXGmgPZr6y3AybPnG
5LF86i9DYGaj8ekHo6i/DPIl1lF/Voyg/jJsOtjr9XCJI/WXga94wJsyYyj1
l6FxReDunNwh1F+GJ7f3Sp79GUT9ZbjsclumkzzQmWv+p5LhxufL+/u3tGe+
KcPVvaZhOTP6M6ubHJsc+bG9LXOxDKv1V8T0f9SHWSNDj/1S0bgrVsyVMrw+
9r50+3dL5hoZdlyQSx5aWzD//H+PnsycHK97Z1T1teIx68rRt8efp7tXmTMb
yNGnOOBFlWVXZhM5viwc/8qmyoSZJ8eZAYs14w91Ye4jh9Ely7Lsos7M9nKM
cF/67nFHQ2ZHOazP5b3XWtKRGXIMuV/Wan11B2YvOTYNn/7s0JB2zAI5TvZf
MS29QJ85XE7HX5dZJMfgY86dD/i2YpbLseWQ+RgjkQ5zshw3sy7On7NTmzlF
Tv21mBVyeHQ00j3Y4a/TPy+To7D8XZs/Y+uZ0+UomnR2+v6nv5g3y7F9Uee8
7ut/MCvlGGDx5XBk2nfmXDkyzNXl1zK+MefLcXrXoPc/Xn1hPiVHwYLMbhHe
NcwqORpmN+g9OvIf8005Ev3vtbOo+cCsliPYIecAl1XJXCxHpxTF7HayCmaN
HHu6xMz1DitnrmzqOcG5omx1KXONHB+790o79F7D/FOOul1tRn1Ke83MjYN4
egnf+cpLp/8BOeDUMA==
            "]]}}, {}}, {{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.007333333333333334], AbsoluteThickness[
           0.8], AbsoluteDashing[{8, 0}], LineBox[CompressedData["
1:eJxdz3uMFtUdxvEfLyu8u2g7FYWXi3UoF1dAGLDIy/0oCq+KOOXmgihT0Lq2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            "]]}}, {}}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->{True, True},
       AxesLabel->{None, None},
       AxesOrigin->{0., 0.},
       AxesStyle->{{
          AbsoluteThickness[0.8]}, {
          AbsoluteThickness[0.8]}},
       DisplayFunction->Identity,
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->All,
       LabelStyle->{FontFamily -> "Cmr10", FontSize -> 12},
       Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
              Part[#, 1]], 
             (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
              Part[#, 1]], 
             (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
              Part[#, 2]]}& )}},
       PlotRange->{{0, 50}, {-0.1, 50}},
       PlotRangeClipping->True,
       PlotRangePadding->{{0, 0}, {0, 0}},
       Ticks->{Automatic, Automatic}], {186., -126.07893370497854}, 
      ImageScaled[{0.5, 0.5}], {360., 222.49223594996215}], InsetBox[
      GraphicsBox[{{{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.007333333333333334], AbsoluteThickness[
           1.4], LineBox[CompressedData["
1:eJw12nlcTOsfB/AjocWSJZJiRERSWSqtn/ZEmfa9zizNjCWyXLKUwUX2QrbI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            "]]}}, {}}, {{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.007333333333333334], AbsoluteThickness[
           0.8], AbsoluteDashing[{2, 2}], LineBox[CompressedData["
1:eJw12ndczH8cB/BvSYuUIg1xFCVFRmSkV7SXa++666adEaG4ENlZZYSTVWZG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            "]]}}, {}}, {{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.007333333333333334], AbsoluteThickness[
           0.8], AbsoluteDashing[{8, 2}], LineBox[CompressedData["
1:eJxd2nlYTN8fB/CrkhbLZC3rRJFIhaio+06rNtO+19TM1NjDF5FqVIhQ9uxj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            "]]}}, {}}, {{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.007333333333333334], AbsoluteThickness[
           0.8], AbsoluteDashing[{8, 0}], LineBox[CompressedData["
1:eJxdz3uMFtUdxvEfLyu8u2g7FYWXi3UoF1dAGLDIy/0oCq+KOOXmgihT0Lq2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            "]]}}, {}}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->{True, True},
       AxesLabel->{None, None},
       AxesOrigin->{0., 0.},
       AxesStyle->{{
          AbsoluteThickness[0.8]}, {
          AbsoluteThickness[0.8]}},
       DisplayFunction->Identity,
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->All,
       LabelStyle->{FontFamily -> "Cmr10", FontSize -> 12},
       Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
              Part[#, 1]], 
             (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
              Part[#, 1]], 
             (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
              Part[#, 2]]}& )}},
       PlotRange->{{0, 50}, {-0.1, 50}},
       PlotRangeClipping->True,
       PlotRangePadding->{{0, 0}, {0, 0}},
       Ticks->{Automatic, Automatic}], {558., -126.07893370497854}, 
      ImageScaled[{0.5, 0.5}], {360., 222.49223594996215}]}, {InsetBox[
      GraphicsBox[{{{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.007333333333333334], AbsoluteThickness[
           1.4], LineBox[CompressedData["
1:eJw92ndczfsfB/BvQ1NKRaXkkJKIU0ZR6lVp0HDau84+2SF0Ece4srriXvMa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            "]]}}, {}}, {{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.007333333333333334], AbsoluteThickness[
           0.8], AbsoluteDashing[{2, 2}], LineBox[CompressedData["
1:eJw12nk8VF0YB/AbytYihZHSqJQkkcgSfpQtYew7Y2bMTLv2BZn2vbQqKdO+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            "]]}}, {}}, {{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.011000000000000001`], AbsoluteThickness[
           0.8], AbsoluteDashing[{8, 2}], LineBox[CompressedData["
1:eJw91H1ME3cAxvEfRwcFUV4qOHkZxTtKgVJoWbUK2Ed5B53AECKQsShkYwGn
hjlQyk55cb7AJE5egtEZFQEVJoIRcabjbeNlARURmGYqg9U3FF82QisMR29/
XC6ffO/54y6Xn8vmL2NSKUJI1Nz17q6vmby5fnOUyu6PqKn0tzTUZraOn1j1
qwoTbl0bTXFHybF1dz3491Xlabr4uFopdlVntIn5WhW/ixJta5FBnhC6UcB7
oVKUFz6gp30hun8nzIb3WqXpu7JNmLIcVk+nvK14U6psv9a0n9uU4O3YT1vy
9KpyzYWWbHs/6HWHFphSBJqnx/0lmQH4Z/XGAhOKwp4+Szq/T4Un7WNZ71E8
yPjnHRPIGoyb1r3kUSbIWyffYbd2Le5H7EznUXxoh89PJ10IxEjR6nFjyhwl
lQ9Mcl4G4Xa/yafGlAW01zql0akh6Ior+5iiFkFpW+NzuToUD3vrx4mRFaKW
j5k/7wxD8sSRU8TIGvstzmXRo+HYJEtyIkY2EO7+STfaFIHBGIzMEgEKLhYI
TTMiEZvJlM2SxSjraB8fbY3EjaP82Flii2XnEgPctkeiZ6j/txlih4qhnCSH
4giETTcemCFL4PJ4NalZGI4Oh4rQGfI+bnfnJz9ODkVggJo3Q5bixCabH6py
gxHABue+JfbY9vXg1pYfA3H1pLvfW+IAQdA9U2HHGqxoWzilJ47Y0lhcK2KA
xj8nG/XECd0batWrqvxR73ZVqicfoOdk8OVXGSshCT/+REec8ezFnZSi1uWI
VawZUBMhMsu9vTU7P4Qg5FKDmhXC4kjN3ugaOW7GuZaoiQs6H8x9KK0PNmSZ
faRmXeBk3HCnpU+Khft3S9RkGcSSSbbBzAu9Fc/M1ewykJhKZXOfBw7WJj/K
ITSYxrGkA4li8HsDq3JYGjNh1kvjot3QebcpP4cw2LQ1TcHkiubNMkjP2nVG
ssXV0F2RaiS48tUSxtBdwadStEMVNJT5HordRIQKz7wv8l4ZzIpQ33fsjftz
rruhpeLGd4U6rrshyXnQoWmE62L4tl+UbjVmDF0M9zoPXR3fYOIOI0VT+oVZ
bu+O7L+iCmtfcHsP3OgRlybaM6j1PDGWzXrgaGX1meYxet7EE/bVh7454cJ1
T8wmdhUXTXFdgtNF9ODDWwazErhNVT26xJl44e+ye0f22XJ7L5iKVhw4/4yG
4y1BaRaR4rNchSnfjpk3K8V2IbOgXMt1b6hGW/cclnDdG780r78SP0Gj+JFZ
pD/xQWvh2fhuG2be8MHAQEPTdaXBrA8qx53OajlrfOb/Z3MGoQFBp/yIDJKh
EP/huff9z5g7F4yPTj43NnRWhpagN4MaE4M1Mlgf9j6593fD80SOsUv+lhPX
ub0ck5+Pftuk5PZyvLY9vfTg/3s5sulXvzo/pUFKcnWriC+kKye+XzRuMHzx
7lgKum0w64vFpVkYjmXmrfFFdi9S9Q4M/gWyywbS
            "]]}}, {}}, {{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.007333333333333334], AbsoluteThickness[
           0.8], AbsoluteDashing[{8, 0}], LineBox[CompressedData["
1:eJxdz3uMFtUdxvEfLyu8u2g7FYWXi3UoF1dAGLDIy/0oCq+KOOXmgihT0Lq2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            "]]}}, {}}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->{True, True},
       AxesLabel->{None, None},
       AxesOrigin->{0., 0.},
       AxesStyle->{{
          AbsoluteThickness[0.8]}, {
          AbsoluteThickness[0.8]}},
       DisplayFunction->Identity,
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->All,
       LabelStyle->{FontFamily -> "Cmr10", FontSize -> 12},
       Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
              Part[#, 1]], 
             (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
              Part[#, 1]], 
             (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
              Part[#, 2]]}& )}},
       PlotRange->{{0, 50}, {-0.1, 60}},
       PlotRangeClipping->True,
       PlotRangePadding->{{0, 0}, {0, 0}},
       Ticks->{Automatic, Automatic}], {186., -378.2368011149356}, 
      ImageScaled[{0.5, 0.5}], {360., 222.4922359499621}], InsetBox[
      GraphicsBox[{{{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.007333333333333334], AbsoluteThickness[
           1.4], LineBox[CompressedData["
1:eJxF2ndYU0nbBvBDQDqCghRBDSrYUAELIAI3RXoJvUMKAVwb9orGil1cX0XF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            "]]}}, {}}, {{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.007333333333333334], AbsoluteThickness[
           0.8], AbsoluteDashing[{2, 2}], LineBox[CompressedData["
1:eJw92nlcTG0bB/DTgso2SjWlNEmiLC0oKv20KZFp32uaaaaxFkIihixZouy7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            "]]}}, {}}, {{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.011000000000000001`], AbsoluteThickness[
           0.8], AbsoluteDashing[{8, 2}], LineBox[CompressedData["
1:eJw10n8w1Hkcx/GPtfnZIqxSFPv9WqyNtWxy0vcldpVShpjJhE41qru4TCdh
zTeVkk7nVPrhalwX5fTjjko1XXuHburoHNWp8euaZa6ctMfNORbnxvf7x3e+
85jn+/X96+uemhG7XUAIiZl5/n8brxrao1NjmIJiseqMGQ2tpdgl2a6N2ami
330rV6C0Yl2XzKKP0a9pV5UFLUPOld2NXhZ/MKkviisr3EKgTIyMdxC+Z6Q1
d8xupzKQ9v222l44ytwpD9QMtoXB7s8xPzvhGGM8bm2+KjUcwswiylZoZLbW
l9RIT0bAODETBASDr5ct1DWq8c/K+MNmAgGeGnfZ2O3VYLCpP3uOQAh7R+ZR
10sNBsyv/yUUmKF0KI9RFWrQF5X1sVBgAcNo1KbCQA1efbZywFRghZ6yI4cT
O9R43ma2xVQwF1+U1t2s3qPG44TyOIHABhVNbjczLdR43XJjgJjYwVvSKOvR
hSPlXdklYjIPekfXx/3Dq7DJf7MrMbGH3CYtX9UYhhexeDVNHJBerFy07QKw
cS9dPk0ccXD8dHCSlMGvpyw2ThMxMuwP6p4Eh+LnzrbWKeIEl7ORU1s+D8Hq
8fpjU2Q+bmbuKB3aFozmRTOBLEDC9l7xD71BCA/VCqeIM05ctk2KqVYhlFXn
T5KFUPw9UiURBeJepXfIJFmE+J6STxIblAhqFI0ZiQuk+oMXWo/5o15vqDcS
V8RJipI17grc8LznaySLcd/Km7la5Qv5mguDE2QJJFUR9g8q5NioCnumJW4Y
bI5ZX+/jAwdN3Xda1g2Rtc3V5KgM7QkepVrijozO2151H3pjQ7blei3rjq9y
PtryzagnREW5ci2RQBmvkF118ETL2SErLSuB33zDl2c+9UBxTcqbPELhrTBw
3jI5DYuW8Ko8loLvtcKm0Jn/7VHXrUN5hMaBrCOOpkZq1iyNOc4m4pIxzsQD
RwIenjOluXvWA9f+NZQ7dVNYfkimyiVSqDvfj0ZZ0rNmpViaUv4785zvnhgJ
3nc/eZwz6wldtplocoLvXqAe5h8Vfc93L0wZkm8pw7jvEW+kjSyfOzDMd28c
3nf36LCR38uw0j0kY+sghRqfi/37WRkWi6f3RfRzJj44n2B1YHM7333wMiVr
w2IpzXU53ma3YPsKzqwcZelr9QUd/H4p9ptnt//Yyu+XInfnMVL9EwWXDofT
2cQXsSmns3YNcGZ9UVtT3ruzne9+mH4SVRbbx3c/JBueUaKnFEreWK5dQRRw
2hU9UkLRs4YCmrMi5eMdnFkFHhxPvXt5DmedAnkN+oY4KxqRoRGXQog/Vgc4
RaeZc4Y/hjPn9Rat4cz6Q/bkssH6F2rWOn+4nnC+ctyW3yvRqj+/O72C3yth
fqqhZE83d88qYZ08Kv7akus6JYLrkipteyiQ0vyJD0gA5he4nFSY0rNGANYV
0TnOas5sAM7ldEsU/L0uABdrF1y36aTwH3u+97U=
            "]]}}, {}}, {{}, {{}, {}, 
          {GrayLevel[0], PointSize[0.007333333333333334], AbsoluteThickness[
           0.8], AbsoluteDashing[{8, 0}], LineBox[CompressedData["
1:eJxdz3uMFtUdxvEfLyu8u2g7FYWXi3UoF1dAGLDIy/0oCq+KOOXmgihT0Lq2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            "]]}}, {}}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->{True, True},
       AxesLabel->{None, None},
       AxesOrigin->{0., 0.},
       AxesStyle->{{
          AbsoluteThickness[0.8]}, {
          AbsoluteThickness[0.8]}},
       DisplayFunction->Identity,
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->All,
       LabelStyle->{FontFamily -> "Cmr10", FontSize -> 12},
       Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
              Part[#, 1]], 
             (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
              Part[#, 1]], 
             (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
              Part[#, 2]]}& )}},
       PlotRange->{{0, 50}, {-0.1, 60}},
       PlotRangeClipping->True,
       PlotRangePadding->{{0, 0}, {0, 0}},
       Ticks->{Automatic, Automatic}], {558., -378.2368011149356}, 
      ImageScaled[{0.5, 0.5}], {360., 222.4922359499621}]}}, {}},
  ContentSelectable->True,
  ImageSize->600,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{{3.672150498385268*^9, 3.672150511561586*^9}, 
   3.672150590200449*^9, 3.672150824917918*^9, {3.6721508611395397`*^9, 
   3.6721508707064967`*^9}, 3.6721511489433174`*^9, 3.6721512896393857`*^9, 
   3.6721514927666965`*^9, 3.67215154740516*^9, {3.672151632575676*^9, 
   3.6721516951519327`*^9}, 3.6724082005614767`*^9, 3.6724082458920093`*^9, 
   3.672408497932211*^9, 3.6724087776541805`*^9, 3.6724088252769423`*^9, 
   3.672503465516737*^9, 3.6725703329601417`*^9, {3.6725739378745975`*^9, 
   3.6725739852913384`*^9}},ExpressionUUID->"7cbdb164-6727-4ab1-8ed9-\
fbc5f812bbb1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{
   "\"\<c:/dropbox/mystuff/cred/ECMAScndRev/LTUAdest.pdf\>\"", ",", "pfin", 
    ",", 
    RowBox[{"ImageResolution", "\[Rule]", "500"}]}], "]"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.5831648913706694`*^9, 3.5831649098835206`*^9}, {
   3.583164965374069*^9, 3.583164976766208*^9}, 3.583165030111542*^9, 
   3.6539342054558725`*^9, {3.653990277033844*^9, 3.6539902881699576`*^9}, {
   3.6725034734825335`*^9, 3.6725034867148566`*^9}, {3.6725703423500805`*^9, 
   3.672570342733119*^9}},ExpressionUUID->"59724b1b-e8ba-4bb3-88c6-\
160ca476fc8d"],

Cell[BoxData["\<\"c:/dropbox/mystuff/cred/ECMAScndRev/LTUAdest.pdf\"\>"], \
"Output",
 CellChangeTimes->{{3.653990282161357*^9, 3.6539902897051115`*^9}, 
   3.6539903363007703`*^9, 3.6539906281219497`*^9, 3.6725034924354286`*^9, 
   3.6725703440922546`*^9, {3.672573989160725*^9, 
   3.6725740167264814`*^9}},ExpressionUUID->"c19ecf98-377e-4fac-bbd1-\
7dfee8042955"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
    "\"\<c:/dropbox/mystuff/cred/ECMAScndRev/LTULengths.txt\>\"", ",", 
     "\"\<Table\>\""}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"d", "[", "1", "]"}], "=", "data"}], ";"}], "\[IndentingNewLine]",
   "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"style", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"AbsoluteThickness", "[", "1.4", "]"}], ",", "Black"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"AbsoluteThickness", "[", ".8", "]"}], ",", 
       RowBox[{"AbsoluteDashing", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "2"}], "}"}], "]"}], ",", "Black"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"AbsoluteDashing", "[", 
        RowBox[{"{", 
         RowBox[{"8", ",", "2"}], "}"}], "]"}], ",", 
       RowBox[{"AbsoluteThickness", "[", ".8", "]"}], ",", "Black"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"AbsoluteDashing", "[", 
        RowBox[{"{", 
         RowBox[{"8", ",", "0"}], "}"}], "]"}], ",", 
       RowBox[{"AbsoluteThickness", "[", ".8", "]"}], ",", "Black"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"AbsoluteDashing", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "2"}], "}"}], "]"}], ",", 
       RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", "Black"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"AbsoluteDashing", "[", 
        RowBox[{"{", 
         RowBox[{"8", ",", "0"}], "}"}], "]"}], ",", 
       RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", "Black"}], "}"}]}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"grid", "=", 
   RowBox[{
    RowBox[{"d", "[", "1", "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"pEW", "=."}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"pEW", "[", "j", "]"}], "=", 
       RowBox[{"{", "}"}]}], ";"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "1", ",", "3"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"AppendTo", "[", 
       RowBox[{
        RowBox[{"pEW", "[", "j", "]"}], ",", 
        RowBox[{"ListPlot", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           RowBox[{"{", 
            RowBox[{"grid", ",", 
             RowBox[{
              RowBox[{
               RowBox[{"d", "[", "j", "]"}], "[", 
               RowBox[{"[", 
                RowBox[{"2", "+", "i"}], "]"}], "]"}], "/", 
              RowBox[{
               RowBox[{"d", "[", "j", "]"}], "[", 
               RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}], "]"}], ",", 
          RowBox[{"Joined", "\[Rule]", "True"}], ",", 
          RowBox[{"PlotStyle", "\[Rule]", 
           RowBox[{"style", "[", 
            RowBox[{"[", 
             RowBox[{"i", "+", "1"}], "]"}], "]"}]}], ",", 
          RowBox[{"LabelStyle", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"FontFamily", "\[Rule]", "\"\<Cmr10\>\""}], ",", 
             RowBox[{"FontSize", "\[Rule]", "12"}]}], "}"}]}], ",", 
          RowBox[{"AxesStyle", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"AbsoluteThickness", "[", ".8", "]"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"AbsoluteThickness", "[", ".8", "]"}], "}"}]}], "}"}]}],
           ",", 
          RowBox[{"AxesOrigin", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1"}], "}"}]}], ",", 
          RowBox[{"PlotRange", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "50"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0.95", ",", "1.12"}], "}"}]}], "}"}]}]}], "]"}]}], 
       "]"}], ";"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "1", ",", "1"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"pEW", "=", 
  RowBox[{"GraphicsGrid", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"Show", "[", 
       RowBox[{"pEW", "[", "1", "]"}], "]"}], "}"}], "}"}], ",", 
    RowBox[{"Spacings", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Scaled", "[", 
        RowBox[{"-", "0.05"}], "]"}], ",", 
       RowBox[{"Scaled", "[", "0.05", "]"}]}], "}"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "300"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.653934722659872*^9, 3.6539348435118723`*^9}, {
   3.6539349010238724`*^9, 3.6539350395788727`*^9}, {3.653935073968872*^9, 
   3.653935100303872*^9}, {3.6539351318168726`*^9, 3.6539351319038725`*^9}, {
   3.653985884743659*^9, 3.653985902772462*^9}, {3.653991106829816*^9, 
   3.653991113484481*^9}, {3.6539911605771894`*^9, 3.653991175691701*^9}, 
   3.6539914059297223`*^9, {3.672570678201662*^9, 3.6725706865855007`*^9}, {
   3.672570758318673*^9, 3.672570759005742*^9}, {3.672570966068446*^9, 
   3.672570975574397*^9}},ExpressionUUID->"67e308d3-af0d-4fcd-b12f-\
337fc8509ffe"],

Cell[BoxData[
 GraphicsBox[{{}, InsetBox[
    GraphicsBox[{{{}, {{}, {}, 
        {GrayLevel[0], PointSize[0.007333333333333334], AbsoluteThickness[
         0.8], AbsoluteDashing[{2, 2}], LineBox[CompressedData["
1:eJw91wlUDPrfBvARN0mRvSwZ2ZJiSIToaVEJmfa9ZmkWsnRd3Lq2CZeyZrnK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          "]]}}, {}}, {{}, {{}, {}, 
        {GrayLevel[0], PointSize[0.007333333333333334], AbsoluteThickness[
         0.8], AbsoluteDashing[{8, 2}], LineBox[CompressedData["
1:eJw91wdUDfwfBvBrR0aySso1IpGGkJEebaW67V1338srssOLm5EZ18gel4ys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          "]]}}, {}}, {{}, {{}, {}, 
        {GrayLevel[0], PointSize[0.007333333333333334], AbsoluteThickness[
         0.8], AbsoluteDashing[{8, 0}], LineBox[CompressedData["
1:eJxd1wt8jfUfB/AnoYk0ui0VZ+UyI84YZmznQ2FSHJcyl9lzbjOSThTrxqPI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          "]]}}, {}}},
     AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
     Axes->{True, True},
     AxesLabel->{None, None},
     AxesOrigin->{0., 1.},
     AxesStyle->{{
        AbsoluteThickness[0.8]}, {
        AbsoluteThickness[0.8]}},
     DisplayFunction->Identity,
     Frame->{{False, False}, {False, False}},
     FrameLabel->{{None, None}, {None, None}},
     FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
     GridLines->{None, None},
     GridLinesStyle->Directive[
       GrayLevel[0.5, 0.4]],
     ImagePadding->All,
     LabelStyle->{FontFamily -> "Cmr10", FontSize -> 12},
     Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
            Part[#, 2]]}& )}},
     PlotRange->{{0, 50}, {0.95, 1.12}},
     PlotRangeClipping->True,
     PlotRangePadding->{{0, 0}, {0, 0}},
     Ticks->{Automatic, Automatic}], {175.5, -114.02727092435559}, 
    ImageScaled[{0.5, 0.5}], {360., 222.49223594996212}], {}},
  ContentSelectable->True,
  ImageSize->300,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{{3.653934792692872*^9, 3.653934854145872*^9}, {
   3.6539349120828724`*^9, 3.6539350046138725`*^9}, 3.6539350402718725`*^9, {
   3.6539350749458723`*^9, 3.653935101775872*^9}, 3.653935132659872*^9, {
   3.6539858862388086`*^9, 3.6539859033865232`*^9}, 3.6539905659957376`*^9, {
   3.6539911080029325`*^9, 3.6539911143095636`*^9}, {3.653991162108343*^9, 
   3.653991176348767*^9}, 3.6539914116002893`*^9, 3.6725706929101334`*^9, 
   3.6725707601598577`*^9, {3.6725709507339125`*^9, 
   3.672570976056445*^9}},ExpressionUUID->"28f2ce90-d14e-431e-a1ae-\
3f87a285d364"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{
  "\"\<c:/dropbox/mystuff/cred/ECMAScndRev/LTUlength.pdf\>\"", ",", "pEW", 
   ",", 
   RowBox[{"ImageResolution", "\[Rule]", "300"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6539905711392517`*^9, 3.6539905760997477`*^9}, 
   3.653991119815114*^9, {3.6539914190900383`*^9, 3.653991424625592*^9}, 
   3.6539914567398033`*^9, {3.672571002804119*^9, 
   3.672571012773116*^9}},ExpressionUUID->"57007aed-e5fb-4d83-967d-\
e0cab4ff9fb1"],

Cell[BoxData["\<\"c:/dropbox/mystuff/cred/ECMAScndRev/LTUlength.pdf\"\>"], \
"Output",
 CellChangeTimes->{
  3.6539905804171796`*^9, 3.6539911210922413`*^9, {3.6539911661177435`*^9, 
   3.6539911800931416`*^9}, {3.6539914218083105`*^9, 3.6539914254926786`*^9}, 
   3.653991458227952*^9, 
   3.6725710153343725`*^9},ExpressionUUID->"542ed383-d3dd-4c85-8053-\
dd9aacfc942a"]
}, Open  ]]
},
WindowSize->{1525.2, 794.4},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
FrontEndVersion->"13.0 for Microsoft Windows (64-bit) (February 4, 2022)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"b378759b-9d0f-4987-b031-598653495c2a"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 6092, 168, 532, "Input",ExpressionUUID->"7559b377-2b55-46cc-94fa-b52524e84e25"],
Cell[6674, 192, 56830, 955, 233, "Output",ExpressionUUID->"814e8375-9a96-4723-b0ae-166de78460e7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[63541, 1152, 372, 8, 36, "Input",ExpressionUUID->"4ac42794-2f84-434b-b8b0-ab905f5b3fd8"],
Cell[63916, 1162, 210, 4, 41, "Output",ExpressionUUID->"19f9968e-c0e3-41ed-9b56-6fa39558a0bf"]
}, Open  ]],
Cell[CellGroupData[{
Cell[64163, 1171, 7677, 208, 507, "Input",ExpressionUUID->"1d5f9a63-cda3-4260-87e8-a2cb3b9262d0"],
Cell[71843, 1381, 707, 11, 41, "Output",ExpressionUUID->"58068490-777f-4289-8f07-895c02740187"],
Cell[72553, 1394, 134158, 2238, 527, "Output",ExpressionUUID->"7cbdb164-6727-4ab1-8ed9-fbc5f812bbb1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[206748, 3637, 627, 13, 62, "Input",ExpressionUUID->"59724b1b-e8ba-4bb3-88c6-160ca476fc8d"],
Cell[207378, 3652, 366, 6, 41, "Output",ExpressionUUID->"c19ecf98-377e-4fac-bbd1-7dfee8042955"]
}, Open  ]],
Cell[CellGroupData[{
Cell[207781, 3663, 5439, 148, 433, "Input",ExpressionUUID->"67e308d3-af0d-4fcd-b12f-337fc8509ffe"],
Cell[213223, 3813, 27208, 458, 263, "Output",ExpressionUUID->"28f2ce90-d14e-431e-a1ae-3f87a285d364"]
}, Open  ]],
Cell[CellGroupData[{
Cell[240468, 4276, 482, 10, 36, "Input",ExpressionUUID->"57007aed-e5fb-4d83-967d-e0cab4ff9fb1"],
Cell[240953, 4288, 372, 7, 41, "Output",ExpressionUUID->"542ed383-d3dd-4c85-8053-dd9aacfc942a"]
}, Open  ]]
}
]
*)

