(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.4' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    300752,       5911]
NotebookOptionsPosition[    289876,       5773]
NotebookOutlinePosition[    290303,       5789]
CellTagsIndexPosition[    290260,       5786]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.672421622216898*^9, 3.6724216963703127`*^9}, {
  3.6724223692255917`*^9, 
  3.672422374538123*^9}},ExpressionUUID->"5cbba988-0c26-4155-a6fa-\
e0265415b11d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"prior", "[", "r_", "]"}], "=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"100", "+", "r"}], ")"}], "^", 
    RowBox[{"(", 
     RowBox[{"-", "1.1"}], ")"}]}], "/", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"100", "+", "r"}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"-", "1.1"}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"r", ",", "0", ",", "Infinity"}], "}"}]}], 
    "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"probf", "[", 
   RowBox[{"rhat_", ",", "a_"}], "]"}], ":=", 
  RowBox[{"1", "-", 
   RowBox[{
    RowBox[{"NIntegrate", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{"r", " ", "rhat", " ", 
         RowBox[{"Cos", "[", "phihat", "]"}]}], "]"}], 
       RowBox[{"Exp", "[", 
        RowBox[{
         RowBox[{"-", ".5"}], 
         RowBox[{"r", "^", "2"}]}], "]"}], " ", 
       RowBox[{"prior", "[", "r", "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"r", ",", "0", ",", "20"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"phihat", ",", 
        RowBox[{"-", "a"}], ",", "a"}], "}"}]}], "]"}], "/", 
    RowBox[{"NIntegrate", "[", 
     RowBox[{
      RowBox[{"\[Pi]", " ", 
       RowBox[{"BesselI", "[", 
        RowBox[{"0", ",", 
         RowBox[{"rhat", " ", "r"}]}], "]"}], " ", 
       RowBox[{"Exp", "[", 
        RowBox[{
         RowBox[{"-", ".5"}], 
         RowBox[{"r", "^", "2"}]}], "]"}], 
       RowBox[{"prior", "[", "r", "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"r", ",", "0", ",", "20"}], "}"}]}], "]"}]}]}]}]}], "Input",
 CellChangeTimes->{{3.672422400481717*^9, 3.672422439836652*^9}, {
   3.672422480750743*^9, 3.672422488958564*^9}, {3.672422643428009*^9, 
   3.67242264373304*^9}, 3.6724227468883543`*^9, {3.6724228233219967`*^9, 
   3.6724228343631005`*^9}, {3.6724239958082333`*^9, 
   3.6724240336410165`*^9}, {3.6724838453484745`*^9, 3.6724838567996197`*^9}, 
   3.672490083034543*^9, {3.6724902273439727`*^9, 3.6724902274069786`*^9}, {
   3.672500946767845*^9, 3.6725009615193205`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"023d91ec-3ec0-46c8-a4d3-b3b298119cfa"],

Cell[BoxData[
 FractionBox["0.15848931924611154`", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"100", "+", "r"}], ")"}], "1.1`"]]], "Output",
 CellChangeTimes->{{3.672422471192787*^9, 3.6724224858992577`*^9}, 
   3.672422645871253*^9, 3.6724227483865037`*^9, {3.6724228265833225`*^9, 
   3.672422834885153*^9}, {3.672424000290682*^9, 3.67242403467712*^9}, 
   3.67242423779031*^9, {3.6724901992601643`*^9, 3.6724902279650345`*^9}, 
   3.6725009636185303`*^9, 3.6725893314378796`*^9, 3.6725906922049427`*^9, 
   3.6725909420559254`*^9, 3.6725921356222696`*^9, 3.6731087348289824`*^9, 
   3.673352252853588*^9, 3.930222919629671*^9},
 CellLabel->"Out[1]=",ExpressionUUID->"0e5a63cb-f034-4f6f-b112-dfe0c71c8d92"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xx", "=", 
  RowBox[{"ParallelTable", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"rhat", ",", 
      RowBox[{
       RowBox[{"FindRoot", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"probf", "[", 
           RowBox[{"rhat", ",", "a"}], "]"}], "-", "0.05"}], ",", 
         RowBox[{"{", 
          RowBox[{"a", ",", ".5", ",", "0", ",", 
           RowBox[{"Pi", "/", "2"}]}], "}"}]}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"rhat", ",", "0", ",", "9", ",", ".05"}], "}"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[3]:=",ExpressionUUID->"edd06d99-7d5e-4e57-bd51-a0dd023918f6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "nlim"}], "MessageName"], " ", ":", 
  "  ", "\<\"\\!\\(\\*RowBox[{\\\"phihat\\\"}]\\) = \
\\!\\(\\*RowBox[{\\\"a\\\"}]\\) is not a valid limit of integration.\"\>"}]], \
"Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.9302229290698667`*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"6b4caeac-c3d9-4860-8c2d-d892ccc58d3d"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "nlim"}], "MessageName"], " ", ":", 
  "  ", "\<\"\\!\\(\\*RowBox[{\\\"phihat\\\"}]\\) = \
\\!\\(\\*RowBox[{\\\"a\\\"}]\\) is not a valid limit of integration.\"\>"}]], \
"Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.9302229291687536`*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"2dcac21a-bf85-444b-a277-48f70e817df6"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "nlim"}], "MessageName"], " ", ":", 
  "  ", "\<\"\\!\\(\\*RowBox[{\\\"phihat\\\"}]\\) = \
\\!\\(\\*RowBox[{\\\"a\\\"}]\\) is not a valid limit of integration.\"\>"}]], \
"Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.9302229292413626`*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"db3e6af7-5dcf-4325-85c8-a1fe9faf59ab"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "nlim"}], "MessageName"], " ", ":", 
  "  ", "\<\"\\!\\(\\*RowBox[{\\\"phihat\\\"}]\\) = \
\\!\\(\\*RowBox[{\\\"a\\\"}]\\) is not a valid limit of integration.\"\>"}]], \
"Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.930222929311986*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"b7acc6e4-49c8-4b09-9ae8-b7041e27e356"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], " ", ":", 
  "  ", "\<\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"NIntegrate\\\", \
\\\"::\\\", \\\"nlim\\\"}], \\\"MessageName\\\"]\\) will be suppressed during \
this calculation.\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.930222929380608*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"7193d118-3fcb-4051-bbb9-4af8aa42b210"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "nlim"}], "MessageName"], " ", ":", 
  "  ", "\<\"\\!\\(\\*RowBox[{\\\"phihat\\\"}]\\) = \
\\!\\(\\*RowBox[{\\\"a\\\"}]\\) is not a valid limit of integration.\"\>"}]], \
"Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.930222929452213*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"9c6793ca-4781-4cb9-9a72-6cc64f73b4e7"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "nlim"}], "MessageName"], " ", ":", 
  "  ", "\<\"\\!\\(\\*RowBox[{\\\"phihat\\\"}]\\) = \
\\!\\(\\*RowBox[{\\\"a\\\"}]\\) is not a valid limit of integration.\"\>"}]], \
"Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.930222929524976*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"87c25f85-e696-44a4-a3e5-fc8a9a53d07d"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], " ", ":", 
  "  ", "\<\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"NIntegrate\\\", \
\\\"::\\\", \\\"nlim\\\"}], \\\"MessageName\\\"]\\) will be suppressed during \
this calculation.\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.93022292972756*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"8f4c3f2e-0fa6-458e-815d-5646f83cbcaf"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "inumr"}], "MessageName"], " ", ":", 
  "  ", "\<\"The integrand \
\\!\\(\\*FractionBox[RowBox[{\\\"0.3169786384922231`\\\", \\\" \\\", \
SuperscriptBox[\\\"\[ExponentialE]\\\", RowBox[{RowBox[{\\\"-\\\", \\\"0.5`\\\
\"}], \\\" \\\", SuperscriptBox[\\\"r\\\", \\\"2\\\"]}]], \\\" \\\", RowBox[{\
\\\"Cosh\\\", \\\"[\\\", RowBox[{\\\"0.9500000000000001`\\\", \\\" \\\", \
\\\"r\\\", \\\" \\\", RowBox[{\\\"Cos\\\", \\\"[\\\", \\\"a\\\", \
\\\"]\\\"}]}], \\\"]\\\"}]}], SuperscriptBox[RowBox[{\\\"(\\\", \
RowBox[{\\\"100\\\", \\\"+\\\", \\\"r\\\"}], \\\")\\\"}], \\\"1.1`\\\"]]\\) \
has evaluated to non-numerical values for all sampling points in the region \
with boundaries \\!\\(\\*RowBox[{\\\"{\\\", RowBox[{\\\"{\\\", \
RowBox[{\\\"0\\\", \\\",\\\", \\\"20\\\"}], \\\"}\\\"}], \
\\\"}\\\"}]\\).\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.9302229303286953`*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"2c0c2e8f-f682-4b62-8b57-ecd0286f765a"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "inumr"}], "MessageName"], " ", ":", 
  "  ", "\<\"The integrand \
\\!\\(\\*FractionBox[RowBox[{\\\"0.3169786384922231`\\\", \\\" \\\", \
SuperscriptBox[\\\"\[ExponentialE]\\\", RowBox[{RowBox[{\\\"-\\\", \\\"0.5`\\\
\"}], \\\" \\\", SuperscriptBox[\\\"r\\\", \\\"2\\\"]}]], \\\" \\\", RowBox[{\
\\\"Cosh\\\", \\\"[\\\", RowBox[{\\\"0.05`\\\", \\\" \\\", \\\"r\\\", \\\" \\\
\", RowBox[{\\\"Cos\\\", \\\"[\\\", \\\"a\\\", \\\"]\\\"}]}], \\\"]\\\"}]}], \
SuperscriptBox[RowBox[{\\\"(\\\", RowBox[{\\\"100\\\", \\\"+\\\", \
\\\"r\\\"}], \\\")\\\"}], \\\"1.1`\\\"]]\\) has evaluated to non-numerical \
values for all sampling points in the region with boundaries \
\\!\\(\\*RowBox[{\\\"{\\\", RowBox[{\\\"{\\\", RowBox[{\\\"0\\\", \\\",\\\", \
\\\"20\\\"}], \\\"}\\\"}], \\\"}\\\"}]\\).\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.930222930429426*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"a7e5ac3e-cbc9-4045-9c35-bf6dde0b1ff3"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "inumr"}], "MessageName"], " ", ":", 
  "  ", "\<\"The integrand \
\\!\\(\\*FractionBox[RowBox[{\\\"0.3169786384922231`\\\", \\\" \\\", \
SuperscriptBox[\\\"\[ExponentialE]\\\", RowBox[{RowBox[{\\\"-\\\", \\\"0.5`\\\
\"}], \\\" \\\", SuperscriptBox[\\\"r\\\", \\\"2\\\"]}]], \\\" \\\", RowBox[{\
\\\"Cosh\\\", \\\"[\\\", RowBox[{\\\"0.9500000000000001`\\\", \\\" \\\", \
\\\"r\\\", \\\" \\\", RowBox[{\\\"Cos\\\", \\\"[\\\", \\\"a\\\", \
\\\"]\\\"}]}], \\\"]\\\"}]}], SuperscriptBox[RowBox[{\\\"(\\\", \
RowBox[{\\\"100\\\", \\\"+\\\", \\\"r\\\"}], \\\")\\\"}], \\\"1.1`\\\"]]\\) \
has evaluated to non-numerical values for all sampling points in the region \
with boundaries \\!\\(\\*RowBox[{\\\"{\\\", RowBox[{\\\"{\\\", \
RowBox[{\\\"0\\\", \\\",\\\", \\\"20\\\"}], \\\"}\\\"}], \
\\\"}\\\"}]\\).\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.9302229304553576`*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"ca30840e-0382-4bc2-bf84-590cbd68e3b7"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "inumr"}], "MessageName"], " ", ":", 
  "  ", "\<\"The integrand \
\\!\\(\\*FractionBox[RowBox[{\\\"0.3169786384922231`\\\", \\\" \\\", \
SuperscriptBox[\\\"\[ExponentialE]\\\", RowBox[{RowBox[{\\\"-\\\", \\\"0.5`\\\
\"}], \\\" \\\", SuperscriptBox[\\\"r\\\", \\\"2\\\"]}]], \\\" \\\", RowBox[{\
\\\"Cosh\\\", \\\"[\\\", RowBox[{\\\"0.9500000000000001`\\\", \\\" \\\", \
\\\"r\\\", \\\" \\\", RowBox[{\\\"Cos\\\", \\\"[\\\", \\\"a\\\", \
\\\"]\\\"}]}], \\\"]\\\"}]}], SuperscriptBox[RowBox[{\\\"(\\\", \
RowBox[{\\\"100\\\", \\\"+\\\", \\\"r\\\"}], \\\")\\\"}], \\\"1.1`\\\"]]\\) \
has evaluated to non-numerical values for all sampling points in the region \
with boundaries \\!\\(\\*RowBox[{\\\"{\\\", RowBox[{\\\"{\\\", \
RowBox[{\\\"0\\\", \\\",\\\", \\\"20\\\"}], \\\"}\\\"}], \
\\\"}\\\"}]\\).\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.9302229305251703`*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"31bfea6c-2b17-46d2-ac2a-02016f724b63"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "inumr"}], "MessageName"], " ", ":", 
  "  ", "\<\"The integrand \
\\!\\(\\*FractionBox[RowBox[{\\\"0.3169786384922231`\\\", \\\" \\\", \
SuperscriptBox[\\\"\[ExponentialE]\\\", RowBox[{RowBox[{\\\"-\\\", \\\"0.5`\\\
\"}], \\\" \\\", SuperscriptBox[\\\"r\\\", \\\"2\\\"]}]], \\\" \\\", RowBox[{\
\\\"Cosh\\\", \\\"[\\\", RowBox[{\\\"0.05`\\\", \\\" \\\", \\\"r\\\", \\\" \\\
\", RowBox[{\\\"Cos\\\", \\\"[\\\", \\\"a\\\", \\\"]\\\"}]}], \\\"]\\\"}]}], \
SuperscriptBox[RowBox[{\\\"(\\\", RowBox[{\\\"100\\\", \\\"+\\\", \
\\\"r\\\"}], \\\")\\\"}], \\\"1.1`\\\"]]\\) has evaluated to non-numerical \
values for all sampling points in the region with boundaries \
\\!\\(\\*RowBox[{\\\"{\\\", RowBox[{\\\"{\\\", RowBox[{\\\"0\\\", \\\",\\\", \
\\\"20\\\"}], \\\"}\\\"}], \\\"}\\\"}]\\).\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.930222930597516*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"620944de-3e52-4ce2-92a8-da22d5af10c2"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], " ", ":", 
  "  ", "\<\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"NIntegrate\\\", \
\\\"::\\\", \\\"inumr\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.93022293066733*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"035ecfc3-dc7b-499e-919d-aac5c1f7850b"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "inumr"}], "MessageName"], " ", ":", 
  "  ", "\<\"The integrand \
\\!\\(\\*FractionBox[RowBox[{\\\"0.3169786384922231`\\\", \\\" \\\", \
SuperscriptBox[\\\"\[ExponentialE]\\\", RowBox[{RowBox[{\\\"-\\\", \\\"0.5`\\\
\"}], \\\" \\\", SuperscriptBox[\\\"r\\\", \\\"2\\\"]}]], \\\" \\\", RowBox[{\
\\\"Cosh\\\", \\\"[\\\", RowBox[{\\\"0.05`\\\", \\\" \\\", \\\"r\\\", \\\" \\\
\", RowBox[{\\\"Cos\\\", \\\"[\\\", \\\"a\\\", \\\"]\\\"}]}], \\\"]\\\"}]}], \
SuperscriptBox[RowBox[{\\\"(\\\", RowBox[{\\\"100\\\", \\\"+\\\", \
\\\"r\\\"}], \\\")\\\"}], \\\"1.1`\\\"]]\\) has evaluated to non-numerical \
values for all sampling points in the region with boundaries \
\\!\\(\\*RowBox[{\\\"{\\\", RowBox[{\\\"{\\\", RowBox[{\\\"0\\\", \\\",\\\", \
\\\"20\\\"}], \\\"}\\\"}], \\\"}\\\"}]\\).\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.9302229307361465`*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"c3026f28-cf15-4b05-bdda-778791aaa747"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], " ", ":", 
  "  ", "\<\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"NIntegrate\\\", \
\\\"::\\\", \\\"inumr\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.930222930812801*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"4f331841-b64d-424f-9f30-cf54c93d08db"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "nlim"}], "MessageName"], " ", ":", 
  "  ", "\<\"\\!\\(\\*RowBox[{\\\"phihat\\\"}]\\) = \
\\!\\(\\*RowBox[{\\\"a\\\"}]\\) is not a valid limit of integration.\"\>"}]], \
"Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.930222934675146*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"c2fe7828-3eff-4593-b8ff-a7e10044a1ef"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "nlim"}], "MessageName"], " ", ":", 
  "  ", "\<\"\\!\\(\\*RowBox[{\\\"phihat\\\"}]\\) = \
\\!\\(\\*RowBox[{\\\"a\\\"}]\\) is not a valid limit of integration.\"\>"}]], \
"Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.93022293472585*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"0a7fdfc5-448f-437c-a12f-aca42ab3ce85"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "nlim"}], "MessageName"], " ", ":", 
  "  ", "\<\"\\!\\(\\*RowBox[{\\\"phihat\\\"}]\\) = \
\\!\\(\\*RowBox[{\\\"a\\\"}]\\) is not a valid limit of integration.\"\>"}]], \
"Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.930222934793359*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"1d447c7e-7d3e-4200-a245-b151b2f60ef2"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], " ", ":", 
  "  ", "\<\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"NIntegrate\\\", \
\\\"::\\\", \\\"nlim\\\"}], \\\"MessageName\\\"]\\) will be suppressed during \
this calculation.\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.930222934877511*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"435ae217-544f-42f7-8191-62225c24077e"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "inumr"}], "MessageName"], " ", ":", 
  "  ", "\<\"The integrand \
\\!\\(\\*FractionBox[RowBox[{\\\"0.3169786384922231`\\\", \\\" \\\", \
SuperscriptBox[\\\"\[ExponentialE]\\\", RowBox[{RowBox[{\\\"-\\\", \\\"0.5`\\\
\"}], \\\" \\\", SuperscriptBox[\\\"r\\\", \\\"2\\\"]}]], \\\" \\\", RowBox[{\
\\\"Cosh\\\", \\\"[\\\", RowBox[{\\\"1.85`\\\", \\\" \\\", \\\"r\\\", \\\" \\\
\", RowBox[{\\\"Cos\\\", \\\"[\\\", \\\"a\\\", \\\"]\\\"}]}], \\\"]\\\"}]}], \
SuperscriptBox[RowBox[{\\\"(\\\", RowBox[{\\\"100\\\", \\\"+\\\", \
\\\"r\\\"}], \\\")\\\"}], \\\"1.1`\\\"]]\\) has evaluated to non-numerical \
values for all sampling points in the region with boundaries \
\\!\\(\\*RowBox[{\\\"{\\\", RowBox[{\\\"{\\\", RowBox[{\\\"0\\\", \\\",\\\", \
\\\"20\\\"}], \\\"}\\\"}], \\\"}\\\"}]\\).\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.930222934958727*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"f5654c7b-b80d-40f7-8f3d-5c6e991324c7"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "inumr"}], "MessageName"], " ", ":", 
  "  ", "\<\"The integrand \
\\!\\(\\*FractionBox[RowBox[{\\\"0.3169786384922231`\\\", \\\" \\\", \
SuperscriptBox[\\\"\[ExponentialE]\\\", RowBox[{RowBox[{\\\"-\\\", \\\"0.5`\\\
\"}], \\\" \\\", SuperscriptBox[\\\"r\\\", \\\"2\\\"]}]], \\\" \\\", RowBox[{\
\\\"Cosh\\\", \\\"[\\\", RowBox[{\\\"1.85`\\\", \\\" \\\", \\\"r\\\", \\\" \\\
\", RowBox[{\\\"Cos\\\", \\\"[\\\", \\\"a\\\", \\\"]\\\"}]}], \\\"]\\\"}]}], \
SuperscriptBox[RowBox[{\\\"(\\\", RowBox[{\\\"100\\\", \\\"+\\\", \
\\\"r\\\"}], \\\")\\\"}], \\\"1.1`\\\"]]\\) has evaluated to non-numerical \
values for all sampling points in the region with boundaries \
\\!\\(\\*RowBox[{\\\"{\\\", RowBox[{\\\"{\\\", RowBox[{\\\"0\\\", \\\",\\\", \
\\\"20\\\"}], \\\"}\\\"}], \\\"}\\\"}]\\).\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.930222935019202*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"8c5f2d25-18f9-4b29-b4df-8db0b00be612"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "inumr"}], "MessageName"], " ", ":", 
  "  ", "\<\"The integrand \
\\!\\(\\*FractionBox[RowBox[{\\\"0.3169786384922231`\\\", \\\" \\\", \
SuperscriptBox[\\\"\[ExponentialE]\\\", RowBox[{RowBox[{\\\"-\\\", \\\"0.5`\\\
\"}], \\\" \\\", SuperscriptBox[\\\"r\\\", \\\"2\\\"]}]], \\\" \\\", RowBox[{\
\\\"Cosh\\\", \\\"[\\\", RowBox[{\\\"1.85`\\\", \\\" \\\", \\\"r\\\", \\\" \\\
\", RowBox[{\\\"Cos\\\", \\\"[\\\", \\\"a\\\", \\\"]\\\"}]}], \\\"]\\\"}]}], \
SuperscriptBox[RowBox[{\\\"(\\\", RowBox[{\\\"100\\\", \\\"+\\\", \
\\\"r\\\"}], \\\")\\\"}], \\\"1.1`\\\"]]\\) has evaluated to non-numerical \
values for all sampling points in the region with boundaries \
\\!\\(\\*RowBox[{\\\"{\\\", RowBox[{\\\"{\\\", RowBox[{\\\"0\\\", \\\",\\\", \
\\\"20\\\"}], \\\"}\\\"}], \\\"}\\\"}]\\).\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.930222935100065*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"89bf405a-2c7d-4ae3-be1f-f4f00e31994d"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], " ", ":", 
  "  ", "\<\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"NIntegrate\\\", \
\\\"::\\\", \\\"inumr\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.930222935170656*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"c6557f5c-0823-470a-b72d-f92a2f272a9b"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "nlim"}], "MessageName"], " ", ":", 
  "  ", "\<\"\\!\\(\\*RowBox[{\\\"phihat\\\"}]\\) = \
\\!\\(\\*RowBox[{\\\"a\\\"}]\\) is not a valid limit of integration.\"\>"}]], \
"Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.9302229361619225`*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"96d3c4f8-b4bc-4e8f-91ed-0793791654af"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "nlim"}], "MessageName"], " ", ":", 
  "  ", "\<\"\\!\\(\\*RowBox[{\\\"phihat\\\"}]\\) = \
\\!\\(\\*RowBox[{\\\"a\\\"}]\\) is not a valid limit of integration.\"\>"}]], \
"Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.930222936232661*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"aa38c269-ec37-4697-a44d-0a01068c4543"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "nlim"}], "MessageName"], " ", ":", 
  "  ", "\<\"\\!\\(\\*RowBox[{\\\"phihat\\\"}]\\) = \
\\!\\(\\*RowBox[{\\\"a\\\"}]\\) is not a valid limit of integration.\"\>"}]], \
"Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.9302229362830763`*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"bc036dc0-1f8d-431a-8402-f40d3711901c"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], " ", ":", 
  "  ", "\<\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"NIntegrate\\\", \
\\\"::\\\", \\\"nlim\\\"}], \\\"MessageName\\\"]\\) will be suppressed during \
this calculation.\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.930222936341552*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"5b03b101-cf97-460b-b286-95508fd5029b"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "inumr"}], "MessageName"], " ", ":", 
  "  ", "\<\"The integrand \
\\!\\(\\*FractionBox[RowBox[{\\\"0.3169786384922231`\\\", \\\" \\\", \
SuperscriptBox[\\\"\[ExponentialE]\\\", RowBox[{RowBox[{\\\"-\\\", \\\"0.5`\\\
\"}], \\\" \\\", SuperscriptBox[\\\"r\\\", \\\"2\\\"]}]], \\\" \\\", RowBox[{\
\\\"Cosh\\\", \\\"[\\\", RowBox[{\\\"2.75`\\\", \\\" \\\", \\\"r\\\", \\\" \\\
\", RowBox[{\\\"Cos\\\", \\\"[\\\", \\\"a\\\", \\\"]\\\"}]}], \\\"]\\\"}]}], \
SuperscriptBox[RowBox[{\\\"(\\\", RowBox[{\\\"100\\\", \\\"+\\\", \
\\\"r\\\"}], \\\")\\\"}], \\\"1.1`\\\"]]\\) has evaluated to non-numerical \
values for all sampling points in the region with boundaries \
\\!\\(\\*RowBox[{\\\"{\\\", RowBox[{\\\"{\\\", RowBox[{\\\"0\\\", \\\",\\\", \
\\\"20\\\"}], \\\"}\\\"}], \\\"}\\\"}]\\).\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.9302229363991013`*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"752d716a-264c-4aa1-a81d-94d125266786"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "inumr"}], "MessageName"], " ", ":", 
  "  ", "\<\"The integrand \
\\!\\(\\*FractionBox[RowBox[{\\\"0.3169786384922231`\\\", \\\" \\\", \
SuperscriptBox[\\\"\[ExponentialE]\\\", RowBox[{RowBox[{\\\"-\\\", \\\"0.5`\\\
\"}], \\\" \\\", SuperscriptBox[\\\"r\\\", \\\"2\\\"]}]], \\\" \\\", RowBox[{\
\\\"Cosh\\\", \\\"[\\\", RowBox[{\\\"2.75`\\\", \\\" \\\", \\\"r\\\", \\\" \\\
\", RowBox[{\\\"Cos\\\", \\\"[\\\", \\\"a\\\", \\\"]\\\"}]}], \\\"]\\\"}]}], \
SuperscriptBox[RowBox[{\\\"(\\\", RowBox[{\\\"100\\\", \\\"+\\\", \
\\\"r\\\"}], \\\")\\\"}], \\\"1.1`\\\"]]\\) has evaluated to non-numerical \
values for all sampling points in the region with boundaries \
\\!\\(\\*RowBox[{\\\"{\\\", RowBox[{\\\"{\\\", RowBox[{\\\"0\\\", \\\",\\\", \
\\\"20\\\"}], \\\"}\\\"}], \\\"}\\\"}]\\).\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.9302229364534607`*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"eb2d40c0-e6d3-40b4-9db5-5036758a0a27"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "inumr"}], "MessageName"], " ", ":", 
  "  ", "\<\"The integrand \
\\!\\(\\*FractionBox[RowBox[{\\\"0.3169786384922231`\\\", \\\" \\\", \
SuperscriptBox[\\\"\[ExponentialE]\\\", RowBox[{RowBox[{\\\"-\\\", \\\"0.5`\\\
\"}], \\\" \\\", SuperscriptBox[\\\"r\\\", \\\"2\\\"]}]], \\\" \\\", RowBox[{\
\\\"Cosh\\\", \\\"[\\\", RowBox[{\\\"2.75`\\\", \\\" \\\", \\\"r\\\", \\\" \\\
\", RowBox[{\\\"Cos\\\", \\\"[\\\", \\\"a\\\", \\\"]\\\"}]}], \\\"]\\\"}]}], \
SuperscriptBox[RowBox[{\\\"(\\\", RowBox[{\\\"100\\\", \\\"+\\\", \
\\\"r\\\"}], \\\")\\\"}], \\\"1.1`\\\"]]\\) has evaluated to non-numerical \
values for all sampling points in the region with boundaries \
\\!\\(\\*RowBox[{\\\"{\\\", RowBox[{\\\"{\\\", RowBox[{\\\"0\\\", \\\",\\\", \
\\\"20\\\"}], \\\"}\\\"}], \\\"}\\\"}]\\).\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.930222936516269*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"8f84acd6-c78f-430a-8d2b-7a236e9f6a70"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], " ", ":", 
  "  ", "\<\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"NIntegrate\\\", \
\\\"::\\\", \\\"inumr\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.930222936597144*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"4a071d05-7203-45e4-9d0f-abe47ef87864"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "nlim"}], "MessageName"], " ", ":", 
  "  ", "\<\"\\!\\(\\*RowBox[{\\\"phihat\\\"}]\\) = \
\\!\\(\\*RowBox[{\\\"a\\\"}]\\) is not a valid limit of integration.\"\>"}]], \
"Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.930222939942149*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"a3a30390-08bc-4ea5-90d7-d46689f202b7"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "nlim"}], "MessageName"], " ", ":", 
  "  ", "\<\"\\!\\(\\*RowBox[{\\\"phihat\\\"}]\\) = \
\\!\\(\\*RowBox[{\\\"a\\\"}]\\) is not a valid limit of integration.\"\>"}]], \
"Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.930222940002634*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"02cbca69-f451-4d58-af5b-5ce603cb3004"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "nlim"}], "MessageName"], " ", ":", 
  "  ", "\<\"\\!\\(\\*RowBox[{\\\"phihat\\\"}]\\) = \
\\!\\(\\*RowBox[{\\\"a\\\"}]\\) is not a valid limit of integration.\"\>"}]], \
"Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.930222940063126*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"88552386-e451-4e0c-827c-1e9ab2b52fab"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], " ", ":", 
  "  ", "\<\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"NIntegrate\\\", \
\\\"::\\\", \\\"nlim\\\"}], \\\"MessageName\\\"]\\) will be suppressed during \
this calculation.\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.930222940123816*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"3f7cd506-c4c7-4f48-b85e-fb012bb0536b"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "inumr"}], "MessageName"], " ", ":", 
  "  ", "\<\"The integrand \
\\!\\(\\*FractionBox[RowBox[{\\\"0.3169786384922231`\\\", \\\" \\\", \
SuperscriptBox[\\\"\[ExponentialE]\\\", RowBox[{RowBox[{\\\"-\\\", \\\"0.5`\\\
\"}], \\\" \\\", SuperscriptBox[\\\"r\\\", \\\"2\\\"]}]], \\\" \\\", RowBox[{\
\\\"Cosh\\\", \\\"[\\\", RowBox[{\\\"3.6500000000000004`\\\", \\\" \\\", \
\\\"r\\\", \\\" \\\", RowBox[{\\\"Cos\\\", \\\"[\\\", \\\"a\\\", \
\\\"]\\\"}]}], \\\"]\\\"}]}], SuperscriptBox[RowBox[{\\\"(\\\", \
RowBox[{\\\"100\\\", \\\"+\\\", \\\"r\\\"}], \\\")\\\"}], \\\"1.1`\\\"]]\\) \
has evaluated to non-numerical values for all sampling points in the region \
with boundaries \\!\\(\\*RowBox[{\\\"{\\\", RowBox[{\\\"{\\\", \
RowBox[{\\\"0\\\", \\\",\\\", \\\"20\\\"}], \\\"}\\\"}], \
\\\"}\\\"}]\\).\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.930222940204282*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"a05b2ca6-644e-48b8-85f3-aceab86dd57c"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "inumr"}], "MessageName"], " ", ":", 
  "  ", "\<\"The integrand \
\\!\\(\\*FractionBox[RowBox[{\\\"0.3169786384922231`\\\", \\\" \\\", \
SuperscriptBox[\\\"\[ExponentialE]\\\", RowBox[{RowBox[{\\\"-\\\", \\\"0.5`\\\
\"}], \\\" \\\", SuperscriptBox[\\\"r\\\", \\\"2\\\"]}]], \\\" \\\", RowBox[{\
\\\"Cosh\\\", \\\"[\\\", RowBox[{\\\"3.6500000000000004`\\\", \\\" \\\", \
\\\"r\\\", \\\" \\\", RowBox[{\\\"Cos\\\", \\\"[\\\", \\\"a\\\", \
\\\"]\\\"}]}], \\\"]\\\"}]}], SuperscriptBox[RowBox[{\\\"(\\\", \
RowBox[{\\\"100\\\", \\\"+\\\", \\\"r\\\"}], \\\")\\\"}], \\\"1.1`\\\"]]\\) \
has evaluated to non-numerical values for all sampling points in the region \
with boundaries \\!\\(\\*RowBox[{\\\"{\\\", RowBox[{\\\"{\\\", \
RowBox[{\\\"0\\\", \\\",\\\", \\\"20\\\"}], \\\"}\\\"}], \
\\\"}\\\"}]\\).\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.930222940264799*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"19267509-a9ed-4aef-af09-3dc85f4d9eb3"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "inumr"}], "MessageName"], " ", ":", 
  "  ", "\<\"The integrand \
\\!\\(\\*FractionBox[RowBox[{\\\"0.3169786384922231`\\\", \\\" \\\", \
SuperscriptBox[\\\"\[ExponentialE]\\\", RowBox[{RowBox[{\\\"-\\\", \\\"0.5`\\\
\"}], \\\" \\\", SuperscriptBox[\\\"r\\\", \\\"2\\\"]}]], \\\" \\\", RowBox[{\
\\\"Cosh\\\", \\\"[\\\", RowBox[{\\\"3.6500000000000004`\\\", \\\" \\\", \
\\\"r\\\", \\\" \\\", RowBox[{\\\"Cos\\\", \\\"[\\\", \\\"a\\\", \
\\\"]\\\"}]}], \\\"]\\\"}]}], SuperscriptBox[RowBox[{\\\"(\\\", \
RowBox[{\\\"100\\\", \\\"+\\\", \\\"r\\\"}], \\\")\\\"}], \\\"1.1`\\\"]]\\) \
has evaluated to non-numerical values for all sampling points in the region \
with boundaries \\!\\(\\*RowBox[{\\\"{\\\", RowBox[{\\\"{\\\", \
RowBox[{\\\"0\\\", \\\",\\\", \\\"20\\\"}], \\\"}\\\"}], \
\\\"}\\\"}]\\).\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.930222940325287*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"7bd99e51-81d1-4160-8a6a-b79150aec96b"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], " ", ":", 
  "  ", "\<\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"NIntegrate\\\", \
\\\"::\\\", \\\"inumr\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.9302229403858633`*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"e8c7b7ee-4bd4-4d5b-8683-3881f522efcb"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "nlim"}], "MessageName"], " ", ":", 
  "  ", "\<\"\\!\\(\\*RowBox[{\\\"phihat\\\"}]\\) = \
\\!\\(\\*RowBox[{\\\"a\\\"}]\\) is not a valid limit of integration.\"\>"}]], \
"Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.9302229406965666`*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"35610829-5070-4617-a3af-431180501955"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "nlim"}], "MessageName"], " ", ":", 
  "  ", "\<\"\\!\\(\\*RowBox[{\\\"phihat\\\"}]\\) = \
\\!\\(\\*RowBox[{\\\"a\\\"}]\\) is not a valid limit of integration.\"\>"}]], \
"Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.9302229407490115`*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"93e3a923-aa26-4c3a-a282-4c33acd0f797"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "nlim"}], "MessageName"], " ", ":", 
  "  ", "\<\"\\!\\(\\*RowBox[{\\\"phihat\\\"}]\\) = \
\\!\\(\\*RowBox[{\\\"a\\\"}]\\) is not a valid limit of integration.\"\>"}]], \
"Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.9302229408075953`*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"a5ab24c1-40a6-4a1b-b171-0ecd50fbdbea"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], " ", ":", 
  "  ", "\<\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"NIntegrate\\\", \
\\\"::\\\", \\\"nlim\\\"}], \\\"MessageName\\\"]\\) will be suppressed during \
this calculation.\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.9302229408600655`*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"c9b65abc-7286-487c-a025-dd28808bd3de"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "inumr"}], "MessageName"], " ", ":", 
  "  ", "\<\"The integrand \
\\!\\(\\*FractionBox[RowBox[{\\\"0.3169786384922231`\\\", \\\" \\\", \
SuperscriptBox[\\\"\[ExponentialE]\\\", RowBox[{RowBox[{\\\"-\\\", \\\"0.5`\\\
\"}], \\\" \\\", SuperscriptBox[\\\"r\\\", \\\"2\\\"]}]], \\\" \\\", RowBox[{\
\\\"Cosh\\\", \\\"[\\\", RowBox[{\\\"4.55`\\\", \\\" \\\", \\\"r\\\", \\\" \\\
\", RowBox[{\\\"Cos\\\", \\\"[\\\", \\\"a\\\", \\\"]\\\"}]}], \\\"]\\\"}]}], \
SuperscriptBox[RowBox[{\\\"(\\\", RowBox[{\\\"100\\\", \\\"+\\\", \
\\\"r\\\"}], \\\")\\\"}], \\\"1.1`\\\"]]\\) has evaluated to non-numerical \
values for all sampling points in the region with boundaries \
\\!\\(\\*RowBox[{\\\"{\\\", RowBox[{\\\"{\\\", RowBox[{\\\"0\\\", \\\",\\\", \
\\\"20\\\"}], \\\"}\\\"}], \\\"}\\\"}]\\).\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.930222940920621*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"c423df90-2cf4-4f94-aead-7d1d0fbdc91e"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "inumr"}], "MessageName"], " ", ":", 
  "  ", "\<\"The integrand \
\\!\\(\\*FractionBox[RowBox[{\\\"0.3169786384922231`\\\", \\\" \\\", \
SuperscriptBox[\\\"\[ExponentialE]\\\", RowBox[{RowBox[{\\\"-\\\", \\\"0.5`\\\
\"}], \\\" \\\", SuperscriptBox[\\\"r\\\", \\\"2\\\"]}]], \\\" \\\", RowBox[{\
\\\"Cosh\\\", \\\"[\\\", RowBox[{\\\"4.55`\\\", \\\" \\\", \\\"r\\\", \\\" \\\
\", RowBox[{\\\"Cos\\\", \\\"[\\\", \\\"a\\\", \\\"]\\\"}]}], \\\"]\\\"}]}], \
SuperscriptBox[RowBox[{\\\"(\\\", RowBox[{\\\"100\\\", \\\"+\\\", \
\\\"r\\\"}], \\\")\\\"}], \\\"1.1`\\\"]]\\) has evaluated to non-numerical \
values for all sampling points in the region with boundaries \
\\!\\(\\*RowBox[{\\\"{\\\", RowBox[{\\\"{\\\", RowBox[{\\\"0\\\", \\\",\\\", \
\\\"20\\\"}], \\\"}\\\"}], \\\"}\\\"}]\\).\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.9302229409813495`*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"59c9ee5a-ce99-4497-8b3b-71f2e5b200c2"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "inumr"}], "MessageName"], " ", ":", 
  "  ", "\<\"The integrand \
\\!\\(\\*FractionBox[RowBox[{\\\"0.3169786384922231`\\\", \\\" \\\", \
SuperscriptBox[\\\"\[ExponentialE]\\\", RowBox[{RowBox[{\\\"-\\\", \\\"0.5`\\\
\"}], \\\" \\\", SuperscriptBox[\\\"r\\\", \\\"2\\\"]}]], \\\" \\\", RowBox[{\
\\\"Cosh\\\", \\\"[\\\", RowBox[{\\\"4.55`\\\", \\\" \\\", \\\"r\\\", \\\" \\\
\", RowBox[{\\\"Cos\\\", \\\"[\\\", \\\"a\\\", \\\"]\\\"}]}], \\\"]\\\"}]}], \
SuperscriptBox[RowBox[{\\\"(\\\", RowBox[{\\\"100\\\", \\\"+\\\", \
\\\"r\\\"}], \\\")\\\"}], \\\"1.1`\\\"]]\\) has evaluated to non-numerical \
values for all sampling points in the region with boundaries \
\\!\\(\\*RowBox[{\\\"{\\\", RowBox[{\\\"{\\\", RowBox[{\\\"0\\\", \\\",\\\", \
\\\"20\\\"}], \\\"}\\\"}], \\\"}\\\"}]\\).\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.9302229410421085`*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"474aef8f-98ad-46f7-8193-ae15c92082ec"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], " ", ":", 
  "  ", "\<\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"NIntegrate\\\", \
\\\"::\\\", \\\"inumr\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.930222941103076*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"16acb85f-e767-4d9e-9b93-3d254e86ebd4"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "nlim"}], "MessageName"], " ", ":", 
  "  ", "\<\"\\!\\(\\*RowBox[{\\\"phihat\\\"}]\\) = \
\\!\\(\\*RowBox[{\\\"a\\\"}]\\) is not a valid limit of integration.\"\>"}]], \
"Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.9302229433417892`*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"356d45ce-f6cb-4825-9c6d-c9a0423c4f14"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "nlim"}], "MessageName"], " ", ":", 
  "  ", "\<\"\\!\\(\\*RowBox[{\\\"phihat\\\"}]\\) = \
\\!\\(\\*RowBox[{\\\"a\\\"}]\\) is not a valid limit of integration.\"\>"}]], \
"Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.9302229433868484`*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"f5931b15-5548-4f2b-ad08-9856286cd35d"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "nlim"}], "MessageName"], " ", ":", 
  "  ", "\<\"\\!\\(\\*RowBox[{\\\"phihat\\\"}]\\) = \
\\!\\(\\*RowBox[{\\\"a\\\"}]\\) is not a valid limit of integration.\"\>"}]], \
"Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.930222943434695*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"b2e30122-aac1-4ac5-b922-af36c916c79c"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], " ", ":", 
  "  ", "\<\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"NIntegrate\\\", \
\\\"::\\\", \\\"nlim\\\"}], \\\"MessageName\\\"]\\) will be suppressed during \
this calculation.\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.930222943481037*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"2b915294-ff03-4e05-8d00-a3bdde97271b"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "inumr"}], "MessageName"], " ", ":", 
  "  ", "\<\"The integrand \
\\!\\(\\*FractionBox[RowBox[{\\\"0.3169786384922231`\\\", \\\" \\\", \
SuperscriptBox[\\\"\[ExponentialE]\\\", RowBox[{RowBox[{\\\"-\\\", \\\"0.5`\\\
\"}], \\\" \\\", SuperscriptBox[\\\"r\\\", \\\"2\\\"]}]], \\\" \\\", RowBox[{\
\\\"Cosh\\\", \\\"[\\\", RowBox[{\\\"5.45`\\\", \\\" \\\", \\\"r\\\", \\\" \\\
\", RowBox[{\\\"Cos\\\", \\\"[\\\", \\\"a\\\", \\\"]\\\"}]}], \\\"]\\\"}]}], \
SuperscriptBox[RowBox[{\\\"(\\\", RowBox[{\\\"100\\\", \\\"+\\\", \
\\\"r\\\"}], \\\")\\\"}], \\\"1.1`\\\"]]\\) has evaluated to non-numerical \
values for all sampling points in the region with boundaries \
\\!\\(\\*RowBox[{\\\"{\\\", RowBox[{\\\"{\\\", RowBox[{\\\"0\\\", \\\",\\\", \
\\\"20\\\"}], \\\"}\\\"}], \\\"}\\\"}]\\).\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.9302229435335445`*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"c45d8f96-d619-499d-bbcf-80752f822572"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "inumr"}], "MessageName"], " ", ":", 
  "  ", "\<\"The integrand \
\\!\\(\\*FractionBox[RowBox[{\\\"0.3169786384922231`\\\", \\\" \\\", \
SuperscriptBox[\\\"\[ExponentialE]\\\", RowBox[{RowBox[{\\\"-\\\", \\\"0.5`\\\
\"}], \\\" \\\", SuperscriptBox[\\\"r\\\", \\\"2\\\"]}]], \\\" \\\", RowBox[{\
\\\"Cosh\\\", \\\"[\\\", RowBox[{\\\"5.45`\\\", \\\" \\\", \\\"r\\\", \\\" \\\
\", RowBox[{\\\"Cos\\\", \\\"[\\\", \\\"a\\\", \\\"]\\\"}]}], \\\"]\\\"}]}], \
SuperscriptBox[RowBox[{\\\"(\\\", RowBox[{\\\"100\\\", \\\"+\\\", \
\\\"r\\\"}], \\\")\\\"}], \\\"1.1`\\\"]]\\) has evaluated to non-numerical \
values for all sampling points in the region with boundaries \
\\!\\(\\*RowBox[{\\\"{\\\", RowBox[{\\\"{\\\", RowBox[{\\\"0\\\", \\\",\\\", \
\\\"20\\\"}], \\\"}\\\"}], \\\"}\\\"}]\\).\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.9302229435940094`*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"c1d509a8-82e5-4b10-a447-a519bfedaa64"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "inumr"}], "MessageName"], " ", ":", 
  "  ", "\<\"The integrand \
\\!\\(\\*FractionBox[RowBox[{\\\"0.3169786384922231`\\\", \\\" \\\", \
SuperscriptBox[\\\"\[ExponentialE]\\\", RowBox[{RowBox[{\\\"-\\\", \\\"0.5`\\\
\"}], \\\" \\\", SuperscriptBox[\\\"r\\\", \\\"2\\\"]}]], \\\" \\\", RowBox[{\
\\\"Cosh\\\", \\\"[\\\", RowBox[{\\\"5.45`\\\", \\\" \\\", \\\"r\\\", \\\" \\\
\", RowBox[{\\\"Cos\\\", \\\"[\\\", \\\"a\\\", \\\"]\\\"}]}], \\\"]\\\"}]}], \
SuperscriptBox[RowBox[{\\\"(\\\", RowBox[{\\\"100\\\", \\\"+\\\", \
\\\"r\\\"}], \\\")\\\"}], \\\"1.1`\\\"]]\\) has evaluated to non-numerical \
values for all sampling points in the region with boundaries \
\\!\\(\\*RowBox[{\\\"{\\\", RowBox[{\\\"{\\\", RowBox[{\\\"0\\\", \\\",\\\", \
\\\"20\\\"}], \\\"}\\\"}], \\\"}\\\"}]\\).\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.930222943654873*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"2e582b59-9e21-48f9-96c0-7fa7201c2a2c"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], " ", ":", 
  "  ", "\<\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"NIntegrate\\\", \
\\\"::\\\", \\\"inumr\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.9302229437154636`*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"e32b3375-cc3c-43c1-a237-b6298ad0e8d2"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "nlim"}], "MessageName"], " ", ":", 
  "  ", "\<\"\\!\\(\\*RowBox[{\\\"phihat\\\"}]\\) = \
\\!\\(\\*RowBox[{\\\"a\\\"}]\\) is not a valid limit of integration.\"\>"}]], \
"Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.930222944880416*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"67a96610-5c30-4410-8ed5-39ace9e49b96"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "nlim"}], "MessageName"], " ", ":", 
  "  ", "\<\"\\!\\(\\*RowBox[{\\\"phihat\\\"}]\\) = \
\\!\\(\\*RowBox[{\\\"a\\\"}]\\) is not a valid limit of integration.\"\>"}]], \
"Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.930222944941264*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"5f71e5e8-812c-45ed-b017-0ff6147ec29c"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "nlim"}], "MessageName"], " ", ":", 
  "  ", "\<\"\\!\\(\\*RowBox[{\\\"phihat\\\"}]\\) = \
\\!\\(\\*RowBox[{\\\"a\\\"}]\\) is not a valid limit of integration.\"\>"}]], \
"Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.930222945001834*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"d9e24368-839e-47b5-b41e-88585b7c03bb"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], " ", ":", 
  "  ", "\<\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"NIntegrate\\\", \
\\\"::\\\", \\\"nlim\\\"}], \\\"MessageName\\\"]\\) will be suppressed during \
this calculation.\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.9302229450518103`*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"b520bbf1-28e3-4388-8d6e-d36e52b5e676"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "inumr"}], "MessageName"], " ", ":", 
  "  ", "\<\"The integrand \
\\!\\(\\*FractionBox[RowBox[{\\\"0.3169786384922231`\\\", \\\" \\\", \
SuperscriptBox[\\\"\[ExponentialE]\\\", RowBox[{RowBox[{\\\"-\\\", \\\"0.5`\\\
\"}], \\\" \\\", SuperscriptBox[\\\"r\\\", \\\"2\\\"]}]], \\\" \\\", RowBox[{\
\\\"Cosh\\\", \\\"[\\\", RowBox[{\\\"6.3500000000000005`\\\", \\\" \\\", \
\\\"r\\\", \\\" \\\", RowBox[{\\\"Cos\\\", \\\"[\\\", \\\"a\\\", \
\\\"]\\\"}]}], \\\"]\\\"}]}], SuperscriptBox[RowBox[{\\\"(\\\", \
RowBox[{\\\"100\\\", \\\"+\\\", \\\"r\\\"}], \\\")\\\"}], \\\"1.1`\\\"]]\\) \
has evaluated to non-numerical values for all sampling points in the region \
with boundaries \\!\\(\\*RowBox[{\\\"{\\\", RowBox[{\\\"{\\\", \
RowBox[{\\\"0\\\", \\\",\\\", \\\"20\\\"}], \\\"}\\\"}], \
\\\"}\\\"}]\\).\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.93022294511248*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"0c02cca4-04eb-47a3-9993-8e3019055844"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "inumr"}], "MessageName"], " ", ":", 
  "  ", "\<\"The integrand \
\\!\\(\\*FractionBox[RowBox[{\\\"0.3169786384922231`\\\", \\\" \\\", \
SuperscriptBox[\\\"\[ExponentialE]\\\", RowBox[{RowBox[{\\\"-\\\", \\\"0.5`\\\
\"}], \\\" \\\", SuperscriptBox[\\\"r\\\", \\\"2\\\"]}]], \\\" \\\", RowBox[{\
\\\"Cosh\\\", \\\"[\\\", RowBox[{\\\"6.3500000000000005`\\\", \\\" \\\", \
\\\"r\\\", \\\" \\\", RowBox[{\\\"Cos\\\", \\\"[\\\", \\\"a\\\", \
\\\"]\\\"}]}], \\\"]\\\"}]}], SuperscriptBox[RowBox[{\\\"(\\\", \
RowBox[{\\\"100\\\", \\\"+\\\", \\\"r\\\"}], \\\")\\\"}], \\\"1.1`\\\"]]\\) \
has evaluated to non-numerical values for all sampling points in the region \
with boundaries \\!\\(\\*RowBox[{\\\"{\\\", RowBox[{\\\"{\\\", \
RowBox[{\\\"0\\\", \\\",\\\", \\\"20\\\"}], \\\"}\\\"}], \
\\\"}\\\"}]\\).\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.9302229451730986`*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"abbfac43-b19e-495f-8942-78b9ab1e9da5"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "inumr"}], "MessageName"], " ", ":", 
  "  ", "\<\"The integrand \
\\!\\(\\*FractionBox[RowBox[{\\\"0.3169786384922231`\\\", \\\" \\\", \
SuperscriptBox[\\\"\[ExponentialE]\\\", RowBox[{RowBox[{\\\"-\\\", \\\"0.5`\\\
\"}], \\\" \\\", SuperscriptBox[\\\"r\\\", \\\"2\\\"]}]], \\\" \\\", RowBox[{\
\\\"Cosh\\\", \\\"[\\\", RowBox[{\\\"6.3500000000000005`\\\", \\\" \\\", \
\\\"r\\\", \\\" \\\", RowBox[{\\\"Cos\\\", \\\"[\\\", \\\"a\\\", \
\\\"]\\\"}]}], \\\"]\\\"}]}], SuperscriptBox[RowBox[{\\\"(\\\", \
RowBox[{\\\"100\\\", \\\"+\\\", \\\"r\\\"}], \\\")\\\"}], \\\"1.1`\\\"]]\\) \
has evaluated to non-numerical values for all sampling points in the region \
with boundaries \\!\\(\\*RowBox[{\\\"{\\\", RowBox[{\\\"{\\\", \
RowBox[{\\\"0\\\", \\\",\\\", \\\"20\\\"}], \\\"}\\\"}], \
\\\"}\\\"}]\\).\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.9302229452216225`*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"5d4d29f4-d67d-402e-817d-8eb73cfc7871"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], " ", ":", 
  "  ", "\<\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"NIntegrate\\\", \
\\\"::\\\", \\\"inumr\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.9302229452740746`*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"851bf36d-7b66-498f-b175-ea4bd7859f04"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "nlim"}], "MessageName"], " ", ":", 
  "  ", "\<\"\\!\\(\\*RowBox[{\\\"phihat\\\"}]\\) = \
\\!\\(\\*RowBox[{\\\"a\\\"}]\\) is not a valid limit of integration.\"\>"}]], \
"Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.9302229486787434`*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"e78cb1f5-d25a-4edc-885d-412a1e195266"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "nlim"}], "MessageName"], " ", ":", 
  "  ", "\<\"\\!\\(\\*RowBox[{\\\"phihat\\\"}]\\) = \
\\!\\(\\*RowBox[{\\\"a\\\"}]\\) is not a valid limit of integration.\"\>"}]], \
"Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.9302229487321267`*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"1638f0ba-0fae-4df2-be04-f794215bff6e"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "nlim"}], "MessageName"], " ", ":", 
  "  ", "\<\"\\!\\(\\*RowBox[{\\\"phihat\\\"}]\\) = \
\\!\\(\\*RowBox[{\\\"a\\\"}]\\) is not a valid limit of integration.\"\>"}]], \
"Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.9302229487926865`*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"7b262471-bd83-4f41-b584-87af5c64d346"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], " ", ":", 
  "  ", "\<\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"NIntegrate\\\", \
\\\"::\\\", \\\"nlim\\\"}], \\\"MessageName\\\"]\\) will be suppressed during \
this calculation.\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.9302229488483987`*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"1ea757c2-c9f6-42f6-9a0d-c41465f49ae6"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "inumr"}], "MessageName"], " ", ":", 
  "  ", "\<\"The integrand \
\\!\\(\\*FractionBox[RowBox[{\\\"0.3169786384922231`\\\", \\\" \\\", \
SuperscriptBox[\\\"\[ExponentialE]\\\", RowBox[{RowBox[{\\\"-\\\", \\\"0.5`\\\
\"}], \\\" \\\", SuperscriptBox[\\\"r\\\", \\\"2\\\"]}]], \\\" \\\", RowBox[{\
\\\"Cosh\\\", \\\"[\\\", RowBox[{\\\"7.25`\\\", \\\" \\\", \\\"r\\\", \\\" \\\
\", RowBox[{\\\"Cos\\\", \\\"[\\\", \\\"a\\\", \\\"]\\\"}]}], \\\"]\\\"}]}], \
SuperscriptBox[RowBox[{\\\"(\\\", RowBox[{\\\"100\\\", \\\"+\\\", \
\\\"r\\\"}], \\\")\\\"}], \\\"1.1`\\\"]]\\) has evaluated to non-numerical \
values for all sampling points in the region with boundaries \
\\!\\(\\*RowBox[{\\\"{\\\", RowBox[{\\\"{\\\", RowBox[{\\\"0\\\", \\\",\\\", \
\\\"20\\\"}], \\\"}\\\"}], \\\"}\\\"}]\\).\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.9302229488990817`*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"0802b246-2c82-4c95-a585-08e6d7593d87"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "inumr"}], "MessageName"], " ", ":", 
  "  ", "\<\"The integrand \
\\!\\(\\*FractionBox[RowBox[{\\\"0.3169786384922231`\\\", \\\" \\\", \
SuperscriptBox[\\\"\[ExponentialE]\\\", RowBox[{RowBox[{\\\"-\\\", \\\"0.5`\\\
\"}], \\\" \\\", SuperscriptBox[\\\"r\\\", \\\"2\\\"]}]], \\\" \\\", RowBox[{\
\\\"Cosh\\\", \\\"[\\\", RowBox[{\\\"7.25`\\\", \\\" \\\", \\\"r\\\", \\\" \\\
\", RowBox[{\\\"Cos\\\", \\\"[\\\", \\\"a\\\", \\\"]\\\"}]}], \\\"]\\\"}]}], \
SuperscriptBox[RowBox[{\\\"(\\\", RowBox[{\\\"100\\\", \\\"+\\\", \
\\\"r\\\"}], \\\")\\\"}], \\\"1.1`\\\"]]\\) has evaluated to non-numerical \
values for all sampling points in the region with boundaries \
\\!\\(\\*RowBox[{\\\"{\\\", RowBox[{\\\"{\\\", RowBox[{\\\"0\\\", \\\",\\\", \
\\\"20\\\"}], \\\"}\\\"}], \\\"}\\\"}]\\).\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.930222948959591*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"5d0af0af-4137-4e47-919e-63897f4e686b"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "inumr"}], "MessageName"], " ", ":", 
  "  ", "\<\"The integrand \
\\!\\(\\*FractionBox[RowBox[{\\\"0.3169786384922231`\\\", \\\" \\\", \
SuperscriptBox[\\\"\[ExponentialE]\\\", RowBox[{RowBox[{\\\"-\\\", \\\"0.5`\\\
\"}], \\\" \\\", SuperscriptBox[\\\"r\\\", \\\"2\\\"]}]], \\\" \\\", RowBox[{\
\\\"Cosh\\\", \\\"[\\\", RowBox[{\\\"7.25`\\\", \\\" \\\", \\\"r\\\", \\\" \\\
\", RowBox[{\\\"Cos\\\", \\\"[\\\", \\\"a\\\", \\\"]\\\"}]}], \\\"]\\\"}]}], \
SuperscriptBox[RowBox[{\\\"(\\\", RowBox[{\\\"100\\\", \\\"+\\\", \
\\\"r\\\"}], \\\")\\\"}], \\\"1.1`\\\"]]\\) has evaluated to non-numerical \
values for all sampling points in the region with boundaries \
\\!\\(\\*RowBox[{\\\"{\\\", RowBox[{\\\"{\\\", RowBox[{\\\"0\\\", \\\",\\\", \
\\\"20\\\"}], \\\"}\\\"}], \\\"}\\\"}]\\).\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.9302229490201416`*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"b5c348f7-92c2-4d7a-924c-b00822b1c768"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], " ", ":", 
  "  ", "\<\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"NIntegrate\\\", \
\\\"::\\\", \\\"inumr\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.930222949080624*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"90bbab01-c523-41df-a829-73f66c1d09b7"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "nlim"}], "MessageName"], " ", ":", 
  "  ", "\<\"\\!\\(\\*RowBox[{\\\"phihat\\\"}]\\) = \
\\!\\(\\*RowBox[{\\\"a\\\"}]\\) is not a valid limit of integration.\"\>"}]], \
"Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.9302229506900144`*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"c0f1d738-ebeb-4f2f-b664-f821cc701ef3"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "nlim"}], "MessageName"], " ", ":", 
  "  ", "\<\"\\!\\(\\*RowBox[{\\\"phihat\\\"}]\\) = \
\\!\\(\\*RowBox[{\\\"a\\\"}]\\) is not a valid limit of integration.\"\>"}]], \
"Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.930222950745378*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"080ec467-5cf2-4a48-bffe-82ef527629ff"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "nlim"}], "MessageName"], " ", ":", 
  "  ", "\<\"\\!\\(\\*RowBox[{\\\"phihat\\\"}]\\) = \
\\!\\(\\*RowBox[{\\\"a\\\"}]\\) is not a valid limit of integration.\"\>"}]], \
"Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.930222950806057*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"fbfd57a5-844f-4d48-8e84-b96dec3530d7"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], " ", ":", 
  "  ", "\<\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"NIntegrate\\\", \
\\\"::\\\", \\\"nlim\\\"}], \\\"MessageName\\\"]\\) will be suppressed during \
this calculation.\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.9302229508666477`*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"dd3dd3e5-619f-4be3-9562-3044c16eeade"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "inumr"}], "MessageName"], " ", ":", 
  "  ", "\<\"The integrand \
\\!\\(\\*FractionBox[RowBox[{\\\"0.3169786384922231`\\\", \\\" \\\", \
SuperscriptBox[\\\"\[ExponentialE]\\\", RowBox[{RowBox[{\\\"-\\\", \\\"0.5`\\\
\"}], \\\" \\\", SuperscriptBox[\\\"r\\\", \\\"2\\\"]}]], \\\" \\\", RowBox[{\
\\\"Cosh\\\", \\\"[\\\", RowBox[{\\\"8.15`\\\", \\\" \\\", \\\"r\\\", \\\" \\\
\", RowBox[{\\\"Cos\\\", \\\"[\\\", \\\"a\\\", \\\"]\\\"}]}], \\\"]\\\"}]}], \
SuperscriptBox[RowBox[{\\\"(\\\", RowBox[{\\\"100\\\", \\\"+\\\", \
\\\"r\\\"}], \\\")\\\"}], \\\"1.1`\\\"]]\\) has evaluated to non-numerical \
values for all sampling points in the region with boundaries \
\\!\\(\\*RowBox[{\\\"{\\\", RowBox[{\\\"{\\\", RowBox[{\\\"0\\\", \\\",\\\", \
\\\"20\\\"}], \\\"}\\\"}], \\\"}\\\"}]\\).\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.9302229509174004`*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"2bb99554-402c-4e4d-a008-0f86327771e1"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "inumr"}], "MessageName"], " ", ":", 
  "  ", "\<\"The integrand \
\\!\\(\\*FractionBox[RowBox[{\\\"0.3169786384922231`\\\", \\\" \\\", \
SuperscriptBox[\\\"\[ExponentialE]\\\", RowBox[{RowBox[{\\\"-\\\", \\\"0.5`\\\
\"}], \\\" \\\", SuperscriptBox[\\\"r\\\", \\\"2\\\"]}]], \\\" \\\", RowBox[{\
\\\"Cosh\\\", \\\"[\\\", RowBox[{\\\"8.15`\\\", \\\" \\\", \\\"r\\\", \\\" \\\
\", RowBox[{\\\"Cos\\\", \\\"[\\\", \\\"a\\\", \\\"]\\\"}]}], \\\"]\\\"}]}], \
SuperscriptBox[RowBox[{\\\"(\\\", RowBox[{\\\"100\\\", \\\"+\\\", \
\\\"r\\\"}], \\\")\\\"}], \\\"1.1`\\\"]]\\) has evaluated to non-numerical \
values for all sampling points in the region with boundaries \
\\!\\(\\*RowBox[{\\\"{\\\", RowBox[{\\\"{\\\", RowBox[{\\\"0\\\", \\\",\\\", \
\\\"20\\\"}], \\\"}\\\"}], \\\"}\\\"}]\\).\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.9302229509761596`*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"9be0d168-c266-4b90-bb85-424148887953"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "inumr"}], "MessageName"], " ", ":", 
  "  ", "\<\"The integrand \
\\!\\(\\*FractionBox[RowBox[{\\\"0.3169786384922231`\\\", \\\" \\\", \
SuperscriptBox[\\\"\[ExponentialE]\\\", RowBox[{RowBox[{\\\"-\\\", \\\"0.5`\\\
\"}], \\\" \\\", SuperscriptBox[\\\"r\\\", \\\"2\\\"]}]], \\\" \\\", RowBox[{\
\\\"Cosh\\\", \\\"[\\\", RowBox[{\\\"8.15`\\\", \\\" \\\", \\\"r\\\", \\\" \\\
\", RowBox[{\\\"Cos\\\", \\\"[\\\", \\\"a\\\", \\\"]\\\"}]}], \\\"]\\\"}]}], \
SuperscriptBox[RowBox[{\\\"(\\\", RowBox[{\\\"100\\\", \\\"+\\\", \
\\\"r\\\"}], \\\")\\\"}], \\\"1.1`\\\"]]\\) has evaluated to non-numerical \
values for all sampling points in the region with boundaries \
\\!\\(\\*RowBox[{\\\"{\\\", RowBox[{\\\"{\\\", RowBox[{\\\"0\\\", \\\",\\\", \
\\\"20\\\"}], \\\"}\\\"}], \\\"}\\\"}]\\).\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.9302229510287113`*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"9d3905af-cd70-49b8-80d3-a675499a8842"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], " ", ":", 
  "  ", "\<\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"NIntegrate\\\", \
\\\"::\\\", \\\"inumr\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"\>"}]], "Print",
 ShowCellLabel->True,
 CellChangeTimes->{3.9302229510891843`*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"9bb7c322-fbee-43a9-969d-fc5a832aa772"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.`", ",", "1.4922565076099612`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.05`", ",", "1.4922080210401676`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.1`", ",", "1.4920622934091976`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.15000000000000002`", ",", "1.4918185182718193`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.2`", ",", "1.4914753266083747`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.25`", ",", "1.4910308569575699`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.30000000000000004`", ",", "1.4904825590002448`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.35000000000000003`", ",", "1.4898273663466257`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.4`", ",", "1.48906151574476`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.45`", ",", "1.4881805727811546`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5`", ",", "1.487179428382097`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.55`", ",", "1.486052215632303`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6000000000000001`", ",", "1.4847921085903866`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.65`", ",", "1.48339152137178`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7000000000000001`", ",", "1.4818418014550405`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.75`", ",", "1.4801331121781778`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8`", ",", "1.4782548395760033`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8500000000000001`", ",", "1.4761942306344238`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9`", ",", "1.4739380145636165`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9500000000000001`", ",", "1.4714709541935578`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "1.4687758110324736`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.05`", ",", "1.4658336418918476`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.1`", ",", "1.4626231442691815`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.1500000000000001`", ",", "1.4591209465292316`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.2000000000000002`", ",", "1.455300688380159`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.25`", ",", "1.4511331485839742`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.3`", ",", "1.4465858498450037`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.35`", ",", "1.4416227189959712`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.4000000000000001`", ",", "1.4362036925567419`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.4500000000000002`", ",", "1.430284596634667`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.5`", ",", "1.4238163755717033`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.5500000000000003`", ",", "1.41674522338236`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.6`", ",", "1.409011947844024`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.6500000000000001`", ",", "1.4005520392440103`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.7000000000000002`", ",", "1.391295508027098`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.75`", ",", "1.3811670910705467`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.8000000000000003`", ",", "1.370087107904223`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.85`", ",", "1.3579718930941649`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9000000000000001`", ",", "1.344735997915343`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9500000000000002`", ",", "1.3302941489062776`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.`", ",", "1.3145648603672844`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.0500000000000003`", ",", "1.297474928700362`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1`", ",", "1.2789650625576359`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.1500000000000004`", ",", "1.2589967936913176`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.2`", ",", "1.237559943446674`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.25`", ",", "1.214680085684706`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3000000000000003`", ",", "1.19042570142468`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.35`", ",", "1.1649123332131652`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4000000000000004`", ",", "1.1383036928747294`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.45`", ",", "1.1108071184835906`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5`", ",", "1.0826667900312386`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5500000000000003`", ",", "1.0541489157688448`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6`", ",", "1.0255263843200186`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.6500000000000004`", ",", "0.9970639495678909`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7`", ",", "0.9690032974792538`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.75`", ",", "0.9415536915070163`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.8`", ",", "0.9148846357159851`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.85`", ",", "0.8891250678155008`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9`", ",", "0.8643649624638989`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.95`", ",", "0.8406591526586459`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.`", ",", "0.8180328874820754`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.05`", ",", "0.7964872586417289`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.1`", ",", "0.7760048926899877`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.15`", ",", "0.756554962814191`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.2`", ",", "0.7380970503875002`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.25`", ",", "0.720584582803568`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.3`", ",", "0.7039676896326447`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.35`", ",", "0.6881948950675206`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.4`", ",", "0.6732149364783432`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.45`", ",", "0.6589774463704404`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.5`", ",", "0.6454339240798039`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.55`", ",", "0.632538128675027`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.6`", ",", "0.6202463729079927`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.6500000000000004`", ",", "0.6085176296819004`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.7`", ",", "0.5973136473045492`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.7500000000000004`", ",", "0.5866105218483957`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.8000000000000003`", ",", "0.5763401507487558`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.8500000000000005`", ",", "0.5665069084064693`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.9000000000000004`", ",", "0.5570712376912226`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.95`", ",", "0.5480070546747166`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.`", ",", "0.5392904512911957`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.050000000000001`", ",", "0.5308994268463239`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.1000000000000005`", ",", "0.5228137433408816`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.15`", ",", "0.5150147637576473`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.2`", ",", "0.5074853612674963`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.25`", ",", "0.5002097604261883`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.300000000000001`", ",", "0.49317346760358355`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.3500000000000005`", ",", "0.48636297931628575`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.4`", ",", "0.4797661134750517`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.45`", ",", "0.47337115242687394`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.5`", ",", "0.46716783201518475`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.55`", ",", "0.46114628326525997`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.6`", ",", "0.455297484411981`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.6499999999999995`", ",", "0.44961299559393775`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.7`", ",", "0.44408505213808946`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.75`", ",", "0.4387063698292117`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.8`", ",", "0.43347016939829003`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.85`", ",", "0.42837013516515215`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.8999999999999995`", ",", "0.423400403209812`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.95`", ",", "0.41855537844201773`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.`", ",", "0.413829909472422`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.05`", ",", "0.40921912833770974`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.1`", ",", "0.4047184499889354`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.15`", ",", "0.4003235997208236`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.2`", ",", "0.3960304635497208`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.25`", ",", "0.39183526963086945`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.3`", ",", "0.38773437633706925`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.35`", ",", "0.3837243644804139`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.4`", ",", "0.3798019915708235`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.45`", ",", "0.3759641459851117`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.5`", ",", "0.37220795207072066`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.55`", ",", "0.3685306238772037`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.6000000000000005`", ",", "0.3649295123113151`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.65`", ",", "0.361402125926574`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.7`", ",", "0.35794602431450123`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.75`", ",", "0.3545589762877237`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.8`", ",", "0.35123878452657076`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.8500000000000005`", ",", "0.347983366487747`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.9`", ",", "0.3447907344405042`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.95`", ",", "0.3416589736739875`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6.`", ",", "0.33858628117950096`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6.050000000000001`", ",", "0.33557090933829087`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6.1000000000000005`", ",", "0.3326111711213806`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6.15`", ",", "0.329705474184829`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6.2`", ",", "0.32685226562595593`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6.25`", ",", "0.3240500790384492`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6.300000000000001`", ",", "0.32129748700115557`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6.3500000000000005`", ",", "0.31859315471653704`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6.4`", ",", "0.3159356976196069`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6.45`", ",", "0.31332391415681177`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6.500000000000001`", ",", "0.3107565687507605`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6.550000000000001`", ",", "0.3082324828456336`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6.6000000000000005`", ",", "0.3057505428878936`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6.65`", ",", "0.30330965415766803`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6.7`", ",", "0.3009087645282982`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6.750000000000001`", ",", "0.2985468648894858`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6.800000000000001`", ",", "0.29622297433226613`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6.8500000000000005`", ",", "0.2939361548178003`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6.9`", ",", "0.2916854942518196`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6.950000000000001`", ",", "0.2894701059235299`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7.000000000000001`", ",", "0.2872891432338224`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7.050000000000001`", ",", "0.2851417718656224`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7.1000000000000005`", ",", "0.28302721347948523`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7.15`", ",", "0.28094469257875027`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7.200000000000001`", ",", "0.27889345628993417`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7.25`", ",", "0.2768727952055071`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7.3`", ",", "0.27488200465247997`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7.35`", ",", "0.272920407335358`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7.4`", ",", "0.27098734832649624`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7.45`", ",", "0.26908218768902525`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7.5`", ",", "0.2672043209799218`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7.55`", ",", "0.2653531359149956`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7.6`", ",", "0.2635280542415361`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7.65`", ",", "0.26172851938289027`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7.7`", ",", "0.2599539841919887`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7.75`", ",", "0.25820392196506364`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7.8`", ",", "0.2564777932165174`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7.85`", ",", "0.2547751196979413`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7.9`", ",", "0.2530954151218219`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7.95`", ",", "0.251438203060963`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8.`", ",", "0.24980302420448466`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8.05`", ",", "0.24818943168996893`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8.1`", ",", "0.24659698978935912`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8.15`", ",", "0.2450252840712403`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8.200000000000001`", ",", "0.24347389120898405`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8.25`", ",", "0.2419424169955137`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8.3`", ",", "0.24043047236610468`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8.35`", ",", "0.23893766751159268`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8.4`", ",", "0.23746365204683859`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8.450000000000001`", ",", "0.2360080524490219`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8.5`", ",", "0.23457053362790062`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8.55`", ",", "0.23315073418523485`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8.6`", ",", "0.23174833778650492`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8.65`", ",", "0.2303630159757883`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8.700000000000001`", ",", "0.22899445296296853`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8.75`", ",", "0.22764233949990598`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8.8`", ",", "0.22630637598051218`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8.85`", ",", "0.22498627266429827`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8.9`", ",", "0.2236817357598436`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8.950000000000001`", ",", "0.2223924993141397`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9.`", ",", "0.2211182710486934`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.9302229571941633`*^9},
 CellLabel->"Out[3]=",ExpressionUUID->"fd8929f9-45e6-4dc8-b698-02590febfbf3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", "xx", "]"}]], "Input",
 CellChangeTimes->{{3.6725910755282707`*^9, 
  3.672591078771595*^9}},ExpressionUUID->"056eb7c1-63ce-4301-b5fa-\
2e63b0e837b8"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.009166666666666668], 
     AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJw90wlUk8caBmB2CTskhARCSBQL0kpRFrGK84GVIlaqtl4VsVUqFLHCBXFB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      "]]}, {}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 9.}, {0, 1.4922565076099612`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.6725910791516333`*^9, 
  3.6725913160433197`*^9},ExpressionUUID->"952a3cea-dffa-43d9-9036-\
ef20bb6e4dd7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"hpdfunc", "=", 
    RowBox[{"Interpolation", "[", "xx", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rp", "[", "cv_", "]"}], ":=", 
    RowBox[{
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{"PDF", "[", 
        RowBox[{
         RowBox[{"ChiDistribution", "[", "2", "]"}], ",", "x"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "cv"}], "}"}]}], "]"}], "+", 
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2", 
          RowBox[{
           RowBox[{"hpdfunc", "[", "x", "]"}], "/", "Pi"}]}], ")"}], 
        RowBox[{"PDF", "[", 
         RowBox[{
          RowBox[{"ChiDistribution", "[", "2", "]"}], ",", "x"}], "]"}]}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "cv", ",", "Infinity"}], "}"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"cvs", "=", 
    RowBox[{
     RowBox[{"FindRoot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"rp", "[", "cv", "]"}], "-", "0.95"}], ",", 
       RowBox[{"{", 
        RowBox[{"cv", ",", "1.5"}], "}"}]}], "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"anglecv", "=", 
    RowBox[{
     RowBox[{"Pi", "/", "2"}], "-", 
     RowBox[{"hpdfunc", "[", "cvs", "]"}]}]}]}]}]], "Input",
 CellChangeTimes->{
  3.672589186416379*^9, {3.672589348518587*^9, 3.672589349558691*^9}, 
   3.672589911370867*^9, {3.6725899448282127`*^9, 3.672589956667396*^9}, {
   3.6725900203827667`*^9, 3.6725900222699556`*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"c3d26cd5-9648-49a3-be1d-16ff8959e8f0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox["InterpolatingFunction",
    "SummaryHead"], "[", 
   DynamicModuleBox[{Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
    TemplateBox[{
      PaneSelectorBox[{False -> GridBox[{{
            PaneBox[
             ButtonBox[
              DynamicBox[
               FEPrivate`FrontEndResource["FEBitmaps", "SummaryBoxOpener"]], 
              ButtonFunction :> (Typeset`open$$ = True), Appearance -> None, 
              BaseStyle -> {}, Evaluator -> Automatic, Method -> 
              "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
             Dynamic[{
               Automatic, 
                3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}]], 
            GraphicsBox[{{{{}, {}, 
                TagBox[{
                  Directive[
                   Opacity[1.], 
                   RGBColor[0.368417, 0.506779, 0.709798], 
                   AbsoluteThickness[1]], 
                  LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAA9lXV5lB5hD6s0RZcSOD3P/9OYWKW
x8I/Id0gEZHe9z8jrwJjx5HTP+nwRri62Pc/1u5l3BET3T/CYdZpQc/3P9ml
0YhQMuM/HH/dYbjB9z/1R6b1MEDoPwbPR353rfc/GYZDhrj37D/EwruiO5T3
P/Vbi3QsCvE/MeZsxTtw9z8ofOvUjYzzP6bid4qlQfc/X+ovx8Lj9T/zFg4A
Ewn3P2xSjyKEbfg/7yvnUcm49j99CNMPGcz6P9/y2cVCVvY/2EUNLL8e/T+D
xsiajNj1Pwp9YrHxo/8/You8uBYm9T8gAU7k+/4AQCnA6XFOT/Q/pkB4JEVF
AkCkd4FwtizzP9LDHfyWhQNARHU58hzc8T//bbWcUrAEQMBHmesjifA/GJXa
cVT0BUD0ykDNiTruPzPj8Q/AIgdAyR9+GuTI6z85rpbicWoIQI1CyjwIduk/
5Ly2TCysCUAd4yI+6IPnP5HyyH9Q2ApAlICsxZP35T8qpWjnuh0MQF0tckUx
iOQ/xX76F49NDUBf11WH8mDjPwWcB+Brdw5A9Jx0wr9j4j8wNqLcjroPQF1W
9Df9ceE/rnsX0Q10EECqfX/eoKngP7qaJE53FxFAQ+LCfSDO3z+YW+8W5bcR
QIB+nqcadt4/9y8zxIdNEkAFbouvy1HdP8zCvYvN7xJAwY02smIv3D8iacE3
SIcTQP2LpkjiNds/SrGCL8cbFEAnRGzH+VLaP+i3ikHpvBRAhdS2djdu2T8H
0gs4QFMVQNxE4l9Xp9g/nKrTSDr2FUAi7yFr5t3XP7KWFD5pjhZAXt0Err0t
1z+aJBN/nCMXQN565wkli9Y/+HBY2nLFF0B1rHg1DOXVP9fQFhp+XBhA+a32
o9BS1T8s7xt0LAAZQIgF0AkVvdQ/U6/eGd+gGUCHkVwFKzLUP/uCGqTGNhpA
DrMQ/De30z8ZFZ1IUdkaQGTGNeqRONM/uLqY0RBxG0DF2ZG6HsjSPykCUqbU
BRxA/ER9ROle0j8QCFKVO6ccQKw6avH/8dE/eCHLaNc9HUAqBq6v8pDRP1b5
ilYW4R1AkX71DmYs0T8GcwiQWYEeQDLRjqsSztA/NwD/rdEWH0DzD7a+wnnQ
P95LPObsuB9AeiiyVQ8i0D+DVXmBHiggQJ8Qagj+ps8/UuT3HBh6IEA1q6cr
fQPPPwtEVd6TyiBA5Hykv2Bpzj+ELe8RqhUhQOa7KpT/3s0/OHas0hFnIUBd
fF1Fhk7NP6xIpgUUsyFA77SdBI7MzD/Gq+H6//8hQDCfpoeaTcw/f6rSzQ==

                   "]]}, 
                 Annotation[#, "Charting`Private`Tag$6867#1"]& ]}}, {}}, {
             DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
              AxesOrigin -> {0, 0}, FrameTicks -> {{{}, {}}, {{}, {}}}, 
              GridLines -> {None, None}, DisplayFunction -> Identity, 
              PlotRangePadding -> {{
                 Scaled[0.1], 
                 Scaled[0.1]}, {
                 Scaled[0.1], 
                 Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
              All, DisplayFunction -> Identity, AspectRatio -> 1, 
              Axes -> {False, False}, AxesLabel -> {None, None}, 
              AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
              Frame -> {{True, True}, {True, True}}, 
              FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
              Directive[
                Opacity[0.5], 
                Thickness[Tiny], 
                RGBColor[0.368417, 0.506779, 0.709798]], 
              FrameTicks -> {{None, None}, {None, None}}, 
              GridLines -> {None, None}, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]], ImageSize -> 
              Dynamic[{
                Automatic, 
                 3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                  Magnification])}], 
              Method -> {
               "DefaultBoundaryStyle" -> Automatic, 
                "DefaultGraphicsInteraction" -> {
                 "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                  "Effects" -> {
                   "Highlight" -> {"ratio" -> 2}, 
                    "HighlightPoint" -> {"ratio" -> 2}, 
                    "Droplines" -> {
                    "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
                "DefaultMeshStyle" -> AbsolutePointSize[6], 
                "ScalingFunctions" -> None, 
                "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
              PlotRange -> {{0., 9.}, {0., 1.4922565076095493`}}, 
              PlotRangeClipping -> True, PlotRangePadding -> {{
                 Scaled[0.1], 
                 Scaled[0.1]}, {
                 Scaled[0.1], 
                 Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
            GridBox[{{
               RowBox[{
                 TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox[
                  RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "9.`"}], "}"}], "}"}], 
                  "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"scalar\"", "SummaryItem"]}]}}, 
             GridBoxAlignment -> {
              "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{2}}, "Rows" -> {{Automatic}}},
              BaseStyle -> {
              ShowStringCharacters -> False, NumberMarks -> False, 
               PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
          AutoDelete -> False, 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
          BaselinePosition -> {1, 1}], True -> GridBox[{{
            PaneBox[
             ButtonBox[
              DynamicBox[
               FEPrivate`FrontEndResource["FEBitmaps", "SummaryBoxCloser"]], 
              ButtonFunction :> (Typeset`open$$ = False), Appearance -> None, 
              BaseStyle -> {}, Evaluator -> Automatic, Method -> 
              "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
             Dynamic[{
               Automatic, 
                3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}]], 
            GraphicsBox[{{{{}, {}, 
                TagBox[{
                  Directive[
                   Opacity[1.], 
                   RGBColor[0.368417, 0.506779, 0.709798], 
                   AbsoluteThickness[1]], 
                  LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAA9lXV5lB5hD6s0RZcSOD3P/9OYWKW
x8I/Id0gEZHe9z8jrwJjx5HTP+nwRri62Pc/1u5l3BET3T/CYdZpQc/3P9ml
0YhQMuM/HH/dYbjB9z/1R6b1MEDoPwbPR353rfc/GYZDhrj37D/EwruiO5T3
P/Vbi3QsCvE/MeZsxTtw9z8ofOvUjYzzP6bid4qlQfc/X+ovx8Lj9T/zFg4A
Ewn3P2xSjyKEbfg/7yvnUcm49j99CNMPGcz6P9/y2cVCVvY/2EUNLL8e/T+D
xsiajNj1Pwp9YrHxo/8/You8uBYm9T8gAU7k+/4AQCnA6XFOT/Q/pkB4JEVF
AkCkd4FwtizzP9LDHfyWhQNARHU58hzc8T//bbWcUrAEQMBHmesjifA/GJXa
cVT0BUD0ykDNiTruPzPj8Q/AIgdAyR9+GuTI6z85rpbicWoIQI1CyjwIduk/
5Ly2TCysCUAd4yI+6IPnP5HyyH9Q2ApAlICsxZP35T8qpWjnuh0MQF0tckUx
iOQ/xX76F49NDUBf11WH8mDjPwWcB+Brdw5A9Jx0wr9j4j8wNqLcjroPQF1W
9Df9ceE/rnsX0Q10EECqfX/eoKngP7qaJE53FxFAQ+LCfSDO3z+YW+8W5bcR
QIB+nqcadt4/9y8zxIdNEkAFbouvy1HdP8zCvYvN7xJAwY02smIv3D8iacE3
SIcTQP2LpkjiNds/SrGCL8cbFEAnRGzH+VLaP+i3ikHpvBRAhdS2djdu2T8H
0gs4QFMVQNxE4l9Xp9g/nKrTSDr2FUAi7yFr5t3XP7KWFD5pjhZAXt0Err0t
1z+aJBN/nCMXQN565wkli9Y/+HBY2nLFF0B1rHg1DOXVP9fQFhp+XBhA+a32
o9BS1T8s7xt0LAAZQIgF0AkVvdQ/U6/eGd+gGUCHkVwFKzLUP/uCGqTGNhpA
DrMQ/De30z8ZFZ1IUdkaQGTGNeqRONM/uLqY0RBxG0DF2ZG6HsjSPykCUqbU
BRxA/ER9ROle0j8QCFKVO6ccQKw6avH/8dE/eCHLaNc9HUAqBq6v8pDRP1b5
ilYW4R1AkX71DmYs0T8GcwiQWYEeQDLRjqsSztA/NwD/rdEWH0DzD7a+wnnQ
P95LPObsuB9AeiiyVQ8i0D+DVXmBHiggQJ8Qagj+ps8/UuT3HBh6IEA1q6cr
fQPPPwtEVd6TyiBA5Hykv2Bpzj+ELe8RqhUhQOa7KpT/3s0/OHas0hFnIUBd
fF1Fhk7NP6xIpgUUsyFA77SdBI7MzD/Gq+H6//8hQDCfpoeaTcw/f6rSzQ==

                   "]]}, 
                 Annotation[#, "Charting`Private`Tag$6867#1"]& ]}}, {}}, {
             DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
              AxesOrigin -> {0, 0}, FrameTicks -> {{{}, {}}, {{}, {}}}, 
              GridLines -> {None, None}, DisplayFunction -> Identity, 
              PlotRangePadding -> {{
                 Scaled[0.1], 
                 Scaled[0.1]}, {
                 Scaled[0.1], 
                 Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
              All, DisplayFunction -> Identity, AspectRatio -> 1, 
              Axes -> {False, False}, AxesLabel -> {None, None}, 
              AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
              Frame -> {{True, True}, {True, True}}, 
              FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
              Directive[
                Opacity[0.5], 
                Thickness[Tiny], 
                RGBColor[0.368417, 0.506779, 0.709798]], 
              FrameTicks -> {{None, None}, {None, None}}, 
              GridLines -> {None, None}, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]], ImageSize -> 
              Dynamic[{
                Automatic, 
                 3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                  Magnification])}], 
              Method -> {
               "DefaultBoundaryStyle" -> Automatic, 
                "DefaultGraphicsInteraction" -> {
                 "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                  "Effects" -> {
                   "Highlight" -> {"ratio" -> 2}, 
                    "HighlightPoint" -> {"ratio" -> 2}, 
                    "Droplines" -> {
                    "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
                "DefaultMeshStyle" -> AbsolutePointSize[6], 
                "ScalingFunctions" -> None, 
                "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
              PlotRange -> {{0., 9.}, {0., 1.4922565076095493`}}, 
              PlotRangeClipping -> True, PlotRangePadding -> {{
                 Scaled[0.1], 
                 Scaled[0.1]}, {
                 Scaled[0.1], 
                 Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
            GridBox[{{
               RowBox[{
                 TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox[
                  RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "9.`"}], "}"}], "}"}], 
                  "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"scalar\"", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["3", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"Hermite\"", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["False", "SummaryItem"]}]}}, 
             GridBoxAlignment -> {
              "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{2}}, "Rows" -> {{Automatic}}},
              BaseStyle -> {
              ShowStringCharacters -> False, NumberMarks -> False, 
               PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
          AutoDelete -> False, 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
          BaselinePosition -> {1, 1}]}, 
       Dynamic[Typeset`open$$], ImageSize -> Automatic]},
     "SummaryPanel"],
    DynamicModuleValues:>{}], "]"}],
  InterpolatingFunction[{{0., 9.}}, {
   5, 7, 0, {181}, {4}, 0, 0, 0, 0, Automatic, {}, {}, False}, CompressedData["
1:eJxF0c1qE1EUAOBJmqZpmqb5Tyb/01eo+7kP4MpHEKxLX8HXiG/gurhw7UqI
IgiC4EJRglKRqlWr1r/kfuCBYZhzvnvuuXey67eu3SgmSVL499xL/sedxTru
5vF9P79ytI4Hvh/mUT2Rf5rfPF7HM/Xn+aPlOl5wL+Vf8a/V31i34t5y77hT
7j33gTuTP+M/qn+y7jN3zp1zX7iv3DfuIn+8cRfcd+4H95O75C65X9xv7g+X
hJhPQtw/CbFeCHFdIURW5IpckdvitrgSV+JK3Da3zZXDhh2XuXLYsKMdboer
cBWuwu1yu1yVq3JVbo/b42pcjauZb5/bD4WNqztHPcR7rHMH3IF+DfkG31Bv
6N/gmlyTa3JNrsm1zN0yZyts2KLFtbg21+baXJtrcx2uw3Xs2+E6XJfrcl2u
y3W5Htdzjh7X43pcn+tzfa7P9bmBexlwA27ADbiUS7mUS7nUfxtyQ27IDbkh
N+JG3Igb+d8jbsyNuTE35sbmmzjvxP1NuIl9J9yUm3JTbspNuRk342bcjJtx
85hP5/w81q/OzTuP7ja34E64Jbfikky/TL9Mv0y/TD9uwZ1wS27FJYfhLw79
DcE=
   "], {Developer`PackedArrayForm, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 
    13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 
    31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 
    49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 
    67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 
    85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102,
     103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 
    117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131,
     132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 
    146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160,
     161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 
    175, 176, 177, 178, 179, 180, 181}, CompressedData["
1:eJwNkns01AkAhdEDEUITm0SI7NYqz5K9UUm19E6kklKawhKJTCzSSltYqVTK
K6+ISkWJzaOzMW+DwYxhmPFOmPkZDq0/7vnO+c65/9xzDX0CD/rKy8nJlc9n
qI3k5SIgEGL8T9zyeWY80Hsb2UWg462dDoVPIHfDBfvlPAL3PX/8vL2DwJ1M
H4eFXAKm+4PtjrQQEJfNmm9iE8i2LAxIoxNYIVXIj2wkoP3MuJTfQICm+fFk
+b8Enu8Oq576QCDzRln103IC0ph+tWclBE6vHk8cfU7gkCiolZJBwEVPTXHb
PQLnz6camCQScM59oLEymsBvHO3ppSEETIxL48XnCDxZnGN19xiBgMXiUwMu
BIImQ8622hL4pgorWxMCMsPJmR6NeU/XryidluLO3n7d4B4pKIHKJRNfpPhV
Q2vJbKEUKk8q9fYnSsH1cXMs8JNips5Au9pJikEPcYGTrhQTg8mhgiEJjj07
/nFbpQSraU29ynES7KKGx/W4SKAg+7AuVEkC05NrNEM/T0I7rWFZzpVJCOvI
LK7xJDik6jwV6gTiest8DgdOwGd2jjmjMoHK9ydWXcsexwIF3ijFZhwyhvdL
Xv13bD4bcSH94HeMhvRta+SNQSnwiecdvzHo7hzJGxd/g32YqpWWwjdYXlKz
tjYcRRW5xvij8wiSXZaQ314ehoH4VbkgfwiLNKYWlYgGMWPj4XZo/SC8or+3
sSIHUHwlxEaJ04/JLbyaV9b9sFBMe0PJECMm1ficoroYp2z+hjheBPf28d/L
Fong7zqkOn2rDwPUDL47qQ917SEqvnm9yLVfmF7j0Ivtu4RDalwhND4xpLKr
QjzVTo3ZuEoI/p/t/rH1Paiheoq8g3pAUknRYRv0YG2Wv/pNdjcM6zavcE7o
xl0xWZXv2I03OVcbDWYFKLu9USisFEAWMeAgd02AYWnl2AEHAW6E7BS9kxdA
2SIv2DSpC5YxCRYpBl1QKmkYiXzDx8u6rLi3e/kIFqn3a4l4yJccfH0xloc8
JW/1B0Y8TJfM3Att6EQTp7dceLETl/Oqumu1OjHRebRQVtWB77G7UsjkDqje
3Sw/p9OB0r3Xox7/14536awgi8j2+R84++datEM39ZVNv4gLy9umAlEGF3OP
9pglHePi+ZS+Q7MWF4fqw9uyGW0Y/6qYPXanDalrLRYUu7UB3vyhRvU21Omd
cHVktaLT0OWqfForMrZs2C9/vBU/aMLTNoatUI5aEpTW34Id6wcNdcpa0G9r
5vAqogXJEXmLvXa2oKJUx2zpshYsM059WMXjYDBlTaNvEQc7rZz95sI5yFdO
OhG9m4Mssf1sry4HDeZdtSZDzQgw+HZra1Uzcn6rOmKU1Ixhc/XE5jPNGEne
4rXHrhkqI6TqqKXz3m0iLlDIxsPPxz5qV7KhufBxBTmZPb/vnr5LF9ioySnh
kJzYaIt13Hd2JRvE+nqrAxIWFCMX3OfSWfjCy8ySFbKwXv/m0+J4FvS5RXLj
PiwwKuyca8HCXEDQL/qrWEjQzAv+Mc1En2fo2BkuEyS20QuX90zQg9TLCu8z
UZA7bXozjImqPS8OdLgzYdG1ICrHjokEz9m1Al0m7N3XvU+cYcB2LKs+h8fA
6RuNMrMaBpKCjZVJ2Qwsp6z5dCGegeGpaI4hmQGz6Q+uW93mSS/We7eJgT/M
vjglrZjv2b3OTZTREaG/rr2ojg7+tO01ShId+hVCtVkvOr5qkpRMzelYdM5R
Z4qgoegn4cylBhoUjnb5x9yj4RG7lmLtS0OnfYByrDUNVdU7HP0W01CYtmFV
TysVHQpcyUgBFZ+uDCgnRFJBuW73unQfFTlGRR4+RlQwrDvCHxFNOGyRkuvR
1ITEv0S+6ZlNUFR6F3U8rAnV3R5R6a5N+B/JmfEl
    "]}, {Automatic}],
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellChangeTimes->{3.6725893617729125`*^9, 3.6725899164083705`*^9, 
  3.672589958574587*^9, 3.6725900227820067`*^9, 3.6725907074534674`*^9, 
  3.67259076858858*^9, 3.672590863114032*^9, 3.672591324316147*^9, 
  3.6725920565813665`*^9, 3.673108759491448*^9, 3.673352287604588*^9, 
  3.673352500549588*^9, 3.930223015314149*^9},
 CellLabel->"Out[4]=",ExpressionUUID->"3ee61bc6-597d-4651-a030-4094234c0e9e"],

Cell[BoxData[
 TemplateBox[{
  "NIntegrate", "nlim", 
   "\"\\!\\(\\*RowBox[{\\\"x\\\"}]\\) = \\!\\(\\*RowBox[{\\\"cv\\\"}]\\) is \
not a valid limit of integration.\"", 2, 6, 1, 17538587345957663816, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.6725893502777634`*^9, 3.6725899164173717`*^9, 
  3.67258995860559*^9, 3.67259002281101*^9, 3.672590707555477*^9, 
  3.6725907686155825`*^9, 3.6725908631460347`*^9, 3.67259132434315*^9, 
  3.672592056608369*^9, 3.6731087597974787`*^9, 3.673352288055588*^9, 
  3.673352500575588*^9, 3.930223015396928*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"398de620-da4e-4151-a86e-2ed0ff7b70ab"],

Cell[BoxData[
 TemplateBox[{
  "NIntegrate", "inumr", 
   "\"The integrand \\!\\(\\*FractionBox[RowBox[{\\\"\[LeftSkeleton]\\\", \
\\\"1\\\", \\\"\[RightSkeleton]\\\"}], \\\"\[Pi]\\\"]\\) has evaluated to \
non-numerical values for all sampling points in the region with boundaries \
\\!\\(\\*RowBox[{\\\"{\\\", RowBox[{\\\"{\\\", RowBox[{\\\"\[Infinity]\\\", \
\\\",\\\", RowBox[{RowBox[{\\\"0.`\\\", \\\"\[VeryThinSpace]\\\"}], \
\\\"+\\\", \\\"cv\\\"}]}], \\\"}\\\"}], \\\"}\\\"}]\\).\"", 2, 6, 2, 
   17538587345957663816, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.6725893502777634`*^9, 3.6725899164173717`*^9, 
  3.67258995860559*^9, 3.67259002281101*^9, 3.672590707555477*^9, 
  3.6725907686155825`*^9, 3.6725908631460347`*^9, 3.67259132434315*^9, 
  3.672592056608369*^9, 3.6731087597974787`*^9, 3.673352288055588*^9, 
  3.673352500575588*^9, 3.9302230154667406`*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"5bf740a9-3edd-4113-97f8-ee6fc724d13c"],

Cell[BoxData[
 TemplateBox[{
  "NIntegrate", "nlim", 
   "\"\\!\\(\\*RowBox[{\\\"x\\\"}]\\) = \\!\\(\\*RowBox[{\\\"cv\\\"}]\\) is \
not a valid limit of integration.\"", 2, 6, 3, 17538587345957663816, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.6725893502777634`*^9, 3.6725899164173717`*^9, 
  3.67258995860559*^9, 3.67259002281101*^9, 3.672590707555477*^9, 
  3.6725907686155825`*^9, 3.6725908631460347`*^9, 3.67259132434315*^9, 
  3.672592056608369*^9, 3.6731087597974787`*^9, 3.673352288055588*^9, 
  3.673352500575588*^9, 3.93022301547974*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"db0dcd38-af14-4ffd-9c57-c18902c338b9"],

Cell[BoxData[
 TemplateBox[{
  "NIntegrate", "inumr", 
   "\"The integrand \\!\\(\\*FractionBox[RowBox[{\\\"\[LeftSkeleton]\\\", \
\\\"1\\\", \\\"\[RightSkeleton]\\\"}], \\\"\[Pi]\\\"]\\) has evaluated to \
non-numerical values for all sampling points in the region with boundaries \
\\!\\(\\*RowBox[{\\\"{\\\", RowBox[{\\\"{\\\", RowBox[{\\\"\[Infinity]\\\", \
\\\",\\\", RowBox[{RowBox[{\\\"0.`\\\", \\\"\[VeryThinSpace]\\\"}], \
\\\"+\\\", \\\"cv\\\"}]}], \\\"}\\\"}], \\\"}\\\"}]\\).\"", 2, 6, 4, 
   17538587345957663816, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.6725893502777634`*^9, 3.6725899164173717`*^9, 
  3.67258995860559*^9, 3.67259002281101*^9, 3.672590707555477*^9, 
  3.6725907686155825`*^9, 3.6725908631460347`*^9, 3.67259132434315*^9, 
  3.672592056608369*^9, 3.6731087597974787`*^9, 3.673352288055588*^9, 
  3.673352500575588*^9, 3.9302230154936686`*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"d11993eb-3739-4289-b417-be8ec6a9fe67"],

Cell[BoxData["1.7482897725800823`"], "Output",
 CellChangeTimes->{3.6725893617729125`*^9, 3.6725899164083705`*^9, 
  3.672589958574587*^9, 3.6725900227820067`*^9, 3.6725907074534674`*^9, 
  3.67259076858858*^9, 3.672590863114032*^9, 3.672591324316147*^9, 
  3.6725920565813665`*^9, 3.673108759491448*^9, 3.673352287604588*^9, 
  3.673352500549588*^9, 3.9302230174614058`*^9},
 CellLabel->"Out[6]=",ExpressionUUID->"2b9ab82b-b081-47e4-8ba6-a308a74d362d"],

Cell[BoxData["0.1892675342007497`"], "Output",
 CellChangeTimes->{3.6725893617729125`*^9, 3.6725899164083705`*^9, 
  3.672589958574587*^9, 3.6725900227820067`*^9, 3.6725907074534674`*^9, 
  3.67259076858858*^9, 3.672590863114032*^9, 3.672591324316147*^9, 
  3.6725920565813665`*^9, 3.673108759491448*^9, 3.673352287604588*^9, 
  3.673352500549588*^9, 3.930223017465395*^9},
 CellLabel->"Out[7]=",ExpressionUUID->"5d8f6584-5fda-4877-a437-bc210792a47e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"ContourPlot", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"x1", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x2", ",", 
       RowBox[{"-", "4"}], ",", "8"}], "}"}], ",", 
     RowBox[{"Contours", "\[Rule]", 
      RowBox[{"{", "0.05", "}"}]}], ",", 
     RowBox[{"ContourStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AbsoluteThickness", "[", "1.8", "]"}], ",", "Black"}], 
       "}"}]}], ",", 
     RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Speed\>\""}], ",", 
     RowBox[{"MaxRecursion", "\[Rule]", "8"}], ",", 
     RowBox[{"ContourShading", "\[Rule]", 
      RowBox[{"{", "None", "}"}]}], ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"FontFamily", "\[Rule]", "\"\<Cmr10\>\""}], ",", 
        RowBox[{"FontSize", "\[Rule]", "15"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pf", "=", 
   RowBox[{"Interpolation", "[", "xx", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x1", ",", 
      RowBox[{
       RowBox[{"FindRoot", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"ArcTan", "[", 
           RowBox[{"Abs", "[", 
            RowBox[{"x2", "/", "x1"}], "]"}], "]"}], "==", 
          RowBox[{"pf", "[", 
           RowBox[{"Sqrt", "[", 
            RowBox[{
             RowBox[{"x1", "^", "2"}], "+", 
             RowBox[{"x2", "^", "2"}]}], "]"}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"x2", ",", ".5", ",", "0", ",", "100"}], "}"}]}], "]"}], 
       "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x1", ",", "0.001", ",", "8", ",", ".1"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"brh0", "=", 
   RowBox[{"Interpolation", "[", "%", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"brh0", "[", 
          RowBox[{"Abs", "[", "x", "]"}], "]"}], ",", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"brh0", "[", 
           RowBox[{"Abs", "[", "x", "]"}], "]"}]}], ",", "x"}], "}"}]}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "4"}], ",", "8"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"AbsoluteThickness", "[", "1.2", "]"}], ",", "Black"}], 
        "}"}], "}"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p3", "=", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"brh0", "[", 
          RowBox[{"Abs", "[", "x", "]"}], "]"}], ",", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"brh0", "[", 
           RowBox[{"Abs", "[", "x", "]"}], "]"}]}], ",", "x"}], "}"}]}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "4"}], ",", "8"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"AbsoluteThickness", "[", ".6", "]"}], ",", "Black"}], "}"}],
        "}"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"pCR", "=", 
  RowBox[{"Show", "[", 
   RowBox[{"p1", ",", "p2", ",", 
    RowBox[{"Graphics", "[", 
     RowBox[{"{", 
      RowBox[{"White", ",", 
       RowBox[{"Disk", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", "cvs"}], "]"}]}], "}"}], "]"}],
     ",", 
    RowBox[{"Graphics", "[", 
     RowBox[{"{", 
      RowBox[{"Black", ",", 
       RowBox[{"AbsoluteThickness", "[", "1.2", "]"}], ",", 
       RowBox[{"Circle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", "cvs", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "anglecv"}], ",", "anglecv"}], "}"}]}], "]"}], ",", 
       RowBox[{"Circle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", "cvs", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Pi", "-", "anglecv"}], ",", 
           RowBox[{"Pi", "+", "anglecv"}]}], "}"}]}], "]"}]}], "}"}], "]"}], 
    ",", "p3", ",", 
    RowBox[{"Graphics", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", 
       RowBox[{"AbsoluteDashing", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "2"}], "}"}], "]"}], ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1.96", ",", 
            RowBox[{"-", "8"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1.96", ",", "8"}], "}"}]}], "}"}], "]"}], ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1.96"}], ",", 
            RowBox[{"-", "8"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1.96"}], ",", "8"}], "}"}]}], "}"}], "]"}]}], "}"}],
      "]"}]}], "]"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.672588176860433*^9, 3.6725881945432014`*^9}, {
   3.672588225712318*^9, 3.6725882369904456`*^9}, {3.672588339060652*^9, 
   3.67258840795654*^9}, {3.672589168208558*^9, 3.6725892107058077`*^9}, {
   3.672589321798916*^9, 3.6725893249502306`*^9}, {3.6725893762483597`*^9, 
   3.6725893809358287`*^9}, 3.672589421342869*^9, {3.6725894574194765`*^9, 
   3.672589509981732*^9}, {3.672589610159749*^9, 3.6725896374434767`*^9}, {
   3.672589817033434*^9, 3.672589835784309*^9}, {3.672590041840913*^9, 
   3.6725900707538033`*^9}, {3.6725907117528973`*^9, 3.672590712824004*^9}, {
   3.6725916899167037`*^9, 3.672591697515464*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"5b98ca63-e186-4bf3-aee2-d31507c4c5a7"],

Cell[BoxData[
 GraphicsBox[{{GraphicsComplexBox[CompressedData["
1:eJx1lc9qFEEQhxfBHASdaNIXyWbGt9BT6hnU6F3wHCN5jvgc/nkADwOpgxBf
YG9eRE978LYIEdSd7vp6piqTYcPyMV3VX/8qzT56dfL09a3FYvFl+zd8l2df
y/euXp4ebD9N5fMfj7efncof8nN1Ab8Zll9+r3xW+Aj+VNZXflf6Cfy17FfZ
fCLri+PhuV39YPxg/GD8YPxg/GD8YPxg/ALry8ybC/xg/GD8YPxg/GD8YPxg
/GD8Apun9n6+2vv5au/nq72fr/Z+vtr7+Wrv56u9n6/2fr6V9VnxPcIPxg/G
D8YPxg/GD8YPxg/GL7A+L/MW/GD8YPxg/GD8YPxg/GD8YPwC699/w9NUPxg/
GD8YPxg/GD8YPxg/GL/Alk8K+aWQXwr5pZBfCvmlkF8K+aWQXwr5Vdb3uc/D
6gfjB+MH4wfjB+MH4wfjB+MX2O5nJ/7+duLvb1f9YH9/O/H3txN/fzvx97cT
f3+76ge/zf3u68fc547iC9t7Ce8lvLf5L8P/y5L+EjnuX3hX/fvKNR8//6U8
yQE+sN+Pu2osge135ZD1AuMb69mf+rh/6Ff9eU8/+sf96ZePd7pned9TYwms
ud1xy3qB/bzGenyoj/6h3zV/+tE/7k+/fJzPe5Zfo8YS2M7fsl5gn/9Yjw/1
8/nXfjfkzz3bv7Y//fJxvpF/o8YSuJx/1bJeYJ//WI8P9bP5j/1uyH/0j/vT
7+dw3X9Z/qtGjSVwOf+6Zb3ALv9JPT7Uz+Y/9pvPfxXyn+xPv3y/f1v+60aN
JXA5/6ZlvcAu/0k9PtTP5j/2m89/HfKf7E+/fJ//WP6bRo0lcDn/Vct6gV3+
k3p8qJ/Nf+w3n/8m5D/Zn37/AUUmdpw=
     "], {}], {}}, {{{}, {}, 
     TagBox[
      {GrayLevel[0], AbsoluteThickness[1.2], Opacity[1.], FaceForm[Opacity[
       0.3]], LineBox[CompressedData["
1:eJwl2nc8lt//B/DrkhHZyUpGoQhJSYPOaUiJsiplJoSKPlQyKjursjNKqJQd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        "]]},
      Annotation[#, "Charting`Private`Tag$12888#1"]& ], 
     TagBox[
      {GrayLevel[0], AbsoluteThickness[1.2], Opacity[1.], FaceForm[Opacity[
       0.3]], LineBox[CompressedData["
1:eJwl2nc8lt//B/DrUijZyUpGoQhJSUOdqyEllVUpM6Go6EPLqOysyi6UUCk7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        "]]},
      Annotation[#, "Charting`Private`Tag$12888#2"]& ]}, {}}, 
   {GrayLevel[1], DiskBox[{0, 0}, 1.7482897725800823]}, 
   {GrayLevel[0], AbsoluteThickness[1.2], 
    CircleBox[{0, 0}, 1.7482897725800823, {-0.1892675342007497, 
     0.1892675342007497}], 
    CircleBox[{0, 0}, 1.7482897725800823, {2.9523251193890436`, 
     3.3308601877905426`}]}, {{{}, {}, 
     TagBox[
      {GrayLevel[0], AbsoluteThickness[0.6], Opacity[1.], FaceForm[Opacity[
       0.3]], LineBox[CompressedData["
1:eJwl2nc8lt//B/DrkhHZyUpGoQhJSYPOaUiJsiplJoSKPlQyKjursjNKqJQd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        "]]},
      Annotation[#, "Charting`Private`Tag$12924#1"]& ], 
     TagBox[
      {GrayLevel[0], AbsoluteThickness[0.6], Opacity[1.], FaceForm[Opacity[
       0.3]], LineBox[CompressedData["
1:eJwl2nc8lt//B/DrUijZyUpGoQhJSUOdqyEllVUpM6Go6EPLqOysyi6UUCk7
srLOIWXvkb1Ckj3u221+T7+fP3g8Hx7Xfa3zPuf9Oo9bwsxWx4KJIIi9+Ne/
vx9exLY0qBCI+L8fbnSIS61DcD+BzF7y3b4/z4XeDF4XMsEuUZBpH53kQifW
SR0fxX5qpJPR1seFHMBB3fUHCcSZ9/7Gl29cKPjU18hzqgQSuX+63vIpF1Ip
brBkPUqg/aNBsdWcXEhzkHSlzhDItlVKLXILJ+qP65aOwg5g4jG33cSJeoxO
Sy5hf5ZbcjvOwYkKVdS2f9Uk0KRLA/q7xIFYbh/RVzlHoDsyT1RVOzlQYKnu
1xPaBLJzbN3TFcGBGk/PMcddItA9Eb+tYoIcqDhy7O0rCwI5mU6uxvKyIxM9
N3VWSwKtZI8XkhvYUa1xs9Z9bDeusUema9jRGDngd+E6gXwL/yxumd2AJOzY
PghaEeiVyC/6q+YNqMvI4mPaLQJltTZPPH+1AfH7Z0rvvkugaa28HkfRDeio
b/Dvex4Esj7qBXVk2ZAbx+fwJew7hxVqf25lQ19vFee7e+LrO9DSbbiZDQ3n
W18K9iKQy27pFUt2NmQSqjKS7U2gMIkfqk7j65Fl6u4+/mcE+kay5L5LX4/K
bqb/VArDz7fYM2P24Hp0t/P1rvx4AtUe84wPO7MOVV62fno7gUAh9WtuOhxf
h4wjtt8SSySQvqmbnOGhdajca0+PRxKBeh89SZXYuQ7F0nseX0zFzzfHITOJ
bR3K4ahlFswkEPcum6LiclZU8nZQi7WIQFqbL7WNq7MiNf43NU/aCVQ/s2O9
+gkWlLTbfICDi0SZyy9vvzVZi5jDmn/ra5JoX3aiurkOEwJZQvxnzpIoKqEg
8YIGE7qyECl9+ByJWKJqudSPMaFuyDskrkWiFo+ZnzJKTKhxsfb9kC6J7ukc
ujHBw4TEN0FtKwMSZYxVeDvWk+i32eOBw9YkUpIcKQ/Ax6Ws7yJivUgkH7hD
swCPC0m6+OytpySaTzurdUAdvxcPNk0VbxKVNNjpZQICDT/QlajwIdEVvgLD
ZEUCWT4wkR72J5H3S+3bb3gJpCxnfnptMIlKD82JLCatQnrKWuHEKBLtvRAe
45S/Ak8XgtvGb0lUGfYr3j55BUaVfO7kjiaRWat8+s2oFehp85fFPoZELwyK
iw1cVmBVE6e73HsSjVz9++vQiRVYJPFe7b94EkXbHJZeqlyGn43bzu36QiIO
774E544luPBArqoaW3yilV+xcgkqGj6Yts7A579Y5/YrdwnyR/PNRmeSyFAS
XtGIWIIdu8WsF7NJlIBeswleXoLJRswC1/NJdIpxyfpLyyLU/TFlPYZtaHq+
xfLHIrQ7F7zFroBEd0pPHhPOWoRNClyB9wtJ9DJUWdg1dBEqa74+fxORaGj3
xopzeovwd45pO1lCInfrGpmR+gWY6x8SeAs7rP576JuiBRj5MuN2M3bC/gJS
O20BWoE3njHfSdTAktSWHbAAH2hrVmwtxffzzsfH8/wCpF3aAh5j72VzndsP
FuAZ29jcn9in/nt4dVRhAZoWJGV5lJHIFlw/oMu5AO20l/V/lJOosOPEH/Fq
BhzRTwjnqcCff0z1QlM+A64501h8BXsofk/R0yQGvF6wdmQIm+Ph1vBxPwbk
5wzplKnE5+8RYo51YkA5p/yP1th7T/L8d+EmA/7cT2UPYhvyEafzNRgwSOv8
jFgVfj5O9Azbgwy4ymtCv4Tt3j8uvk2WAQ9KD58swk743DXvs54BFY5s8p3G
LhRoNj/MmIdiLxI8JKrx9T2uqpscnocnre+9eIjN0Mz7dKlsHtqsrCejsJs4
2/TEv87DlblhyyLslDoa8Sd+Hg7Lphf0Y/sE8SWnRcxDiQfMTEw1JDLXU7rs
6DcPozLcFMWwAb8W83HneahbUK52EFu49XbahtvzcM9NxyO62HPhfkZNRtiv
9gpYY9cZxK9/c24enhJ9VfUYO3FLaaYFmIcWP08YBGJ79QxcVVCch0/etMMY
bNMYJk66+Dz01WDQUrEPXRPPhTzzMDBejykfm1/qiKU3E75eyTzmH9iTQwa8
2jN02OzLX1+NXfnJoVBogA5jxt+YNmLHWb+07m+iw5fXvD+3YLvKZfInfqdD
pmX2gp/YhuMNxfZZdChXY+b27//7Pk/aqH6kQ9MRtNSAzWPHuZn5FR0Omxvv
+Pf5o3vkSqu96ZBL2478jv1j7rR9mAMdihbv8cjFjsm+LmZiTYdmlW1JydjO
Dp6V2w3oUNIl8kEU9qVD7x5MnqHD1JnUXn9spWW07asqHZ49cG7gITY77K51
lafD0+bJj82wf7ssOWmI0uHY07VJp7GLjwnv2MhFh57ZvjcUsF+v3d/UsUqD
WU8Jl0n8/nS87eVu99Hg4DnjxmpseY3AVuUGGlSyLY37hL2OPdVjpZgGNde9
KryIXfBipPPFexpM+Xh7UQb7lfY6H/1QGtQfk41fwOPLbqO0soQXDZbFxumF
YO94efVZ+nUa3K3Z6GqEvebykwNO+jT49qwwtyR2t/CbweOnadDoddiReDy+
g6NaDzfL0uDZE++sgnF9rHw4P04fm4N53stS6tht129HoO452JX0WXwe11uG
jN9Jn9o5yNOKoDa2VfKPKOG0OSgV+kv2F67XpozD5w/fnYO86SamLtip9w0W
mS3moNk++zRhbN/9Dh9rLsxB8utqyMkfJKLyM1ZNVOaghOv6YUc8XyR+2/nZ
bWEWUvZuk0zYvjWvl1/+nYUiSkLc3t9IdKON40xy5yyMjeig+RSTSHJiYvBn
4SycVb+ZYI3npyjhjM3y7rNQo7boTAfE71dKyurY3VmoJ13afQrbQDEs65LF
LPSocvghjOc3wZMPtd3UZ6F+DuQLzyNR0H+qT39umIXaztV5k7m43p2Tm0aX
ZuCKRJG8Gvb5p6JbmcZn4MPIOeOBHDwe3hAFcnUz8C9zk80inn+9ykqmXUNm
YLeJ0IJ3Kokcxc4ay22ZgV31r4ISU0ikL1uYeJRzBhoeMfpQkUwiFeVdjIur
03BAsFtiJZFEsxo8Ia590/CmTk/tgU8ksrnfXN7yYRrmlHeUreD1xazaSNlV
YRouEU4Hh/D6Q7XWuIWJTcMxxzWl5W9IJPYL1CVyT8POUwxBz0gSdc5L3GyZ
noKHK18yKsNIdFFyKHpn9hQ8K0G/GoHXt9NONuwtYAqOJ851bvMj0ftE/4K4
XVPwSvDnY5/wekh0Jtg8EJuCan7aH2Pwepql+rtOcHUSCsYufLvggp//ikmo
QeEkfOBagHLtSLTqoi3apzoJ+dfr643fwetpmm1tmtwk3LP/6T4RW3x83zMX
N5FJ2Jp27sb1m3h8eYR8V5+fgK94mz7lXcPji9XrXPX9CbgxOXQrhdd7aw4r
01b7cdjsyq/Hp00iCZsPxQ664/DVvbfs/bhfaK3pk9y8Zxw2qPZ3W2mQSC3g
yh+j6TE40tnyWuYont83atr9ujMGC4ST11vI435CcJfH+O1R+N8fThcdgkRH
Jec+rr0xAjtf3Cv6b5lAXgcf+9adHoFf4UqEzwKBKrRYb7/eOQIz7KQ7YmcJ
pPdISGnvxB8osLS2+fEwgW60HM6/dv8PXH3kVFpeg/tVb6+6Yo9hKHBZIeZ2
JYGao7i+PLcchrn8uh3ryggknPkq9MqpYQimNgtJ4f7pfV/ClekNwzB2R63u
dDqBsg/WDkgE/4YxlR3Pq0II1D0qwHCJGYJcegGSnQEE2rYmpkPTfQgqFP5J
/OWPzy8kWyhoMQRbJoqKOnE/Oa2m6v55xxAscHe5ro37T5a3phy9qYNwevWM
qDTuh+W14yVA4QAkH3nfTiUJ5Jx5UGO5vR+GJOiwZNBXYR6/6CzI7YeMW/NP
h/6u4r6DjHIL74d9zi0yfY2r8MHBsilW/X5YIB6/XSR2FdrBC+G8zX2QT3kD
2zaVVXij/M7w9tpeaMDuX88sswo/yuoFWaf0Qi5NNqN84VU45KeimvysF1pc
sTCIXV6B186tvFDS7IW6e+Il0opWYF6cgK1jUA9Uo0QJhaMrMC73LMcHry6Y
EHdcQ0JxBUo+4rsqq9YFs9+MvW8VXYExoCMjdU0XfGsXOfx8cRm+LrlhmOvS
CSNkZpUYacswsMY9sdaxAzqHSkac5V2Gzv1fTy/YtEEu17MGgcu4r3rv8uaJ
fBs8rSld5j68BB9cV59aO9oK/Samma0LlqDdaNMrLqtWqGh96uuU2RK8QZv4
LXntJ1RXMT8QGYH7KDZpr/OXmqFiiHoPm8si7J08YMIq0AwN7oYfXmOxCG/9
PLsftjRBe24WAQ/5Rejx/t6IwsUmGDBnO/gkZwFmHPl+jvNCI2xF+3/ejFyA
lFTb9h98jbB3+xHpS48XYNWGMeJxUwNs8r2Qeu3YAhxs5fsyptsANz3yz/Iq
xn2MvblAtU495Kg7zJwfzYCxlx9OevDWwy/XbD9uf4z7EMq/XLWhDrZvXevu
sY8B1TkynJK066B5W3mP1+t5OHGOFQnE1MAQNt2NMfbzcJ3ILrun4jVQcEdh
Y9bpeSj+56Ik/W01nFseeZk9TYda7nHeLVFVsHrs7n1KhQ7Ts9W0Q19XwLtX
fl22YqbDCo/ba5hFKuCjtIRtBY00+Es7NPNuZDle70GFyT0a5BsdENKLKIPx
LyoEOE7QoNxX9qpvQmXQTHX0iyIPDZ7w2vt4T3gp5Px5oNYzbg7eE/fo5331
A/Lrravwt5mDz8cSQ9wEfsC5hXS2zL1zeHw0npwO+w4tBvr0+PJmYYvetsT6
0BIoyvCpzU2egft9iu0Dgovhysst+Q/NZ6DWxREpYmMxZH4j0JUsOAOttvG2
2gYVwXS6+5cdDtMwouCq6vlABK07Xw0cl5qG6b4+44XcCNqpXT7qWjMFQ1PN
jhqJQxhWLHGPQ3AK0n6RbCKiBfCHRVXp7pxJKP1Y22ZRJB/eSrx+eNuFSXhJ
MKahfXMefPrQmmc32wTM0aQiw4W+Qsvn4t+n7/2FTpmP5QQ2ZUL5RFcX3Rcj
UHRpT7CGVAbUjt9zfyXmD0TH/jAeKX+BPR8Mt8Sn/4Zr63RLBy6kwf1S7hl+
j35BwWbtEnP5RCjcsPP1Q6N+aGiWH1h5Nh6mCFb8jFTug9ET0iZKNh+hapR9
Ki2yC8qwLTFWU97B+1Wan9L2NcJ7jzVN9l19BcsqH1pb2NXBlVcSC2tiQ6Bm
dzpX/v5K6PWFFlLfHwBNy1M5km98h1tevzQ5ou4L66zuZW8fLoQK9UdD28rc
oPjCGY7qjHT4mL019E/IfSg+Kdbe2voKerSnrXUxNYbRscNccjtfwWnnpbNx
QUYgh5HGbembDoUzZXfYX70PbjTbHS4qLITOUjeNRVPdQBKpuf+h3ndoPYl2
uMv7ArktPdE/btRByeNZxtKhIWDe1Pqd0sYO6Dr6mUEviwH8Sv2lzsFdUNXk
pFzgp3fAv1GvK43shfP1Hcay3h8AZVY0/+xyP7yTzVJiqB4P9l61edibNAR3
HVUo7TX7DBT1dlgfSf0N/RcemibrpIFKU4v4xwnDcOTLN4bDsXTw2TpsjaL/
CIyTviy3cWsGYMvfWL2ZGIei7B6Ban3ZoJImVa9dPQ6dv9fI8tbngKYg/vWP
QyZg+2Ohkm70FWic7nWP8Z6EYVMptAfReUDEfJ15wK9JOJvAeHEiIB84u2Zd
goemoI75CRkelwLQFHrIfuvAFOT42WaQYAJB0VyXgMPeaah8KsgxbzsC22Xf
lOu54b7hvUppzFsENPvXnevln4HHjN1MbV4UAaOzmcmyUrNwpU4gmNX2G2DL
bnuXf2MW/iD1inmnvgGO0E0JrAmz8LlSwNQW+xJwInL9sLj0HNwSsk5r74Pv
IF/TUKmMhQZVLzHYrz4pBSbNmWm+B2lwrbey6i2yDGQmBR3PukWDVTn/3Xzg
Xgbi9rJHR1fRoIHwSPmzp+XA1Etcf28QHTp2tXvlvqgESkcq2sSL6PAYp0DW
d54qcHGwYOPAOB2yAd3BuuAqcGb2vTCH+jwMj648/vtlNRjMNjEoHJmHOdfy
Cb7oWqD27KSXMg8DUhpLL7l46oCFSt5hhOez92YRuzbp1IGXS7b5Ck8Y8FZw
i7F4Ux0oH5vtOcGyABdnzxXsa60H4uz7L8pLL0BjjjE9VaEG8H5AU95SbQEW
S/mNHr3SAIayOG78dl2AvhdLN5/tbADMT7N3js8vQOEc4HittxEMTajHyvIv
wsd1XTxWEk1ARWD00C+lRdg/7BRvY9YEzg/WHWm0XoQJQjmtDgNN4KZh5nl6
0yI84KSoEjDcDDpC/RONxhfh6+CamlCZFrCe/yBdj3UJEkm3LCOtW8B3BYcS
Yv8SLOv8FBo32gIqoxTXhIUsQf0jErP5kz+B1FEt+a+Hl+EDkjftz3wbeMGy
tvKj1jIsTOE/FaHcDmJZQ4hL15Yhi+HmHg27dhB2JnBg4ekyDMuS5Ej62w6e
Fy/dsKtZhhk3VaxsujvAlcT7Oye0VuBks6HEzLcucGrYhuOi6Qrc73415x3R
DZReW2j6267AJ4qW5/UOd4NGeliQ9bMVyOln+ygzqxsIWzILrStdgXKUW9uD
+B6wi9P5fNueVbi3ufHU49JewLXp2ec6ahW27rwY0jLYC2zPak7Gnl2Fzm6t
PQpr+wCpFjHTZrkKv+3qut9D9YGXEy0mb1+uQh3fofdUbh8Y2DPsOj29Cu8A
BrEmuR/ovJ+Tc9AgUHK86NenQQNA5Xr2kMt5Al3MPHnY6ssA4A1n03fUIxBR
ZFOk0TQAzoqqbDpujPu11sJyDv5BcPKJxYDifwRaYjFpDw4fBDoKK1dScX+l
af528W30EAgZu688/opANNvSJ65FQ6AvsOuWxBsCRTtNrLnWPwSeXSi7ZvGB
QLNBgF1a8jcoNzT2s8wk0OuiHpGkj79BDWufn2UjgUZFxY/kpAwDwZX1j+Zb
CBQme6o4vHYYKK+/E+DSTiBq352TTpPDoF1G/YV9H4FCzqJzR5T+AJdK8VMj
4wRSdTY1Kcn8A3S+PqsH60jk3xbtUpc/Atp/cSul7CXRzhCJb8MVo8APRnnK
qJCohuPd2t1/R8H7uRXvqAM4rzyVPOmwYQyoBu4ssT+C+23H7eXrNceAy7rI
u1XqOC9cla+VrR4DIhtWiWOXSaSncKDjVu04eBj0hkfPgES0j7kimRPjgHvW
edLEiEThEqrGy1wTQOGRo6bFVZwf+UDfM60JECLTMrjdCue/xRO/U+onAO1p
QtXbByQC5p8c5q0mgdM2mZYLDiTilrCKEHGcBPptnuYsTiTq75LJo3yxG4L2
XXpMIo9LiUveCZNANHkDzPEgUYVGyhOhv5NA9t1Km3sAvr7dGZ4Hb00Bs118
eUOBJJIavxtn7DwFhmtG804E4+tNUC51858CnpfFhWZC8fVKZq+rTJoCBnLP
sgVx/ukWyPUzGJsC5WVu3l7vcX5cgYHONtNApJJJ99kHnJ9Nr9j5PZoGlEfa
mYA4nBeLZ3Ui/KcBQ0qi1xfnr0AvGb6chGmw7e4MpZtEolzO4LCZoWkw7RC8
QxXnt5I78g+YaNPguaaNrQTOdzUNpZd4mGeAwrUre/pw/vsVtiS4a9sMEBDp
/6LyBedFMVzuJjMg6sjJsrUZJOJ3JZwdbGaArSW6UYMt/ivC0PvRDLBM/XP1
UhaJlD/WbomLnAEl3hmI+koi410Hovt+zgAT63PP7uH8mgrYP+hrzQLWw75f
OXC+zY2J87xuMgu+534sisUuWXPU8r7NLKBFOzp8w/m4tfTe9hD/WXDeUXJj
L87PhFZPfG3ZLFBLtmoxwfmaLd3Bt/vnLIhgcavrxObj47s5NjQL2Pyqeqpx
HpdpPSW3gXkO5Awl9/rj/K5jmp5y8ugcuLA78sYctmGx5osLWnMAj8tNBjjv
W0r+tjU3mQPq3O0TW8pI5DS8ebfbozlwnLgn5YTtpZHFE+g/B7j5mQKbsQOS
tKbfRs4BPvUKYbdynEfveH4p+DoH1OT+O9qEndIgFlJVNgcOV/albKsgUc7e
3LsdP+fAwwq6TS529fy4MmNuDjS0dTBKK/H4cNHP2atEA9Mq/tXr/+3XFagp
ex+jgdebkkJPYXMvKKV36NCAt1oWVYC9054jyc2eBk56/HduBjsndWFHizsN
VCUTFtLVJDo5+vuDTAgN2Kw9B92xTS2K39Zl0IB0owV7CvZ4TKqI5Hca6K9d
e68Z26n7dfiDZhr4r/LnMuPf/s5mX/7KQRqIDvNL3FxDorBLD4JFaTRwhKna
7d9+3bYQc247FjoQ7jnlfRH7c532s+/8dMC0kohssY9wADah7XTwY9c7Ra9/
+2mn5Z7eUqGDvWodneHY+l5Ca5E6Pp6LrEjAHipmcd2oTwfqxkVLOdj2qzPL
ljfowHdNuUMJNqHa55j7kA7SakvU/u2fPX9YQ+fwoQO/4KsW//bnNmfm3b0a
TgdDYppd//bfPk19msqIp4Mgtd3p//bn9imE2azLpQPD5oLhZuxv1u5/DSro
gC86yrMeW+vjnRup7XTgfd/lWQV29y+jQaa/dPBUhpu5CPum+Bmzi4t0IBD7
bH0m9rzh/p74DfNAiH7yXdy//cdwKcPlzfPAU4n+NRR7Ywtvm5bcPKj5Wq7t
hh3NS1x8rzoPbk7/sbmFLX9+rIGuOQ9qj7pv0sPO9Ws/f8ZoHthwFJ0+gH2q
rLQq6vY8gLk1XCLYzWszT08/mgf7Un/eXMLvx+xo7A+15/PgpBarWTv25KMX
x8Oj5sE6BW/5F9hsdKvDFJwH75QVN1j+24/bcyk3uHYeJD1JCj6ILXXnhMrv
nnnQfKc2sxOPH+qP6O7nBAP09lddSsCulmJP6eNmgJ3ympn3sK+YMWSVJRhA
u/fRF2bsex2Nkp1HGUCA76lhBR6/TIJFMbt0GGAiE9b7YwfopYi6mzFAfNut
3RuwE6q9BWXdGUCuJSZsHNdHLzzM/rCEAQa2uByKxb69JOtT2cQAfA5xVbrY
C/sFWcQGGcAnf6H4M663TenTq9+ZF8CdXHZrHVyvGu8/zmxUXwDbeVs4l3A9
c3vZKOpcXAD5S4Yr77BbrivfDrBYANp3VsvHv5Po2s5vQ+weC6BXSNj6Dp4f
nNO725iLFoCS/l9v6SJcr2gToh9cBIpxq1ZZeP65G9u5pKyxCIxCpn+cwD7o
8e7A3cuLQGVD46ohnq9K1Xd/mXywCKwebipwKsD3U6MZ9ydjEcwt6fffxfMf
b5e7f4fCEhgU+K9lLAfPZ4Ua5UJHlgDK7be3wI6K5mHRP7sEtursztLKxvVs
/vZJ080lIN7F+0kgk0Qn/ubaVX9aAtnkjlPWn0l0nzGlD7cugz08OTf24Pm/
bZOp1Dv+FUA8GNDzxevD65RGFCK1AvzPa2n04vXDWF3d0GvvCnB58v2KzzsS
DTxUCLbSWQHVNdHP66Jx/XcsEYrPV8DR96LZe/H6wxQb3pnPvAp2/ZX5afaC
RLIKjcEts6vA3r/1VfM9XM/btpGefwhqoi+PrQSv39N+U4wzk0xU5N3n1X0k
rqfI2THrprXUzPPkW10VBKIv6tza0sdC1XzoVd2ETauLHZT5w0IVRSgGni3H
/cmHaeN9UyyUVYlHKSwl0PT5IO3zJCsl9ubZ3YQSAo2/q9/nKsFKFekKC4cX
EmjojBY5eJWVauVJZ+5OJ1BL5NmwpH5Wao2Z4c9NuP/JPHQKHRpYR2Xm7Bhw
fE0grV8e4QV/11GeNXTT3kjc7/gW2YGZdRSPtGJSUgSBtrYflDrOtJ5KYWMN
0cD9VMBDeV8N8fXUz9YD5OtgAt3K5NW7bLie0vuaWxHhS6Btu7p+329aTx1R
7NnHcCBQ4FY7rvQSNiqgpyvoDraNSuu+lio2Ssxe4dbwQwJpaB4xXmhio7QU
HUPbHhBo7X225GODbNQT85SvRfcI9LA8VqOReQN1bWQ7ezzu90zvNHrOntxA
6b2RsKu3IpBi4d6lfeUbKOTTf9DegEB1l+nDedXsVFLfyhlObI2jGncuNLNT
1wXeZMZfIdC3HW/o453slG7qjcC+ywTKoh9j2TrKTm2QDzK7oI/7v9Dn27zZ
OCg5qkPq7AUCXa+XMtZT56ACSmNWHXF/unJKr3EUcVBZmiMThScIJLc/rWBL
BidlG6RywRZb0unKbEAeJ+UTLrsshr25cM3Otd84qTcqExvdjhOI7cTFVyP1
nJT7d9sLp48R6M/5RbvsCU5KLnff6C9AoLjraju0d3JRvX9y9dUPEUjsZVuQ
RywXte3j8kSuEoHWLxIZ905xUxt+GLvdxZbWtb7voslNOYaf11bAPpbYuN9P
i5vSdy16F7ubQM4GcQXR+tzU0kIzz3NFPF7yzpRW3uCmRMPqimwVCNTgHNYu
4cNNZXZeFDWSxfe/spOsKeem9u9y39iwlUAKTJfOSZ/hoXYh73evscO/ZaG/
53io221HDK5jr/Xk35Omw0NBH9GjyxIEamNtEVC9wkN1SF7ul8X24LjQp23F
Q3UZSek/EyNQh6Du3UdPeag8Efj3tgiBvHedj2j6xkP1GOzrDuUnUL+h+pCb
Ki+1yqlna4E93pT3JJzipZp/v5ZUxmZoKgp9PsFLbXLeuNi0iUDch4U0uzR5
qcFTmrr82Ee2/E1TMeKlrq6UeLzdSKDIruePRh/xUi+1XPkquXF+MG7huwh5
qYwHUb5PNhCo1MTiuMyxjdR+X/qtQiYCHcraEuW0j49KLvbZlUlbhXedY36t
kd5EHYAK3S3Dq7BnRGe8WYafGvOUFQ7swnkoKYqmKyJALRh1JHc0rMI1AoIl
m7cJUt8XteqjylfhzKShs5CUEHWl77QmvWgV/ieqqvRtkzB1MMjD+0XuKpSY
PZWcJbyZmhG/6micsQpNt0xKXeQUobbKF6X2p6xC8ywzn53LItTL7yocbvGr
MJzOlK5BiFKbdrc8nnu/Co38D7dumhalWFQtxPux5cI6Xc7SRKnUiL7yGuyF
t04ynguiFJ954N5P2K++fHWcZRKjfN5cvGGA3dCuvKVxoxilZfxN7du7VXhS
RsEsQFmMev7ZPfdV7CpU+CE6yuYgRpVe89H2wl6qLQg59kiMYp2enbDHrmwz
POzoKkZ5fh49dh77xljE8z8+YlT/zmGKBTuWT2B3WYQYdbT2Svi9mFUocI3r
vmc+Pp9C8ftr2EO3UkQLkBjFmXQmWxs74/7Z0tkSMeoJX8aUfMy//OgnaF4t
RoVzmecNRa9C/zTWvGPdYpRLu8VqE/aVvLhrjv1i1MjgdY1v2DLf1djTh8Qo
+VqDubfYP1rdjSQmxChnZbULz7FD+reyXJ4Ro/aNbcl3xr42WpQSQBejXub2
ydzEVqKZXipbFKParvpHXcb+/+/LiFP/A/wvNz0=
        "]]},
      Annotation[#, "Charting`Private`Tag$12924#2"]& ]}, {}}, 
   {AbsoluteThickness[1], AbsoluteDashing[{2, 2}], 
    LineBox[{{1.96, -8}, {1.96, 8}}], LineBox[{{-1.96, -8}, {-1.96, 8}}]}},
  AspectRatio->1,
  AxesLabel->{None, None},
  AxesOrigin->{0., 0.},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  LabelStyle->{FontFamily -> "Cmr10", FontSize -> 15},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "GridLinesInFront" -> 
    True},
  PlotRange->{{-5, 5}, {-4, 8}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.672588178278575*^9, 3.672588195650312*^9}, 
   3.672588237407487*^9, {3.672588341403886*^9, 3.6725883915058956`*^9}, 
   3.672589211442881*^9, {3.6725893634730825`*^9, 3.672589381927928*^9}, 
   3.672589422108946*^9, {3.672589458446579*^9, 3.6725895029930334`*^9}, 
   3.672589638716604*^9, {3.67258982248798*^9, 3.672589836433374*^9}, {
   3.6725900483465633`*^9, 3.6725900716008883`*^9}, {3.672590709290651*^9, 
   3.6725907138061028`*^9}, 3.6725907740921307`*^9, {3.6725909310928288`*^9, 
   3.6725909573894587`*^9}, 3.672591327985514*^9, 3.6725916979605083`*^9, {
   3.672592036854394*^9, 3.6725920594306517`*^9}, 3.6725921952472315`*^9, 
   3.672592243141021*^9, 3.673352443526588*^9, 3.9302230357591844`*^9},
 CellLabel->"Out[14]=",ExpressionUUID->"ec224fda-7e5b-48ff-a8c7-8140db36f8de"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"p0", "=", 
     RowBox[{"ContourPlot", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", 
        RowBox[{"x1", ",", "0", ",", "8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x2", ",", 
         RowBox[{
          RowBox[{"-", "Pi"}], "/", "2"}], ",", 
         RowBox[{"Pi", "/", "2"}]}], "}"}], ",", 
       RowBox[{"Contours", "\[Rule]", 
        RowBox[{"{", "0.05", "}"}]}], ",", 
       RowBox[{"ContourStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"AbsoluteThickness", "[", "1.8", "]"}], ",", "Black"}], 
         "}"}]}], ",", 
       RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Speed\>\""}], ",", 
       RowBox[{"MaxRecursion", "\[Rule]", "8"}], ",", 
       RowBox[{"ContourShading", "\[Rule]", 
        RowBox[{"{", "None", "}"}]}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"FontFamily", "\[Rule]", "\"\<Cmr10\>\""}], ",", 
          RowBox[{"FontSize", "\[Rule]", "15"}]}], "}"}]}]}], "]"}]}], ";", 
    RowBox[{"pAR1", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"Piecewise", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ArcSin", "[", 
             RowBox[{
              RowBox[{"1.96", "/", "rx"}], "+", ".001"}], "]"}], ",", 
            RowBox[{"rx", ">", "1.96"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Pi", "/", "2"}], ",", "True"}], "}"}]}], "}"}], "]"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"rx", ",", ".01", ",", "8"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"Black", ",", 
           RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", 
           RowBox[{"AbsoluteDashing", "[", 
            RowBox[{"{", 
             RowBox[{"2", ",", "2"}], "}"}], "]"}]}], "}"}], "}"}]}]}], 
      "]"}]}]}], "\n", 
   RowBox[{"pAR2", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"Piecewise", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ArcSin", "[", 
             RowBox[{
              RowBox[{"1.96", "/", "rx"}], "+", ".001"}], "]"}], ",", 
            RowBox[{"rx", ">", "1.96"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Pi", "/", "2"}], ",", "True"}], "}"}]}], "}"}], "]"}]}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"rx", ",", ".01", ",", "8"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"Black", ",", 
          RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", 
          RowBox[{"AbsoluteDashing", "[", 
           RowBox[{"{", 
            RowBox[{"2", ",", "2"}], "}"}], "]"}]}], "}"}], "}"}]}]}], 
     "]"}]}], "\n", 
   RowBox[{"p1", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"pf", "[", "rx", "]"}], ",", 
        RowBox[{"-", 
         RowBox[{"pf", "[", "rx", "]"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"rx", ",", ".01", ",", "cvs"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"AbsoluteThickness", "[", "0.4", "]"}], ",", "Black"}], 
         "}"}], "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"p2", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"pf", "[", "rx", "]"}], ",", 
        RowBox[{"-", 
         RowBox[{"pf", "[", "rx", "]"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"rx", ",", "cvs", ",", "8"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"AbsoluteThickness", "[", "1.2", "]"}], ",", "Black"}], 
         "}"}], "}"}]}]}], "]"}]}], "\n", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"pCI", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"p0", ",", "pAR1", ",", "pAR2", ",", "p1", ",", "p2", ",", 
      RowBox[{"Graphics", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"AbsoluteThickness", "[", "1.2", "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"cvs", ",", 
              RowBox[{
               RowBox[{"-", "Pi"}], "/", "2"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"cvs", ",", 
              RowBox[{"anglecv", "-", 
               RowBox[{"Pi", "/", "2"}]}]}], "}"}]}], "}"}], "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"cvs", ",", 
              RowBox[{"Pi", "/", "2"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"cvs", ",", 
              RowBox[{
               RowBox[{"-", "anglecv"}], "+", 
               RowBox[{"Pi", "/", "2"}]}]}], "}"}]}], "}"}], "]"}]}], "}"}], 
       "]"}], ",", 
      RowBox[{"Graphics", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"AbsoluteThickness", "[", "1.2", "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", 
              RowBox[{
               RowBox[{"-", "Pi"}], "/", "2"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"cvs", ",", 
              RowBox[{
               RowBox[{"-", "Pi"}], "/", "2"}]}], "}"}]}], "}"}], "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", 
              RowBox[{"Pi", "/", "2"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"cvs", ",", 
              RowBox[{"Pi", "/", "2"}]}], "}"}]}], "}"}], "]"}]}], "}"}], 
       "]"}], ",", 
      RowBox[{"FrameTicks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "Pi"}], "/", "2"}], ",", 
             RowBox[{
              RowBox[{"-", "Pi"}], "/", "4"}], ",", "0", ",", 
             RowBox[{"Pi", "/", "4"}], ",", 
             RowBox[{"Pi", "/", "2"}]}], "}"}], ",", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"Automatic", ",", "None"}], "}"}]}], "}"}]}]}], "]"}]}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.6725858360283737`*^9, 3.672585841123883*^9}, {
   3.6725859950062695`*^9, 3.6725860679535637`*^9}, {3.6725861188196497`*^9, 
   3.6725861558603535`*^9}, {3.6725872421399703`*^9, 
   3.6725874686916237`*^9}, {3.672587519254679*^9, 3.672587521235877*^9}, {
   3.672587642105963*^9, 3.672587643145067*^9}, {3.6725878237301235`*^9, 
   3.672587872016952*^9}, {3.6725879535901084`*^9, 3.672588133914139*^9}, 
   3.6725881924189887`*^9, 3.672590138743602*^9, {3.67259025303803*^9, 
   3.6725903748602114`*^9}, {3.6725904074874735`*^9, 
   3.6725904329100156`*^9}, {3.6725904750412283`*^9, 
   3.6725904911838427`*^9}, {3.6725905323879623`*^9, 3.672590609060629*^9}, {
   3.6725911297366915`*^9, 3.6725911402957473`*^9}, {3.6725916293066435`*^9, 
   3.672591643963109*^9}, {3.6725917313588476`*^9, 3.672591748623574*^9}, {
   3.6725917850252137`*^9, 3.6725917851352243`*^9}, {3.6733523166355877`*^9, 
   3.673352405216588*^9}, 3.673352557640588*^9, {3.673352589478588*^9, 
   3.673352621636588*^9}, {3.6733526821135883`*^9, 3.673352782696588*^9}},
 CellLabel->"In[20]:=",ExpressionUUID->"11cb64dd-8a4c-48ab-9382-e024a5218c53"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1], Opacity[1.], 
      AbsoluteDashing[{2, 2}], 
      LineBox[{{0.01000016306122449, 1.5707963267948966`}, {
       0.08841658303072619, 1.5707963267948966`}, {0.16683300300022788`, 
       1.5707963267948966`}, {0.3368577731128146, 1.5707963267948966`}, {
       0.4956152897255153, 1.5707963267948966`}, {0.6512586140628197, 
       1.5707963267948966`}, {0.8200938685737074, 1.5707963267948966`}, {
       0.9776618695847091, 1.5707963267948966`}, {1.1484218007692941`, 
       1.5707963267948966`}, {1.316067539678483, 1.5707963267948966`}, {
       1.4724460250877855`, 1.5707963267948966`}, {1.6420164406706717`, 
       1.5707963267948966`}, {1.8003196027536716`, 1.5707963267948966`}, {
       1.8779140876574734`, 1.5707963267948966`}, {1.9555085725612753`, 
       1.5707963267948966`}, {1.9581395241234814`, 1.5707963267948966`}, {
       1.959414130329309, 1.5707963267948966`}}], LineBox[CompressedData["
1:eJwVlHk41AsfxX9mzHSVyjL2+D16cVVEtlLy/VqKKEkhQi6lxEVZrtKVJaQk
WhBSXonHUrbKvhZpm7EnJUrKWGcYRMzr/eM8549zPs/57yi6+dqcpBAEcWlF
//faROP2TB8+DOupOwQcmgf6Z3mX/gA+ZNpShS/JzoN27FuF7Et8SM/M0ZBi
zYGrbsgXr6t8UHjtUBR0aw6uD256oHWHDw/XXRmjHZ+DyusfXH/d50O9yXij
muYc/NCPUazP40Pdfzxcg2hzwBjW/Rr9lA9Ka11S5z/Pgo/hLXfGGz4Yt8mQ
jkmzkMY2Uurr4oNyxZdp/8BZeJU0NZQ5wIeUu5+rFe1mQXHygIfGLB929/rs
/0duFnIOhIqHEAQe3Osd3snnQU1Wl38/jcB4+2sGat95wD54WSdbhMAwjn6r
XwkPTHMHn2qpEOgoVC4dZMsDx+UdkklbCAxQcZApBh6cPZIQ9EuTQIOZXaa+
m3mQQcD2+l0ELrjcCLYV4MH80fTyA4cI1Mo491G8bAbWPZmWLrYjMNso7Gt+
5gwo0yzPM5wI1OFxRpNvzIBN8S/9Pg8CO3ocup28Z6BAyL7q9EUChZQp6Yab
ZsC1UrQ2ModAW8sPGZseT0OQiKfCj4IV3nbmdf79abjuUR9qUUJgQ3L638cS
p6FSzBdEawhML03L3B04DQyvt/UZ7QT+M9K2Y9RwGl7JxTRVLBG4mf63BLWX
C/avKrrrKQLYltZn8egdF4YDxkZaVgng4li3nXsjF2jvD4l0iwpg2NzZZtUC
LhiHbXDmKq/015b1todxoWaoeHazlQCyTF/2wFYulBR+2pSeIYBKvdw8IpkD
Ro7rd2dlreSyISMS8Rxg0Y2t83IFMFgwuE8/igOTx3OCyksEMKDKlFLozwE1
sXNNnc0CeF5DqmbnIQ48ClrlvHZSAP/78H3x63UcSAOthFCgoFJluNbDm1MQ
Fj5QxjGlYF7VrHX61Sk40RTfe8KCglyuEfd+xBRsNRvdaGlLwViKulbruSmo
t3r4VMqLgkJNCcv3D0/BkLNkX1ESBdt/zkabSE2B2sUF5W/jFNRYQ71gZjkJ
IrW5FnbTFNzXMETm7J4EHt/Ot3WeggOK8hulNCehNrK0/AmViqw283t/SkyC
9TVvy4syVFSycDegD0xAYGq/n8QeKopzZT1SgyegtryxyiydintVQyp2lo3D
yapw58xMKt5+vTE5NXcchGuRv/CIio+TtrrR742DY1Ot8eNiKl5X9P9LIHoc
eO8qWxktVIx8bngx4ug4qH0r6RnkrPAJnNZ7/DG4uzZrOsRMEMMkd2jl245B
gFvkliKuII5m6eu5yY/C7Sr5sMI5QTw3ycYWxiiUMso7834L4nOyZUlLeBS4
zWP/ZtNp2OJQcUphkQ1nt9ixUmVpqChhwjPpZYPPjGpglDENqRFHiMYkNnhG
v691vElDRpmhsJUkG1zyZGxoWnQ8Gmwsvqw8Ah0pGuU+2+m4P0j9tI7CCJjH
7FH4YEDHrbmOZ/wkR0DrxFl2nhkdFxR1HH7RR4Cm0Bph7UzH9WwpKaufP6Eg
Mbg07Qods7wkpn/n/4TF4B6G1hc6CtVpdxtt/wkpZnd6XOJWobDL1L9yTj+A
Hjksns38A1si9SufTXyHF+LyTybVV2OjioL4YtIQMLoi43uj1mB40oHCG77f
IEWnXqmoWRirK6S+xV74Ct4jgzLXNq7DucMnw2PiBiHAoPelzan1aK3gfUfv
xQCsciX6PtmIYF5Uke4x0QG4+DY64iZfBI8Mb9e5VN8Pa/4Ijqp9IIrrTqi4
JCd+BuOJvufeB8XQrdDrY5r7J2gcs49jL4hhXvWRNddt+sCp0rC6P1UcRaZC
m5w8PkKGVoqcrTkDx5uURTSDe2HhvFO3EZuBpaF/5c7nfoD7vTu0l69IoHjz
4NFkdg+MfYupM9CVxKgtX1LHVXvgcI1RDqdLEoPe+VoaXuoGNyOfWtXLUijZ
Zpq9rb0Lrt2mbetWkcaIraeTuPpdsMwv23O4WRojnRutygo6QVqyJ9bGXwY3
/IpLrpHrhP2L7pteMWTR8iV7ITGtA1Svuc/XNclihHRiY4dUB1hph3jG+Mqh
T8mLVZvvtUN83pLuy/UbkB9NdzHWbIegt9xtUTUbcIkadauhrg2Ca2xiq47L
Y4SgIT31WBs0Nb+OaFiWR+0eTknhEgueXXiavy9fAUMXnZQN0lnQtLRa03w/
ie02Jxn6e1hgLUyulzpIYkqceVO1CQv6ZbUnvh8iMT0ntxyNWbCw/VhBpD2J
e80SgvYBCzTP5avWuZH4Rr/TwEWfBenDlop650n0esEfvK3OgkBmnJjSIxLZ
wxN0PUkWUPofcLi5JDKEUo83MliQMFbGasgnMdbM7reVOGvlnz/HHy8mse7y
MwFPERZ8NVFfk1ZNYmMIfeeD1SywKn9HFesgMTh8+YHeMhM+NQ9+HegisSKl
v9F+kQmeXbyGJx9I/Jhx9cz5eSZc5sqHHegn0fVNiUUtlwmVaj6/r4yQqDhp
YGH1gwnmuyL67MdI9PMITPIfYkLXvqRKlcmV/Z7Dp+4OMmHKozb4xQyJpUV+
ScN9TAgNbLe/NUfiQUOPmbW9TBC+PKzntkBil6hft243E1JvLkhsWyKR98XT
wKWDCX9mruPx+ST2ntFQiWEx4X9BbMZY
       "]]},
     Annotation[#, "Charting`Private`Tag$15668#1"]& ], {}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0.01, 8}, {0., 1.5707963267948966`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.67258613152492*^9, 3.672586156236391*^9}, {
   3.672587342006956*^9, 3.672587469018656*^9}, 3.6725875225130053`*^9, 
   3.6725876435541077`*^9, {3.6725878275775084`*^9, 3.672587872619012*^9}, {
   3.672588000937843*^9, 3.672588019937742*^9}, {3.672588063829131*^9, 
   3.67258807181593*^9}, {3.6725881164553933`*^9, 3.672588134516199*^9}, {
   3.672590356985424*^9, 3.672590375378263*^9}, 3.67259043415414*^9, 
   3.6725905193036537`*^9, 3.6725905717158947`*^9, 3.672590610150738*^9, 
   3.6725907164073625`*^9, 3.6725907775024714`*^9, 3.6725909619219117`*^9, 
   3.672591144176135*^9, 3.6725913307117867`*^9, 3.6725917033660483`*^9, {
   3.672591733529064*^9, 3.672591749722684*^9}, 3.6725917857442856`*^9, {
   3.6725920370794163`*^9, 3.672592062197928*^9}, 3.6725922082955365`*^9, 
   3.6725922446601725`*^9, 3.673352413515588*^9, 3.6733524469555883`*^9, 
   3.673352562784588*^9, {3.673352593263588*^9, 3.673352622340588*^9}, {
   3.673352723402588*^9, 3.673352783342588*^9}, {3.930223049246352*^9, 
   3.9302230554104166`*^9}},
 CellLabel->"Out[20]=",ExpressionUUID->"a846ad24-6d9a-453c-979e-291db66c1b54"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1], Opacity[1.], 
      AbsoluteDashing[{2, 2}], 
      LineBox[{{0.01000016306122449, -1.5707963267948966`}, {
       0.08841658303072619, -1.5707963267948966`}, {
       0.16683300300022788`, -1.5707963267948966`}, {
       0.3368577731128146, -1.5707963267948966`}, {
       0.4956152897255153, -1.5707963267948966`}, {
       0.6512586140628197, -1.5707963267948966`}, {
       0.8200938685737074, -1.5707963267948966`}, {
       0.9776618695847091, -1.5707963267948966`}, {
       1.1484218007692941`, -1.5707963267948966`}, {
       1.316067539678483, -1.5707963267948966`}, {
       1.4724460250877855`, -1.5707963267948966`}, {
       1.6420164406706717`, -1.5707963267948966`}, {
       1.8003196027536716`, -1.5707963267948966`}, {
       1.8779140876574734`, -1.5707963267948966`}, {
       1.9555085725612753`, -1.5707963267948966`}, {
       1.9581395241234814`, -1.5707963267948966`}, {
       1.959414130329309, -1.5707963267948966`}}], LineBox[CompressedData["
1:eJwVlHk41AsfxX9mmK5SWcYev0cvrorIVkrmaymiJIUIuZQSF2W5SleWkJJo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       "]]},
     Annotation[#, "Charting`Private`Tag$15720#1"]& ], {}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0.01, 8}, {-1.5707963267948966`, 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.67258613152492*^9, 3.672586156236391*^9}, {
   3.672587342006956*^9, 3.672587469018656*^9}, 3.6725875225130053`*^9, 
   3.6725876435541077`*^9, {3.6725878275775084`*^9, 3.672587872619012*^9}, {
   3.672588000937843*^9, 3.672588019937742*^9}, {3.672588063829131*^9, 
   3.67258807181593*^9}, {3.6725881164553933`*^9, 3.672588134516199*^9}, {
   3.672590356985424*^9, 3.672590375378263*^9}, 3.67259043415414*^9, 
   3.6725905193036537`*^9, 3.6725905717158947`*^9, 3.672590610150738*^9, 
   3.6725907164073625`*^9, 3.6725907775024714`*^9, 3.6725909619219117`*^9, 
   3.672591144176135*^9, 3.6725913307117867`*^9, 3.6725917033660483`*^9, {
   3.672591733529064*^9, 3.672591749722684*^9}, 3.6725917857442856`*^9, {
   3.6725920370794163`*^9, 3.672592062197928*^9}, 3.6725922082955365`*^9, 
   3.6725922446601725`*^9, 3.673352413515588*^9, 3.6733524469555883`*^9, 
   3.673352562784588*^9, {3.673352593263588*^9, 3.673352622340588*^9}, {
   3.673352723402588*^9, 3.673352783342588*^9}, {3.930223049246352*^9, 
   3.9302230554966497`*^9}},
 CellLabel->"Out[21]=",ExpressionUUID->"777ca3fb-16d0-4d0b-9097-809964ea52f1"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[0.4], Opacity[1.], 
      LineBox[CompressedData["
1:eJwV1Xk8VVsbB/BDhRRJUV0aKK4rYyXS8NNV3qJU3F5UMvNyqxOZEm46CQ2I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       "]]},
     Annotation[#, "Charting`Private`Tag$15774#1"]& ], 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[0.4], Opacity[1.], 
      LineBox[CompressedData["
1:eJwV1Xk4VVsbAPBDhRRJUV1UiOvKWGRoeOtWvqIQtw9NMn/cdBwz4aaTUBky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       "]]},
     Annotation[#, "Charting`Private`Tag$15774#2"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0.01, 1.7482897725800823`}, {-1.492254550857734, 
   1.492254550857734}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.67258613152492*^9, 3.672586156236391*^9}, {
   3.672587342006956*^9, 3.672587469018656*^9}, 3.6725875225130053`*^9, 
   3.6725876435541077`*^9, {3.6725878275775084`*^9, 3.672587872619012*^9}, {
   3.672588000937843*^9, 3.672588019937742*^9}, {3.672588063829131*^9, 
   3.67258807181593*^9}, {3.6725881164553933`*^9, 3.672588134516199*^9}, {
   3.672590356985424*^9, 3.672590375378263*^9}, 3.67259043415414*^9, 
   3.6725905193036537`*^9, 3.6725905717158947`*^9, 3.672590610150738*^9, 
   3.6725907164073625`*^9, 3.6725907775024714`*^9, 3.6725909619219117`*^9, 
   3.672591144176135*^9, 3.6725913307117867`*^9, 3.6725917033660483`*^9, {
   3.672591733529064*^9, 3.672591749722684*^9}, 3.6725917857442856`*^9, {
   3.6725920370794163`*^9, 3.672592062197928*^9}, 3.6725922082955365`*^9, 
   3.6725922446601725`*^9, 3.673352413515588*^9, 3.6733524469555883`*^9, 
   3.673352562784588*^9, {3.673352593263588*^9, 3.673352622340588*^9}, {
   3.673352723402588*^9, 3.673352783342588*^9}, {3.930223049246352*^9, 
   3.9302230555411615`*^9}},
 CellLabel->"Out[22]=",ExpressionUUID->"7ee9cff8-95f2-46db-b7a0-c959836df8e9"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1.2], Opacity[1.], 
      LineBox[CompressedData["
1:eJwVkGdUUwcYhm/YRCCElQSFy3LhoBgV6RG/j32kThSNVkABBWQqiiJyFKEW
Vxtxi4oswVTBugooiOA6InLDCiOykVRl36CMhNIf73nP++N5fzyWAVHeu1UI
gvCfzv8tcUqtU/6YgMEtdrIS01GweRy6vYmYBHrzjltGvFGItnVuf6Q1Cfkd
0s5QzigwOYNfQ7iTIHQ8McUyGoWVg2tVax0mQTWvN9BLdxQyM7WX5MZOgn9u
WEnslBzCNRP/XE9PQplVWnd2pxwY4iiv2wMKmCKTHVnZcrjhc7rP+ocCHm3f
GiDOkMPy5mxhLqGEwNTv0efTp/mupoZ8thLulDMdZ6TJoUHuGljCV8Kce5Ee
PeflIDLlHm0+pIQrZ/ZK7I/JwTuo7L4RMQXqBbfjLQVyEMenpLhpEbj472vG
aqpykGbnWq7SIdDYWlUZQMhBVvWm2EGfQC0ru5IXChoIC/U+Wy6BeMD4+f4f
NCx+lbiRPY/ANXOYmaV9NJzWiTdt9SRwRZb2qj4JDW43I+4d+p3AE65XbW6J
aCgs9aZEGgzMCo5xmbeahg3b/GKETAYOhF5P1vCgoXck1CRWj4F8od+5Thca
TOYn7nA2YeB+ts3whZU0HLhQIJPMZuDToHA1qR0NP4XoMNTdGegc5DWLMKEh
j/3G3j+JgcXrLFJutI/AlSDHC4aECuoaF39xjhqBJXWJynQ9VYzLi/7Q4TsM
gSOu68xnqGHuXM+MMfchWC8N9iibpY53tmkOh+sOAn9eXlHQfA1092iP13/X
B/etA9gT1pr4sEDIS3jzFbpkCewnfC20lWx2Ma39Fwp8DUd32muj/8msyoMr
ZBCz7LUPy5aJ9i3p+djwGYYbGn07HGbguLR0bvJvPaA5b49XDl8HNa2aDeP2
dUOji0/bWTddjFdOvrAI7YKMsp0DsRv0cIGXVjcvqROI/p4uby8WrqTLFx0v
74Bz+/fg3YX6eEqkuFWh3gE9r00YVn/po8qWSr2s3e0wU/n90sKlbFSXr3Of
OtcGVcHBIYXFbHw/v398a3QreN01XOS0wgDDNq17/ynuE+RUD77eVGaAl0PE
NkWJUqisYm4MBEOMjxoq6rzbAhGKhzz6mSGm73RIOdHVDN/YZ5+auBrhHy8u
l6bymmG5MsN9yUsjjL2ql7QjpAn8qmV5bauNcS3rmLfvo0ZQqSlZrUcZ47vn
D1UaZzTCvnvV0mVrTZCXnqTZcUgCpWEGbgN1Jjg+22Llw7YGaFBJvZmxiYPd
t102vhc0wN7K9KX11RwU5Qz9+qy5HqSHW9Ovb+GiQjuyyldQDzzlNoWgjotv
eX2fNnXXwdIQDbu7O3gYLkoTLwmvA1PRgPdwCw9dniweGyfqIN4s+PFzgSle
VInP5N+oheKDrC/cdlMsrThmGMmvhVc5NDvSbyY+OHr8enZ9DdwrZur59M5E
D/c5MZwDNaDPKPAsiZiFrhlGn+25NQCkMMb86ywsYue1Fr0WwxqrzBh2jBma
i7y17kSJwUYxuFsxZIZPQ8MWopUYDmt/vLQ30hy3uV0miCYKROMt10Ll5sgI
0N6w/iwFdyrmCHfFkDgStFrH0ZMCWlahffEgiWes0yu1PShw0duV9OYQiVsD
uIXNbhS0CtJiFxwlsWT8F26CCwWcfpavPJlE5sdLdIUTBSncsfmnLpNIFOUY
bl9Kwd6IyooHRSSeZppm5lpSUJga4tT1jMRdni1DCRYUaBSq/2NcSuL6rCMR
m0kKMlVQdKScREH1AhnDjIKWK4+FbpUkZl3FL35cCtaU3/RtlJK4/Z2EY8mi
4HrvzxJmG4kbw0osxnUpkOk0bnDqIFHytmtzrQ4FyVsN3DJ7SNzdVLnqJJOC
599O2ob3k+h/fozTr04B08Am+9bg9D+/Pu6dGgUCh5dm4mESrXqzNLJUp30k
Tugv/05ixv2R2wLGtI/cq6dDxkg8t2VXPp+gQPhhmVraBImsuOVVZspqaB2q
SahSTG8fuwt1E9WwiBP9fWqKRIbkWv6ZsWr4D9i2vTg=
       "]]},
     Annotation[#, "Charting`Private`Tag$15829#1"]& ], 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1.2], Opacity[1.], 
      LineBox[CompressedData["
1:eJwVkGdUUwcYhm/YRCCElQSFy6pVHBSjIj1iPplH6kTRaAUUUECmoigiRxFq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       "]]},
     Annotation[#, "Charting`Private`Tag$15829#2"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{1.748289772580086, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{1.7482897725800823`, 8}, {-1.3815287656520319`, 
    1.3815287656520319`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.67258613152492*^9, 3.672586156236391*^9}, {
   3.672587342006956*^9, 3.672587469018656*^9}, 3.6725875225130053`*^9, 
   3.6725876435541077`*^9, {3.6725878275775084`*^9, 3.672587872619012*^9}, {
   3.672588000937843*^9, 3.672588019937742*^9}, {3.672588063829131*^9, 
   3.67258807181593*^9}, {3.6725881164553933`*^9, 3.672588134516199*^9}, {
   3.672590356985424*^9, 3.672590375378263*^9}, 3.67259043415414*^9, 
   3.6725905193036537`*^9, 3.6725905717158947`*^9, 3.672590610150738*^9, 
   3.6725907164073625`*^9, 3.6725907775024714`*^9, 3.6725909619219117`*^9, 
   3.672591144176135*^9, 3.6725913307117867`*^9, 3.6725917033660483`*^9, {
   3.672591733529064*^9, 3.672591749722684*^9}, 3.6725917857442856`*^9, {
   3.6725920370794163`*^9, 3.672592062197928*^9}, 3.6725922082955365`*^9, 
   3.6725922446601725`*^9, 3.673352413515588*^9, 3.6733524469555883`*^9, 
   3.673352562784588*^9, {3.673352593263588*^9, 3.673352622340588*^9}, {
   3.673352723402588*^9, 3.673352783342588*^9}, {3.930223049246352*^9, 
   3.93022305558704*^9}},
 CellLabel->"Out[23]=",ExpressionUUID->"d779a4a2-4fae-492a-98c8-d3889318cfe1"],

Cell[BoxData[
 GraphicsBox[{{GraphicsComplexBox[CompressedData["
1:eJxllT9IVWEYhz+CWjpLg3EH8SjNDg2B1fCdwgiCFunPEDVENglSQpNTS3+4
XGtoEyFoiJDmAuEjiHIQbGiMCAwacilL76UzpOec55X3dy6KPD73fc9z5J7P
sZuzU9MHQgjvd7/3fvLqjE9e+jc2SMMf7+x+bUbPpfHl6nWw8D4zvlv94ojx
ler9Q8anehsTvY2O8Ug1P2xc14wKh7B97fGZE90t6/NcGtPnfWZMH0wfTB9M
H0yf5xBeDj2//nXzp/V5Lo3p8z4zpg+mD6YPpg+mz3MIt+bGJ6befbM+z6Ux
fd5nxvTB9MH0wfTB9HkO4f7kjwudqx+sz3NpTJ/3mTF9MH0wfTB9MH2eQ+jW
HOnzXBrT531mTB9MH0wfTB9Mn+cQbtd/T+vzXBrT531mTB9MH0wfTB9Mn+cQ
XtWfR+vzXBrT531mTB9MH0wfTB9Mn+cQdurn2fo8l8b0eZ8Z0wfTB9MH0wfT
59nOZ+vzbOez9Xlv53OU8znK+RzlfI5yPluf3/8lPqg+j9v2vMALe+smRgrv
R42Zf1iz3S/MvLJen/8X4pN462df7dfipzfP1h+t7KTV6nbzAhYfxVuvzvvr
r7Wuz7z4JD7J/ij7m/mV+Of35tOzs/30fe/2e3kBi4/irV/nff9Kq5958Ul8
kv1R9jfzy/HQk87W0mq/Ob/zAhYfxVu/zvv+5VY/8+KT+CT7o+xv5hfjwo3X
xy7+7aeT1fOTF7D4KN76dd73L7b6mRefxCfZH2V/M9+Nn88NTr843FzvV144
3vdRvPXrvO/vtvrdvn2fxCfZH2V/Mz8f770dWV0/OkjV7fXzAhYfxVu/zvv+
+VY/8+KT+CT7o+xv5mfi+bnjvenhQaqP87yAxUfx1q/zvn+m1c+8+CQ+yf4o
++N/igoNgQ==
     "], {}], {}}, {{{}, {}, 
     TagBox[
      {GrayLevel[0], AbsoluteThickness[1], Opacity[1.], 
       AbsoluteDashing[{2, 2}], 
       LineBox[{{0.01000016306122449, 1.5707963267948966`}, {
        0.08841658303072619, 1.5707963267948966`}, {0.16683300300022788`, 
        1.5707963267948966`}, {0.3368577731128146, 1.5707963267948966`}, {
        0.4956152897255153, 1.5707963267948966`}, {0.6512586140628197, 
        1.5707963267948966`}, {0.8200938685737074, 1.5707963267948966`}, {
        0.9776618695847091, 1.5707963267948966`}, {1.1484218007692941`, 
        1.5707963267948966`}, {1.316067539678483, 1.5707963267948966`}, {
        1.4724460250877855`, 1.5707963267948966`}, {1.6420164406706717`, 
        1.5707963267948966`}, {1.8003196027536716`, 1.5707963267948966`}, {
        1.8779140876574734`, 1.5707963267948966`}, {1.9555085725612753`, 
        1.5707963267948966`}, {1.9581395241234814`, 1.5707963267948966`}, {
        1.959414130329309, 1.5707963267948966`}}], LineBox[CompressedData["
1:eJwVlHk41AsfxX9mzHSVyjL2+D16cVVEtlLy/VqKKEkhQi6lxEVZrtKVJaQk
WhBSXonHUrbKvhZpm7EnJUrKWGcYRMzr/eM8549zPs/57yi6+dqcpBAEcWlF
//faROP2TB8+DOupOwQcmgf6Z3mX/gA+ZNpShS/JzoN27FuF7Et8SM/M0ZBi
zYGrbsgXr6t8UHjtUBR0aw6uD256oHWHDw/XXRmjHZ+DyusfXH/d50O9yXij
muYc/NCPUazP40Pdfzxcg2hzwBjW/Rr9lA9Ka11S5z/Pgo/hLXfGGz4Yt8mQ
jkmzkMY2Uurr4oNyxZdp/8BZeJU0NZQ5wIeUu5+rFe1mQXHygIfGLB929/rs
/0duFnIOhIqHEAQe3Osd3snnQU1Wl38/jcB4+2sGat95wD54WSdbhMAwjn6r
XwkPTHMHn2qpEOgoVC4dZMsDx+UdkklbCAxQcZApBh6cPZIQ9EuTQIOZXaa+
m3mQQcD2+l0ELrjcCLYV4MH80fTyA4cI1Mo491G8bAbWPZmWLrYjMNso7Gt+
5gwo0yzPM5wI1OFxRpNvzIBN8S/9Pg8CO3ocup28Z6BAyL7q9EUChZQp6Yab
ZsC1UrQ2ModAW8sPGZseT0OQiKfCj4IV3nbmdf79abjuUR9qUUJgQ3L638cS
p6FSzBdEawhML03L3B04DQyvt/UZ7QT+M9K2Y9RwGl7JxTRVLBG4mf63BLWX
C/avKrrrKQLYltZn8egdF4YDxkZaVgng4li3nXsjF2jvD4l0iwpg2NzZZtUC
LhiHbXDmKq/015b1todxoWaoeHazlQCyTF/2wFYulBR+2pSeIYBKvdw8IpkD
Ro7rd2dlreSyISMS8Rxg0Y2t83IFMFgwuE8/igOTx3OCyksEMKDKlFLozwE1
sXNNnc0CeF5DqmbnIQ48ClrlvHZSAP/78H3x63UcSAOthFCgoFJluNbDm1MQ
Fj5QxjGlYF7VrHX61Sk40RTfe8KCglyuEfd+xBRsNRvdaGlLwViKulbruSmo
t3r4VMqLgkJNCcv3D0/BkLNkX1ESBdt/zkabSE2B2sUF5W/jFNRYQ71gZjkJ
IrW5FnbTFNzXMETm7J4EHt/Ot3WeggOK8hulNCehNrK0/AmViqw283t/SkyC
9TVvy4syVFSycDegD0xAYGq/n8QeKopzZT1SgyegtryxyiydintVQyp2lo3D
yapw58xMKt5+vTE5NXcchGuRv/CIio+TtrrR742DY1Ot8eNiKl5X9P9LIHoc
eO8qWxktVIx8bngx4ug4qH0r6RnkrPAJnNZ7/DG4uzZrOsRMEMMkd2jl245B
gFvkliKuII5m6eu5yY/C7Sr5sMI5QTw3ycYWxiiUMso7834L4nOyZUlLeBS4
zWP/ZtNp2OJQcUphkQ1nt9ixUmVpqChhwjPpZYPPjGpglDENqRFHiMYkNnhG
v691vElDRpmhsJUkG1zyZGxoWnQ8Gmwsvqw8Ah0pGuU+2+m4P0j9tI7CCJjH
7FH4YEDHrbmOZ/wkR0DrxFl2nhkdFxR1HH7RR4Cm0Bph7UzH9WwpKaufP6Eg
Mbg07Qods7wkpn/n/4TF4B6G1hc6CtVpdxtt/wkpZnd6XOJWobDL1L9yTj+A
Hjksns38A1si9SufTXyHF+LyTybVV2OjioL4YtIQMLoi43uj1mB40oHCG77f
IEWnXqmoWRirK6S+xV74Ct4jgzLXNq7DucMnw2PiBiHAoPelzan1aK3gfUfv
xQCsciX6PtmIYF5Uke4x0QG4+DY64iZfBI8Mb9e5VN8Pa/4Ijqp9IIrrTqi4
JCd+BuOJvufeB8XQrdDrY5r7J2gcs49jL4hhXvWRNddt+sCp0rC6P1UcRaZC
m5w8PkKGVoqcrTkDx5uURTSDe2HhvFO3EZuBpaF/5c7nfoD7vTu0l69IoHjz
4NFkdg+MfYupM9CVxKgtX1LHVXvgcI1RDqdLEoPe+VoaXuoGNyOfWtXLUijZ
Zpq9rb0Lrt2mbetWkcaIraeTuPpdsMwv23O4WRojnRutygo6QVqyJ9bGXwY3
/IpLrpHrhP2L7pteMWTR8iV7ITGtA1Svuc/XNclihHRiY4dUB1hph3jG+Mqh
T8mLVZvvtUN83pLuy/UbkB9NdzHWbIegt9xtUTUbcIkadauhrg2Ca2xiq47L
Y4SgIT31WBs0Nb+OaFiWR+0eTknhEgueXXiavy9fAUMXnZQN0lnQtLRa03w/
ie02Jxn6e1hgLUyulzpIYkqceVO1CQv6ZbUnvh8iMT0ntxyNWbCw/VhBpD2J
e80SgvYBCzTP5avWuZH4Rr/TwEWfBenDlop650n0esEfvK3OgkBmnJjSIxLZ
wxN0PUkWUPofcLi5JDKEUo83MliQMFbGasgnMdbM7reVOGvlnz/HHy8mse7y
MwFPERZ8NVFfk1ZNYmMIfeeD1SywKn9HFesgMTh8+YHeMhM+NQ9+HegisSKl
v9F+kQmeXbyGJx9I/Jhx9cz5eSZc5sqHHegn0fVNiUUtlwmVaj6/r4yQqDhp
YGH1gwnmuyL67MdI9PMITPIfYkLXvqRKlcmV/Z7Dp+4OMmHKozb4xQyJpUV+
ScN9TAgNbLe/NUfiQUOPmbW9TBC+PKzntkBil6hft243E1JvLkhsWyKR98XT
wKWDCX9mruPx+ST2ntFQiWEx4X9BbMZY
        "]]},
      Annotation[#, "Charting`Private`Tag$15668#1"]& ], {}}, {}}, {{{}, {}, 
     TagBox[
      {GrayLevel[0], AbsoluteThickness[1], Opacity[1.], 
       AbsoluteDashing[{2, 2}], 
       LineBox[{{0.01000016306122449, -1.5707963267948966`}, {
        0.08841658303072619, -1.5707963267948966`}, {
        0.16683300300022788`, -1.5707963267948966`}, {
        0.3368577731128146, -1.5707963267948966`}, {
        0.4956152897255153, -1.5707963267948966`}, {
        0.6512586140628197, -1.5707963267948966`}, {
        0.8200938685737074, -1.5707963267948966`}, {
        0.9776618695847091, -1.5707963267948966`}, {
        1.1484218007692941`, -1.5707963267948966`}, {
        1.316067539678483, -1.5707963267948966`}, {
        1.4724460250877855`, -1.5707963267948966`}, {
        1.6420164406706717`, -1.5707963267948966`}, {
        1.8003196027536716`, -1.5707963267948966`}, {
        1.8779140876574734`, -1.5707963267948966`}, {
        1.9555085725612753`, -1.5707963267948966`}, {
        1.9581395241234814`, -1.5707963267948966`}, {
        1.959414130329309, -1.5707963267948966`}}], LineBox[CompressedData["
1:eJwVlHk41AsfxX9mmK5SWcYev0cvrorIVkrmaymiJIUIuZQSF2W5SleWkJJo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        "]]},
      Annotation[#, "Charting`Private`Tag$15720#1"]& ], {}}, {}}, {{{}, {}, 
     TagBox[
      {GrayLevel[0], AbsoluteThickness[0.4], Opacity[1.], 
       LineBox[CompressedData["
1:eJwV1Xk8VVsbB/BDhRRJUV0aKK4rYyXS8NNV3qJU3F5UMvNyqxOZEm46CQ2I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        "]]},
      Annotation[#, "Charting`Private`Tag$15774#1"]& ], 
     TagBox[
      {GrayLevel[0], AbsoluteThickness[0.4], Opacity[1.], 
       LineBox[CompressedData["
1:eJwV1Xk4VVsbAPBDhRRJUV1UiOvKWGRoeOtWvqIQtw9NMn/cdBwz4aaTUBky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        "]]},
      Annotation[#, "Charting`Private`Tag$15774#2"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {GrayLevel[0], AbsoluteThickness[1.2], Opacity[1.], 
       LineBox[CompressedData["
1:eJwVkGdUUwcYhm/YRCCElQSFy3LhoBgV6RG/j32kThSNVkABBWQqiiJyFKEW
Vxtxi4oswVTBugooiOA6InLDCiOykVRl36CMhNIf73nP++N5fzyWAVHeu1UI
gvCfzv8tcUqtU/6YgMEtdrIS01GweRy6vYmYBHrzjltGvFGItnVuf6Q1Cfkd
0s5QzigwOYNfQ7iTIHQ8McUyGoWVg2tVax0mQTWvN9BLdxQyM7WX5MZOgn9u
WEnslBzCNRP/XE9PQplVWnd2pxwY4iiv2wMKmCKTHVnZcrjhc7rP+ocCHm3f
GiDOkMPy5mxhLqGEwNTv0efTp/mupoZ8thLulDMdZ6TJoUHuGljCV8Kce5Ee
PeflIDLlHm0+pIQrZ/ZK7I/JwTuo7L4RMQXqBbfjLQVyEMenpLhpEbj472vG
aqpykGbnWq7SIdDYWlUZQMhBVvWm2EGfQC0ru5IXChoIC/U+Wy6BeMD4+f4f
NCx+lbiRPY/ANXOYmaV9NJzWiTdt9SRwRZb2qj4JDW43I+4d+p3AE65XbW6J
aCgs9aZEGgzMCo5xmbeahg3b/GKETAYOhF5P1vCgoXck1CRWj4F8od+5Thca
TOYn7nA2YeB+ts3whZU0HLhQIJPMZuDToHA1qR0NP4XoMNTdGegc5DWLMKEh
j/3G3j+JgcXrLFJutI/AlSDHC4aECuoaF39xjhqBJXWJynQ9VYzLi/7Q4TsM
gSOu68xnqGHuXM+MMfchWC8N9iibpY53tmkOh+sOAn9eXlHQfA1092iP13/X
B/etA9gT1pr4sEDIS3jzFbpkCewnfC20lWx2Ma39Fwp8DUd32muj/8msyoMr
ZBCz7LUPy5aJ9i3p+djwGYYbGn07HGbguLR0bvJvPaA5b49XDl8HNa2aDeP2
dUOji0/bWTddjFdOvrAI7YKMsp0DsRv0cIGXVjcvqROI/p4uby8WrqTLFx0v
74Bz+/fg3YX6eEqkuFWh3gE9r00YVn/po8qWSr2s3e0wU/n90sKlbFSXr3Of
OtcGVcHBIYXFbHw/v398a3QreN01XOS0wgDDNq17/ynuE+RUD77eVGaAl0PE
NkWJUqisYm4MBEOMjxoq6rzbAhGKhzz6mSGm73RIOdHVDN/YZ5+auBrhHy8u
l6bymmG5MsN9yUsjjL2ql7QjpAn8qmV5bauNcS3rmLfvo0ZQqSlZrUcZ47vn
D1UaZzTCvnvV0mVrTZCXnqTZcUgCpWEGbgN1Jjg+22Llw7YGaFBJvZmxiYPd
t102vhc0wN7K9KX11RwU5Qz9+qy5HqSHW9Ovb+GiQjuyyldQDzzlNoWgjotv
eX2fNnXXwdIQDbu7O3gYLkoTLwmvA1PRgPdwCw9dniweGyfqIN4s+PFzgSle
VInP5N+oheKDrC/cdlMsrThmGMmvhVc5NDvSbyY+OHr8enZ9DdwrZur59M5E
D/c5MZwDNaDPKPAsiZiFrhlGn+25NQCkMMb86ywsYue1Fr0WwxqrzBh2jBma
i7y17kSJwUYxuFsxZIZPQ8MWopUYDmt/vLQ30hy3uV0miCYKROMt10Ll5sgI
0N6w/iwFdyrmCHfFkDgStFrH0ZMCWlahffEgiWes0yu1PShw0duV9OYQiVsD
uIXNbhS0CtJiFxwlsWT8F26CCwWcfpavPJlE5sdLdIUTBSncsfmnLpNIFOUY
bl9Kwd6IyooHRSSeZppm5lpSUJga4tT1jMRdni1DCRYUaBSq/2NcSuL6rCMR
m0kKMlVQdKScREH1AhnDjIKWK4+FbpUkZl3FL35cCtaU3/RtlJK4/Z2EY8mi
4HrvzxJmG4kbw0osxnUpkOk0bnDqIFHytmtzrQ4FyVsN3DJ7SNzdVLnqJJOC
599O2ob3k+h/fozTr04B08Am+9bg9D+/Pu6dGgUCh5dm4mESrXqzNLJUp30k
Tugv/05ixv2R2wLGtI/cq6dDxkg8t2VXPp+gQPhhmVraBImsuOVVZspqaB2q
SahSTG8fuwt1E9WwiBP9fWqKRIbkWv6ZsWr4D9i2vTg=
        "]]},
      Annotation[#, "Charting`Private`Tag$15829#1"]& ], 
     TagBox[
      {GrayLevel[0], AbsoluteThickness[1.2], Opacity[1.], 
       LineBox[CompressedData["
1:eJwVkGdUUwcYhm/YRCCElQSFy6pVHBSjIj1iPplH6kTRaAUUUECmoigiRxFq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        "]]},
      Annotation[#, "Charting`Private`Tag$15829#2"]& ]}, {}}, 
   {AbsoluteThickness[1.2], 
    LineBox[NCache[{{1.7482897725800823`, Rational[-1, 2] Pi}, {
       1.7482897725800823`, -1.3815287925941468`}}, {{
      1.7482897725800823`, -1.5707963267948966`}, {
      1.7482897725800823`, -1.3815287925941468`}}]], 
    LineBox[NCache[{{1.7482897725800823`, Rational[1, 2] Pi}, {
       1.7482897725800823`, 1.3815287925941468`}}, {{1.7482897725800823`, 
      1.5707963267948966`}, {1.7482897725800823`, 1.3815287925941468`}}]]}, 
   {AbsoluteThickness[1.2], 
    LineBox[NCache[{{0, Rational[-1, 2] Pi}, {
       1.7482897725800823`, Rational[-1, 2] Pi}}, {{
       0, -1.5707963267948966`}, {
       1.7482897725800823`, -1.5707963267948966`}}]], 
    LineBox[NCache[{{0, Rational[1, 2] Pi}, {
       1.7482897725800823`, Rational[1, 2] Pi}}, {{0, 1.5707963267948966`}, {
       1.7482897725800823`, 1.5707963267948966`}}]]}},
  AspectRatio->1,
  AxesLabel->{None, None},
  AxesOrigin->{0., 0.},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{{{
       NCache[Rational[-1, 2] Pi, -1.5707963267948966`], 
       FormBox[
        RowBox[{"-", 
          FractionBox["\[Pi]", "2"]}], TraditionalForm]}, {
       NCache[Rational[-1, 4] Pi, -0.7853981633974483], 
       FormBox[
        RowBox[{"-", 
          FractionBox["\[Pi]", "4"]}], TraditionalForm]}, {0, 
       FormBox["0", TraditionalForm]}, {
       NCache[Rational[1, 4] Pi, 0.7853981633974483], 
       FormBox[
        FractionBox["\[Pi]", "4"], TraditionalForm]}, {
       NCache[Rational[1, 2] Pi, 1.5707963267948966`], 
       FormBox[
        FractionBox["\[Pi]", "2"], TraditionalForm]}}, None}, {
    Automatic, None}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  LabelStyle->{FontFamily -> "Cmr10", FontSize -> 15},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "GridLinesInFront" -> 
    True},
  PlotRange->
   NCache[{{0, 8}, {Rational[-1, 2] Pi, Rational[1, 2] Pi}}, {{0, 
     8}, {-1.5707963267948966`, 1.5707963267948966`}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.67258613152492*^9, 3.672586156236391*^9}, {
   3.672587342006956*^9, 3.672587469018656*^9}, 3.6725875225130053`*^9, 
   3.6725876435541077`*^9, {3.6725878275775084`*^9, 3.672587872619012*^9}, {
   3.672588000937843*^9, 3.672588019937742*^9}, {3.672588063829131*^9, 
   3.67258807181593*^9}, {3.6725881164553933`*^9, 3.672588134516199*^9}, {
   3.672590356985424*^9, 3.672590375378263*^9}, 3.67259043415414*^9, 
   3.6725905193036537`*^9, 3.6725905717158947`*^9, 3.672590610150738*^9, 
   3.6725907164073625`*^9, 3.6725907775024714`*^9, 3.6725909619219117`*^9, 
   3.672591144176135*^9, 3.6725913307117867`*^9, 3.6725917033660483`*^9, {
   3.672591733529064*^9, 3.672591749722684*^9}, 3.6725917857442856`*^9, {
   3.6725920370794163`*^9, 3.672592062197928*^9}, 3.6725922082955365`*^9, 
   3.6725922446601725`*^9, 3.673352413515588*^9, 3.6733524469555883`*^9, 
   3.673352562784588*^9, {3.673352593263588*^9, 3.673352622340588*^9}, {
   3.673352723402588*^9, 3.673352783342588*^9}, {3.930223049246352*^9, 
   3.930223055602996*^9}},
 CellLabel->"Out[24]=",ExpressionUUID->"28c9d090-5f77-4a35-bf9a-3c5fbf24ecb1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pfin", "=", 
  RowBox[{"GraphicsGrid", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"pCR", ",", "pCI"}], "}"}], "}"}], ",", 
    RowBox[{"Spacings", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Scaled", "[", "0.3", "]"}], ",", 
       RowBox[{"Scaled", "[", "0.05", "]"}]}], "}"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.67259147355507*^9, 3.6725914797786922`*^9}, 
   3.6725915394446583`*^9, {3.6725918184945602`*^9, 3.672591822382949*^9}},
 CellLabel->"In[25]:=",ExpressionUUID->"3007aeaf-6d4f-497d-8a0d-c2131065babd"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{{GraphicsComplexBox[CompressedData["
1:eJx1lc9qFEEQhxfBHASdaNIXyWbGt9BT6hnU6F3wHCN5jvgc/nkADwOpgxBf
YG9eRE978LYIEdSd7vp6piqTYcPyMV3VX/8qzT56dfL09a3FYvFl+zd8l2df
y/euXp4ebD9N5fMfj7efncof8nN1Ab8Zll9+r3xW+Aj+VNZXflf6Cfy17FfZ
fCLri+PhuV39YPxg/GD8YPxg/GD8YPxg/ALry8ybC/xg/GD8YPxg/GD8YPxg
/GD8Apun9n6+2vv5au/nq72fr/Z+vtr7+Wrv56u9n6/2fr6V9VnxPcIPxg/G
D8YPxg/GD8YPxg/GL7A+L/MW/GD8YPxg/GD8YPxg/GD8YPwC699/w9NUPxg/
GD8YPxg/GD8YPxg/GL/Alk8K+aWQXwr5pZBfCvmlkF8K+aWQXwr5Vdb3uc/D
6gfjB+MH4wfjB+MH4wfjB+MX2O5nJ/7+duLvb1f9YH9/O/H3txN/fzvx97cT
f3+76ge/zf3u68fc547iC9t7Ce8lvLf5L8P/y5L+EjnuX3hX/fvKNR8//6U8
yQE+sN+Pu2osge135ZD1AuMb69mf+rh/6Ff9eU8/+sf96ZePd7pned9TYwms
ud1xy3qB/bzGenyoj/6h3zV/+tE/7k+/fJzPe5Zfo8YS2M7fsl5gn/9Yjw/1
8/nXfjfkzz3bv7Y//fJxvpF/o8YSuJx/1bJeYJ//WI8P9bP5j/1uyH/0j/vT
7+dw3X9Z/qtGjSVwOf+6Zb3ALv9JPT7Uz+Y/9pvPfxXyn+xPv3y/f1v+60aN
JXA5/6ZlvcAu/0k9PtTP5j/2m89/HfKf7E+/fJ//WP6bRo0lcDn/Vct6gV3+
k3p8qJ/Nf+w3n/8m5D/Zn37/AUUmdpw=
         "], {}], {}}, {{{}, {}, 
         TagBox[
          {GrayLevel[0], AbsoluteThickness[1.2], Opacity[1.], FaceForm[
           Opacity[0.3]], LineBox[CompressedData["
1:eJwl2nc8lt//B/DrkhHZyUpGoQhJSYPOaUiJsiplJoSKPlQyKjursjNKqJQd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            "]]},
          Annotation[#, "Charting`Private`Tag$12888#1"]& ], 
         TagBox[
          {GrayLevel[0], AbsoluteThickness[1.2], Opacity[1.], FaceForm[
           Opacity[0.3]], LineBox[CompressedData["
1:eJwl2nc8lt//B/DrUijZyUpGoQhJSUOdqyEllVUpM6Go6EPLqOysyi6UUCk7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            "]]},
          Annotation[#, "Charting`Private`Tag$12888#2"]& ]}, {}}, 
       {GrayLevel[1], DiskBox[{0, 0}, 1.7482897725800823]}, 
       {GrayLevel[0], AbsoluteThickness[1.2], 
        CircleBox[{0, 0}, 1.7482897725800823, {-0.1892675342007497, 
         0.1892675342007497}], 
        CircleBox[{0, 0}, 1.7482897725800823, {2.9523251193890436`, 
         3.3308601877905426`}]}, {{{}, {}, 
         TagBox[
          {GrayLevel[0], AbsoluteThickness[0.6], Opacity[1.], FaceForm[
           Opacity[0.3]], LineBox[CompressedData["
1:eJwl2nc8lt//B/DrkhHZyUpGoQhJSYPOaUiJsiplJoSKPlQyKjursjNKqJQd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            "]]},
          Annotation[#, "Charting`Private`Tag$12924#1"]& ], 
         TagBox[
          {GrayLevel[0], AbsoluteThickness[0.6], Opacity[1.], FaceForm[
           Opacity[0.3]], LineBox[CompressedData["
1:eJwl2nc8lt//B/DrUijZyUpGoQhJSUOdqyEllVUpM6Go6EPLqOysyi6UUCk7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            "]]},
          Annotation[#, "Charting`Private`Tag$12924#2"]& ]}, {}}, 
       {AbsoluteThickness[1], AbsoluteDashing[{2, 2}], 
        LineBox[{{1.96, -8}, {1.96, 8}}], LineBox[{{-1.96, -8}, {-1.96, 8}}]}},
      AspectRatio->1,
      AxesLabel->{None, None},
      AxesOrigin->{0., 0.},
      DisplayFunction->Identity,
      Frame->True,
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{22.884766182761922`, 0.625}, {22.500000000000057`, 
       3.7925006386878977`}},
      LabelStyle->{FontFamily -> "Cmr10", FontSize -> 15},
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "GridLinesInFront" -> True},
      PlotRange->{{-5, 5}, {-4, 8}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}},
      Ticks->{Automatic, Automatic}], {216., -184.5}, 
     ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
     GraphicsBox[{{GraphicsComplexBox[CompressedData["
1:eJxllT9IVWEYhz+CWjpLg3EH8SjNDg2B1fCdwgiCFunPEDVENglSQpNTS3+4
XGtoEyFoiJDmAuEjiHIQbGiMCAwacilL76UzpOec55X3dy6KPD73fc9z5J7P
sZuzU9MHQgjvd7/3fvLqjE9e+jc2SMMf7+x+bUbPpfHl6nWw8D4zvlv94ojx
ler9Q8anehsTvY2O8Ug1P2xc14wKh7B97fGZE90t6/NcGtPnfWZMH0wfTB9M
H0yf5xBeDj2//nXzp/V5Lo3p8z4zpg+mD6YPpg+mz3MIt+bGJ6befbM+z6Ux
fd5nxvTB9MH0wfTB9HkO4f7kjwudqx+sz3NpTJ/3mTF9MH0wfTB9MH2eQ+jW
HOnzXBrT531mTB9MH0wfTB9Mn+cQbtd/T+vzXBrT531mTB9MH0wfTB9Mn+cQ
XtWfR+vzXBrT531mTB9MH0wfTB9Mn+cQdurn2fo8l8b0eZ8Z0wfTB9MH0wfT
59nOZ+vzbOez9Xlv53OU8znK+RzlfI5yPluf3/8lPqg+j9v2vMALe+smRgrv
R42Zf1iz3S/MvLJen/8X4pN462df7dfipzfP1h+t7KTV6nbzAhYfxVuvzvvr
r7Wuz7z4JD7J/ij7m/mV+Of35tOzs/30fe/2e3kBi4/irV/nff9Kq5958Ul8
kv1R9jfzy/HQk87W0mq/Ob/zAhYfxVu/zvv+5VY/8+KT+CT7o+xv5hfjwo3X
xy7+7aeT1fOTF7D4KN76dd73L7b6mRefxCfZH2V/M9+Nn88NTr843FzvV144
3vdRvPXrvO/vtvrdvn2fxCfZH2V/Mz8f770dWV0/OkjV7fXzAhYfxVu/zvv+
+VY/8+KT+CT7o+xv5mfi+bnjvenhQaqP87yAxUfx1q/zvn+m1c+8+CQ+yf4o
++N/igoNgQ==
         "], {}], {}}, {{{}, {}, 
         TagBox[
          {GrayLevel[0], AbsoluteThickness[1], Opacity[1.], 
           AbsoluteDashing[{2, 2}], 
           LineBox[{{0.01000016306122449, 1.5707963267948966`}, {
            0.08841658303072619, 1.5707963267948966`}, {0.16683300300022788`, 
            1.5707963267948966`}, {0.3368577731128146, 1.5707963267948966`}, {
            0.4956152897255153, 1.5707963267948966`}, {0.6512586140628197, 
            1.5707963267948966`}, {0.8200938685737074, 1.5707963267948966`}, {
            0.9776618695847091, 1.5707963267948966`}, {1.1484218007692941`, 
            1.5707963267948966`}, {1.316067539678483, 1.5707963267948966`}, {
            1.4724460250877855`, 1.5707963267948966`}, {1.6420164406706717`, 
            1.5707963267948966`}, {1.8003196027536716`, 
            1.5707963267948966`}, {1.8779140876574734`, 
            1.5707963267948966`}, {1.9555085725612753`, 
            1.5707963267948966`}, {1.9581395241234814`, 
            1.5707963267948966`}, {1.959414130329309, 1.5707963267948966`}}], 
           LineBox[CompressedData["
1:eJwVlHk41AsfxX9mzHSVyjL2+D16cVVEtlLy/VqKKEkhQi6lxEVZrtKVJaQk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            "]]},
          
          Annotation[#, 
           "Charting`Private`Tag$15668#1"]& ], {}}, {}}, {{{}, {}, 
         TagBox[
          {GrayLevel[0], AbsoluteThickness[1], Opacity[1.], 
           AbsoluteDashing[{2, 2}], 
           LineBox[{{0.01000016306122449, -1.5707963267948966`}, {
            0.08841658303072619, -1.5707963267948966`}, {
            0.16683300300022788`, -1.5707963267948966`}, {
            0.3368577731128146, -1.5707963267948966`}, {
            0.4956152897255153, -1.5707963267948966`}, {
            0.6512586140628197, -1.5707963267948966`}, {
            0.8200938685737074, -1.5707963267948966`}, {
            0.9776618695847091, -1.5707963267948966`}, {
            1.1484218007692941`, -1.5707963267948966`}, {
            1.316067539678483, -1.5707963267948966`}, {
            1.4724460250877855`, -1.5707963267948966`}, {
            1.6420164406706717`, -1.5707963267948966`}, {
            1.8003196027536716`, -1.5707963267948966`}, {
            1.8779140876574734`, -1.5707963267948966`}, {
            1.9555085725612753`, -1.5707963267948966`}, {
            1.9581395241234814`, -1.5707963267948966`}, {
            1.959414130329309, -1.5707963267948966`}}], 
           LineBox[CompressedData["
1:eJwVlHk41AsfxX9mmK5SWcYev0cvrorIVkrmaymiJIUIuZQSF2W5SleWkJJo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            "]]},
          
          Annotation[#, 
           "Charting`Private`Tag$15720#1"]& ], {}}, {}}, {{{}, {}, 
         TagBox[
          {GrayLevel[0], AbsoluteThickness[0.4], Opacity[1.], 
           LineBox[CompressedData["
1:eJwV1Xk8VVsbB/BDhRRJUV0aKK4rYyXS8NNV3qJU3F5UMvNyqxOZEm46CQ2I
DJkq3CKZp8g8z7mEK2MkQ2WI9u444l3nj/1Zn+9nP+uz11r7eZ4lZck0sOFl
MBih5OGOpVJRgp88biOrp11fZ5DG3YNpl+xDfOFQky/G9R8mFS1fku8gaiap
+yjxRPBEyOy//oioyjLmOvfV4pzrdACWjjeu4/pmnajRPP89rGucbjxCLM7Y
L8Gj/gDuNyx3cz0occrrtn4grPzThrSJU9StBvhtg6B6gj+I66f51Wf8GoLx
Iru//3fivVNfxQLZIXDetv38YWLJn3TNKd9QDPO2f9Mi5lnF67527SM8EQ3y
47pJVvz9I7kwqLjsTAKxxcVDcdFGEVC2ma0+SKxz6dgp0+EIOLfy6nCt4GHA
2MqMxNWBzZUHiKkwW8v4O49RluCas5/4fnOgbHJuNNQ+ZlzbR+zUE9nlcDgG
z+5J9GoQG43H+ys0x0Dp5MPDXEuvyJ9I/xiLge7YZerEF+KYRj0rn2Ktxj7r
PcQzHRESQxrxOMmxj1Ai/tgrOVfhHY+FPd6tisSdw8+aEqri8dQlho/ropkU
L5vTCeDUUPY7ie8IlQ2M2SXCpW6bkBz3PI6OJUyFP8d6zf3V24gTuqZ3ZQ49
hytDqHArsbwDu9xJ6QWYSZYpW4jVgwQHv1e/wM2jj1mSxAbdCpILc0nw1VcV
3Ejsf9nxkYBhCoKZbKYw8RqGx/aGuBQ0rFxSECIOD7mVdW8iBYuyfp9Wcb+X
H9oqfOsV0kK2nFpJXMKTt1osMxWP6+2oZcTzul4VwfwZ4A84HftjgMahRzx3
HRUzoCfkLE0T+/T5njEwzMBk7sbE78QCVwMH1z3JQILkSMw3YrGwJ4vhezNx
6L2f9RdilYFyzVibLPw9/kFvgNjuGl92cmUOIuf0PSqI57NfD/OP5uAav0hG
GfH9OYf1toK58PWvGCohznB56yJ9JhezDziH3nDj3SI1ovtz4Zb1pi2bONBT
vuQ+Ow9yNdZ2icR5vvr1TOUCOGv0HWERH6thzDcbFGDeJ3mjD3EPX7a8gmsB
ehetx72JGf4b7o8VFWA6b9LHg1j37qC+hW4hPr0rDXQk7g90emdg8wbM1WvF
zIhXRIYPqEUXI/JydLs6sXVpm/NQcTECFzQM1IirPgkLBg0WIz9jsHkX8W01
vz1jMiW4Lq5fpEi8vN0tICqjBBWvY122E/MKm+xeqi7F7+a0iTB3PRUPtK1/
lGHhetPYh36y/46dgYUrywEbN4EBYvPx+n9FJMpx/6OcTC9xmQjfleKD5ZBU
fHK2k/immXekOKsca2s7QhqIlxaufK0TqsAeWQPvLOJF9dMRitsrca61dONN
4lCloDULapUYenE5xJNYTqbFr+FYJZhuLQLXiQ1ET7jbXamEag3vZ0fi51/+
Y/KsoBJR+Sq+VsT6zyAhdroKP0NdRXSIYwWVnyx4VkOBdcpHgPhAn9CLxs5a
HC8yL7/VR8P97XC78VgtPH/ZnuhNnFtewPjErsWOpAaWB7HSc5tzjM11qMmo
2+dEvI1ZLKRmVYetIp43LYiX81x2jpuqg25zjDuIm3Y0HXYUaMCNytL17F5S
v5fu9oprNuHTm8IpS2Kz91uL87xaUbvBauO39zRsP0f+cay9DQlbuo+f7KZx
0XHGO4PRAUPnYK2gLhq0oa3pFtMujKal1jM7SL6nFLZYPuxGbmHaW812GkPM
VP8HhT3Y417v2N1KYzi4iCoW7QdkM1WWt9D4M7TjhqXUIK6a7DSVaqSRs/p8
59jpD6jOnbcvrKXxvyLls0MeQ5Dunc3eVEUjTNZ5c23wMFarrZK7VkZDtLSm
VKnkI7S6njUqF5H6Eg1I8ekagfLbTKHxfHLeoSaORgKjgJTZ56ks8n91r59/
unsMDzakDWem0vitWCDone44CopSi9ySSL2bPo+5d30CSjmGtfbxpB+8zp5V
fPQZVlVTbeYxNOaOizC1k79AR1WmVSycxK+8UdXT8RUnVAIsWgNpNLDOWplN
TsJFvMk93I+GlPjWyV1rpjF4Wu8Y/qIRsuJNETNxGlrfR4JZrjS02oRV4pVn
sH6Ub/n7y+Q+ybMXCa+ZwbyHz6peK5Jfbp5hfxl+wybGmvQpExpX2/Nexfd9
Q9qAgW/sKXLf6PxQ8bs2i8Csu+G52qQfRMyYWCzNIpkS3D2iTvJ/aWZqIXwO
ssZ85UfkaTgeeSkfuOM79KL0RAskaeTvuEsbp39Hj84u8SfCNGQlHVVHjlI4
IRJpbbxI4Z/pNSJ2bRS8fcb3K0xSSOzNPf/SgSb9c9O1mz0UUq1Y+35l/ED9
HgfzyVoK32oFih7f+4ELJxvGvXIomGmHpTRLs7HevBQCcRQEYrpBp7MRd+9A
QaofhdGgo7bnNOcxYjIjZXGVwmTUa7Z3KzFvp7bTWQqqrGHVxxc40AtQTU/S
pKAkV1oraMaB8DsRXUXinc1Rpp4WHPyspCoy91GQ2WAQYGbLAc/FTP1CDQqb
UsoGZa6S+BV9TfV7KfC0xwZlsThIcZo4P7SL7E/a+GvjSw6i7cpYbHkKLbW7
WQdTOTDxvtJ8nbjx0ppN6ekcGAaxZ9m/UajOqzkSksNBnINPF1uOQoGuWoxx
CQeMh4Y0LUvhmZOo3sg/HFhP9z38Kk0hbsPk4H/fcTBiv5T4J3F0Ub1rXScH
CgL2j8alKITx+cSn9HCQ5DXFP7KNQkDUFNtxhIPWziqt91so3EFj0PAomc/Y
rmZEzPr4XObsBAfLRrxXvNtMwUvp4hmNKQ4W/hbUbJak4NG+bzR5hgO5sV/j
jhO7uYt5ScxxsJi2ub9agoLz5hnRBxR5nzrEPkzsWNGUtPiDA/2wyzPFv1D4
Pwu45CQ=
            "]]},
          Annotation[#, "Charting`Private`Tag$15774#1"]& ], 
         TagBox[
          {GrayLevel[0], AbsoluteThickness[0.4], Opacity[1.], 
           LineBox[CompressedData["
1:eJwV1Xk4VVsbAPBDhRRJUV1UiOvKWGRoeOtWvqIQtw9NMn/cdBwz4aaTUBky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            "]]},
          Annotation[#, "Charting`Private`Tag$15774#2"]& ]}, {}}, {{{}, {}, 
         TagBox[
          {GrayLevel[0], AbsoluteThickness[1.2], Opacity[1.], 
           LineBox[CompressedData["
1:eJwVkGdUUwcYhm/YRCCElQSFy3LhoBgV6RG/j32kThSNVkABBWQqiiJyFKEW
Vxtxi4oswVTBugooiOA6InLDCiOykVRl36CMhNIf73nP++N5fzyWAVHeu1UI
gvCfzv8tcUqtU/6YgMEtdrIS01GweRy6vYmYBHrzjltGvFGItnVuf6Q1Cfkd
0s5QzigwOYNfQ7iTIHQ8McUyGoWVg2tVax0mQTWvN9BLdxQyM7WX5MZOgn9u
WEnslBzCNRP/XE9PQplVWnd2pxwY4iiv2wMKmCKTHVnZcrjhc7rP+ocCHm3f
GiDOkMPy5mxhLqGEwNTv0efTp/mupoZ8thLulDMdZ6TJoUHuGljCV8Kce5Ee
PeflIDLlHm0+pIQrZ/ZK7I/JwTuo7L4RMQXqBbfjLQVyEMenpLhpEbj472vG
aqpykGbnWq7SIdDYWlUZQMhBVvWm2EGfQC0ru5IXChoIC/U+Wy6BeMD4+f4f
NCx+lbiRPY/ANXOYmaV9NJzWiTdt9SRwRZb2qj4JDW43I+4d+p3AE65XbW6J
aCgs9aZEGgzMCo5xmbeahg3b/GKETAYOhF5P1vCgoXck1CRWj4F8od+5Thca
TOYn7nA2YeB+ts3whZU0HLhQIJPMZuDToHA1qR0NP4XoMNTdGegc5DWLMKEh
j/3G3j+JgcXrLFJutI/AlSDHC4aECuoaF39xjhqBJXWJynQ9VYzLi/7Q4TsM
gSOu68xnqGHuXM+MMfchWC8N9iibpY53tmkOh+sOAn9eXlHQfA1092iP13/X
B/etA9gT1pr4sEDIS3jzFbpkCewnfC20lWx2Ma39Fwp8DUd32muj/8msyoMr
ZBCz7LUPy5aJ9i3p+djwGYYbGn07HGbguLR0bvJvPaA5b49XDl8HNa2aDeP2
dUOji0/bWTddjFdOvrAI7YKMsp0DsRv0cIGXVjcvqROI/p4uby8WrqTLFx0v
74Bz+/fg3YX6eEqkuFWh3gE9r00YVn/po8qWSr2s3e0wU/n90sKlbFSXr3Of
OtcGVcHBIYXFbHw/v398a3QreN01XOS0wgDDNq17/ynuE+RUD77eVGaAl0PE
NkWJUqisYm4MBEOMjxoq6rzbAhGKhzz6mSGm73RIOdHVDN/YZ5+auBrhHy8u
l6bymmG5MsN9yUsjjL2ql7QjpAn8qmV5bauNcS3rmLfvo0ZQqSlZrUcZ47vn
D1UaZzTCvnvV0mVrTZCXnqTZcUgCpWEGbgN1Jjg+22Llw7YGaFBJvZmxiYPd
t102vhc0wN7K9KX11RwU5Qz9+qy5HqSHW9Ovb+GiQjuyyldQDzzlNoWgjotv
eX2fNnXXwdIQDbu7O3gYLkoTLwmvA1PRgPdwCw9dniweGyfqIN4s+PFzgSle
VInP5N+oheKDrC/cdlMsrThmGMmvhVc5NDvSbyY+OHr8enZ9DdwrZur59M5E
D/c5MZwDNaDPKPAsiZiFrhlGn+25NQCkMMb86ywsYue1Fr0WwxqrzBh2jBma
i7y17kSJwUYxuFsxZIZPQ8MWopUYDmt/vLQ30hy3uV0miCYKROMt10Ll5sgI
0N6w/iwFdyrmCHfFkDgStFrH0ZMCWlahffEgiWes0yu1PShw0duV9OYQiVsD
uIXNbhS0CtJiFxwlsWT8F26CCwWcfpavPJlE5sdLdIUTBSncsfmnLpNIFOUY
bl9Kwd6IyooHRSSeZppm5lpSUJga4tT1jMRdni1DCRYUaBSq/2NcSuL6rCMR
m0kKMlVQdKScREH1AhnDjIKWK4+FbpUkZl3FL35cCtaU3/RtlJK4/Z2EY8mi
4HrvzxJmG4kbw0osxnUpkOk0bnDqIFHytmtzrQ4FyVsN3DJ7SNzdVLnqJJOC
599O2ob3k+h/fozTr04B08Am+9bg9D+/Pu6dGgUCh5dm4mESrXqzNLJUp30k
Tugv/05ixv2R2wLGtI/cq6dDxkg8t2VXPp+gQPhhmVraBImsuOVVZspqaB2q
SahSTG8fuwt1E9WwiBP9fWqKRIbkWv6ZsWr4D9i2vTg=
            "]]},
          Annotation[#, "Charting`Private`Tag$15829#1"]& ], 
         TagBox[
          {GrayLevel[0], AbsoluteThickness[1.2], Opacity[1.], 
           LineBox[CompressedData["
1:eJwVkGdUUwcYhm/YRCCElQSFy6pVHBSjIj1iPplH6kTRaAUUUECmoigiRxFq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            "]]},
          Annotation[#, "Charting`Private`Tag$15829#2"]& ]}, {}}, 
       {AbsoluteThickness[1.2], 
        LineBox[NCache[{{1.7482897725800823`, Rational[-1, 2] Pi}, {
           1.7482897725800823`, -1.3815287925941468`}}, {{
          1.7482897725800823`, -1.5707963267948966`}, {
          1.7482897725800823`, -1.3815287925941468`}}]], 
        LineBox[NCache[{{1.7482897725800823`, Rational[1, 2] Pi}, {
           1.7482897725800823`, 1.3815287925941468`}}, {{1.7482897725800823`, 
          1.5707963267948966`}, {1.7482897725800823`, 
          1.3815287925941468`}}]]}, 
       {AbsoluteThickness[1.2], 
        LineBox[NCache[{{0, Rational[-1, 2] Pi}, {
           1.7482897725800823`, Rational[-1, 2] Pi}}, {{
           0, -1.5707963267948966`}, {
           1.7482897725800823`, -1.5707963267948966`}}]], 
        LineBox[NCache[{{0, Rational[1, 2] Pi}, {
           1.7482897725800823`, Rational[1, 2] Pi}}, {{
           0, 1.5707963267948966`}, {1.7482897725800823`, 
           1.5707963267948966`}}]]}},
      AspectRatio->1,
      AxesLabel->{None, None},
      AxesOrigin->{0., 0.},
      DisplayFunction->Identity,
      Frame->True,
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{{{
           NCache[Rational[-1, 2] Pi, -1.5707963267948966`], 
           FormBox[
            RowBox[{"-", 
              FractionBox["\[Pi]", "2"]}], TraditionalForm]}, {
           NCache[Rational[-1, 4] Pi, -0.7853981633974483], 
           FormBox[
            RowBox[{"-", 
              FractionBox["\[Pi]", "4"]}], TraditionalForm]}, {0, 
           FormBox["0", TraditionalForm]}, {
           NCache[Rational[1, 4] Pi, 0.7853981633974483], 
           FormBox[
            FractionBox["\[Pi]", "4"], TraditionalForm]}, {
           NCache[Rational[1, 2] Pi, 1.5707963267948966`], 
           FormBox[
            FractionBox["\[Pi]", "2"], TraditionalForm]}}, None}, {
        Automatic, None}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{26.970459314550354`, 0.6250000000000568}, {
       22.500000000000057`, 3.7925006386878977`}},
      LabelStyle->{FontFamily -> "Cmr10", FontSize -> 15},
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "GridLinesInFront" -> True},
      PlotRange->
       NCache[{{0, 8}, {Rational[-1, 2] Pi, Rational[1, 2] Pi}}, {{0, 
         8}, {-1.5707963267948966`, 1.5707963267948966`}}],
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}},
      Ticks->{Automatic, Automatic}], {648., -184.5}, 
     ImageScaled[{0.5, 0.5}], {360., 360.}]}, {}},
  ImageSize->500,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{
  3.672500000930271*^9, 3.6725007591000805`*^9, 3.672501132011368*^9, 
   3.672585677017474*^9, 3.672590721242846*^9, 3.6725907814448657`*^9, 
   3.6725908277894993`*^9, 3.672590968146534*^9, 3.672591154736191*^9, 
   3.672591336885404*^9, {3.6725914746421785`*^9, 3.672591480427757*^9}, 
   3.6725915406167755`*^9, 3.672591707600472*^9, 3.6725917906737785`*^9, 
   3.6725918229480057`*^9, 3.6725920372274313`*^9, 3.6725921149342012`*^9, 
   3.6725922162713337`*^9, 3.6725922495896654`*^9, 3.673352547570588*^9, {
   3.673352608522588*^9, 3.673352627105588*^9}, 3.673352797827588*^9, 
   3.930223062863982*^9},
 CellLabel->"Out[25]=",ExpressionUUID->"5dbefd2f-6361-4ecc-bd2f-321067db932f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{
  "\"\<c:/dropbox/mystuff/cred/ECMAScndRev/WIconst.pdf\>\"", ",", "pfin"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.6725913503017454`*^9, 
  3.6725913508618016`*^9}},ExpressionUUID->"66088279-9650-42c4-9760-\
547a48e4dc21"],

Cell[BoxData["\<\"c:/dropbox/mystuff/cred/ECMAScndRev/WIconst.pdf\"\>"], \
"Output",
 CellChangeTimes->{3.6725913532780433`*^9, 3.6725915204467583`*^9, 
  3.672591796859397*^9, 
  3.672591830111722*^9},ExpressionUUID->"d387afe9-29be-428e-8f05-\
fb63dbe124b9"]
}, Open  ]]
},
WindowSize->{1407.876923076923, 726.0923076923077},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"13.0 for Microsoft Windows (64-bit) (February 4, 2022)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"fe7ad922-b632-4664-ad5f-c8a16d81ab8c"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 205, 4, 35, "Input",ExpressionUUID->"5cbba988-0c26-4155-a6fa-e0265415b11d"],
Cell[CellGroupData[{
Cell[788, 28, 2185, 60, 107, "Input",ExpressionUUID->"023d91ec-3ec0-46c8-a4d3-b3b298119cfa"],
Cell[2976, 90, 713, 12, 62, "Output",ExpressionUUID->"0e5a63cb-f034-4f6f-b112-dfe0c71c8d92"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3726, 107, 707, 20, 35, "Input",ExpressionUUID->"edd06d99-7d5e-4e57-bd51-a0dd023918f6"],
Cell[CellGroupData[{
Cell[4458, 131, 396, 10, 42, "Print",ExpressionUUID->"6b4caeac-c3d9-4860-8c2d-d892ccc58d3d"],
Cell[4857, 143, 396, 10, 42, "Print",ExpressionUUID->"2dcac21a-bf85-444b-a277-48f70e817df6"],
Cell[5256, 155, 396, 10, 42, "Print",ExpressionUUID->"db3e6af7-5dcf-4325-85c8-a1fe9faf59ab"],
Cell[5655, 167, 394, 10, 42, "Print",ExpressionUUID->"b7acc6e4-49c8-4b09-9ae8-b7041e27e356"],
Cell[6052, 179, 443, 10, 42, "Print",ExpressionUUID->"7193d118-3fcb-4051-bbb9-4af8aa42b210"],
Cell[6498, 191, 394, 10, 42, "Print",ExpressionUUID->"9c6793ca-4781-4cb9-9a72-6cc64f73b4e7"],
Cell[6895, 203, 394, 10, 42, "Print",ExpressionUUID->"87c25f85-e696-44a4-a3e5-fc8a9a53d07d"],
Cell[7292, 215, 442, 10, 42, "Print",ExpressionUUID->"8f4c3f2e-0fa6-458e-815d-5646f83cbcaf"],
Cell[7737, 227, 1034, 19, 97, "Print",ExpressionUUID->"2c0c2e8f-f682-4b62-8b57-ecd0286f765a"],
Cell[8774, 248, 1016, 18, 97, "Print",ExpressionUUID->"a7e5ac3e-cbc9-4045-9c35-bf6dde0b1ff3"],
Cell[9793, 268, 1034, 19, 97, "Print",ExpressionUUID->"ca30840e-0382-4bc2-bf84-590cbd68e3b7"],
Cell[10830, 289, 1034, 19, 97, "Print",ExpressionUUID->"31bfea6c-2b17-46d2-ac2a-02016f724b63"],
Cell[11867, 310, 1016, 18, 97, "Print",ExpressionUUID->"620944de-3e52-4ce2-92a8-da22d5af10c2"],
Cell[12886, 330, 443, 10, 42, "Print",ExpressionUUID->"035ecfc3-dc7b-499e-919d-aac5c1f7850b"],
Cell[13332, 342, 1018, 18, 97, "Print",ExpressionUUID->"c3026f28-cf15-4b05-bdda-778791aaa747"],
Cell[14353, 362, 444, 10, 42, "Print",ExpressionUUID->"4f331841-b64d-424f-9f30-cf54c93d08db"],
Cell[14800, 374, 394, 10, 42, "Print",ExpressionUUID->"c2fe7828-3eff-4593-b8ff-a7e10044a1ef"],
Cell[15197, 386, 393, 10, 42, "Print",ExpressionUUID->"0a7fdfc5-448f-437c-a12f-aca42ab3ce85"],
Cell[15593, 398, 394, 10, 42, "Print",ExpressionUUID->"1d447c7e-7d3e-4200-a245-b151b2f60ef2"],
Cell[15990, 410, 443, 10, 42, "Print",ExpressionUUID->"435ae217-544f-42f7-8191-62225c24077e"],
Cell[16436, 422, 1016, 18, 97, "Print",ExpressionUUID->"f5654c7b-b80d-40f7-8f3d-5c6e991324c7"],
Cell[17455, 442, 1016, 18, 97, "Print",ExpressionUUID->"8c5f2d25-18f9-4b29-b4df-8db0b00be612"],
Cell[18474, 462, 1016, 18, 97, "Print",ExpressionUUID->"89bf405a-2c7d-4ae3-be1f-f4f00e31994d"],
Cell[19493, 482, 444, 10, 42, "Print",ExpressionUUID->"c6557f5c-0823-470a-b72d-f92a2f272a9b"],
Cell[19940, 494, 396, 10, 42, "Print",ExpressionUUID->"96d3c4f8-b4bc-4e8f-91ed-0793791654af"],
Cell[20339, 506, 394, 10, 42, "Print",ExpressionUUID->"aa38c269-ec37-4697-a44d-0a01068c4543"],
Cell[20736, 518, 396, 10, 42, "Print",ExpressionUUID->"bc036dc0-1f8d-431a-8402-f40d3711901c"],
Cell[21135, 530, 443, 10, 42, "Print",ExpressionUUID->"5b03b101-cf97-460b-b286-95508fd5029b"],
Cell[21581, 542, 1018, 18, 97, "Print",ExpressionUUID->"752d716a-264c-4aa1-a81d-94d125266786"],
Cell[22602, 562, 1018, 18, 97, "Print",ExpressionUUID->"eb2d40c0-e6d3-40b4-9db5-5036758a0a27"],
Cell[23623, 582, 1016, 18, 97, "Print",ExpressionUUID->"8f84acd6-c78f-430a-8d2b-7a236e9f6a70"],
Cell[24642, 602, 444, 10, 42, "Print",ExpressionUUID->"4a071d05-7203-45e4-9d0f-abe47ef87864"],
Cell[25089, 614, 394, 10, 42, "Print",ExpressionUUID->"a3a30390-08bc-4ea5-90d7-d46689f202b7"],
Cell[25486, 626, 394, 10, 42, "Print",ExpressionUUID->"02cbca69-f451-4d58-af5b-5ce603cb3004"],
Cell[25883, 638, 394, 10, 42, "Print",ExpressionUUID->"88552386-e451-4e0c-827c-1e9ab2b52fab"],
Cell[26280, 650, 443, 10, 42, "Print",ExpressionUUID->"3f7cd506-c4c7-4f48-b85e-fb012bb0536b"],
Cell[26726, 662, 1032, 19, 97, "Print",ExpressionUUID->"a05b2ca6-644e-48b8-85f3-aceab86dd57c"],
Cell[27761, 683, 1032, 19, 97, "Print",ExpressionUUID->"19267509-a9ed-4aef-af09-3dc85f4d9eb3"],
Cell[28796, 704, 1032, 19, 97, "Print",ExpressionUUID->"7bd99e51-81d1-4160-8a6a-b79150aec96b"],
Cell[29831, 725, 446, 10, 42, "Print",ExpressionUUID->"e8c7b7ee-4bd4-4d5b-8683-3881f522efcb"],
Cell[30280, 737, 396, 10, 42, "Print",ExpressionUUID->"35610829-5070-4617-a3af-431180501955"],
Cell[30679, 749, 396, 10, 42, "Print",ExpressionUUID->"93e3a923-aa26-4c3a-a282-4c33acd0f797"],
Cell[31078, 761, 396, 10, 42, "Print",ExpressionUUID->"a5ab24c1-40a6-4a1b-b171-0ecd50fbdbea"],
Cell[31477, 773, 445, 10, 42, "Print",ExpressionUUID->"c9b65abc-7286-487c-a025-dd28808bd3de"],
Cell[31925, 785, 1016, 18, 97, "Print",ExpressionUUID->"c423df90-2cf4-4f94-aead-7d1d0fbdc91e"],
Cell[32944, 805, 1018, 18, 97, "Print",ExpressionUUID->"59c9ee5a-ce99-4497-8b3b-71f2e5b200c2"],
Cell[33965, 825, 1018, 18, 97, "Print",ExpressionUUID->"474aef8f-98ad-46f7-8193-ae15c92082ec"],
Cell[34986, 845, 444, 10, 42, "Print",ExpressionUUID->"16acb85f-e767-4d9e-9b93-3d254e86ebd4"],
Cell[35433, 857, 396, 10, 42, "Print",ExpressionUUID->"356d45ce-f6cb-4825-9c6d-c9a0423c4f14"],
Cell[35832, 869, 396, 10, 42, "Print",ExpressionUUID->"f5931b15-5548-4f2b-ad08-9856286cd35d"],
Cell[36231, 881, 394, 10, 42, "Print",ExpressionUUID->"b2e30122-aac1-4ac5-b922-af36c916c79c"],
Cell[36628, 893, 443, 10, 42, "Print",ExpressionUUID->"2b915294-ff03-4e05-8d00-a3bdde97271b"],
Cell[37074, 905, 1018, 18, 97, "Print",ExpressionUUID->"c45d8f96-d619-499d-bbcf-80752f822572"],
Cell[38095, 925, 1018, 18, 97, "Print",ExpressionUUID->"c1d509a8-82e5-4b10-a447-a519bfedaa64"],
Cell[39116, 945, 1016, 18, 97, "Print",ExpressionUUID->"2e582b59-9e21-48f9-96c0-7fa7201c2a2c"],
Cell[40135, 965, 446, 10, 42, "Print",ExpressionUUID->"e32b3375-cc3c-43c1-a237-b6298ad0e8d2"],
Cell[40584, 977, 394, 10, 42, "Print",ExpressionUUID->"67a96610-5c30-4410-8ed5-39ace9e49b96"],
Cell[40981, 989, 394, 10, 42, "Print",ExpressionUUID->"5f71e5e8-812c-45ed-b017-0ff6147ec29c"],
Cell[41378, 1001, 394, 10, 42, "Print",ExpressionUUID->"d9e24368-839e-47b5-b41e-88585b7c03bb"],
Cell[41775, 1013, 445, 10, 42, "Print",ExpressionUUID->"b520bbf1-28e3-4388-8d6e-d36e52b5e676"],
Cell[42223, 1025, 1031, 19, 97, "Print",ExpressionUUID->"0c02cca4-04eb-47a3-9993-8e3019055844"],
Cell[43257, 1046, 1034, 19, 97, "Print",ExpressionUUID->"abbfac43-b19e-495f-8942-78b9ab1e9da5"],
Cell[44294, 1067, 1034, 19, 97, "Print",ExpressionUUID->"5d4d29f4-d67d-402e-817d-8eb73cfc7871"],
Cell[45331, 1088, 446, 10, 42, "Print",ExpressionUUID->"851bf36d-7b66-498f-b175-ea4bd7859f04"],
Cell[45780, 1100, 396, 10, 42, "Print",ExpressionUUID->"e78cb1f5-d25a-4edc-885d-412a1e195266"],
Cell[46179, 1112, 396, 10, 42, "Print",ExpressionUUID->"1638f0ba-0fae-4df2-be04-f794215bff6e"],
Cell[46578, 1124, 396, 10, 42, "Print",ExpressionUUID->"7b262471-bd83-4f41-b584-87af5c64d346"],
Cell[46977, 1136, 445, 10, 42, "Print",ExpressionUUID->"1ea757c2-c9f6-42f6-9a0d-c41465f49ae6"],
Cell[47425, 1148, 1018, 18, 97, "Print",ExpressionUUID->"0802b246-2c82-4c95-a585-08e6d7593d87"],
Cell[48446, 1168, 1016, 18, 97, "Print",ExpressionUUID->"5d0af0af-4137-4e47-919e-63897f4e686b"],
Cell[49465, 1188, 1018, 18, 97, "Print",ExpressionUUID->"b5c348f7-92c2-4d7a-924c-b00822b1c768"],
Cell[50486, 1208, 444, 10, 42, "Print",ExpressionUUID->"90bbab01-c523-41df-a829-73f66c1d09b7"],
Cell[50933, 1220, 396, 10, 42, "Print",ExpressionUUID->"c0f1d738-ebeb-4f2f-b664-f821cc701ef3"],
Cell[51332, 1232, 394, 10, 42, "Print",ExpressionUUID->"080ec467-5cf2-4a48-bffe-82ef527629ff"],
Cell[51729, 1244, 394, 10, 42, "Print",ExpressionUUID->"fbfd57a5-844f-4d48-8e84-b96dec3530d7"],
Cell[52126, 1256, 445, 10, 42, "Print",ExpressionUUID->"dd3dd3e5-619f-4be3-9562-3044c16eeade"],
Cell[52574, 1268, 1018, 18, 97, "Print",ExpressionUUID->"2bb99554-402c-4e4d-a008-0f86327771e1"],
Cell[53595, 1288, 1018, 18, 97, "Print",ExpressionUUID->"9be0d168-c266-4b90-bb85-424148887953"],
Cell[54616, 1308, 1018, 18, 97, "Print",ExpressionUUID->"9d3905af-cd70-49b8-80d3-a675499a8842"],
Cell[55637, 1328, 446, 10, 42, "Print",ExpressionUUID->"9bb7c322-fbee-43a9-969d-fc5a832aa772"]
}, Open  ]],
Cell[56098, 1341, 15535, 366, 564, "Output",ExpressionUUID->"fd8929f9-45e6-4dc8-b698-02590febfbf3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[71670, 1712, 190, 4, 35, "Input",ExpressionUUID->"056eb7c1-63ce-4301-b5fa-2e63b0e837b8"],
Cell[71863, 1718, 4082, 80, 304, "Output",ExpressionUUID->"952a3cea-dffa-43d9-9036-ef20bb6e4dd7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[75982, 1803, 1704, 47, 131, "Input",ExpressionUUID->"c3d26cd5-9648-49a3-be1d-16ff8959e8f0"],
Cell[77689, 1852, 17083, 329, 79, "Output",ExpressionUUID->"3ee61bc6-597d-4651-a030-4094234c0e9e"],
Cell[94775, 2183, 702, 14, 50, "Message",ExpressionUUID->"398de620-da4e-4151-a86e-2ed0ff7b70ab"],
Cell[95480, 2199, 1030, 19, 61, "Message",ExpressionUUID->"5bf740a9-3edd-4113-97f8-ee6fc724d13c"],
Cell[96513, 2220, 701, 14, 50, "Message",ExpressionUUID->"db0dcd38-af14-4ffd-9c57-c18902c338b9"],
Cell[97217, 2236, 1030, 19, 61, "Message",ExpressionUUID->"d11993eb-3739-4289-b417-be8ec6a9fe67"],
Cell[98250, 2257, 453, 6, 40, "Output",ExpressionUUID->"2b9ab82b-b081-47e4-8ba6-a308a74d362d"],
Cell[98706, 2265, 451, 6, 40, "Output",ExpressionUUID->"5d8f6584-5fda-4877-a437-bc210792a47e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[99194, 2276, 6215, 175, 274, "Input",ExpressionUUID->"5b98ca63-e186-4bf3-aee2-d31507c4c5a7"],
Cell[105412, 2453, 50282, 845, 471, "Output",ExpressionUUID->"ec224fda-7e5b-48ff-a8c7-8140db36f8de"]
}, Open  ]],
Cell[CellGroupData[{
Cell[155731, 3303, 7736, 204, 416, "Input",ExpressionUUID->"11cb64dd-8a4c-48ab-9382-e024a5218c53"],
Cell[163470, 3509, 6321, 118, 295, "Output",ExpressionUUID->"a846ad24-6d9a-453c-979e-291db66c1b54"],
Cell[169794, 3629, 6387, 123, 287, "Output",ExpressionUUID->"777ca3fb-16d0-4d0b-9097-809964ea52f1"],
Cell[176184, 3754, 8829, 165, 285, "Output",ExpressionUUID->"7ee9cff8-95f2-46db-b7a0-c959836df8e9"],
Cell[185016, 3921, 7078, 135, 294, "Output",ExpressionUUID->"d779a4a2-4fae-492a-98c8-d3889318cfe1"],
Cell[192097, 4058, 23106, 412, 469, "Output",ExpressionUUID->"28c9d090-5f77-4a35-bf9a-3c5fbf24ecb1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[215240, 4475, 642, 15, 35, "Input",ExpressionUUID->"3007aeaf-6d4f-497d-8a0d-c2131065babd"],
Cell[215885, 4492, 73401, 1259, 320, "Output",ExpressionUUID->"5dbefd2f-6361-4ecc-bd2f-321067db932f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[289323, 5756, 275, 7, 35, "Input",ExpressionUUID->"66088279-9650-42c4-9760-547a48e4dc21"],
Cell[289601, 5765, 259, 5, 40, "Output",ExpressionUUID->"d387afe9-29be-428e-8f05-fb63dbe124b9"]
}, Open  ]]
}
]
*)

