(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     73180,       1728]
NotebookOptionsPosition[     69112,       1663]
NotebookOutlinePosition[     69578,       1681]
CellTagsIndexPosition[     69535,       1678]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"level", "=", ".05"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"grid", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"j", ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", "8", ",", ".2"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cv", "=", 
   RowBox[{"Quantile", "[", 
    RowBox[{
     RowBox[{"NormalDistribution", "[", 
      RowBox[{"0", ",", "1"}], "]"}], ",", 
     RowBox[{"1", "-", 
      RowBox[{"level", "/", "2"}]}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dPhi", "[", 
    RowBox[{"a_", ",", "b_"}], "]"}], "=", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"a", "<", "b"}], ",", 
       RowBox[{
        RowBox[{"CDF", "[", 
         RowBox[{
          RowBox[{"NormalDistribution", "[", 
           RowBox[{"0", ",", "1"}], "]"}], ",", "b"}], "]"}], "-", 
        RowBox[{"CDF", "[", 
         RowBox[{
          RowBox[{"NormalDistribution", "[", 
           RowBox[{"0", ",", "1"}], "]"}], ",", "a"}], "]"}]}], ",", "0"}], 
      "]"}], ",", 
     RowBox[{"Element", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", "Reals"}], "]"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xdel", "=", ".2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xgrid", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"j", ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", 
       RowBox[{
        RowBox[{"Max", "[", "grid", "]"}], "+", "3"}], ",", "xdel"}], "}"}]}],
     "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"wi", "[", 
     RowBox[{
      RowBox[{"x_", "?", "NumberQ"}], ",", "rho_"}], "]"}], "=", 
    RowBox[{
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{"2", 
        RowBox[{"Cosh", "[", 
         RowBox[{"x", " ", "rho", " ", 
          RowBox[{"Cos", "[", "om", "]"}]}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"om", ",", 
         RowBox[{"ArcSin", "[", 
          RowBox[{"cv", "/", "x"}], "]"}], ",", 
         RowBox[{"Pi", "/", "2"}]}], "}"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"Pi", " ", 
       RowBox[{"BesselI", "[", 
        RowBox[{"0", ",", 
         RowBox[{"rho", " ", "x"}]}], "]"}]}], ")"}]}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"w", "[", 
     RowBox[{"c_", ",", "d_", ",", "rho_"}], "]"}], ":=", 
    RowBox[{"NIntegrate", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Piecewise", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", 
            RowBox[{"x", "<", "cv"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"NIntegrate", "[", 
             RowBox[{
              RowBox[{"2", 
               RowBox[{"Cosh", "[", 
                RowBox[{"x", " ", "rho", " ", 
                 RowBox[{"Cos", "[", "om", "]"}]}], "]"}]}], ",", 
              RowBox[{"{", 
               RowBox[{"om", ",", 
                RowBox[{"ArcSin", "[", 
                 RowBox[{"cv", "/", "x"}], "]"}], ",", 
                RowBox[{"Pi", "/", "2"}]}], "}"}]}], "]"}], ",", 
            RowBox[{"x", ">", "cv"}]}], "}"}]}], "}"}], "]"}], "/", " ", 
       RowBox[{"(", 
        RowBox[{"Pi", " ", 
         RowBox[{"BesselI", "[", 
          RowBox[{"0", ",", 
           RowBox[{"rho", " ", "x"}]}], "]"}]}], ")"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "c", ",", "d"}], "}"}]}], "]"}]}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"x_", "?", "NumberQ"}], ",", "rho_"}], "]"}], "=", 
  RowBox[{
   RowBox[{"BesselI", "[", 
    RowBox[{"0", ",", 
     RowBox[{"rho", " ", "x"}]}], "]"}], 
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}]}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"rho", "^", "2"}]}], ")"}]}], "]"}], 
   "x"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"B", "=", 
   RowBox[{"ParallelTable", "[", 
    RowBox[{
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"x", ",", 
         RowBox[{"grid", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"xgrid", "[", 
          RowBox[{"[", "j", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"xgrid", "[", 
           RowBox[{"[", "j", "]"}], "]"}], "+", "xdel"}]}], "}"}]}], "]"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "grid", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "1", ",", 
       RowBox[{"Length", "[", "xgrid", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"w", "[", 
    RowBox[{
     RowBox[{"c_", "?", "NumberQ"}], ",", "d_", ",", "rho_"}], "]"}], "=", 
   RowBox[{"Piecewise", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"d", "<", "cv"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NIntegrate", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"wi", "[", 
            RowBox[{"x", ",", "rho"}], "]"}], 
           RowBox[{"f", "[", 
            RowBox[{"x", ",", "rho"}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "c", ",", "d"}], "}"}]}], "]"}], ",", 
        RowBox[{"c", ">", "cv"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NIntegrate", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"wi", "[", 
            RowBox[{"x", ",", "rho"}], "]"}], 
           RowBox[{"f", "[", 
            RowBox[{"x", ",", "rho"}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "cv", ",", "d"}], "}"}]}], "]"}], ",", "True"}], 
       "}"}]}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"A0", "=", 
    RowBox[{"ParallelTable", "[", 
     RowBox[{
      RowBox[{"w", "[", 
       RowBox[{
        RowBox[{"xgrid", "[", 
         RowBox[{"[", "j", "]"}], "]"}], ",", 
        RowBox[{
         RowBox[{"xgrid", "[", 
          RowBox[{"[", "j", "]"}], "]"}], "+", "xdel"}], ",", 
        RowBox[{"grid", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"Length", "[", "grid", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "1", ",", 
        RowBox[{"Length", "[", "xgrid", "]"}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"bEW", "[", 
    RowBox[{"betlevel_", ",", "pi_"}], "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"A", "=", 
      RowBox[{"A0", "-", 
       RowBox[{"betlevel", " ", "B"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"cpi", "=", 
      RowBox[{"-", 
       RowBox[{"pi", ".", "A"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"xs", "=", 
      RowBox[{"LinearProgramming", "[", 
       RowBox[{"cpi", ",", "A", ",", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"10", "^", 
            RowBox[{"(", 
             RowBox[{"-", "8"}], ")"}]}]}], ",", 
          RowBox[{"{", 
           RowBox[{"Length", "[", "grid", "]"}], "}"}]}], "]"}], ",", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "1", ",", 
            RowBox[{"Length", "[", "xgrid", "]"}]}], "}"}]}], "]"}]}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"B", ".", "xs"}], ",", 
       RowBox[{
        RowBox[{"A", ".", "xs"}], "/", 
        RowBox[{"(", 
         RowBox[{"1", "-", "betlevel"}], ")"}]}]}], "}"}]}], ")"}]}], 
  "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.55282354280569*^9, 3.55282354307089*^9}, {
   3.55282381524409*^9, 3.55282391998249*^9}, 3.55282395243049*^9, {
   3.5528246453210897`*^9, 3.55282464580469*^9}, 3.55282496011349*^9, 
   3.55282501887869*^9, {3.5528260775892897`*^9, 3.55282610680809*^9}, {
   3.5528293929656897`*^9, 3.55282939491569*^9}, {3.6725718604998803`*^9, 
   3.6725718669635267`*^9}},ExpressionUUID->"572ffdef-de97-4b82-b24b-\
6f9813c2005b"],

Cell[BoxData["1.959963984540054`"], "Output",
 CellChangeTimes->{3.55282350885909*^9, 3.55282392790729*^9, 
  3.55282496037869*^9, 3.55282610721369*^9, 3.55282939656929*^9, 
  3.6720589642796907`*^9, 
  3.6725718799498253`*^9},ExpressionUUID->"c04ad22e-d956-494e-b559-\
0fc1538fca35"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"a", "<", "b"}], ",", 
   RowBox[{
    RowBox[{"CDF", "[", 
     RowBox[{
      RowBox[{"NormalDistribution", "[", 
       RowBox[{"0", ",", "1"}], "]"}], ",", "b"}], "]"}], "-", 
    RowBox[{"CDF", "[", 
     RowBox[{
      RowBox[{"NormalDistribution", "[", 
       RowBox[{"0", ",", "1"}], "]"}], ",", "a"}], "]"}]}], ",", "0"}], 
  "]"}]], "Output",
 CellChangeTimes->{3.55282350885909*^9, 3.55282392790729*^9, 
  3.55282496037869*^9, 3.55282610721369*^9, 3.55282939656929*^9, 
  3.6720589642796907`*^9, 
  3.672571880137844*^9},ExpressionUUID->"399738eb-0396-4718-834c-\
8da69bfd0546"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "nlim"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\(\\*RowBox[{\\\"om\\\"}]\\)\[NoBreak] = \[NoBreak]\
\\!\\(\\*RowBox[{\\\"ArcSin\\\", \\\"[\\\", \
FractionBox[\\\"1.959963984540054`\\\", \\\"x\\\"], \\\"]\\\"}]\\)\[NoBreak] \
is not a valid limit of integration. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/NIntegrate/nlim\\\", \
ButtonNote -> \\\"NIntegrate::nlim\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.55282350895269*^9, 3.55282392851569*^9, 
  3.55282496037869*^9, 3.55282610726049*^9, 3.55282939656929*^9, 
  3.6720589648177443`*^9, 
  3.672571880263857*^9},ExpressionUUID->"b4924839-e6f5-4a51-9cf1-\
4c69dcec9df8"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "nlim"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\(\\*RowBox[{\\\"om\\\"}]\\)\[NoBreak] = \[NoBreak]\
\\!\\(\\*RowBox[{\\\"ArcSin\\\", \\\"[\\\", \
FractionBox[\\\"1.959963984540054`\\\", \\\"x\\\"], \\\"]\\\"}]\\)\[NoBreak] \
is not a valid limit of integration. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/NIntegrate/nlim\\\", \
ButtonNote -> \\\"NIntegrate::nlim\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.55282350895269*^9, 3.55282392851569*^9, 
  3.55282496037869*^9, 3.55282610726049*^9, 3.55282939656929*^9, 
  3.6720589648177443`*^9, 
  3.6725718803008604`*^9},ExpressionUUID->"94025482-95b6-424d-819f-\
ceb6564a47e0"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["rho", "2"]}], "-", 
      SuperscriptBox["x", "2"]}], ")"}]}]], " ", "x", " ", 
  RowBox[{"BesselI", "[", 
   RowBox[{"0", ",", 
    RowBox[{"rho", " ", "x"}]}], "]"}]}]], "Output",
 CellChangeTimes->{3.55282350885909*^9, 3.55282392790729*^9, 
  3.55282496037869*^9, 3.55282610721369*^9, 3.55282939656929*^9, 
  3.6720589642796907`*^9, 
  3.6725718803018603`*^9},ExpressionUUID->"9ef3f172-78ac-45c7-b8d7-\
0924b0fca4ac"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "nlim"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\(\\*RowBox[{\\\"x\\\"}]\\)\[NoBreak] = \
\[NoBreak]\\!\\(\\*RowBox[{\\\"c\\\"}]\\)\[NoBreak] is not a valid limit of \
integration. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/nlim\\\", ButtonNote -> \
\\\"NIntegrate::nlim\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.55282350895269*^9, 3.55282392851569*^9, 
  3.55282496037869*^9, 3.55282610726049*^9, 3.55282939656929*^9, 
  3.6720589648177443`*^9, 
  3.672571887008531*^9},ExpressionUUID->"b9404f29-a7c2-4fb1-978b-\
9640183011bb"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "nlim"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\(\\*RowBox[{\\\"x\\\"}]\\)\[NoBreak] = \
\[NoBreak]\\!\\(\\*RowBox[{\\\"d\\\"}]\\)\[NoBreak] is not a valid limit of \
integration. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/nlim\\\", ButtonNote -> \
\\\"NIntegrate::nlim\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.55282350895269*^9, 3.55282392851569*^9, 
  3.55282496037869*^9, 3.55282610726049*^9, 3.55282939656929*^9, 
  3.6720589648177443`*^9, 
  3.672571887035534*^9},ExpressionUUID->"2b8de069-56ee-46e5-a6e7-\
b39c18551b67"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "nlim"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\(\\*RowBox[{\\\"x\\\"}]\\)\[NoBreak] = \
\[NoBreak]\\!\\(\\*RowBox[{\\\"c\\\"}]\\)\[NoBreak] is not a valid limit of \
integration. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/nlim\\\", ButtonNote -> \
\\\"NIntegrate::nlim\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.55282350895269*^9, 3.55282392851569*^9, 
  3.55282496037869*^9, 3.55282610726049*^9, 3.55282939656929*^9, 
  3.6720589648177443`*^9, 
  3.6725718870615363`*^9},ExpressionUUID->"6c20468a-9221-4b2d-9a87-\
c0e9ba9608c9"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], ":", 
  " ", "\<\"Further output of \
\[NoBreak]\\!\\(\\*StyleBox[RowBox[{\\\"NIntegrate\\\", \\\"::\\\", \
\\\"nlim\\\"}], \\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during \
this calculation. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/stop\\\", ButtonNote -> \
\\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.55282350895269*^9, 3.55282392851569*^9, 
  3.55282496037869*^9, 3.55282610726049*^9, 3.55282939656929*^9, 
  3.6720589648177443`*^9, 
  3.672571887088539*^9},ExpressionUUID->"4d473fb0-ee68-4569-9fb9-\
dad0404024a3"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "nlim"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\(\\*RowBox[{\\\"x\\\"}]\\)\[NoBreak] = \
\[NoBreak]\\!\\(\\*RowBox[{\\\"c\\\"}]\\)\[NoBreak] is not a valid limit of \
integration. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/nlim\\\", ButtonNote -> \
\\\"NIntegrate::nlim\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.55282350895269*^9, 3.55282392851569*^9, 
  3.55282496037869*^9, 3.55282610726049*^9, 3.55282939656929*^9, 
  3.6720589648177443`*^9, 
  3.6725718871235423`*^9},ExpressionUUID->"e81e10b8-5649-42fa-815a-\
71c691df98c0"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "nlim"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\(\\*RowBox[{\\\"x\\\"}]\\)\[NoBreak] = \
\[NoBreak]\\!\\(\\*RowBox[{\\\"d\\\"}]\\)\[NoBreak] is not a valid limit of \
integration. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/nlim\\\", ButtonNote -> \
\\\"NIntegrate::nlim\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.55282350895269*^9, 3.55282392851569*^9, 
  3.55282496037869*^9, 3.55282610726049*^9, 3.55282939656929*^9, 
  3.6720589648177443`*^9, 
  3.6725718871525455`*^9},ExpressionUUID->"360a7618-7957-48f0-a750-\
82c491940265"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "nlim"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\(\\*RowBox[{\\\"x\\\"}]\\)\[NoBreak] = \
\[NoBreak]\\!\\(\\*RowBox[{\\\"c\\\"}]\\)\[NoBreak] is not a valid limit of \
integration. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/nlim\\\", ButtonNote -> \
\\\"NIntegrate::nlim\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.55282350895269*^9, 3.55282392851569*^9, 
  3.55282496037869*^9, 3.55282610726049*^9, 3.55282939656929*^9, 
  3.6720589648177443`*^9, 
  3.672571887176548*^9},ExpressionUUID->"9fa0e7bc-9e1b-4c27-ae3e-\
3732b3de28a0"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], ":", 
  " ", "\<\"Further output of \
\[NoBreak]\\!\\(\\*StyleBox[RowBox[{\\\"NIntegrate\\\", \\\"::\\\", \
\\\"nlim\\\"}], \\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during \
this calculation. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/stop\\\", ButtonNote -> \
\\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.55282350895269*^9, 3.55282392851569*^9, 
  3.55282496037869*^9, 3.55282610726049*^9, 3.55282939656929*^9, 
  3.6720589648177443`*^9, 
  3.6725718871995497`*^9},ExpressionUUID->"cbfec1ef-a0f7-4b5d-886d-\
4182d89728fa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"bEW", "[", 
   RowBox[{"betlevel_", ",", "pi_"}], "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A", "=", 
     RowBox[{"A0", "-", 
      RowBox[{"betlevel", " ", "B"}]}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"cpi", "=", 
     RowBox[{"-", 
      RowBox[{"pi", ".", "A"}]}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"xs", "=", 
     RowBox[{"LinearProgramming", "[", 
      RowBox[{"cpi", ",", "A", ",", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"0", "*", 
          RowBox[{"10", "^", 
           RowBox[{"(", 
            RowBox[{"-", "8"}], ")"}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"Length", "[", "grid", "]"}], "}"}]}], "]"}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "xgrid", "]"}]}], "}"}]}], "]"}]}], "]"}]}],
     ";", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"B", ".", "xs"}], ",", 
      RowBox[{
       RowBox[{"A", ".", "xs"}], "/", 
       RowBox[{"(", 
        RowBox[{"1", "-", "betlevel"}], ")"}]}]}], "}"}]}], 
   ")"}]}], "\[IndentingNewLine]", 
 RowBox[{"bEW", "[", 
  RowBox[{"0.05", ",", 
   RowBox[{"Table", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"1", 
        RowBox[{"Length", "[", "grid", "]"}]}]}], "}"}]}], "]"}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.55282554612749*^9, 3.55282561456469*^9}, {
   3.55282565816669*^9, 3.5528256629246902`*^9}, 3.672065692993495*^9, {
   3.672065766113806*^9, 
   3.672065775423737*^9}},ExpressionUUID->"3743a51c-bb1e-4d3a-8893-\
60b15f56f28a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0.1353351759653059`", ",", "0.14074844038879503`", ",", 
     "0.1569811489809002`", ",", "0.18397168741433495`", ",", 
     "0.22149409565141853`", ",", "0.2690100950821316`", ",", 
     "0.3255271515308261`", ",", "0.38950902229378304`", ",", 
     "0.45887547201099166`", ",", "0.5311076425322103`", ",", 
     "0.6034496491999488`", ",", "0.6731722786318138`", ",", 
     "0.7378483038795098`", ",", "0.7955857938481421`", ",", 
     "0.8451766784799092`", ",", "0.8861390969356704`", ",", 
     "0.918656957509201`", ",", "0.9434413250809084`", ",", 
     "0.9615503428221472`", ",", "0.9742055661174731`", ",", 
     "0.9826346452690166`", ",", "0.9879574161777789`", ",", 
     "0.9911193168419686`", ",", "0.992866163619474`", ",", 
     "0.9937492214791435`", ",", "0.9941487957522531`", ",", 
     "0.9943066762070687`", ",", "0.9943608298035685`", ",", 
     "0.9943783843904912`", ",", "0.9943845821931381`", ",", 
     "0.9943861349356671`", ",", "0.994387791154945`", ",", 
     "0.9944014356222768`", ",", "0.9944479040729645`", ",", 
     "0.9945527741326439`", ",", "0.9947382911104883`", ",", 
     "0.9950138749390065`", ",", "0.9953670872517384`", ",", 
     "0.9957555887121632`", ",", "0.9960988803693738`", ",", 
     "0.9962671056134603`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.044511416966082185`", ",", "0.04424562366438208`", ",", 
     "0.04344643742977141`", ",", "0.04211096779414412`", ",", 
     "0.04024212771038636`", ",", "0.03785795200290458`", ",", 
     "0.03500065417937337`", ",", "0.03174263546010341`", ",", 
     "0.02818729064228238`", ",", "0.02446367954059212`", ",", 
     "0.02071564656887144`", ",", "0.017087368215534752`", ",", 
     "0.013708197174715532`", ",", "0.010679803795909331`", ",", 
     "0.008067971608196816`", ",", "0.00590020309888956`", ",", 
     "0.004168912092869019`", ",", "0.0028388204419911075`", ",", 
     "0.0018565277898092531`", ",", "0.0011601785666424155`", ",", 
     "0.0006876088969476766`", ",", "0.0003820870295388486`", ",", 
     "0.00019550406587369928`", ",", "0.00008942599795929604`", ",", 
     "0.000034690348435687734`", ",", "0.000010236972019073886`", ",", 
     "1.6928748204062313`*^-6", ",", 
     RowBox[{"-", "1.589925422677756`*^-17"}], ",", "1.7872622479462038`*^-7",
      ",", "2.1008538743658232`*^-7", ",", 
     RowBox[{"-", "5.185624864453695`*^-18"}], ",", "4.2741973123453763`*^-7",
      ",", "2.529250424421967`*^-6", ",", "6.899665249482295`*^-6", ",", 
     "0.000013361515749031886`", ",", "0.000020909227574464623`", ",", 
     "0.000027849604289190292`", ",", "0.000032009252570441095`", ",", 
     "0.00003085853746399809`", ",", "0.000021432128817888056`", ",", 
     "2.8317648847154293`*^-18"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.5528255735366898`*^9, 3.5528256168734903`*^9}, {
   3.55282565372069*^9, 3.55282566326789*^9}, 3.672065694666662*^9, 
   3.6720657769308877`*^9, 
   3.672571943217151*^9},ExpressionUUID->"bb207e26-a4b3-432c-bc45-\
e9cc2eb4dee3"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"average", "[", "betlevel_", "]"}], ":=", 
     RowBox[{"bEW", "[", 
      RowBox[{"betlevel", ",", 
       RowBox[{"Table", "[", 
        RowBox[{"1", ",", 
         RowBox[{"{", 
          RowBox[{"Length", "[", "grid", "]"}], "}"}]}], "]"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"env", "[", "betlevel_", "]"}], ":=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"pic", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"Boole", "[", 
            RowBox[{"i", "\[Equal]", "j"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"j", ",", "1", ",", 
             RowBox[{"Length", "[", "grid", "]"}]}], "}"}]}], "]"}]}], ";", 
        RowBox[{
         RowBox[{
          RowBox[{"bEW", "[", 
           RowBox[{"betlevel", ",", "pic"}], "]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}], ".", "pic"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", 
         RowBox[{"Length", "[", "grid", "]"}], ",", "1"}], "}"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.672065907205914*^9, 3.6720659268618793`*^9}, {
   3.6720659604412365`*^9, 3.67206600187938*^9}, {3.6720661240635977`*^9, 
   3.6720662125624466`*^9}, {3.67257164727756*^9, 3.6725716479976325`*^9}, 
   3.6725717406428957`*^9},ExpressionUUID->"57855f0f-e78d-4656-bdae-\
9ae9fe14407a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"env", "[", ".05", "]"}]], "Input",
 CellChangeTimes->{{3.672572050506879*^9, 
  3.6725720590017285`*^9}},ExpressionUUID->"0100bc25-faea-4984-b419-\
212f0a3fb4dd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.044511452196323166`", ",", "0.044245663881906455`", ",", 
   "0.04344649417955838`", ",", "0.04211105755805044`", ",", 
   "0.040242275859230514`", ",", "0.03785819738893696`", ",", 
   "0.03500105383048637`", ",", "0.031743267899373484`", ",", 
   "0.028726518791515242`", ",", "0.026010182669983745`", ",", 
   "0.023594931862553785`", ",", "0.021480827699453725`", ",", 
   "0.01968215251303952`", ",", "0.018210901677589604`", ",", 
   "0.016971924339279066`", ",", "0.01587989791506629`", ",", 
   "0.014912911495129105`", ",", "0.014052322573667456`", ",", 
   "0.013282406084097139`", ",", "0.012590113371385334`", ",", 
   "0.011964463075815385`", ",", "0.01139644349037462`", ",", 
   "0.010878539405528097`", ",", "0.010405506398051241`", ",", 
   "0.00997489316175588`", ",", "0.009575168118763844`", ",", 
   "0.009205868273597472`", ",", "0.008863689368698323`", ",", 
   "0.008545782040242166`", ",", "0.008249676697652256`", ",", 
   "0.007973221493818235`", ",", "0.007714529539301267`", ",", 
   "0.007471931101452331`", ",", "0.007243925255131241`", ",", 
   "0.007029122922046186`", ",", "0.006826169417447787`", ",", 
   "0.006634688388493697`", ",", "0.006454429318092123`", ",", 
   "0.006280322121226689`", ",", "0.006109368518848837`", ",", 
   "0.005937248886056387`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.6725720602718554`*^9},ExpressionUUID->"ca7185fd-33b6-4c40-adcb-\
f70f05210b04"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"style", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"AbsoluteThickness", "[", "1.4", "]"}], ",", "Black"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"AbsoluteThickness", "[", ".8", "]"}], ",", 
         RowBox[{"AbsoluteDashing", "[", 
          RowBox[{"{", 
           RowBox[{"2", ",", "2"}], "}"}], "]"}], ",", "Black"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"AbsoluteDashing", "[", 
          RowBox[{"{", 
           RowBox[{"8", ",", "2"}], "}"}], "]"}], ",", 
         RowBox[{"AbsoluteThickness", "[", ".8", "]"}], ",", "Black"}], "}"}],
        ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"AbsoluteDashing", "[", 
          RowBox[{"{", 
           RowBox[{"8", ",", "0"}], "}"}], "]"}], ",", 
         RowBox[{"AbsoluteThickness", "[", ".8", "]"}], ",", "Black"}], "}"}],
        ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"AbsoluteDashing", "[", 
          RowBox[{"{", 
           RowBox[{"2", ",", "2"}], "}"}], "]"}], ",", 
         RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", "Black"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"AbsoluteDashing", "[", 
          RowBox[{"{", 
           RowBox[{"8", ",", "0"}], "}"}], "]"}], ",", 
         RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", "Black"}], 
        "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pe", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pa", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"betlevels", "=", 
     RowBox[{"{", 
      RowBox[{"0.05", ",", "0.06", ",", "0.1", ",", ".5"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"betlevels", "=", 
     RowBox[{"{", "0.05", "}"}]}], "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"AppendTo", "[", 
       RowBox[{"pe", ",", 
        RowBox[{"ListPlot", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Table", "[", 
              RowBox[{
               RowBox[{"grid", "[", 
                RowBox[{"[", "i", "]"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"i", ",", "1", ",", 
                 RowBox[{"Length", "[", "grid", "]"}], ",", "1"}], "}"}]}], 
              "]"}], ",", 
             RowBox[{"100", 
              RowBox[{"env", "[", 
               RowBox[{"betlevels", "[", 
                RowBox[{"[", "ib", "]"}], "]"}], "]"}]}]}], "}"}], "]"}], ",", 
          RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
          RowBox[{"Joined", "\[Rule]", "True"}], ",", 
          RowBox[{"PlotStyle", "\[Rule]", 
           RowBox[{"style", "[", 
            RowBox[{"[", "ib", "]"}], "]"}]}], ",", 
          RowBox[{"LabelStyle", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"FontFamily", "\[Rule]", "\"\<Cmr10\>\""}], ",", 
             RowBox[{"FontSize", "\[Rule]", "15"}]}], "}"}]}], ",", 
          RowBox[{"AxesStyle", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"AbsoluteThickness", "[", ".8", "]"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"AbsoluteThickness", "[", ".8", "]"}], "}"}]}], 
            "}"}]}]}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"AppendTo", "[", 
       RowBox[{"pa", ",", 
        RowBox[{"ListPlot", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           RowBox[{"{", 
            RowBox[{"grid", ",", 
             RowBox[{"100", 
              RowBox[{
               RowBox[{"average", "[", 
                RowBox[{"betlevels", "[", 
                 RowBox[{"[", "ib", "]"}], "]"}], "]"}], "[", 
               RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}], "]"}], ",", 
          RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
          RowBox[{"Joined", "\[Rule]", "True"}], ",", 
          RowBox[{"PlotStyle", "\[Rule]", 
           RowBox[{"style", "[", 
            RowBox[{"[", "ib", "]"}], "]"}]}], ",", 
          RowBox[{"LabelStyle", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"FontFamily", "\[Rule]", "\"\<Cmr10\>\""}], ",", 
             RowBox[{"FontSize", "\[Rule]", "15"}]}], "}"}]}], ",", 
          RowBox[{"AxesStyle", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"AbsoluteThickness", "[", ".8", "]"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"AbsoluteThickness", "[", ".8", "]"}], "}"}]}], 
            "}"}]}]}], "]"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"ib", ",", "1", ",", 
       RowBox[{"Length", "[", "betlevels", "]"}]}], "}"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Show", "[", "pe", "]"}], "\[IndentingNewLine]", 
   RowBox[{"Show", "[", "pa", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.55282395553489*^9, 3.5528239573600903`*^9}, {
   3.55282407331489*^9, 3.55282425230929*^9}, {3.55282428761209*^9, 
   3.55282437550249*^9}, {3.5528244355780897`*^9, 3.5528244988526897`*^9}, 
   3.55282457566709*^9, 3.55282464301229*^9, {3.55282475230589*^9, 
   3.55282478061989*^9}, {3.5528251622894897`*^9, 3.55282516765589*^9}, {
   3.55282550240069*^9, 3.5528255314010897`*^9}, {3.5528257662912903`*^9, 
   3.55282579858329*^9}, {3.5528262504684896`*^9, 3.5528262593916903`*^9}, 
   3.6725717934751787`*^9, {3.672572133137141*^9, 
   3.6725721474415717`*^9}},ExpressionUUID->"ccd8a554-6205-438e-bf66-\
3ed13d6e51bd"],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[1.4], 
      LineBox[CompressedData["
1:eJxTTMoPSmViYGDQBGIQDQMargbMP88KOsyaCQIn7Z9yMnYc3ATj37TfdOnV
sdcJgg4mxiDw2D5yR4m0zg0BqPxL+8izR2TPSwg4QEz7YK9+5sftaE8+qPrP
9sd/uTqYM/A4pKeBwDf7K8fXFLKmckL1/7TP+dv7wuA3m8PZMyDwx/5Tsceq
R+dYoOYxODhe2PDN9gETVD2jw07FDyxu+oxQ85kdZHNq3c7X/reH6GdxSKiY
Waiv/NceYh+bw8dLrx02q/+2hxjH4fCv8Nzv9Iyf9hDzOB3k+vZLh9z5bg8x
j9uh9NSpi1eqv0HN43H4k51qWenwFWoenwPnrRShlypfoOYJOPzfof5oicpn
qHoBh9R/Tdt+W3+Cmi/oIP5nesfN9I9Q/UION7bX5Eos+wC1T9ihas2jbXmv
30PNE3G4q8Tj82vxO6h5Ig4b86Y0FpW+hZon6jC/qjFZKfYN1Dwxh8uCR5O3
RLyGmifukHjEZqZS2iuoeRIO8aL1e1c2v4SaJ+GgxvVRat/6F1DzJB1abla3
Mb58DjVPyqGm7KK1pd5zqHnSDtKm8a8d655BzZNxuLWCv+b/9adQ82QcuvbO
YFC2fgo1T9bh08HC9+XLn0DNk3NwuFHDdF3iCdQ8eYeUzhsFp3seQ81TcFCw
zQk7/f+RPQBiCxvn
       "]]}}, {}}, {{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[0.8], 
      AbsoluteDashing[{2, 2}], LineBox[CompressedData["
1:eJxTTMoPSmViYGDQBGIQDQMc8UJLX9++YD9rJgictH+v8ynuxBQY/6b9NJbD
ukLt5+1NjEHgsf2F5zx/t7w8A5V/aZ8Zu8JTgeeUPcS0D/ZdcvtOS/kdh6r/
bD93v6FgXOYR+/Q0EPhmz5IlUvvf6hBU/0/7W2yphv0FB+zPngGBP/bF+zqN
jv3eCzWPwcE1KOnkuabdUPWMDo+KjbNjM3dCzWd2kBXcwrp49XaofhaHa4HF
y+r3bIPax+bwtMV8psyMbVDzOBzeHV1+l5tzO9Q8Toeva9fMiNTaDjWP28Hf
hKst+uc2qHk8DrrZwhuYVsHM43OYyRlS6aIHM0/AYdKxzooXDVuh6gUc5oWx
LzZZsRVqvqDDLs6W3mDj7VD9Qg5qp9RiP/+CuV/YQeB48nZrsT1Q80QcfPby
/d6+ai/UPCDfZUbvnpX7oOaJOszLXfPf+O4+qHliDoebtT47+++DmifuMKHg
UPrZSFj4STise2vB/lFwP9Q8CYfdC1J4Xv05DDVP0uFGQIGANO9JqHlSDp/L
K2YIPTwLNU/aIVj73ZmQRxeg5sk4GGTfVT395SLUPBkHxsY8R5WTF6HmyTqs
vnrndeeNC1Dz5Byqokue/nkISz/yDrHtzOUSsueg5ik47PvTN2l5+Bl7ALQu
GJY=
       "]]}}, {}}, {{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[0.8], 
      AbsoluteDashing[{8, 2}], LineBox[CompressedData["
1:eJxdzTsKwkAQgOFVgyhK0Ph+a5na9PEMHkFQS8+jNxL0ANZWdoIgCBY6DMyy
/0AIPzv77WJzWG+Lzrn0/8mfczrKnPOwb9bZUuaO80ceKk/sv6z3O5k37n+s
rxeZLzy3CvcL1uqXrPV+ZK3vla11KvCq8Grw6vBieA3s+1a/ifsJ3mvBa8Pz
rV4HXhdeD14fnm/1BvCG8EbwxvB8qzeBN4U3gze3/gEItHX+
       "]]}}, {}}, {{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[0.8], 
      AbsoluteDashing[{8, 0}], LineBox[CompressedData["
1:eJxdzTsKwkAQgOFVgyhK0Ph+a5na9PEMHkFQS8+jNxL0ANZWdoIgCBY6DMyy
/0AIPzv77WJzWG+Lzrn0/8mfczrKnPOwb9bZUuaO80ceKk/sv6z3O5k37n+s
rxeZLzy3CvcL1uqXrPV+ZK3vla11KvCq8Grw6vBieA3s+1a/ifsJ3mvBa8Pz
rV4HXhdeD14fnm/1BvCG8EbwxvB8qzeBN4U3gze3/gEItHX+
       "]]}}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  AxesStyle->{{
     AbsoluteThickness[0.8]}, {
     AbsoluteThickness[0.8]}},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Cmr10", FontSize -> 15},
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 8.}, {0, 4.451145219632316}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.67206600527772*^9, 3.672066225641754*^9, 3.672571966233453*^9, {
   3.6725721394687743`*^9, 
   3.672572149397767*^9}},ExpressionUUID->"5e4427da-935a-4691-9ab8-\
c752795dfee8"],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[1.4], 
      LineBox[CompressedData["
1:eJxTTMoPSmViYGDQBGIQDQMBuofFfpwVdJg1EwRO2s+/LV11YBOMf9O+IE/Y
61WCoIOJMQg8tr/RwH9Q84YAVP6l/SK2fuvTEgIOENM+2OefL/nn58kHVf/Z
XtnM3keJgcchPQ0Evtmf/Gfu+SSFE6r/p/0TjZuXDvawOZw9AwJ/7OtDl8Zo
TmKGmsfgsINzee2ESQxQ9YwOZzc8yP4T9tseYj6zQwTnl+UP3n21h+hncdh+
1nBGkdhHe4h9bA4vbNrdPS6+tIcYx+HwL+aea9HDR/YQ8zgd/ihVlEesuwU1
j9uhPf/DdHntS1DzeBycrASTKw4fh5rH5zDvt/ySiM17oeYJOGyfV+0TMGsj
VL2Ag7WQRbD4hMVQ8wUdrOxXTWZlnQLVL+TAmhCYWx/QBLVP2MHQvvSZeHYO
1DwRh/BMk4ZNRwOg5ok4VE15mBphoAY1T9QhR2P9Qpsld/ZAzBNzaF98yHnp
3k92EPPEHTZ0Sp7KZ/9mBzFPwiHOuZL36bpDeyDmSTjcfdfNvDuDDWqepEPj
V7mTCZMNoO6TcthcXnXl9mw3qPukHZg+uVyxfBIKdZ+Mw0GGybN/KyRC3Sfj
sOjQebuaC2lQ82QdghIrVl62yIKaJ+cgwFMp2+ieCTVP3iEnv2v5kr5EqHkK
DtKnsjXWp2+xAQCGNwui
       "]]}}, {}}, {{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[0.8], 
      AbsoluteDashing[{2, 2}], LineBox[CompressedData["
1:eJxTTMoPSmViYGDQBGIQDQMn7v/r1OM6Zj9rJgictL/9Nb2p6cpRKP+mfUSP
1GVbw6P2JsYg8NieS+jdHy/pI1D5l/YTb8uvse4/ZA8x7YP9lFKJQpmJB6Dq
P9sfur1B1yR5j316Ggh8s//kl3TuucJ2qP6f9lW/tj1evXWj/dkzIPDHfpZM
9fs00ZVQ8xgcsmWUN2pzL4CqZ3Q4uKq9ivHCRKj5zA4K6ge7TbfVQ/WzOFwO
urxvhVUS1D42B+MbKQc2HGCHmsfhcOQJV1KR6/I9EPM4Hdb//MOwWdYbah63
w4ZjYbN5HSOh5vE4bGTV2HPgZxTUPD6HlCcfdwWIBUPNE3DQWijyw+iuHVS9
gENzl2KZxZbrdhDzBWH22UD0Czn8/7bqXd4LU6h9wg6Tsp5MSHZygZon4hAj
83utxhV7qHkiDkWshjubZuyygZgn6nBSFGii0x6oeWIOwskyK2/wJUHNE3eI
zImcFx3eBDVPwiHBwma6jMp0qHkSDne2PlYKvLEMGp6SDgl3p3Q0q2yG+k/K
Ie38u/gFnnug5kk71N+UODTnJCx+ZRx2N7FNvTHnGNQ8GYdJfNoecXNPQM2T
dTA4MCne9tZxqHlyDi/bHjrxLjwMNU/eQedImORu5+1Q8xQckkAe1Dq/BwBe
DhLt
       "]]}}, {}}, {{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[0.8], 
      AbsoluteDashing[{8, 2}], LineBox[CompressedData["
1:eJxdzTsKwkAQgOFVgyhK0Ph+a5na9PEMHkFQS8+jNxL0ANZWdoIgCBY6DMyy
/0AIPzv77WJzWG+Lzrn0/8mfczrKnPOwb9bZUuaO80ceKk/sv6z3O5k37n+s
rxeZLzy3CvcL1uqXrPV+ZK3vla11KvCq8Grw6vBieA3s+1a/ifsJ3mvBa8Pz
rV4HXhdeD14fnm/1BvCG8EbwxvB8qzeBN4U3gze3/gEItHX+
       "]]}}, {}}, {{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[0.8], 
      AbsoluteDashing[{8, 0}], LineBox[CompressedData["
1:eJxdzTsKwkAQgOFVgyhK0Ph+a5na9PEMHkFQS8+jNxL0ANZWdoIgCBY6DMyy
/0AIPzv77WJzWG+Lzrn0/8mfczrKnPOwb9bZUuaO80ceKk/sv6z3O5k37n+s
rxeZLzy3CvcL1uqXrPV+ZK3vla11KvCq8Grw6vBieA3s+1a/ifsJ3mvBa8Pz
rV4HXhdeD14fnm/1BvCG8EbwxvB8qzeBN4U3gze3/gEItHX+
       "]]}}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  AxesStyle->{{
     AbsoluteThickness[0.8]}, {
     AbsoluteThickness[0.8]}},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Cmr10", FontSize -> 15},
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 8.}, {-1.5899254226777562`*^-15, 4.451141696608218}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.67206600527772*^9, 3.672066225641754*^9, 3.672571966233453*^9, {
   3.6725721394687743`*^9, 
   3.672572149403768*^9}},ExpressionUUID->"26064ac7-4807-4ae9-8e06-\
d88a8d47564e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Show", "[", 
       RowBox[{"pa", ",", 
        RowBox[{"PlotRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"0", ",", "5"}], "}"}]}]}], "]"}], ",", 
      RowBox[{"Show", "[", 
       RowBox[{"pe", ",", 
        RowBox[{"PlotRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"0", ",", "5"}], "}"}]}]}], "]"}]}], "}"}], "}"}], ",", 
   RowBox[{"Spacings", "\[Rule]", 
    RowBox[{"Scaled", "[", 
     RowBox[{"-", "0.05"}], "]"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.55282910355449*^9, 3.5528291481236897`*^9}, {
   3.55282917901169*^9, 3.55282917918329*^9}, {3.55282920988409*^9, 
   3.55282921027409*^9}, {3.55282924030409*^9, 3.55282925871209*^9}, {
   3.6720660552257147`*^9, 3.672066061721364*^9}, {3.6720662810582952`*^9, 
   3.6720662811213017`*^9}, 3.6725718032171526`*^9, 
   3.67257216332616*^9},ExpressionUUID->"58395b9d-5f9c-4f7b-97df-\
cb6e88fa3a28"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{{{}, {{}, {}, 
         {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[
          1.4], LineBox[CompressedData["
1:eJxTTMoPSmViYGDQBGIQDQMBuofFfpwVdJg1EwRO2s+/LV11YBOMf9O+IE/Y
61WCoIOJMQg8tr/RwH9Q84YAVP6l/SK2fuvTEgIOENM+2OefL/nn58kHVf/Z
XtnM3keJgcchPQ0Evtmf/Gfu+SSFE6r/p/0TjZuXDvawOZw9AwJ/7OtDl8Zo
TmKGmsfgsINzee2ESQxQ9YwOZzc8yP4T9tseYj6zQwTnl+UP3n21h+hncdh+
1nBGkdhHe4h9bA4vbNrdPS6+tIcYx+HwL+aea9HDR/YQ8zgd/ihVlEesuwU1
j9uhPf/DdHntS1DzeBycrASTKw4fh5rH5zDvt/ySiM17oeYJOGyfV+0TMGsj
VL2Ag7WQRbD4hMVQ8wUdrOxXTWZlnQLVL+TAmhCYWx/QBLVP2MHQvvSZeHYO
1DwRh/BMk4ZNRwOg5ok4VE15mBphoAY1T9QhR2P9Qpsld/ZAzBNzaF98yHnp
3k92EPPEHTZ0Sp7KZ/9mBzFPwiHOuZL36bpDeyDmSTjcfdfNvDuDDWqepEPj
V7mTCZMNoO6TcthcXnXl9mw3qPukHZg+uVyxfBIKdZ+Mw0GGybN/KyRC3Sfj
sOjQebuaC2lQ82QdghIrVl62yIKaJ+cgwFMp2+ieCTVP3iEnv2v5kr5EqHkK
DtKnsjXWp2+xAQCGNwui
           "]]}}, {}}, {{}, {{}, {}, 
         {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[
          0.8], AbsoluteDashing[{2, 2}], LineBox[CompressedData["
1:eJxTTMoPSmViYGDQBGIQDQMn7v/r1OM6Zj9rJgictL/9Nb2p6cpRKP+mfUSP
1GVbw6P2JsYg8NieS+jdHy/pI1D5l/YTb8uvse4/ZA8x7YP9lFKJQpmJB6Dq
P9sfur1B1yR5j316Ggh8s//kl3TuucJ2qP6f9lW/tj1evXWj/dkzIPDHfpZM
9fs00ZVQ8xgcsmWUN2pzL4CqZ3Q4uKq9ivHCRKj5zA4K6ge7TbfVQ/WzOFwO
urxvhVUS1D42B+MbKQc2HGCHmsfhcOQJV1KR6/I9EPM4Hdb//MOwWdYbah63
w4ZjYbN5HSOh5vE4bGTV2HPgZxTUPD6HlCcfdwWIBUPNE3DQWijyw+iuHVS9
gENzl2KZxZbrdhDzBWH22UD0Czn8/7bqXd4LU6h9wg6Tsp5MSHZygZon4hAj
83utxhV7qHkiDkWshjubZuyygZgn6nBSFGii0x6oeWIOwskyK2/wJUHNE3eI
zImcFx3eBDVPwiHBwma6jMp0qHkSDne2PlYKvLEMGp6SDgl3p3Q0q2yG+k/K
Ie38u/gFnnug5kk71N+UODTnJCx+ZRx2N7FNvTHnGNQ8GYdJfNoecXNPQM2T
dTA4MCne9tZxqHlyDi/bHjrxLjwMNU/eQedImORu5+1Q8xQckkAe1Dq/BwBe
DhLt
           "]]}}, {}}, {{}, {{}, {}, 
         {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[
          0.8], AbsoluteDashing[{8, 2}], LineBox[CompressedData["
1:eJxdzTsKwkAQgOFVgyhK0Ph+a5na9PEMHkFQS8+jNxL0ANZWdoIgCBY6DMyy
/0AIPzv77WJzWG+Lzrn0/8mfczrKnPOwb9bZUuaO80ceKk/sv6z3O5k37n+s
rxeZLzy3CvcL1uqXrPV+ZK3vla11KvCq8Grw6vBieA3s+1a/ifsJ3mvBa8Pz
rV4HXhdeD14fnm/1BvCG8EbwxvB8qzeBN4U3gze3/gEItHX+
           "]]}}, {}}, {{}, {{}, {}, 
         {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[
          0.8], AbsoluteDashing[{8, 0}], LineBox[CompressedData["
1:eJxdzTsKwkAQgOFVgyhK0Ph+a5na9PEMHkFQS8+jNxL0ANZWdoIgCBY6DMyy
/0AIPzv77WJzWG+Lzrn0/8mfczrKnPOwb9bZUuaO80ceKk/sv6z3O5k37n+s
rxeZLzy3CvcL1uqXrPV+ZK3vla11KvCq8Grw6vBieA3s+1a/ifsJ3mvBa8Pz
rV4HXhdeD14fnm/1BvCG8EbwxvB8qzeBN4U3gze3/gEItHX+
           "]]}}, {}}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      AxesStyle->{{
         AbsoluteThickness[0.8]}, {
         AbsoluteThickness[0.8]}},
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      LabelStyle->{FontFamily -> "Cmr10", FontSize -> 15},
      Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
             Part[#, 1]], 
            (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
             Part[#, 1]], 
            (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{0, 5},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}], {174., -108.46496502560653}, 
     ImageScaled[{0.5, 0.5}], {360., 222.49223594996212}], InsetBox[
     GraphicsBox[{{{}, {{}, {}, 
         {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[
          1.4], LineBox[CompressedData["
1:eJxTTMoPSmViYGDQBGIQDQMargbMP88KOsyaCQIn7Z9yMnYc3ATj37TfdOnV
sdcJgg4mxiDw2D5yR4m0zg0BqPxL+8izR2TPSwg4QEz7YK9+5sftaE8+qPrP
9sd/uTqYM/A4pKeBwDf7K8fXFLKmckL1/7TP+dv7wuA3m8PZMyDwx/5Tsceq
R+dYoOYxODhe2PDN9gETVD2jw07FDyxu+oxQ85kdZHNq3c7X/reH6GdxSKiY
Waiv/NceYh+bw8dLrx02q/+2hxjH4fCv8Nzv9Iyf9hDzOB3k+vZLh9z5bg8x
j9uh9NSpi1eqv0HN43H4k51qWenwFWoenwPnrRShlypfoOYJOPzfof5oicpn
qHoBh9R/Tdt+W3+Cmi/oIP5nesfN9I9Q/UION7bX5Eos+wC1T9ihas2jbXmv
30PNE3G4q8Tj82vxO6h5Ig4b86Y0FpW+hZon6jC/qjFZKfYN1Dwxh8uCR5O3
RLyGmifukHjEZqZS2iuoeRIO8aL1e1c2v4SaJ+GgxvVRat/6F1DzJB1abla3
Mb58DjVPyqGm7KK1pd5zqHnSDtKm8a8d655BzZNxuLWCv+b/9adQ82QcuvbO
YFC2fgo1T9bh08HC9+XLn0DNk3NwuFHDdF3iCdQ8eYeUzhsFp3seQ81TcFCw
zQk7/f+RPQBiCxvn
           "]]}}, {}}, {{}, {{}, {}, 
         {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[
          0.8], AbsoluteDashing[{2, 2}], LineBox[CompressedData["
1:eJxTTMoPSmViYGDQBGIQDQMc8UJLX9++YD9rJgictH+v8ynuxBQY/6b9NJbD
ukLt5+1NjEHgsf2F5zx/t7w8A5V/aZ8Zu8JTgeeUPcS0D/ZdcvtOS/kdh6r/
bD93v6FgXOYR+/Q0EPhmz5IlUvvf6hBU/0/7W2yphv0FB+zPngGBP/bF+zqN
jv3eCzWPwcE1KOnkuabdUPWMDo+KjbNjM3dCzWd2kBXcwrp49XaofhaHa4HF
y+r3bIPax+bwtMV8psyMbVDzOBzeHV1+l5tzO9Q8Toeva9fMiNTaDjWP28Hf
hKst+uc2qHk8DrrZwhuYVsHM43OYyRlS6aIHM0/AYdKxzooXDVuh6gUc5oWx
LzZZsRVqvqDDLs6W3mDj7VD9Qg5qp9RiP/+CuV/YQeB48nZrsT1Q80QcfPby
/d6+ai/UPCDfZUbvnpX7oOaJOszLXfPf+O4+qHliDoebtT47+++DmifuMKHg
UPrZSFj4STise2vB/lFwP9Q8CYfdC1J4Xv05DDVP0uFGQIGANO9JqHlSDp/L
K2YIPTwLNU/aIVj73ZmQRxeg5sk4GGTfVT395SLUPBkHxsY8R5WTF6HmyTqs
vnrndeeNC1Dz5Byqokue/nkISz/yDrHtzOUSsueg5ik47PvTN2l5+Bl7ALQu
GJY=
           "]]}}, {}}, {{}, {{}, {}, 
         {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[
          0.8], AbsoluteDashing[{8, 2}], LineBox[CompressedData["
1:eJxdzTsKwkAQgOFVgyhK0Ph+a5na9PEMHkFQS8+jNxL0ANZWdoIgCBY6DMyy
/0AIPzv77WJzWG+Lzrn0/8mfczrKnPOwb9bZUuaO80ceKk/sv6z3O5k37n+s
rxeZLzy3CvcL1uqXrPV+ZK3vla11KvCq8Grw6vBieA3s+1a/ifsJ3mvBa8Pz
rV4HXhdeD14fnm/1BvCG8EbwxvB8qzeBN4U3gze3/gEItHX+
           "]]}}, {}}, {{}, {{}, {}, 
         {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[
          0.8], AbsoluteDashing[{8, 0}], LineBox[CompressedData["
1:eJxdzTsKwkAQgOFVgyhK0Ph+a5na9PEMHkFQS8+jNxL0ANZWdoIgCBY6DMyy
/0AIPzv77WJzWG+Lzrn0/8mfczrKnPOwb9bZUuaO80ceKk/sv6z3O5k37n+s
rxeZLzy3CvcL1uqXrPV+ZK3vla11KvCq8Grw6vBieA3s+1a/ifsJ3mvBa8Pz
rV4HXhdeD14fnm/1BvCG8EbwxvB8qzeBN4U3gze3/gEItHX+
           "]]}}, {}}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      AxesStyle->{{
         AbsoluteThickness[0.8]}, {
         AbsoluteThickness[0.8]}},
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      LabelStyle->{FontFamily -> "Cmr10", FontSize -> 15},
      Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
             Part[#, 1]], 
            (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
             Part[#, 1]], 
            (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{0, 5},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}], {522., -108.46496502560653}, 
     ImageScaled[{0.5, 0.5}], {360., 222.49223594996212}]}, {}},
  ContentSelectable->True,
  ImageSize->600,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{
  3.55282912005929*^9, {3.55282915286609*^9, 3.55282917991649*^9}, 
   3.55282921088249*^9, {3.5528292488996897`*^9, 3.55282925900849*^9}, 
   3.5528294695148897`*^9, {3.672066050719264*^9, 3.672066062474439*^9}, {
   3.672066272842474*^9, 3.6720662817873683`*^9}, 
   3.672572167142542*^9},ExpressionUUID->"c95f7a0a-c57c-460b-9c46-\
316f69705b08"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"pb", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pcrp", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"betlevels", "=", 
     RowBox[{"{", 
      RowBox[{"0.05", ",", "0.06", ",", "0.1", ",", ".5"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"betlevels", "=", 
     RowBox[{"{", "0.05", "}"}]}], "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"style", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"AbsoluteThickness", "[", "1.4", "]"}], ",", "Black"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"AbsoluteThickness", "[", ".8", "]"}], ",", 
         RowBox[{"AbsoluteDashing", "[", 
          RowBox[{"{", 
           RowBox[{"2", ",", "2"}], "}"}], "]"}], ",", "Black"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"AbsoluteDashing", "[", 
          RowBox[{"{", 
           RowBox[{"8", ",", "2"}], "}"}], "]"}], ",", 
         RowBox[{"AbsoluteThickness", "[", ".8", "]"}], ",", "Black"}], "}"}],
        ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"AbsoluteDashing", "[", 
          RowBox[{"{", 
           RowBox[{"8", ",", "0"}], "}"}], "]"}], ",", 
         RowBox[{"AbsoluteThickness", "[", ".8", "]"}], ",", "Black"}], "}"}],
        ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"AbsoluteDashing", "[", 
          RowBox[{"{", 
           RowBox[{"2", ",", "2"}], "}"}], "]"}], ",", 
         RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", "Black"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"AbsoluteDashing", "[", 
          RowBox[{"{", 
           RowBox[{"8", ",", "0"}], "}"}], "]"}], ",", 
         RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", "Black"}], 
        "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"xx", "=", 
       RowBox[{"average", "[", 
        RowBox[{"betlevels", "[", 
         RowBox[{"[", "ib", "]"}], "]"}], "]"}]}], ";", 
      RowBox[{"cbl", "=", 
       RowBox[{"betlevels", "[", 
        RowBox[{"[", "ib", "]"}], "]"}]}], ";", 
      RowBox[{"AppendTo", "[", 
       RowBox[{"pb", ",", 
        RowBox[{"ListPlot", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           RowBox[{"{", 
            RowBox[{"grid", ",", 
             RowBox[{"100", 
              RowBox[{"xx", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}]}], "}"}], "]"}], ",", 
          RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
          RowBox[{"Joined", "\[Rule]", "True"}], ",", 
          RowBox[{"PlotStyle", "\[Rule]", 
           RowBox[{"style", "[", 
            RowBox[{"[", "ib", "]"}], "]"}]}], ",", 
          RowBox[{"LabelStyle", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"FontFamily", "\[Rule]", "\"\<Cmr10\>\""}], ",", 
             RowBox[{"FontSize", "\[Rule]", "15"}]}], "}"}]}], ",", 
          RowBox[{"AxesStyle", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"AbsoluteThickness", "[", ".8", "]"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"AbsoluteThickness", "[", ".8", "]"}], "}"}]}], 
            "}"}]}]}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"AppendTo", "[", 
       RowBox[{"pcrp", ",", 
        RowBox[{"ListPlot", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           RowBox[{"{", 
            RowBox[{"grid", ",", 
             RowBox[{"100", 
              RowBox[{"(", 
               RowBox[{"cbl", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "cbl"}], ")"}], 
                 RowBox[{
                  RowBox[{"xx", "[", 
                   RowBox[{"[", "2", "]"}], "]"}], "/", 
                  RowBox[{"xx", "[", 
                   RowBox[{"[", "1", "]"}], "]"}]}]}]}], ")"}]}]}], "}"}], 
           "]"}], ",", 
          RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
          RowBox[{"Joined", "\[Rule]", "True"}], ",", 
          RowBox[{"PlotStyle", "\[Rule]", 
           RowBox[{"style", "[", 
            RowBox[{"[", "ib", "]"}], "]"}]}], ",", 
          RowBox[{"LabelStyle", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"FontFamily", "\[Rule]", "\"\<Cmr10\>\""}], ",", 
             RowBox[{"FontSize", "\[Rule]", "15"}]}], "}"}]}], ",", 
          RowBox[{"AxesStyle", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"AbsoluteThickness", "[", ".8", "]"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"AbsoluteThickness", "[", ".8", "]"}], "}"}]}], 
            "}"}]}]}], "]"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"ib", ",", "1", ",", 
       RowBox[{"Length", "[", "betlevels", "]"}]}], "}"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"pfin", "=", 
    RowBox[{"GraphicsGrid", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Show", "[", 
          RowBox[{"pb", ",", 
           RowBox[{"PlotRange", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"0", ",", "100"}], "}"}]}]}], "]"}], ",", 
         RowBox[{"Show", "[", 
          RowBox[{"pcrp", ",", 
           RowBox[{"PlotRange", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"0", ",", "45"}], "}"}]}]}], "]"}]}], "}"}], "}"}], ",", 
      RowBox[{"Spacings", "\[Rule]", 
       RowBox[{"Scaled", "[", 
        RowBox[{"-", "0.00"}], "]"}]}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.67257175918575*^9, {3.6725718200668373`*^9, 3.672571844612292*^9}, {
   3.672572178190646*^9, 3.672572251922019*^9}, {3.672572331300956*^9, 
   3.672572332710097*^9}},ExpressionUUID->"8d94d83a-ab3e-4f5c-a9b7-\
043d4e96240e"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Power", "::", "infy"}], "MessageName"], ":", 
  " ", "\<\"Infinite expression \[NoBreak]\\!\\(\\*FractionBox[\\\"1\\\", \
\\\"0.`\\\"]\\)\[NoBreak] encountered. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/infy\\\", \
ButtonNote -> \\\"Power::infy\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.672572199199747*^9, {3.672572239583785*^9, 3.6725722532011466`*^9}, 
   3.672572333356161*^9},ExpressionUUID->"44e9ffae-9205-4629-a02b-\
65334844a8c9"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Power", "::", "infy"}], "MessageName"], ":", 
  " ", "\<\"Infinite expression \[NoBreak]\\!\\(\\*FractionBox[\\\"1\\\", \
\\\"0.`\\\"]\\)\[NoBreak] encountered. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/infy\\\", \
ButtonNote -> \\\"Power::infy\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.672572199199747*^9, {3.672572239583785*^9, 3.6725722532011466`*^9}, 
   3.6725723333991656`*^9},ExpressionUUID->"2c942383-d67e-4909-9c45-\
dc36756314b4"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Power", "::", "infy"}], "MessageName"], ":", 
  " ", "\<\"Infinite expression \[NoBreak]\\!\\(\\*FractionBox[\\\"1\\\", \
\\\"0.`\\\"]\\)\[NoBreak] encountered. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/infy\\\", \
ButtonNote -> \\\"Power::infy\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.672572199199747*^9, {3.672572239583785*^9, 3.6725722532011466`*^9}, 
   3.67257233344217*^9},ExpressionUUID->"719411b2-bfc3-4ffd-b9f0-\
977fa446cf2a"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], ":", 
  " ", "\<\"Further output of \[NoBreak]\\!\\(\\*StyleBox[RowBox[{\\\"Power\\\
\", \\\"::\\\", \\\"infy\\\"}], \\\"MessageName\\\"]\\)\[NoBreak] will be \
suppressed during this calculation. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\
\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/stop\\\", ButtonNote -> \
\\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.672572199199747*^9, {3.672572239583785*^9, 3.6725722532011466`*^9}, 
   3.6725723334651723`*^9},ExpressionUUID->"ff20c20f-4c7b-4841-b4b1-\
03957623fdb5"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Infinity", "::", "indet"}], "MessageName"], ":", 
  " ", "\<\"Indeterminate expression \[NoBreak]\\!\\(\\*RowBox[{\\\"0.`\\\", \
\\\" \\\", \\\"ComplexInfinity\\\"}]\\)\[NoBreak] encountered. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/indet\\\", \
ButtonNote -> \\\"Infinity::indet\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.672572199199747*^9, {3.672572239583785*^9, 3.6725722532011466`*^9}, 
   3.6725723335101767`*^9},ExpressionUUID->"41914628-b1c8-4121-b96b-\
482f628ae861"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Infinity", "::", "indet"}], "MessageName"], ":", 
  " ", "\<\"Indeterminate expression \[NoBreak]\\!\\(\\*RowBox[{\\\"0.`\\\", \
\\\" \\\", \\\"ComplexInfinity\\\"}]\\)\[NoBreak] encountered. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/indet\\\", \
ButtonNote -> \\\"Infinity::indet\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.672572199199747*^9, {3.672572239583785*^9, 3.6725722532011466`*^9}, 
   3.6725723335531807`*^9},ExpressionUUID->"00656c58-40f2-47f8-8415-\
adc4c500d3f8"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Infinity", "::", "indet"}], "MessageName"], ":", 
  " ", "\<\"Indeterminate expression \[NoBreak]\\!\\(\\*RowBox[{\\\"0.`\\\", \
\\\" \\\", \\\"ComplexInfinity\\\"}]\\)\[NoBreak] encountered. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/indet\\\", \
ButtonNote -> \\\"Infinity::indet\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.672572199199747*^9, {3.672572239583785*^9, 3.6725722532011466`*^9}, 
   3.6725723335951853`*^9},ExpressionUUID->"953ac339-ca5d-45ba-ad42-\
b813b27055de"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], ":", 
  " ", "\<\"Further output of \
\[NoBreak]\\!\\(\\*StyleBox[RowBox[{\\\"Infinity\\\", \\\"::\\\", \\\"indet\\\
\"}], \\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during this \
calculation. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/stop\\\", ButtonNote -> \
\\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.672572199199747*^9, {3.672572239583785*^9, 3.6725722532011466`*^9}, 
   3.672572333618188*^9},ExpressionUUID->"30fd6adf-6396-4c10-92d6-\
316a27f28e0a"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{{{}, {{}, {}, 
         {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[
          1.4], LineBox[CompressedData["
1:eJxTTMoPSmViYGDQBGIQDQO/Hrw01xTUdpg1EwRO2pdPNvsaqKYD5d+0d/V+
EJCfqu9gYgwCj+29ig/fXJNqBJV/aZ/zr3uLvZqZA8S0D/ZSmsr9K55ZQdV/
tte0Pxi3383BIT0NBL7Zn8jn0dpe6QzV/9Pey6BXdfZHN4ezZ0Dgj73V5Get
un1eUPMYHGZcqjmvruMHVc/oMC9fosz3SgDUfGYHFi+blVZFQVD9LA5n6vcf
3v84GGofm8Pn4OAKRcVQqHkcDuEqj7y91MOg5nE6WM9X60//HgY1j9sh7X2U
C9u0cKh5PA4Hvr8QecMZATWPz2FCinvaq6gIqHkCDjvWBM66MyECql7AgVXa
Ie/tpgio+YIOBw40PdY8DtMv5MDoov4m/FIE1D5hh6Vfy3b+uw4zT8ThwHX+
5N5bMPNEHEpnvOGbcBtmnqhD6r5pJ17chpkn5lCs2dLNegdmnrhDvLrAZv47
MPMkHJjnhtgJ3YGZJ+Fw7+z/LyJ3YOZJOrCGPPfXvgMzT8oh20q/qBxunrTD
P5UHzsp3YebJONh+CzUPvgczT8bB33rSbrEHMPNkHeLaevMjH8HMk3P4Z/Tg
y9UnMPPkHTrMr6ZzPIeZp+BQ7zSXTeZFhAMAOxMI4A==
           "]]}}, {}}, {{}, {{}, {}, 
         {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[
          0.8], AbsoluteDashing[{2, 2}], LineBox[CompressedData["
1:eJxTTMoPSmViYGDQBGIQDQOvdENnbk28Yz9rJgictJdIyPmkOfMulH/Tfu2b
ZIeuuQ/sTYxB4LH99gxbjZbZj6HyL+0NGCSe+G15bg8x7YP9tysXo/4eewNV
/9m+1ZpRMyPgo316Ggh8sz+xoiKAvf4LVP9P+zoT0SsSJ77bnz0DAn/sPYLm
J0xg+Q01j8Gh++CcE/NE/kHVMzpUWtXZSRczOEDMZ3aYauvjV7qH0QGin8Vh
Q9TyzDPvmBwg9rE5pAd/vXpegsUBYhyHQ1lK9+1mb1YHiHmcDnMvXVimNY0N
ah63Q1qE2ec2Zg6oeTwOrlvf5zcD1UHM43Mom6uo7hnNDTVPwGHa798+63x4
oeoFHIzTlkvpl/JDzRd0+B9S7ZL0QQCqX8gh3HpuG5O/ENQ+YYf873udIu8K
Q80TcbjDcerKrgWiUPNEHNSeqLBIzROHmifqYBzPzXPyniTUPDGHt5/V+R9X
yEDNE3eo2fPv3qGZ8lDzJBwkXriuXHtcEWqehMPdLVmK1mkqUPMkHVr/d19Q
+aQONU/K4QSbh//xvTpQ86Qd3r0x3/6v2xBqnozDj1m6nNXzTKHmyThwbuTu
nr7YCmqerMON4HP7mDwdoObJOay8HXx8z2JnqHnyDv3rzE+qurpDzVNwOPn9
FnMtu7cDAIe9CXU=
           "]]}}, {}}, {{}, {{}, {}, 
         {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[
          0.8], AbsoluteDashing[{8, 2}], LineBox[CompressedData["
1:eJxdzTsKwkAQgOFVgyhK0Ph+a5na9PEMHkFQS8+jNxL0ANZWdoIgCBY6DMyy
/0AIPzv77WJzWG+Lzrn0/8mfczrKnPOwb9bZUuaO80ceKk/sv6z3O5k37n+s
rxeZLzy3CvcL1uqXrPV+ZK3vla11KvCq8Grw6vBieA3s+1a/ifsJ3mvBa8Pz
rV4HXhdeD14fnm/1BvCG8EbwxvB8qzeBN4U3gze3/gEItHX+
           "]]}}, {}}, {{}, {{}, {}, 
         {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[
          0.8], AbsoluteDashing[{8, 0}], LineBox[CompressedData["
1:eJxdzTsKwkAQgOFVgyhK0Ph+a5na9PEMHkFQS8+jNxL0ANZWdoIgCBY6DMyy
/0AIPzv77WJzWG+Lzrn0/8mfczrKnPOwb9bZUuaO80ceKk/sv6z3O5k37n+s
rxeZLzy3CvcL1uqXrPV+ZK3vla11KvCq8Grw6vBieA3s+1a/ifsJ3mvBa8Pz
rV4HXhdeD14fnm/1BvCG8EbwxvB8qzeBN4U3gze3/gEItHX+
           "]]}}, {}}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      AxesStyle->{{
         AbsoluteThickness[0.8]}, {
         AbsoluteThickness[0.8]}},
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      LabelStyle->{FontFamily -> "Cmr10", FontSize -> 15},
      Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
             Part[#, 1]], 
            (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
             Part[#, 1]], 
            (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{0, 100},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}], {180., -111.24611797498106}, 
     ImageScaled[{0.5, 0.5}], {360., 222.49223594996212}], InsetBox[
     GraphicsBox[{{{}, {{}, {}, 
         {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[
          1.4], LineBox[CompressedData["
1:eJxTTMoPSmViYGDQBGIQDQMeeUcUUuWdHGbNBIGT9j1Lltydk+cI5d+072ST
fnLLy97BxBgEHtt3lad9u7zPCir/0t76677myU5mDhDTPth/y+womRhnBFX/
2T616uX9I7l6DulpIPDN/nf+12t3qzWh+n/aL27/uufsalWHs2dA4I+9mtHr
T/kHlKDmMTjciJeZvL9VAaqe0WGv/OybXktloeYzOyyZHHo2mF8aqp/F4dUi
hvn3JCWh9rE5CChPZ1uwQBxqHofDyT87Lu1oF4Oax+mw4467dtlOUah53A4Z
DsWB21VEoebxOPjnLFS/vFsEah6fg88Jjx03i0Wg5gk4LH5fMUfIRQSqXsDh
82WemPmqIlDzBR10N2WkGgjD9As5WHzbzHmYQwRqn7DDbvefkanMMPNEHOb9
DCxgYISZJ+IQblmSpsUAM0/U4T8YCEPNE3NY+/ZhJQsDzDxxhyi2d06sDDDz
JODmQsyTcDBpD97CBTdP0mHuh3nh9gww90k51IQGnFwDN0/aIfrbqUl+jDDz
ZBzubZ1ewc0EM0/GIZevmmMnE8w8WYcFnMduKzDDzJNz8Gn0P8LMDDNP3oHf
3P2KOBPMPAW4+wBXqvbf
           "]]}}, {}}, {{}, {{}, {}, 
         {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[
          0.8], AbsoluteDashing[{2, 2}], LineBox[CompressedData["
1:eJxTTMoPSmViYGDQBGIQDQOc0oztO+xdHWbNBIGT9gZxMTYioS5Q/k17ZZXf
7jP/ODqYGIPAY3vrvzlLVSTtoPIv7bc5uWu6p1k4QEz7YL/16L6t0e3GUPWf
7e/kHRU566zvkJ4GAt/sg5Y9zgp00oTq/2nf9nDq/r/7VRzOngGBP/ZqNh03
g0sUoeYxOMxb5jAt1EUOqp7RQWohG5efnjTUfGaHvzfZa5QDJKH6WRzS1ovO
b4ySgNrH5vCfZ1XqHkYJqHkcDr/+g4A41DxOh5X+W3PMZCSg5nE72Dpyluca
SkDN43GoPLtzU5shzDw+h0ojxg+nFGDmCTicf7x5XgIPTL2Aw/zVIVnKDBJQ
8wUdWMDqYPqFHGpyzdaws8PsE3Y4MIXhyG9umHkiDl6FG+KWcsDME3Fgg+qH
mCcK50PME3NITt8vcl4WZp64g6T6rZuyuTDzJBx8+AvXrP8CM0/C4dds+//C
SyWh5kk6nPDsbNSIlIKaJ+UQ8XXLJ4UnUlDzpB1Yvsxn01GVhpon4yB/X/JB
v5A01DwZh+MbW9/d2iYFNU/W4V0L27ztajDz5Bw+sdRMPVMuCTVP3kH27LXe
L7th7lNw+AeNDwDr0PXI
           "]]}}, {}}, {{}, {}, {}}, {{}, {}, {}}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      AxesStyle->{{
         AbsoluteThickness[0.8]}, {
         AbsoluteThickness[0.8]}},
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      LabelStyle->{FontFamily -> "Cmr10", FontSize -> 15},
      Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
             Part[#, 1]], 
            (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
             Part[#, 1]], 
            (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{0, 45},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}], {540., -111.24611797498106}, 
     ImageScaled[{0.5, 0.5}], {360., 222.49223594996212}]}, {}},
  ContentSelectable->True,
  ImageSize->600,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{
  3.6725721995137787`*^9, {3.6725722399088173`*^9, 3.672572253523179*^9}, 
   3.6725723336791935`*^9},ExpressionUUID->"a74fbcd7-4a6a-4e80-9b1d-\
ccf350f99144"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{
  "\"\<c:/dropbox/mystuff/cred/ECMAScndRev/WIAdest.pdf\>\"", ",", "pfin"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.672572357860612*^9, 
  3.6725723716529903`*^9}},ExpressionUUID->"cd51e985-bda1-4b49-87af-\
a793c5791b9d"],

Cell[BoxData["\<\"c:/dropbox/mystuff/cred/ECMAScndRev/WIAdest.pdf\"\>"], \
"Output",
 CellChangeTimes->{
  3.672572372754101*^9},ExpressionUUID->"da4a26ab-a942-44e3-9aab-\
4f8cc8d4300d"]
}, Open  ]]
},
WindowSize->{1525.2, 794.4},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
FrontEndVersion->"13.0 for Microsoft Windows (64-bit) (February 4, 2022)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"ca46b207-d136-4c9f-9589-5a85828cd1c6"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 8619, 258, 631, "Input",ExpressionUUID->"572ffdef-de97-4b82-b24b-6f9813c2005b"],
Cell[9189, 282, 284, 5, 41, "Output",ExpressionUUID->"c04ad22e-d956-494e-b559-0fc1538fca35"],
Cell[9476, 289, 647, 18, 41, "Output",ExpressionUUID->"399738eb-0396-4718-834c-8da69bfd0546"],
Cell[10126, 309, 799, 15, 48, "Message",ExpressionUUID->"b4924839-e6f5-4a51-9cf1-4c69dcec9df8"],
Cell[10928, 326, 801, 15, 48, "Message",ExpressionUUID->"94025482-95b6-424d-819f-ceb6564a47e0"],
Cell[11732, 343, 601, 17, 50, "Output",ExpressionUUID->"9ef3f172-78ac-45c7-b8d7-0924b0fca4ac"],
Cell[12336, 362, 717, 14, 32, "Message",ExpressionUUID->"b9404f29-a7c2-4fb1-978b-9640183011bb"],
Cell[13056, 378, 717, 14, 32, "Message",ExpressionUUID->"2b8de069-56ee-46e5-a6e7-b39c18551b67"],
Cell[13776, 394, 719, 14, 32, "Message",ExpressionUUID->"6c20468a-9221-4b2d-9a87-c0e9ba9608c9"],
Cell[14498, 410, 747, 15, 32, "Message",ExpressionUUID->"4d473fb0-ee68-4569-9fb9-dad0404024a3"],
Cell[15248, 427, 719, 14, 32, "Message",ExpressionUUID->"e81e10b8-5649-42fa-815a-71c691df98c0"],
Cell[15970, 443, 719, 14, 32, "Message",ExpressionUUID->"360a7618-7957-48f0-a750-82c491940265"],
Cell[16692, 459, 717, 14, 32, "Message",ExpressionUUID->"9fa0e7bc-9e1b-4c27-ae3e-3732b3de28a0"],
Cell[17412, 475, 749, 15, 32, "Message",ExpressionUUID->"cbfec1ef-a0f7-4b5d-886d-4182d89728fa"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18198, 495, 1783, 52, 161, "Input",ExpressionUUID->"3743a51c-bb1e-4d3a-8893-60b15f56f28a"],
Cell[19984, 549, 3086, 54, 201, "Output",ExpressionUUID->"bb207e26-a4b3-432c-bc45-e9cc2eb4dee3"]
}, Open  ]],
Cell[23085, 606, 1537, 40, 136, "Input",ExpressionUUID->"57855f0f-e78d-4656-bdae-9ae9fe14407a"],
Cell[CellGroupData[{
Cell[24647, 650, 186, 4, 36, "Input",ExpressionUUID->"0100bc25-faea-4984-b419-212f0a3fb4dd"],
Cell[24836, 656, 1462, 26, 117, "Output",ExpressionUUID->"ca7185fd-33b6-4c40-adcb-f70f05210b04"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26335, 687, 5949, 148, 507, "Input",ExpressionUUID->"ccd8a554-6205-438e-bf66-3ed13d6e51bd"],
Cell[32287, 837, 3975, 83, 326, "Output",ExpressionUUID->"5e4427da-935a-4691-9ab8-c752795dfee8"],
Cell[36265, 922, 4003, 83, 317, "Output",ExpressionUUID->"26064ac7-4807-4ae9-8e06-d88a8d47564e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[40305, 1010, 1064, 26, 36, "Input",ExpressionUUID->"58395b9d-5f9c-4f7b-97df-cb6e88fa3a28"],
Cell[41372, 1038, 8508, 169, 272, "Output",ExpressionUUID->"c95f7a0a-c57c-460b-9c46-316f69705b08"]
}, Open  ]],
Cell[CellGroupData[{
Cell[49917, 1212, 6185, 164, 458, "Input",ExpressionUUID->"8d94d83a-ab3e-4f5c-a9b7-043d4e96240e"],
Cell[56105, 1378, 599, 12, 49, "Message",ExpressionUUID->"44e9ffae-9205-4629-a02b-65334844a8c9"],
Cell[56707, 1392, 601, 12, 49, "Message",ExpressionUUID->"2c942383-d67e-4909-9c45-dc36756314b4"],
Cell[57311, 1406, 598, 12, 49, "Message",ExpressionUUID->"719411b2-bfc3-4ffd-b9f0-977fa446cf2a"],
Cell[57912, 1420, 681, 13, 32, "Message",ExpressionUUID->"ff20c20f-4c7b-4841-b4b1-03957623fdb5"],
Cell[58596, 1435, 637, 12, 32, "Message",ExpressionUUID->"41914628-b1c8-4121-b96b-482f628ae861"],
Cell[59236, 1449, 637, 12, 32, "Message",ExpressionUUID->"00656c58-40f2-47f8-8415-adc4c500d3f8"],
Cell[59876, 1463, 637, 12, 32, "Message",ExpressionUUID->"953ac339-ca5d-45ba-ad42-b813b27055de"],
Cell[60516, 1477, 685, 14, 32, "Message",ExpressionUUID->"30fd6adf-6396-4c10-92d6-316a27f28e0a"],
Cell[61204, 1493, 7393, 149, 273, "Output",ExpressionUUID->"a74fbcd7-4a6a-4e80-9b1d-ccf350f99144"]
}, Open  ]],
Cell[CellGroupData[{
Cell[68634, 1647, 273, 7, 36, "Input",ExpressionUUID->"cd51e985-bda1-4b49-87af-a793c5791b9d"],
Cell[68910, 1656, 186, 4, 41, "Output",ExpressionUUID->"da4a26ab-a942-44e3-9aab-4f8cc8d4300d"]
}, Open  ]]
}
]
*)

