module globals
	use myfuncs
	use dotops
	use dispmodule
    
    real, parameter     :: alpha=0.05
    
    real, parameter     :: thmin=0, thmax=15
    real, allocatable   :: impgrid(:), chkgrid(:)
    integer             :: nimp, nchk
    
    integer, parameter  :: nGQ=50
    real                :: GQxw(nGQ,2)
    
	integer, parameter	:: nsim=100000 
    integer, parameter  :: nY=2,nxgrid=250
    real                :: Ys(nY,nsim), densimp(nsim), densalt(nsim)
    real, allocatable   :: denschk(:,:), lam(:)
    
    
    real                :: eqtCI(2,nsim)
    integer             :: globall
    real                :: globalx
!$OMP THREADPRIVATE(globall,globalx) 
    external            :: leftfunc,phi0func
    
end module

module compute
	use globals
	implicit none
	
	contains
	
    subroutine prep
        integer, parameter  :: n=300, nimp0=100
        integer :: i
        
        impgrid=[(thmin,i=1,10),(thmin+(thmax-thmin)*(i/real(nimp0))**2,i=1,nimp0),(thmax,i=1,10)]
        nimp=size(impgrid)
        
        chkgrid=[(thmin+(thmax-thmin)*(i/real(n)),i=0,n)]
        nchk=size(chkgrid)
        allocate(denschk(nchk,nsim),lam(nchk))
    end subroutine

    subroutine setY(impind,Y)
        integer :: impind
        real    :: Y(nY)
        real    :: X(2)
        call rnnoa(X)
        Y(1)=X(1)-X(2)+impgrid(impind)
        Y(2)=X(2)
    end subroutine

    function getdens_star(th,Y) result(val)
        real    :: th, Y(nY), val
        real    :: x(2)
        x(1)=Y(1)+Y(2)
        x(2)=Y(2)
        val=-log(2*pi)-.5*((x(1)-th)**2+x(2)**2)
    end function

    function getdens(th,Y) result(val)
        real    :: th, Y(nY), val
        real    :: x
        x=Y(1)
        val=-.5*log(2*pi*2)-.25*(x-th)**2
    end function
    
    elemental function priordens(th) result(val)
        real, intent(in)    :: th
        real   :: val
        val=(th+100)**(-1.1)
!         val=(th+1)**(-2)
    end function
        
    function postdens(th,l) result(val)
        real    :: th,val
        integer :: l
        val=priordens(th)*exp(getdens(th,Ys(:,l))-densimp(l))
    end function
    
    function postdensga(ga,l) result(val)
        real    :: ga,val
        integer :: l
        real    :: Y(nY),mu,sig,q0,x,th,m,xd,c
        real    :: sqrt2=sqrt(2.0)
        integer :: j
        Y=Ys(:,l)
        mu=Y(1)
        sig=1.4
        q0=gausscdf((thmin-mu)/sig)
        val=0
        m=0
        do j=1,nGQ
            x=gausscdfinv(q0+GQxw(j,1)*(1-q0))
            th=mu+sig*x
            xd=GQxw(j,2)*postdens(th,l)/gaussdens(x)
!            val=val+.5*(gausscdf(sqrt2*(ga-(th+.5*Y(1)-.5*th)))+gausscdf(sqrt2*(ga-(.5*Y(1)-.5*th))))*xd
            c=ga-(.5*Y(1)-.5*th)
            val=val+((c + (exp(-c**2) - exp(-(c - th)**2))/Sqrt(Pi) + c*Erf(c) + (-c + th)*Erfc(-c + th))/2.)*xd/th
            m=m+xd
        enddo
        val=val/m       
    end function

    subroutine setdensY
        integer :: l,i,j
        real    :: Y(nY),hs(nimp), h
        real    :: mu, sig, q0,x
        
        
        do l=1,nsim
            call setY(mod(l,nimp)+1,Y)
            Ys(:,l)=Y
        enddo

        call mkGQxw(GQxw)
        
!$omp parallel do private(Y,j,mu,sig,q0,h,hs,x)
        do l=1,nsim
            Y=Ys(:,l)
            do j=1,nimp
                hs(j)=getdens_star(impgrid(j),Y)
            enddo
            densimp(l)=logmeanexp(hs)

            mu=Y(1)
            sig=1.4
            q0=gausscdf((thmin-mu)/sig)
            h=0
            do j=1,nGQ
                x=gausscdfinv(q0+GQxw(j,1)*(1-q0))
                h=h+GQxw(j,2)*postdens(mu+sig*x,l)/gaussdens(x)
            enddo
            densalt(l)=(1-q0)*sig*h
            do j=1,nchk
                denschk(j,l)=max(exp(getdens_star(chkgrid(j),Y)-densimp(l)),1E-100)
            enddo
        enddo
        call disp(sum(denschk,dim=2)/nsim)
    end subroutine
    
    
    function getcv(stats,w,alpha) result(val)
        use SVRGP_INT
        real    :: stats(nsim), w(nsim),alpha, val
        real    :: sort(nsim),p
        integer :: inds(nsim),l
        
        inds=[(l,l=1,nsim)]
        call svrgp(stats,sort,inds)
        p=w(inds(nsim))
        do l=nsim-1,1,-1
            if(p+w(inds(l))>alpha*nsim) then
                val=sort(l+1)
                return
            endif
            p=p+w(inds(l))
        enddo
        print *,"error in getcv: weights sum up to less than alpha"
        stop
    end function
    

    
    subroutine seteqt
        use neqnf_int
        integer :: l
        real    :: leftm(1)
        real    :: fnorm

        real    :: f(1)
        
        !do l=1,200
        !    globall=l
        !    leftm=4
        !    call leftfunc(leftm,f,1)
        !    call disp([Ys(1,l),f])
        !enddo
        !stop
        
        call erset(0,1,0)
!$omp parallel do private(leftm,fnorm)        
        do l=1,nsim
            globall=l
            leftm=-2.0
            call neqnf(leftfunc,leftm,xguess=leftm,fnorm=fnorm)
            eqtCI(:,l)=[leftm(1),-leftm(1)+Ys(1,l)]
        enddo
        print *,"done computing equal-tailed set"
        do l=1,20
            call disp([Ys(1,l),eqtCI(:,l),Ys(2,l),Ys(1,l)+Ys(2,l)])
        enddo
!        stop
    end subroutine
    
    
    subroutine setaug
        real, allocatable    :: LR(:,:)
        real    :: rp(nchk)
        integer :: l,j
        real    :: ga, x, Delta, Sigi(2,2), f(1)
        logical :: norej(nsim)
        
        Sigi=invertpd(reshape([2.0,1.0,1.0,1.0],[2,2]))
 
        allocate(LR(nchk,nsim))

        norej=Ys(2,:)+eqtCI(1,:)<0.and.Ys(2,:)+eqtCI(2,:)>0
        norej=norej.or.((Ys(1,:)>6.0 .and. Ys(2,:)<1.645 .and. Ys(2,:)+Ys(1,:)>-1.645))
!        Ys(2,l)<1.96 .and. (Ys(1,l)+Ys(2,l))>-1.96
        do l=1,nsim
            ga=-Ys(2,l)
            x=Ys(1,l)
            do j=1,nchk
                Delta=chkgrid(j)
                LR(j,l)=.5*exp(-log(2*pi)-.5*sum([x-Delta,ga]*matmul(Sigi,[x-Delta,ga]))-log(densalt(l))-densimp(l))+.5*exp(-log(2*pi)-.5*sum([x-Delta,ga-Delta]*matmul(Sigi,[x-Delta,ga-Delta]))-log(densalt(l))-densimp(l))
            enddo
        enddo
        lam=.1
        do j=1,100
            rp=0
            do l=1,nsim
                if((.not.norej(l)).and.sum(lam*LR(:,l))<1) rp=rp+denschk(:,l)
            enddo
            rp=rp/nsim
            lam=lam*exp(3*(rp-alpha))
!            print *,j
        enddo
        call disp(chkgrid.cvr.lam.cud.rp)
!        stop
        !do l=1,200
        !    globalx=Ys(1,l)
        !    call phi0func([-Ys(2,l)],f,1)
        !    call disp([exp(f),sum(lam*LR(:,l))])
        !enddo
        !stop
        
    end subroutine

    subroutine printphi0
        use neqnf_int
        integer :: j
        integer, parameter  :: nx=250
        real    :: xgrid(nx)=[(-5+j*20.0/nx,j=1,nx)]
        real    :: ggrid(20)=[(-10+.5*(j-1),j=1,20)], fgrid(20)
        real    :: gaco(nx),gag(1)

        real    :: rp(nchk),c,f(1)
        integer :: i,l
            
        do j=1,nx
            globalx=xgrid(j)
            do i=1,size(ggrid) 
                call phi0func([ggrid(i)],f,1)
                fgrid(i)=f(1)
            enddo
            if(maxval(fgrid)<0.0) then
                gaco(j)=0
            else
                gag(1)=ggrid(minloc(abs(fgrid),dim=1))
                call neqnf(phi0func,gag,xguess=gag) 
                gaco(j)=gag(1) !-xgrid(j)
            endif
        enddo
        call disp(xgrid.cvr.gaco.cud.(-gaco+xgrid).cud.(-2*gaco+xgrid))
        call savemat("c:/dropbox/mystuff/cred/betproofrev/IMaugdat.txt",xgrid.cvr.gaco)
        rp=0
        do l=1,nsim
            c=gaco(minloc(abs(xgrid-Ys(1,l)),dim=1))
!            if(-Ys(2,l)<c .or. -Ys(2,l)>-c+Ys(1,l)) rp=rp+denschk(:,l)
            globalx=Ys(1,l)
            call phi0func([-Ys(2,l)],f,1)
            if(f(1)<0) rp=rp+denschk(:,l)
            if((-Ys(2,l)<c .or. -Ys(2,l)>-c+Ys(1,l)).and.(f(1)>0).and.(abs(f(1))>.2)) then
                call disp(f(1))
                do j=1,100
                    call phi0func([-5.0+.1*j],f,1)
                    call disp([-5.0+.1*j,f])
                enddo
                call disp([c,-c+Ys(1,l),-Ys(2,l)])
                stop
            endif
        enddo
        rp=rp/nsim
        call disp(rp)
        stop
    end subroutine
    
    subroutine evaleqt
        integer :: l
        real    :: rp(nchk)
        
        rp=0
        do l=1,nsim
 !           rp=rp+merge(denschk(:,l),0.0,Ys(2,l)+eqtCI(1,l)>chkgrid.or.Ys(2,l)+eqtCI(2,l)<chkgrid)/nsim
             rp=rp+merge(denschk(:,l),0.0,Ys(2,l)+eqtCI(1,l)>0.or.Ys(2,l)+eqtCI(2,l)<0)/nsim
        enddo
        call disp(chkgrid.cvr.rp)
        call savemat("c:/dropbox/mystuff/cred/betproofrev/xx.txt",Ys(1,1:200).cvr.eqtCI(2,1:200))
    end subroutine
    
    subroutine evalStoye
        integer :: l
        real    :: rp(nchk)
        
        rp=0
        do l=1,nsim
            rp=rp+merge(0.0,denschk(:,l),Ys(2,l)<1.96 .and. (Ys(1,l)+Ys(2,l))>-1.96)/nsim
        enddo
        print *,"Stoye"
        call disp(chkgrid.cvr.rp)
        
    end subroutine
    
end module

program mfort
	use globals
	use compute
	implicit none

	call disp_set(advance="double",orient="row")
	call inittime
    call rnopt(6)
    call rnset(14)
    
    call prep
    call setdensY
    call evalStoye
    call seteqt
    call evaleqt
    call setaug
    call printphi0
!   
end program

subroutine Leftfunc(X,F,n)
    use compute
    implicit none
    real    :: X(n),F(n)
    integer :: n

    
    F(1)=postdensga(x(1),globall)-alpha/2
end subroutine
    
subroutine phi0func(X,F,n)
    use compute
    implicit none
    real    :: X(n),F(n)
    integer :: n
    
    integer :: j
    real    :: Delta,ga,Sigi(2,2)
    real    :: mu,sig,q0,h,xx,th
    
    mu=globalx
    sig=1.4
    q0=gausscdf((thmin-mu)/sig)
    h=0
    do j=1,nGQ
        xx=gausscdfinv(q0+GQxw(j,1)*(1-q0))
        th=mu+sig*xx
        h=h+GQxw(j,2)*priordens(th)*exp(getdens(th,[globalx,0.0]))/gaussdens(xx)
    enddo
    h=log((1-q0)*sig*h)
    Sigi=invertpd(reshape([2.0,1.0,1.0,1.0],[2,2]))

!f=h
!return
    
    ga=-abs(X(1))
    F(1)=0
    do j=1,nchk
        Delta=chkgrid(j)
        F(1)=F(1)+lam(j)*(.5*exp(-log(2*pi)-.5*sum([globalx-Delta,ga]*matmul(Sigi,[globalx-Delta,ga]))-h)+.5*exp(-log(2*pi)-.5*sum([globalx-Delta,ga-Delta]*matmul(Sigi,[globalx-Delta,ga-Delta]))-h))
    enddo
    F(1)=log(F(1))
 !   print *,"logF"
  !  call disp(F)
    
end subroutine

    