include 'c:/dropbox/mystuff/medunbiased/revision/fortran/compilerflags.f90'
	
! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX Mean Bias Routines XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX	
! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
!dec$ if (biastype==MEAN)
module calc
	use globals
	use model
	implicit none
	real				:: Omeg(nG,nG),ovec(nG), oconst, lam(nG)
	real				:: effintFs(3,nsim),deltahats(nsim)
	
	contains

	function getswitchprob() result(val)
		real		:: val(nthgrid)
		integer		:: l
		val=0
		do l=1,nsim
			val=val+thgridfs(:,l)*SWran(l)
		enddo
		val=val/nsim
	end function
	
	subroutine setdeltahats(SWflag) 
		logical :: SWflag
		integer	:: l
		if(SWflag) then
!$omp parallel do
			do l=1,nsim
				deltahats(l)=SWran(l)*Sests(l)+(1-SWran(l))*(effintFs(2,l)-sum(lam*intGs(1,:,l)))/effintFs(1,l)
			enddo
		else
!$omp parallel do
			do l=1,nsim
				deltahats(l)=(effintFs(2,l)-sum(lam*intGs(1,:,l)))/effintFs(1,l)
			enddo
		endif
	end subroutine
	
	subroutine mkOmeg(indenv,SWflag)
		integer	:: indenv			! index of envelope on envgrid; if zero, weighted average F
		logical :: SWflag
		integer	:: l,i,j
		real	:: eta
		
		if(indenv==0) then
			effintFs=intFs
		else
			effintFs=intenvs(:,indenv,:)
			where (effintFs(1,:)==0)
				effintFs(1,:)=1E-100
			endwhere
		endif
		oconst=0; Omeg=0; ovec=0
		if(SWflag) then
!$omp parallel do private(i,j) reduction(+:oconst,ovec,Omeg)
			do l=1,nsim
				oconst=oconst+(1-SWran(l))*(effintFs(3,l)-effintFs(2,l)**2/effintFs(1,l))
				oconst=oconst+SWran(l)*(Sests(l)**2*effintFs(1,l)-2*Sests(l)*effintFs(2,l)+effintFs(3,l))
				do i=1,nG
					ovec(i)=ovec(i)+(1-SWran(l))*(intGs(1,i,l)*effintFs(2,l)/effintFs(1,l)-intGs(2,i,l))
					ovec(i)=ovec(i)+SWran(l)*(Sests(l)*intGs(1,i,l)-intGs(2,i,l))
					do j=1,nG
						Omeg(j,i)=Omeg(j,i)+intGs(1,i,l)*intGs(1,j,l)/effintFs(1,l)
					enddo
				enddo
			enddo
		else
			do l=1,nsim
				oconst=oconst+effintFs(3,l)-effintFs(2,l)**2/effintFs(1,l)
				do i=1,nG
					ovec(i)=ovec(i)+intGs(1,i,l)*effintFs(2,l)/effintFs(1,l)-intGs(2,i,l)
					do j=1,nG
						Omeg(j,i)=Omeg(j,i)+intGs(1,i,l)*intGs(1,j,l)/effintFs(1,l)
					enddo
				enddo
			enddo
		endif
		Omeg=Omeg/nsim
		ovec=ovec/nsim
		oconst=oconst/nsim
	end subroutine
	
	subroutine solvequad(eps,ropt)
		use qprog_int
		logical		:: SWflag
		real		:: eps,ropt
		real, allocatable		:: rlam(:),rOmeg(:,:),rovec(:),odiag(:)
		logical		:: sel(nG)
		integer		:: i,j,l

		sel=diagonal(Omeg)<1E5
		rOmeg=selectifc(selectifr(Omeg,sel),sel)
		rovec=pack(ovec,sel)
		allocate(rlam(count(sel)))
		
		odiag=sqrt(diagonal(rOmeg))
		
		do i=1,size(odiag)
			do j=1,size(odiag)
				rOmeg(j,i)=rOmeg(j,i)/(odiag(i)*odiag(j))
			enddo
		enddo
		rovec=rovec/(odiag)
		call erset(0,0,0)
		call qprog(0,rOmeg.cud.(-rOmeg),[rovec-eps/odiag,-rovec-eps/odiag],[(0.0,i=1,nG)],rOmeg,rlam)
		if(IERCD()==2) then
			ropt=1E10
			return
		endif
		ropt=sum(rlam*matmul(rOmeg,rlam))+oconst
		rlam=rlam/odiag
		lam=unpack(rlam,sel,0.0)
	end subroutine
	
	subroutine setnoconst()
		integer	:: l
		do l=1,nsim
			deltahats(l)=(intFs(2,l))/intFs(1,l)
		enddo
	end subroutine

	function quadenv(eps) result(val)
		real	:: eps,env(nenv)
		integer	:: i
		real	:: val(2,nenv)
		
		env=0
		do i=1,nenv
!			print *,i
			call mkOmeg(i,.false.)
			call solvequad(eps,env(i))
		enddo
		call mdisp(envgrid.cvr.env)
		val=envgrid.cvr.env
	end function

	subroutine setfeasible(eps)
		real	:: eps
		real	:: epsfeas,deleps,rbound,ropt,bias(nthgrid),meanepsSW
		integer	:: i
		
		call mkOmeg(0,.false.)
		call solvequad(eps,rbound)
		call setdeltahats(.false.)
		print *,'profile of bound estimator, no switching'
		call mdisp(thgrid.cvr.getbias(deltahats).cud.getbiasMCs(deltahats).cud.getrisk(deltahats))
		print *,'underlying lambda'
		call mdisp(Ggrid.cvr.lam)

		meanepsSW=0 

		epsfeas=eps
		deleps=eps
		do i=1,15
			deleps=deleps*0.5
			call solvequad(epsfeas,ropt)
			if(ropt<rbound*(1+riskeps)) then
				epsfeas=epsfeas-deleps
			else
				epsfeas=epsfeas+deleps
			endif
			epsfeas=max(epsfeas,meanepsSW)
		enddo
		epsfeas=epsfeas+deleps
		call solvequad(epsfeas,ropt)		
		call setdeltahats(.true.)

		bias=getbias(deltahats)
		print *,'bias epsilon, risk bound, risk feasible'
		call mdisp([eps,rbound,ropt,ropt/rbound])

		print *,'profile of feasible test'
		call mdisp(thgrid.cvr.getbias(deltahats).cud.getbiasMCs(deltahats).cud.getrisk(deltahats))
		if(maxval(abs(bias))>eps) then
			print *,'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX'
			print *,'feasible test does not satisfy bias constraint'
			print *,'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX'
			call mdisp(maxval(abs(bias)))
		endif
	end subroutine
	
!dec$ if (model==ARconst)	
	
	function evalss(rhogrid) result(val)
		real	:: rhogrid(:)
		integer, parameter	:: nssim=100000
		integer	:: nrhogrid
		real	:: outss(2,2,size(rhogrid)), outc(size(outss,dim=1),2,nssim)
		real	:: val(2*2,2*size(rhogrid))
		real	:: GQxw(nGQ,2),rho0,intF(3), intG(3,nG), deltahat,SWr,dhS
		real	:: X(nX),th,f0
		integer	:: l,i,ir,io,idgp
		
		nrhogrid=size(rhogrid)
		call mkGQxw(GQxw)
		do idgp=1,2
			outss=0
			do ir=1,nrhogrid
				rho0=rhogrid(ir)
!$omp parallel do private(X,deltahat,f0,intF,i,th,intG,io)			
				do l=1,nssim
					call setssX(rho0,X,idgp)
					f0=getdens(rho0,X)
					intF=0
					do i=1,nGQ
						th=thminF+(thmaxF-thminF)*GQxw(i,1)
						intF=intF+GQxw(i,2)*exp(getdens(th,X)-f0)*[1.0,th,th**2]/astddev(th)**2
					enddo
					do i=1,nG
						intG(:,i)=exp(getdens(Ggrid(i),X)-f0)*[1.0,Ggrid(i),Ggrid(i)**2]/astddev(Ggrid(i))
					enddo
					deltahat=(intF(2)-sum(lam*intG(1,:)))/intF(1)

					io=1
					call setout()
					deltahat=getOLS(X)
					deltahat=(nsample*deltahat+1)/(nsample-3)
					call setout()
				enddo
				outss(:,:,ir)=sum(outc,dim=3)/nssim
				print *,"small sample bias and MSE"
				call mdisp(rhogrid)
				call mdisp(outss(:,1,:))
				call mdisp(outss(:,2,:))
				val((idgp-1)*2+1:(idgp-1)*2+1,1:nrhogrid)=outss(:,1,:)
				val((idgp-1)*2+1:(idgp-1)*2+1,nrhogrid+1:)=outss(:,2,:)
			enddo
		enddo

	contains 
	
		subroutine setout
			outc(io,1,l)=deltahat-rho0
			outc(io,2,l)=(deltahat-rho0)**2
			io=io+1
		end subroutine

	end function
!dec$ endif

	
	end module
!dec$ endif			

! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX Median Bias Routines XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX	
! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX	
!dec$ if (biastype==MEDIAN)
module calc
	use globals
	use model
	implicit none
	real				:: SWviols(nG),SWobj,lam(nG)
	real				:: viols(nG), v2(nG),lampos(nG),lamneg(nG),lamfacpos(nG),lamfacneg(nG)
	real				:: deltahats(nsim)
	real, allocatable	:: effobjs(:,:)

	contains
	
	function getswitchprob() result(val)
		real		:: val(nthgrid)
		integer		:: l
		val=0
		do l=1,nsim
			val=val+thgridfs(:,l)*SWran(l)
		enddo
		val=val/nsim
	end function

	function getviolsMCs() result(val)
		real	:: val(nG),c(nG),b(nG),b2(nG),lagr(netas),etahat
		integer	:: l,minind,i0
		
		b=0;b2=0
		do l=1,nsim
			lagr=effobjs(:,l)+matmul(consts(:,:,l),lam)
			minind=minloc(lagr,dim=1)
			if((minind==1).or.(minind==netas)) then
				c=consts(minind,:,l)
			else
				etahat=getquadmin(etagrids(minind-1:minind+1,l),lagr(minind-1:minind+1))
				do i0=1,nG
					c(i0)=getquadint(etagrids(minind-1:minind+1,l),consts(minind-1:minind+1,i0,l),etahat)
				enddo
			endif
			b=b+c
			b2=b2+c**2
		enddo
		b=b/nsim;b2=b2/nsim
		val=sqrt((b2-b**2)/nsim)
	end function
	
	function getcviols() result(val)
        real    :: val(nG),csum(nG)
        real    :: etahat, lagr(netas)
        integer :: l,i0,minind
		real, parameter	:: eeps=1E-10
		integer	:: boundcount
        
		boundcount=0
		csum=0
!$omp parallel do private(l,lagr,i0,minind,etahat) reduction(+:csum, boundcount) 
		do l=1,nsim
			lagr=effobjs(:,l)+matmul(consts(:,:,l),lam)
			minind=minloc(lagr,dim=1)
			if((minind==1)) then
				etahat=etagrids(minind,l)-eeps
				csum=csum+consts(minind,:,l)
			else 
				if( minind==netas) then
				etahat=etagrids(minind,l)+eeps
				csum=csum+consts(minind,:,l)
				else
					etahat=getquadmin(etagrids(minind-1:minind+1,l),lagr(minind-1:minind+1))
					do i0=1,nG
						csum(i0)=csum(i0)+getquadint(etagrids(minind-1:minind+1,l),consts(minind-1:minind+1,i0,l),etahat)
					enddo
				endif
			endif
			deltahats(l)=etahat
		enddo
		val=csum/nsim
		if(boundcount>0) print *,"fraction of etas at boundary", real(boundcount)/nsim		
	end function 
	
	function getFrisk() result(val)
		real	:: val
		integer	:: l,minind
		val=0
		do l=1,nsim
			minind=minloc(abs(etagrids(:,l)-deltahats(l)),dim=1)
			if((minind==1).or.(minind==netas)) then
				val=val+effobjs(minind,l)
			else
				val=val+getquadint(etagrids(minind-1:minind+1,l),effobjs(minind-1:minind+1,l),deltahats(l))
			endif
		enddo
		val=val/nsim
	end function


	subroutine iterate(meaneps)
		real	:: meaneps
		lampos=lampos*exp((viols-meaneps)*lamfacpos)
		lamneg=lamneg*exp(-(viols+meaneps)*lamfacneg)
		where((viols-meaneps)*(v2-meaneps)>=0) 
			lamfacpos=lamfacpos*1.03
		elsewhere
			lamfacpos=0.5*lamfacpos
		endwhere
		where((viols+meaneps)*(v2+meaneps)>=0) 
			lamfacneg=lamfacneg*1.03
		elsewhere
			lamfacneg=0.5*lamfacneg
		endwhere
		call setbounds(lamfacneg,0.01,100.0)	
		call setbounds(lamfacpos,0.01,100.0)	
		v2=viols
		lam=lampos-lamneg
	end subroutine

	subroutine initlams()
		lampos=1E-4
		lamneg=1E-4
		lamfacpos=10; lamfacneg=10
		viols=0;v2=0
	end subroutine

	function getriskbound(eps) result(val)
		real	:: eps,val
		effobjs=objs
		val=getriskbound_go(eps,0)
	end function
	
	function getriskbound_go(eps,ienv) result(val)
        real    :: eps,val, cbound, lbound
        integer :: ienv,i
		
		call initlams
		lbound=1E-5
		do i=1,1001
			call iterate(eps)
			viols=getcviols()
			if(mod(i,25)==0) then
				cbound=getFrisk()+sum(lamneg*(-eps-viols))+sum(lampos*(viols-eps))
				call mdisp([real(i),maxval(abs(viols)),cbound])
				if(cbound<0) cycle
				if(cbound/lbound-1<1E-4.and.i>50) exit
				lbound=cbound
			endif			
		enddo
		val=getFrisk()+sum(lamneg*(-eps-viols))+sum(lampos*(viols-eps))
		print *,"riskbound =", val
	end function
	
	function getriskenv(eps) result(envtab)
		integer	:: i
		real	:: eps,envtab(2,nenv)
		
		envtab(1,:)=envgrid
		envtab(2,:)=-1
		
		do i=1,nenv
			effobjs=envobs(:,:,i)
			envtab(2,i)=getriskbound_go(eps,i)
			print *,"envelope of risk"
			call mdisp(envtab)
		enddo
	end function
	
	subroutine setlamfeas(biaseps)
        integer :: i,j
		real		:: r, riskbound, deleps, ceps, crisk
		real		:: biaseps

		effobjs=objs
		call initlams
		riskbound=(1+riskeps)*getriskbound(biaseps)

!dec$ if (model==forq)
		deleps=0.5*biaseps
		ceps=0.5*biaseps
		do i=1,200
			call iterate(ceps)
			viols=getcviols()
		enddo
		crisk=getFrisk()
		if(crisk>riskbound) then
			do i=1,200
				call iterate(ceps)
				viols=getcviols()
			enddo
		endif
		do i=1,1000
			call iterate(ceps)
            viols=getcviols()
			if(mod(i,25)==0) then
				call mdisp([real(i),maxval(abs(viols))])
				if(maxval(abs(getbias(deltahats)))<biaseps) then
					r=getFrisk()/riskbound
					print *,r
					if(r>1) then 
						print *,"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
						print *,"XXXXXXXXX risk too large XXXXXXXXXXXXXXXXXXXXXXX" 
						print *,"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
					endif
					return
				endif
			endif
		enddo
		print *,"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
		print *,"XXXXXXXXX failed to determine unbiased test XXXX" 
		print *,"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
		print *,maxval(abs(getbias(deltahats)))

		
		
!dec$ else	
		do i=1,200
			call iterate(biaseps)
            viols=getcviols()
			viols(1:10)=viols(1:10)-[(0.001*(10-j),j=1,10)]		! push away from 1/2 for median function to be invertible at boundary
			viols(nG-9:)=viols(nG-9:)+[(0.001*j,j=1,10)]
		enddo
		call mdisp([real(i),maxval(abs(viols))])
		print *,"profile of feasible nearly unbiased"
		call mdisp(thgrid.cvr.getbias(deltahats).cud.getbiasMCs(deltahats).cud.getrisk(deltahats))
		call setubdeltahat(gmedfunc(:,1))
		print *,'exactly unbiased feasible'
		call mdisp(thgrid.cvr.getbias(deltahats).cud.getbiasMCs(deltahats).cud.getrisk(deltahats))
		r=getFrisk()/riskbound
		print *,"risk ratio to (1+riskeps)*bound",r
		if(r>1) then 
			print *,"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
			print *,"XXXXXXXXX risk too large XXXXXXXXXXXXXXXXXXXXXXX" 
			print *,"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
		endif


!dec$ endif 	
	end subroutine

	
	subroutine setnoconst()
		lam=0
		effobjs=objs
		viols=getcviols()
	end subroutine
		

	subroutine setubdeltahat(gmf,useS)
		logical, optional	:: useS(nsim)
        real    :: gmf(nthgrid),dhub(nsim)
        real    :: dsort(nsim),prob
        integer :: i,l,j,sortind(nsim)
        
		real	:: delmed
        real    :: medfunc(nthgrid)
        
		medfunc=quantile_s(deltahats,0.5)
!$omp parallel do private(delmed,j)
		do i=1,nthgrid
			delmed=maxval(deltahats)-minval(deltahats)
			do j=1,30
				delmed=0.5*delmed
				if(sum(thgridfs(i,:)*(rboole(deltahats>medfunc(i))-0.5))<0) then			
					medfunc(i)=medfunc(i)-delmed
				else
					medfunc(i)=medfunc(i)+delmed
				endif
			enddo
		enddo
		print *,"median function"
		call mdisp(thgrid.cvr.medfunc)
		if(any(medfunc(2:)<=medfunc(1:nthgrid-1))) then
			print *,'WARNING: median function is not monotone; using monotone hull'
		endif
        do i=2,nthgrid
            medfunc(i)=max(medfunc(i-1)+1E-10,medfunc(i))
		enddo
		gmf=medfunc		
        do l=1,nsim
			dhub(l)=getmedtrans(deltahats(l),medfunc)
		enddo
		if(present(useS)) then
			where(.not. useS) deltahats=dhub
		else
			deltahats=dhub
		endif
	end subroutine
	
	function getmedtrans(dhat,medfunc) result(val)
		real	:: dhat,medfunc(nthgrid),val
		integer	:: i0
		i0=count(medfunc<dhat)
		if((i0==0)) then
			val=thgrid(1)-0.000001
		elseif (i0==nthgrid) then
			val=thgrid(nthgrid)+0.000001
		else
			val=getlinint(medfunc(i0:i0+1),thgrid(i0:i0+1),dhat)
		endif
	end function
	
!dec$ if (model/=ARnoconst)	

	function evalss(rhogrid) result(val)
		real	:: rhogrid(:)
		integer, parameter	:: nssim=100000
		integer	:: nrhogrid
		real	:: outss(2,2,size(rhogrid)), outc(size(outss,dim=1),2,nssim)
		real	:: val(2*2,2*size(rhogrid))
		real	:: rho0,deltahat,obj(netas), const(netas,nG),etahat, f0
		real	:: rhohat,mu,sig,shatGLS,cr,pdist(3,nG),el,er,zscores(2)
		real	:: X(nX),likvecs(nGQ,netas-1)
		real	:: th
		integer	:: i,ir,io,minind,j,l,idgp
		real	:: GQxw(nGQ,2)
		real,allocatable		:: etagrid0(:)

		real	:: test(3,nG)
!dec$ if (model==FORQ)	
		qzscore=mytdf(1.0,1)			! initialize mytdf
		qzscore=gausscdfinv(forq)
		zscores=[tin(0.1*forq,nsample-1.0),tin(min(5*forq,0.99),nsample-1.0)]
		call mkGQxw(GQxw)
!dec$ else
		call prepvecs
		etagrid0=etagrid
!dec$ endif				
		
		nrhogrid=size(rhogrid)
		do idgp=1,2
		outss=0
		do ir=1,nrhogrid
			rho0=rhogrid(ir)
!$omp parallel do private (X,f0,rhohat,mu,sig,shatGLS,i,th,j,cr,etagrid,const,obj,likvecs,minind,etahat,io,pdist,el,er)
			do l=1,nssim
				call setssX(rho0,X,idgp)
				f0=getdens(rho0,X)
!dec$ if (model==FORQ)	
				do i=1,nG
					th=Ggrid(i)
					mu=getcondmu(th,X)
					sig=getcondsig(th)*getshatGLS(th,X)/sqrt(nsample-1.0)
					cr=exp(getdens(th,X)-f0)
					pdist(:,i)=[cr,mu+sig*zscores]
				enddo
				pdist(1,:)=pdist(1,:)/sum(pdist(1,:))
				el=minval(pdist(2,:),mask=pdist(1,:)>1E-5,dim=1)
				er=maxval(pdist(3,:),mask=pdist(1,:)>1E-5,dim=1)
				etagrid=0.5*(el+er)+(er-el)*[(-1.0+2.0*(i-1)/real(netas-1),i=1,netas)]
				do i=1,nG
					th=Ggrid(i)
					mu=getcondmu(th,X)
					sig=getcondsig(th)*getshatGLS(th,X)/sqrt(nsample-1.0)
					cr=exp(getdens(Ggrid(i),X)-f0)
					do j=1,netas
						const(j,i)=cr*(tdf((etagrid(j)-mu)/sig,nsample-1.0)-forq)
					enddo
				enddo
				obj=0
				do i=1,nGQ
					th=thminF+(thmaxF-thminF)*GQxw(i,1)
					mu=getcondmu(th,X)
					sig=getcondsig(th)
					shatGLS=getshatGLS(th,X)
					cr=GQxw(i,2)*exp(getdens(th,X)-f0)/astddev(th)
					do j=1,netas
						obj(j)=obj(j)+cr*geteloss(etagrid(j),mu,sig,shatGLS) 	
					enddo
				enddo
!dec$ else
				etagrid=etagrid0
				call setlikvecs(X,likvecs,f0)
				call setobj(obj,likvecs)
				do i=1,nG
					call setconst(i,const(:,i),likvecs)
				enddo
!dec$ endif				
				obj=obj+matmul(const,lam)
				minind=minloc(obj,dim=1)
				if((minind==1)) then
					etahat=etagrid(minind)-0.00001
				else 
					if( minind==netas) then
						etahat=etagrid(minind)+0.00001
					else
						etahat=getquadmin(etagrid(minind-1:minind+1),obj(minind-1:minind+1))
					endif
				endif
				io=1
!dec$ if (model==FORQ)
				deltahat=etahat
				call setout()
				deltahat=getSest(X)
				call setout()
!dec$ elseif(model<=Arconst)		
				deltahat=etahat
				deltahat=getmedtrans(etahat,gmedfunc(:,1))
				call setout()
				etahat=getOLS(X)
				deltahat=getmedtrans(etahat,gmedfunc(:,2))
				call setout()
!dec$ elseif(model==MA)
				deltahat=etahat
				deltahat=getmedtrans(etahat,gmedfunc(:,1))
				call setout()
				etahat=getNyb(X)
				deltahat=getmedtrans(etahat,gmedfunc(:,2))
				call setout()
!dec$ endif			
			enddo
			outss(:,:,ir)=sum(outc,dim=3)/nssim
			print *,"small sample bias and MAD"
			call mdisp(rhogrid)
			call mdisp(outss(:,1,:))
			call mdisp(outss(:,2,:))
			val((idgp-1)*2+1:(idgp-1)*2+1,1:nrhogrid)=outss(:,1,:)
			val((idgp-1)*2+1:(idgp-1)*2+1,nrhogrid+1:)=outss(:,2,:)
			enddo
		enddo

	contains 
	
		subroutine setout
!dec$ if (model==FORQ)
			outc(io,1,l)=rboole(X(6)<deltahat)-forq
			outc(io,2,l)=abs(deltahat-X(6))*abs(outc(io,1,l))
			if(.not. all(isfinite(outc(io,:,l)))) then
!$omp critical
				print *,"problem",X(6),deltahat,forq
				print *,etagrid
				print *,obj
!$omp end critical
			endif
!dec$ else		
			outc(io,1,l)=rboole(deltahat-rho0>0)-.5
			outc(io,2,l)=abs(deltahat-rho0)
!dec$ endif			
			io=io+1
		end subroutine

	end function
!dec$ endif				
end module	
!dec$ endif			


