include 'c:/dropbox/mystuff/medunbiased/revision/fortran/compilerflags.f90'

!dec$ if (model==FORQ) .and. (biastype==median)	

module ar1for
	use modelpara
	implicit none
	integer, parameter	:: nX=6
	real				:: qzscore

	contains
	
	subroutine setssX(rho,X,idgp)
		real	:: rho,X(nX)
		integer	:: i,idgp
		real	:: J(-1001:nsample+horizon),s2
		if(idgp==1) then
			call rnchi(4.0,J)
			J=J-4
		else
			!call rnun(J)
			!J=J-0.5
			call rnun(J)
			J=merge(-1.0,1.0,J<0.5)
		endif
		call rnnoa(J(-1001:-1001))
		J(-1001)=J(-1001)/sqrt(1-rho**2)
        do i=-1000,nsample+horizon
            J(i)=rho*J(i-1)+J(i)
		enddo
		J=(J-J(1))
        X(1)=sum(J(1:nsample-1)*(J(2:nsample)-J(1:nsample-1)))
        X(2)=sum(J(1:nsample-1)**2)/(nsample-1)
        X(3)=J(nsample)
        X(4)=sum(J(1:nsample-1))/(nsample-1)
		X(5)=sum((J(2:nsample)-J(1:nsample-1))**2)
		X(6)=J(nsample+horizon)
	end subroutine

	
	subroutine setX(th,X)
        real    :: th,X(nX),J(nsample+1), rho
        integer :: i
		
        rho=th
        call rnnoa(J)
		if(rho<1) J(1)=J(1)/sqrt(1-rho**2)
        do i=2,nsample
            J(i)=rho*J(i-1)+J(i)
		enddo
		J(nsample+1)=rho**horizon*J(nsample)+sqrt((1-rho**(2*horizon))/(1-rho**2))*J(nsample+1)
		J=J-J(1)
        X(1)=sum(J(1:nsample-1)*(J(2:nsample)-J(1:nsample-1)))
        X(2)=sum(J(1:nsample-1)**2)/(nsample-1)
        X(3)=J(nsample)
        X(4)=sum(J(1:nsample-1))/(nsample-1)
		X(5)=sum((J(2:nsample)-J(1:nsample-1))**2)
		X(6)=J(nsample+1)
	end subroutine
	
	function getdens(r,X) result(val)
        real    :: r,sS2,X(nX),val
		if(r==1) then
			val=-0.5*(nsample-1)*log(X(5))
		else
			sS2=2*(1-r)+(nsample-2)*(1-r)**2
			val=.5*log((1-r**2)/sS2)-0.5*(nsample-1)*log(X(5)+2*(1-r)*X(1)+(1-r)**2*X(2)*(nsample-1)-((1-r)*X(3)+(1-r)**2*X(4)*(nsample-1))**2/sS2)
		endif
	end function
	
	function getSWran(X) result(val)
        real    :: X(nX),val
		val=0
	end function
	
	function getSest(X) result(val)
        real    :: X(nX), val, chat, rhohat, muhat,sighat
		chat=-(X(1)-X(3)*X(4))/(X(2)-X(4)**2)
		rhohat=1-chat/(nsample-1)
		sighat=sqrt((X(5)+2*(1-rhohat)*X(1)+(1-rhohat)**2*X(2)*(nsample-1))/(nsample-1))
		muhat=(X(4)*(nsample-1)+X(3))/nsample
		val=muhat+(X(3)-muhat)*rhohat**horizon+qzscore*sighat*sqrt((1-rhohat**(2*horizon))/(1-rhohat**2))
	end function
	
	function getcondmu(r,X) result(val)
		real	:: r,X(nX),val
		val=((1-r)*(1-r**horizon)/(nsample*(1-r)+2*r))*X(4)*(nsample-1)
		val=val+((1+r**horizon*(nsample*(1-r)-1+2*r))/(nsample*(1-r)+2*r))*X(3)
	end function

	function getcondsig(r) result(val)
		real	:: r,val
		val=(1 + nsample + 3*r - nsample*r + (-1 + nsample)*(-1 + r)*r**(2*horizon) - 2*r**horizon*(1 + r))/((-nsample + (-2 + nsample)*r)*(-1 + r**2))
		val=sqrt(val)
	end function
	
	function getshatGLS(r,X) result(val)
		real	:: r,X(nX),val,ss2
		sS2=2*(1-r)+(nsample-2)*(1-r)**2
		val=(X(5)+2*(1-r)*X(1)+(1-r)**2*X(2)*(nsample-1)-((1-r)*X(3)+(1-r)**2*X(4)*(nsample-1))**2/sS2)	
		val=sqrt(val)
	end function
	
	function mytdf(x,ind) result(val)
		integer	:: ind
		real		:: x,val,y
		real		:: ns=-1
		integer	:: i
		integer, parameter	:: ngrid=50
		real, parameter	:: xgrid(ngrid)=[(-10+10.0*(i-1.0)/(ngrid-1),i=1,ngrid)]
		real	,save		:: valgrid(ngrid,3)
		if(nsample/=ns) then
!$omp critical	
			do i=1,ngrid
				valgrid(i,:)=log([tdf(xgrid(i),nsample-1.0),tdf(xgrid(i),nsample-0.0),tpr(xgrid(i),nsample-2.0)])
			enddo
			ns=nsample
!$omp end critical	
		endif
		if(ind==3) then
			if(abs(x)>-xgrid(1)) then
				val=0
			else
				val=exp(qdval(-abs(x),xgrid,valgrid(:,3),check=.false.))
			endif
			return
		endif
		if(x>0)	then
			val=1-getval(-x)
		else
			val=getval(x)
		endif
			
		contains
		
		function	 getval(x) result(val)
			real	:: x,val
			integer	:: minind
			if(x<xgrid(1)) then
				val=0
				return
			endif
			val=exp(qdval(x,xgrid,valgrid(:,ind),check=.false.))
		end function
	end function		
			
	function geteloss(eta,m,condsig,shat) result(val)
		real	:: eta,m,condsig,shat,val
		real	:: r
		r=(eta-m)/(condsig*shat)
		val=mytdf(sqrt(nsample-2.0)*r,3)/sqrt(nsample-2.0)+r*mytdf(sqrt(real(nsample))*r,2)-r*forq
		val=val*condsig
		if(val<0) then
			print *,"problem in geteloss"
			stop
		endif
	end function
	
	elemental function astddev(x) result(val)
		real, intent(in)	:: x
		real	:: val
		val=sqrt((1-x**(2*horizon))/(1-x**2))

	end function
	
end module
	

module model_common
	use globals
	use ar1for
	implicit none

	integer, parameter	:: prop_os=12

	contains

	subroutine setXp(X)
        real    :: X(nX)
		integer	:: ivec(1),i
		
		call rnund(nprop+2*prop_os-2,ivec)
		i=ivec(1)-(prop_os-1)
		if(i<1) i=1
		if(i>nprop) i=nprop
		call setX(propgrid(i),X)
	end subroutine
	
end module


module model
	use model_common

	implicit none
	
	real			:: fIS(nsim) ! for problem specific additional calculations, such as alternative estimators
	real, allocatable	:: Xs(:,:)

	contains
	
	subroutine prep
		integer	:: l,i,j,c,csw,cnosw,i0,minind
		real	:: X(nX),chat,GQxw(nGQ,2),th,mu,sig,shatGLS,cr,rhohat,pdist(3,nG),el,er,zscores(2)
		
		if(.not. allocated(objs)) then
			allocate(thgridfs(nthgrid,nsim),consts(netas,nG,nsim),objs(netas,nsim),etagrids(netas,nsim))
			allocate(Xs(nX,nsim),envobs(netas,nsim,nenv))
		endif

		qzscore=mytdf(1.0,1)			! initialize mytdf
		qzscore=gausscdfinv(forq)
		zscores=[tin(0.1*forq,nsample-1.0),tin(min(5*forq,0.99),nsample-1.0)]
		call rnopt(3)
		call rnset(12)
		
		call mkGQxw(GQxw)
		etagrid=[(-20+40*(i-1)/real(netas-1),i=1,netas)]
!$omp parallel do private (X,rhohat,mu,sig,shatGLS,i,th,j,cr,pdist,el,er) num_threads(46) schedule(dynamic)
		do l=1,nsim
			call setXp(X)
			call setIS(X,fIS(l))
			
			do i=1,nG
				th=Ggrid(i)
				mu=getcondmu(th,X)
				sig=getcondsig(th)*getshatGLS(th,X)/sqrt(nsample-1.0)
				cr=exp(getdens(th,X)-fIS(l))
				pdist(:,i)=[cr,mu+sig*zscores]
			enddo
			pdist(1,:)=pdist(1,:)/sum(pdist(1,:))
			el=minval(pdist(2,:),mask=pdist(1,:)>1E-5,dim=1)
			er=maxval(pdist(3,:),mask=pdist(1,:)>1E-5,dim=1)
			etagrids(:,l)=0.5*(el+er)+(er-el)*[(-1.0+2.0*(i-1)/real(netas-1),i=1,netas)]
			
			do i=1,nG
				th=Ggrid(i)
				mu=getcondmu(th,X)
				sig=getcondsig(th)*getshatGLS(th,X)/sqrt(nsample-1.0)
				cr=exp(getdens(th,X)-fIS(l))
				do j=1,netas
					consts(j,i,l)=cr*(mytdf((etagrids(j,l)-mu)/sig,1)-forq)
				enddo
			enddo
			objs(:,l)=0
			do i=1,nGQ
				th=thminF+(thmaxF-thminF)*GQxw(i,1)
				mu=getcondmu(th,X)
				sig=getcondsig(th)
				shatGLS=getshatGLS(th,X)
				cr=(GQxw(i,2)*exp(getdens(th,X)-fIS(l))/astddev(th))
				do j=1,netas
					objs(j,l)=objs(j,l)+cr*geteloss(etagrids(j,l),mu,sig,shatGLS) 	
				enddo
			enddo
			do i=1,nenv
				th=envgrid(i)
				mu=getcondmu(th,X)
				sig=getcondsig(th)
				shatGLS=getshatGLS(th,X)
				cr=exp(getdens(th,X)-fIS(l))/astddev(th)
				do j=1,netas
					envobs(j,l,i)=cr*geteloss(etagrids(j,l),mu,sig,shatGLS) 	
				enddo
			enddo

			do i=1,nthgrid
				thgridfs(i,l)=exp(getdens(thgrid(i),X)-fIS(l))
			enddo
			Sests(l)=getSest(X)
			Swran(l)=0
			Xs(:,l)=X
		enddo			
	end subroutine

	subroutine setIS(X,fIS)
        real    :: X(nX),fIS
		real	:: ldensp(nprop),chat
		integer	:: i,j,l
		
		do j=1,nprop
			ldensp(j)=getdens(propgrid(j),X)
		enddo
		ldensp(1)=ldensp(1)+log(real(prop_os))
		ldensp(nprop)=ldensp(nprop)+log(real(prop_os))
		fIS=logsumexp(ldensp)-log(nprop+2*prop_os-2.0)
	end subroutine

	function getbias(deltahats) result(val)
		real		:: val(nthgrid),deltahats(nsim),th,mu,sig,b(nthgrid)
		integer		:: l,i
		b=0
!$omp parallel do private (i,th,mu,sig) reduction(+:b)
		do l=1,nsim
			do i=1,nthgrid
				th=thgrid(i)
				mu=getcondmu(th,Xs(:,l))
				sig=getcondsig(th)*getshatGLS(th,Xs(:,l))/sqrt(nsample-1.0)
				b(i)=b(i)+thgridfs(i,l)*(mytdf((deltahats(l)-mu)/sig,1)-forq)
			enddo
		enddo
		val=b/nsim
	end function
	
	function getbiasMCs(deltahats) result(val)
		real		:: val(nthgrid),b(nthgrid),b2(nthgrid),deltahats(nsim),th,mu,sig,cval
		integer		:: l,i
		b=0;b2=0
!$omp parallel do private (i,th,mu,sig) reduction(+:b,b2)
		do l=1,nsim
			do i=1,nthgrid
				th=thgrid(i)
				mu=getcondmu(th,Xs(:,l))
				sig=getcondsig(th)*getshatGLS(th,Xs(:,l))/sqrt(nsample-1.0)
				cval=thgridfs(i,l)*(mytdf((deltahats(l)-mu)/sig,1)-forq)
				b(i)=b(i)+cval
				b2(i)=b2(i)+cval**2
			enddo
		enddo
		b=b/nsim;b2=b2/nsim
		val=sqrt((b2-b**2)/nsim)
	end function
	
	function getrisk(deltahats) result(val)
		real		:: val(nthgrid),deltahats(nsim),th,mu,sig,shatGLS,del,b(nthgrid)
		integer		:: l,i
		b=0
!$omp parallel do private (i,th,mu,sig,shatGLS) reduction(+:b)
		do l=1,nsim
			do i=1,nthgrid
				th=thgrid(i)
				mu=getcondmu(th,Xs(:,l))
				sig=getcondsig(th)
				shatGLS=getshatGLS(th,Xs(:,l))
				b(i)=b(i)+thgridfs(i,l)*geteloss(deltahats(l),mu,sig,shatGLS)/astddev(th)
			enddo
		enddo
		val=b/nsim
	end function

end module
!dec$ endif	
	


