include 'c:/dropbox/mystuff/medunbiased/revision/fortran/compilerflags.f90'

module commonglobals
	use myfuncs
	use dotops
	use ML
	integer				:: nsample
	integer, parameter	:: nsim=250000
!dec$ if (biastype==MEAN)		
	real, parameter		:: riskeps=0.01
!dec$ endif		
!dec$ if (biastype==MEDIAN)	
	!dec$ if (model==FORQ)
	real					:: riskeps=0.02
	!dec$ else
	real					:: riskeps=0.02
	!dec$ endif	
!dec$ endif
end module
	
module modelpara
	use commonglobals
	real, parameter		:: thgrideps=0.0001
!dec$ if (model<=FORQ)
	real, parameter		:: thmin=-0.95, thmax=1.0-1E-7
!dec$ if (biastype==MEAN)		
	integer, parameter	:: nG=103,nthgrid=501,nprop=nG
!dec$ else
	integer, parameter	:: nG=53,nthgrid=501,nprop=nG
!dec$ endif
	integer, parameter	:: nenv=20
	real, parameter     :: thgrid(nthgrid)=[(thmin+(thmax-thmin)*((i-1)/real(nthgrid-1)),i=1,nthgrid)]
	real, parameter		:: Ggrid(nG)=[thmin,[(tanh(-1.83+(3.2+1.83)*((i-1)/real(nG-3))),i=1,nG-2)],thmax]
	real, parameter		:: thmaxF=thmax,thminF=thmin		
	real, parameter		:: propgrid(nprop)=Ggrid
	real, parameter     :: envgrid(nenv)=[thmin,[(tanh(-1.83+(3.2+1.83)*((i-1)/real(nenv-3))),i=1,nenv-2)],thmax]

	real, parameter		:: kappaChi0=0.5,kappaChi1=0.5
	real					:: forq=0.05
	integer				:: horizon=20

	real					:: gmedfunc(nthgrid,2)	! global medfuncs, for small sample comparisons

!dec$ endif
	
!dec$ if (model==MA)		
	integer, parameter	:: nG=53,nthgrid=501,nprop=nG,nenv=21
	
	real, parameter		:: thmin=1E-7,thmax=1.0-1E-7
	real, parameter     :: thgrid(nthgrid)=[(thmax-(thmax-thmin)*((i-1)/real(nthgrid-1)),i=nthgrid,1,-1)]
!	real, parameter		:: Ggrid(nG)=[thmin,[(tanh(2.0*(i/real(nG-2))),i=1,nG-2)],thmax]
	real, parameter		:: Ggrid(nG)=[thmin,[(.5+.5*tanh(-3.0+(3.0+3.0)*((i-1)/real(nG-3))),i=1,nG-2)],thmax]
	real, parameter		:: thmaxF=thmax,thminF=thmin		
	real, parameter     :: envgrid(nenv)=[thmin,[(tanh(2.0*(i/real(nenv-2))),i=1,nenv-2)],thmax]

	real					:: gmedfunc(nthgrid,2)	! global medfuncs, for small sample comparisons

	
	real, parameter		:: propgrid(nprop)=Ggrid

	real, parameter		:: kappaChi0=0.5,kappaChi1=0.5
!dec$ endif		

	
!dec$ if (biastype==MEAN)
	integer, parameter	:: nGQ=100		
!dec$ else	
!dec$ if (model==FORQ)
	integer, parameter	:: nGQ=100		
	integer, parameter	:: netas=100
	real				:: etagrid(netas)
!dec$ else
integer, parameter	:: nGQ=7, nsubdiv=4		
	integer, parameter	:: netas=(nG-1)*nsubdiv+1
	real				:: etagrid(netas)
!dec$ endif
!dec$ endif

end module
	
module globals
	use commonglobals
!dec$ if (biastype==MEDIAN)
	use modelpara, only : nG,Ggrid,netas,nthgrid,thgrid,nsim,etagrid,kappaChi0,kappaChi1,envgrid,nenv
!dec$ else
	use modelpara, only : nG,Ggrid,nenv,nthgrid,thgrid,nsim,envgrid,kappaChi0,kappaChi1	
!dec$ endif		
	
! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX Computed Input for both calculations
	real				:: Sests(nsim), SWran(nsim)
	real, allocatable	:: thgridfs(:,:)		! thgridfs(nthgrid,nsim)
	! function getbias, getrisk (use deltahats as input)
!dec$ if (biastype==MEDIAN)
! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX Input for Median bias calculations
!	real				:: objs(netas,nsim), consts(netas,nG,nsim),etagrids(netas,nsim), envobs(netas,nsim,nenv)
	real, allocatable	:: objs(:,:), consts(:,:,:), etagrids(:,:), envobs(:,:,:)
!dec$ else
! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX Input for Mean bias calculations
	real				:: intFs(3,nsim), intGs(3,nG,nsim), intenvs(3,nenv,nsim) ! constain integrals over term on delta^2,delta,1
!dec$ endif		

end module

