include 'c:/dropbox/mystuff/medunbiased/revision/fortran/compilerflags.f90'
	
program mfort
	use commonglobals
	use model
	use model_common
	use calc
	use omp_lib

	implicit none
	
	integer, allocatable	:: nsset(:)
	integer, allocatable	:: horizonset(:)
	real, allocatable	:: forqset(:),ssrhogrid(:)
	
	integer	:: l,i,ins,ih,ifq
	
	real, allocatable		:: outbr(:,:), outmf(:,:), outpara(:,:)
	
	call openML()
	call inittime
	call rnopt(8)
	
	call omp_set_num_threads(24)
!$omp parallel do num_threads(48)
	do i=1,50
		call rnset(20+13753*omp_get_thread_num())
	enddo
	call rnset(18000)
	
	nsset=[4,5,6,7,8,9,10,12,14,16,18,20,25,30,35,40,45,50,60,70,80,90,100,120,140,160,180,200,220,240,260,280,300,320,340,360,380,400]
	ssrhogrid=[-0.3,0.5,0.8,0.9,0.95,0.99]
	nsample=50
		
!dec$ if (model==ARconst .and. biastype==MEDIAN)
	print *,"entering ARconst MEDIAN"
	
	nsample=50
	call prep
	call setlamfeas(0.0)
	do l=1,nsim
		deltahats(l)=getOLS(Xs(:,l))
	enddo
	call setubdeltahat(gmedfunc(:,2))
	outbr=evalss(ssrhogrid)	
	nsample=200
	call prep
	call setlamfeas(0.0)
	do l=1,nsim
		deltahats(l)=getOLS(Xs(:,l))
	enddo
	call setubdeltahat(gmedfunc(:,2))
	outbr=outbr.cud.evalss(ssrhogrid)	
	call savemat("c:/dropbox/mystuff/medunbiased/revision/ssARconst_median.csv",outbr) 
	call mdisp(outbr)

	outbr=reshape(Ggrid,[1,nG])
	outmf=reshape(thgrid,[1,nthgrid])
	allocate(outpara(0,1))

	do ins=size(nsset),1,-1 !,size(nsset)-1
		nsample=nsset(ins)
		print *,"entering with nsample=",nsample
		call prep
		call setlamfeas(0.0)
		print *,"done with nsample=",nsample
		outpara=outpara.cud.[real(nsample)]
		outbr=outbr.cud.lam
		outmf=outmf.cud.gmedfunc(:,1)
		call savemat("c:/dropbox/mystuff/medunbiased/revision/ARconst_median_lam.csv",outbr) 
		call savemat("c:/dropbox/mystuff/medunbiased/revision/ARconst_median_para.csv",outpara) 
		call savemat("c:/dropbox/mystuff/medunbiased/revision/ARconst_median_mf.csv",outmf) 
		call printtime
	enddo	

	nsample=50
	call prep
	call setlamfeas(0.0)
	outbr=thgrid.cvr.getbias(deltahats).cud.getrisk(deltahats)
	
	call setnoconst()
	outbr=outbr.cud.getbias(deltahats).cud.getrisk(deltahats)

	do l=1,nsim
		deltahats(l)=getOLS(Xs(:,l))
	enddo
	print *,'BC corrected OLS / MLE'
	call mdisp(thgrid.cvr.getbias(deltahats).cud.getbiasMCs(deltahats).cud.getrisk(deltahats))
	call setubdeltahat(gmedfunc(:,2))
	outbr=outbr.cud.getbias(deltahats).cud.getrisk(deltahats)
	call savemat("c:/dropbox/mystuff/medunbiased/revision/arconst_median.dat",outbr) 
	
	outbr=getriskenv(0.0)
	call savemat("c:/dropbox/mystuff/medunbiased/revision/arconst_median_env.dat",outbr) 
!dec$ endif	
	
!dec$ if (model==ARnoconst .and. biastype==MEDIAN)
	print *,"entering ARnoconst MEDIAN"
	outbr=reshape(Ggrid,[1,nG])
	outmf=reshape(thgrid,[1,nthgrid])
	allocate(outpara(0,1))

	do ins=size(nsset),1,-1 !,size(nsset)-1
		nsample=nsset(ins)
		print *,"entering with nsample=",nsample
		call prep
		call setlamfeas(0.0)
		print *,"done with nsample=",nsample
		outpara=outpara.cud.[real(nsample)]
		outbr=outbr.cud.lam
		outmf=outmf.cud.gmedfunc(:,1)
		call savemat("c:/dropbox/mystuff/medunbiased/revision/ARnoconst_median_lam.csv",outbr) 
		call savemat("c:/dropbox/mystuff/medunbiased/revision/ARnoconst_median_para.csv",outpara) 
		call savemat("c:/dropbox/mystuff/medunbiased/revision/ARnoconst_median_mf.csv",outmf) 
		call printtime
	enddo	

	nsample=50
	call prep
	outbr=getriskenv(0.0)
	call savemat("c:/dropbox/mystuff/medunbiased/revision/arnoconst_median_env.dat",outbr) 

	
	call setlamfeas(0.0)
	call mdisp(thgrid.cvr.getbias(deltahats).cud.getbiasMCs(deltahats).cud.getrisk(deltahats))
	outbr=thgrid.cvr.getbias(deltahats).cud.getrisk(deltahats)
	
	call setnoconst()
	outbr=outbr.cud.getbias(deltahats).cud.getrisk(deltahats)

	do l=1,nsim
		deltahats(l)=getOLS(Xs(:,l))
	enddo
	print *,'BC corrected OLS / MLE'
	call mdisp(thgrid.cvr.getbias(deltahats).cud.getbiasMCs(deltahats).cud.getrisk(deltahats))
	call setubdeltahat(gmedfunc(:,2))
	outbr=outbr.cud.getbias(deltahats).cud.getrisk(deltahats)
	call savemat("c:/dropbox/mystuff/medunbiased/revision/arnoconst_median.dat",outbr) 
	
!dec$ endif	
!dec$ if (model==MA .and. biastype==MEDIAN)
	print *,"entering MA"
	ssrhogrid=[0.0,0.5,0.8,0.9,0.95,0.99]
	nsample=50
	nX=nsample
	call prep
	call setlamfeas(0.0)
	do l=1,nsim
		deltahats(l)=getNyb(Xs(:,l))
	enddo
	call setubdeltahat(gmedfunc(:,2))
	outbr=evalss(ssrhogrid)	
	nsample=200
	nX=nsample
	call prep
	call setlamfeas(0.0)
	do l=1,nsim
		deltahats(l)=getNyb(Xs(:,l))
	enddo
	call setubdeltahat(gmedfunc(:,2))
	outbr=outbr.cud.evalss(ssrhogrid)	
	call savemat("c:/dropbox/mystuff/medunbiased/revision/ssMA_median.csv",outbr) 
	call mdisp(outbr)

	outbr=reshape(Ggrid,[1,nG])
	outmf=reshape(thgrid,[1,nthgrid])
	allocate(outpara(0,1))

	do ins=size(nsset),1,-1 !,size(nsset)-1
		nsample=nsset(ins)
		print *,"entering with nsample=",nsample
		nX=nsample
		call prep
		call setlamfeas(0.0)
		print *,"done with nsample=",nsample
		outpara=outpara.cud.[real(nsample)]
		outbr=outbr.cud.lam
		outmf=outmf.cud.gmedfunc(:,1)
		call savemat("c:/dropbox/mystuff/medunbiased/revision/MA_lam.csv",outbr) 
		call savemat("c:/dropbox/mystuff/medunbiased/revision/MA_para.csv",outpara) 
		call savemat("c:/dropbox/mystuff/medunbiased/revision/MA_mf.csv",outmf) 
		call printtime
	enddo	
	
	nsample=50
	nX=nsample
	call prep
	call setlamfeas(0.0)
	call setubdeltahat(gmedfunc(:,1))
	print *,'exactly unbiased feasible'
	call mdisp(thgrid.cvr.getbias(deltahats).cud.getbiasMCs(deltahats).cud.getrisk(deltahats))
	outbr=thgrid.cvr.getbias(deltahats).cud.getrisk(deltahats)
	
	call setnoconst()
	outbr=outbr.cud.getbias(deltahats).cud.getrisk(deltahats)

	do l=1,nsim
		deltahats(l)=getNyb(Xs(:,l))
	enddo
	print *,'Nyblom'
	call mdisp(thgrid.cvr.getbias(deltahats).cud.getbiasMCs(deltahats).cud.getrisk(deltahats))
	call setubdeltahat(gmedfunc(:,2))
	outbr=outbr.cud.getbias(deltahats).cud.getrisk(deltahats)
	call savemat("c:/dropbox/mystuff/medunbiased/revision/MA_median.dat",outbr) 
	
	outbr=getriskenv(0.0)
	call savemat("c:/dropbox/mystuff/medunbiased/revision/MA_median_env.dat",outbr) 
!dec$ endif		
!dec$ if (model==forq .and. biastype==MEDIAN)
	print *,"entering forq"
	forq=0.05
	horizon=10
	nsample=50
	call prep
	call setlamfeas(0.002)
	outbr=evalss(ssrhogrid)	
	nsample=200
	call prep
	call setlamfeas(0.002)
	outbr=outbr.cud.evalss(ssrhogrid)
	call savemat("c:/dropbox/mystuff/medunbiased/revision/ssForq.csv",outbr) 
	call mdisp(outbr)

	horizonset=[1,2,4,10,20,40]
	forqset=[0.01,0.05,.10]
	nsset=[20,50,100,200,300,400]
	
	outbr=reshape(Ggrid,[1,nG])
	outmf=reshape(thgrid,[1,nthgrid])
	allocate(outpara(0,3))
	
	do ins=1,size(nsset) !,size(nsset)-1
	nsample=nsset(ins)
	do ifq=1,size(forqset)	!,size(forqset)-1
	forq=forqset(ifq)
	do ih=1,size(horizonset) !,size(horizonset)-1
		horizon=horizonset(ih)
		if(horizon>nsample/2) cycle
		print *,"entering ", nsample, forq, horizon
		call prep
		call setlamfeas(0.002)
		call mdisp(thgrid.cvr.getbias(deltahats).cud.getbiasMCs(deltahats).cud.getrisk(deltahats))
		print *,"done with ", nsample, forq, horizon
		outpara=outpara.cud.[real(nsample), forq, real(horizon)]
		outbr=outbr.cud.lam
		outmf=outmf.cud.gmedfunc(:,1)
		call savemat("c:/dropbox/mystuff/medunbiased/revision/forq_lam.csv",outbr) 
		call savemat("c:/dropbox/mystuff/medunbiased/revision/forq_para.csv",outpara) 
		call savemat("c:/dropbox/mystuff/medunbiased/revision/forq_mf.csv",outmf) 
		call printtime
	enddo
	enddo
	enddo

	forq=0.05
	horizon=10
	nsample=50
	call prep
	call setlamfeas(0.002)
	call mdisp(thgrid.cvr.getbias(deltahats).cud.getbiasMCs(deltahats).cud.getrisk(deltahats))
	outbr=thgrid.cvr.getbias(deltahats).cud.getrisk(deltahats)
	
	call setnoconst()
	outbr=outbr.cud.getbias(deltahats).cud.getrisk(deltahats)
	deltahats=Sests
	call mdisp(thgrid.cvr.getbias(deltahats).cud.getbiasMCs(deltahats).cud.getrisk(deltahats))
	outbr=outbr.cud.getbias(deltahats).cud.getrisk(deltahats)
	call savemat("c:/dropbox/mystuff/medunbiased/revision/forq.dat",outbr) 

	outbr=getriskenv(0.002)
	call savemat("c:/dropbox/mystuff/medunbiased/revision/forq_env.dat",outbr) 
	
!dec$ endif	
!dec$ if (model==ARconst .and. biastype==MEAN)
	print *,"entering ARconst MEAN"
	nsample=50
	call prep
	call setfeasible(0.005)
	outbr=evalss(ssrhogrid)	
	nsample=200
	call prep
	call setfeasible(0.005)
	outbr=outbr.cud.evalss(ssrhogrid)	
	call savemat("c:/dropbox/mystuff/medunbiased/revision/ssARconst_mean.csv",outbr) 
	call mdisp(outbr)
	
	outbr=reshape(Ggrid,[1,nG])
	allocate(outpara(0,1))

	do ins=size(nsset),1,-1 !,size(nsset)-1
		nsample=nsset(ins)
		print *,"entering with nsample=",nsample
		call prep
		call setfeasible(0.005)
		print *,"done with nsample=",nsample
		outpara=outpara.cud.[real(nsample)]
		outbr=outbr.cud.lam
		call savemat("c:/dropbox/mystuff/medunbiased/revision/ARconst_mean_lam.csv",outbr) 
		call savemat("c:/dropbox/mystuff/medunbiased/revision/ARconst_mean_para.csv",outpara) 
		call printtime
	enddo	

	nsample=50
	
	call prep
	call setfeasible(0.005)
	outbr=thgrid.cvr.getbias(deltahats).cud.getrisk(deltahats)
	
	call setnoconst()
	outbr=outbr.cud.getbias(deltahats).cud.getrisk(deltahats)
	
	do l=1,nsim
		deltahats(l)=getOLS(Xs(:,l))
	enddo
	outbr=outbr.cud.getbias(deltahats).cud.getrisk(deltahats)
	
	call savemat("c:/dropbox/mystuff/medunbiased/revision/arconst_mean.dat",outbr)

	outbr=outbr(1:3,:)
	do l=1,nsim
		deltahats(l)=getOLS(Xs(:,l))
		deltahats(l)=(nsample*deltahats(l)+1)/(nsample-4)
	enddo
	outbr=outbr.cud.getbias(deltahats).cud.getrisk(deltahats)
	do l=1,nsim
		deltahats(l)=getWSest(Xs(:,l))
	enddo
	outbr=outbr.cud.getbias(deltahats).cud.getrisk(deltahats)
	do l=1,nsim
		deltahats(l)=getMLE(l)
	enddo
	outbr=outbr.cud.getbias(deltahats).cud.getrisk(deltahats)
	call savemat("c:/dropbox/mystuff/medunbiased/revision/arconst_mean_comp.dat",outbr) 
	
	outbr=quadenv(0.005)
	call savemat("c:/dropbox/mystuff/medunbiased/revision/arconst_mean_env.dat",outbr) 
!dec$ endif	
	
!dec$ if (model==ARnoconst .and. biastype==MEAN)
	print *,"entering ARnoconst MEAN"
	outbr=reshape(Ggrid,[1,nG])
	allocate(outpara(0,1))

	do ins=size(nsset),1,-1 !,size(nsset)-1
		nsample=nsset(ins)
		print *,"entering with nsample=",nsample
		call prep
		call setfeasible(0.005)
		print *,"done with nsample=",nsample
		outpara=outpara.cud.[real(nsample)]
		outbr=outbr.cud.lam
		call savemat("c:/dropbox/mystuff/medunbiased/revision/ARnoconst_mean_lam.csv",outbr) 
		call savemat("c:/dropbox/mystuff/medunbiased/revision/ARnoconst_mean_para.csv",outpara) 
		call printtime
	enddo	

	nsample=50

	call prep
	call setfeasible(0.005)
	outbr=thgrid.cvr.getbias(deltahats).cud.getrisk(deltahats)
	
	call setnoconst()
	outbr=outbr.cud.getbias(deltahats).cud.getrisk(deltahats)
	
	do l=1,nsim
		deltahats(l)=getOLS(Xs(:,l))
	enddo
	outbr=outbr.cud.getbias(deltahats).cud.getrisk(deltahats)
	
	call savemat("c:/dropbox/mystuff/medunbiased/revision/arnoconst_mean.dat",outbr)
	
	outbr=quadenv(0.005)
	call savemat("c:/dropbox/mystuff/medunbiased/revision/arnoconst_mean_env.dat",outbr) 
!dec$ endif	
end program