include 'c:/dropbox/mystuff/medunbiased/revision/fortran/compilerflags.f90'
!dec$ if (.not. model==FORQ)

module AR1noconst
	use modelpara
	implicit none
	integer, parameter	:: nX=2
	
	contains
	
	subroutine setX(rho,X)
        real    :: th,X(nX),J(nsample+1), rho
        integer :: i
        
       call rnnoa(J)
		J(1)=0
        do i=2,nsample+1
            J(i)=rho*J(i-1)+J(i)
        enddo
        J=J/sqrt(real(nsample))

		X(1)=sum(J(1:nsample)*(J(2:nsample+1)-J(1:nsample)))
        X(2)=sum(J(1:nsample)**2)/nsample
	end subroutine
	
	function getdens(rho,X) result(val)
        real    :: rho,th,X(nX),val
		th=nsample*(1-rho)
		val=-th*X(1)-.5*th**2*X(2)
	end function
	
	function getSWran(X) result(val)
        real    :: X(nX),val
		val=0
	end function
	
	function getSest(X) result(val)
        real    :: X(nX), val, chat, rhohat
		chat=-X(1)/X(2)
		rhohat=1-chat/nsample
!dec$ if (biastype==MEDIAN)
		rhohat=(nsample*rhohat)/(nsample-1)
!dec$ else
		rhohat=(nsample*rhohat)/(nsample-2)
!dec$ endif			
		val=rhohat
	end function
	
	function getOLS(X) result(val)
        real    :: X(nX), val, chat, rhohat
		chat=-X(1)/X(2)
		rhohat=1-chat/nsample
		val=rhohat
	end function

	elemental function astddev(x) result(val)
		real, intent(in)	:: x
		real	:: val
		val=sqrt((1-x**2)/nsample+8*(x+.0)**2/nsample**2)
	end function
	
end module

module AR1const
	use modelpara
	implicit none
	integer, parameter	:: nX=5
	
	contains
	
	subroutine setssX(rho,X,idgp)
		use rnchi_int
		real	:: rho,X(nX)
		integer	:: idgp,i
		real	:: J(-1001:nsample),s2
		if(idgp==1) then
			call rnchi(4.0,J)
			J=J-4
		else
			call rnun(J)
			J=merge(-1.0,1.0,J<0.5)
		endif
        do i=-1000,nsample
            J(i)=rho*J(i-1)+J(i)
		enddo
		J=(J-J(1))
        X(1)=sum(J(1:nsample-1)*(J(2:nsample)-J(1:nsample-1)))
        X(2)=sum(J(1:nsample-1)**2)/(nsample-1)
        X(3)=J(nsample)
        X(4)=sum(J(1:nsample-1))/(nsample-1)
		X(5)=sum((J(2:nsample)-J(1:nsample-1))**2)
	end subroutine
	
	subroutine setX(th,X)
        real    :: th,X(nX),J(nsample), rho
        integer :: i
		
        rho=th
        call rnnoa(J)
		if(rho<1) J(1)=J(1)/sqrt(1-rho**2)
        do i=2,nsample
            J(i)=rho*J(i-1)+J(i)
		enddo
		J=J-J(1)
        X(1)=sum(J(1:nsample-1)*(J(2:nsample)-J(1:nsample-1)))
        X(2)=sum(J(1:nsample-1)**2)/(nsample-1)
        X(3)=J(nsample)
        X(4)=sum(J(1:nsample-1))/(nsample-1)
		X(5)=sum((J(2:nsample)-J(1:nsample-1))**2)
	end subroutine
	
	function getdens(r,X) result(val)
        real    :: r,sS2,X(nX),val
		if(r==1) then
			val=-0.5*(nsample-1)*log(X(5))
		else
			sS2=2*(1-r)+(nsample-2)*(1-r)**2
			val=.5*log((1-r**2)/sS2)-0.5*(nsample-1)*log(X(5)+2*(1-r)*X(1)+(1-r)**2*X(2)*(nsample-1)-((1-r)*X(3)+(1-r)**2*X(4)*(nsample-1))**2/sS2)
		endif
	end function
	
	function getSWran(X) result(val)
        real    :: X(nX),val
		val=0
	end function
	
	function getSest(X) result(val)
        real    :: X(nX), val, chat, rhohat
		chat=-(X(1)-X(3)*X(4))/(X(2)-X(4)**2)
		rhohat=1-chat/(nsample-1)
!dec$ if (biastype==MEDIAN)
		rhohat=(nsample*rhohat+1)/(nsample-2)
!dec$ else
		rhohat=(nsample*rhohat+1)/(nsample-3)
!dec$ endif		
		val=rhohat
	end function
	
	function getWSest(X) result(val)
        real    :: X(nX), val, chat,rhohat
		chat=-(X(1)-X(3)*X(4)-X(2)+2*X(4)**2)/(X(2)-X(4)**2)
		val=1-chat/(nsample-1)
	end function

	function getOLS(X) result(val)
        real    :: X(nX), val, chat
		chat=-(X(1)-X(3)*X(4))/(X(2)-X(4)**2)
		val=1-chat/(nsample-1)
	end function
	
	elemental function astddev(x) result(val)
		real, intent(in)	:: x
		real	:: val
		val=sqrt((1-x**2)/nsample+8*(x+.4)**2/nsample**2)
	end function

end module
	
module MA
	use modelpara
	implicit none
	
	integer	:: nX
	
	contains
	
	subroutine setssX(rho,X,idgp)
		use rnchi_int
		integer	:: idgp
        real    :: rho,th,X(nsample)
        real    :: W(nsample)
        integer :: i
		if(idgp==1) then
			call rnchi(4.0,X)
			X=X-4
			call rnchi(4.0,W)
			W=W-4
		else
			call rnun(X)
			X=merge(-1.0,1.0,X<0.5)
			call rnun(W)
			W=merge(-1.0,1.0,W<0.5)
		endif
        do i=2,nsample
            W(i)=W(i-1)+W(i)
        enddo
		if(rho==0) then
			X=W
		else
			th=nsample*(1-rho)/sqrt(rho)
			X=X+(th/nsample)*W
		endif
        X=X-sum(X)/nsample
	end subroutine

	subroutine setX(rho,X)
        real    :: rho,th,X(nsample)
        real    :: W(nsample)
        integer :: i
		
        call rnnoa(X)
        call rnnoa(W)
        do i=2,nsample
            W(i)=W(i-1)+W(i)
        enddo
		if(rho==0) then
			X=W
		else
			th=nsample*(1-rho)/sqrt(rho)
			X=X+(th/nsample)*W
		endif
        X=X-sum(X)/nsample
	end subroutine
	
	function getdens(rho,Y) result(val)
        real    :: rho,Y(nsample),val
        real    :: r(nsample), x(nsample)
        integer :: i
		
		x(1)=Y(1)
        r(1)=1
        do i=2,nsample
            x(i)=rho*x(i-1)+Y(i)-Y(i-1)
            r(i)=rho*r(i-1)
        enddo
        x=x-r*sum(r*x)/sum(r**2)
		if(rho==1) then
			val=-.5*(nsample-1)*log(rho*sum(x**2))
		else
			val=0.5*log((nsample*(-1 + rho**2)*rho**(nsample-1))/(-1 + rho**(2*nsample)))-.5*(nsample-1)*log(sum(x**2))

		endif
	end function

	function getNyb(X) result(Nyb)
        real    :: X(nsample),W,Nyb
		integer	:: i
        W=0
        Nyb=0
        do i=1,nsample
            W=W+X(i)
            Nyb=Nyb+W**2
        enddo
        Nyb=-Nyb/sum(X**2)
	end function

	function getSWran(X) result(val)
        real    :: X(nsample),val
		val=0
	end function

	elemental function astddev(x) result(val)
		real, intent(in)	:: x
		real	:: val
		val=sqrt((1-x**2)/nsample+6.0*x**2/nsample**2)
	end function
end module

module model_common
	use globals
	use modelpara
!dec$ if (model==MA)	
	use MA
!dec$ elseif (model==ARnoconst)
	use AR1noconst
!dec$ elseif (model==ARconst)
	use AR1const
!dec$ endif		
	implicit none
	integer, parameter	:: prop_os=12
	
	contains

	subroutine setXp(X)
        real    :: X(nsample)
		integer	:: ivec(1),i
		
		call rnund(nprop+2*prop_os-2,ivec)
		i=ivec(1)-(prop_os-1)
		if(i<1) i=1
		if(i>nprop) i=nprop
		call setX(propgrid(i),X)
	end subroutine
	
	elemental function densF(x) result(val)
		real, intent(in)	:: x
		real	:: val
		val=1/(thmaxF-thminF)
	end function

end module

	
!dec$ if (biastype==mean)	

module model
	use model_common
!dec$ if (model==ARnoconst)
	use AR1noconst
!dec$ elseif(model==ARconst)
	use AR1const
!dec$ endif		

	implicit none
	
	real			:: fIS(nsim) ! for problem specific additional calculations, such as alternative estimators
	real, allocatable	:: Xs(:,:)

	contains
	
	subroutine prep
		integer	:: l,i,j,c,csw,cnosw,i0,minind
		real	:: X(nX)
		real	:: th,GQxw(nGQ,2)

		if(allocated(Xs)) deallocate(thgridfs,Xs)
		allocate(thgridfs(nthgrid,nsim),Xs(nX,nsim))
		
		call mkGQxw(GQxw)
!$omp parallel do private(X,i)
		do l=1,nsim
			call setXp(X)
			SWran(l)=getSWran(X)
			call setIS(X,fIS(l))
			do i=1,nG
!				call setG(i,intGs(:,i,l))
				intGs(:,i,l)=exp(getdens(Ggrid(i),X)-fIS(l))*[1.0,Ggrid(i),Ggrid(i)**2]/astddev(Ggrid(i))
			enddo
			do i=1,nenv
				intenvs(:,i,l)=exp(getdens(envgrid(i),X)-fIS(l))*[1.0,envgrid(i),envgrid(i)**2]/astddev(envgrid(i))**2
			enddo
			do i=1,nthgrid
				thgridfs(i,l)=exp(getdens(thgrid(i),X)-fIS(l))
				if(thgridfs(i,l)/=thgridfs(i,l)) then
					call mdisp([thgrid(i),X,getdens(thgrid(i),X)])
				endif
			enddo
			intFs(:,l)=0
			do i=1,nGQ
				th=thminF+(thmaxF-thminF)*GQxw(i,1)
				intFs(:,l)=intFs(:,l)+GQxw(i,2)*exp(getdens(th,X)-fIS(l))*[1.0,th,th**2]/astddev(th)**2
			enddo
			Sests(l)=getSest(X)
			Xs(:,l)=X
		enddo			
	end subroutine

	subroutine setIS(X,fIS)
		implicit none
        real    :: X(nX),fIS
		real	:: ldensp(nprop)
		integer	:: j
		
		do j=1,nprop
			ldensp(j)=getdens(propgrid(j),X)
		enddo
		ldensp(1)=ldensp(1)+log(real(prop_os))
		ldensp(nprop)=ldensp(nprop)+log(real(prop_os))
		fIS=logsumexp(ldensp)-log(nprop+2*prop_os-2.0)
	end subroutine

	function getbias(deltahats) result(val)
		implicit none
		real		:: val(nthgrid),deltahats(nsim)
		integer		:: l
		val=0
		do l=1,nsim
			val=val+thgridfs(:,l)*(deltahats(l)-thgrid)/astddev(thgrid)
		enddo
		val=val/nsim
	end function
	
	function getbiasMCs(deltahats) result(val)
		implicit none
		real		:: b(nthgrid), b2(nthgrid), c(nthgrid), val(nthgrid),deltahats(nsim)
		integer		:: l
		b=0;b2=0
		do l=1,nsim
			c=thgridfs(:,l)*(deltahats(l)-thgrid)/astddev(thgrid)
			b=b+c
			b2=b2+c**2
		enddo
		b=b/nsim;b2=b2/nsim
		val=sqrt((b2-b**2)/nsim)
	end function

	function getrisk(deltahats) result(val)
		implicit none
		real		:: val(nthgrid),deltahats(nsim)
		integer		:: l
		val=0
		do l=1,nsim
			val=val+thgridfs(:,l)*(deltahats(l)-thgrid)**2/astddev(thgrid)**2
		enddo
		val=val/nsim
	end function
	
	function getMLE(l) result(val)
        implicit none
		integer	:: l
        real    :: val
		integer	:: minind
		minind=maxloc(thgridfs(:,l),dim=1)
		if((minind==1).or.(minind==nthgrid)) then
			val=thgrid(minind)
		else
			val=getquadmin(thgrid(minind-1:minind+1),-thgridfs(minind-1:minind+1,l))
		endif
	end function


	function getlamplot(lam,thvec) result(val)
		implicit none
		real	:: lam(nG),thvec(:)
		real	:: val(size(thvec))
		real	:: yvec(size(thvec)),bscoef(nG)
		integer	:: j
		real    :: xknot(nG+3)=[Ggrid(1),Ggrid(1),Ggrid(1:nG-2),Ggrid(nG),Ggrid(nG),Ggrid(nG)]

		val=0
		do j=1,nG
			bscoef=0
			bscoef(j)=1.0
			call bs1gd(0,thvec,3,xknot,bscoef,yvec)
			yvec=(yvec*boole(thvec<=Ggrid(nG)))/bsitg(Ggrid(1),Ggrid(nG),3,xknot,nG,bscoef)
			val=val+lam(j)*yvec
		enddo
	end function

end module
!dec$ endif		

	
	
	
!dec$ if (biastype==median)	
module model
	use model_common
!dec$ if (model==MA)	
	use MA
!dec$ elseif (model==ARnoconst)
	use AR1noconst
!dec$ elseif (model==ARconst)
	use AR1const
!dec$ endif		

	implicit none
	
	real			:: fIS(nsim)
	real, allocatable	:: Xs(:,:)
	real			:: xvecs(nGQ,netas-1), yvecs(nGQ,nG,nsubdiv*4),yvecFs(nGQ,netas-1)
	integer			:: yvecind(nG)					! smallest index in long yvec of nG_i that is non-zero
	

	contains
	
	subroutine prep
		integer	:: l,i,j,c,csw,cnosw,i0,minind
		real	:: X(nX), chat, likvecs(nGQ,netas-1)
		
		if(.not. allocated(objs)) then
			allocate(thgridfs(nthgrid,nsim),consts(netas,nG,nsim),objs(netas,nsim),etagrids(netas,nsim))
			allocate(envobs(netas,nsim,nenv))
		endif
		if(allocated(Xs)) deallocate(Xs)
		allocate(Xs(nX,nsim))
		print *,"entering prep"

		call prepvecs()
!$omp parallel do private (i,minind,chat,X,likvecs)		
		do l=1,nsim
			call setXp(X)
			call setIS(X,fIS(l))
			call setlikvecs(X,likvecs,fIS(l))
			call setobj(objs(:,l),likvecs)
			do i=1,nenv
				envobs(:,l,i)=(exp(getdens(envgrid(i),X)-fIS(l))/astddev(envgrid(i)))*abs(etagrid-envgrid(i))
			enddo
			do i=1,nG
				call setconst(i,consts(:,i,l),likvecs)
			enddo
			do i=1,nthgrid
				thgridfs(i,l)=exp(getdens(thgrid(i),X)-fIS(l))
			enddo
!dec$ if (model==MA) 			
			minind=maxloc(thgridfs(:,l),dim=1)
			if((minind==1).or.(minind==nthgrid)) then
				chat=thgrid(minind)
			else
				chat=getquadmin(thgrid(minind-1:minind+1),-thgridfs(minind-1:minind+1,l))
			endif
			Sests(l)=chat/(1+1.0/nX)
			SWran(l)=0
!dec$ else 			
			Sests(l)=getSest(X)
			SWran(l)=0
!dec$ endif
			Xs(:,l)=X
		enddo
		print *,"done with prep"
	end subroutine
		
	subroutine prepvecs
        real        :: xknot(nG+3)=[Ggrid(1),Ggrid(1),Ggrid(1:nG-2),Ggrid(nG),Ggrid(nG),Ggrid(nG)]
        real        :: bscoef(nG), length
		
		real		:: yvec(nGQ),xvec(nGQ)
		integer		:: i,j,isub,c(nG),c0
		real		:: GQxw(nGQ,2)
		
		call mkGQxw(GQxw)
		yvecs=0
		
		c=0; c0=0
		do i=1,nG-1
			do isub=1,nsubdiv
				c0=c0+1
				length=(Ggrid(i+1)-Ggrid(i))/nsubdiv
				etagrid(c0)=Ggrid(i)+(isub-1)*length
				xvec=Ggrid(i)+(isub-1)*length+length*GQxw(:,1)
			
				yvecFs(:,c0)=length*GQxw(:,2)*rboole(thminF<=xvec.and.xvec<=thmaxF)/(astddev(xvec)*(thmaxF-thminF))
				xvecs(:,c0)=xvec
				do j=1,nG
					bscoef=0
					bscoef(j)=1.0
					call bs1gd(0,xvec,3,xknot,bscoef,yvec)
					if(.not.all(yvec==0.0)) then
						if(c(j)==0) yvecind(j)=c0
						c(j)=c(j)+1
						yvecs(:,j,c(j))=length*GQxw(:,2)*yvec/bsitg(Ggrid(1),Ggrid(nG),3,xknot,nG,bscoef)
					endif
				enddo
			enddo
		enddo
		etagrid(netas)=Ggrid(nG)
		etagrids=spread(etagrid,2,nsim)
	end subroutine
	
	subroutine setconst(iG,const,likvecs)
		real	:: const(netas),likvecs(nGQ,netas-1)
		integer	:: iG,i0,i,c
		
		i0=yvecind(iG)
		const(1:i0)=0
		c=min(4*nsubdiv,netas-i0)
		do i=1,c
			const(i0+i)=sum(yvecs(:,iG,i)*likvecs(:,i0+i-1))+const(i0+i-1)
		enddo
		do i=i0+c+1,netas
			const(i)=const(i0+c)
		enddo
		const=const-0.5*const(netas)
	end subroutine
	
	subroutine setobj(obj,likvecs) 
		real		:: obj(netas),likvecs(nGQ,netas-1)
		integer		:: i,j
		real		:: int(2)
		real		:: p(nGQ)
		
		obj=0
		do i=1,netas-1
			p=likvecs(:,i)*yvecFs(:,i)
			int=[sum(p),sum(p*xvecs(:,i))]
			do j=1,i
				obj(j)=obj(j)+int(2)-etagrid(j)*int(1)
			enddo
			do j=i+1,netas
				obj(j)=obj(j)-int(2)+etagrid(j)*int(1)
			enddo
		enddo	
	end subroutine

	subroutine setlikvecs(X,likvecs,fIS)
        real    :: X(:),likvecs(nGQ,netas-1),fIS
		integer	:: i,j
		do i=1,netas-1
			do j=1,nGQ
				likvecs(j,i)=exp(getdens(xvecs(j,i),X)-fIS)
			enddo
		enddo
	end subroutine

	subroutine setIS(X,fIS)
        real    :: X(nX),fIS
		real	:: ldensp(nprop)
		integer	:: i,j
		
		do j=1,nprop
			ldensp(j)=getdens(propgrid(j),X)
		enddo
		ldensp(1)=ldensp(1)+log(real(prop_os))
		ldensp(nprop)=ldensp(nprop)+log(real(prop_os))
		fIS=logsumexp(ldensp)-log(nprop+(2*prop_os-2.0))
	end subroutine
	
	function getbias(deltahats) result(val)
		real		:: val(nthgrid),deltahats(nsim)
		integer		:: l
		val=0
		do l=1,nsim
			val=val+thgridfs(:,l)*(rboole(deltahats(l)>thgrid)-0.5)
		enddo
		val=val/nsim
	end function
	
	function getbiasMCs(deltahats) result(val)
		real		:: b(nthgrid), b2(nthgrid), c(nthgrid), val(nthgrid),deltahats(nsim)
		integer		:: l
		b=0;b2=0
		do l=1,nsim
			c=thgridfs(:,l)*(rboole(deltahats(l)>thgrid)-0.5)
			b=b+c
			b2=b2+c**2
		enddo
		b=b/nsim;b2=b2/nsim
		val=sqrt((b2-b**2)/nsim)
	end function

	function getrisk(deltahats) result(val)
		real		:: val(nthgrid),deltahats(nsim)
		integer		:: l
		val=0
		do l=1,nsim
			val=val+thgridfs(:,l)*abs(deltahats(l)-thgrid)/astddev(thgrid)
		enddo
		val=val/nsim
	end function

	function getMLE(l) result(val)
		integer	:: l
        real    :: val
		integer	:: minind
		minind=maxloc(thgridfs(:,l),dim=1)
		if((minind==1).or.(minind==nthgrid)) then
			val=thgrid(minind)
		else
			val=getquadmin(thgrid(minind-1:minind+1),-thgridfs(minind-1:minind+1,l))
		endif
	end function

	function getlamplot(lam,thvec) result(val)
		real	:: lam(nG),thvec(:)
		real	:: val(size(thvec))
		real	:: yvec(size(thvec)),bscoef(nG)
		integer	:: j
		real    :: xknot(nG+3)=[Ggrid(1),Ggrid(1),Ggrid(1:nG-2),Ggrid(nG),Ggrid(nG),Ggrid(nG)]

		val=0
		do j=1,nG
			bscoef=0
			bscoef(j)=1.0
			call bs1gd(0,thvec,3,xknot,bscoef,yvec)
			yvec=(yvec*boole(thvec<=Ggrid(nG)))/bsitg(Ggrid(1),Ggrid(nG),3,xknot,nG,bscoef)
			val=val+lam(j)*yvec
		enddo
	end function

end module	
!dec$ endif		
	
!dec$ endif		
	
