% This is the main function to compute mean unbiased estimator for AR(1)
% with unknown constant mean. 

% Input : X : pre-scaled time series data, (Y1-Y1,Y2-Y1,...,YT-Y1)/sY where
% sY^2 = sum_i((Yi-Y1)^2), recorded by a row vector 
% Output : est : estimator
%          
% For the revised version of Mueller and Wang Unbiased Estimation paper
% Date: July 24 2018

function est = ARconst_mean_est(X)
%% Section 1 Load theta_G and Lagrangian Multipliers
% set path to include the file "ARconst_mean_lambda.mat" in the current path
T = length(X) ;
load('ARconst_mean_lam.csv') ;
load('ARconst_mean_para.csv') ;
% lamtable = table2array(ARconstmeanlam) ;
% paratable = table2array(ARconstmeanpara) ;
r_G = ARconst_mean_lam(1,:) ; % a grid on [-0.95,1]
Nr = length(r_G) ;
lam = ARconst_mean_lam(find(ARconst_mean_para==T)+1,:) ;  % Lagrangian multipliers corresponding to the theta_G
    r0 = 0.99 ; % this is for numerical purpose only
    s20 = sum((X(2:T) - r0*X(1:T-1)).^2)-...
               (1-r0).*(X(T)+(1-r0)*sum(X(2:T-1))).^2./(T*(1-r0)+2*r0)  ;
    f0 = 0.5*log((1+r0)./(T*(1-r0)+2*r0))-0.5*(T-1)*log(s20) ;
%% Section 2 Compute the density
    sS2_G = 2*(1-r_G)+(T-2)*(1-r_G).^2 ;
    s2hat_G = sum((kron(ones(1,Nr),X(2:T)) - kron(r_G,X(1:T-1))).^2,1)-...
               ((1-r_G)*X(T)+(1-r_G).^2*sum(X(2:T-1))).^2./sS2_G  ;
    f_G = 0.5*log((1-r_G.^2)./sS2_G)-0.5*(T-1)*log(s2hat_G) ;

%% Section 3 Compute Unbiased Estimator
% n_delta = 300 ;
% delta = linspace(-1.5,1.5,n_delta)' ; % candidates for estimator, you may enlarge the search space
nG = 1000 ;
[r_F,wGQ] = lgwt(nG,-0.95,1) ;
r_F = r_F' ;
    sS2_F = 2*(1-r_F)+(T-2)*(1-r_F).^2 ;
    s2hat_F = sum((kron(ones(1,nG),X(2:T)) - kron(r_F,X(1:T-1))).^2,1)-...
               ((1-r_F)*X(T)+(1-r_F).^2*sum(X(2:T-1))).^2./sS2_F  ;
    f_F = 0.5*log((1-r_F.^2)./sS2_F)-0.5*(T-1)*log(s2hat_F) ;

           int_rF = (r_F.*exp(f_F-f0)./((1-r_F.^2)/T+8*(r_F+0.4).^2/T^2))*wGQ/1.95 ;
           int_fF =      (exp(f_F-f0)./((1-r_F.^2)/T+8*(r_F+0.4).^2/T^2))*wGQ/1.95 ;
           int_fG =       exp(f_G-f0)./sqrt((1-r_G.^2)/T+8*(r_G+0.4).^2/T^2) ;
           est = (int_rF - lam*int_fG')/int_fF ;
      



    

end

