% This is the main function to compute mean unbiased estimator for AR(1)
% with unknown constant mean. 

% Input : X : pre-scaled time series data, (Y1-Y1,Y2-Y1,...,YT-Y1)/sY where
% sY^2 = sum_i((Yi-Y1)^2), recorded by a row vector 
% Output : est : estimator
%          
% For the revised version of Mueller and Wang Unbiased Estimation paper
% Date: July 24 2018

function [est,boundary] = ARconst_med_est(X)
%% Section 1 Load theta_G and Lagrangian Multipliers
% set path to include the file "ARconst_mean_lambda.mat" in the current path
T = length(X) ;
load('ARconst_median_lam.csv') ;
load('ARconst_median_para.csv') ;
% lamtable = table2array(ARconstmeanlam) ;
% paratable = table2array(ARconstmeanpara) ;
r_grid = ARconst_median_lam(1,:) ; % a grid on [-0.95,1]
Nr = length(r_grid) ;
r_spline = [r_grid(1),r_grid(1),r_grid(1:Nr-2),r_grid(Nr),r_grid(Nr),r_grid(Nr)] ;


lam = ARconst_median_lam(find(ARconst_median_para==T)+1,:) ;  % Lagrangian multipliers corresponding to the theta_G
r0 = 0.99 ;
    s20 = sum((X(2:T) - r0*X(1:T-1)).^2)-...
               (1-r0).*(X(T)+(1-r0)*sum(X(2:T-1))).^2./(T*(1-r0)+2*r0)  ;
    f0 = 0.5*log((1+r0)./(T*(1-r0)+2*r0))-0.5*(T-1)*log(s20) ;
    

%% Section 2 Compute the density
nG = 500 ;
[r_G,wGQG] = lgwt(nG,-0.95,1) ;
r_G = flipud(r_G) ; wGQG = flipud(wGQG) ;
r_G = r_G' ;

    sS2_G = 2*(1-r_G)+(T-2)*(1-r_G).^2 ;
    s2hat_G = sum((kron(ones(1,nG),X(2:T)) - kron(r_G,X(1:T-1))).^2,1)-...
               ((1-r_G)*X(T)+(1-r_G).^2*sum(X(2:T-1))).^2./sS2_G  ;
    f_G = 0.5*log((1-r_G.^2)./sS2_G)-0.5*(T-1)*log(s2hat_G) ;

    B = bspline_basismatrix(3,r_spline,r_G') ;
%    B = B' ;
    B = (B./kron(sum(B,2),ones(1,Nr)))'*Nr ; 

%% Section 3 Compute Unbiased Estimator
n_delta = 100 ;
delta = linspace(-0.95,1,n_delta)' ; % candidates for estimator, you may enlarge the search space
nF = 200 ;
[r_F,wGQF] = lgwt(nF,-0.95,1) ;
r_F = flipud(r_F) ; wGQF = flipud(wGQF) ;
r_F = r_F' ;
    sS2_F = 2*(1-r_F)+(T-2)*(1-r_F).^2 ;
    s2hat_F = sum((kron(ones(1,nF),X(2:T)) - kron(r_F,X(1:T-1))).^2,1)-...
               ((1-r_F)*X(T)+(1-r_F).^2*sum(X(2:T-1))).^2./sS2_F  ;
    f_F = 0.5*log((1-r_F.^2)./sS2_F)-0.5*(T-1)*log(s2hat_F) ;           
    loss = abs(bsxfun(@minus,delta,r_F))./ sqrt(kron(ones(n_delta,1),(1-r_F.^2)/T+8*(r_F+0.4).^2/T^2)) ; % normalizing the risk 
    c = zeros(n_delta,Nr) ;
%    const = ((bsxfun(@minus,delta,r_grid)>=0)-1/2).*kron(exp(f_grid-f0),ones(n_delta,1)) ;
    for i = 1:Nr                              
        c(:,i) = sum(((bsxfun(@minus,delta,r_G)>=0)-1/2).*kron(exp(f_G-f0).*B(i,:).*wGQG',ones(n_delta,1)),2)/sum(B(i,:).*wGQG') ;     
    end
%        L = (loss.*kron(exp(f_F-f0),ones(n_delta,1)))*wGQF/1.95 + sum(kron(lam,ones(n_delta,1)).*const,2) ;         
        L = (loss.*kron(exp(f_F-f0),ones(n_delta,1)))*wGQF/1.95 + sum(kron(lam,ones(n_delta,1)).*c,2) ;
        [~,Ind] = min(L) ;

        if Ind ==1 || Ind == length(delta)           
           est = delta(Ind) ;  
           boundary = (Ind==1)-(Ind==n_delta) ;
        else
            p = polyfit(delta(Ind-1:Ind+1),L(Ind-1:Ind+1),2) ;
            est = -1/2*p(2)/p(1)    ;
            boundary = 0 ;
        end
        load('ARconst_median_mf.csv') ;
        r_value = ARconst_median_mf(1,:) ;
        med_fun = ARconst_median_mf(find(ARconst_median_para==T)+1,:) ;
        
        if est<max(med_fun) && est>min(med_fun)
           est = interp1(med_fun,r_value,est) ; % inverse the median function
        end

    

end

