% This is the main function to compute median unbiased estimator for degree
% of time variation, or cofficient of MA(1) with unknown constant mean as discussed in the paper. 
% This version imposes unit variance of each
% observation so that data should be pre-scaled by standard deviation.
% Input : X : pre-scaled time series data, with the latest in the end
% Output : est : estimator
%          sw  : = 1 if switch to standard estimator; = 0 otherwise
% Note that, the lagrangian multipliers are associated with values on
% theta_G grid, where unbiasedness is imposed.
function [est,boundary] = MA_est(X) 
%% Section 1 Load eta and Lagrangian
load('MA_para.csv') ;
load('MA_lam.csv')
T = length(X) ;
r_grid = MA_lam(1,:) ; % a grid on [-0.95,1]
Nr = length(r_grid) ;
r_spline = [r_grid(1),r_grid(1),r_grid(1:end-2),r_grid(Nr),r_grid(Nr),r_grid(Nr)] ;

lam = MA_lam(find(MA_para==T)+1,:) ;  % Lagrangian multipliers corresponding to the theta_G
%% Section 2 Compute MLE

r0 = 0.99 ;
nF = 200 ;
[r_F,wGQF] = lgwt(nF,0,1) ;
r_F = flipud(r_F) ; wGQF = flipud(wGQF) ;
r_F = r_F' ;
f_F = getdens(r_F,X) ;

nG = 500 ;
[r_G,wGQG] = lgwt(nG,0,1) ;
r_G = r_G' ;
r_G = flipud(r_G) ; wGQG = flipud(wGQG) ;
f_G = getdens(r_G,X) ;
f0 = getdens(r0,X) ;

% f_grid = getdens(r_grid,X) ;


   B = bspline_basismatrix(3,r_spline,r_G') ;
   B = (B./kron(sum(B,2),ones(1,Nr)))' ; 
%% Section 3 Construct Estimator by Grid Search
n_delta = 200 ;
delta = linspace(0,1,n_delta)' ; % candidates for estimator, you may enlarge the search space


    loss = abs(bsxfun(@minus,delta,r_F))./ sqrt(kron(ones(n_delta,1),(1-r_F.^2)/T+6*(r_F).^2/T^2)) ; % normalizing the risk 
    c = zeros(n_delta,Nr) ;        
    for i = 1:Nr                              
        c(:,i) = sum(((bsxfun(@minus,delta,r_G)>0)-1/2).*kron(exp(f_G-f0).*B(i,:).*wGQG',ones(n_delta,1)),2)/(B(i,:)*wGQG) ;     
    end
%    const = ((bsxfun(@minus,delta,r_grid)>0)-1/2).*kron(exp(f_grid-f0),ones(n_delta,1)) ;
        
     L = (loss.*kron(exp(f_F-f0),ones(n_delta,1)))*wGQF/1 + sum(kron(lam,ones(n_delta,1)).*c,2) ;  
              

        [~,Ind] = min(L) ;
        if Ind ==1 || Ind == length(delta)           
           est = delta(Ind) ;    
           boundary = (Ind==1)-(Ind==n_delta) ;
        else
            p = polyfit(delta(Ind-1:Ind+1),L(Ind-1:Ind+1),2) ;
            est = -1/2*p(2)/p(1)    ;
            boundary = 0 ;
        end
        load('MA_mf.csv')
        med_fun = MA_mf(find(MA_para==T)+1,:) ;
        
        % inverse the median function, the first 9 values in the median function are all 0, so we may start from the ninth to inverse
        if est<max(med_fun)&&est>min(med_fun)
           est = interp1(med_fun,MA_mf(1,:),est) ; 
        end

    