% This is the main function to compute quantile unbiased forecast for AR(1)

% Input : X : pre-scaled time series data, (Y1-Y1,Y2-Y1,...,YT-Y1)/sY where
% sY^2 = sum_i((Yi-Y1)^2), recorded by a *column* vector
%         alpha : alpha-quantile 
%         tao : T+tao periods ahead forecast
% Output : est : the forecast value
%          
% For the revised version of Mueller and Wang Unbiased Estimation paper
% Date: July 24 2018
function [est,boundary] = forq_est(X,alpha,tao)
%% Section 1 Load gamma and Lagrangian

T = length(X) ;
load('forq_lam.csv') ;
load('forq_para.csv') ;
r_G = forq_lam(1,:) ; % a grid on [-0.95,1]
Nr = length(r_G) ;
lam = forq_lam(find(ismember(forq_para,[T,alpha,tao],'rows'))+1,:) ; % find the corresponding lambda
%% Section 2 Compute Sufficient Statistic

    w = [kron(ones(T-1,1),(1-r_G).*(1-r_G.^tao)./(T*(1-r_G)+2*r_G));
        (1+(r_G.^tao).*(T*(1-r_G)-1+2*r_G))./(T*(1-r_G)+2*r_G)] ;
    wX = X'*w ;
    sigd2 = ((1-r_G)*T+1+3*r_G-2*(1+r_G).*(r_G.^tao)-(1-r_G)*(T-1).*(r_G.^(2*tao)))./...
        ((1-r_G.^2).*(T*(1-r_G)+2*r_G)) ;
    sigd = sqrt(sigd2) ;
    r0 = 0.99 ;
    s20 = sum((X(2:T) - r0*X(1:T-1)).^2)-...
               (1-r0).*(X(T)+(1-r0)*sum(X(2:T-1))).^2./(T*(1-r0)+2*r0)  ;
    f0 = 0.5*log((1+r0)./(T*(1-r0)+2*r0))-0.5*(T-1)*log(s20) ;
    s2hat = sum((kron(ones(1,Nr),X(2:T)) - kron(r_G,X(1:T-1))).^2,1)-...
               (1-r_G).*(X(T)+(1-r_G)*sum(X(2:T-1))).^2./(T*(1-r_G)+2*r_G)  ;

    f_G = 0.5*log((1+r_G)./(T*(1-r_G)+2*r_G))-0.5*(T-1)*log(s2hat) ;
    
    
    

    nF = 200 ;
    [r_F,wGQF] = lgwt(nF,-0.95,1) ;
    r_F = flipud(r_F) ; wGQF = flipud(wGQF) ;
    r_F = r_F' ;
    w_F = [kron(ones(T-1,1),(1-r_F).*(1-r_F.^tao)./(T*(1-r_F)+2*r_F));
        (1+(r_F.^tao).*(T*(1-r_F)-1+2*r_F))./(T*(1-r_F)+2*r_F)] ;
    wX_F = X'*w_F ;
    sigd2_F = ((1-r_F)*T+1+3*r_F-2*(1+r_F).*(r_F.^tao)-(1-r_F)*(T-1).*(r_F.^(2*tao)))./...
        ((1-r_F.^2).*(T*(1-r_F)+2*r_F)) ;
    sigd_F = sqrt(sigd2_F) ;
    s2hat_F = sum((kron(ones(1,nF),X(2:T)) - kron(r_F,X(1:T-1))).^2,1)-...
               (1-r_F).*(X(T)+(1-r_F)*sum(X(2:T-1))).^2./(T*(1-r_F)+2*r_F)  ;
    f_F = 0.5*log((1+r_F)./(T*(1-r_F)+2*r_F))-0.5*(T-1)*log(s2hat_F) ;
%% Section 4 Construct Estimator by Grid Search

n_delta = 1000 ;
delta = linspace(-7,4,n_delta)' ; % candidates for estimator
% L = nan(1,length(delta)) ;
c0_G = sigd.*sqrt(s2hat) ;
c0_F = sigd_F.*sqrt(s2hat_F) ;

  
            v0_G = bsxfun(@minus,delta,wX)./kron(ones(n_delta,1),c0_G) ;
            v0_F = bsxfun(@minus,delta,wX_F)./kron(ones(n_delta,1),c0_F) ;
            
            
            loss = kron(sigd_F,ones(n_delta,1)).*...
                (tpdf(v0_F*sqrt(T-2),T-2)/sqrt(T-2)+v0_F.*mytdf(sqrt(T)*v0_F,T)-v0_F*alpha) ./...
                  kron(ones(n_delta,1),sqrt((1-r_F.^(2*tao))./(1-r_F.^2))) ; % normalizing the risk 
            c = mytdf(v0_G*sqrt(T-1),T-1)-alpha ;
            const = c.*kron(exp(f_G-f0),ones(n_delta,1)) ;
            obj = (loss.*kron(exp(f_F-f0),ones(n_delta,1)))*wGQF/1.95 ;
            matmul = sum(kron(lam.*exp(f_G-f0),ones(n_delta,1)).*c,2) ;
            L = obj + matmul ;          

        [~,Ind] = min(L) ;
        if Ind ==1 || Ind == length(delta)           
           est = delta(Ind) ;  
           boundary = (Ind==1)-(Ind==n_delta) ;
        else
            p = polyfit(delta(Ind-1:Ind+1),L(Ind-1:Ind+1),2) ;
            est = -1/2*p(2)/p(1)    ;
            boundary = 0 ;
        end

end
        