%% simulate data and construct estimator in Mueller and Wang (2018)
% problem: 
% 1 = AR(1) mean unbias with known constant
% 2 = AR(1) mean unbias with unknown constant
% 3 = AR(1) median unbias with known constant 
% 4 = AR(1) median unbias with unknown constant 
% 5 = MA(1) 
% 6 = Quantile Forecast
clear ; clc ;
rng('default')
rng(1) ;
problem = 4 ; 
nsim = 10000 ; % simulation draws
T = 50 ; % sample size
alpha = 0.05 ; % level of significance
tao = 10 ; % forecast horizon in problem 6
rho = 0.99 ; % AR(1) coefficient
known_mean_var = 0 ; % 1 if we know mean is 0 and variance is 1
%% DGP with mean 0 and variance 1
if known_mean_var == 1
    y0 = 0 ; y = zeros(nsim,T) ;
    for t = 1:T
        if t == 1
            y(:,t) = rho*y0 + randn(nsim,1) ;
        else
            y(:,t) = rho*y(:,t-1) + randn(nsim,1) ;
        end
    end
else    
%% DGP with unknown mean and variance, stationary initial draw  
%    y = chi2rnd(4,nsim,1001+T+tao)-4 ; % Chi-square dist with df=4
    y = 2*(randn(nsim,1001+T+tao)>0)-1 ; % Bernoulli
%    y = randn(nsim,1001+T+tao) ; % Normal
    for t = 2:1001+T+tao
        y(:,t) = rho.*y(:,t-1) + y(:,t) ; 
    end
    y = y(:,1001:1001+T-1+tao) ; % drop the initial 1000 draws
    
end       
    
    Xd = y(:,1:T) - kron(y(:,1),ones(1,T)) ;
    s = sqrt(sum(Xd.^2,2)/T) ;
    Xstar = Xd./kron(ones(1,T),s) ; % maximum invariant statistics
    est = nan(nsim,1) ;
%% AR(1) coefficient Mean Unbiased, known mean 0 and variance 1
if problem == 1   
    parfor t = 1:nsim
        est(t) = ARnoconst_mean_est(y(t,:)') ;
    end
  
    bias = 1000*mean(est-rho) 
    MSE = 1000*mean((est-rho).^2) 
  
end

%% AR(1) coefficient Mean Unbiased, unknown mean and variance
if problem == 2   
    parfor t = 1:nsim
        est(t) = ARconst_mean_est(Xstar(t,:)') ;
    end
  
    bias = 1000*mean(est-rho) 
    MSE = 1000*mean((est-rho).^2) 

end
%% AR(1) coefficient Median Unbiased, known mean 0 and variance 1
if problem == 3   
    parfor t = 1:nsim
        est(t) = ARnoconst_med_est(y(t,:)') ;
    end 
    med_bias = 100*(mean(est>rho)-1/2) 
    MAD = 100*mean(abs(est-rho)) 
    
end
%% AR(1) coefficient Median Unbiased, unknown mean and variance
if problem == 4   
    parfor t = 1:nsim
        est(t) = ARconst_med_est(Xstar(t,:)') ;
    end 
    med_bias = 100*(mean(est>rho)-1/2) 
    MAD = 100*mean(abs(est-rho)) 
    
end
%% MA(1) 
if problem == 5
    eta = 0.99 ; % the MA(1) coefficient
    phe = (1-eta)/sqrt(eta) ;
    eps = chi2rnd(4,nsim,T)-4 ;
    u = chi2rnd(4,nsim,T)-4 ;
    y = phe*cumsum(eps,2)+u ;
    Xd = y - kron(y(:,1),ones(1,T)) ;
    s = sqrt(sum(Xd.^2,2)) ;
    Xstar = Xd./kron(ones(1,T),s) ;
    parfor t = 1:nsim
        est(t) = MA_est(Xstar(t,:)') ;
    end
  
    bias = 100*(mean((est>eta))-0.5) 
    MSE = 100*mean(abs(est-eta)) 
end
%% Quantile Forecast
if problem == 6   
    parfor t = 1:nsim
        est(t) = forq_est(Xstar(t,:)',alpha,tao) ;
    end  
    q_bias = 100*(mean( (y(:,end)-y(:,1)<est.*s) )-alpha ) 
    q_risk = 100*mean( abs(y(:,end)-y(:,1)-est.*s).*abs((y(:,end)<=y(:,1)+est.*s)-alpha) ) 
   
end
