function output  = GMM_loss_fun(r, d, param, v, beta01, beta10, beta11, beta02, beta20, weight_matrix,...
                                std_01, std_10, std_11, std_02, std_20)
    %%%% This function generates the loss function in (28) for GMM estimation without the Feller constraint %%%%
    %%%% Input %%%%
    % r: Vector of interest rate
    % d: Vector of dividend
    % param: Vector of model parameters [kappa, alpha, xi, rho]
    % v: Vector of spot volatilities
    % beta01: Data beta_01
    % beta10: Data beta_10
    % beta11: Data beta_11
    % beta02: Data beta_02
    % beta20: Data beta_20
    % weight_matrix: The 5*5 weight matrix W_n in (28)
    % std_01: Standard derivation of data beta_01
    % std_10: Standard derivation of data beta_10
    % std_11: Standard derivation of data beta_11
    % std_02: Standard derivation of data beta_02
    % std_20: Standard derivation of data beta_20
    
    mag =  moment_fun('over_gn', r, d, param, v, beta01, beta10, beta11, beta02, beta20, ...
                      std_01, std_10, std_11, std_02, std_20); % g_n
    output = mag'*weight_matrix*mag; % See the right hand side of equation (28)
end