function output = moment_derivatives(type, r, d, param, v, std_01, std_10, std_11, std_02, std_20)
    %%%% This function returns the derivatives of the moment functions
    %%%% Input %%%%
    % type: Character 'exact' or 'over'
    % r: A scalar interest rate
    % d: A scalar of dividend
    % param: Vector of model parameters [kappa, alpha, xi, rho]
    % v: A scalar spot volatility
    % std_01: Standard derivation of data beta_01
    % std_10: Standard derivation of data beta_10
    % std_11: Standard derivation of data beta_11
    % std_02: Standard derivation of data beta_02
    % std_20: Standard derivation of data beta_20
    %%%% Output %%%%
    % output: The summand of \hat{G} in equation (C1)
    
    kappa = param(1);
    alpha = param(2);
    xi = param(3);
    rho = param(4);
    deri_01 = 1/std_01*[0,0,-(1/4).*(v.^2).^(-1/2).*rho,-(1/4).*(v.^2).^(-1/2).*xi];
    deri_10 = 1/std_10*[-(1/96).*(v.^2).^(-1/2).*((-24).*v.^2+24.*alpha),-(1/4).*(v.^2).^(-1/2).*kappa,-(1/96).*(v.^2).^(-1/2).*((-8).*xi+24.*d.*rho+(-24).*r.*rho+12.*v.^2.*rho+2.*xi.*rho.^2),-(1/96).*(v.^2).^(-1/2).*(24.*d.*xi+(-24).*r.*xi+12.*v.^2.*xi+2.*xi.^2.*rho)];
    deri_02 = 1/std_02*[0,0,-(1/48).*(v.^2).^(-3/2).*(4.*xi+(-10).*xi.*rho.^2),-(-5/24).*(v.^2).^(-3/2).*xi.^2.*rho];
    deri_11 = 1/std_11*[-(1/384).*(v.^2).^(-3/2).*(8.*v.^2.*xi.*rho+(-40).*alpha.*xi.*rho),-(-5/48).*(v.^2).^(-3/2).*kappa.*xi.*rho,-(1/384).*(v.^2).^(-3/2).*(64.*d.*xi+(-64).*r.*xi+8.*v.^2.*kappa.*rho+(-40).*alpha.*kappa.*rho+36.*xi.^2.*rho+(-160).*d.*xi.*rho.^2+160.*r.*xi.*rho.^2+(-8).*v.^2.*xi.*rho.^2+(-27).*xi.^2.*rho.^3),-(1/384).*(v.^2).^(-3/2).*(8.*v.^2.*kappa.*xi+(-40).*alpha.*kappa.*xi+12.*xi.^3+(-160).*d.*xi.^2.*rho+160.*r.*xi.^2.*rho+(-8).*v.^2.*xi.^2.*rho+(-27).*xi.^3.*rho.^2)];
    deri_20 = 1/std_20*[(-1/30720).*(v.^2).^(-3/2).*(960.*v.^6+1920.*r.*v.^2.*(4.*v.^2+(-4).*alpha)+(-960).*v.^4.*alpha+(-480).*d.^2.*((-8).*v.^2+8.*alpha)+(-480).*r.^2.*((-8).*v.^2+8.*alpha)+40.*(4.*d.^2+(2.*r+v.^2).^2+d.*((-8).*r+4.*v.^2)).*((-24).*v.^2+24.*alpha)+3200.*v.^4.*kappa+(-1280).*v.^2.*alpha.*kappa+(-1920).*alpha.^2.*kappa+320.*v.^2.*xi.^2+640.*alpha.*xi.^2+(-1600).*v.^4.*xi.*rho+320.*v.^2.*alpha.*xi.*rho+(-240).*v.^2.*xi.^2.*rho.^2+(-400).*alpha.*xi.^2.*rho.^2+80.*r.*((-48).*v.^4+40.*alpha.*xi.*rho+2.*v.^2.*(24.*alpha+(-4).*xi.*rho))+80.*d.*(48.*v.^4+12.*r.*((-8).*v.^2+8.*alpha)+(-40).*alpha.*xi.*rho+2.*v.^2.*((-24).*alpha+4.*xi.*rho))),(-1/30720).*(v.^2).^(-3/2).*((-3840).*d.^2.*kappa+(-3840).*r.^2.*kappa+(-7680).*r.*v.^2.*kappa+(-960).*v.^4.*kappa+960.*(4.*d.^2+(2.*r+v.^2).^2+d.*((-8).*r+4.*v.^2)).*kappa+(-640).*v.^2.*kappa.^2+(-1920).*alpha.*kappa.^2+640.*kappa.*xi.^2+320.*v.^2.*kappa.*xi.*rho+(-400).*kappa.*xi.^2.*rho.^2+80.*d.*(96.*r.*kappa+(-48).*v.^2.*kappa+(-40).*kappa.*xi.*rho)+80.*r.*(48.*v.^2.*kappa+40.*kappa.*xi.*rho)),(-1/30720).*(v.^2).^(-3/2).*((-320).*v.^4.*xi+640.*v.^2.*kappa.*xi+1280.*alpha.*kappa.*xi+(-64).*xi.^3+(-3840).*d.^3.*rho+3840.*r.^3.*rho+(-480).*v.^6.*rho+(-1600).*v.^4.*kappa.*rho+320.*v.^2.*alpha.*kappa.*rho+(-480).*v.^2.*xi.^2.*rho+1200.*v.^4.*xi.*rho.^2+(-480).*v.^2.*kappa.*xi.*rho.^2+(-800).*alpha.*kappa.*xi.*rho.^2+(-352).*xi.^3.*rho.^2+360.*v.^2.*xi.^2.*rho.^3+236.*xi.^3.*rho.^4+40.*(4.*d.^2+(2.*r+v.^2).^2+d.*((-8).*r+4.*v.^2)).*((-8).*xi+24.*d.*rho+(-24).*r.*rho+12.*v.^2.*rho+2.*xi.*rho.^2)+(-480).*r.^2.*((-8).*xi+12.*v.^2.*rho+14.*xi.*rho.^2)+(-480).*d.^2.*((-8).*xi+(-24).*r.*rho+12.*v.^2.*rho+14.*xi.*rho.^2)+320.*r.*v.^2.*((-12).*v.^2.*rho+6.*(2.*xi+2.*v.^2.*rho)+(-6).*rho.*(4.*d+(-4).*r+2.*v.^2+xi.*rho)+4.*xi.*((-1)+rho.^2))+80.*r.*(36.*v.^4.*rho+40.*alpha.*kappa.*rho+(-36).*xi.^2.*rho+27.*xi.^2.*rho.^3+2.*v.^2.*((-8).*xi+(-4).*kappa.*rho+6.*xi.*rho.^2))+80.*d.*((-144).*r.^2.*rho+(-36).*v.^4.*rho+(-40).*alpha.*kappa.*rho+36.*xi.^2.*rho+(-27).*xi.^2.*rho.^3+2.*v.^2.*(8.*xi+4.*kappa.*rho+(-6).*xi.*rho.^2)+12.*r.*((-8).*xi+12.*v.^2.*rho+14.*xi.*rho.^2))),(-1/30720).*(v.^2).^(-3/2).*((-3840).*d.^3.*xi+3840.*r.^3.*xi+(-480).*v.^6.*xi+(-1600).*v.^4.*kappa.*xi+320.*v.^2.*alpha.*kappa.*xi+(-160).*v.^2.*xi.^3+1200.*v.^4.*xi.^2.*rho+(-480).*v.^2.*kappa.*xi.^2.*rho+(-800).*alpha.*kappa.*xi.^2.*rho+(-176).*xi.^4.*rho+360.*v.^2.*xi.^3.*rho.^2+236.*xi.^4.*rho.^3+40.*(4.*d.^2+(2.*r+v.^2).^2+d.*((-8).*r+4.*v.^2)).*(24.*d.*xi+(-24).*r.*xi+12.*v.^2.*xi+2.*xi.^2.*rho)+(-480).*r.^2.*(12.*v.^2.*xi+14.*xi.^2.*rho)+(-480).*d.^2.*((-24).*r.*xi+12.*v.^2.*xi+14.*xi.^2.*rho)+320.*r.*v.^2.*(4.*xi.^2.*rho+(-6).*xi.*(4.*d+(-4).*r+2.*v.^2+xi.*rho))+80.*r.*(36.*v.^4.*xi+40.*alpha.*kappa.*xi+(-12).*xi.^3+27.*xi.^3.*rho.^2+2.*v.^2.*((-4).*kappa.*xi+6.*xi.^2.*rho))+80.*d.*((-144).*r.^2.*xi+(-36).*v.^4.*xi+(-40).*alpha.*kappa.*xi+12.*xi.^3+(-27).*xi.^3.*rho.^2+2.*v.^2.*(4.*kappa.*xi+(-6).*xi.^2.*rho)+12.*r.*(12.*v.^2.*xi+14.*xi.^2.*rho)))];
    
    type = string(type);
    
    if type == 'exact'
        output = [deri_01', deri_10', deri_02', deri_11'];
    end
    if type == 'over'
        output = [deri_01', deri_10', deri_02', deri_11', deri_20'];
    end    
end