function output = moment_fun(type, r, d, param, v, beta01, beta10, beta11, beta02, beta20, ...
                                std_01, std_10, std_11, std_02, std_20)
    %%%% Input %%%%
    % type: Character 'exact_gn', 'exact_g', 'over_gn', or 'over_g'
    % r: Vector of interest rate
    % d: Vector of dividend
    % param: Vector of model parameters [kappa, alpha, xi, rho]
    % v: Vector of spot volatilities
    % beta01: Data beta_01
    % beta10: Data beta_10
    % beta11: Data beta_11
    % beta02: Data beta_02
    % beta20: Data beta_20
    % std_01: Standard derivation of data beta_01
    % std_10: Standard derivation of data beta_10
    % std_11: Standard derivation of data beta_11
    % std_02: Standard derivation of data beta_02
    % std_20: Standard derivation of data beta_20
    % std_01, std_10, std_11, std_02, and std_21 are used to standardize the corresponding moment functions
    %%%% Output %%%%
    % output: The vector g_n if type == 'exact_gn'
    % output: The matrix g if type == 'exact_g'
    % output: The vector g_n if type == 'over_gn'
    % output: The matrix g if type == 'over_g'
    
    % Standardize the moment functions
    g1 = (beta01 - sigma_01(r, d, param, v))/std_01;
    g2 = (beta10 - sigma_10(r, d, param, v))/std_10;
    g3 = (beta02 - sigma_02(r, d, param, v))/std_02;
    g4 = (beta11 - sigma_11(r, d, param, v))/std_11;
    g5 = (beta20 - sigma_20(r, d, param, v))/std_20;
    
    type = string(type);
    
    % Various outputs
    if type == 'exact_gn'
        g = [g1; g2; g3; g4];
        output = sum(g, 2)/size(g, 2);
    end
    if type == 'exact_g'
        output = [g1; g2; g3; g4];
    end
    if type == 'over_gn'
        gAverage=[g1; g2; g3; g4; g5]; 
        output = sum(gAverage, 2)/size(gAverage, 2);
    end
    if type == 'over_g'
        output = [g1; g2; g3; g4; g5];
    end
end